// Main server that runs all backend services
// Equipment management - GlobalEquipmentJsonData.js (Port 5001)
// Document management - GlobalEDocumentsHandle3.js (Port 5002)
// Admin Users management - GlobalAdminUsersHandle.js (Port 5003)
// DVIR Handler - GlobalDVIRhandler.js (Port 5006)

console.log('\n🚀 Starting Titan Drilling Backend Services...\n');

// Set environment variables for ports
process.env.EQUIPMENT_PORT = '5001';
process.env.DOCUMENTS_PORT = '5002';
process.env.ADMIN_USERS_PORT = '5003';
process.env.INSPECTION_PORT = '5004';
process.env.JOBCARD_PORT = '5005';
process.env.DVIR_PORT = '5006';





// Start all three servers
console.log('📊 Starting Equipment Server on port 5001...');
require('./GlobalEquipmentJsonData');

console.log('📁 Starting Documents Server on port 5002...');
require('./GlobalEDocumentsHandle3');

console.log('👥 Starting Admin Users Server on port 5003...');
require('./GlobalAdminUsersHandle');

console.log('🔍 Starting Inspection Handler Server on port 5004...');
require('./GlobalInspectionHandler');




console.log('🔧 Starting Job Card Reports Server on port 5005...');
require('./GlobalJobcardReports');

console.log('🔒 Starting DVIR Handler Server on port 5006...');
require('./GlobalDVIRhandler');

console.log('\n✅ All servers initialized!\n');
console.log('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━');
console.log('📡 Equipment API: https://api.titandrillingzm.com:5001');
console.log('📡 Documents API: https://api.titandrillingzm.com:5002');
console.log('📡 Admin Users API: https://api.titandrillingzm.com:5003');
console.log('📡 Inspection API: https://api.titandrillingzm.com:5004');
console.log('📡 Job Card API: https://api.titandrillingzm.com:5005');
console.log('📡 DVIR Handler API: https://api.titandrillingzm.com:5006');
console.log('━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n');