const mongoose = require('mongoose');

   const DocumentSchema = new mongoose.Schema({
     id: { type: String, required: true, unique: true },
     uid: { type: String, required: true, index: true },
     documentType: { type: String, required: true, index: true },
     type: { type: String, required: true },
     description: { type: String, required: true },
     subfolderName: { type: String, required: true, index: true },
     equipment: { type: Object },
     fileId: { type: mongoose.Schema.Types.ObjectId, ref: 'documents.files', required: true },
     fileType: { type: String, required: true },
     fileName: { type: String, required: true },
     fileSize: { type: Number },
     createdAt: { type: Date, default: Date.now, index: true },
     updatedAt: { type: Date, default: Date.now },
     databaseName: { type: String, default: 'titan_drilling' },
   }, {
     timestamps: true,
     collection: 'documents'
   });

   DocumentSchema.index({ uid: 1, documentType: 1, subfolderName: 1 });
   DocumentSchema.index({ createdAt: -1 });

   module.exports = mongoose.model('Document', DocumentSchema);
