#!/bin/bash

# MongoDB API Testing Script
# This script tests all MongoDB backend APIs to verify they're working

echo "🔍 Testing MongoDB Backend APIs..."
echo "Server: 168.231.113.219"
echo ""

# Colors
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Test Inspection API
echo "📋 Testing Inspection API (Port 5004)..."
INSP_COUNT=$(curl -s http://168.231.113.219:5004/inspections/count 2>/dev/null | python3 -c "import sys, json; data=json.load(sys.stdin); print(data.get('total', 0))" 2>/dev/null)
if [ "$INSP_COUNT" ]; then
    echo -e "${GREEN}✅ Inspection Count: $INSP_COUNT reports${NC}"
else
    echo -e "${RED}❌ Inspection API Failed${NC}"
fi

INSP_ALL=$(curl -s 'http://168.231.113.219:5004/inspections/all?limit=100' 2>/dev/null | python3 -c "import sys, json; data=json.load(sys.stdin); print(len(data.get('data', [])))" 2>/dev/null)
if [ "$INSP_ALL" ]; then
    echo -e "${YELLOW}⚠️  Inspection /all endpoint returns: $INSP_ALL records${NC}"
else
    echo -e "${RED}❌ Inspection /all endpoint Failed${NC}"
fi
echo ""

# Test Equipment API
echo "🚜 Testing Equipment API (Port 5001)..."
EQUIP_COUNT=$(curl -s http://168.231.113.219:5001/count 2>/dev/null | python3 -c "import sys, json; data=json.load(sys.stdin); print(data.get('count', 0))" 2>/dev/null)
if [ "$EQUIP_COUNT" ]; then
    echo -e "${GREEN}✅ Equipment Count: $EQUIP_COUNT items${NC}"
else
    echo -e "${RED}❌ Equipment API Failed${NC}"
fi
echo ""

# Test Job Card API
echo "🔧 Testing Job Card API (Port 5005)..."
JOB_COUNT=$(curl -s http://168.231.113.219:5005/jobcards/all 2>/dev/null | python3 -c "import sys, json; data=json.load(sys.stdin); print(len(data.get('data', [])))" 2>/dev/null)
if [ "$JOB_COUNT" ]; then
    echo -e "${GREEN}✅ Job Cards Count: $JOB_COUNT job cards${NC}"
else
    echo -e "${RED}❌ Job Card API Failed${NC}"
fi
echo ""

# Test Maintenance API
echo "🔨 Testing Maintenance Request API (Port 5009)..."
MAINT_COUNT=$(curl -s http://168.231.113.219:5009/request-maintenance 2>/dev/null | python3 -c "import sys, json; data=json.load(sys.stdin); print(len(data.get('data', [])))" 2>/dev/null)
if [ "$MAINT_COUNT" ]; then
    echo -e "${GREEN}✅ Maintenance Requests: $MAINT_COUNT requests${NC}"
else
    echo -e "${RED}❌ Maintenance API Failed${NC}"
fi
echo ""

# Test Service Schedule API
echo "📅 Testing Service Schedule API (Port 5010)..."
SCHED_COUNT=$(curl -s http://168.231.113.219:5010/service-schedules 2>/dev/null | python3 -c "import sys, json; data=json.load(sys.stdin); print(len(data.get('data', [])))" 2>/dev/null)
if [ "$SCHED_COUNT" ]; then
    echo -e "${GREEN}✅ Service Schedules: $SCHED_COUNT schedules${NC}"
else
    echo -e "${RED}❌ Service Schedule API Failed${NC}"
fi
echo ""

# Summary
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "📊 SUMMARY:"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "Inspections (count): $INSP_COUNT"
echo "Inspections (/all):  $INSP_ALL"
echo "Job Cards:           $JOB_COUNT"
echo "Maintenance:         $MAINT_COUNT"
echo "Service Schedules:   $SCHED_COUNT"
echo "Equipment:           $EQUIP_COUNT"
echo ""

# Check if inspection /all is broken
if [ "$INSP_COUNT" != "$INSP_ALL" ]; then
    echo -e "${RED}⚠️  ISSUE DETECTED:${NC}"
    echo "The /inspections/all endpoint returns $INSP_ALL but count shows $INSP_COUNT"
    echo ""
    echo -e "${YELLOW}SOLUTION:${NC}"
    echo "1. SSH to server: ssh root@168.231.113.219"
    echo "2. Restart PM2: pm2 restart titan-drilling-api"
    echo "3. Check logs: pm2 logs titan-drilling-api --lines 50"
    echo ""
fi

echo "✅ Test Complete!"


