#!/bin/bash

echo "🔄 Restarting DVIR Handler Server..."

# Find and kill the existing process
PID=$(lsof -ti:5006)
if [ ! -z "$PID" ]; then
    echo "⏹️  Stopping existing server (PID: $PID)..."
    kill -9 $PID
    sleep 2
else
    echo "ℹ️  No existing server found on port 5006"
fi

# Start the server
echo "🚀 Starting DVIR Handler Server..."
cd Appmongosetup/backend
nohup node GlobalDVIRhandler.js > dvir_server.log 2>&1 &

echo "✅ DVIR Handler Server restarted!"
echo "📋 Check logs: tail -f Appmongosetup/backend/dvir_server.log"
