<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Titan Drilling - @yield('title', 'Dashboard')</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="{{ asset('js/custom-alerts.js') }}"></script>

    <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Jost:ital,wght@0,100..900;1,100..900&family=Manrope:wght@200..800&family=Roboto:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">" rel="stylesheet">

    @if (app()->environment('local'))
        @vite(['resources/css/app.css'])
    @endif
    @yield('styles')

    <!-- Page Loader -->
    <div id="pageLoader" class="page-loader">
        <div class="loader-container">
            <div class="loader-spinner">
                <div class="spinner-ring"></div>
                <div class="spinner-ring"></div>
                <div class="spinner-ring"></div>
                <div class="spinner-ring"></div>
            </div>
            <div class="loader-text">
                <!-- <span class="loader-title">Titan Drilling</span>
                <span class="loader-subtitle">Loading...</span> -->
            </div>
        </div>
    </div>

    <style>
        /* CSS Variables for better maintainability */
        :root {
            --primary-color: #0055a5;
            --primary-hover: rgb(0, 53, 102);
            --primary-dark: rgb(2, 63, 121);
            --bg-color: #f4f7fc;
            --white: #ffffff;
            --text-primary: #1f2937;
            --text-secondary: #4b5563;
            --text-muted: #6b7280;
            --border-color: #e2e8f0;
            --border-light: #f1f5f9;
            --shadow-sm: 0 2px 4px rgba(0, 0, 0, 0.1);
            --shadow-md: 0 4px 6px rgba(0, 0, 0, 0.15);
            --shadow-lg: 0 20px 60px rgba(0, 0, 0, 0.3);
            --radius-sm: 4px;
            --radius-md: 8px;
            --radius-lg: 12px;
            --transition-base: all 0.2s ease;
            --transition-slow: all 0.3s ease;
            --z-index-modal: 1060;
            --z-index-backdrop: 1050;
            --z-index-alert: 10000;
            --z-index-loader: 9999;
            --font-family: "Jost", sans-serif;
        }

        /* Reset and Base Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: var(--font-family);
        }

        html {
            scroll-behavior: smooth;
        }

        body {
            background-color: var(--bg-color);
            overflow-x: hidden;
        }

        /* Selection Styles */
        ::selection{
            background: #0055a5 !important;
            color: var(--white);
            text-shadow: 0 0 2px rgba(0,0,0,0.2);
            border-radius: var(--radius-sm);
            padding: 2px;
        }



        /* Custom Scrollbar Styles */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 10px;
        }

        ::-webkit-scrollbar-thumb {
            background-color: var(--primary-color);
            border-radius: 10px;
            border: 2px solid #f1f1f1;
        }

        ::-webkit-scrollbar-thumb:hover {
            background-color: var(--primary-dark);
        }

        /* Firefox Scrollbar Support */
        * {
            scrollbar-width: thin;
            scrollbar-color: var(--primary-color) #f1f1f1;
        }

        /* Layout Components */
        .page-transition {
            margin-top: 38px !important;
        }
        
        .wrapper {
            display: flex;
            min-height: 100vh;
            position: relative;
        }

        .content {
            width: 100%;
            padding: 0;
            transition: var(--transition-slow);
            position: relative;
        }

        /* Sidebar Content Adjustments - Removed as we'll handle this with JavaScript */

        /* Loading Components */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.7);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: var(--z-index-loader);
        }

        .loading-spinner {
            width: 50px;
            height: 50px;
            border: 5px solid #f3f3f3;
            border-top: 5px solid var(--primary-color);
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        .page-transition {
            opacity: 0;
            transform: translateY(20px);
            transition: var(--transition-slow);
            margin-top: 50px !important;
        }
        
        .page-transition.loaded {
            margin-top: 50px !important;
            opacity: 1;
            transform: translateY(0);
        }

        /* Animations */
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Responsive Page Transition Adjustments */
        @media (max-width: 768px) {
            .page-transition,
            .page-transition.loaded {
                margin-top: 40px !important;
            }
        }
        
        @media (max-width: 576px) {
            .page-transition { margin-top: 35px !important; }
            .page-transition.loaded { margin-top: 5px !important; }
        }

        /* Additional Responsive Adjustments */
        @media (max-width: 1400px) { .content { padding: 0; } }
        @media (max-width: 1200px) { .content { padding: 0; } }
        @media (max-width: 992px) { .content { padding: 0; } }
        @media (max-width: 768px) { 
            .content { padding: 0; }
            .wrapper { flex-direction: column; }
        }
        @media (max-width: 576px) { .content { padding: 0; } }
        @media (max-width: 480px) { .content { padding: 0; } }

        /* ===== PAGE LOADER STYLES ===== */
        .page-loader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: var(--z-index-loader);
            opacity: 1;
            visibility: visible;
            transition: all 0.5s ease-in-out;
        }

        .page-loader.hidden {
            opacity: 0;
            visibility: hidden;
        }

        .loader-container {
            text-align: center;
            color: white;
        }

        .loader-spinner {
            position: relative;
            width: 200px;
            height: 200px;
            margin: 0 auto 2rem;
        }

        .spinner-ring {
            position: absolute;
            width: 120%;
            height: 120%;
            border: 4px solid transparent;
            border-top: 4px solid #ffd205;
            border-radius: 50%;
            animation: spin 1.5s linear infinite;
        }

        .spinner-ring:nth-child(2) {
            width: 100%;
            height: 100%;
            top: 5%;
            left: 5%;
            border-top-color: #00B894;
            animation-delay: -0.375s;
        }

        .spinner-ring:nth-child(3) {
            width: 90%;
            height: 90%;
            top: 10%;
            left: 10%;
            border-top-color: #ffffff;
            animation-delay: -0.75s;
        }

        .spinner-ring:nth-child(4) {
            width: 80%;
            height: 80%;
            top: 15%;
            left: 15%;
            border-top-color: #ffd205;
            animation-delay: -1.125s;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }
            100% {
                transform: rotate(360deg);
            }
        }

        .loader-text {
            text-align: center;
        }

        /* .loader-title {
            display: block;
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            color: black;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
            font-family: var(--font-family);
        }

        .loader-subtitle {
            display: block;
            font-size: 1rem;
            font-weight: 400;
            color: rgba(0, 0, 0, 0.8);
            font-family: var(--font-family);
        } */

        /* @keyframes pulse {
            0%, 100% {
                opacity: 0.8;
            }
            50% {
                opacity: 1;
            }
        } */

        /* Responsive loader styles */
        @media (max-width: 768px) {
            .loader-spinner {
                width: 60px;
                height: 60px;
                margin: 0 auto 1.5rem;
            }

            .loader-title {
                font-size: 1.5rem;
            }

            .loader-subtitle {
                font-size: 0.9rem;
            }
        }

        @media (max-width: 480px) {
            .loader-spinner {
                width: 50px;
                height: 50px;
                margin: 0 auto 1rem;
            }

            .loader-title {
                font-size: 1.25rem;
            }

            .loader-subtitle {
                font-size: 0.8rem;
            }
        }

        /* Global Modal Fixes */
        .modal {
            z-index: var(--z-index-modal) !important;
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            width: 100% !important;
            height: 100% !important;
            overflow: scroll !important;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.51), 0 10px 10px -5px rgba(0, 0, 0, 0.55);
        }

        /* Ensure modal content is always above backdrop */
        .modal.show .modal-dialog {
            z-index: calc(var(--z-index-modal) + 20) !important;
        }

        .modal.show .modal-content {
            z-index: calc(var(--z-index-modal) + 20) !important;
        }

        /* Global Bootstrap Modal Override - Maximum Priority */
        .modal[style*="display: block"] .modal-dialog,
        .modal.show .modal-dialog,
        .modal.fade.show .modal-dialog {
            z-index: 9999 !important;
            position: relative !important;
            top: -50px !important;
        }

        .modal[style*="display: block"] .modal-content,
        .modal.show .modal-content,
        .modal.fade.show .modal-content {
            z-index: 999912121 !important;
            position: relative !important;
        }

        .modal-backdrop,
        .modal-backdrop.show,
        .modal-backdrop.fade.show {
            z-index: 1000 !important;
        }

        /* Remove Modal Backdrop Completely */
        .modal-backdrop {
            display: none !important;
            visibility: hidden !important;
            opacity: 0 !important;
            pointer-events: none !important;
        }

        .modal-backdrop.show {
            display: none !important;
            visibility: hidden !important;
            opacity: 0 !important;
            pointer-events: none !important;
        }

        .modal-backdrop.fade {
            display: none !important;
            visibility: hidden !important;
            opacity: 0 !important;
            pointer-events: none !important;
        }

        .modal-backdrop.fade.show {
            display: none !important;
            visibility: hidden !important;
            opacity: 0 !important;
            pointer-events: none !important;
        }

        .modal-backdrop {
            z-index: var(--z-index-backdrop) !important;
            background-color: rgba(0, 0, 0, 0.5) !important;
            opacity: 1 !important;
            position: fixed !important;
            top: 0 !important;
            left: 0 !important;
            width: 100% !important;
            height: 100% !important;
        }

        /* Content Loader Styles */
        .content-loader {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(2px);
            z-index: 1000;
            display: none;
            justify-content: center;
            align-items: center;
            transition: opacity var(--transition-slow);
        }

        .content-loader.show { display: flex; }

        .loader-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
            gap: 20px;
        }

        .loader-spinner {
            position: relative;
            width: 50px;
            height: 50px;
        }

        .spinner-ring {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border: 3px solid transparent;
            border-top: 3px solid var(--primary-color);
            border-radius: 50%;
            animation: spin 1.2s cubic-bezier(0.5, 0, 0.5, 1) infinite;
        }

        .spinner-ring:nth-child(1) {
            animation-delay: -0.45s;
            border-top-color: var(--primary-color);
        }

        .spinner-ring:nth-child(2) {
            animation-delay: -0.3s;
            border-top-color: #3b82f6;
            width: 80%;
            height: 80%;
            top: 10%;
            left: 10%;
        }

        .spinner-ring:nth-child(3) {
            animation-delay: -0.15s;
            border-top-color: #60a5fa;
            width: 60%;
            height: 60%;
            top: 20%;
            left: 20%;
        }

        .spinner-ring:nth-child(4) {
            animation-delay: 0s;
            border-top-color: #93c5fd;
            width: 40%;
            height: 40%;
            top: 30%;
            left: 30%;
        }

        .loader-text {
            color: var(--text-primary);
            font-size: 14px;
            font-weight: 500;
            font-family: var(--font-family);
            animation: pulse 1.5s ease-in-out infinite;
        }

        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.5; }
        }

        .modal-dialog {
            z-index: calc(var(--z-index-modal) + 10) !important;
            position: relative !important;
        }

        .modal-content {
            z-index: calc(var(--z-index-modal) + 10212) !important;
            position: relative !important;
        }

        body.modal-open {
            overflow: hidden !important;
            padding-right: 0 !important;
        }

        .modal.show { display: block !important; }

        .modal.fade .modal-dialog {
            transition: transform var(--transition-slow);
            transform: translate(0, -50px);
        }

        .modal.show .modal-dialog { transform: none; }

        /* Custom Alert Styles */
        .custom-alert-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 10000;
            backdrop-filter: blur(5px);
            animation: fadeIn 0.3s ease;
        }

        .custom-alert-overlay.show {
            display: flex;
        }

        .custom-alert-modal {
            background: white;
            border-radius: 8px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 450px;
            width: 90%;
            max-height: 80vh;
            overflow: hidden;
            animation: slideIn 0.3s ease;
            position: relative;
        }

        .custom-alert-header {
            display: flex;
            align-items: center;
            padding: 24px 24px 16px;
            border-bottom: 1px solid #f1f5f9;
        }

        .custom-alert-icon {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 16px;
            flex-shrink: 0;
        }

        .custom-alert-icon i {
            font-size: 24px;
        }

        .custom-alert-icon.info {
            background: #0055a5;
            color: white;
        }

        .custom-alert-icon.success {
            background: linear-gradient(135deg, #10b981, #059669);
            color: white;
        }

        .custom-alert-icon.warning {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            color: white;
        }

        .custom-alert-icon.error {
            background: linear-gradient(135deg, #ef4444, #dc2626);
            color: white;
        }

        .custom-alert-title {
            font-size: 20px;
            font-weight: 600;
            color: #1f2937;
            margin: 0;
            flex: 1;
        }

        .custom-alert-close {
            background: none;
            border: none;
            color: #6b7280;
            font-size: 20px;
            cursor: pointer;
            padding: 8px;
            border-radius: 8px;
            transition: all 0.2s ease;
        }

        .custom-alert-close:hover {
            background: #f3f4f6;
            color: #374151;
        }

        .custom-alert-body {
            padding: 16px 24px 24px;
        }

        .custom-alert-body p {
            font-size: 16px;
            color: #4b5563;
            line-height: 1.6;
            margin: 0;
        }

        .custom-alert-footer {
            display: flex;
            justify-content: flex-end;
            gap: 12px;
            padding: 16px 24px 24px;
            background: #f9fafb;
        }

        .custom-alert-btn {
            padding: 12px 24px;
            border: none;
            /* border-radius: 8px; */
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s ease;
            min-width: 80px;
        }

        .custom-alert-btn-primary {
            background: #0055a5;
            color: white;
        }

        .custom-alert-btn-primary:hover {
            background:rgb(0, 53, 102);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.4);
        }

        .custom-alert-btn-secondary {
            background: #f3f4f6;
            color: #374151;
        }

        .custom-alert-btn-secondary:hover {
            background: #e5e7eb;
            transform: translateY(-1px);
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes slideIn {
            from { 
                opacity: 0;
                transform: translateY(-20px) scale(0.95);
            }
            to { 
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        /* Responsive Design */
        @media (max-width: 480px) {
            .custom-alert-modal {
                width: 95%;
                margin: 20px;
            }
            
            .custom-alert-header {
                padding: 20px 20px 12px;
            }
            
            .custom-alert-body {
                padding: 12px 20px 20px;
            }
            
            .custom-alert-footer {
                padding: 12px 20px 20px;
                flex-direction: column;
            }
            
            .custom-alert-btn {
                width: 100%;
            }
        }
    </style>
</head>

<body>
    @include('layout.Navbar')
    
    <!-- Loading Overlay -->
    <div id="loadingOverlay" aria-hidden="true" role="status" aria-label="Page loading" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.7); display: none; justify-content: center; align-items: center; z-index: 9999;">
        <div style="width: 50px; height: 50px; border: 5px solid #f3f3f3; border-top: 5px solid #0055a5; border-radius: 50%; animation: spin 1s linear infinite;"></div>
    </div>

    <!-- Sidebar - Fixed Position -->
    <aside id="sidebar" role="complementary" aria-label="Main navigation">
        @include('layout.sidebar')
    </aside>
    
    <!-- Main Content Area -->
    <main id="mainContent" role="main" style="width: calc(100% - 270px); padding: 0; transition: all 0.3s ease; position: relative; margin-left: 270px; overflow-x: hidden; min-height: 100vh;">
            <!-- Content Loader -->
            <div id="contentLoader" aria-hidden="true" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(2px); z-index: 1000; display: none; justify-content: center; align-items: center; transition: opacity 0.3s ease;">
                <div style="display: flex; flex-direction: column; align-items: center; justify-content: center; text-align: center; gap: 20px;">
                    <div style="position: relative; width: 50px; height: 50px;" role="status" aria-label="Loading content">
                        <div style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; border: 3px solid transparent; border-top: 3px solid #0055a5; border-radius: 50%; animation: spin 1.2s cubic-bezier(0.5, 0, 0.5, 1) infinite;"></div>
                        <div style="position: absolute; top: 10%; left: 10%; width: 80%; height: 80%; border: 3px solid transparent; border-top: 3px solid #3b82f6; border-radius: 50%; animation: spin 1.2s cubic-bezier(0.5, 0, 0.5, 1) infinite; animation-delay: -0.3s;"></div>
                        <div style="position: absolute; top: 20%; left: 20%; width: 60%; height: 60%; border: 3px solid transparent; border-top: 3px solid #60a5fa; border-radius: 50%; animation: spin 1.2s cubic-bezier(0.5, 0, 0.5, 1) infinite; animation-delay: -0.15s;"></div>
                        <div style="position: absolute; top: 30%; left: 30%; width: 40%; height: 40%; border: 3px solid transparent; border-top: 3px solid #93c5fd; border-radius: 50%; animation: spin 1.2s cubic-bezier(0.5, 0, 0.5, 1) infinite; animation-delay: 0s;"></div>
                    </div>
                    <div style="color: #1f2937; font-size: 14px; font-weight: 500; font-family: 'Jost', sans-serif; animation: pulse 1.5s ease-in-out infinite;">Loading...</div>
                </div>
            </div>

            <!-- Custom Alert Modal -->
            <div id="customAlert" role="dialog" aria-modal="true" aria-labelledby="alertTitle" aria-hidden="true" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); display: none; justify-content: center; align-items: center; z-index: 10000; backdrop-filter: blur(5px); animation: fadeIn 0.3s ease;">
                <div style="background: white; border-radius: 8px; box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3); max-width: 450px; width: 90%; max-height: 80vh; overflow: hidden; animation: slideIn 0.3s ease; position: relative;">
                    <div style="display: flex; align-items: center; padding: 24px 24px 16px; border-bottom: 1px solid #f1f5f9;">
                        <div id="alertIconContainer" style="width: 48px; height: 48px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-right: 16px; flex-shrink: 0; background: #0055a5; color: white;" aria-hidden="true">
                            <i id="alertIcon" class="fas fa-info-circle" style="font-size: 24px;"></i>
                        </div>
                        <h3 id="alertTitle" style="font-size: 20px; font-weight: 600; color: #1f2937; margin: 0; flex: 1;">Alert</h3>
                        <button onclick="closeCustomAlert()" aria-label="Close alert" style="background: none; border: none; color: #6b7280; font-size: 20px; cursor: pointer; padding: 8px; border-radius: 8px; transition: all 0.2s ease;">
                            <i class="fas fa-times" aria-hidden="true"></i>
                        </button>
                    </div>
                    <div style="padding: 16px 24px 24px;">
                        <p id="alertMessage" style="font-size: 16px; color: #4b5563; line-height: 1.6; margin: 0;">This is a custom alert message.</p>
                    </div>
                    <div style="display: flex; justify-content: flex-end; gap: 12px; padding: 16px 24px 24px; background: #f9fafb;">
                        <button id="alertCancelBtn" onclick="closeCustomAlert()" style="display: none; padding: 12px 24px; border: none; font-size: 14px; font-weight: 500; cursor: pointer; transition: all 0.2s ease; min-width: 80px; background: #f3f4f6; color: #374151;" aria-label="Cancel action">
                            Cancel
                        </button>
                        <button id="alertConfirmBtn" onclick="confirmCustomAlert()" style="padding: 12px 24px; border: none; font-size: 14px; font-weight: 500; cursor: pointer; transition: all 0.2s ease; min-width: 80px; background: #0055a5; color: white;" aria-label="Confirm action">
                            OK
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- Breadcrumb Navigation -->
            <!-- <div class="breadcrumb-nav">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#" onclick="loadPage('{{ route('dashboard') }}', 'Dashboard')">Dashboard</a></li>
                        <li class="breadcrumb-item active" id="currentPage">Dashboard</li>
                    </ol>
                </nav>
            </div> -->
            
            <!-- Dynamic Content Area -->
            <div id="dynamicContent" style="box-sizing: border-box; margin-top: 4%;   ">
                @yield('content')
            </div>
        </main>

    <!-- Inline dynamic loader to avoid blocked asset requests in production -->
    @php
        $dynamicLoaderPath = public_path('js/dynamic-loader.js');
    @endphp
    @if (file_exists($dynamicLoaderPath))
        <script>
{!! file_get_contents($dynamicLoaderPath) !!}
        </script>
    @else
        <script>console.error('Dynamic loader script missing at {{ $dynamicLoaderPath }}');</script>
    @endif

    <script>
        // Shared reference so other scripts can access layout elements safely
        var elements = window.elements || {};

        // Optimized Welcome Page JavaScript
        (function() {
            'use strict';
            
            // Configuration
            const CONFIG = {
                mobileBreakpoint: 768,
                selectors: {
                    contentLoader: '#contentLoader',
                    sidebar: '#sidebar',
                    dynamicContent: '#dynamicContent',
                    customAlert: '#customAlert'
                },
                storageKeys: {
                    sidebar: 'sidebar-collapsed'
                }
            };

            // Cached DOM elements
            // Initialize DOM elements
            function initElements() {
                elements = {
                    contentLoader: document.getElementById('contentLoader'),
                    sidebar: document.getElementById('sidebar'),
                    mainContent: document.getElementById('mainContent'),
                    dynamicContent: document.getElementById('dynamicContent'),
                    customAlert: document.getElementById('customAlert')
                };
                window.elements = elements;
                console.log('Elements initialized:', elements);
            }

            // Content Loader Functions
            window.showContentLoader = function() {
                if (elements.contentLoader) {
                    console.log('Showing content loader...');
                    elements.contentLoader.style.display = 'flex';
                } else {
                    console.log('Content loader element not found!');
                }
            };

            window.hideContentLoader = function() {
                if (elements.contentLoader) {
                    elements.contentLoader.style.display = 'none';
                }
            };

            // Toggle sidebar function - only works on desktop
            window.toggleSidebar = function() {
                console.log('toggleSidebar called');
                if (window.innerWidth > CONFIG.mobileBreakpoint && elements.sidebar && elements.mainContent) {
                    const isCollapsed = elements.sidebar.style.transform === 'translateX(-100%)';
                    console.log('Sidebar collapsed:', isCollapsed);
                    if (isCollapsed) {
                        // Open sidebar
                        elements.sidebar.style.transform = 'translateX(0)';
                        elements.sidebar.style.opacity = '1';
                        // Adjust main content width - make space for sidebar
                        elements.mainContent.style.width = 'calc(100% - 270px)';
                        elements.mainContent.style.marginLeft = '270px';
                        console.log('Sidebar opened, main content adjusted');
                        // Save state
                        localStorage.setItem('sidebar-collapsed', 'false');
                    } else {
                        // Close sidebar
                        elements.sidebar.style.transform = 'translateX(-100%)';
                        elements.sidebar.style.opacity = '0';
                        // Expand main content to full width
                        elements.mainContent.style.width = '100%';
                        elements.mainContent.style.marginLeft = '0';
                        console.log('Sidebar closed, main content expanded');
                        // Save state
                        localStorage.setItem('sidebar-collapsed', 'true');
                    }
                } else {
                    console.log('Toggle conditions not met:', {
                        windowWidth: window.innerWidth,
                        mobileBreakpoint: CONFIG.mobileBreakpoint,
                        sidebar: !!elements.sidebar,
                        mainContent: !!elements.mainContent
                    });
                }
            };

            // Dynamic page loading function
            window.loadPageDynamic = function(pageName) {
                console.log('Loading page:', pageName);
                showContentLoader();
                
                fetch('/load-page', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({ page: pageName })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        document.title = data.title + ' - Titan Drilling';
                        
                        if (elements.dynamicContent) {
                            elements.dynamicContent.innerHTML = data.content;
                        }
                        
                        history.pushState(null, '', data.url);
                        updateActiveSidebarItem(pageName);
                        console.log('Page loaded successfully:', data.title);
                    } else {
                        console.error('Failed to load page:', data.error);
                        showErrorAlert('Page Load Error', 'Failed to load page: ' + data.error);
                    }
                })
                .catch(error => {
                    console.error('Error loading page:', error);
                    showErrorAlert('Page Load Error', 'Error loading page: ' + error.message);
                })
                .finally(() => {
                    hideContentLoader();
                });
            };
            // Update active sidebar item
            function updateActiveSidebarItem(pageName) {
                const allLinks = document.querySelectorAll('#sidebar a[data-page]');
                allLinks.forEach(link => {
                    // Remove active styling
                    link.style.background = '';
                    link.style.color = '';
                    link.style.boxShadow = '';
                });
                
                const currentLink = document.querySelector(`#sidebar [data-page="${pageName}"]`);
                if (currentLink) {
                    // Apply active styling
                    currentLink.style.background = '#0055a5';
                    currentLink.style.color = 'white';
                    currentLink.style.boxShadow = '0 2px 4px 0 rgba(59, 130, 246, 0.3)';
                    
                    const parentMenu = currentLink.closest('div[id$="Menu"]');
                    if (parentMenu) {
                        // Expand parent menu
                        parentMenu.style.maxHeight = '500px';
                        parentMenu.style.opacity = '1';
                        parentMenu.style.transform = 'translateY(0) scale(1)';
                        parentMenu.style.background = 'linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%)';
                        parentMenu.style.border = 'none';
                        parentMenu.style.margin = '4px 0';
                        
                        const parentButton = document.querySelector(`[data-target="#${parentMenu.id}"]`);
                        if (parentButton) {
                            parentButton.setAttribute('aria-expanded', 'true');
                            parentButton.style.background = 'linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%)';
                            parentButton.style.color = '#1e293b';
                            parentButton.style.borderLeft = '3px solid #0055a5';
                            
                            const icon = parentButton.querySelector('i.fa-chevron-down');
                            if (icon) {
                                icon.style.transform = 'rotate(180deg)';
                                icon.style.opacity = '1';
                            }
                            const mainIcon = parentButton.querySelector('i:not(.fa-chevron-down)');
                            if (mainIcon) {
                                mainIcon.style.color = '#0055a5';
                            }
                        }
                    }
                }
            }

            // Event Handlers
            function initEventHandlers() {
                // Sidebar navigation links
                const sidebarLinks = document.querySelectorAll('#sidebar a[data-page]');
                sidebarLinks.forEach(link => {
                    if (link.tagName === 'A') {
                        link.addEventListener('click', function(event) {
                            event.preventDefault();
                            
                            const pageName = this.getAttribute('data-page');
                            const href = this.getAttribute('href');
                            
                            console.log('Sidebar link clicked:', pageName, href);
                            
                            if (pageName && href && !href.startsWith('#') && !href.startsWith('http') && !href.startsWith('mailto:')) {
                                console.log('Loading page dynamically:', pageName);
                                loadPageDynamic(pageName);
                            } else {
                                window.location.href = href;
                            }
                        });
                    }
                });

                // Hide loader when page is fully loaded
                window.addEventListener('load', hideContentLoader);
            }

            // Debug function
            function debugDynamicLoader() {
                console.log('=== DYNAMIC LOADER DEBUG ===');
                console.log('dynamicLoader available:', typeof dynamicLoader !== 'undefined');
                console.log('loadPage function available:', typeof loadPage !== 'undefined');
                
                if (typeof dynamicLoader !== 'undefined') {
                    console.log('Dynamic loader methods:', Object.getOwnPropertyNames(dynamicLoader));
                    console.log('Current page:', dynamicLoader.getCurrentPage());
                    console.log('Current URL:', dynamicLoader.getCurrentUrl());
                } else {
                    console.log('Dynamic loader not loaded!');
                }
                
                const scripts = document.querySelectorAll('script');
                let dynamicLoaderScript = false;
                scripts.forEach(script => {
                    if (script.src && script.src.includes('dynamic-loader.js')) {
                        dynamicLoaderScript = true;
                        console.log('Dynamic loader script found:', script.src);
                    }
                });
                
                if (typeof dynamicLoader === 'undefined') {
                    console.error('Dynamic loader script missing or failed to initialize');
                } else if (!dynamicLoaderScript) {
                    console.log('Dynamic loader loaded inline, no external script tag detected');
                }
            }

            // Initialize page components
            function init() {
                console.log('Main layout loaded, checking dynamic loader...');
                
                initElements();
                initEventHandlers();
                
                // Initialize sidebar state and main content width
                initializeSidebarState();
                
                // Add loaded class to trigger animation
                setTimeout(() => {
                    if (elements.dynamicContent) {
                        elements.dynamicContent.style.opacity = '1';
                    }
                }, 100);
                
                // Debug dynamic loader after a short delay
                setTimeout(debugDynamicLoader, 500);

                // Global modal fix - ensure all modals work properly
                fixModalBackdrop();
                
                // Remove any existing backdrops on page load
                removeAllModalBackdrops();
                
                // Initialize responsive behavior
                initializeResponsiveBehavior();
            }

            // Initialize sidebar state and main content width
            function initializeSidebarState() {
                if (elements.sidebar && elements.dynamicContent) {
                    // Check if sidebar is collapsed (stored in localStorage or default to open)
                    const isCollapsed = localStorage.getItem('sidebar-collapsed') === 'true';
                    
                    if (isCollapsed) {
                        // Sidebar is collapsed, expand main content
                        elements.sidebar.style.transform = 'translateX(-100%)';
                        elements.sidebar.style.opacity = '0';
                        elements.dynamicContent.style.width = '100%';
                        elements.dynamicContent.style.marginLeft = '0';
                    } else {
                        // Sidebar is open, adjust main content
                        elements.sidebar.style.transform = 'translateX(0)';
                        elements.sidebar.style.opacity = '1';
                        elements.dynamicContent.style.width = '100%';
                        elements.dynamicContent.style.marginLeft = '0';
                    }
                }
            }

            // Start when DOM is ready
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', init);
            } else {
                init();
            }
            
            // Ensure sidebar toggle works on all pages by re-initializing after a delay
            setTimeout(function() {
                console.log('Re-initializing sidebar toggle for all pages');
                const sidebarToggle = document.getElementById('sidebar-toggle-btn');
                if (sidebarToggle && !sidebarToggle.hasAttribute('data-initialized')) {
                    sidebarToggle.setAttribute('data-initialized', 'true');
                    sidebarToggle.addEventListener('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        console.log('Sidebar toggle clicked - calling window.toggleSidebar');
                        if (typeof window.toggleSidebar === 'function') {
                            window.toggleSidebar();
                        } else {
                            console.error('window.toggleSidebar not available');
                        }
                    });
                }
            }, 1000);
            // Initialize responsive behavior
            function initializeResponsiveBehavior() {
                const sidebar = elements.sidebar;
                const content = document.getElementById('mainContent');
                const sidebarToggle = document.querySelector('.sidebar-toggle');
                
                function handleResize() {
                    const width = window.innerWidth;
                    
                    if (width <= CONFIG.mobileBreakpoint) {
                        // Mobile/tablet: hide sidebar completely
                        if (sidebar) {
                            Object.assign(sidebar.style, {
                                display: 'none',
                                visibility: 'hidden',
                                opacity: '0',
                                transform: 'translateX(-100%)',
                                width: '0',
                                height: '0',
                                overflow: 'hidden'
                            });
                        }
                        
                        // Ensure content uses full width
                        if (content) {
                            Object.assign(content.style, {
                                paddingLeft: '0',
                                paddingRight: '0',
                                width: '100%',
                                marginLeft: '0'
                            });
                        }
                        
                        // Hide sidebar toggle
                        if (sidebarToggle) {
                            sidebarToggle.style.display = 'none';
                        }
                    } else {
                        // Desktop: show sidebar and restore functionality
                        if (sidebar) {
                            Object.assign(sidebar.style, {
                                display: 'block',
                                visibility: 'visible',
                                opacity: '1',
                                transform: 'translateX(0)',
                                width: '270px',
                                height: '100vh',
                                overflow: 'auto'
                            });
                        }
                        
                        // Restore content with sidebar space
                        if (content) {
                            Object.assign(content.style, {
                                paddingLeft: '0',
                                paddingRight: '0',
                                width: 'calc(100% - 270px)',
                                // marginLeft: '270px'
                            });
                        }
                        
                        // Show sidebar toggle
                        if (sidebarToggle) {
                            sidebarToggle.style.display = 'flex';
                        }
                    }
                }
                
                // Run on load and resize
                handleResize();
                window.addEventListener('resize', handleResize);
            }
        })();

        // Global function to remove all modal backdrops
        window.removeAllModalBackdrops = function() {
            const backdrops = document.querySelectorAll('.modal-backdrop');
            backdrops.forEach(backdrop => backdrop.remove());
            console.log('Removed', backdrops.length, 'modal backdrops');
        };

        // Global function to fix modal backdrop issues
        window.fixModalBackdrop = function() {
            document.addEventListener('show.bs.modal', function (event) {
                const modal = event.target;
                console.log('Modal opening:', modal.id);
                
                document.body.classList.add('modal-open');
                
                const existingBackdrops = document.querySelectorAll('.modal-backdrop');
                existingBackdrops.forEach(backdrop => backdrop.remove());
                
                // Prevent backdrop creation by removing any existing ones
                setTimeout(() => {
                    const newBackdrops = document.querySelectorAll('.modal-backdrop');
                    newBackdrops.forEach(backdrop => backdrop.remove());
                }, 10);
                
                // Ensure modal content is above backdrop
                const modalDialog = modal.querySelector('.modal-dialog');
                const modalContent = modal.querySelector('.modal-content');
                
                if (modalDialog) {
                    modalDialog.style.zIndex = '9999';
                    modalDialog.style.position = 'relative';
                }
                if (modalContent) {
                    modalContent.style.zIndex = '9999';
                    modalContent.style.position = 'relative';
                }
                
                // Force backdrop to lower z-index
                setTimeout(() => {
                    const backdrops = document.querySelectorAll('.modal-backdrop');
                    backdrops.forEach(backdrop => {
                        backdrop.style.zIndex = '1000';
                    });
                }, 10);
            });

            document.addEventListener('hidden.bs.modal', function (event) {
                const modal = event.target;
                console.log('Modal closing:', modal.id);
                
                document.body.classList.remove('modal-open');
                
                const backdrops = document.querySelectorAll('.modal-backdrop');
                backdrops.forEach(backdrop => backdrop.remove());
                
                Object.assign(document.body.style, {
                    overflow: '',
                    paddingRight: ''
                });
            });

            document.addEventListener('click', function(event) {
                if (event.target.classList.contains('modal') && event.target === event.currentTarget) {
                    const openModal = document.querySelector('.modal.show');
                    if (openModal) {
                        const modalInstance = bootstrap.Modal.getInstance(openModal);
                        if (modalInstance) {
                            modalInstance.hide();
                        }
                    }
                }
            });

            // Additional fix for modal z-index issues
            document.addEventListener('DOMContentLoaded', function() {
                // Force modal content above backdrop with maximum specificity
                const style = document.createElement('style');
                style.textContent = `
                    /* Override Bootstrap and any other CSS */
                    .modal.show .modal-dialog {
                        z-index: 9999 !important;
                        position: relative !important;
                    }
                    .modal.show .modal-content {
                        z-index: 9999 !important;
                        position: relative !important;
                    }
                    .modal-backdrop {
                        z-index: 1000 !important;
                    }
                    .modal-backdrop.show {
                        z-index: 1000 !important;
                    }
                    /* Force all modals to be above backdrop */
                    .modal[style*="display: block"] .modal-dialog {
                        z-index: 9999 !important;
                    }
                    .modal[style*="display: block"] .modal-content {
                        z-index: 9999121 !important;
                    }
                `;
                document.head.appendChild(style);
            });
            
            // Continuous monitoring to fix modal z-index issues and remove backdrops
            setInterval(function() {
                const openModals = document.querySelectorAll('.modal.show, .modal[style*="display: block"]');
                const backdrops = document.querySelectorAll('.modal-backdrop');
                
                // Fix modal content z-index
                openModals.forEach(modal => {
                    const dialog = modal.querySelector('.modal-dialog');
                    const content = modal.querySelector('.modal-content');
                    
                    if (dialog) {
                        dialog.style.zIndex = '9999';
                        dialog.style.position = 'relative';
                    }
                    if (content) {
                        content.style.zIndex = '9999';
                        content.style.position = 'relative';
                    }
                });
                
                // Remove all backdrops completely
                backdrops.forEach(backdrop => {
                    backdrop.remove();
                });
            }, 100); // Check every 100ms
            
            // MutationObserver to fix z-index issues immediately when modals are added
            const observer = new MutationObserver(function(mutations) {
                mutations.forEach(function(mutation) {
                    if (mutation.type === 'childList') {
                        mutation.addedNodes.forEach(function(node) {
                            if (node.nodeType === 1) { // Element node
                                // Check if it's a modal or backdrop
                                if (node.classList && (node.classList.contains('modal') || node.classList.contains('modal-backdrop'))) {
                                    setTimeout(() => {
                                        if (node.classList.contains('modal')) {
                                            const dialog = node.querySelector('.modal-dialog');
                                            const content = node.querySelector('.modal-content');
                                            if (dialog) {
                                                dialog.style.zIndex = '9999';
                                                dialog.style.position = 'relative';
                                            }
                                            if (content) {
                                                content.style.zIndex = '9999';
                                                content.style.position = 'relative';
                                            }
                                        } else if (node.classList.contains('modal-backdrop')) {
                                            // Remove backdrop immediately
                                            node.remove();
                                        }
                                    }, 10);
                                }
                            }
                        });
                    }
                });
            });
            
            // Start observing
            observer.observe(document.body, {
                childList: true,
                subtree: true
            });
            
            // Override Bootstrap's modal backdrop creation
            const originalCreateBackdrop = window.bootstrap?.Modal?.prototype?._createBackdrop;
            if (originalCreateBackdrop) {
                window.bootstrap.Modal.prototype._createBackdrop = function() {
                    // Do nothing - prevent backdrop creation
                    return null;
                };
            }
            
            // Override jQuery modal backdrop if it exists
            if (window.$ && window.$.fn.modal) {
                const originalModal = window.$.fn.modal;
                window.$.fn.modal = function(options) {
                    const result = originalModal.call(this, options);
                    // Remove any backdrops that might have been created
                    setTimeout(() => {
                        document.querySelectorAll('.modal-backdrop').forEach(backdrop => backdrop.remove());
                    }, 10);
                    return result;
                };
            }
        };

        // Custom Alert Functions
        let alertCallback = null;

        window.showCustomAlert = function(options = {}) {
            const {
                title = 'Alert',
                message = 'This is a custom alert message.',
                type = 'info',
                showCancel = false,
                confirmText = 'OK',
                cancelText = 'Cancel',
                onConfirm = null,
                onCancel = null
            } = options;

            const alert = elements.customAlert;
            const icon = document.getElementById('alertIcon');
            const iconContainer = document.getElementById('alertIconContainer');
            const titleEl = document.getElementById('alertTitle');
            const messageEl = document.getElementById('alertMessage');
            const confirmBtn = document.getElementById('alertConfirmBtn');
            const cancelBtn = document.getElementById('alertCancelBtn');

            if (!alert) return;

            const iconClass = getIconClass(type);
            icon.className = `fas ${iconClass}`;
            
            // Update icon container background based on type
            const typeColors = {
                info: '#0055a5',
                success: 'linear-gradient(135deg, #10b981, #059669)',
                warning: 'linear-gradient(135deg, #f59e0b, #d97706)',
                error: 'linear-gradient(135deg, #ef4444, #dc2626)'
            };
            iconContainer.style.background = typeColors[type] || typeColors.info;

            titleEl.textContent = title;
            messageEl.textContent = message;
            confirmBtn.textContent = confirmText;
            cancelBtn.textContent = cancelText;

            cancelBtn.style.display = showCancel ? 'block' : 'none';
            alertCallback = { onConfirm, onCancel };
            alert.style.display = 'flex';
        };

        window.closeCustomAlert = function() {
            if (elements.customAlert) {
                elements.customAlert.style.display = 'none';
                
                if (alertCallback && alertCallback.onCancel) {
                    alertCallback.onCancel();
                }
                alertCallback = null;
            }
        };

        window.confirmCustomAlert = function() {
            if (elements.customAlert) {
                elements.customAlert.style.display = 'none';
                
                if (alertCallback && alertCallback.onConfirm) {
                    alertCallback.onConfirm();
                }
                alertCallback = null;
            }
        };

        function getIconClass(type) {
            const icons = {
                success: 'fa-check-circle',
                warning: 'fa-exclamation-triangle',
                error: 'fa-times-circle',
                info: 'fa-info-circle'
            };
            return icons[type] || icons.info;
        }

        // Convenience functions for different alert types
        window.showInfoAlert = (title, message, onConfirm = null) => 
            showCustomAlert({ title, message, type: 'info', onConfirm });

        window.showSuccessAlert = (title, message, onConfirm = null) => 
            showCustomAlert({ title, message, type: 'success', onConfirm });

        window.showWarningAlert = (title, message, onConfirm = null) => 
            showCustomAlert({ title, message, type: 'warning', onConfirm });

        window.showErrorAlert = (title, message, onConfirm = null) => 
            showCustomAlert({ title, message, type: 'error', onConfirm });

        window.showConfirmAlert = (title, message, onConfirm = null, onCancel = null) => 
            showCustomAlert({ title, message, type: 'warning', showCancel: true, onConfirm, onCancel });

        // Alert event handlers
        document.addEventListener('click', function(e) {
            if (e.target === elements.customAlert) {
                closeCustomAlert();
            }
        });

        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && elements.customAlert && elements.customAlert.style.display === 'flex') {
                closeCustomAlert();
            }
        });
    </script>

    <script>
        // ===== PAGE LOADER FUNCTIONALITY =====
        function initPageLoader() {
            const pageLoader = document.getElementById('pageLoader');
            
            // Show loader on page load
            function showLoader() {
                if (pageLoader) {
                    pageLoader.classList.remove('hidden');
                }
            }
            
            let navigationCheckTimeout = null;
            
            // Hide loader when page is fully loaded
            function hideLoader() {
                if (pageLoader) {
                    setTimeout(() => {
                        pageLoader.classList.add('hidden');
                    }, 500); // Small delay for smooth transition
                    if (navigationCheckTimeout) {
                        clearTimeout(navigationCheckTimeout);
                        navigationCheckTimeout = null;
                    }
                }
            }
            
            // Show loader on page refresh/navigation
            function showLoaderOnNavigation() {
                if (!pageLoader) return;
                
                pageLoader.classList.remove('hidden');
                
                if (navigationCheckTimeout) {
                    clearTimeout(navigationCheckTimeout);
                }
                
                const currentUrl = window.location.href;
                navigationCheckTimeout = setTimeout(() => {
                    // If the URL hasn't changed, navigation was likely cancelled (AJAX link, modal, etc.)
                    if (window.location.href === currentUrl) {
                        hideLoader();
                    }
                }, 2000);
            }
            
            // Page load events
            window.addEventListener('load', hideLoader);
            window.addEventListener('DOMContentLoaded', function() {
                // Hide loader after a minimum time to ensure smooth experience
                setTimeout(hideLoader, 800);
            });
            
            // Show loader on page refresh
            window.addEventListener('beforeunload', showLoaderOnNavigation);
            
            // Show loader on form submissions
            document.addEventListener('submit', function(e) {
                // Only show loader for forms that cause page navigation
                const form = e.target;
                if (form.method && (form.method.toLowerCase() === 'post' || form.method.toLowerCase() === 'get')) {
                    showLoaderOnNavigation();
                }
            });
            
            // Show loader on link clicks (for navigation)
            document.addEventListener('click', function(e) {
                const link = e.target.closest('a');
                if (link && link.href && !link.href.includes('#') && !link.target) {
                    // Check if it's an internal link
                    const currentHost = window.location.hostname;
                    try {
                        const linkHost = new URL(link.href).hostname;
                        
                        if (linkHost === currentHost) {
                            showLoaderOnNavigation();
                        }
                    } catch (error) {
                        // Invalid URL, skip
                    }
                }
            });
            
            // Global function to show loader manually
            window.showPageLoader = function() {
                showLoaderOnNavigation();
            };
            
            // Global function to hide loader manually
            window.hidePageLoader = function() {
                hideLoader();
            };
            
            console.log('Page loader initialized');
        }
        
        // Initialize page loader when DOM is ready
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', initPageLoader);
        } else {
            initPageLoader();
        }
    </script>

    @if (app()->environment('local'))
        @vite(['resources/js/app.js'])
    @endif
    @yield('scripts')
</body>

</html>