# MongoDB Dashboard Integration Guide

## ✅ Dashboard Successfully Migrated to MongoDB

Your Laravel dashboard is now **100% connected to MongoDB** - No more Firebase!

---

## 🔗 MongoDB Backend APIs

All data is now fetched from your **Express.js MongoDB backend** running on server `168.231.113.219`:

### Core Services:
| Service | Port | Endpoint | Collection |
|---------|------|----------|------------|
| **Inspections** | 5004 | `/inspections/all` | `inspectionreports` |
| **Job Cards/Work Orders** | 5005 | `/jobcards/all` | `jobcards_v3` |
| **Maintenance Requests** | 5009 | `/request-maintenance` | `GlobalrequestMaintenance` |
| **Service Schedules** | 5010 | `/service-schedules` | `GlobalServiceSchdule` |
| **Equipment/Vehicles** | 5001 | `/EquipmentsDataJSON/GlobalEquipmentJsonData` | `equipment` |

---

## 📊 Dashboard Metrics Connected

All dashboard cards now pull data from MongoDB:

### Inspection Conducted
- ✅ **Total Inspections** - Count from `inspectionreports` collection
- ✅ **Good Inspections** - Based on `step3.faultyItems == 0` or `step3.overallCondition == 'good'`
- ✅ **Faulty Inspections** - Based on `step3.faultyItems > 0`

### Issue Report
- ✅ **Total Issues** - Faulty inspections + maintenance requests
- ✅ **Resolved** - Maintenance requests with `status: 'resolved'`
- ✅ **In Progress** - Maintenance requests with `status: 'in progress'`
- ✅ **Pending** - Maintenance requests with `status: 'pending'`

### Fault Summary
- ✅ **Faulty Vehicles** - Unique equipment with faulty inspections
- ✅ **Repair Items** - From `correctiveActionData.subItemStatuses`
- ✅ **Replace Items** - From `correctiveActionData.subItemStatuses`

### Work Order Summary
- ✅ **Total Work Orders** - Count from `jobcards_v3` collection
- ✅ **Completed** - Job cards with `status: 'completed'`
- ✅ **Initiated** - Job cards with `status: 'Hold'` or `'initiated'`
- ✅ **In Progress** - Job cards with `status: 'in_progress'`
- ✅ **On Hold** - Job cards with `status: 'Hold'`
- ✅ **Rework** - Job cards with `status: 'rework'`
- ✅ **Postponed** - Job cards with `status: 'postponed'`

### Schedule
- ✅ **Total Schedules** - Count from `GlobalServiceSchdule` collection
- ✅ **Due Soon** - Schedules within next 7 days
- ✅ **Overdue** - Schedules past due date

### Request Summary
- ✅ **Requested** - Maintenance with `status: 'requested'` or `'pending'`
- ✅ **Accepted** - Maintenance with `status: 'accepted'` or `'approved'`
- ✅ **Resolved** - Maintenance with `status: 'resolved'`

### Vehicle Status
- ✅ **Total Vehicles** - Count from `equipment` collection
- ✅ **Active** - Equipment with `status: 'active'`
- ✅ **In Maintenance** - Equipment with `status: 'maintenance'`
- ✅ **Breakdown** - Equipment with `status: 'breakdown'`

---

## 🔧 Modified Files

### 1. `app/Http/Controllers/DashboardController.php`
- ✅ Removed Firebase URL
- ✅ Added MongoDB API endpoints configuration
- ✅ Created `fetchMongoDBData()` method
- ✅ Added MongoDB-specific counting methods (prefixed with `countMongo*`)
- ✅ Updated all test methods to use MongoDB

**MongoDB Configuration:**
```php
private $mongoBaseUrl = 'http://168.231.113.219';
private $inspectionPort = '5004';
private $jobCardPort = '5005';
private $maintenanceRequestPort = '5009';
private $serviceSchedulePort = '5010';
private $equipmentPort = '5001';
```

### 2. `routes/web.php`
- ✅ Changed `/test-firebase` to `/test-mongodb`
- ✅ All test routes now use MongoDB

---

## 🧪 Testing the Integration

### Test Endpoints (Browser/Postman):

1. **Test MongoDB Connection:**
   ```
   http://127.0.0.1:8000/test-mongodb
   ```
   Should return all dashboard data from MongoDB

2. **Test Inspection Data:**
   ```
   http://127.0.0.1:8000/test-inspection
   ```
   Should show inspection counts and sample data

3. **Test Service Schedules:**
   ```
   http://127.0.0.1:8000/test-service-schedule
   ```
   Should show schedule data from MongoDB

4. **Test Maintenance Requests:**
   ```
   http://127.0.0.1:8000/test-maintenance
   ```
   Should show maintenance request data

### Direct MongoDB API Tests:

Test if MongoDB backend is running:

```bash
# Inspection Reports
curl http://168.231.113.219:5004/inspections/all

# Job Cards
curl http://168.231.113.219:5005/jobcards/all

# Maintenance Requests
curl http://168.231.113.219:5009/request-maintenance

# Service Schedules
curl http://168.231.113.219:5010/service-schedules

# Equipment/Vehicles
curl http://168.231.113.219:5001/EquipmentsDataJSON/GlobalEquipmentJsonData
```

---

## 📱 MongoDB Data Structure

### Inspection Report Structure:
```javascript
{
  _id: "report_id",
  userId: "user_id",
  requestNumber: "ZAM-KOB-INS-001",
  status: "completed",
  step1: {
    country: "Zambia",
    project: "Kobold",
    inspector: "John Doe",
    selectedEquipment: {
      id: "eq_123",
      equipmentName: "Bulldozer",
      mainCategory: "Heavy Equipment"
    }
  },
  step2: {
    selections: {},
    faultyItems: 3
  },
  step3: {
    faultyItems: 3,
    overallCondition: "Needs Repair",
    priority: "High",
    safeToUse: "No",
    pdfDownloadUrl: "..."
  },
  correctiveActionData: {
    subItemStatuses: {
      "item_1": "repair",
      "item_2": "replace"
    },
    faultyCount: 2
  },
  createdAt: "2025-01-15T10:30:00Z"
}
```

### Job Card Structure:
```javascript
{
  _id: "jobcard_id",
  adminUid: "user_id",
  requestNumber: "ZAM-KOB-JC-001",
  title: "Repair Excavator Engine",
  status: "in_progress",
  priority: "High",
  equipment: {
    equipmentName: "CAT Excavator",
    mainCategory: "Heavy Equipment",
    model: "320D"
  },
  assignTo: [{
    name: "Mechanic Name",
    uid: "mech_123"
  }],
  startDate: "2025-01-10",
  dueDate: "2025-01-20",
  createdAt: "2025-01-10T08:00:00Z"
}
```

### Maintenance Request Structure:
```javascript
{
  _id: "maint_id",
  adminUid: "user_id",
  requestNumber: "ZAM-KOB-MR-001",
  workOrderTitle: "Engine Oil Change",
  requestType: "Preventive",
  priority: "Medium",
  status: "accepted",
  equipment: {
    equipmentName: "Toyota Hilux",
    country: "Zambia",
    project: "Kobold"
  },
  createdAt: "2025-01-12T14:00:00Z"
}
```

### Service Schedule Structure:
```javascript
{
  _id: "schedule_id",
  scheduleId: "SS-001",
  title: "Monthly Oil Change",
  repeatType: "hours",
  intervals: [{value: "250", unit: "hours"}],
  status: "upcoming",
  equipment: {
    equipmentName: "Truck ABC",
    meterReading: 5000
  },
  lastServiceDate: "2025-01-01",
  createdAt: "2024-12-15"
}
```

---

## 🚀 How It Works

1. **Dashboard loads** → `DashboardController@index` is called
2. **Controller fetches data** → `fetchMongoDBData()` method runs
3. **HTTP requests made** → Calls all 5 MongoDB APIs simultaneously
4. **Data processed** → Counting methods analyze the data
5. **Dashboard renders** → Blade template shows the metrics

### Request Flow:
```
Laravel Dashboard (Port 8000)
    ↓
DashboardController
    ↓
HTTP::get() to MongoDB APIs
    ↓
Express.js Backend (Ports 5001-5028)
    ↓
MongoDB Database (Port 27017)
    ↓
titan_drilling database
```

---

## 🔍 Debugging

### Check Laravel Logs:
```bash
tail -f storage/logs/laravel.log
```

Look for lines like:
- `MongoDB Inspection Response Status: 200`
- `MongoDB Inspection Data Count: 45`
- `MongoDB Job Card Data Count: 12`

### Check MongoDB Backend is Running:
```bash
# SSH to server
ssh root@168.231.113.219
# Password: 5aXBS2f-y/vwM8#

# Check PM2 status
pm2 status

# Check logs
pm2 logs titan-drilling-api --lines 100

# Restart if needed
pm2 restart titan-drilling-api
```

### Test MongoDB Backend Directly:
```bash
# Test Inspection API
curl http://168.231.113.219:5004/inspections/count

# Test Equipment API
curl http://168.231.113.219:5001/count
```

---

## ⚠️ Important Notes

1. **Make sure MongoDB backend is running** on server `168.231.113.219`
   - All 28 services must be active
   - Check with `pm2 status`

2. **Network connectivity** - Your Laravel app must be able to reach `168.231.113.219`
   - Check firewall rules
   - Test with `curl` or `ping`

3. **Data Format** - MongoDB responses include wrapper object:
   ```json
   {
     "success": true,
     "data": [...],  // <-- This is what we extract
     "pagination": {...}
   }
   ```

4. **Error Handling** - If MongoDB fails, dashboard shows zeros (from `getDefaultDashboardData()`)

---

## 📈 Benefits Over Firebase

✅ **Faster** - Local MongoDB queries vs Firebase HTTP requests  
✅ **More Reliable** - No internet dependency for data  
✅ **Better Querying** - MongoDB aggregation pipelines  
✅ **Structured Data** - Defined schemas with validation  
✅ **Offline Support** - Mobile app can sync when back online  
✅ **Better Security** - Data stays on your server  
✅ **Cost Effective** - No Firebase billing  

---

## 🎯 Next Steps

1. ✅ Dashboard is now connected to MongoDB
2. ✅ All metrics pull from MongoDB collections
3. ✅ Old Firebase code removed
4. ⏳ Test with real data
5. ⏳ Verify all counts are accurate
6. ⏳ Monitor performance and logs

---

## 📞 MongoDB Backend Services Status

Check all services are running:

```bash
curl http://168.231.113.219:5001  # Equipment
curl http://168.231.113.219:5004  # Inspections  
curl http://168.231.113.219:5005  # Job Cards
curl http://168.231.113.219:5009  # Maintenance Requests
curl http://168.231.113.219:5010  # Service Schedules
```

Each should return a JSON response with `"status": "OK"` or similar.

---

## 🎉 Migration Complete!

Your dashboard is now fully powered by **MongoDB** with no Firebase dependencies!

All data flows from:
- React Native Mobile App → MongoDB Backend → Laravel Dashboard


