// src/utils/normalizeEquipmentData.js

const normalizeEquipmentData = (data) => {
  const normalized = [];
  const currentDate = new Date();
  let nameCounter = 1;

  const randomDate = () =>
    new Date(currentDate - Math.random() * 30 * 24 * 60 * 60 * 1000).toISOString();

  data["Light Vehicles TDC"]?.forEach((item, index) => {
    normalized.push({
      id: `lv-${index}`,
      equipmentNumber: item["Vehicle Number"] || `LV-${index + 1}`,
      equipmentName: `Vehicle ${nameCounter++}`,
      equipmentCategory: "Light Vehicle",
      mainCategory: "Light Vehicles TDC",
      model: item["Vehicle Type"] || "N/A",
      meterReading: Math.floor(Math.random() * 10000),
      meterUnit: "Miles",
      status: "Available",
      createdAt: randomDate(),
      country: item["Vehicle Number"]?.includes("ZAMBIA") ? "Zambia" : "DRC",
      vin: item["VIN Number"] || "N/A",
      regNum: item["Reg Num"] || "N/A",
      dynamicField1: item["Vehicle Number"] || "N/A",
      dynamicField2: item["Reg Num"] || "N/A",
      dynamicField3: item["VIN Number"] || "N/A",
    });
  });

  data["Heavy Vehicles TDC"]?.forEach((item, index) => {
    normalized.push({
      id: `hv-${index}`,
      equipmentNumber: item["Vehicle Number"] || `HV-${index + 1}`,
      equipmentName: `Vehicle ${nameCounter++}`,
      equipmentCategory: "Heavy Vehicle",
      mainCategory: "Heavy Vehicles TDC",
      model: item["Vehicle Type"] || "N/A",
      meterReading: Math.floor(Math.random() * 10000),
      meterUnit: "Miles",
      status: "Available",
      createdAt: randomDate(),
      country: item["Vehicle Number"]?.includes("ZAMBIA") ? "Zambia" : "DRC",
      vin: item["VIN Number/Chas#"] || "N/A",
      regNum: item["Reg Num"] || "N/A",
      dynamicField1: item["Vehicle Number"] || "N/A",
      dynamicField2: item["Reg Num"] || "N/A",
      dynamicField3: item["VIN Number/Chas#"] || "N/A",
    });
  });

  data["Containers"]?.forEach((item, index) => {
    normalized.push({
      id: `cont-${index}`,
      equipmentNumber: `CONT-${index + 1}`,
      equipmentName: `Container ${nameCounter++}`,
      equipmentCategory: "Container",
      mainCategory: "Containers",
      model: item["Container Type"] || "N/A",
      meterReading: 0,
      meterUnit: "N/A",
      status: "Available",
      createdAt: randomDate(),
      country: "DRC",
      purpose: item["Purpose"] || "N/A",
      dynamicField1: item["Purpose"] || "N/A",
      dynamicField2: item["Container Type"] || "N/A",
      dynamicField3: item["Container Type"] || "N/A",
    });
  });

  data["TDC Rigs"]?.forEach((item, index) => {
    normalized.push({
      id: `rig-${index}`,
      equipmentNumber: item["Rig Name"] || `RIG-${index + 1}`,
      equipmentName: `Rig ${nameCounter++}`,
      equipmentCategory: "Rig",
      mainCategory: "TDC Rigs",
      model: item["Rig Type"] || "N/A",
      meterReading: Math.floor(Math.random() * 5000),
      meterUnit: "Hours",
      status: "Available",
      createdAt: randomDate(),
      country: "DRC",
      truckType: item["Truck Type"] || "N/A",
      chassisNumber: item["Chassis Number"] || "N/A",
      dynamicField1: item["Rig Name"] || "N/A",
      dynamicField2: item["Truck Type"] || "N/A",
      dynamicField3: item["Chassis Number"] || "N/A",
    });
  });

  data["Machinery"]?.forEach((item, index) => {
    normalized.push({
      id: `mach-${index}`,
      equipmentNumber: item["Equipment Num"] || `MACH-${index + 1}`,
      equipmentName: `Machinery ${nameCounter++}`,
      equipmentCategory: "Machinery",
      mainCategory: "Machinery",
      model: item["Equipment Type"] || "N/A",
      meterReading: Math.floor(Math.random() * 5000),
      meterUnit: "Hours",
      status: "Available",
      createdAt: randomDate(),
      country: "DRC",
      vin: item["VIN Number/Chas#"] || "N/A",
      dynamicField1: item["Equipment Num"] || "N/A",
      dynamicField2: item["Equipment Name"] || "N/A",
      dynamicField3: item["VIN Number/Chas#"] || "N/A",
    });
  });

  data["Mud Mixer Trailers"]?.forEach((item, index) => {
    normalized.push({
      id: `trailer-${index}`,
      equipmentNumber: `TRAILER-${item["Number"] || index + 1}`,
      equipmentName: `Trailer ${nameCounter++}`,
      equipmentCategory: "Mud Mixer Trailer",
      mainCategory: "Mud Mixer Trailers",
      model: item["Type"] || "N/A",
      meterReading: 0,
      meterUnit: "N/A",
      status: "Available",
      createdAt: randomDate(),
      country: "DRC",
      serialNumber: item["Serial Number"] || "N/A",
      dynamicField1: item["Number"] || "N/A",
      dynamicField2: item["Serial Number"] || "N/A",
      dynamicField3: item["Type"] || "N/A",
    });
  });

  data["Lightning Shelters"]?.forEach((item, index) => {
    normalized.push({
      id: `shelter-${index}`,
      equipmentNumber: `SHELTER-${index + 1}`,
      equipmentName: `Shelter ${nameCounter++}`,
      equipmentCategory: "Lightning Shelter",
      mainCategory: "Lightning Shelters",
      model: "Shelter",
      meterReading: 0,
      meterUnit: "N/A",
      status: "Available",
      createdAt: randomDate(),
      country: "DRC",
      shelterName: item["Shelter"] || "N/A",
      dynamicField1: item["Shelter"] || "N/A",
      dynamicField2: item["Shelter"] || "N/A",
      dynamicField3: item["Shelter"] || "N/A",
    });
  });

  data["Trailers"]?.forEach((item, index) => {
    normalized.push({
      id: `rod-trailer-${index}`,
      equipmentNumber: `ROD-TRAILER-${index + 1}`,
      equipmentName: `Trailer ${nameCounter++}`,
      equipmentCategory: "Trailer",
      mainCategory: "Trailers",
      model: item["Type"] || "N/A",
      meterReading: 0,
      meterUnit: "N/A",
      status: "Available",
      createdAt: randomDate(),
      country: "DRC",
      chassisNumber: item["Chassis#"] || "N/A",
      dynamicField1: item["Type"] || "N/A",
      dynamicField2: item["Chassis#"] || "N/A",
      dynamicField3: item["Chassis#"] || "N/A",
    });
  });

  data["Appliances"]?.forEach((item, index) => {
    normalized.push({
      id: `appliance-${index}`,
      equipmentNumber: `APP-${index + 1}`,
      equipmentName: `Appliance ${nameCounter++}`,
      equipmentCategory: "Appliance",
      mainCategory: "Appliances",
      model: item["Model"] || "N/A",
      meterReading: 0,
      meterUnit: "N/A",
      status: "Available",
      createdAt: randomDate(),
      country: "DRC",
      serialNumber: item["Model/Serial Num"] || "N/A",
      applianceType: item["Type"] || "N/A",
      dynamicField1: item["Type"] || "N/A",
      dynamicField2: item["Model"] || "N/A",
      dynamicField3: item["Model/Serial Num"] || "N/A",
    });
  });

  data["Generators"]?.forEach((item, index) => {
    normalized.push({
      id: `gen-${index}`,
      equipmentNumber: `GEN-${index + 1}`,
      equipmentName: `Generator ${nameCounter++}`,
      equipmentCategory: "Generator",
      mainCategory: "Generators",
      model: item["Model"] || "N/A",
      meterReading: Math.floor(Math.random() * 2000),
      meterUnit: "Hours",
      status: "Available",
      createdAt: randomDate(),
      country: "DRC",
      serialNumber: item["Model/Serial Num"] || "N/A",
      generatorType: item["Type"] || "N/A",
      dynamicField1: item["Type"] || "N/A",
      dynamicField2: item["Model"] || "N/A",
      dynamicField3: item["Model/Serial Num"] || "N/A",
    });
  });

  data["Workshop Machinery"]?.forEach((item, index) => {
    normalized.push({
      id: `wmach-${index}`,
      equipmentNumber: `WMACH-${index + 1}`,
      equipmentName: `Machinery ${nameCounter++}`,
      equipmentCategory: "Workshop Machinery",
      mainCategory: "Workshop Machinery",
      model: item["Model"] || "N/A",
      meterReading: Math.floor(Math.random() * 1000),
      meterUnit: "Hours",
      status: "Available",
      createdAt: randomDate(),
      country: "DRC",
      serialNumber: item["Serial Num"] || "N/A",
      machineryType: item["Type"] || "N/A",
      dynamicField1: item["Type"] || "N/A",
      dynamicField2: item["Model"] || "N/A",
      dynamicField3: item["Serial Num"] || "N/A",
    });
  });

  data["Pumps"]?.forEach((item, index) => {
    normalized.push({
      id: `pump-${index}`,
      equipmentNumber: `PUMP-${index + 1}`,
      equipmentName: `Pump ${nameCounter++}`,
      equipmentCategory: "Pump",
      mainCategory: "Pumps",
      model: item["Model"] || "N/A",
      meterReading: Math.floor(Math.random() * 1000),
      meterUnit: "Hours",
      status: "Available",
      createdAt: randomDate(),
      country: "DRC",
      serialNumber: item["Serial Num"] || "N/A",
      pumpType: item["Type"] || "N/A",
      dynamicField1: item["Type"] || "N/A",
      dynamicField2: item["Model"] || "N/A",
      dynamicField3: item["Serial Num"] || "N/A",
    });
  });

  data["Tents"]?.forEach((item, index) => {
    normalized.push({
      id: `tent-${index}`,
      equipmentNumber: `TENT-${index + 1}`,
      equipmentName: `Tent ${nameCounter++}`,
      equipmentCategory: "Tent",
      mainCategory: "Tents",
      model: item["Model"] || "N/A",
      meterReading: 0,
      meterUnit: "N/A",
      status: "Available",
      createdAt: randomDate(),
      country: "DRC",
      serialNumber: item["Serial Num"] || "N/A",
      tentType: item["Type"] || "N/A",
      dynamicField1: item["Type"] || "N/A",
      dynamicField2: item["Model"] || "N/A",
      dynamicField3: item["Serial Num"] || "N/A",
    });
  });

  return normalized.sort((a, b) => new Date(b.createdAt) - new Date(a.createdAt));
};

export default normalizeEquipmentData;