import { View, Text, TextInput, TouchableOpacity, Image, StyleSheet, Platform } from 'react-native';
import React, { useState } from 'react';
import CheckBox from '@react-native-community/checkbox';
import { useNavigation } from '@react-navigation/native';
import LinearGradient from 'react-native-linear-gradient';
import { SafeAreaView } from 'react-native-safe-area-context';

export default function Register() {
  const navigation = useNavigation();

  const [email, setEmail] = useState('');
  const [password, setPassword] = useState('');
  const [showPassword, setShowPassword] = useState(false);
  const [rememberMe, setRememberMe] = useState(false);
  const [error, setError] = useState({ email: '', password: '' });

  const signIn = () => {
    let errors = {};

    if (!email.trim()) {
      errors.email = 'Email is required';
    } else if (!/^\S+@\S+\.\S+$/.test(email)) {
      errors.email = 'Enter a valid email address';
    }

    if (!password.trim()) {
      errors.password = 'Password is required';
    }

    setError(errors);

    if (Object.keys(errors).length === 0) {
      console.log('Login Successful');
      // Proceed with authentication
    }

  };
  const AdminSignup = () => {
    navigation.navigate('SignUp'); 
  };
  const handleForgotPassword = () => {
    navigation.navigate('ForgotPassword'); 
  };

  const toggleShowPassword = () => {
    setShowPassword(!showPassword);
  };

  return (
    <View style={styles.container}>
      <LinearGradient
        colors={['#015185', '#3481BC']}
        style={styles.gradient}
        start={{ x: 0, y: 0 }}
        end={{ x: 1, y: 0 }}
      >
        <SafeAreaView edges={['top']} style={styles.headerSafeArea}>
          <View style={styles.headerContent}>
            <TouchableOpacity onPress={() => navigation.goBack()} style={styles.backButton}>
              <Image
                source={require('../../../Images/adminlogin/back.png')}
                style={styles.backIcon}
              />
            </TouchableOpacity>
            <View style={styles.headerTextContainer}>
              <Text style={styles.welcomeText}>Welcome</Text>
              <Text style={styles.subHeaderText}>Let’s Get You Started With Titan Drilling</Text>
            </View>
          </View>
        </SafeAreaView>
      </LinearGradient>

      <SafeAreaView edges={['bottom']} style={styles.contentSafeArea}>
        <View style={styles.formContainer}>
          <View style={styles.inputContainer}>
            <Text style={styles.inputLabel}>Email</Text>
            <View style={styles.inputWrapper}>
              <Image
                source={require('../../../Images/adminlogin/email.png')}
                style={styles.inputIcon}
              />
              <TextInput
                style={styles.inputWithIcon}
                placeholder="Enter Email Address"
                value={email}
                onChangeText={setEmail}
                keyboardType="email-address"
                autoCapitalize="none"
                placeholderTextColor="#999"
              />
            </View>
            {error.email ? <Text style={styles.errorText}>{error.email}</Text> : null}
          </View>

          <View style={styles.passwordContainer}>
            <Text style={styles.inputLabel}>Password</Text>
            <View style={styles.inputWrapper}>
              <Image
                source={require('../../../Images/adminlogin/key.png')}
                style={styles.inputIcon}
              />
              <TextInput
                style={styles.passwordInput}
                placeholder="Enter Password"
                value={password}
                onChangeText={setPassword}
                secureTextEntry={!showPassword}
                placeholderTextColor="#999"
              />
              <TouchableOpacity
                style={styles.eyeButton}
                onPress={toggleShowPassword}
              >
                <Image
                  source={
                    showPassword
                      ? require('../../../Images/adminlogin/mdi_eye.png')
                      : require('../../../Images/adminlogin/mdi_hide.png')
                  }
                  style={styles.eyeIcon}
                />
              </TouchableOpacity>
              {error.password ? <Text style={styles.errorText}>{error.password}</Text> : null}
            </View>
            <View style={styles.passwordOptions}>
              <View style={styles.rememberMeContainer}>
                <CheckBox
                  value={rememberMe}
                  onValueChange={setRememberMe}
                  tintColors={{ true: '#015185', false: '#999' }}
                  style={{ transform: [{ scaleX: 0.8 }, { scaleY: 0.8 }] }}
                />
                <Text style={styles.rememberMeText}>Remember Me</Text>
              </View>
              <TouchableOpacity onPress={handleForgotPassword}>
                <Text style={styles.forgotPasswordText}>Forgot Password?</Text>
              </TouchableOpacity>
            </View>
          </View>

          <LinearGradient
            colors={['#015185', '#3481BC']}
            start={{ x: 0, y: 0 }}
            end={{ x: 1, y: 0 }}
            style={styles.googleButtonGradient}
          >
            <TouchableOpacity
              style={styles.googleButton}
              onPress={signIn}
            >
              <Text style={styles.googleButtonText}>Sign In Using Password</Text>
            </TouchableOpacity>
          </LinearGradient>

          <View style={styles.dividerContainer}>
            <View style={styles.borderLine} />
          </View>
        </View>
      </SafeAreaView>
    </View>
  );
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: '#fff',
  },
  gradient: {
    width: '100%',
  },
  headerSafeArea: {
    paddingTop: Platform.OS === 'ios' ? 0 : 30,
  },
  headerContent: {
    paddingHorizontal: 30,
    paddingBottom: 15,
  },
  backButton: {
    marginTop: 10,
    marginBottom: 20,
  },
  backIcon: {
    width: 24,
    height: 24,
    tintColor: '#fff',
  },
  welcomeText: {
    fontSize: 24,
    fontWeight: 'bold',
    color: '#fff',
    marginBottom: 5,
  },
  subHeaderText: {
    fontSize: 16,
    color: '#fff',
  },
  contentSafeArea: {
    flex: 1,
    paddingHorizontal: 30,
    paddingTop: 30,
  },
  formContainer: {
    width: '100%',
  },
  inputContainer: {
    marginBottom: 15,
    marginHorizontal: 10,
  },
  passwordContainer: {
    marginBottom: 15,
    marginHorizontal: 10,
  },
  inputWrapper: {
    position: 'relative',
  },
  inputLabel: {
    fontSize: 22,
    color: '#015185',
    marginBottom: 5,
    fontWeight: '500',
  },
  inputWithIcon: {
    height: 50,
    borderWidth: 1,
    borderColor: '#ddd',
    borderRadius: 8,
    // paddingHorizontal: 15,
    paddingLeft: 45,
    fontSize: 16,
    color: '#333',
    width: '100%',
  },
  passwordInput: {
    height: 50,
    borderWidth: 1,
    borderColor: '#ddd',
    borderRadius: 8,
    paddingHorizontal: 15,
    paddingLeft: 45,
    paddingRight: 45,
    fontSize: 16,
    color: '#333',
    width: '100%',
  },
  inputIcon: {
    width: 24,
    height: 24,
    position: 'absolute',
    left: 10,
    top: '50%',
    transform: [{ translateY: -12 }],
    tintColor: '#015185',
  },
  eyeButton: {
    position: 'absolute',
    right: 10,
    top: '50%',
    transform: [{ translateY: -12 }],
  },
  eyeIcon: {
    width: 24,
    height: 24,
    tintColor: '#015185',
  },
  passwordOptions: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    marginTop: 10,
  },
  rememberMeContainer: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  rememberMeText: {
    fontSize: 14,
    color: '#333',
    marginLeft: 5,
  },
  forgotPasswordText: {
    fontSize: 14,
    color: '#015185',
    fontWeight: 'bold',
  },
  googleButtonGradient: {
    borderRadius: 8,
    marginTop: 10,
    marginHorizontal: 10,
  },
  googleButton: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    height: 50,
    borderRadius: 8,
    paddingHorizontal: 15,
    // Removed backgroundColor since it's handled by gradient
  },
  googleButtonText: {
    color: '#fff',
    fontSize: 16,
    fontWeight: 'bold',
  },
  dividerContainer: {
    flexDirection: 'row',
    alignItems: 'center',
    width: '100%',
    marginBottom: 20,
    marginHorizontal: 10,
    marginTop: 20,
  },
  borderLine: {
    flex: 1,
    height: 1,
    backgroundColor: '#888',
    borderStyle: 'dashed',
    borderColor: '#888',
  },
  dividerText: {
    fontSize: 16,
    color: '#888',
    fontWeight: 'bold',
    textAlign: 'center',
    paddingHorizontal: 10,
  },
  errorText: { 
    color: 'red', 
    fontSize: 14, 
    marginTop: 5 
  },
});