// import React, { useState, useRef, useEffect, useCallback } from 'react';
// import {
//   View,
//   Text,
//   StyleSheet,
//   TouchableOpacity,
//   StatusBar,
//   Dimensions,
//   TextInput,
//   ScrollView,
//   Platform,
//   Modal,
//   KeyboardAvoidingView,
//   Alert,
//   Keyboard,
//   Image,
//   ActivityIndicator,
// } from 'react-native';
// import MaterialIcons from 'react-native-vector-icons/MaterialIcons';
// import DateTimePicker from '@react-native-community/datetimepicker';
// import { launchCamera, launchImageLibrary } from 'react-native-image-picker';
// import Toast from 'react-native-toast-message';
// import storage from '@react-native-firebase/storage';
// import database from '@react-native-firebase/database';
// import AsyncStorage from '@react-native-async-storage/async-storage';
// import NetInfo from '@react-native-community/netinfo';
// import { PermissionsAndroid } from 'react-native';
// import DropDownPicker from 'react-native-dropdown-picker';
// import { useNavigation } from '@react-navigation/native';

// const { width, height } = Dimensions.get('window');

// const ALL_POSSIBLE_PROJECTS = [
//   { label: 'Kansanshi', value: 'Kansanshi' },
//   { label: 'Kalumbila', value: 'Kalumbila' },
//   { label: 'Kimteto', value: 'Kimteto' },
//   { label: 'Kobold', value: 'Kobold' },
//   { label: 'FQM Exploration', value: 'FQM Exploration' },
//   { label: 'Mimosa', value: 'Mimosa' },
//   { label: 'Lubumbashi', value: 'Lubumbashi' },
//   { label: 'Musompo', value: 'Musompo' },
//   { label: 'IME', value: 'IME' },
//   { label: 'Kamoa', value: 'Kamoa' },
// ];

// const CustomInputField = ({
//   label,
//   value,
//   onChangeText,
//   isRequired = false,
//   showError = false,
//   errorMessage = '',
//   icon,
//   onIconPress,
//   editable = true,
//   showSelectButton = false,
//   onSelectPress,
//   noBackground = false,
//   noInput = false,
//   onFocus,
//   inputRef,
//   onLayout,
//   secureTextEntry = false,
//   ...props
// }) => {
//   return (
//     <View style={[inputStyles.container, noInput && { marginBottom: width * 0.02 }]} onLayout={onLayout}>
//       {noInput ? (
//         <View style={inputStyles.noInputContainer}>
//           <Text style={inputStyles.label}>
//             {label}
//             {isRequired && <Text style={inputStyles.requiredError}> *</Text>}
//           </Text>
//           <TouchableOpacity style={inputStyles.selectButton} onPress={onSelectPress}>
//             <Text style={inputStyles.selectText}>Select</Text>
//             <MaterialIcons name="arrow-drop-down" size={width * 0.06} color="#333" />
//           </TouchableOpacity>
//         </View>
//       ) : (
//         <>
//           <Text style={inputStyles.label}>
//             {label}
//             {isRequired && <Text style={inputStyles.requiredError}> *</Text>}
//           </Text>
//           <View style={inputStyles.inputContainer}>
//             <TextInput
//               style={[
//                 inputStyles.input,
//                 showError ? inputStyles.inputError : null,
//                 !editable && inputStyles.disabledInput,
//                 noBackground && inputStyles.noBackground,
//               ]}
//               value={value}
//               onChangeText={onChangeText}
//               editable={editable}
//               placeholderTextColor="#888"
//               onFocus={onFocus}
//               ref={inputRef}
//               secureTextEntry={secureTextEntry}
//               {...props}
//             />
//             {icon && (
//               <TouchableOpacity style={inputStyles.inputIcon} onPress={onIconPress}>
//                 {icon}
//               </TouchableOpacity>
//             )}
//             {showSelectButton && (
//               <TouchableOpacity style={inputStyles.selectButton} onPress={onSelectPress}>
//                 <Text style={inputStyles.selectText}>Select</Text>
//                 <MaterialIcons name="arrow-drop-down" size={width * 0.06} color="#333" />
//               </TouchableOpacity>
//             )}
//           </View>
//           {showError && <Text style={inputStyles.errorText}>{errorMessage}</Text>}
//         </>
//       )}
//     </View>
//   );
// };

// const Add_team_member = ({ setActiveStep, teamData, updateTeamData }) => {
//   const navigation = useNavigation();
//   const [department, setDepartment] = useState(teamData?.department || '');
//   const [nrcIdNumber, setNrcIdNumber] = useState(teamData?.nrcIdNumber || '');
//   const [engagementDate, setEngagementDate] = useState(
//     teamData?.engagementDate ? new Date(teamData.engagementDate) : new Date()
//   );
//   const [titanInductionDate, setTitanInductionDate] = useState(
//     teamData?.titanInductionDate ? new Date(teamData.titanInductionDate) : new Date()
//   );
//   const [clientInduction, setClientInduction] = useState(teamData?.clientInduction || '');
//   const [dateExamined, setDateExamined] = useState(
//     teamData?.dateExamined ? new Date(teamData.dateExamined) : new Date()
//   );
//   const [expiryMedicals, setExpiryMedicals] = useState(
//     teamData?.expiryMedicals ? new Date(teamData.expiryMedicals) : new Date()
//   );
//   const [driverLicenseNumber, setDriverLicenseNumber] = useState(teamData?.driverLicenseNumber || '');
//   const [driverLicenseCode, setDriverLicenseCode] = useState(teamData?.driverLicenseCode || '');
//   const [driverLicenseExpiry, setDriverLicenseExpiry] = useState(
//     teamData?.driverLicenseExpiry ? new Date(teamData.driverLicenseExpiry) : new Date()
//   );
//   const [clientDrivingDate, setClientDrivingDate] = useState(
//     teamData?.clientDrivingDate ? new Date(teamData.clientDrivingDate) : new Date()
//   );
//   const [dateCompletedFirstAid, setDateCompletedFirstAid] = useState(
//     teamData?.dateCompletedFirstAid ? new Date(teamData.dateCompletedFirstAid) : new Date()
//   );
//   const [levelFirstAid, setLevelFirstAid] = useState(teamData?.levelFirstAid || '');
//   const [expiryDateFirstAid, setExpiryDateFirstAid] = useState(
//     teamData?.expiryDateFirstAid ? new Date(teamData.expiryDateFirstAid) : new Date()
//   );
//   const [project, setProject] = useState(teamData?.project || []);
//   const [isProjectOpen, setIsProjectOpen] = useState(false);
//   const [uploadModalVisible, setUploadModalVisible] = useState(false);
//   const [currentUploadField, setCurrentUploadField] = useState('');
//   const [isUploading, setIsUploading] = useState(false);
//   const [keyboardHeight, setKeyboardHeight] = useState(0);
//   const [isKeyboardVisible, setIsKeyboardVisible] = useState(false);
//   const [isOnline, setIsOnline] = useState(true);
//   const [inputPositions, setInputPositions] = useState({});
//   const [profilePic, setProfilePic] = useState(teamData?.profilePic || null);
//   const [email, setEmail] = useState(teamData?.email || '');
//   const [password, setPassword] = useState(teamData?.password || '');
//   const [showPassword, setShowPassword] = useState(false);
//   const [emailError, setEmailError] = useState(false);
//   const [emailErrorMessage, setEmailErrorMessage] = useState('');
//   const [passwordError, setPasswordError] = useState(false);
//   const [passwordErrorMessage, setPasswordErrorMessage] = useState('');
//   const [showDatePicker, setShowDatePicker] = useState(false);
//   const [datePickerValue, setDatePickerValue] = useState(new Date());
//   const [currentEditingDateField, setCurrentEditingDateField] = useState('');
//   const [datePickerMaxDate, setDatePickerMaxDate] = useState(null);

//   const scrollViewRef = useRef(null);
//   const inputRefs = {
//     department: useRef(null),
//     nrcIdNumber: useRef(null),
//     clientInduction: useRef(null),
//     driverLicenseNumber: useRef(null),
//     driverLicenseCode: useRef(null),
//     levelFirstAid: useRef(null),
//     email: useRef(null),
//     password: useRef(null),
//   };

//   const showToast = (type, title, message) => {
//     Toast.show({
//       type,
//       text1: title,
//       text2: message,
//       position: 'bottom',
//     });
//   };

//   useEffect(() => {
//     const checkNetwork = async () => {
//       const state = await NetInfo.fetch();
//       setIsOnline(state.isConnected);
//       if (state.isConnected) {
//         syncOfflineData();
//       }
//     };

//     checkNetwork();

//     const unsubscribe = NetInfo.addEventListener((state) => {
//       setIsOnline(state.isConnected);
//       if (state.isConnected) {
//         syncOfflineData();
//       }
//     });

//     const keyboardWillShow = Keyboard.addListener(
//       Platform.OS === 'ios' ? 'keyboardWillShow' : 'keyboardDidShow',
//       (e) => {
//         setKeyboardHeight(e.endCoordinates.height);
//         setIsKeyboardVisible(true);
//       }
//     );

//     const keyboardWillHide = Keyboard.addListener(
//       Platform.OS === 'ios' ? 'keyboardWillHide' : 'keyboardDidHide',
//       () => {
//         setKeyboardHeight(0);
//         setIsKeyboardVisible(false);
//         scrollViewRef.current?.scrollTo({ y: 0, animated: true });
//       }
//     );

//     return () => {
//       unsubscribe();
//       keyboardWillShow.remove();
//       keyboardWillHide.remove();
//     };
//   }, []);

//   const syncOfflineData = async () => {
//     try {
//       const pendingUploads = JSON.parse(await AsyncStorage.getItem('pendingUploads') || '[]');
//       if (pendingUploads.length > 0) {
//         for (const upload of pendingUploads) {
//           const { adminUid, tempId, field, file } = upload;
//           const reference = storage().ref(file.name);
//           await reference.putFile(file.uri);
//           const downloadURL = await reference.getDownloadURL();
//           await database()
//             .ref(`/TeamMember/temp/${adminUid}/${tempId}/${field}`)
//             .set({ url: downloadURL, name: file.name, type: file.type });
//         }
//         await AsyncStorage.setItem('pendingUploads', '[]');
//         showToast('success', 'Sync Success', 'Offline uploads have been synced.');
//       }

//       const pendingTeamData = JSON.parse(await AsyncStorage.getItem('pendingTeamData') || '[]');
//       if (pendingTeamData.length > 0) {
//         for (const data of pendingTeamData) {
//           const { adminUid, tempId, data: teamData } = data;
//           await database()
//             .ref(`/TeamMember/temp/${adminUid}/${tempId}`)
//             .set(teamData);
//         }
//         await AsyncStorage.setItem('pendingTeamData', '[]');
//         showToast('success', 'Sync Success', 'Offline team data has been synced.');
//       }
//     } catch (error) {
//       console.error('Error syncing offline data:', error);
//       showToast('error', 'Sync Error', 'Failed to sync offline data.');
//     }
//   };

//   const requestCameraPermission = async () => {
//     if (Platform.OS === 'android') {
//       try {
//         const granted = await PermissionsAndroid.request(
//           PermissionsAndroid.PERMISSIONS.CAMERA,
//           {
//             title: 'Camera Permission',
//             message: 'This app needs access to your camera to take photos.',
//             buttonPositive: 'OK',
//             buttonNegative: 'Cancel',
//           }
//         );
//         return granted === PermissionsAndroid.RESULTS.GRANTED;
//       } catch (error) {
//         console.error('Error requesting camera permission:', error);
//         showToast('error', 'Error', 'Failed to request camera permission.');
//         return false;
//       }
//     }
//     return true;
//   };

//   const requestStoragePermission = async () => {
//     if (Platform.OS === 'android') {
//       try {
//         const permission = Platform.Version >= 33
//           ? PermissionsAndroid.PERMISSIONS.READ_MEDIA_IMAGES
//           : PermissionsAndroid.PERMISSIONS.READ_EXTERNAL_STORAGE;
//         const granted = await PermissionsAndroid.request(permission, {
//           title: 'Storage Permission',
//           message: 'This app needs access to your storage to select files.',
//           buttonPositive: 'OK',
//           buttonNegative: 'Cancel',
//         });
//         return granted === PermissionsAndroid.RESULTS.GRANTED;
//       } catch (error) {
//         console.error('Error requesting storage permissions:', error);
//         showToast('error', 'Error', 'Failed to request storage permissions.');
//         return false;
//       }
//     }
//     return true;
//   };

//   const handlePickImage = async () => {
//     setIsUploading(true);
//     const hasPermission = await requestStoragePermission();
//     if (!hasPermission) {
//       showToast('error', 'Permission Denied', 'Storage permission is required to pick a file.');
//       setIsUploading(false);
//       return;
//     }

//     try {
//       const result = await launchImageLibrary({ mediaType: 'photo', quality: 0.8 });
//       if (!result.didCancel && !result.errorCode) {
//         const file = result.assets[0];
//         await uploadFile(file, 'image');
//       }
//     } catch (error) {
//       console.error('Error picking image:', error);
//       showToast('error', 'Error', 'Failed to pick image.');
//     } finally {
//       setIsUploading(false);
//       setUploadModalVisible(false);
//     }
//   };

//   const handlePickPDF = async () => {
//     setIsUploading(true);
//     const hasPermission = await requestStoragePermission();
//     if (!hasPermission) {
//       showToast('error', 'Permission Denied', 'Storage permission is required to pick a file.');
//       setIsUploading(false);
//       return;
//     }

//     try {
//       const result = await launchImageLibrary({ mediaType: 'mixed' });
//       if (!result.didCancel && !result.errorCode) {
//         const file = result.assets[0];
//         if (file.type === 'application/pdf') {
//           await uploadFile(file, 'pdf');
//         } else {
//           showToast('error', 'Invalid File', 'Please select a PDF file.');
//         }
//       }
//     } catch (error) {
//       console.error('Error picking PDF:', error);
//       showToast('error', 'Error', 'Failed to pick PDF.');
//     } finally {
//       setIsUploading(false);
//       setUploadModalVisible(false);
//     }
//   };

//   const handleTakePhoto = async () => {
//     setIsUploading(true);
//     const hasPermission = await requestCameraPermission();
//     if (!hasPermission) {
//       showToast('error', 'Permission Denied', 'Camera permission is required to take a photo.');
//       setIsUploading(false);
//       return;
//     }

//     try {
//       const result = await launchCamera({ mediaType: 'photo', quality: 0.8 });
//       if (!result.didCancel && !result.errorCode) {
//         const file = result.assets[0];
//         await uploadFile(file, 'image');
//       }
//     } catch (error) {
//       console.error('Error taking photo:', error);
//       showToast('error', 'Error', 'Failed to take photo.');
//     } finally {
//       setIsUploading(false);
//       setUploadModalVisible(false);
//     }
//   };

//   const uploadFile = async (file, fileType) => {
//     try {
//       const adminUid = await AsyncStorage.getItem('userUid');
//       if (!adminUid) {
//         showToast('error', 'Error', 'Administrator not authenticated.');
//         return;
//       }

//       const tempId = teamData.tempId || `temp_${Date.now()}`;
//       const extension = file.uri.split('.').pop().toLowerCase();
//       const fileName = `teamMembers/${adminUid}/${tempId}/${currentUploadField}/${Date.now()}.${extension}`;
//       const reference = storage().ref(fileName);

//       if (currentUploadField === 'profilePic' && profilePic) {
//         await storage().ref(profilePic.name).delete().catch((err) => console.warn('Error deleting old profile pic:', err));
//       }

//       await reference.putFile(file.uri);
//       const downloadURL = await reference.getDownloadURL();

//       const doc = { uri: file.uri, url: downloadURL, name: fileName, type: fileType };
//       const updatedTeamData = {
//         ...teamData,
//         [currentUploadField]: currentUploadField === 'profilePic' ? doc : [...(teamData[currentUploadField] || []), doc],
//         tempId,
//       };

//       updateTeamData(updatedTeamData);
//       if (currentUploadField === 'profilePic') {
//         setProfilePic(doc);
//       }

//       if (isOnline) {
//         await database()
//           .ref(`/TeamMember/temp/${adminUid}/${tempId}/${currentUploadField}`)
//           .set(currentUploadField === 'profilePic' ? doc : updatedTeamData[currentUploadField]);
//       } else {
//         const pendingUploads = JSON.parse(await AsyncStorage.getItem('pendingUploads') || '[]');
//         pendingUploads.push({
//           adminUid,
//           tempId,
//           field: currentUploadField,
//           file: { uri: file.uri, name: fileName, type: fileType },
//         });
//         await AsyncStorage.setItem('pendingUploads', JSON.stringify(pendingUploads));
//         showToast('info', 'Offline Mode', 'File upload queued. Will sync when online.');
//       }

//       showToast('success', 'Success', 'File uploaded successfully.');
//     } catch (error) {
//       console.error('Error uploading file:', error);
//       showToast('error', 'Error', 'Failed to upload file.');
//       throw error;
//     }
//   };

//   const handleRemoveDocument = async (field, index) => {
//     try {
//       const updatedDocs = Array.isArray(teamData[field]) ? teamData[field].filter((_, i) => i !== index) : null;
//       const updatedTeamData = {
//         ...teamData,
//         [field]: updatedDocs,
//       };
//       updateTeamData(updatedTeamData);

//       if (field === 'profilePic') {
//         setProfilePic(null);
//         if (isOnline && teamData[field]) {
//           await storage().ref(teamData[field].name).delete().catch((err) => console.warn('Error deleting profile pic:', err));
//         }
//       }

//       if (isOnline) {
//         const adminUid = await AsyncStorage.getItem('userUid');
//         const tempId = teamData.tempId;
//         await database()
//           .ref(`/TeamMember/temp/${adminUid}/${tempId}/${field}`)
//           .set(updatedDocs ? updatedDocs : null);
//       }
//       showToast('success', 'Success', 'Document removed successfully.');
//     } catch (error) {
//       console.error('Error removing document:', error);
//       showToast('error', 'Error', 'Failed to remove document.');
//     }
//   };

//   const handleUploadPress = (field) => {
//     setCurrentUploadField(field);
//     setUploadModalVisible(true);
//   };

//   const handleNext = async () => {
//     if (!department.trim()) {
//       showToast('error', 'Validation Error', 'Department is required.');
//       return;
//     }
//     if (!nrcIdNumber.trim()) {
//       showToast('error', 'Validation Error', 'NRC / ID Number is required.');
//       return;
//     }
//     if (!email.trim()) {
//       showToast('error', 'Validation Error', 'Email is required.');
//       return;
//     }
//     if (!password.trim()) {
//       showToast('error', 'Validation Error', 'Password is required.');
//       return;
//     }
//     if (!project.length) {
//       showToast('error', 'Validation Error', 'At least one project must be selected.');
//       return;
//     }
//     if (
//       isNaN(engagementDate.getTime()) ||
//       isNaN(titanInductionDate.getTime()) ||
//       isNaN(dateExamined.getTime()) ||
//       isNaN(expiryMedicals.getTime()) ||
//       isNaN(driverLicenseExpiry.getTime()) ||
//       isNaN(clientDrivingDate.getTime()) ||
//       isNaN(dateCompletedFirstAid.getTime()) ||
//       isNaN(expiryDateFirstAid.getTime())
//     ) {
//       showToast('error', 'Validation Error', 'All dates must be valid.');
//       return;
//     }
//     if (expiryMedicals <= dateExamined) {
//       showToast('error', 'Validation Error', 'Medical Expiry Date must be after Date Examined.');
//       return;
//     }
//     if (driverLicenseExpiry <= engagementDate) {
//       showToast('error', 'Validation Error', "Driver's License Expiry Date must be after Engagement Date.");
//       return;
//     }
//     if (expiryDateFirstAid <= dateCompletedFirstAid) {
//       showToast('error', 'Validation Error', 'First Aid Expiry Date must be after Date Completed.');
//       return;
//     }

//     const isEmailValid = validateEmail(email);
//     const isPasswordValid = validatePassword(password);
//     if (!isEmailValid || !isPasswordValid) {
//       showToast('error', 'Validation Error', 'Please correct all input errors.');
//       return;
//     }

//     try {
//       const adminUid = await AsyncStorage.getItem('userUid');
//       if (!adminUid) {
//         showToast('error', 'Error', 'Administrator not authenticated.');
//         return;
//       }

//       const tempId = teamData.tempId || `temp_${Date.now()}`;
//       const updatedTeamData = {
//         ...teamData,
//         password,
//         department,
//         nrcIdNumber,
//         project,
//         engagementDate: engagementDate.toISOString(),
//         titanInductionDate: titanInductionDate.toISOString(),
//         clientInduction,
//         dateExamined: dateExamined.toISOString(),
//         expiryMedicals: expiryMedicals.toISOString(),
//         driverLicenseNumber,
//         driverLicenseCode,
//         driverLicenseExpiry: driverLicenseExpiry.toISOString(),
//         clientDrivingDate: clientDrivingDate.toISOString(),
//         dateCompletedFirstAid: dateCompletedFirstAid.toISOString(),
//         levelFirstAid,
//         expiryDateFirstAid: expiryDateFirstAid.toISOString(),
//         tempId,
//         profilePic,
//         email,
//       };

//       updateTeamData(updatedTeamData);

//       if (isOnline) {
//         await database()
//           .ref(`/TeamMember/temp/${adminUid}/${tempId}`)
//           .set(updatedTeamData);
//       } else {
//         const pendingTeamData = JSON.parse(await AsyncStorage.getItem('pendingTeamData') || '[]');
//         pendingTeamData.push({ adminUid, tempId, data: updatedTeamData });
//         await AsyncStorage.setItem('pendingTeamData', JSON.stringify(pendingTeamData));
//         showToast('info', 'Offline Mode', 'Data saved locally. Will sync when online.');
//       }

//       setActiveStep(2);
//     } catch (error) {
//       console.error('Error in handleNext:', error);
//       showToast('error', 'Error', 'Failed to save data.');
//     }
//   };

//   const handleBack = () => {
//     Alert.alert(
//       'Confirm Exit',
//       'Are you sure you want to exit? Any unsaved changes will be lost.',
//       [
//         { text: 'Cancel', style: 'cancel' },
//         { text: 'OK', onPress: () => navigation.replace('Team_employment_Home') },
//       ],
//       { cancelable: true }
//     );
//   };

//   const formatDate = (date) => {
//     if (!date || isNaN(date.getTime())) return '';
//     const d = new Date(date);
//     const year = d.getFullYear();
//     const month = String(d.getMonth() + 1).padStart(2, '0');
//     const day = String(d.getDate()).padStart(2, '0');
//     return `${year}-${month}-${day}`;
//   };

//   const onDateChange = (event, selectedDate) => {
//     if (event.type === 'dismissed') {
//       setShowDatePicker(false);
//       return;
//     }

//     const currentDate = selectedDate || datePickerValue;
//     setShowDatePicker(false);
//     setDatePickerValue(currentDate);

//     switch (currentEditingDateField) {
//       case 'engagementDate':
//         setEngagementDate(currentDate);
//         if (currentDate > titanInductionDate) {
//           showToast('error', 'Validation Error', 'Engagement Date must be before Titan Induction Date.');
//         }
//         if (currentDate > driverLicenseExpiry) {
//           showToast('error', 'Validation Error', "Engagement Date must be before Driver's License Expiry.");
//         }
//         break;
//       case 'titanInductionDate':
//         setTitanInductionDate(currentDate);
//         if (currentDate < engagementDate) {
//           showToast('error', 'Validation Error', 'Titan Induction Date must be after Engagement Date.');
//         }
//         break;
//       case 'dateExamined':
//         setDateExamined(currentDate);
//         if (currentDate > expiryMedicals) {
//           showToast('error', 'Validation Error', 'Date Examined must be before Medical Expiry Date.');
//         }
//         break;
//       case 'expiryMedicals':
//         setExpiryMedicals(currentDate);
//         if (currentDate <= dateExamined) {
//           showToast('error', 'Validation Error', 'Medical Expiry Date must be after Date Examined.');
//         }
//         break;
//       case 'driverLicenseExpiry':
//         setDriverLicenseExpiry(currentDate);
//         if (currentDate <= engagementDate) {
//           showToast('error', 'Validation Error', "Driver's License Expiry Date must be after Engagement Date.");
//         }
//         break;
//       case 'clientDrivingDate':
//         setClientDrivingDate(currentDate);
//         break;
//       case 'dateCompletedFirstAid':
//         setDateCompletedFirstAid(currentDate);
//         if (currentDate > expiryDateFirstAid) {
//           showToast('error', 'Validation Error', 'Date Completed must be before First Aid Expiry Date.');
//         }
//         break;
//       case 'expiryDateFirstAid':
//         setExpiryDateFirstAid(currentDate);
//         if (currentDate <= dateCompletedFirstAid) {
//           showToast('error', 'Validation Error', 'First Aid Expiry Date must be after Date Completed.');
//         }
//         break;
//       default:
//         break;
//     }

//     setDatePickerValue(new Date());
//     setCurrentEditingDateField('');
//     setDatePickerMaxDate(null);
//   };

//   const showMode = (currentMode, field) => {
//     setShowDatePicker(true);
//     setCurrentEditingDateField(field);

//     let maxDate = null;
//     if (['titanInductionDate', 'expiryMedicals', 'driverLicenseExpiry', 'expiryDateFirstAid'].includes(field)) {
//       maxDate = null; // Allow future dates
//     } else {
//       maxDate = new Date(); // Restrict to today or past
//     }
//     setDatePickerMaxDate(maxDate);

//     let initialDate = new Date();
//     switch (field) {
//       case 'engagementDate':
//         initialDate = engagementDate ? new Date(engagementDate) : new Date();
//         break;
//       case 'titanInductionDate':
//         initialDate = titanInductionDate ? new Date(titanInductionDate) : new Date();
//         break;
//       case 'dateExamined':
//         initialDate = dateExamined ? new Date(dateExamined) : new Date();
//         break;
//       case 'expiryMedicals':
//         initialDate = expiryMedicals ? new Date(expiryMedicals) : new Date();
//         break;
//       case 'driverLicenseExpiry':
//         initialDate = driverLicenseExpiry ? new Date(driverLicenseExpiry) : new Date();
//         break;
//       case 'clientDrivingDate':
//         initialDate = clientDrivingDate ? new Date(clientDrivingDate) : new Date();
//         break;
//       case 'dateCompletedFirstAid':
//         initialDate = dateCompletedFirstAid ? new Date(dateCompletedFirstAid) : new Date();
//         break;
//       case 'expiryDateFirstAid':
//         initialDate = expiryDateFirstAid ? new Date(expiryDateFirstAid) : new Date();
//         break;
//     }
//     setDatePickerValue(initialDate);
//   };

//   const showDatePickerDialog = (field) => {
//     showMode('date', field);
//   };

//   const handleInputFocus = useCallback(
//     (field) => () => {
//       if (scrollViewRef.current && inputPositions[field] !== undefined) {
//         const scrollPosition = inputPositions[field] - height * 0.1;
//         scrollViewRef.current.scrollTo({ y: scrollPosition, animated: true });
//       }
//     },
//     [inputPositions]
//   );

//   const handleInputLayout = useCallback(
//     (field) => (event) => {
//       const { y } = event.nativeEvent.layout;
//       setInputPositions((prev) => ({ ...prev, [field]: y }));
//     },
//     []
//   );

//   const renderDocumentPreviews = (field) => {
//     const docs = teamData[field] || [];
//     if (docs.length === 0) return null;

//     return (
//       <View style={styles.documentPreviewContainer}>
//         {docs.map((doc, index) => (
//           <View key={index} style={styles.documentPreviewItem}>
//             {doc.type === 'pdf' ? (
//               <View style={styles.pdfIconContainer}>
//                 <MaterialIcons name="picture-as-pdf" size={40} color="#ff4444" />
//               </View>
//             ) : (
//               <Image source={{ uri: doc.uri }} style={styles.documentPreviewImage} />
//             )}
//             <TouchableOpacity
//               style={styles.removeDocumentButton}
//               onPress={() => handleRemoveDocument(field, index)}
//             >
//               <MaterialIcons name="close" size={18} color="#fff" />
//             </TouchableOpacity>
//             <Text style={styles.documentName} numberOfLines={1} ellipsizeMode="middle">
//               {doc.name.split('/').pop()}
//             </Text>
//           </View>
//         ))}
//       </View>
//     );
//   };

//   const renderProfilePicturePreview = () => {
//     if (!profilePic) return null;

//     return (
//       <View style={styles.profilePicturePreview}>
//         <Image source={{ uri: profilePic.uri }} style={styles.profilePictureImage} />
//         <TouchableOpacity
//           style={styles.removePictureButton}
//           onPress={() => handleRemoveDocument('profilePic', 0)}
//         >
//           <MaterialIcons name="close" size={18} color="#fff" />
//         </TouchableOpacity>
//       </View>
//     );
//   };

//   const validateEmail = (email) => {
//     const emailEmpty = !email.trim();
//     const emailInvalid = emailEmpty ? false : !/\S+@\S+\.\S+/.test(email);
//     const emailTooLong = email.length > 40;

//     setEmailError(emailEmpty || emailInvalid || emailTooLong);
//     if (emailEmpty) {
//       setEmailErrorMessage('Email is required');
//     } else if (emailInvalid) {
//       setEmailErrorMessage('Enter a valid email address');
//     } else if (emailTooLong) {
//       setEmailErrorMessage('Email cannot exceed 40 characters');
//     } else {
//       setEmailErrorMessage('');
//     }

//     return !(emailEmpty || emailInvalid || emailTooLong);
//   };

//   const validatePassword = (password) => {
//     const passwordEmpty = !password.trim();
//     const passwordShort = passwordEmpty ? false : password.length < 8;
//     const passwordNoSpecialChar = passwordEmpty ? false : !/[!@#$%^&*(),.?":{}|<>]/.test(password);
//     const passwordTooLong = password.length > 15;

//     setPasswordError(passwordEmpty || passwordShort || passwordNoSpecialChar || passwordTooLong);
//     if (passwordEmpty) {
//       setPasswordErrorMessage('Password is required');
//     } else if (passwordShort) {
//       setPasswordErrorMessage('Password must be at least 8 characters');
//     } else if (passwordNoSpecialChar) {
//       setPasswordErrorMessage('Password needs a special character');
//     } else if (passwordTooLong) {
//       setPasswordErrorMessage('Password cannot exceed 15 characters');
//     } else {
//       setPasswordErrorMessage('');
//     }

//     return !(passwordEmpty || passwordShort || passwordNoSpecialChar || passwordTooLong);
//   };

//   return (
//     <KeyboardAvoidingView
//       style={styles.container}
//       behavior={Platform.OS === 'ios' ? 'padding' : 'height'}
//       keyboardVerticalOffset={Platform.OS === 'ios' ? 100 : 20}
//     >
//       <StatusBar barStyle="dark-content" />
//       <ScrollView
//         ref={scrollViewRef}
//         contentContainerStyle={[styles.content, { paddingBottom: keyboardHeight + 120 }]}
//         showsVerticalScrollIndicator={false}
//         keyboardShouldPersistTaps="handled"
//         keyboardDismissMode="on-drag"
//       >
//         <Text style={styles.sectionTitle}>Employee Profile Picture</Text>
//         <View style={styles.profilePictureContainer}>
//           {renderProfilePicturePreview()}
//           <TouchableOpacity
//             style={[styles.uploadButton, profilePic && styles.replaceButton]}
//             onPress={() => handleUploadPress('profilePic')}
//           >
//             <Text style={styles.uploadButtonText}>{profilePic ? 'Replace Picture' : 'Upload Picture'}</Text>
//             <MaterialIcons name={profilePic ? 'edit' : 'cloud-upload'} size={width * 0.05} color="#fff" />
//           </TouchableOpacity>
//         </View>

//         <Text style={styles.sectionTitle}>Login Details</Text>
//         <CustomInputField
//           label="Email"
//           value={email}
//           onChangeText={(text) => {
//             setEmail(text);
//             validateEmail(text);
//           }}
//           isRequired
//           showError={emailError}
//           errorMessage={emailErrorMessage}
//           inputRef={inputRefs.email}
//           onFocus={handleInputFocus('email')}
//           onLayout={handleInputLayout('email')}
//           keyboardType="email-address"
//         />
//         <CustomInputField
//           label="Password"
//           value={password}
//           onChangeText={(text) => {
//             setPassword(text);
//             validatePassword(text);
//           }}
//           isRequired
//           showError={passwordError}
//           errorMessage={passwordErrorMessage}
//           inputRef={inputRefs.password}
//           onFocus={handleInputFocus('password')}
//           onLayout={handleInputLayout('password')}
//           secureTextEntry={!showPassword}
//           icon={
//             <MaterialIcons
//               name={showPassword ? 'visibility' : 'visibility-off'}
//               size={width * 0.06}
//               color="#333"
//             />
//           }
//           onIconPress={() => setShowPassword(!showPassword)}
//         />

//         <Text style={styles.sectionTitle}>General Details</Text>
//         <CustomInputField
//           label="Department"
//           value={department}
//           placeholder="Department"
//           onChangeText={setDepartment}
//           isRequired
//           inputRef={inputRefs.department}
//           onFocus={handleInputFocus('department')}
//           onLayout={handleInputLayout('department')}
//         />
//         <CustomInputField
//           label="NRC / ID Number"
//           value={nrcIdNumber}
//           placeholder="NRC / ID Number"
//           onChangeText={setNrcIdNumber}
//           isRequired
//           inputRef={inputRefs.nrcIdNumber}
//           onFocus={handleInputFocus('nrcIdNumber')}
//           onLayout={handleInputLayout('nrcIdNumber')}
//         />
//         <View style={styles.inputRow}>
//           <Text style={inputStyles.label}>
//             Project{project.length === 0 && <Text style={inputStyles.requiredError}> *</Text>}
//           </Text>
//           <DropDownPicker
//             open={isProjectOpen}
//             value={project}
//             items={ALL_POSSIBLE_PROJECTS}
//             setOpen={setIsProjectOpen}
//             setValue={setProject}
//             setItems={() => {}} // No-op since items are static
//             multiple={true}
//             mode="BADGE"
//             badgeDotColors={['#015185']}
//             placeholder="Select Projects"
//             style={styles.dropdown}
//             dropDownContainerStyle={styles.dropdownContainer}
//             textStyle={styles.dropdownText}
//             placeholderStyle={styles.placeholderStyle}
//             selectedItemContainerStyle={styles.selectedItemContainer}
//             selectedItemLabelStyle={styles.selectedTextStyle}
//             maxHeight={height * 0.4}
//           />
//         </View>
//         <CustomInputField
//           label="Engagement Date"
//           value={formatDate(engagementDate)}
//           placeholder="Engagement Date"
//           editable={false}
//           icon={<MaterialIcons name="calendar-today" size={width * 0.06} color="#333" />}
//           onIconPress={() => showDatePickerDialog('engagementDate')}
//         />

//         <Text style={styles.sectionTitle}>Titan Induction</Text>
//         <CustomInputField
//           label="Titan Induction Date"
//           value={formatDate(titanInductionDate)}
//           placeholder="Titan Induction Date"
//           editable={false}
//           icon={<MaterialIcons name="calendar-today" size={width * 0.06} color="#333" />}
//           onIconPress={() => showDatePickerDialog('titanInductionDate')}
//         />
//         <CustomInputField
//           label="Client Induction"
//           value={clientInduction}
//           placeholder="Client Induction"
//           onChangeText={setClientInduction}
//           inputRef={inputRefs.clientInduction}
//           onFocus={handleInputFocus('clientInduction')}
//           onLayout={handleInputLayout('clientInduction')}
//         />

//         <Text style={styles.sectionTitle}>Medicals</Text>
//         <CustomInputField
//           label="Date Examined"
//           value={formatDate(dateExamined)}
//           placeholder="Date Examined"
//           editable={false}
//           icon={<MaterialIcons name="calendar-today" size={width * 0.06} color="#333" />}
//           onIconPress={() => showDatePickerDialog('dateExamined')}
//         />
//         <CustomInputField
//           label="Expiry"
//           value={formatDate(expiryMedicals)}
//           placeholder="Expiry"
//           editable={false}
//           icon={<MaterialIcons name="calendar-today" size={width * 0.06} color="#333" />}
//           onIconPress={() => showDatePickerDialog('expiryMedicals')}
//         />
//         <TouchableOpacity
//           style={styles.uploadButton}
//           onPress={() => handleUploadPress('medicalDocs')}
//         >
//           <Text style={styles.uploadButtonText}>Upload Medical Docs</Text>
//           <MaterialIcons name="cloud-upload" size={width * 0.05} color="#fff" />
//         </TouchableOpacity>
//         {renderDocumentPreviews('medicalDocs')}

//         <Text style={styles.sectionTitle}>Driver's License</Text>
//         <CustomInputField
//           label="Number"
//           value={driverLicenseNumber}
//           placeholder="Number"
//           onChangeText={setDriverLicenseNumber}
//           inputRef={inputRefs.driverLicenseNumber}
//           onFocus={handleInputFocus('driverLicenseNumber')}
//           onLayout={handleInputLayout('driverLicenseNumber')}
//         />
//         <CustomInputField
//           label="Code"
//           value={driverLicenseCode}
//           placeholder="Code"
//           onChangeText={setDriverLicenseCode}
//           inputRef={inputRefs.driverLicenseCode}
//           onFocus={handleInputFocus('driverLicenseCode')}
//           onLayout={handleInputLayout('driverLicenseCode')}
//         />
//         <CustomInputField
//           label="Expiry"
//           value={formatDate(driverLicenseExpiry)}
//           placeholder="Expiry"
//           editable={false}
//           icon={<MaterialIcons name="calendar-today" size={width * 0.06} color="#333" />}
//           onIconPress={() => showDatePickerDialog('driverLicenseExpiry')}
//         />
//         <TouchableOpacity
//           style={styles.uploadButton}
//           onPress={() => handleUploadPress('driverLicenseDocs')}
//         >
//           <Text style={styles.uploadButtonText}>Upload License Docs</Text>
//           <MaterialIcons name="cloud-upload" size={width * 0.05} color="#fff" />
//         </TouchableOpacity>
//         {renderDocumentPreviews('driverLicenseDocs')}

//         <Text style={styles.sectionTitle}>Defensive Driving Data</Text>
//         <CustomInputField
//           label="Client Driving Date"
//           value={formatDate(clientDrivingDate)}
//           placeholder="Client Driving Date"
//           editable={false}
//           icon={<MaterialIcons name="calendar-today" size={width * 0.06} color="#333" />}
//           onIconPress={() => showDatePickerDialog('clientDrivingDate')}
//         />
//         <TouchableOpacity
//           style={styles.uploadButton}
//           onPress={() => handleUploadPress('defensiveDrivingDocs')}
//         >
//           <Text style={styles.uploadButtonText}>Upload Driving Docs</Text>
//           <MaterialIcons name="cloud-upload" size={width * 0.05} color="#fff" />
//         </TouchableOpacity>
//         {renderDocumentPreviews('defensiveDrivingDocs')}

//         <Text style={styles.sectionTitle}>First Aid Training</Text>
//         <CustomInputField
//           label="Date Completed"
//           value={formatDate(dateCompletedFirstAid)}
//           placeholder="Date Completed"
//           editable={false}
//           icon={<MaterialIcons name="calendar-today" size={width * 0.06} color="#333" />}
//           onIconPress={() => showDatePickerDialog('dateCompletedFirstAid')}
//         />
//         <CustomInputField
//           label="Level"
//           value={levelFirstAid}
//           placeholder="Level"
//           onChangeText={setLevelFirstAid}
//           inputRef={inputRefs.levelFirstAid}
//           onFocus={handleInputFocus('levelFirstAid')}
//           onLayout={handleInputLayout('levelFirstAid')}
//         />
//         <CustomInputField
//           label="Expiry Date"
//           value={formatDate(expiryDateFirstAid)}
//           placeholder="Expiry Date"
//           editable={false}
//           icon={<MaterialIcons name="calendar-today" size={width * 0.06} color="#333" />}
//           onIconPress={() => showDatePickerDialog('expiryDateFirstAid')}
//         />

//         <View style={{ height: width * 0.4 }} />
//       </ScrollView>

//       <View style={styles.buttonContainer}>
//         <TouchableOpacity
//           style={[styles.button, styles.backButton]}
//           onPress={handleBack}
//         >
//           <Text style={styles.buttonText}>{'<'} Cancel</Text>
//         </TouchableOpacity>
//         <TouchableOpacity style={styles.button} onPress={handleNext}>
//           <Text style={styles.buttonText}>Next {'>'}</Text>
//         </TouchableOpacity>
//       </View>

//       <Modal
//         animationType="slide"
//         transparent={true}
//         visible={showDatePicker}
//         onRequestClose={() => setShowDatePicker(false)}
//         statusBarTranslucent={true}
//       >
//         <View style={styles.datePickerContainer}>
//           <DateTimePicker
//             testID="dateTimePicker"
//             value={datePickerValue}
//             mode="date"
//             display={Platform.OS === 'ios' ? 'inline' : 'default'}
//             onChange={onDateChange}
//             maximumDate={datePickerMaxDate}
//             accentColor="#025383"
//             textColor="#333"
//             style={styles.datePicker}
//           />
//           {Platform.OS === 'ios' && (
//             <TouchableOpacity
//               style={styles.datePickerCloseButton}
//               onPress={() => setShowDatePicker(false)}
//             >
//               <Text style={styles.datePickerCloseText}>Done</Text>
//             </TouchableOpacity>
//           )}
//         </View>
//       </Modal>

//       <Modal
//         visible={uploadModalVisible}
//         transparent
//         animationType="slide"
//         onRequestClose={() => setUploadModalVisible(false)}
//       >
//         <View style={styles.modalOverlay}>
//           <View style={styles.modalContent}>
//             <Text style={styles.modalTitle}>Upload Document</Text>
//             {isUploading ? (
//               <View style={styles.loaderContainer}>
//                 <ActivityIndicator size="large" color="#015185" />
//                 <Text style={styles.loaderText}>Uploading...</Text>
//               </View>
//             ) : (
//               <>
//                 <ScrollView style={styles.uploadList}>
//                   {currentUploadField === 'profilePic' ? (
//                     <>
//                       <TouchableOpacity
//                         style={styles.uploadOption}
//                         onPress={handlePickImage}
//                         disabled={isUploading}
//                       >
//                         <MaterialIcons name="photo-library" size={width * 0.06} color="#333" />
//                         <Text style={styles.uploadOptionText}>Pick Image</Text>
//                       </TouchableOpacity>
//                       <TouchableOpacity
//                         style={styles.uploadOption}
//                         onPress={handleTakePhoto}
//                         disabled={isUploading}
//                       >
//                         <MaterialIcons name="camera-alt" size={width * 0.06} color="#333" />
//                         <Text style={styles.uploadOptionText}>Take Photo</Text>
//                       </TouchableOpacity>
//                     </>
//                   ) : (
//                     <>
//                       <TouchableOpacity
//                         style={styles.uploadOption}
//                         onPress={handlePickImage}
//                         disabled={isUploading}
//                       >
//                         <MaterialIcons name="photo-library" size={width * 0.06} color="#333" />
//                         <Text style={styles.uploadOptionText}>Pick Image</Text>
//                       </TouchableOpacity>
//                       <TouchableOpacity
//                         style={styles.uploadOption}
//                         onPress={handleTakePhoto}
//                         disabled={isUploading}
//                       >
//                         <MaterialIcons name="camera-alt" size={width * 0.06} color="#333" />
//                         <Text style={styles.uploadOptionText}>Take Photo</Text>
//                       </TouchableOpacity>
//                       <TouchableOpacity
//                         style={styles.uploadOption}
//                         onPress={handlePickPDF}
//                         disabled={isUploading}
//                       >
//                         <MaterialIcons name="picture-as-pdf" size={width * 0.06} color="#333" />
//                         <Text style={styles.uploadOptionText}>Pick PDF</Text>
//                       </TouchableOpacity>
//                     </>
//                   )}
//                 </ScrollView>
//                 <TouchableOpacity
//                   style={styles.modalCloseButton}
//                   onPress={() => setUploadModalVisible(false)}
//                   disabled={isUploading}
//                 >
//                   <Text style={styles.modalCloseText}>Cancel</Text>
//                 </TouchableOpacity>
//               </>
//             )}
//           </View>
//         </View>
//       </Modal>

//       <Toast />
//     </KeyboardAvoidingView>
//   );
// };

// const inputStyles = StyleSheet.create({
//   container: {
//     marginBottom: width * 0.04,
//   },
//   label: {
//     fontSize: width * 0.038,
//     color: '#015185',
//     marginBottom: width * 0.01,
//     fontWeight: '500',
//   },
//   requiredError: {
//     color: 'red',
//     fontWeight: 'bold',
//   },
//   inputContainer: {
//     position: 'relative',
//     flexDirection: 'row',
//     alignItems: 'center',
//   },
//   noInputContainer: {
//     flexDirection: 'row',
//     justifyContent: 'space-between',
//     alignItems: 'center',
//     paddingVertical: width * 0.02,
//   },
//   input: {
//     flex: 1,
//     borderWidth: 1,
//     borderColor: '#015185',
//     borderRadius: width * 0.012,
//     paddingHorizontal: width * 0.03,
//     paddingVertical: width * 0.035,
//     fontSize: width * 0.04,
//     backgroundColor: '#fff',
//   },
//   inputError: {
//     borderColor: 'red',
//   },
//   disabledInput: {
//     backgroundColor: '#f5f5f5',
//   },
//   noBackground: {
//     backgroundColor: 'transparent',
//   },
//   errorText: {
//     color: 'red',
//     fontSize: width * 0.032,
//     marginTop: width * 0.005,
//     marginLeft: width * 0.005,
//   },
//   inputIcon: {
//     position: 'absolute',
//     right: width * 0.03,
//     top: '50%',
//     transform: [{ translateY: -width * 0.03 }],
//   },
//   selectButton: {
//     flexDirection: 'row',
//     alignItems: 'center',
//     justifyContent: 'center',
//   },
//   selectText: {
//     fontSize: width * 0.04,
//     color: '#015185',
//     marginRight: width * 0.01,
//   },
// });

// const styles = StyleSheet.create({
//   container: {
//     flex: 1,
//     backgroundColor: '#fff',
//   },
//   content: {
//     padding: width * 0.04,
//     paddingBottom: width * 0.3,
//   },
//   sectionTitle: {
//     fontSize: width * 0.045,
//     fontWeight: 'bold',
//     color: '#025383',
//     marginTop: width * 0.06,
//     marginBottom: width * 0.03,
//   },
//   uploadButton: {
//     backgroundColor: '#3481BC',
//     flexDirection: 'row',
//     alignItems: 'center',
//     justifyContent: 'center',
//     paddingVertical: width * 0.025,
//     paddingHorizontal: width * 0.05,
//     borderRadius: 5,
//     marginTop: width * 0.02,
//     marginBottom: width * 0.04,
//     width: '50%',
//   },
//   replaceButton: {
//     backgroundColor: '#015185',
//   },
//   uploadButtonText: {
//     color: '#fff',
//     fontSize: width * 0.04,
//     fontWeight: '600',
//     marginRight: width * 0.01,
//   },
//   buttonContainer: {
//     flexDirection: 'row',
//     justifyContent: 'space-between',
//     paddingHorizontal: 20,
//     paddingVertical: 10,
//     borderTopWidth: StyleSheet.hairlineWidth,
//     borderTopColor: '#ccc',
//     backgroundColor: '#fff',
//     position: 'absolute',
//     bottom: 0,
//     width: '100%',
//   },
//   button: {
//     backgroundColor: 'transparent',
//     paddingVertical: 8,
//     paddingHorizontal: 15,
//     alignItems: 'center',
//   },
//   backButton: {
//     backgroundColor: 'transparent',
//   },
//   buttonText: {
//     color: '#0078D4',
//     fontSize: 16,
//     fontWeight: 'bold',
//   },
//   modalOverlay: {
//     flex: 1,
//     backgroundColor: 'rgba(0, 0, 0, 0.5)',
//     justifyContent: 'center',
//     alignItems: 'center',
//   },
//   modalContent: {
//     backgroundColor: '#fff',
//     borderRadius: width * 0.025,
//     padding: width * 0.05,
//     width: width * 0.8,
//     maxHeight: height * 0.6,
//   },
//   modalTitle: {
//     fontSize: width * 0.045,
//     fontWeight: 'bold',
//     color: '#333',
//     marginBottom: width * 0.025,
//     textAlign: 'center',
//   },
//   uploadList: {
//     maxHeight: height * 0.4,
//   },
//   uploadOption: {
//     flexDirection: 'row',
//     alignItems: 'center',
//     paddingVertical: width * 0.02,
//   },
//   uploadOptionText: {
//     fontSize: width * 0.04,
//     color: '#333',
//     marginLeft: width * 0.02,
//   },
//   modalCloseButton: {
//     marginTop: width * 0.025,
//     alignItems: 'center',
//   },
//   modalCloseText: {
//     fontSize: width * 0.04,
//     color: '#0078D4',
//     fontWeight: '600',
//   },
//   dropdown: {
//     borderWidth: 1,
//     borderColor: '#015185',
//     borderRadius: 5,
//     backgroundColor: '#fff',
//   },
//   dropdownContainer: {
//     borderWidth: 1,
//     borderColor: '#015185',
//     borderRadius: 5,
//     backgroundColor: '#fff',
//   },
//   dropdownText: {
//     fontSize: 16,
//     color: '#333',
//   },
//   placeholderStyle: {
//     fontSize: 16,
//     color: '#888',
//   },
//   selectedItemContainer: {
//     flexDirection: 'row',
//     justifyContent: 'space-between',
//     alignItems: 'center',
//     padding: 8,
//     backgroundColor: '#f0f0f0',
//     borderRadius: 5,
//     marginVertical: 2,
//   },
//   selectedTextStyle: {
//     fontSize: 16,
//     color: '#333',
//   },
//   loaderContainer: {
//     flex: 1,
//     justifyContent: 'center',
//     alignItems: 'center',
//     paddingVertical: width * 0.1,
//   },
//   loaderText: {
//     fontSize: width * 0.04,
//     color: '#333',
//     marginTop: width * 0.02,
//   },
//   documentPreviewContainer: {
//     flexDirection: 'row',
//     flexWrap: 'wrap',
//     marginTop: width * 0.02,
//     marginBottom: width * 0.04,
//   },
//   documentPreviewItem: {
//     marginRight: width * 0.03,
//     marginBottom: width * 0.03,
//     alignItems: 'center',
//     position: 'relative',
//   },
//   documentPreviewImage: {
//     width: 50,
//     height: 50,
//     borderRadius: 5,
//   },
//   pdfIconContainer: {
//     width: 50,
//     height: 50,
//     justifyContent: 'center',
//     alignItems: 'center',
//   },
//   removeDocumentButton: {
//     position: 'absolute',
//     top: -5,
//     right: -5,
//     backgroundColor: 'red',
//     borderRadius: 10,
//     width: 20,
//     height: 20,
//     alignItems: 'center',
//     justifyContent: 'center',
//   },
//   documentName: {
//     fontSize: width * 0.03,
//     color: '#333',
//     marginTop: 5,
//     maxWidth: 50,
//   },
//   profilePictureContainer: {
//     alignItems: 'center',
//     marginBottom: width * 0.04,
//   },
//   profilePicturePreview: {
//     width: width * 0.25,
//     height: width * 0.25,
//     borderRadius: width * 0.125,
//     overflow: 'hidden',
//     borderWidth: 2,
//     borderColor: '#015185',
//     marginBottom: width * 0.02,
//   },
//   profilePictureImage: {
//     width: '100%',
//     height: '100%',
//     resizeMode: 'cover',
//   },
//   removePictureButton: {
//     position: 'absolute',
//     top: -5,
//     right: -5,
//     backgroundColor: 'red',
//     borderRadius: 10,
//     width: 20,
//     height: 20,
//     alignItems: 'center',
//     justifyContent: 'center',
//   },
//   datePickerContainer: {
//     position: 'absolute',
//     bottom: 0,
//     left: 0,
//     right: 0,
//     backgroundColor: '#fff',
//     borderTopLeftRadius: width * 0.04,
//     borderTopRightRadius: width * 0.04,
//     padding: width * 0.04,
//     elevation: 10,
//     shadowColor: '#000',
//     shadowOffset: { width: 0, height: -2 },
//     shadowOpacity: 0.2,
//     shadowRadius: 5,
//   },
//   datePicker: {
//     width: '100%',
//     backgroundColor: '#f9f9f9',
//   },
//   datePickerCloseButton: {
//     backgroundColor: '#025383',
//     paddingVertical: width * 0.02,
//     borderRadius: width * 0.015,
//     alignItems: 'center',
//     marginTop: width * 0.02,
//   },
//   datePickerCloseText: {
//     fontSize: width * 0.04,
//     color: '#fff',
//     fontWeight: '600',
//   },
//   inputRow: {
//     marginBottom: width * 0.04,
//   },
// });

// export default Add_team_member;


import { View, Text } from 'react-native'
import React from 'react'

const Add_team_member = () => {
  return (
    <View>
      <Text>Add_team_member</Text>
    </View>
  )
}

export default Add_team_member