// Export all email-related modules
export { default as InspectionEmailService } from './InspectionEmailService';
export { default as EmailConfig } from './EmailConfig';

// Export specific configurations and utilities
export {
  EMAIL_CONFIG,
  EMAIL_STYLES,
  EMAIL_SUBJECTS,
  EMAIL_FOOTER,
  EMAIL_HEADER,
  STATUS_COLORS,
  PRIORITY_COLORS,
  LOCATION_MAPPINGS,
  EMAIL_VALIDATION,
  DEFAULT_TEMPLATES
} from './EmailConfig';

// Export utility classes and methods
export { default as InspectionEmailUtil } from './EmailUtils';

// Main service instance
import InspectionEmailService from './InspectionEmailService';
import InspectionEmailUtil from './EmailUtils';
import EmailConfig from './EmailConfig';
export const emailService = InspectionEmailService;

// Convenience functions for common email operations
export const sendInspectionEmails = (reportData, pdfUrl, signatureUrl) => {
  return InspectionEmailService.sendInspectionEmails(reportData, pdfUrl, signatureUrl);
};

export const getEmailStatistics = () => {
  return InspectionEmailService.getEmailStatistics();
};

export const retryFailedEmails = () => {
  return InspectionEmailService.retryFailedEmails();
};

// Default export for backward compatibility
export default {
  InspectionEmailService,
  InspectionEmailUtil,
  EmailConfig,
  emailService,
  sendInspectionEmails,
  getEmailStatistics,
  retryFailedEmails
};
