export const DvirPChecklist = {
  artifact_id: "2aa56fee-59ce-4356-8429-fac734f38ede",
  formTitle: "Driver’s Pre-Trip Release Form",
  fields: {
    date: {
      type: "date",
      label: "Date",
      value: "2025-06-03"
    },
    vehicleRegistration: {
      type: "text",
      label: "Vehicle Registration",
      value: ""
    }
  },
  requirements: {
    type: "checklist",
    label: "Requirements",
    items: [
      { id: "req1", label: "I hold a valid driver’s licence", checked: false },
      { id: "req2", label: "I will obey speed limits and road signs", checked: false },
      { id: "req3", label: "I will not overload the vehicle and ensure the load is secure", checked: false },
      { id: "req4", label: "I have completed the vehicle pre check list and satisfied all is order for my trip", checked: false },
      { id: "req5", label: "I am fit for work – (Not under the influence of alcohol, am well rested, am healthy)", checked: false },
      { id: "req6", label: "I have read and understand the Titan driving procedure, National driving rules and cliental rules", checked: false },
      { id: "req7", label: "I will ensure every passenger and myself wears a seat belt (No unauthorised passengers)", checked: false }
    ]
  },
  hazards: {
    type: "checklist",
    label: "Hazards – Are you aware of:",
    items: [
      { id: "haz1", label: "Pedestrians crossing the road, school children and drunkards", checked: false },
      { id: "haz2", label: "Motor bikes and taxis stopping suddenly or pulling in to the road suddenly", checked: false },
      { id: "haz3", label: "Oncoming vehicles overtaking on blind rises or corners", checked: false },
      { id: "haz4", label: "Heavy trucks or plant taking up width of the road", checked: false },
      { id: "haz5", label: "Riots or unrest", checked: false },
      { id: "haz6", label: "Gravel/Sandy roads can be slippery – Loss of control", checked: false },
      { id: "haz7", label: "Tyre blowouts or punctures – Loss of control", checked: false }
    ]
  },
  authorization: {
    type: "section",
    label: "Authorization and Instructions",
    fields: {
      authorizedBy: {
        type: "text",
        label: "Who has authorized this trip and the vehicle to be used?",
        value: ""
      },
      instructions: {
        type: "textarea",
        label: "What are the instructions given to you?",
        value: ""
      },
      departureTime: {
        type: "time",
        label: "Time instructed to depart",
        value: "18:28"
      },
      returnTime: {
        type: "time",
        label: "Time instructed to return",
        value: ""
      }
    }
  },
  travelNote: {
    type: "note",
    value: "NB. Unless otherwise instructed you are required to leave no earlier than sunrise and arrive at your destination no later than sunset. Failing to arrive then you should park in a safe area for the night. You are required to inform your supervisor on arrival at your destination and the same when you depart."
  },
  passengers: {
    type: "list",
    label: "Passengers’ names authorized to travel with you",
    items: [
      { id: "pass1", label: "Passenger 1", type: "text", value: "" },
      { id: "pass2", label: "Passenger 2", type: "text", value: "" }
    ]
  },
  additionalNote: {
    type: "note",
    value: "No personal business/issues to be conducted unless you have authorization to do so."
  },
  signatures: {
    type: "section",
    label: "Signatures",
    fields: {
      driverName: {
        type: "text",
        label: "Driver’s Name",
        value: ""
      },
      driverSignature: {
        type: "text",
        label: "Driver’s Signature",
        value: ""
      },
      supervisorName: {
        type: "text",
        label: "Supervisor’s Name",
        value: ""
      },
      supervisorSignature: {
        type: "text",
        label: "Supervisor’s Signature",
        value: ""
      }
    }
  }
};
