import React from 'react';
import Signature_Step2 from '../../../MainHome/InspectionReport/CorrectiveAction/Signature_Step2';
import HSECorrectiveActionAPI from '../../../ConfigMongo/HSECorrectiveActionConfig';

const HSECAStep2 = ({
  report,
  navigation,
  subItemStatuses,
  setSubItemStatuses,
  setActiveStep,
  isUpdate = false,
  onRefresh,
}) => {
  const checklistTitle = report?.step1?.checklistTitle || report?.step1?.requestNumber || 'HSE Corrective Action';

  return (
    <Signature_Step2
      report={report}
      navigation={navigation}
      subItemStatuses={subItemStatuses}
      setSubItemStatuses={setSubItemStatuses}
      setActiveStep={setActiveStep}
      isUpdate={isUpdate}
      onRefresh={onRefresh}
      apiClient={HSECorrectiveActionAPI}
      checklistTitleOverride={checklistTitle}
    />
  );
};

export default HSECAStep2;