import React from 'react';
import { Modal, View, TouchableOpacity, Text, StyleSheet, Dimensions } from 'react-native';

const { width } = Dimensions.get('window');

const DropdownMenuModal = ({ visible, options, position, onSelect, onClose }) => {
  if (!visible) return null;
  const DROPDOWN_WIDTH = 180;
  const DROPDOWN_HEIGHT = (options.length || 1) * 44;
  const MARGIN = 12;
  const screenHeight = Dimensions.get('window').height;
  let top = position?.y || 100;
  if (top + DROPDOWN_HEIGHT + MARGIN > screenHeight) {
    top = top - DROPDOWN_HEIGHT - MARGIN;
  }
  const left = (position?.x || 100) - DROPDOWN_WIDTH;

  return (
    <Modal visible={visible} transparent animationType="fade" onRequestClose={onClose}>
      <TouchableOpacity
        style={{ flex: 1, backgroundColor: 'rgba(0,0,0,0.1)' }}
        onPress={onClose}
        activeOpacity={1}
      >
        <View
          style={[
            styles.dropdown,
            {
              position: 'absolute',
              top,
              left,
              width: DROPDOWN_WIDTH,
            },
          ]}
        >
          {options.map(option => (
            <TouchableOpacity
              key={option.value}
              style={styles.optionRow}
              onPress={() => {
                onClose && onClose();
                onSelect && onSelect(option.value);
              }}
            >
              {option.icon}
              <Text style={styles.optionLabel}>{option.label}</Text>
            </TouchableOpacity>
          ))}
        </View>
      </TouchableOpacity>
    </Modal>
  );
};

const styles = StyleSheet.create({
  dropdown: {
    backgroundColor: '#fff',
    borderRadius: 10,
    shadowColor: '#000',
    shadowOffset: { width: 0, height: 4 },
    shadowOpacity: 0.15,
    shadowRadius: 8,
    elevation: 10,
    borderWidth: 1,
    borderColor: '#eee',
    paddingVertical: 4,
    zIndex: 9999,
  },
  optionRow: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingVertical: 12,
    paddingHorizontal: 16,
    borderBottomWidth: 1,
    borderBottomColor: '#f0f0f0',
  },
  optionLabel: {
    fontSize: 16,
    color: '#222',
    fontWeight: '500',
    marginLeft: 14,
  },
});

export default DropdownMenuModal; 