#!/bin/bash

# Sync the entire backend directory to the remote server's /root/node-mongo-api path.

set -euo pipefail

export SSHPASS='5aXBS2f-y/vwM8#'

SOURCE_DIR="$(cd "$(dirname "$0")" && pwd)"
PROJECT_ROOT="$(cd "${SOURCE_DIR}/.." && pwd)"
DATA_SOURCE_DIR="${PROJECT_ROOT}/components/MainHome/AAdataa"
DATA_TARGET_DIR="${SOURCE_DIR}/AAdataa"
TARGET_HOST="root@168.231.113.219"
TARGET_DIR="/root/node-mongo-api"
SSH_OPTS="-o ConnectTimeout=30 -o ServerAliveInterval=60 -o StrictHostKeyChecking=no"

EXCLUDES=(
  "node_modules"
  ".git"
  ".DS_Store"
  "__MACOSX"
  "*.swp"
  "*.tmp"
)

RSYNC_EXCLUDES=()
for pattern in "${EXCLUDES[@]}"; do
  RSYNC_EXCLUDES+=(--exclude "$pattern")
done

echo "Preparing bulk upload data files..."
mkdir -p "${DATA_TARGET_DIR}"

DATA_FILES=(
  "titan-drilling-1f8e9-default-rtdb-admins-export.json"
  "titan-drilling-1f8e9-default-rtdb-GlobalEquipmentJsonData-export.json"
)

for data_file in "${DATA_FILES[@]}"; do
  SRC_FILE="${DATA_SOURCE_DIR}/${data_file}"
  DEST_FILE="${DATA_TARGET_DIR}/${data_file}"

  if [ ! -f "${SRC_FILE}" ]; then
    echo "Error: required data file ${SRC_FILE} not found."
    exit 1
  fi

  cp -f "${SRC_FILE}" "${DEST_FILE}"
  echo "  Copied ${data_file} to backend/AAdataa/"
done

echo "Ensuring remote directory ${TARGET_DIR} exists..."
sshpass -e ssh ${SSH_OPTS} "${TARGET_HOST}" "mkdir -p \"${TARGET_DIR}\""

echo "Uploading backend from ${SOURCE_DIR} to ${TARGET_HOST}:${TARGET_DIR}..."

sshpass -e rsync -av --progress \
  "${RSYNC_EXCLUDES[@]}" \
  -e "ssh ${SSH_OPTS}" \
  "${SOURCE_DIR}/" \
  "${TARGET_HOST}:${TARGET_DIR}/"

echo "Upload complete."

