<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Maintenance Request - {{ $workOrderData['requestNumber'] }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #0055A5;
            padding-bottom: 20px;
        }
        
        .header h1 {
            color: #0055A5;
            margin: 0;
            font-size: 24px;
        }
        
        .header h2 {
            color: #666;
            margin: 5px 0 0 0;
            font-size: 16px;
            font-weight: normal;
        }
        
        .info-section {
            margin-bottom: 25px;
        }
        
        .info-section h3 {
            background-color: #0055A5;
            color: white;
            padding: 8px 12px;
            margin: 0 0 10px 0;
            font-size: 14px;
        }
        
        .info-grid {
            display: table;
            width: 100%;
            border-collapse: collapse;
        }
        
        .info-row {
            display: table-row;
        }
        
        .info-label {
            display: table-cell;
            width: 30%;
            padding: 8px 12px;
            background-color: #f8f9fa;
            border: 1px solid #ddd;
            font-weight: bold;
        }
        
        .info-value {
            display: table-cell;
            padding: 8px 12px;
            border: 1px solid #ddd;
        }
        
        .tasks-section {
            margin-top: 30px;
        }
        
        .task-item {
            margin-bottom: 15px;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        
        .task-title {
            font-weight: bold;
            color: #0055A5;
            margin-bottom: 5px;
        }
        
        .task-details {
            font-size: 11px;
            color: #666;
        }
        
        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }
        
        .priority-badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: bold;
            text-transform: uppercase;
        }
        
        .priority-low { background-color: #d4edda; color: #155724; }
        .priority-medium { background-color: #fff3cd; color: #856404; }
        .priority-high { background-color: #f8d7da; color: #721c24; }
        .priority-emergency { background-color: #f5c6cb; color: #721c24; }
    </style>
</head>
<body>
    <div class="header">
        <h1>Maintenance Request</h1>
        <h2>Request Number: {{ $workOrderData['requestNumber'] }}</h2>
    </div>

    <div class="info-section">
        <h3>Request Information</h3>
        <div class="info-grid">
            <div class="info-row">
                <div class="info-label">Request Number</div>
                <div class="info-value">{{ $workOrderData['requestNumber'] }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Work Order Title</div>
                <div class="info-value">{{ $workOrderData['workOrderTitle'] }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Country</div>
                <div class="info-value">{{ $workOrderData['country'] }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Project</div>
                <div class="info-value">{{ $workOrderData['project'] }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Priority</div>
                <div class="info-value">
                    <span class="priority-badge priority-{{ strtolower($workOrderData['priority'] ?? 'low') }}">
                        {{ $workOrderData['priority'] ?? 'Low' }}
                    </span>
                </div>
            </div>
            <div class="info-row">
                <div class="info-label">Request Type</div>
                <div class="info-value">{{ $workOrderData['requestType'] ?? 'General' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Status</div>
                <div class="info-value">{{ $workOrderData['status'] ?? 'Initiated' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Created Date</div>
                <div class="info-value">{{ \Carbon\Carbon::parse($workOrderData['createdAt'])->format('d/m/Y H:i') }}</div>
            </div>
        </div>
    </div>

    @if($workOrderData['memo'])
    <div class="info-section">
        <h3>Memo</h3>
        <div style="padding: 10px; background-color: #f8f9fa; border: 1px solid #ddd; border-radius: 4px;">
            {{ $workOrderData['memo'] }}
        </div>
    </div>
    @endif

    @if($workOrderData['vehicle'])
    <div class="info-section">
        <h3>Vehicle Information</h3>
        <div class="info-grid">
            <div class="info-row">
                <div class="info-label">Equipment Name</div>
                <div class="info-value">{{ $workOrderData['vehicle']['equipmentName'] ?? 'N/A' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Equipment Number</div>
                <div class="info-value">{{ $workOrderData['vehicle']['equipmentNumber'] ?? 'N/A' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Model</div>
                <div class="info-value">{{ $workOrderData['vehicle']['model'] ?? 'N/A' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Meter Reading</div>
                <div class="info-value">{{ $workOrderData['vehicle']['meterReading'] ?? '0' }} {{ $workOrderData['vehicle']['meterUnit'] ?? 'KM' }}</div>
            </div>
            <div class="info-row">
                <div class="info-label">Status</div>
                <div class="info-value">{{ $workOrderData['vehicle']['status'] ?? 'N/A' }}</div>
            </div>
        </div>
    </div>
    @endif

    @if(!empty($workOrderData['assignTo']))
    <div class="info-section">
        <h3>Assigned To</h3>
        <div style="padding: 10px; background-color: #f8f9fa; border: 1px solid #ddd; border-radius: 4px;">
            @foreach($workOrderData['assignTo'] as $assignee)
                <div style="margin-bottom: 5px;">
                    <strong>{{ $assignee['fullName'] }}</strong>
                    @if(isset($assignee['employeeNumber']))
                        ({{ $assignee['employeeNumber'] }})
                    @endif
                    @if(isset($assignee['role']))
                        - {{ $assignee['role'] }}
                    @endif
                </div>
            @endforeach
        </div>
    </div>
    @endif

    @if(!empty($workOrderData['tasks']))
    <div class="tasks-section">
        <h3>Tasks</h3>
        @foreach($workOrderData['tasks'] as $index => $task)
        <div class="task-item">
            <div class="task-title">Task {{ $index + 1 }}: {{ $task['title'] }}</div>
            <div class="task-details">
                <strong>Type:</strong> {{ $task['description'] ?? 'Repair' }}<br>
                @if(!empty($task['assignees']))
                <strong>Assigned to:</strong> {{ implode(', ', array_column($task['assignees'], 'fullName')) }}<br>
                @endif
                @if(!empty($task['note']))
                <strong>Note:</strong> {{ $task['note'] }}
                @endif
            </div>
        </div>
        @endforeach
    </div>
    @endif

    <div class="footer">
        <p>This document was generated on {{ \Carbon\Carbon::now()->format('d/m/Y H:i') }}</p>
        <p>Titan Drilling - Maintenance Request System</p>
    </div>
</body>
</html>
