@extends('welcome')

@section('title', 'Workorder')

@section('styles')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
@endsection

@php
    function getStatusColor($status) {
        $status = strtolower($status);
        switch ($status) {
            case 'completed':
            case 'closed':
                return 'success';
            case 'in progress':
            case 'processing':
                return 'primary';
            case 'on hold':
                return 'warning';
            case 'initiated':
                return 'info';
            case 'rework':
                return 'danger';
            case 'archived': 
            case 'cancelled':
                return 'secondary';
            default:
                return 'info';
        }
    }

    function getPriorityColor($priority) {
        $priority = strtolower($priority);
        switch ($priority) {
            case 'high':
            case 'urgent':
                return 'danger';
            case 'medium':
                return 'warning';
            case 'low':
                return 'success';
            default:
                return 'secondary';
        }
    }
@endphp

@section('content')
<div class="workorder-container">
    <!-- Header -->
    <div class="header-gradient">
        <div class="header-content">
            <div class="header-left">
                <a href="javascript:history.back()" class="back-button">
                    <i class="fas fa-arrow-left"></i>
                </a>
                <h1 class="header-title">Workorders</h1>
            </div>
            <div class="header-right">
                <div class="search-container">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="search-icon">
                        <circle cx="11" cy="11" r="8"/>
                        <path d="M21 21l-4.35-4.35"/>
                    </svg>
                    <input type="text" class="search-input" placeholder="Search workorders..." id="globalSearchInput">
                </div>
                <a href="{{ route('maintenance.workorders.create') }}" class="create-btn">
                    <i class="fas fa-plus"></i>
                    Create Workorder
                </a>
            </div>
        </div>
    </div>
    <!-- Main Content -->
    <div class="main-content">
        <div class="workorder-content">
            <div class="tab-navigation">
                <div class="tab-list">
                    <button class="tab-btn active" data-tab="open">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                            <polyline points="14,2 14,8 20,8"/>
                            <line x1="16" y1="13" x2="8" y2="13"/>
                            <line x1="16" y1="17" x2="8" y2="17"/>
                            <polyline points="10,9 9,9 8,9"/>
                        </svg>
                        <span>Open</span>
                    </button>
                    <button class="tab-btn" data-tab="completed">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
                            <polyline points="22,4 12,14.01 9,11.01"/>
                        </svg>
                        <span>Completed</span>
                    </button>
                    <button class="tab-btn" data-tab="archive">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <polyline points="21,8 21,21 3,21 3,8"/>
                            <rect x="1" y="3" width="22" height="5"/>
                            <line x1="10" y1="12" x2="14" y2="12"/>
                        </svg>
                        <span>Archive</span>
                    </button>
                </div>
            </div>
        <div class="tab-content">
            <div id="open" class="tab-pane active">
                <div class="table-section">
                    <div class="table-container">
                        <div id="openTableLoader" class="table-loader" aria-live="polite" aria-busy="true">
                            <div class="table-loader-content">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                                <p class="loader-text">Fetching workorders...</p>
                            </div>
                        </div>
                        <table class="workorder-table">
                            <thead class="table-header">
                                <tr>
                                    <th style="width: 50px;">S.No</th>
                                    <th>Action</th>
                                    <th>WO Number</th>
                                    <th>Created Date</th>
                                    <th>Vehicle</th>
                                    <th>Due Date</th>
                                    <th>Status</th>
                                    <th>Priority</th>
                                    <th>Assigned</th>
                                    <th>Memo</th>
                                </tr>
                            </thead>
                            <tbody class="table-body" id="openTableBody">
                                <tr class="empty-row">
                                    <td colspan="10" class="empty-state">
                                        <div class="empty-content">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
                                                <circle cx="12" cy="12" r="10"/>
                                                <path d="M12 6v6l4 2"/>
                                            </svg>
                                            <h3>No Data Available</h3>
                                            <p>No ${tabName} work orders found.</p>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination Controls -->
                    <div class="pagination-container" id="openPagination" style="display: none;">
                        <div class="pagination-info">
                            <span id="openPaginationInfo">Showing 1-10 of 0 work orders</span>
                        </div>
                        <div class="pagination-controls">
                            <button class="pagination-btn" id="openPrevBtn" type="button" disabled>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="15,18 9,12 15,6"/>
                                </svg>
                                Previous
                            </button>
                            <div class="pagination-pages" id="openPageNumbers">
                                <!-- Page numbers will be generated dynamically -->
                            </div>
                            <button class="pagination-btn" id="openNextBtn" type="button" disabled>
                                Next
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="9,18 15,12 9,6"/>
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            <div id="completed" class="tab-pane">
                <div class="table-section">
                    <div class="table-container">
                        <div id="completedTableLoader" class="table-loader" aria-live="polite" aria-busy="true">
                            <div class="table-loader-content">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                                <p class="loader-text">Fetching workorders...</p>
                            </div>
                        </div>
                        <table class="workorder-table">
                            <thead class="table-header">
                                <tr>
                                    <th style="width: 50px;">S.No</th>
                                    <th>Action</th>
                                    <th>WO Number</th>
                                    <th>Created Date</th>
                                    <th>Vehicle</th>
                                    <th>Completed Date</th>
                                    <th>Status</th>
                                    <th>Priority</th>
                                    <th>Assigned</th>
                                    <th>Memo</th>
                                </tr>
                            </thead>
                            <tbody class="table-body" id="completedTableBody">
                                <tr class="empty-row">
                                    <td colspan="10" class="empty-state">
                                        <div class="empty-content">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
                                                <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
                                                <polyline points="22,4 12,14.01 9,11.01"/>
                                            </svg>
                                            <h3>No Completed Workorders</h3>
                                            <p>Completed workorders will appear here once available.</p>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
            <div id="archive" class="tab-pane">
                
                <div class="table-section">
                    <div class="table-container">
                        <div id="archiveTableLoader" class="table-loader" aria-live="polite" aria-busy="true">
                            <div class="table-loader-content">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                                <p class="loader-text">Fetching workorders...</p>
                            </div>
                        </div>
                        <table class="workorder-table">
                            <thead class="table-header">
                                <tr>
                                    <th style="width: 50px;">S.No</th>
                                    <th>Action</th>
                                    <th>WO Number</th>
                                    <th>Created Date</th>
                                    <th>Vehicle</th>
                                    <th>Completed Date</th>
                                    <th>Status</th>
                                    <th>Priority</th>
                                    <th>Assigned</th>
                                    <th>Memo</th>
                                </tr>
                            </thead>
                            <tbody class="table-body" id="archiveTableBody">
                                <tr class="empty-row">
                                    <td colspan="10" class="empty-state">
                                        <div class="empty-content">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
                                                <polyline points="21,8 21,21 3,21 3,8"/>
                                                <rect x="1" y="3" width="22" height="5"/>
                                                <line x1="10" y1="12" x2="14" y2="12"/>
                                            </svg>
                                            <h3>No Archived Workorders</h3>
                                            <p>Archived workorders will appear here when available.</p>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
    
    <!-- Task List popup -->
    <div class="modal search-popup" id="task-list">
        <div class="modal-dialog" style="">
            <div class="modal-content">
                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">Select Task</h4>
                </div>
                <!-- Modal body -->
                <div class="modal-body">
                    <form class="form-inline" action="">
                        <div class="input-group">
                            <div class="input-group-text br-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                    <path fill="currentColor" d="M15.5 14h-.79l-.28-.27A6.47 6.47 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14" />
                                </svg>
                            </div>
                            <input type="text" class="form-control" placeholder="Search">
                        </div>
                        <span class="empty-data">No Data</span>
                        <div class="row my-3 align-items-center justify-content-center">
                            <button type="button" class="save btn btn-danger" data-bs-dismiss="modal">Select</button>
                            <!-- Modal footer -->
                            <div class="modal-footer col-md-4 p-0 w-auto">
                                <button type="button" class="save btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 24 24">
                                        <path fill="currentColor" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                                    </svg>Cancel</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
</div>
<!-- Sorting Popup modals -->
<div class="modal" id="sorting">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Sorting</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form action="">
                    <form action="">
                        <h1>Sort Order</h1>
                        <div class="form-check">
                            <input type="radio" class="form-check-input" id="radio1" name="optradio" value="Ascending" checked>
                            <label class="form-check-label" for="radio1">Ascending</label>
                        </div>
                        <div class="form-check">
                            <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Descending">
                            <label class="label" for="radio2">Descending</label>
                        </div>
                    </form>
                    <h1>Sort By</h1>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio1" name="optradio" value="Report Number" checked>
                        <label class="form-check-label" for="radio1">WO Number</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Start Date">
                        <label class="form-check-label" for="radio2">Created Date</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Vehicle Number">
                        <label class="form-check-label" for="radio2">Vehicle Number</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Start Date">
                        <label class="form-check-label" for="radio2">Status</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Vehicle Number">
                        <label class="form-check-label" for="radio2">Priority</label>
                    </div>
                    <div class="row my-3 align-items-center justify-content-center">
                        <button type="submit" class="save btn btn-danger col-md-4 mx-2">Ok</button>
                        <button type="reset" class="save btn btn-danger col-md-4 mx-2">Reset</button>
                        <!-- Modal footer -->
                        <div class="modal-footer col-md-4 p-0">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- filter Popup modals -->
<div class="modal" id="filter">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Filter</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form action="">
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio1" name="optradio" value="Ascending">
                        <label class="form-check-label" for="radio1">Initiated</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Descending">
                        <label class="form-check-label" for="radio2">In Progress</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio1" name="optradio" value="Report Number">
                        <label class="form-check-label" for="radio1">On Hold</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Start Date">
                        <label class="form-check-label" for="radio2">Complete</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Vehicle Number">
                        <label class="form-check-label" for="radio2">Rework</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Vehicle Number" checked>
                        <label class="form-check-label" for="radio2">(Not Filtered)</label>
                    </div>
                    <div class="row my-3 align-items-center justify-content-center">
                        <button type="submit" class="save btn btn-danger col-md-4 mx-2">Ok</button>
                        <button type="reset" class="save btn btn-danger col-md-4 mx-2">Reset</button>
                        <!-- Modal footer -->
                        <div class="modal-footer col-md-4 p-0">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

</div>

</script>

<style>
/* CSS Variables for consistent theming */
:root {
    --primary-color: #0055a5;
    --primary-hover: #003f7d;
    --secondary-color: #6c757d;
    --secondary-hover: #5a6268;
    --success-color: #28a745;
    --success-hover: #218838;
    --warning-color: #ffc107;
    --warning-hover: #e0a800;
    --danger-color: #dc3545;
    --danger-hover: #c82333;
    --info-color: #17a2b8;
    --info-hover: #138496;
    --text-primary: #212529;
    --text-secondary: #6c757d;
    --text-muted: #6b7280;
    --text-light: #ffffff;
    --bg-primary: #ffffff;
    --bg-secondary: #f8f9fa;
    --bg-light: #f8fafc;
    --bg-hover: #e9ecef;
    --border-color: #dee2e6;
    --border-light: #e2e8f0;
    --shadow-sm: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    --shadow-md: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    --shadow-lg: 0 1rem 3rem rgba(0, 0, 0, 0.175);
    --radius-sm: 0.25rem;
    --radius-md: 0.375rem;
    --radius-lg: 0.5rem;
    --transition-base: all 0.15s ease-in-out;
    --transition-slow: all 0.3s ease-in-out;
    --font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    --z-index-modal: 1050;
    --z-index-dropdown: 1000;
}

/* Import Google Fonts for better typography */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* ===== WORKORDER CONTAINER ===== */
.workorder-container {
    min-height: 100vh;
    background: var(--bg-light);
}

/* ===== HEADER STYLES ===== */
.header-gradient {
    background: #0055a5;
    padding: 20px 0;
    box-shadow: 0 4px 12px rgba(0, 85, 165, 0.3);
}

.header-content {
    width: 100%;
    padding: 0 20px;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.header-left {
    display: flex;
    align-items: center;
    gap: 15px;
}

.back-button {
    color: white;
    font-size: 20px;
    text-decoration: none;
    padding: 8px;
    border-radius: 50%;
    transition: var(--transition-base);
}

.back-button:hover {
    background-color: rgba(255, 255, 255, 0.1);
    color: white;
}

.header-title {
    color: white;
    font-size: 28px;
    font-weight: 700;
    margin: 0;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 15px;
}

.create-btn {
    background: white;
    color: var(--primary-color);
    border: none;
    padding: 12px 24px;
    border-radius: var(--radius-md);
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: var(--transition-base);
    box-shadow: var(--shadow-sm);
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

.create-btn:hover {
    background: rgba(255, 255, 255, 0.9);
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
    color: var(--primary-color);
    text-decoration: none;
}

/* Search Container */
.search-container {
    position: relative;
    display: flex;
    align-items: center;
}

.search-icon {
    position: absolute;
    left: 12px;
    color: #9ca3af;
    z-index: 1;
}

.search-input {
    padding: 10px 12px 10px 40px;
    border: 1px solid #d1d5db;
    border-radius: var(--radius-md);
    font-size: 14px;
    font-weight: 400;
    color: #374151;
    background: white;
    width: 300px;
    transition: all 0.2s ease;
}

.search-input:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.search-input::placeholder {
    color: #9ca3af;
}

/* Main Content */
.main-content {
    width: 100%;
    padding: 30px 20px;
    padding-bottom: 300px;
}

/* ===== CONTENT SECTION ===== */
.workorder-content {
    background: var(--bg-primary);
    border-radius: 0;
    box-shadow: var(--shadow-md);
    border: 1px solid var(--border-light);
    overflow: hidden;
}

/* ===== TAB NAVIGATION ===== */
.tab-navigation {
    background: var(--bg-light);
    border-bottom: 1px solid var(--border-light);
    padding: 0;
}

.tab-list {
    display: flex;
    gap: 0;
}

.tab-btn {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 16px 24px;
    background: transparent;
    border: none;
    color: var(--text-muted);
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
    border-radius: 0;
    position: relative;
}

.tab-btn:hover {
    background: rgba(0, 85, 165, 0.05);
    color: var(--primary-color);
}

.tab-btn.active {
    background: var(--bg-primary);
    color: var(--primary-color);
    border-bottom: 2px solid var(--primary-color);
}

.tab-btn svg {
    flex-shrink: 0;
}

/* ===== TAB CONTENT ===== */
.tab-content {
    position: relative;
}

.tab-pane {
    display: none;
    padding: 0;
}

.tab-pane.active {
    display: block;
}

/* ===== ACTION BAR ===== */
.action-bar {
    background: var(--bg-light);
    border-bottom: 1px solid var(--border-light);
    padding: 20px 24px;
}

.action-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 20px;
}

.search-section {
    flex: 1;
    max-width: 400px;
}

.search-container {
    position: relative;
    display: flex;
    align-items: center;
}

.search-icon {
    position: absolute;
    left: 12px;
    color: var(--text-muted);
    z-index: 1;
}

.search-input {
    width: 100%;
    padding: 12px 12px 12px 44px;
    border: 1px solid var(--border-color);
    border-radius: 0;
    font-size: 14px;
    font-weight: 400;
    background: var(--bg-primary);
    transition: var(--transition-base);
}

.search-input:focus {
    outline: none;
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(0, 85, 165, 0.1);
}

.action-buttons {
    display: flex;
    align-items: center;
    gap: 12px;
}

.action-buttons button {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 10px 16px;
    border: 1px solid var(--border-color);
    border-radius: 0;
    background: var(--bg-primary);
    color: var(--text-primary);
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
}

.action-buttons button:hover {
    background: var(--bg-hover);
    border-color: var(--text-muted);
    transform: translateY(-1px);
}

.btn-create {
    background: var(--primary-color) !important;
    color: var(--text-light) !important;
}

.btn-create:hover {
    background: var(--primary-hover) !important;
    transform: translateY(-2px) !important;
    box-shadow: var(--shadow-md) !important;
    color: var(--text-light) !important;
}

.btn-sort {
    background: var(--secondary-color) !important;
    color: var(--text-light) !important;
}

.btn-sort:hover {
    background: var(--secondary-hover) !important;
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
    color: var(--text-light);
}

.btn-filter {
    background: var(--warning-color) !important;
    color: var(--text-light) !important;
}

.btn-filter:hover {
    background: var(--warning-hover) !important;
    transform: translateY(-2px) !important;
    box-shadow: var(--shadow-md) !important;
    color: var(--text-light) !important;
}

.btn-export {
    background: var(--success-color) !important;
    color: var(--text-light) !important;
}

.btn-export:hover {
    background: var(--success-hover) !important;
    transform: translateY(-2px) !important;
    box-shadow: var(--shadow-md) !important;
    color: var(--text-light) !important;
}

/* ===== TABLE SECTION ===== */
.table-section {
    background: white;
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-md);
    border: 1px solid var(--border-light);
    overflow: visible;
    margin-bottom: 24px;
}

.table-container {
    position: relative;
    overflow-x: auto;
    overflow-y: auto;
    border-radius: var(--radius-md);
    border: 1px solid var(--border-light);
    padding-bottom: 400px;
    background: var(--bg-primary);
}

.workorder-table {
    width: 100%;
    min-width: 1100px;
    border-collapse: collapse;
    background: var(--bg-primary);
}

.table-loader {
    position: absolute;
    inset: 0;
    background: rgba(255, 255, 255, 0.9);
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 10;
    flex-direction: column;
    gap: 12px;
}

.table-loader-content {
    text-align: center;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 12px;
}

.loader-text {
    margin: 0;
    font-size: 14px;
    color: var(--text-secondary);
}

.table-loading-state {
    opacity: 0.4;
    pointer-events: none;
}

.spinner-border {
    width: 3rem;
    height: 3rem;
    color: var(--primary-color);
}

.table-header {
    background: var(--bg-light);
}

.table-header th {
    padding: 16px 12px;
    text-align: left;
    font-size: 14px;
    font-weight: 600;
    color: var(--text-primary);
    border-bottom: 1px solid var(--border-light);
    border-radius: 0;
}

.table-body {
    background: var(--bg-primary);
}

.table-row {
    border-bottom: 1px solid var(--border-light);
    transition: var(--transition-base);
}

.table-row:hover {
    background: var(--bg-light);
}

.table-row td {
    padding: 16px 12px;
    font-size: 14px;
    color: var(--text-primary);
    vertical-align: middle;
}

.btn-view {
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    background: var(--primary-color);
    color: var(--text-light);
    border: none;
    border-radius: 0;
    font-size: 12px;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
    box-shadow: 0 2px 4px rgba(0, 85, 165, 0.2);
}

.btn-view:hover {
    background: var(--primary-hover);
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

/* ===== DROPDOWN STYLES ===== */
.dropdown {
    position: relative;
    display: inline-block;
}

.dropdown .action-btn {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 8px 16px;
    background: var(--primary-color);
    color: white;
    border: none;
    border-radius: 0;
    font-size: 12px;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
    text-transform: uppercase;
    letter-spacing: 0.04em;
}

.dropdown .action-btn:hover {
    background: rgba(0, 85, 165, 0.85);
    transform: translateY(-1px);
    box-shadow: var(--shadow-sm);
    color: white !important;
}

.dropdown-menu {
    position: absolute;
    top: calc(100% + 8px);
    left: 0;
    right: auto;
    background: white;
    border: 1px solid var(--border-light);
    box-shadow: var(--shadow-md);
    border-radius: var(--radius-md);
    padding: 8px 0;
    min-width: 220px;
    z-index: 1000;
    display: none;
    list-style: none;
    margin: 0;
}

.dropdown-menu.show {
    display: block;
}

.dropdown-item {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 12px 18px;
    color: var(--text-primary);
    text-decoration: none;
    font-size: 13px;
    font-weight: 400;
    transition: var(--transition-base);
    border-radius: var(--radius-sm);
    background: transparent;
    width: 100%;
    border: none;
    text-align: left;
    cursor: pointer;
}

.dropdown-item:hover {
    background: rgba(0, 85, 165, 0.08);
    color: var(--primary-color);
    transform: translateX(4px);
}

.dropdown-item svg {
    min-width: 14px;
}

.dropdown-item.danger {
    color: var(--danger-color);
}

.dropdown-item.danger:hover {
    background: #f8d7da;
    color: #721c24;
}

.dropdown-divider {
    height: 1px;
    background: var(--border-color);
    margin: 8px 0;
}

/* Delete confirmation modal */
.confirmation-overlay {
    position: fixed;
    inset: 0;
    background: rgba(15, 23, 42, 0.45);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 11000;
    padding: 16px;
}

.confirmation-dialog {
    background: #ffffff;
    border-radius: 12px;
    box-shadow: 0 20px 40px rgba(15, 23, 42, 0.2);
    max-width: 420px;
    width: 100%;
    padding: 24px;
    display: flex;
    flex-direction: column;
    gap: 16px;
}

.confirmation-dialog h3 {
    margin: 0;
    font-size: 20px;
    font-weight: 600;
    color: #111827;
}

.confirmation-dialog p {
    margin: 0;
    font-size: 14px;
    line-height: 1.5;
    color: #4b5563;
}

.confirmation-actions {
    display: flex;
    justify-content: flex-end;
    gap: 12px;
    margin-top: 8px;
}

.confirmation-actions button {
    min-width: 110px;
    border-radius: 8px;
    border: none;
    padding: 10px 16px;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
}

.confirmation-actions .confirm-btn {
    background: #dc2626;
    color: #ffffff;
}

.confirmation-actions .confirm-btn:hover {
    background: #b91c1c;
}

.confirmation-actions .cancel-btn {
    background: #f3f4f6;
    color: #1f2937;
}

.confirmation-actions .cancel-btn:hover {
    background: #e5e7eb;
}

/* PDF Viewer Modal */
.pdf-modal-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.8);
    display: none;
    justify-content: center;
    align-items: center;
    z-index: 10000;
}

.pdf-modal-overlay.active {
    display: flex;
}

.pdf-modal-container {
    background: white;
    width: 90%;
    height: 90%;
    max-width: 1200px;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
    display: flex;
    flex-direction: column;
}

.pdf-modal-header {
    background: #0055A5;
    color: white;
    padding: 20px 24px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.pdf-modal-title {
    font-size: 20px;
    font-weight: 600;
    margin: 0;
}

.pdf-modal-close {
    background: none;
    border: none;
    color: white;
    font-size: 28px;
    cursor: pointer;
    padding: 0;
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 4px;
    transition: background 0.2s ease;
}

.pdf-modal-close:hover {
    background: rgba(255, 255, 255, 0.1);
}

.pdf-modal-body {
    flex: 1;
    padding: 0;
    overflow: hidden;
}

.pdf-frame {
    width: 100%;
    height: 100%;
    border: none;
}

.pdf-loading {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    height: 100%;
    gap: 16px;
}

.pdf-loading-spinner {
    width: 48px;
    height: 48px;
    border: 4px solid #e2e8f0;
    border-top-color: #0055A5;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

.pdf-loading-text {
    color: #64748b;
    font-size: 16px;
    font-weight: 500;
}

.wo-number {
    font-weight: 600;
    color: var(--primary-color);
}

.memo-text {
    max-width: 200px;
    overflow: hidden;
    text-overflow: ellipsis;
    white-space: nowrap;
}

/* ===== STATUS BADGES ===== */
.status-badge {
    display: inline-flex;
    align-items: center;
    padding: 4px 12px;
    font-size: 12px;
    font-weight: 500;
    border-radius: 0;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.status-success {
    background: var(--success-color);
    color: var(--text-light);
}

.status-primary {
    background: var(--primary-color);
    color: var(--text-light);
}

.status-warning {
    background: var(--warning-color);
    color: var(--text-light);
}

.status-info {
    background: var(--info-color);
    color: var(--text-light);
}

.status-danger {
    background: var(--danger-color);
    color: var(--text-light);
}

.status-secondary {
    background: var(--secondary-color);
    color: var(--text-light);
}

/* ===== PRIORITY BADGES ===== */
.priority-badge {
    display: inline-flex;
    align-items: center;
    padding: 4px 12px;
    font-size: 12px;
    font-weight: 500;
    border-radius: 0;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.priority-danger {
    color: var(--danger-color);
}

.priority-warning {
    color: var(--warning-color);
}

.priority-success {
    color: var(--success-color);
}

.priority-secondary {
    background: var(--secondary-color);
    color: var(--text-light);
}

/* ===== EMPTY STATE ===== */
.empty-row {
    background: var(--bg-primary);
}

.empty-state {
    text-align: center;
    padding: 48px 24px;
    background: var(--bg-primary);
}

.empty-content {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 16px;
}

.empty-content svg {
    color: var(--text-muted);
}

.empty-content h3 {
    font-size: 18px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
}

.empty-content p {
    font-size: 14px;
    color: var(--text-muted);
    margin: 0;
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 1200px) {
    .main-content {
        padding: 20px;
        padding-bottom: 300px;
    }
    
    .header-content {
        padding: 0 15px;
    }
    
    .header-title {
        font-size: 24px;
    }
    
    .search-input {
        width: 250px;
    }
}

@media (max-width: 768px) {
    .header-content {
        padding: 0 15px;
        flex-direction: column;
        gap: 15px;
        align-items: stretch;
    }
    
    .header-left {
        justify-content: center;
    }
    
    .header-right {
        justify-content: center;
        flex-direction: column;
        gap: 10px;
    }
    
    .search-input {
        width: 100%;
    }
    
    .create-btn {
        width: 100%;
        justify-content: center;
    }
}

@media (max-width: 992px) {
    .workorder-container {
        padding: 16px;
    }
    
    .workorder-header {
        padding: 20px;
        margin-bottom: 20px;
    }
    
    .page-title h1 {
        font-size: 26px;
    }
    
    .page-title p {
        font-size: 15px;
    }
    
    .tab-btn {
        padding: 12px 16px;
        font-size: 13px;
    }
    
    .action-bar {
        padding: 16px 20px;
    }
    
    .action-buttons {
        gap: 8px;
        flex-wrap: wrap;
    }
    
    .action-buttons button {
        padding: 8px 12px;
        font-size: 13px;
        flex: 1;
        min-width: 120px;
    }
    
    .table-container {
        overflow-x: auto;
    }
    
    .workorder-table {
        min-width: 800px;
    }
    
    .modal-dialog {
        width: 95%;
        max-width: 700px;
    }
}

@media (max-width: 768px) {
    .workorder-container {
        padding: 12px;
    }
    
    .workorder-header {
        padding: 16px;
        margin-bottom: 16px;
    }
    
    .page-title h1 {
        font-size: 22px;
    }
    
    .page-title p {
        font-size: 14px;
    }
    
    .tab-list {
        flex-direction: column;
    }
    
    .tab-btn {
        justify-content: center;
        border-bottom: 1px solid #e2e8f0;
        padding: 14px 16px;
    }
    
    .tab-btn.active {
        border-bottom: 2px solid #0055a5;
    }
    
    .action-bar {
        padding: 12px 16px;
    }
    
    .action-content {
        flex-direction: column;
        gap: 12px;
        align-items: stretch;
    }
    
    .action-buttons {
        flex-direction: column;
        gap: 8px;
    }
    
    .action-buttons button {
        width: 100%;
        padding: 12px 16px;
        font-size: 14px;
        font-weight: 600;
        min-height: 48px;
        justify-content: center;
    }
    
    .table-container {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        border: 1px solid #e2e8f0;
    }
    
    .workorder-table {
        min-width: 700px;
    }
    
    .table-header th,
    .table-row td {
        padding: 10px 8px;
        font-size: 13px;
    }
    
    .table-header th {
        font-size: 12px;
        font-weight: 600;
    }
    
    .status-badge,
    .priority-badge {
        padding: 4px 8px;
        font-size: 11px;
    }
    
    .btn-view {
        padding: 6px 10px;
        font-size: 11px;
    }
    
    .memo-text {
        max-width: 150px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    
    .modal-dialog {
        width: 95%;
        margin: 10px auto;
    }
    
    .modal-content {
        border-radius: 0;
    }
    
    .modal-body {
        padding: 20px;
    }
    
    .modal-footer {
        padding: 16px 20px;
        flex-direction: column;
        gap: 8px;
    }
    
    .btn {
        width: 100%;
        justify-content: center;
    }
}

@media (max-width: 576px) {
    .workorder-container {
        padding: 8px;
    }
    
    .workorder-header {
        padding: 12px;
        margin-bottom: 12px;
    }
    
    .page-title h1 {
        font-size: 20px;
    }
    
    .page-title p {
        font-size: 13px;
    }
    
    .action-bar {
        padding: 8px 12px;
    }
    
    .btn-create {
        padding: 14px 16px;
        font-size: 15px;
        font-weight: 700;
        min-height: 52px;
    }
    
    .search-input {
        padding: 12px 12px 12px 40px;
        font-size: 14px;
    }
    
    .search-icon {
        left: 12px;
        width: 16px;
        height: 16px;
    }
    
    .table-container {
        margin-bottom: 16px;
    }
    
    .workorder-table {
        min-width: 600px;
    }
    
    .table-header th,
    .table-row td {
        padding: 8px 6px;
        font-size: 12px;
    }
    
    .table-header th {
        font-size: 11px;
        padding: 10px 6px;
    }
    
    .status-badge,
    .priority-badge {
        padding: 3px 6px;
        font-size: 10px;
    }
    
    .btn-view {
        padding: 5px 8px;
        font-size: 10px;
    }
    
    .memo-text {
        max-width: 120px;
    }
    
    .empty-state {
        padding: 32px 16px;
    }
    
    .empty-content h3 {
        font-size: 16px;
    }
    
    .empty-content p {
        font-size: 13px;
    }
    
    .modal-dialog {
        width: 98%;
        margin: 5px auto;
    }
    
    .modal-header {
        padding: 12px 16px;
    }
    
    .modal-title {
        font-size: 18px;
    }
    
    .modal-body {
        padding: 16px;
    }
    
    .modal-footer {
        padding: 12px 16px;
    }
    
    .btn {
        padding: 10px 16px;
        font-size: 14px;
    }
}

@media (max-width: 480px) {
    .workorder-container {
        padding: 4px;
    }
    
    .workorder-header {
        padding: 8px;
        margin-bottom: 8px;
    }
    
    .page-title h1 {
        font-size: 18px;
    }
    
    .page-title p {
        font-size: 12px;
    }
    
    .action-bar {
        padding: 6px 8px;
    }
    
    .btn-create {
        padding: 16px 12px;
        font-size: 16px;
        font-weight: 700;
        min-height: 56px;
    }
    
    .search-input {
        padding: 14px 14px 14px 44px;
        font-size: 15px;
        min-height: 48px;
    }
    
    .search-icon {
        left: 14px;
        width: 18px;
        height: 18px;
    }
    
    .workorder-table {
        min-width: 500px;
    }
    
    .table-header th,
    .table-row td {
        padding: 6px 4px;
        font-size: 11px;
    }
    
    .table-header th {
        font-size: 10px;
        padding: 8px 4px;
    }
    
    .status-badge,
    .priority-badge {
        padding: 2px 4px;
        font-size: 9px;
    }
    
    .btn-view {
        padding: 4px 6px;
        font-size: 9px;
    }
    
    .memo-text {
        max-width: 100px;
    }
    
    .empty-state {
        padding: 24px 12px;
    }
    
    .empty-content h3 {
        font-size: 14px;
    }
    
    .empty-content p {
        font-size: 12px;
    }
    
    .modal-dialog {
        width: 100%;
        margin: 0;
        height: 100vh;
    }
    
    .modal-content {
        height: 100vh;
        border-radius: 0;
    }
    
    .modal-header {
        padding: 10px 12px;
    }
    
    .modal-title {
        font-size: 16px;
    }
    
    .modal-body {
        padding: 12px;
        overflow-y: auto;
    }
    
    .modal-footer {
        padding: 10px 12px;
    }
    
    .btn {
        padding: 8px 12px;
        font-size: 13px;
    }
}

/* ===== TABLET LANDSCAPE OPTIMIZATION ===== */
@media (max-width: 1024px) and (orientation: landscape) {
    .workorder-container {
        padding: 16px;
    }
    
    .action-content {
        flex-direction: row;
        align-items: center;
    }
    
    .search-section {
        max-width: 300px;
    }
    
    .action-buttons {
        flex-wrap: wrap;
        gap: 6px;
    }
    
    .action-buttons button {
        padding: 8px 12px;
        font-size: 12px;
    }
}

/* ===== MOBILE LANDSCAPE OPTIMIZATION ===== */
@media (max-width: 896px) and (orientation: landscape) {
    .workorder-header {
        padding: 12px;
    }
    
    .page-title h1 {
        font-size: 20px;
    }
    
    .action-bar {
        padding: 8px 12px;
    }
    
    .btn-create {
        padding: 10px 12px;
        font-size: 13px;
    }
}

/* ===== TABLE RESPONSIVE IMPROVEMENTS ===== */
@media (max-width: 768px) {
    .workorder-table {
        font-size: 12px;
    }
    
    .table-header th:first-child,
    .table-row td:first-child {
        position: sticky;
        left: 0;
        background: #f8fafc;
        z-index: 10;
        border-right: 1px solid #e2e8f0;
    }
    
    .table-header th:first-child {
        background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    }
    
    .wo-number {
        font-weight: 600;
        color: #0055a5;
        font-size: 12px;
    }
}

/* ===== MODAL RESPONSIVE IMPROVEMENTS ===== */
@media (max-width: 768px) {
    .modal {
        align-items: flex-start;
        padding-top: 20px;
    }
    
    .modal-dialog {
        margin: 0;
    }
    
    .form-check {
        margin-bottom: 8px;
    }
    
    .form-check-label {
        font-size: 13px;
    }
    
    .btn {
        padding: 10px 16px;
        font-size: 14px;
    }
}

/* ===== ACCESSIBILITY IMPROVEMENTS ===== */
@media (prefers-reduced-motion: reduce) {
    * {
        transition: none !important;
        animation: none !important;
    }
}

/* Focus styles for better accessibility */
.search-input:focus,
.action-buttons button:focus,
.tab-btn:focus,
.btn-view:focus {
    outline: 2px solid var(--primary-color);
    outline-offset: 2px;
}
.no-data {
    padding: 2%;
}

/* Screen reader only content */
.sr-only {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}

/* ===== HIGH DPI DISPLAYS ===== */
@media (-webkit-min-device-pixel-ratio: 2), (min-resolution: 192dpi) {
    .search-icon,
    .tab-btn svg,
    .action-buttons button svg,
    .btn-view svg {
        image-rendering: -webkit-optimize-contrast;
        image-rendering: crisp-edges;
    }
}

/* ===== FOCUS STATES ===== */
.search-input:focus,
.action-buttons button:focus,
.tab-btn:focus,
.btn-view:focus {
    outline: 2px solid rgba(0, 85, 165, 0.5);
    outline-offset: 2px;
}

/* ===== SMOOTH ANIMATIONS ===== */
* {
    transition: all 0.2s ease;
}

/* ===== ADDITIONAL INSPECTION2-STYLE IMPROVEMENTS ===== */
.workorder-container {
    background: #f8fafc;
}

.workorder-content {
    border-radius: 0;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    border: 1px solid #e2e8f0;
}

.table-row:hover {
    background: #f8fafc;
  /*  transform: translateY(-1px);*/
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
}

.table-header th {
    font-weight: 600;
    color: #374151;
    border-bottom: 2px solid #e5e7eb;
}

.action-bar {
    background: #f8fafc;
    border-bottom: 1px solid #e2e8f0;
    padding: 20px 24px;
}

.search-container {
    position: relative;
    display: flex;
    align-items: center;
}

.search-icon {
    position: absolute;
    left: 12px;
    color: #64748b;
    z-index: 1;
}

.search-input {
    width: 100%;
    padding: 12px 12px 12px 44px;
    border: 1px solid #d1d5db;
    border-radius: 0;
    font-size: 14px;
    font-weight: 400;
    background: white;
    transition: all 0.2s ease;
}

.action-buttons button {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 10px 16px;
    border: 1px solid #d1d5db;
    border-radius: 0;
    background: white;
    color: #374151;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
}

.action-buttons button:hover {
    background: #f3f4f6;
    border-color: #9ca3af;
    transform: translateY(-1px);
}

/* ===== HOVER EFFECTS ===== */
.action-buttons button:active,
.tab-btn:active,
.btn-view:active {
    transform: translateY(0);
}

/* ===== LOADING STATES ===== */
.action-buttons button:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
}

.action-buttons button:disabled:hover {
    background: white;
    border-color: #d1d5db;
    transform: none;
}

/* ===== PAGINATION STYLES ===== */
.pagination-container {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 20px 24px;
    background: #f8fafc;
    border-top: 1px solid #e2e8f0;
}

.pagination-info {
    color: #64748b;
    font-size: 14px;
    font-weight: 500;
}

.pagination-controls {
    display: flex;
    align-items: center;
    gap: 8px;
}

.pagination-btn {
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 8px 16px;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    background: white;
    color: #374151;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
}

.pagination-btn:hover:not(:disabled) {
    background: #f3f4f6;
    border-color: #9ca3af;
}

.pagination-btn:disabled {
    opacity: 0.5;
    cursor: not-allowed;
    background: #f9fafb;
}

.pagination-pages {
    display: flex;
    align-items: center;
    gap: 4px;
}

.page-number {
    padding: 8px 12px;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    background: white;
    color: #374151;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    min-width: 40px;
    text-align: center;
}

.page-number:hover {
    background: #f3f4f6;
    border-color: #9ca3af;
}

.page-number.active {
    background: #3b82f6;
    border-color: #3b82f6;
    color: white;
}

.page-number.active:hover {
    background: #2563eb;
    border-color: #2563eb;
}
</style>

<script>
// MongoDB API Configuration
const TAB_NAMES = ['open', 'completed', 'archive'];
const DEFAULT_COUNTRY_SELECTION = ['DRC', 'Zambia'];
const MONGODB_API_BASE = 'https://api.titandrillingzm.com:6005';
const ADMIN_UID = 'cahj3jJqe5Z16pQdLGSWrNgm84o1'; // Replace with actual logged-in admin UID

// Global variables
let allWorkOrders = [];
let currentPage = { open: 1, completed: 1, archive: 1 };
let itemsPerPage = 10;
let filteredWorkOrders = { open: [], completed: [], archive: [] };
let baseWorkOrdersByTab = { open: [], completed: [], archive: [] };
let selectedCountries = [...DEFAULT_COUNTRY_SELECTION];
let currentSearchTerm = '';
let dataReady = false;
let activePdfObjectUrl = null;
let activePdfAbortController = null;
const DATE_TIME_FORMAT_OPTIONS = {
    day: '2-digit',
    month: '2-digit',
    year: 'numeric',
    hour: '2-digit',
    minute: '2-digit',
    hour12: false
};

function formatDateTime(value) {
    if (!value) return 'N/A';
    const date = new Date(value);
    if (Number.isNaN(date.getTime())) return 'N/A';
    return date.toLocaleString('en-GB', DATE_TIME_FORMAT_OPTIONS);
}

function escapeHtml(value) {
    if (value === null || value === undefined) return '';
    return String(value)
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;')
        .replace(/'/g, '&#39;');
}

function getInitialCountrySelection() {
    if (typeof window.getCountryFilterSelection === 'function') {
        const selection = window.getCountryFilterSelection();
        if (Array.isArray(selection) && selection.length > 0) {
            return [...selection];
        }
    }
    return [...DEFAULT_COUNTRY_SELECTION];
}

function normalizeCountry(value) {
    if (!value) return '';
    const stringValue = value.toString().trim();
    if (!stringValue) return '';
    const dashTrimmed = stringValue.includes('-') ? stringValue.split('-')[0] : stringValue;
    const commaTrimmed = dashTrimmed.includes(',') ? dashTrimmed.split(',')[0] : dashTrimmed;
    const normalized = commaTrimmed.trim().toLowerCase();

    if (normalized === 'democratic republic of congo' || normalized === 'republic of congo' || normalized === 'rdc' || normalized === 'congo (drc)' || normalized === 'd. r. congo') {
        return 'drc';
    }

    if (normalized === 'zambia' || normalized === 'zam') {
        return 'zambia';
    }

    return normalized;
}

function extractWorkorderCountry(workOrder) {
    const possibleFields = [
        workOrder.country,
        workOrder.raw?.location?.country,
        workOrder.raw?.country,
        workOrder.raw?.siteCountry,
        workOrder.location?.country,
        workOrder.project
    ];

    for (const field of possibleFields) {
        if (typeof field === 'string' && field.trim() !== '') {
            return field.trim();
        }
    }

    return '';
}

function matchesCountry(workOrder, normalizedSelection) {
    if (!normalizedSelection || normalizedSelection.size === 0 || normalizedSelection.size >= DEFAULT_COUNTRY_SELECTION.length) {
        return true;
    }

    const country = normalizeCountry(extractWorkorderCountry(workOrder));
    if (!country) {
        return false;
    }

    return normalizedSelection.has(country);
}

function matchesSearchTerm(workOrder) {
    if (!currentSearchTerm) {
        return true;
    }

    const fields = [
        workOrder.requestNumber,
        workOrder.title,
        workOrder.memo,
        workOrder.status,
        workOrder.priority,
        workOrder.vehicle,
        workOrder.project,
        workOrder.country
    ];

    if (fields.some(field => field && field.toString().toLowerCase().includes(currentSearchTerm))) {
        return true;
    }

    if (Array.isArray(workOrder.assignTo) && workOrder.assignTo.length > 0) {
        return workOrder.assignTo.some(assignee =>
            assignee && assignee.toString().toLowerCase().includes(currentSearchTerm)
        );
    }

    return false;
}

function applyFiltersForAllTabs({ resetPage = false } = {}) {
    const normalizedSelection = new Set(
        selectedCountries
            .map(normalizeCountry)
            .filter(Boolean)
    );

    TAB_NAMES.forEach(tabName => applyFiltersForTab(tabName, normalizedSelection, resetPage));
}

function applyFiltersForTab(tabName, normalizedSelection, resetPage) {
    const baseList = baseWorkOrdersByTab[tabName] || [];
    const filtered = baseList.filter(workOrder =>
        matchesCountry(workOrder, normalizedSelection) &&
        matchesSearchTerm(workOrder)
    );

    filteredWorkOrders[tabName] = filtered;

    if (resetPage || currentPage[tabName] < 1) {
        currentPage[tabName] = 1;
    }

    const totalPages = filtered.length === 0 ? 0 : Math.ceil(filtered.length / itemsPerPage);
    if (totalPages > 0 && currentPage[tabName] > totalPages) {
        currentPage[tabName] = totalPages;
    }
    if (totalPages === 0) {
        currentPage[tabName] = 1;
    }

    renderWorkOrders(tabName);
}

function getTabElements(tabName) {
    const container = document.querySelector(`#${tabName} .table-container`);
    const table = container ? container.querySelector('.workorder-table') : null;
    const loader = document.getElementById(`${tabName}TableLoader`);
    return { container, table, loader };
}

function setTabLoading(tabName, isLoading) {
    const { table, loader } = getTabElements(tabName);
    if (loader) {
        loader.style.display = isLoading ? 'flex' : 'none';
    }
    if (table) {
        table.classList.toggle('table-loading-state', isLoading);
    }
}

function showAllTableLoaders() {
    TAB_NAMES.forEach(tabName => setTabLoading(tabName, true));
}

function hideAllTableLoaders() {
    TAB_NAMES.forEach(tabName => setTabLoading(tabName, false));
}

// Fetch work orders from MongoDB
async function fetchWorkOrders() {
    try {
        console.log('🔄 Fetching job cards from MongoDB...');
        dataReady = false;
        showAllTableLoaders();
        
        const response = await fetch(`${MONGODB_API_BASE}/jobcards/all`);
        
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        
        const result = await response.json();
        console.log('MongoDB API Response:', result);
        
        if (result.success && Array.isArray(result.data)) {
            allWorkOrders = result.data.map(jobCard => {
                const assignToArray = Array.isArray(jobCard.assignTo)
                    ? jobCard.assignTo
                    : jobCard.assignTo
                        ? [jobCard.assignTo]
                        : [];
                
                return {
                    id: jobCard._id || jobCard.id,
                    requestNumber: jobCard.requestNumber || jobCard._id,
                    title: jobCard.title || 'Untitled Job Card',
                    status: jobCard.status || 'Hold',
                    priority: jobCard.priority || 'Low',
                    createdAt: jobCard.createdAt || null,
                    dueDate: jobCard.dueDate || null,
                    completedDate: jobCard.completedDate || null,
                    equipment: jobCard.equipment || null,
                    vehicle: jobCard.equipment?.equipmentName || jobCard.equipment?.vehicleNumber || 'N/A',
                    assignTo: assignToArray,
                    memo: jobCard.notes || jobCard.description || '',
                    pdfDownloadUrl: jobCard.pdfDownloadUrl || jobCard.pdfUrl || jobCard.documentUrl || '',
                    adminUid: jobCard.adminUid || jobCard.adminUID || '',
                    country: jobCard.location?.country || '',
                    project: jobCard.location?.project || '',
                    raw: jobCard
                };
            });
            
            console.log(`✅ Loaded ${allWorkOrders.length} job cards from MongoDB`);
            
            filterWorkOrdersByStatus();
            dataReady = true;
            applyFiltersForAllTabs({ resetPage: true });
            hideAllTableLoaders();
            if (allWorkOrders.length > 0) {
                showNotification('success', `Loaded ${allWorkOrders.length} job cards successfully`);
            } else {
                showNotification('info', 'No job cards found');
            }
            
        } else {
            console.log('No job cards found in MongoDB');
            allWorkOrders = [];
            filterWorkOrdersByStatus();
            dataReady = true;
            applyFiltersForAllTabs({ resetPage: true });
            hideAllTableLoaders();
            showNotification('info', 'No job cards found');
        }
        
    } catch (error) {
        console.error('❌ Error fetching job cards from MongoDB:', error);
        showNotification('error', 'Failed to load job cards: ' + error.message);
        allWorkOrders = [];
        filterWorkOrdersByStatus();
        dataReady = true;
        applyFiltersForAllTabs({ resetPage: true });
        hideAllTableLoaders();
    }
}

// Filter work orders by status (MongoDB schema: Hold, assigned, in_progress, complete, cancelled)
function filterWorkOrdersByStatus() {
    baseWorkOrdersByTab.open = allWorkOrders.filter(wo => {
        const status = wo.status ? wo.status.toLowerCase() : '';
        // Open: Hold, assigned, in_progress
        return ['hold', 'assigned', 'in_progress'].includes(status);
    });
    
    baseWorkOrdersByTab.completed = allWorkOrders.filter(wo => {
        const status = wo.status ? wo.status.toLowerCase() : '';
        // Completed: complete
        return status === 'complete';
    });
    
    baseWorkOrdersByTab.archive = allWorkOrders.filter(wo => {
        const status = wo.status ? wo.status.toLowerCase() : '';
        // Archive: cancelled
        return status === 'cancelled';
    });
    
    filteredWorkOrders.open = [...baseWorkOrdersByTab.open];
    filteredWorkOrders.completed = [...baseWorkOrdersByTab.completed];
    filteredWorkOrders.archive = [...baseWorkOrdersByTab.archive];
    
    console.log('Filtered job cards:', {
        open: filteredWorkOrders.open.length,
        completed: filteredWorkOrders.completed.length,
        archive: filteredWorkOrders.archive.length
    });
}

// Render work orders for a specific tab
function renderWorkOrders(tabName) {
    setTabLoading(tabName, false);

    const workOrders = filteredWorkOrders[tabName] || [];
    const totalItems = workOrders.length;
    const totalPages = totalItems === 0 ? 0 : Math.ceil(totalItems / itemsPerPage);

    if (totalPages > 0 && currentPage[tabName] > totalPages) {
        currentPage[tabName] = totalPages;
    }
    if (totalPages === 0) {
        currentPage[tabName] = 1;
    }

    const startIndex = (currentPage[tabName] - 1) * itemsPerPage;
    const endIndex = startIndex + itemsPerPage;
    const pageWorkOrders = workOrders.slice(startIndex, endIndex);

    const tbody = document.getElementById(tabName + 'TableBody');
    const pagination = document.getElementById(tabName + 'Pagination');
    const paginationInfo = document.getElementById(tabName + 'PaginationInfo');
    
    if (!tbody) return;
    
    // Clear existing content
    tbody.innerHTML = '';
    
    if (pageWorkOrders.length === 0) {
        tbody.innerHTML = `
            <tr>
                <td colspan="10" class="no-data-cell">
                    <div class="no-data">
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"/>
                            <path d="M12 6v6l4 2"/>
                        </svg>
                        <h3>No Data Available</h3>
                        <p>No ${tabName} work orders found.</p>
                    </div>
                </td>
            </tr>
        `;
        if (pagination) pagination.style.display = 'none';
    } else {
        // Render work orders
        pageWorkOrders.forEach((workOrder, index) => {
            const globalIndex = startIndex + index + 1;
            const row = createWorkOrderRow(workOrder, globalIndex, tabName);
            tbody.appendChild(row);
        });
        
        // Show pagination
        if (pagination) {
            pagination.style.display = 'flex';
            updatePaginationInfo(tabName, workOrders.length);
            updatePaginationControls(tabName, workOrders.length);
        }
    }
}

// Create work order row
function createWorkOrderRow(workOrder, index, tabName) {
    const row = document.createElement('tr');
    row.className = 'table-row';
    
    const statusColor = getStatusColorClass(workOrder.status);
    const priorityColor = getPriorityColorClass(workOrder.priority);
    
    const equipmentName = (workOrder.vehicle && workOrder.vehicle !== 'N/A')
        ? workOrder.vehicle
        : workOrder.equipment?.equipmentName
            || workOrder.equipment?.name
            || workOrder.equipment?.vehicleNumber
            || 'N/A';
    
    const assignedUsers = Array.isArray(workOrder.assignTo)
        ? workOrder.assignTo.length
        : 0;
    
    const createdDate = formatDateTime(workOrder.createdAt);
    const secondaryDate = (tabName === 'completed' || tabName === 'archive')
        ? formatDateTime(workOrder.completedDate)
        : formatDateTime(workOrder.dueDate);
    
    const statusLabel = escapeHtml(workOrder.status || 'N/A');
    const priorityLabel = escapeHtml(workOrder.priority || 'N/A');
    const requestNumberLabel = escapeHtml(workOrder.requestNumber || workOrder.id || 'N/A');
    const vehicleLabel = escapeHtml(equipmentName);
    const memoLabel = escapeHtml((workOrder.memo && workOrder.memo.trim()) ? workOrder.memo.trim() : 'N/A');
    
    // Escape strings for HTML attributes
    const safeWorkOrderId = (workOrder.id || '').replace(/'/g, "\\'").replace(/"/g, '&quot;');
    const safePdfUrl = (workOrder.pdfDownloadUrl || '').replace(/'/g, "\\'").replace(/"/g, '&quot;');
    const safeRequestNumber = (workOrder.requestNumber || workOrder.id || '').replace(/'/g, "\\'").replace(/"/g, '&quot;');
    const safeAdminUid = (workOrder.adminUid || '').replace(/'/g, "\\'").replace(/"/g, '&quot;');
    
    row.innerHTML = `
        <td style="text-align: center; font-weight: 500; color: #64748b;">${index}</td>
        <td>
            <div class="dropdown">
                <button class="action-btn"
                        type="button"
                        id="workorderAction-${index}"
                        data-dropdown-index="${index}"
                        aria-label="Open actions menu"
                        aria-haspopup="true"
                        aria-expanded="false"
                        onclick="toggleWorkorderDropdown(event, ${index})">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                        <circle cx="12" cy="12" r="3"></circle>
                        <path d="M12 1v6m0 6v6m11-7h-6m-6 0H1"></path>
                    </svg>
                    Actions
                </button>
                <ul class="dropdown-menu" id="workorder-dropdown-${index}" aria-labelledby="workorderAction-${index}" role="menu">
                    <li role="none">
                        <a class="dropdown-item" role="menuitem" href="javascript:void(0)" onclick="event.preventDefault(); event.stopPropagation(); viewPDFModal('${safePdfUrl}', '${safeRequestNumber}');">
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                            <polyline points="14,2 14,8 20,8"/>
                        </svg>
                        View PDF
                        </a>
                    </li>
                    <li role="none">
                        <a class="dropdown-item" role="menuitem" href="javascript:void(0)" onclick="event.preventDefault(); event.stopPropagation(); openTrackJobCard('${safeWorkOrderId}', '${safeAdminUid}');">
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                            <polyline points="12 5 12 12 16 14"></polyline>
                        </svg>
                        Track Job Card
                        </a>
                    </li>
                    <li class="dropdown-divider" role="none"></li>
                    <li role="none">
                        <a class="dropdown-item danger" role="menuitem" href="javascript:void(0)" onclick="event.preventDefault(); event.stopPropagation(); deleteWorkOrder('${safeWorkOrderId}', '${safeRequestNumber}', '${safeAdminUid}');">
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <polyline points="3,6 5,6 21,6"/>
                            <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"/>
                        </svg>
                        Delete Job Card
                        </a>
                    </li>
                </ul>
            </div>
        </td>
        <td>
            <div class="wo-number">
                <strong>${requestNumberLabel}</strong>
            </div>
        </td>
        <td>
            <div class="date-info">
                <span class="date">${createdDate}</span>
            </div>
        </td>
        <td>
            <div class="vehicle-info">
                <span class="vehicle-name">${vehicleLabel}</span>
            </div>
        </td>
        <td>
            <div class="date-info">
                <span class="date">${secondaryDate}</span>
            </div>
        </td>
        <td>
            <span class="status-badge ${statusColor}">${statusLabel}</span>
        </td>
        <td>
            <span class="priority-badge ${priorityColor}">${priorityLabel}</span>
        </td>
        <td>
            <div class="assigned-info">
                <span class="assigned-count">${assignedUsers}</span>
            </div>
        </td>
        <td>
            <div class="memo-info">
                <span class="memo-text">${memoLabel}</span>
            </div>
        </td>
    `;
    
    return row;
}

// Get status color class (MongoDB schema: Hold, assigned, in_progress, complete, cancelled)
function getStatusColorClass(status) {
    if (!status) return 'info';
    const s = status.toLowerCase();
    if (s === 'complete') return 'success';
    if (s === 'in_progress') return 'primary';
    if (s === 'hold') return 'warning';
    if (s === 'assigned') return 'info';
    if (s === 'cancelled') return 'secondary';
    return 'info';
}

// Get priority color class (MongoDB schema: Low, Medium, High, Emergency)
function getPriorityColorClass(priority) {
    if (!priority) return 'secondary';
    const p = priority.toLowerCase();
    if (p === 'emergency') return 'danger';
    if (p === 'high') return 'danger';
    if (p === 'medium') return 'warning';
    if (p === 'low') return 'success';
    return 'secondary';
}

// Update pagination info
function updatePaginationInfo(tabName, totalItems) {
    const paginationInfo = document.getElementById(tabName + 'PaginationInfo');
    if (!paginationInfo) return;
    
    const startIndex = (currentPage[tabName] - 1) * itemsPerPage + 1;
    const endIndex = Math.min(currentPage[tabName] * itemsPerPage, totalItems);
    
    paginationInfo.textContent = `Showing ${startIndex}-${endIndex} of ${totalItems} work orders`;
}

// Update pagination controls
function updatePaginationControls(tabName, totalItems) {
    const totalPages = Math.ceil(totalItems / itemsPerPage);
    const prevBtn = document.getElementById(tabName + 'PrevBtn');
    const nextBtn = document.getElementById(tabName + 'NextBtn');
    const pageNumbers = document.getElementById(tabName + 'PageNumbers');
    
    // Update prev/next buttons
    if (prevBtn) prevBtn.disabled = currentPage[tabName] <= 1;
    if (nextBtn) nextBtn.disabled = currentPage[tabName] >= totalPages;
    
    // Generate page numbers
    if (pageNumbers) {
        pageNumbers.innerHTML = '';
    }

    if (!pageNumbers || totalPages <= 1) {
        return;
    }

    const startPage = Math.max(1, currentPage[tabName] - 2);
    const endPage = Math.min(totalPages, startPage + 4);

    for (let i = startPage; i <= endPage; i++) {
        const pageBtn = document.createElement('button');
        pageBtn.className = `page-number ${i === currentPage[tabName] ? 'active' : ''}`;
        pageBtn.textContent = i;
        pageBtn.onclick = () => goToPage(tabName, i);
        pageNumbers.appendChild(pageBtn);
    }
}

// Change page
function changePage(tabName, direction) {
    const totalPages = Math.ceil(filteredWorkOrders[tabName].length / itemsPerPage);
    const newPage = currentPage[tabName] + direction;
    
    if (newPage >= 1 && newPage <= totalPages) {
        currentPage[tabName] = newPage;
        renderWorkOrders(tabName);
    }
}

// Go to specific page
function goToPage(tabName, page) {
    const totalPages = Math.ceil(filteredWorkOrders[tabName].length / itemsPerPage);
    
    if (page >= 1 && page <= totalPages) {
        currentPage[tabName] = page;
        renderWorkOrders(tabName);
    }
}

// Tab switching functionality
function switchTab(tabName) {
    // Update tab buttons
    document.querySelectorAll('.tab-btn').forEach(btn => {
        btn.classList.remove('active');
    });
    document.querySelector(`[data-tab="${tabName}"]`).classList.add('active');
    
    // Update tab panes
    document.querySelectorAll('.tab-pane').forEach(pane => {
        pane.classList.remove('active');
    });
    document.getElementById(tabName).classList.add('active');
    
    // Reset to first page for the new tab
    currentPage[tabName] = 1;
    renderWorkOrders(tabName);
}

// Search functionality
function setupSearch() {
    // Global search input
    const globalSearchInput = document.getElementById('globalSearchInput');
    if (globalSearchInput) {
        globalSearchInput.addEventListener('input', function() {
            searchWorkOrders(this.value);
        });
    }
    
    // Individual tab search inputs (if they exist)
    const searchInputs = ['openSearch', 'completedSearch', 'archiveSearch'];
    
    searchInputs.forEach(inputId => {
        const input = document.getElementById(inputId);
        if (input) {
            input.addEventListener('input', function() {
                searchWorkOrders(this.value);
            });
        }
    });
}

// Search work orders
function searchWorkOrders(searchTerm) {
    currentSearchTerm = (searchTerm || '').trim().toLowerCase();
    applyFiltersForAllTabs({ resetPage: true });
}

function closeAllWorkorderDropdowns() {
    document.querySelectorAll('.dropdown-menu.show').forEach(menu => menu.classList.remove('show'));
    document.querySelectorAll('.action-btn[aria-expanded="true"]').forEach(btn => btn.setAttribute('aria-expanded', 'false'));
}

// Toggle dropdown function (matches inspection dropdown UX)
function toggleWorkorderDropdown(event, dropdownIndex) {
    event.preventDefault();
    event.stopPropagation();

    const dropdownMenu = document.getElementById(`workorder-dropdown-${dropdownIndex}`);
    const triggerButton = document.querySelector(`.action-btn[data-dropdown-index="${dropdownIndex}"]`);
    const wasOpen = dropdownMenu?.classList.contains('show');

    // Close all dropdowns and reset aria state
    closeAllWorkorderDropdowns();

    if (dropdownMenu && triggerButton && !wasOpen) {
        dropdownMenu.classList.add('show');
        triggerButton.setAttribute('aria-expanded', 'true');
    }
}

// Close dropdowns when clicking outside
document.addEventListener('click', function(event) {
    if (!event.target.closest('.dropdown')) {
        closeAllWorkorderDropdowns();
    }
});

// View work order function
function viewWorkorder(workOrderId) {
    console.log('Viewing work order details:', workOrderId);
    // Close dropdown
    closeAllWorkorderDropdowns();
    
    // You can implement the view details functionality here
    // For now, just show an alert
    alert(`Viewing work order details: ${workOrderId}`);
}

// View PDF function
function viewPDF(workOrderId, pdfUrl) {
    console.log('📄 Viewing PDF for job card:', workOrderId, 'URL:', pdfUrl);
    
    // Close dropdown
    closeAllWorkorderDropdowns();
    
    if (pdfUrl && pdfUrl.trim() !== '') {
        // Validate PDF URL format
        if (!pdfUrl.startsWith('http://') && !pdfUrl.startsWith('https://')) {
            showSimpleAlert('Invalid PDF URL format. The PDF may not be available yet.', 'error');
            return;
        }
        
        // Open PDF from MongoDB storage in new tab
        console.log('📂 Opening PDF from MongoDB storage:', pdfUrl);
        
        try {
            const pdfWindow = window.open(pdfUrl, '_blank');
            
            // Check if popup was blocked
            if (!pdfWindow || pdfWindow.closed || typeof pdfWindow.closed == 'undefined') {
                showSimpleAlert('Popup blocked! Please allow popups for this site and try again.', 'warning');
                return;
            }
            
            // Optional: Focus the new window
            pdfWindow.focus();
            
            console.log('✅ PDF opened successfully in new tab');
            showNotification('success', 'PDF opened successfully');
            
        } catch (error) {
            console.error('❌ Error opening PDF:', error);
            showSimpleAlert('Failed to open PDF. Please check your browser settings and try again.', 'error');
        }
    } else {
        showSimpleAlert('PDF not available for this job card. It may not have been generated yet.', 'info');
    }
}

function openTrackJobCard(jobCardId, adminUid) {
    closeAllWorkorderDropdowns();

    if (!jobCardId) {
        showSimpleAlert('Job card ID is not available for tracking.', 'error');
        return;
    }

    try {
        const params = new URLSearchParams();
        params.set('job_card_id', jobCardId);
        if (adminUid) {
            params.set('admin_uid', adminUid);
        }
        window.location.href = `/maintenance/track-jobcard?${params.toString()}`;
    } catch (error) {
        console.error('❌ Failed to open track job card page:', error);
        showSimpleAlert('Unable to open track job card page.', 'error');
    }
}

// Simple alert notification
function showSimpleAlert(message, type = 'info') {
    const colors = {
        success: '#10b981',
        error: '#ef4444',
        warning: '#f59e0b',
        info: '#3b82f6'
    };
    
    const alertMsg = document.createElement('div');
    alertMsg.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        background: ${colors[type] || colors.info};
        color: white;
        padding: 12px 20px;
        border-radius: 8px;
        z-index: 100001;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        max-width: 400px;
    `;
    alertMsg.textContent = message;
    document.body.appendChild(alertMsg);
    
    setTimeout(() => {
        if (alertMsg.parentNode) {
            alertMsg.style.opacity = '0';
            alertMsg.style.transition = 'opacity 0.3s ease';
            setTimeout(() => {
                if (alertMsg.parentNode) alertMsg.parentNode.removeChild(alertMsg);
            }, 300);
        }
    }, 3000);
}

// Initialize when page loads
document.addEventListener('DOMContentLoaded', function() {
    console.log('Initializing work order page...');
    selectedCountries = getInitialCountrySelection();
    
    // Setup search functionality
    setupSearch();
    
    // Setup tab switching
    document.querySelectorAll('.tab-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const tabName = this.getAttribute('data-tab');
            switchTab(tabName);
        });
    });
    
    // Fetch work orders from Firebase
    fetchWorkOrders();
});

window.addEventListener('countryFilterChanged', function(event) {
    const detail = event && event.detail ? event.detail : {};
    const countries = Array.isArray(detail.selectedCountries) ? detail.selectedCountries : [];
    selectedCountries = countries.length > 0 ? [...countries] : [...DEFAULT_COUNTRY_SELECTION];

    if (dataReady) {
        applyFiltersForAllTabs({ resetPage: true });
    }
});

// Add tab switching function to global scope
window.switchTab = switchTab;
window.changePage = changePage;
window.goToPage = goToPage;
window.viewWorkorder = viewWorkorder;
window.toggleWorkorderDropdown = toggleWorkorderDropdown;
window.viewPDF = viewPDF;
window.openTrackJobCard = openTrackJobCard;
</script>

<!-- PDF Viewer Modal pdfModal -->
<div id="pdfModal" class="pdf-modal-overlay">
    <div class="pdf-modal-container">
        <div class="pdf-modal-header">
            <h2 class="pdf-modal-title" id="pdfModalTitle">Job Card PDF</h2>
            <button class="pdf-modal-close" onclick="closePDFModal()">&times;</button>
        </div>
        <div class="pdf-modal-body">
            <div id="pdfLoadingState" class="pdf-loading">
                <div class="pdf-loading-spinner"></div>
                <p class="pdf-loading-text">Loading PDF...</p>
            </div>
            <iframe id="pdfFrame" class="pdf-frame" style="display: none;"></iframe>
        </div>
    </div>
</div>

<script>
// View PDF in modal
function viewPDFModal(pdfUrl, requestNumber) {
    console.log('📂 Opening PDF modal for:', requestNumber);
    
    if (!pdfUrl || pdfUrl.trim() === '' || pdfUrl === 'undefined') {
        showNotification('error', 'PDF not available for this job card. It may not have been generated yet.');
        return;
    }
    
    // Validate PDF URL format
    if (!pdfUrl.startsWith('http://') && !pdfUrl.startsWith('https://')) {
        showNotification('error', 'Invalid PDF URL format. The PDF may not be available yet.');
        return;
    }
    
    const modal = document.getElementById('pdfModal');
    const pdfFrame = document.getElementById('pdfFrame');
    const pdfLoadingState = document.getElementById('pdfLoadingState');
    const pdfModalTitle = document.getElementById('pdfModalTitle');
    
    // Abort any previous load
    if (activePdfAbortController) {
        activePdfAbortController.abort();
    }
    activePdfAbortController = new AbortController();

    // Revoke previous object URL if exists
    if (activePdfObjectUrl) {
        URL.revokeObjectURL(activePdfObjectUrl);
        activePdfObjectUrl = null;
    }

    // Clear iframe
    pdfFrame.removeAttribute('src');

    // Update title
    pdfModalTitle.textContent = `Job Card: ${requestNumber}`;
    
    // Show modal and loading state
    modal.classList.add('active');
    pdfLoadingState.style.display = 'flex';
    pdfFrame.style.display = 'none';

    fetch(pdfUrl, { signal: activePdfAbortController.signal })
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            const contentType = response.headers.get('content-type') || '';
            if (!contentType.includes('pdf')) {
                console.warn('Unexpected content type for PDF:', contentType);
            }
            return response.blob();
        })
        .then(blob => {
            const objectUrl = URL.createObjectURL(blob);
            activePdfObjectUrl = objectUrl;
            pdfFrame.onload = function() {
                pdfLoadingState.style.display = 'none';
                pdfFrame.style.display = 'block';
                console.log('✅ PDF loaded successfully');
            };
            pdfFrame.onerror = function() {
                pdfLoadingState.innerHTML = '<p class="pdf-loading-text" style="color: #dc3545;">Failed to load PDF. Please try again.</p>';
                console.error('❌ Error loading PDF in iframe');
            };
            pdfFrame.src = objectUrl;
        })
        .catch(error => {
            if (error.name === 'AbortError') {
                console.log('PDF load aborted');
                return;
            }
            console.error('❌ Error fetching PDF:', error);
            pdfLoadingState.innerHTML = '<p class="pdf-loading-text" style="color: #dc3545;">Failed to load PDF. Please try again.</p>';
            showNotification('error', 'Failed to load PDF. Please try again.');
        });
}

// Close PDF modal
function closePDFModal() {
    const modal = document.getElementById('pdfModal');
    const pdfFrame = document.getElementById('pdfFrame');

    if (activePdfAbortController) {
        activePdfAbortController.abort();
        activePdfAbortController = null;
    }

    modal.classList.remove('active');
    pdfFrame.removeAttribute('src');

    if (activePdfObjectUrl) {
        URL.revokeObjectURL(activePdfObjectUrl);
        activePdfObjectUrl = null;
    }

    console.log('🚪 PDF modal closed');
}

// Close modal when clicking outside
document.getElementById('pdfModal')?.addEventListener('click', function(event) {
    if (event.target === this) {
        closePDFModal();
    }
});

// Delete work order function
async function showDeleteConfirmation(message) {
    // If another confirmation dialog exists, remove it to avoid stacking
    document.querySelectorAll('.confirmation-overlay').forEach(overlay => overlay.remove());

    return new Promise(resolve => {
        const overlay = document.createElement('div');
        overlay.className = 'confirmation-overlay';

        const dialog = document.createElement('div');
        dialog.className = 'confirmation-dialog';

        const title = document.createElement('h3');
        title.textContent = 'Confirm Deletion';

        const body = document.createElement('p');
        body.innerHTML = message.split('\n').map(line => line.trim()).join('<br>');

        const actions = document.createElement('div');
        actions.className = 'confirmation-actions';

        const confirmButton = document.createElement('button');
        confirmButton.className = 'confirm-btn';
        confirmButton.type = 'button';
        confirmButton.textContent = 'Delete';

        const cancelButton = document.createElement('button');
        cancelButton.className = 'cancel-btn';
        cancelButton.type = 'button';
        cancelButton.textContent = 'Cancel';

        actions.appendChild(cancelButton);
        actions.appendChild(confirmButton);

        dialog.appendChild(title);
        dialog.appendChild(body);
        dialog.appendChild(actions);
        overlay.appendChild(dialog);
        document.body.appendChild(overlay);

        const cleanup = () => {
            overlay.remove();
            document.removeEventListener('keydown', handleKeydown);
        };

        const handleConfirm = () => {
            cleanup();
            resolve(true);
        };

        const handleCancel = () => {
            cleanup();
            resolve(false);
        };

        const handleKeydown = (event) => {
            if (event.key === 'Escape') {
                handleCancel();
            }
        };

        confirmButton.addEventListener('click', handleConfirm);
        cancelButton.addEventListener('click', handleCancel);
        overlay.addEventListener('click', event => {
            if (event.target === overlay) {
                handleCancel();
            }
        });
        document.addEventListener('keydown', handleKeydown);

        // Focus trap: move focus to cancel button initially
        cancelButton.focus();
    });
}

async function deleteWorkOrder(workOrderId, requestNumber, adminUid) {
    console.log('🗑️ Delete work order:', workOrderId, requestNumber);
    
    // Close all dropdowns
    closeAllWorkorderDropdowns();
    
    const confirmationMessage = `⚠️ Are you sure you want to DELETE this job card?\n\nJob Card: ${requestNumber}\n\n⚠️ This action CANNOT be undone!`;
    const userConfirmed = await showDeleteConfirmation(confirmationMessage);

    if (!userConfirmed) {
        console.log('❌ Delete cancelled by user');
        return;
    }
    
    try {
        console.log('🔄 Deleting job card from MongoDB...');
        
        // Call MongoDB delete API
        const targetAdminUid = adminUid || ADMIN_UID;
        const response = await fetch(`${MONGODB_API_BASE}/jobcards/${targetAdminUid}/${workOrderId}`, {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json'
            }
        });
        
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        
        const result = await response.json();
        console.log('✅ Delete response:', result);
        
        if (result.success) {
            showNotification('success', 'Job card deleted successfully!');
            
            // Refresh the work orders list
            setTimeout(() => {
                fetchWorkOrders();
            }, 1000);
        } else {
            const message = result.error || 'Failed to delete job card';
            throw new Error(message);
        }
        
    } catch (error) {
        console.error('❌ Error deleting job card:', error);
        showNotification('error', 'Failed to delete job card: ' + error.message);
    }
}

// Show notification
function showNotification(type, message) {
    // Create notification element
    const notification = document.createElement('div');
    notification.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        background: ${type === 'success' ? '#10b981' : '#ef4444'};
        color: white;
        padding: 16px 24px;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        z-index: 10001;
        font-size: 14px;
        font-weight: 500;
        max-width: 400px;
        animation: slideInRight 0.3s ease;
    `;
    notification.textContent = message;
    
    document.body.appendChild(notification);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        notification.style.animation = 'slideOutRight 0.3s ease';
        setTimeout(() => notification.remove(), 300);
    }, 5000);
}

// Add animation styles
const style = document.createElement('style');
style.textContent = `
    @keyframes slideInRight {
        from {
            transform: translateX(100%);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }
    @keyframes slideOutRight {
        from {
            transform: translateX(0);
            opacity: 1;
        }
        to {
            transform: translateX(100%);
            opacity: 0;
        }
    }
`;
document.head.appendChild(style);

// Add functions to global scope
window.viewPDFModal = viewPDFModal;
window.closePDFModal = closePDFModal;
window.deleteWorkOrder = deleteWorkOrder;
</script>
@endsection