<div id="sidebar">
    <a href="{{ route('dashboard') }}" class="sidebar-logo">
        <img src="/images/Sidebar-logo.png" alt="Titan Drilling" height="40" width="100" class="logo-image">
    </a>

    <nav role="navigation" aria-label="Main navigation" class="sidebar-nav">
        <a href="{{ route('dashboard') }}" 
            data-page="dashboard"
            class="sidebar-link @if(Route::currentRouteName() == 'dashboard') active @endif">
            <i class="fas fa-tachometer-alt sidebar-icon" aria-hidden="true"></i> Dashboard
        </a>

        @php
            $currentRoute = Route::currentRouteName();
            $isInspectionActive = str_starts_with($currentRoute, 'inspection.');
            $isVehiclesActive = str_starts_with($currentRoute, 'vehicles.');
            $isMasterDataActive = str_starts_with($currentRoute, 'master_data.');
            $isAnalyticsActive = in_array($currentRoute, ['dashboard.excel_report', 'dashboard.inspection_kpi', 'dashboard.incident_kpi', 'dashboard.logbook_kpi', 'dashboard.maintenance_kpi', 'dashboard.workorder_kpi', 'dashboard.fuel_management_kpi', 'dashboard.equipment_kpi', 'dashboard.team_kpi', 'dashboard.team_employees_kpi']) || str_starts_with($currentRoute, 'dashboard.team_kpi');
        @endphp

        <button data-target="#inspectionMenu" 
                @if($isInspectionActive) aria-expanded="true" @else aria-expanded="false" @endif
                class="sidebar-menu-btn @if($isInspectionActive) active @endif">
            <i class="fas fa-search sidebar-icon @if($isInspectionActive) active @endif" aria-hidden="true"></i> Inspection
            <i class="fas fa-chevron-down sidebar-chevron @if($isInspectionActive) active @endif" aria-hidden="true"></i>
        </button>
        <div id="inspectionMenu" class="sidebar-submenu @if($isInspectionActive) active @endif">
            <a href="{{ route('inspection.inspection_report') }}" data-page="inspection_report_home" 
               class="sidebar-sublink @if($currentRoute == 'inspection.inspection_report') active @endif">Inspection Report Home</a>
            <a href="{{ route('inspection.inspection2') }}" data-page="create_inspection_report" 
               class="sidebar-sublink @if($currentRoute == 'inspection.inspection2') active @endif">Create Inspection Report</a>
            <a href="{{ route('inspection.hse_reports') }}" data-page="hse_reports" 
               class="sidebar-sublink @if($currentRoute == 'inspection.hse_reports') active @endif">HSE Inspection Reports</a>
        </div>

        <button data-target="#incidentReportMenu" 
                class="sidebar-menu-btn @if(str_contains($currentRoute, 'inspection.incident')) active @endif">
            <i class="fas fa-exclamation-triangle sidebar-icon @if(str_contains($currentRoute, 'inspection.incident')) active @endif" aria-hidden="true"></i> Incident Report
            <i class="fas fa-chevron-down sidebar-chevron @if(str_contains($currentRoute, 'inspection.incident')) active @endif" aria-hidden="true"></i>
        </button>
        <div id="incidentReportMenu" class="sidebar-submenu @if(str_contains($currentRoute, 'inspection.incident')) active @endif">
            <a href="{{ route('inspection.incident_report') }}" data-page="incident_report_home" 
               class="sidebar-sublink @if($currentRoute == 'inspection.incident_report') active @endif">Incident Report Home</a>
            <a href="{{ route('inspection.create_incident_report') }}" data-page="create_incident_report" 
               class="sidebar-sublink @if($currentRoute == 'inspection.create_incident_report') active @endif">Create Incident Report</a>
        </div>

        <button data-target="#dailyInspectionMenu" 
                class="sidebar-menu-btn @if(str_contains($currentRoute, 'inspection.operator_daily')) active @endif">
            <i class="fas fa-calendar-check sidebar-icon @if(str_contains($currentRoute, 'inspection.operator_daily')) active @endif" aria-hidden="true"></i> Daily Inspection Report
            <i class="fas fa-chevron-down sidebar-chevron @if(str_contains($currentRoute, 'inspection.operator_daily')) active @endif" aria-hidden="true"></i>
        </button>
        <div id="dailyInspectionMenu" class="sidebar-submenu @if(str_contains($currentRoute, 'inspection.operator_daily')) active @endif">
            <a href="{{ route('inspection.operator_daily_reporting') }}" data-page="daily_inspection_home" 
               class="sidebar-sublink @if($currentRoute == 'inspection.operator_daily_reporting') active @endif">Daily Inspection Report Home</a>
        </div>

        <button data-target="#jobCardMenu"
                class="sidebar-menu-btn @if(str_contains($currentRoute, 'job_card') || $currentRoute == 'maintenance.workorder') active @endif">
            <i class="fas fa-clipboard-list sidebar-icon @if(str_contains($currentRoute, 'job_card') || $currentRoute == 'maintenance.workorder') active @endif" aria-hidden="true"></i> Job Card
            <i class="fas fa-chevron-down sidebar-chevron @if(str_contains($currentRoute, 'job_card') || $currentRoute == 'maintenance.workorder') active @endif" aria-hidden="true"></i>
        </button>
        <div id="jobCardMenu" class="sidebar-submenu @if(str_contains($currentRoute, 'job_card') || $currentRoute == 'maintenance.workorder') active @endif">
                <a href="{{ route('maintenance.workorder') }}" data-page="job_card_home"
                   class="sidebar-sublink @if($currentRoute == 'maintenance.workorder') active @endif">Job Card Home Page</a>
                <a href="{{ route('maintenance.workorders.create') }}" data-page="job_card_create"
                   class="sidebar-sublink @if($currentRoute == 'maintenance.workorders.create') active @endif">Create Job Card</a>
        </div>

        <button data-target="#requestMaintenanceMenu" 
                class="sidebar-menu-btn @if(str_contains($currentRoute, 'request.maintenance') || $currentRoute == 'maintenance.request' || $currentRoute == 'create.request.maintenance') active @endif">
            <i class="fas fa-tools sidebar-icon @if(str_contains($currentRoute, 'request.maintenance') || $currentRoute == 'maintenance.request' || $currentRoute == 'create.request.maintenance') active @endif" aria-hidden="true"></i> Request Maintenance
            <i class="fas fa-chevron-down sidebar-chevron @if(str_contains($currentRoute, 'request.maintenance') || $currentRoute == 'maintenance.request' || $currentRoute == 'create.request.maintenance') active @endif" aria-hidden="true"></i>
        </button>
        <div id="requestMaintenanceMenu" class="sidebar-submenu @if(str_contains($currentRoute, 'request.maintenance') || $currentRoute == 'maintenance.request' || $currentRoute == 'create.request.maintenance') active @endif">
            <a href="{{ route('request.maintenance') }}" data-page="request_maintenance_home" 
               class="sidebar-sublink @if($currentRoute == 'request.maintenance') active @endif">Request Maintenance Home</a>
            <a href="{{ route('create.request.maintenance') }}" data-page="create_request_maintenance" 
               class="sidebar-sublink @if($currentRoute == 'create.request.maintenance') active @endif">Create Request Maintenance</a>
        </div>

        <button data-target="#serviceScheduleMenu" 
                class="sidebar-menu-btn @if(str_contains($currentRoute, 'maintenance.service_schedule') || str_contains($currentRoute, 'maintenance.create_schedule')) active @endif">
            <i class="fas fa-calendar-alt sidebar-icon @if(str_contains($currentRoute, 'maintenance.service_schedule') || str_contains($currentRoute, 'maintenance.create_schedule')) active @endif" aria-hidden="true"></i> Service Schedule
            <i class="fas fa-chevron-down sidebar-chevron @if(str_contains($currentRoute, 'maintenance.service_schedule') || str_contains($currentRoute, 'maintenance.create_schedule')) active @endif" aria-hidden="true"></i>
        </button>
        <div id="serviceScheduleMenu" class="sidebar-submenu @if(str_contains($currentRoute, 'maintenance.service_schedule') || str_contains($currentRoute, 'maintenance.create_schedule')) active @endif">
            <a href="{{ route('maintenance.service_schedule') }}" data-page="service_schedule_home" 
               class="sidebar-sublink @if($currentRoute == 'maintenance.service_schedule') active @endif">Service Schedule Home</a>
            <a href="{{ route('maintenance.create_schedule') }}" data-page="create_service_schedule" 
               class="sidebar-sublink @if($currentRoute == 'maintenance.create_schedule') active @endif">Create Service Schedule</a>
        </div>

        <button data-target="#dvirReportsMenu" 
                class="sidebar-menu-btn @if(str_contains($currentRoute, 'dvir')) active @endif">
            <i class="fas fa-clipboard-check sidebar-icon @if(str_contains($currentRoute, 'dvir')) active @endif" aria-hidden="true"></i> DVIR Reports
            <i class="fas fa-chevron-down sidebar-chevron @if(str_contains($currentRoute, 'dvir')) active @endif" aria-hidden="true"></i>
        </button>
        <div id="dvirReportsMenu" class="sidebar-submenu @if(str_contains($currentRoute, 'dvir')) active @endif">
            <a href="{{ route('vehicles.dvir_dot_inspection') }}" data-page="dvir_reports_home" 
               class="sidebar-sublink @if($currentRoute == 'vehicles.dvir_dot_inspection') active @endif">DVIR Reports Home</a>
            <a href="/dvir-dot-inspection/create-dvir-report-step1" data-page="create_dvir_report" 
               class="sidebar-sublink @if(str_contains($currentRoute, 'dvir') && str_contains($currentRoute, 'create')) active @endif">Create DVIR Report</a>
        </div>

        {{-- LOGBOOK MENU - COMMENTED OUT --}}
     

        <button data-target="#fuelLogMenu" 
                class="sidebar-menu-btn @if(str_contains($currentRoute, 'fuel.')) active @endif">
            <i class="fas fa-gas-pump sidebar-icon @if(str_contains($currentRoute, 'fuel.')) active @endif" aria-hidden="true"></i> Fuel Log
            <i class="fas fa-chevron-down sidebar-chevron @if(str_contains($currentRoute, 'fuel.')) active @endif" aria-hidden="true"></i>
        </button>
        <div id="fuelLogMenu" class="sidebar-submenu @if(str_contains($currentRoute, 'fuel.')) active @endif">
            <a href="{{ route('fuel.logger') }}" data-page="fuel_log_home" 
               class="sidebar-sublink @if($currentRoute == 'fuel.logger') active @endif">Fuel Log Home</a>
            <a href="{{ route('fuel.new-entry') }}" data-page="create_fuel_log" 
               class="sidebar-sublink @if($currentRoute == 'fuel.new-entry') active @endif">Create Fuel Log</a>
        </div>

        <a href="{{ route('notice.index') }}" 
           data-page="notice_board"
           class="sidebar-link @if($currentRoute == 'notice.index' || $currentRoute == 'notice.create' || $currentRoute == 'notice.show') active @endif">
            <i class="fas fa-bullhorn sidebar-icon" aria-hidden="true"></i> Notice Board
        </a>

        <button data-target="#hrModuleMenu"     
                class="sidebar-menu-btn @if(str_contains($currentRoute, 'hr.')) active @endif">
            <i class="fas fa-users sidebar-icon @if(str_contains($currentRoute, 'hr.')) active @endif" aria-hidden="true"></i> HR Module
            <i class="fas fa-chevron-down sidebar-chevron @if(str_contains($currentRoute, 'hr.')) active @endif" aria-hidden="true"></i>
        </button>
        <div id="hrModuleMenu" class="sidebar-submenu @if(str_contains($currentRoute, 'hr.')) active @endif">
            <a href="{{ route('hr.admin.dashboard') }}" data-page="hr_dashboard" 
               class="sidebar-sublink @if($currentRoute == 'hr.admin.dashboard') active @endif">HR Dashboard</a>
            <a href="{{ route('hr.create.application') }}" data-page="create_hr_application" 
               class="sidebar-sublink @if($currentRoute == 'hr.create.application') active @endif">Submit Application</a>
        </div>


        <button data-target="#vehiclesMenu" 
                @if($isVehiclesActive) aria-expanded="true" @else aria-expanded="false" @endif
                class="sidebar-menu-btn @if($isVehiclesActive) active @endif">
            <i class="fas fa-car sidebar-icon @if($isVehiclesActive) active @endif" aria-hidden="true"></i> Equipments
            <i class="fas fa-chevron-down sidebar-chevron @if($isVehiclesActive) active @endif" aria-hidden="true"></i>
        </button>
        <div id="vehiclesMenu" class="sidebar-submenu @if($isVehiclesActive) active @endif">
            <a href="{{ route('vehicles.inventory') }}" data-page="vehicles_inventory" 
               class="sidebar-sublink @if($currentRoute == 'vehicles.inventory') active @endif">Equipment Inventory</a>
            <a href="{{ route('vehicles.overview') }}" data-page="vehicles_overview" 
               class="sidebar-sublink @if($currentRoute == 'vehicles.overview') active @endif">Equipment Overview</a>
        </div>

        {{-- MASTER DATA MENU - COMMENTED OUT --}}
        {{-- <button data-target="#masterDataMenu" 
                @if($isMasterDataActive) aria-expanded="true" @else aria-expanded="false" @endif
                class="sidebar-menu-btn @if($isMasterDataActive) active @endif">
            <i class="fas fa-database sidebar-icon @if($isMasterDataActive) active @endif" aria-hidden="true"></i> Master Data
            <i class="fas fa-chevron-down sidebar-chevron @if($isMasterDataActive) active @endif" aria-hidden="true"></i>
        </button>
        <div id="masterDataMenu" class="sidebar-submenu @if($isMasterDataActive) active @endif">
            <a href="{{ route('master_data.team') }}" data-page="team_management" 
               class="sidebar-sublink @if($currentRoute == 'master_data.team') active @endif">Team Management</a>
            <a href="{{ route('master_data.documents') }}" data-page="documents" 
               class="sidebar-sublink @if($currentRoute == 'master_data.documents') active @endif">Documents</a>
            <a href="{{ route('master_data.account') }}" data-page="account" 
class="sidebar-sublink @if($currentRoute == 'master_data.account') active @endif">Account</a>
            <a href="{{ route('master_data.subscription') }}" data-page="subscription" 
               class="sidebar-sublink @if($currentRoute == 'master_data.subscription') active @endif">Subscription</a>
            <a href="{{ route('account-deletion.admin.index') }}" data-page="account_deletion" 
               class="sidebar-sublink @if(str_starts_with($currentRoute, 'account-deletion.admin.')) active @endif">
               <i class="fas fa-user-times me-2"></i>Account Deletion Requests
            </a>
        </div> --}}

        <button data-target="#analyticsMenu" 
                @if($isAnalyticsActive) aria-expanded="true" @else aria-expanded="false" @endif
                class="sidebar-menu-btn @if($isAnalyticsActive) active @endif">
            <i class="fas fa-chart-line sidebar-icon @if($isAnalyticsActive) active @endif" aria-hidden="true"></i> Analytics Report & KPIs
            <i class="fas fa-chevron-down sidebar-chevron @if($isAnalyticsActive) active @endif" aria-hidden="true"></i>
        </button>
        <div id="analyticsMenu" class="sidebar-submenu @if($isAnalyticsActive) active @endif">
            {{-- <a href="{{ route('dashboard.excel_report') }}" data-page="excel_report" 
               class="sidebar-sublink @if($currentRoute == 'dashboard.excel_report') active @endif">Excel Report</a> --}}
            <a href="{{ route('dashboard.inspection_kpi') }}" data-page="inspection_kpi" 
               class="sidebar-sublink @if($currentRoute == 'dashboard.inspection_kpi') active @endif">Inspection KPI</a>
            <a href="{{ route('dashboard.incident_kpi') }}" data-page="incident_kpi" 
               class="sidebar-sublink @if($currentRoute == 'dashboard.incident_kpi') active @endif">Incident KPI</a>
            <!-- <a href="{{ route('dashboard.logbook_kpi') }}" data-page="logbook_kpi" 
               class="sidebar-sublink @if($currentRoute == 'dashboard.logbook_kpi') active @endif">Logbook KPI</a> -->
            <a href="{{ route('dashboard.maintenance_kpi') }}" data-page="maintenance_kpi" 
               class="sidebar-sublink @if($currentRoute == 'dashboard.maintenance_kpi') active @endif">Maintenance KPI</a>
            <a href="{{ route('dashboard.workorder_kpi') }}" data-page="workorder_kpi" 
               class="sidebar-sublink @if($currentRoute == 'dashboard.workorder_kpi') active @endif">Workorder KPI</a>
            <a href="{{ route('dashboard.fuel_management_kpi') }}" data-page="fuel_management_kpi" 
               class="sidebar-sublink @if($currentRoute == 'dashboard.fuel_management_kpi') active @endif">Fuel Management KPI</a>
            <a href="{{ route('dashboard.equipment_kpi') }}" data-page="equipment_kpi" 
               class="sidebar-sublink @if($currentRoute == 'dashboard.equipment_kpi') active @endif">Equipment KPI</a>
            <a href="{{ route('dashboard.team_employees_kpi') }}" data-page="team_employees_kpi" 
               class="sidebar-sublink @if($currentRoute == 'dashboard.team_employees_kpi') active @endif">Team/Employees KPI</a>
        </div>

        {{-- <a href="{{ route('vehicles.dvir_dot_inspection') }}" 
           data-page="dvir_dot_inspection"
           class="sidebar-link @if($currentRoute == 'vehicles.dvir_dot_inspection') active @endif">
            <i class="fas fa-cog sidebar-icon" aria-hidden="true"></i> Navigation Setting
        </a> --}}
    </nav>

    <div class="sidebar-footer">
        <a href="{{ route('users') }}" class="sidebar-link">
            <i class="fas fa-user sidebar-icon" aria-hidden="true"></i> User Info
        </a>
        
        
        <a href="#" class="sidebar-link">
            <i class="fas fa-sign-out-alt sidebar-icon" aria-hidden="true"></i> Logout
        </a>
    </div>

    <style>
        /* Main Sidebar Styles */
        #sidebar {
            width: 270px;
            height: 100vh;
            background: linear-gradient(180deg, #ffffff 0%, #f8fafc 100%);
            border-right: 1px solid #e2e8f0;
            position: fixed;
            top: 0;
            left: 0;
            transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1), opacity 0.3s ease;
            display: flex;
            flex-direction: column;
            z-index: 999;
            overflow-y: auto;
            padding-right: 5px;
            scrollbar-width: thin;
            box-shadow: 2px 0 4px 0 rgba(0, 0, 0, 0.05);
            padding-top: 70px;
            transform: translateX(0);
        }

        /* Sidebar Logo */
        .sidebar-logo {
            display: flex;
            align-items: center;
            padding: 20px 16px;
            border-bottom: 1px solid #e2e8f0;
            background: #ffffff;
            min-height: 70px;
            max-height: 70px;
            flex-shrink: 0;
            text-decoration: none;
        }

        .logo-image {
            max-width: 140px;
            height: 40px;
            object-fit: contain;
        }

        /* Sidebar Navigation */
        .sidebar-nav {
            flex: 1;
            overflow-y: auto;
            overflow-x: hidden;
            padding: 0;
            scrollbar-width: thin;
        }

        /* Sidebar Links */
        .sidebar-link {
            display: flex;
            align-items: center;
            padding: 16px 24px;
            color: #374151;
            font-size: 15px;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.2s ease;
            width: 100%;
            margin-bottom: 2px;
            border: none;
            background: none;
            text-align: left;
            position: relative;
            cursor: pointer;
            white-space: nowrap;
        }

        .sidebar-link:hover {
            background: #f8fafc;
            color: #1e293b;
        }

        .sidebar-link.active {
            background: #0055a5;
            color: white;
            box-shadow: 0 2px 4px 0 rgba(59, 130, 246, 0.3);
        }

        /* Sidebar Icons */
        .sidebar-icon {
            margin-right: 12px;
            font-size: 16px;
            width: 20px;
            text-align: center;
            flex-shrink: 0;
            display: inline-block;
            opacity: 1;
            visibility: visible;
        }

        .sidebar-link.active .sidebar-icon {
            color: white;
        }

        /* Menu Buttons */
        .sidebar-menu-btn {
            display: flex;
            align-items: center;
            padding: 16px 24px;
            color: #374151;
            font-size: 15px;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.2s ease;
            width: 100%;
            margin-bottom: 2px;
            border: none;
            background: none;
            text-align: left;
            position: relative;
            cursor: pointer;
            white-space: nowrap;
        }

        .sidebar-menu-btn:hover {
            background: #f8fafc;
            color: #1e293b;
        }

        .sidebar-menu-btn.active {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            color: #1e293b;
            border-left: 3px solid #0055a5;
        }

        .sidebar-menu-btn.active .sidebar-icon {
            color: #0055a5;
        }

        /* Chevron Icons */
        .sidebar-chevron {
            margin-left: auto;
            font-size: 12px;
            transition: transform 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94), opacity 0.3s ease;
            opacity: 0.7;
            cursor: pointer;
            padding: 4px;
            border-radius: 2px;
        }

        .sidebar-menu-btn.active .sidebar-chevron {
            transform: rotate(180deg);
            opacity: 1;
        }

        /* Submenu */
        .sidebar-submenu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94), opacity 0.3s ease 0.1s, transform 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            opacity: 0;
            transform: translateY(-20px) scale(0.98);
        }

        .sidebar-submenu.active {
            max-height: 500px;
            opacity: 1;
            transform: translateY(0) scale(1);
            border: none;
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            border-radius: 0;
            margin: 4px 0;
        }

        /* Sublinks */
        .sidebar-sublink {
            display: block;
            padding: 12px 24px 12px 56px;
            font-size: 14px;
            font-weight: 400;
            color: #6b7280;
            text-decoration: none;
            transition: all 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            position: relative;
            border-left: 2px solid transparent;
            opacity: 0;
            transform: translateX(-15px) translateY(-5px);
            white-space: nowrap;
            cursor: pointer;
        }

        .sidebar-submenu.active .sidebar-sublink {
            opacity: 1;
            transform: translateX(0) translateY(0);
        }

        .sidebar-sublink:hover {
            background: #f1f5f9;
            color: #374151;
        }

        .sidebar-sublink.active {
            background: linear-gradient(90deg, rgb(0, 85, 165) 0%, #f8fafc 100%);
            color: rgb(255, 255, 255);
            border-left-color: #0055a5;
            font-weight: 400;
        }

        /* Sidebar Footer */
        .sidebar-footer {
            flex-shrink: 0;
            background: #ffffff;
            border-top: 1px solid #e2e8f0;
            padding: 0;
            margin: 0;
        }


        .sidebar-dropdown-content .sidebar-sublink {
            padding: 8px 16px;
            font-size: 13px;
            color: #64748b;
            display: block;
            text-decoration: none;
            transition: all 0.2s ease;
        }

        .sidebar-dropdown-content .sidebar-sublink:hover {
            color: #0055a5;
            background-color: #e2e8f0;
        }

        .sidebar-dropdown-content .sidebar-sublink.active {
            color: #0055a5;
            background-color: #e2e8f0;
            font-weight: 500;
        }

        /* Responsive Styles */
        @media (max-width: 1200px) {
            #sidebar {
                width: 250px !important;
            }
        }

        @media (max-width: 992px) {
            #sidebar {
                width: 240px !important;
            }
            
            .sidebar-link,
            .sidebar-menu-btn {
                padding: 14px 20px !important;
                font-size: 14px !important;
            }
            
            .sidebar-sublink {
                padding: 10px 20px !important;
                font-size: 13px !important;
            }
        }

        @media (max-width: 768px) {
            #sidebar {
                display: none !important;
                visibility: hidden !important;
                opacity: 0 !important;
                transform: translateX(-100%) !important;
                width: 0 !important;
                height: 0 !important;
                overflow: hidden !important;
            }
        }

        @media (max-width: 576px) {
            #sidebar {
                display: none !important;
                visibility: hidden !important;
                opacity: 0 !important;
                transform: translateX(-100%) !important;
                width: 0 !important;
                height: 0 !important;
                overflow: hidden !important;
            }
        }

        /* Scrollbar styles for webkit browsers */
        #sidebar::-webkit-scrollbar {
            width: 6px;
        }

        #sidebar::-webkit-scrollbar-track {
            background: #f1f5f9;
        }

        #sidebar::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 3px;
        }

        #sidebar::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }
    </style>

    <script>
        // Optimized Sidebar Functionality
        (function() {
            'use strict';
            
            // Cache DOM elements
            const sidebar = document.getElementById('sidebar');
            const menuButtons = document.querySelectorAll('button[data-target]');
            const sublinks = document.querySelectorAll('a[data-page]');
            const dropdownIcons = document.querySelectorAll('i.fa-chevron-down');
            
            // Configuration
            const CONFIG = {
                mobileBreakpoint: 768,
                animationDelay: 100,
                transitionDuration: 300
            };

            // Utility Functions
            const isMobile = () => window.innerWidth <= CONFIG.mobileBreakpoint;
            const debounce = (func, wait) => {
                let timeout;
                return function executedFunction(...args) {
                    const later = () => {
                        clearTimeout(timeout);
                        func(...args);
                    };
                    clearTimeout(timeout);
                    timeout = setTimeout(later, wait);
                };
            };

            // Menu Management
            const MenuManager = {
                closeAllMenus() {
                    const openMenus = document.querySelectorAll('div[id$="Menu"]');
                    openMenus.forEach(menu => {
                        const isExpanded = menu.classList.contains('active');
                        if (isExpanded) {
                            menu.classList.remove('active');
                            
                            const button = document.querySelector(`[data-target="#${menu.id}"]`);
                            if (button) {
                                button.setAttribute('aria-expanded', 'false');
                                button.classList.remove('active');
                            }
                        }
                    });
                },

                toggleMenu(targetId) {
                    const targetElement = document.querySelector(targetId);
                    if (!targetElement) return;

                    const isExpanded = targetElement.classList.contains('active');
                    const button = document.querySelector(`[data-target="${targetId}"]`);
                    
                    if (isExpanded) {
                        // Close menu
                        targetElement.classList.remove('active');
                        
                        if (button) {
                            button.setAttribute('aria-expanded', 'false');
                            button.classList.remove('active');
                        }
                    } else {
                        // Close all other menus first
                        this.closeAllMenus();
                        
                        // Open this menu
                        targetElement.classList.add('active');
                        
                        if (button) {
                            button.setAttribute('aria-expanded', 'true');
                            button.classList.add('active');
                        }
                    }
                },

                expandCurrentSection() {
                    const currentUrl = window.location.pathname;
                    sublinks.forEach(link => {
                        if (link.getAttribute('href') === currentUrl) {
                            const parentMenu = link.closest('div[id$="Menu"]');
                            if (parentMenu) {
                                // Expand the menu
                                parentMenu.classList.add('active');
                                
                                const button = document.querySelector(`[data-target="#${parentMenu.id}"]`);
                                if (button) {
                                    button.setAttribute('aria-expanded', 'true');
                                    button.classList.add('active');
                                }
                            }
                        }
                    });
                }
            };

            // Event Handlers
            const EventHandlers = {
                handleMenuClick(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    const targetId = this.getAttribute('data-target');
                    MenuManager.toggleMenu(targetId);
                },

                handleDropdownClick(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    const parentButton = this.closest('.sidebar-toggle-btn');
                    if (parentButton) {
                        parentButton.click();
                    }
                },

                handleSublinkClick() {
                    if (isMobile()) {
                        setTimeout(() => {
                            MenuManager.closeAllMenus();
                        }, CONFIG.animationDelay);
                    }
                },

                handleOutsideClick(e) {
                    if (isMobile() && !e.target.closest('.sidebar')) {
                        MenuManager.closeAllMenus();
                    }
                },

                handleEscapeKey(e) {
                if (e.key === 'Escape') {
                        MenuManager.closeAllMenus();
                    }
                },

                handleResize: debounce(() => {
                    MenuManager.closeAllMenus();
                    
                setTimeout(() => {
                        MenuManager.expandCurrentSection();
                    }, CONFIG.animationDelay);
                }, CONFIG.transitionDuration)
            };



            // Initialize Sidebar
            function init() {
                if (!sidebar) return;

                // Bind event listeners
                menuButtons.forEach(button => {
                    button.addEventListener('click', EventHandlers.handleMenuClick);
                });

                dropdownIcons.forEach(icon => {
                    icon.addEventListener('click', EventHandlers.handleDropdownClick);
                });

                sublinks.forEach(link => {
                    link.addEventListener('click', EventHandlers.handleSublinkClick);
                });

                document.addEventListener('click', EventHandlers.handleOutsideClick);
                document.addEventListener('keydown', EventHandlers.handleEscapeKey);
                window.addEventListener('resize', EventHandlers.handleResize);

                // Initialize current section
                MenuManager.expandCurrentSection();
            }

            // Initialize when DOM is ready
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', init);
            } else {
                init();
            }
        })();
    </script>
</div>