<div id="sidebar">
    <a href="{{ route('dashboard') }}" class="sidebar-logo">
        <img src="/images/Sidebar-logo.png" alt="Titan Drilling" height="40" width="100" class="logo-image">
    </a>

    <nav role="navigation" aria-label="Main navigation" class="sidebar-nav">
        <a href="{{ route('dashboard') }}" 
            data-page="dashboard"
            class="sidebar-link @if(Route::currentRouteName() == 'dashboard') active @endif">
            <i class="fas fa-tachometer-alt sidebar-icon" aria-hidden="true"></i> Dashboard
        </a>

        @php
            $currentRoute = Route::currentRouteName();
            $isInspectionActive = str_starts_with($currentRoute, 'inspection.');
            $isMaintenanceActive = str_starts_with($currentRoute, 'maintenance.');
            $isFuelActive = str_starts_with($currentRoute, 'fuel.');
            $isVehiclesActive = str_starts_with($currentRoute, 'vehicles.');
            $isMasterDataActive = str_starts_with($currentRoute, 'master_data.');
            $isAnalyticsActive = in_array($currentRoute, ['dashboard.excel_report', 'dashboard.inspection_kpi', 'dashboard.maintenance_kpi', 'dashboard.fuel_management_kpi']);
        @endphp

        <button data-target="#inspectionMenu" 
                @if($isInspectionActive) aria-expanded="true" @else aria-expanded="false" @endif
                class="sidebar-menu-btn @if($isInspectionActive) active @endif">
            <i class="fas fa-search sidebar-icon @if($isInspectionActive) active @endif" aria-hidden="true"></i> Inspection
            <i class="fas fa-chevron-down sidebar-chevron @if($isInspectionActive) active @endif" aria-hidden="true"></i>
        </button>
        <div id="inspectionMenu" class="sidebar-submenu @if($isInspectionActive) active @endif">
            <a href="{{ route('inspection.inspection_report') }}" data-page="inspection_report" 
               class="sidebar-sublink @if($currentRoute == 'inspection.inspection_report') active @endif">Inspection Report</a>
            <a href="{{ route('inspection.operator_daily_reporting') }}" data-page="operator_daily_reporting" 
               class="sidebar-sublink @if($currentRoute == 'inspection.operator_daily_reporting') active @endif">Operator Daily Reporting</a>
            <a href="{{ route('inspection.incident_report') }}" data-page="incident_report" 
               class="sidebar-sublink @if($currentRoute == 'inspection.incident_report') active @endif">Incident Report</a>
            <a href="{{ route('inspection.incident_checklist') }}" data-page="incident_checklist" 
               class="sidebar-sublink @if($currentRoute == 'inspection.incident_checklist') active @endif">Inspection Checklist</a>
            <a href="{{ route('inspection.reminder') }}" data-page="reminder" 
               class="sidebar-sublink @if($currentRoute == 'inspection.reminder') active @endif">Reminder</a>
            <a href="{{ route('inspection.inspection2') }}" data-page="inspection2" 
               class="sidebar-sublink @if($currentRoute == 'inspection.inspection2') active @endif">Inspection 2</a>
            <a href="{{ route('inspection.document_upload') }}" data-page="document_upload" 
               class="sidebar-sublink @if($currentRoute == 'inspection.document_upload') active @endif">Document Upload</a>
            <a href="{{ route('inspection.do_inspection') }}" data-page="do_inspection" 
               class="sidebar-sublink @if($currentRoute == 'inspection.do_inspection') active @endif">Do Inspection</a>
            <a href="{{ route('inspection.back_to_incident_report') }}" data-page="back_to_incident_report"
               class="sidebar-sublink @if($currentRoute == 'inspection.back_to_incident_report') active @endif">Back to Incident Report</a>
        </div>

        <button data-target="#jobCardMenu"
                class="sidebar-menu-btn @if(str_contains($currentRoute, 'job_card') || $currentRoute == 'maintenance.jobcards') active @endif">
            <i class="fas fa-clipboard-list sidebar-icon @if(str_contains($currentRoute, 'job_card') || $currentRoute == 'maintenance.jobcards') active @endif" aria-hidden="true"></i> Job Cards
            <i class="fas fa-chevron-down sidebar-chevron @if(str_contains($currentRoute, 'job_card') || $currentRoute == 'maintenance.jobcards') active @endif" aria-hidden="true"></i>
        </button>
        <div id="jobCardMenu" class="sidebar-submenu @if(str_contains($currentRoute, 'job_card') || $currentRoute == 'maintenance.jobcards') active @endif">
                <a href="{{ route('maintenance.jobcards') }}" data-page="job_cards"
                   class="sidebar-sublink @if($currentRoute == 'maintenance.jobcards') active @endif">Job Cards List</a>
                <a href="{{ route('maintenance.workorders.create') }}" data-page="job_card_create"
                   class="sidebar-sublink @if($currentRoute == 'maintenance.workorders.create') active @endif">Create Job Card</a>
        </div>

        <a href="{{ route('vehicles.dvir_dot_inspection') }}"
           data-page="dvir_dot_inspection"
           class="sidebar-link @if($currentRoute == 'vehicles.dvir_dot_inspection') active @endif">
            <i class="fas fa-edit sidebar-icon" aria-hidden="true"></i> DVIR & DOT Inspection
        </a>

        <a href="{{ route('logbook') }}" 
           data-page="logbook"
           class="sidebar-link @if($currentRoute == 'logbook') active @endif">
            <i class="fas fa-book sidebar-icon" aria-hidden="true"></i> Logbook
        </a>

        <a href="{{ route('notice.index') }}" 
           data-page="notice_board"
           class="sidebar-link @if($currentRoute == 'notice.index' || $currentRoute == 'notice.create' || $currentRoute == 'notice.show') active @endif">
            <i class="fas fa-bullhorn sidebar-icon" aria-hidden="true"></i> Notice Board
        </a>

        <a href="{{ route('hr.admin.dashboard') }}" 
           data-page="hr_admin_dashboard"
           class="sidebar-link @if($currentRoute == 'hr.admin.dashboard') active @endif">
            <i class="fas fa-users sidebar-icon" aria-hidden="true"></i> HR Admin Dashboard
        </a>

        <button data-target="#maintenanceMenu" 
                @if($isMaintenanceActive) aria-expanded="true" @else aria-expanded="false" @endif
                class="sidebar-menu-btn @if($isMaintenanceActive) active @endif">
            <i class="fas fa-wrench sidebar-icon @if($isMaintenanceActive) active @endif" aria-hidden="true"></i> Maintenance
            <i class="fas fa-chevron-down sidebar-chevron @if($isMaintenanceActive) active @endif" aria-hidden="true"></i>
        </button>
        <div id="maintenanceMenu" class="sidebar-submenu @if($isMaintenanceActive) active @endif">
            <a href="{{ route('maintenance.workorder') }}" data-page="workorder" 
               class="sidebar-sublink @if($currentRoute == 'maintenance.workorder') active @endif">Workorder</a>
            <a href="{{ route('maintenance.request') }}" data-page="request_maintenance" 
               class="sidebar-sublink @if($currentRoute == 'maintenance.request') active @endif">Request Maintenance</a>
            <a href="{{ route('maintenance.service_schedule') }}" data-page="service_schedule" 
               class="sidebar-sublink @if($currentRoute == 'maintenance.service_schedule') active @endif">Service Schedule</a>
            <a href="{{ route('maintenance.parts_inventory') }}" data-page="parts_inventory" 
               class="sidebar-sublink @if($currentRoute == 'maintenance.parts_inventory') active @endif">Parts Inventory</a>
            <a href="{{ route('maintenance.labor_codes') }}" data-page="labor_codes" 
               class="sidebar-sublink @if($currentRoute == 'maintenance.labor_codes') active @endif">Labor Codes</a>
            <a href="{{ route('maintenance.task_master') }}" data-page="task_master" 
               class="sidebar-sublink @if($currentRoute == 'maintenance.task_master') active @endif">Task Master</a>
        </div>

        <button data-target="#fuelMenu" 
                @if($isFuelActive) aria-expanded="true" @else aria-expanded="false" @endif
                class="sidebar-menu-btn @if($isFuelActive) active @endif">
            <i class="fas fa-gas-pump sidebar-icon @if($isFuelActive) active @endif" aria-hidden="true"></i> Fuel Management
            <i class="fas fa-chevron-down sidebar-chevron @if($isFuelActive) active @endif" aria-hidden="true"></i>
        </button>
        <div id="fuelMenu" class="sidebar-submenu @if($isFuelActive) active @endif">
            <a href="{{ route('fuel.logger') }}" data-page="fuel_logger" 
               class="sidebar-sublink @if($currentRoute == 'fuel.logger') active @endif">Fuel Logger</a>
            <a href="{{ route('fuel.bunker') }}" data-page="fuel_bunker" 
               class="sidebar-sublink @if($currentRoute == 'fuel.bunker') active @endif">Fuel Bunker</a>
        </div>

        <button data-target="#vehiclesMenu" 
                @if($isVehiclesActive) aria-expanded="true" @else aria-expanded="false" @endif
                class="sidebar-menu-btn @if($isVehiclesActive) active @endif">
            <i class="fas fa-car sidebar-icon @if($isVehiclesActive) active @endif" aria-hidden="true"></i> Equipments
            <i class="fas fa-chevron-down sidebar-chevron @if($isVehiclesActive) active @endif" aria-hidden="true"></i>
        </button>
        <div id="vehiclesMenu" class="sidebar-submenu @if($isVehiclesActive) active @endif">
            <a href="{{ route('vehicles.inventory') }}" data-page="vehicles_inventory" 
               class="sidebar-sublink @if($currentRoute == 'vehicles.inventory') active @endif">Vehicles Inventory</a>
            <a href="{{ route('vehicles.overview') }}" data-page="vehicles_overview" 
               class="sidebar-sublink @if($currentRoute == 'vehicles.overview') active @endif">Vehicles Overview</a>
        </div>

        <button data-target="#masterDataMenu" 
                @if($isMasterDataActive) aria-expanded="true" @else aria-expanded="false" @endif
                class="sidebar-menu-btn @if($isMasterDataActive) active @endif">
            <i class="fas fa-database sidebar-icon @if($isMasterDataActive) active @endif" aria-hidden="true"></i> Master Data
            <i class="fas fa-chevron-down sidebar-chevron @if($isMasterDataActive) active @endif" aria-hidden="true"></i>
        </button>
        <div id="masterDataMenu" class="sidebar-submenu @if($isMasterDataActive) active @endif">
            <a href="{{ route('master_data.team') }}" data-page="team_management" 
               class="sidebar-sublink @if($currentRoute == 'master_data.team') active @endif">Team Management</a>
            <a href="{{ route('master_data.documents') }}" data-page="documents" 
               class="sidebar-sublink @if($currentRoute == 'master_data.documents') active @endif">Documents</a>
            <a href="{{ route('master_data.account') }}" data-page="account" 
class="sidebar-sublink @if($currentRoute == 'master_data.account') active @endif">Account</a>
            <a href="{{ route('master_data.subscription') }}" data-page="subscription" 
               class="sidebar-sublink @if($currentRoute == 'master_data.subscription') active @endif">Subscription</a>
            <a href="{{ route('account-deletion.admin.index') }}" data-page="account_deletion" 
               class="sidebar-sublink @if(str_starts_with($currentRoute, 'account-deletion.admin.')) active @endif">
               <i class="fas fa-user-times me-2"></i>Account Deletion Requests
            </a>
        </div>

        <button data-target="#analyticsMenu" 
                @if($isAnalyticsActive) aria-expanded="true" @else aria-expanded="false" @endif
                class="sidebar-menu-btn @if($isAnalyticsActive) active @endif">
            <i class="fas fa-chart-line sidebar-icon @if($isAnalyticsActive) active @endif" aria-hidden="true"></i> Analytics Report & KPIs
            <i class="fas fa-chevron-down sidebar-chevron @if($isAnalyticsActive) active @endif" aria-hidden="true"></i>
        </button>
        <div id="analyticsMenu" class="sidebar-submenu @if($isAnalyticsActive) active @endif">
            <a href="{{ route('dashboard.excel_report') }}" data-page="excel_report" 
               class="sidebar-sublink @if($currentRoute == 'dashboard.excel_report') active @endif">Excel Report</a>
            <a href="{{ route('dashboard.inspection_kpi') }}" data-page="inspection_kpi" 
               class="sidebar-sublink @if($currentRoute == 'dashboard.inspection_kpi') active @endif">Inspection KPI</a>
            <a href="{{ route('dashboard.maintenance_kpi') }}" data-page="maintenance_kpi" 
               class="sidebar-sublink @if($currentRoute == 'dashboard.maintenance_kpi') active @endif">Maintenance KPI</a>
            <a href="{{ route('dashboard.fuel_management_kpi') }}" data-page="fuel_management_kpi" 
               class="sidebar-sublink @if($currentRoute == 'dashboard.fuel_management_kpi') active @endif">Fuel Management KPI</a>
        </div>

        <a href="{{ route('vehicles.dvir_dot_inspection') }}" 
           data-page="dvir_dot_inspection"
           class="sidebar-link @if($currentRoute == 'vehicles.dvir_dot_inspection') active @endif">
            <i class="fas fa-cog sidebar-icon" aria-hidden="true"></i> Navigation Setting
        </a>
    </nav>

    <div class="sidebar-footer">
        <div class="language-selector">
            <select aria-label="Select language" class="language-select">
                <option value="en">English</option>
                <option value="es">Spanish</option>
                <option value="fr">French</option>
            </select>
        </div>
        
        <a href="{{ route('users') }}" class="sidebar-link">
            <i class="fas fa-user sidebar-icon" aria-hidden="true"></i> User Info
        </a>
        
        <button onclick="refreshContent()" type="button" class="sidebar-link">
            <i class="fas fa-sync-alt sidebar-icon" aria-hidden="true"></i> Refresh
        </button>
        
        <button onclick="toggleFullscreen()" type="button" class="sidebar-link">
            <i class="fas fa-expand sidebar-icon" aria-hidden="true"></i> Enter Full Screen
        </button>
        
        <a href="#" class="sidebar-link">
            <i class="fas fa-sign-out-alt sidebar-icon" aria-hidden="true"></i> Logout
        </a>
    </div>

    <style>
        /* Main Sidebar Styles */
        #sidebar {
            width: 270px;
            height: 100vh;
            background: linear-gradient(180deg, #ffffff 0%, #f8fafc 100%);
            border-right: 1px solid #e2e8f0;
            position: fixed;
            top: 0;
            left: 0;
            transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1), opacity 0.3s ease;
            display: flex;
            flex-direction: column;
            z-index: 999;
            overflow-y: auto;
            padding-right: 5px;
            scrollbar-width: thin;
            box-shadow: 2px 0 4px 0 rgba(0, 0, 0, 0.05);
            padding-top: 70px;
            transform: translateX(0);
        }

        /* Sidebar Logo */
        .sidebar-logo {
            display: flex;
            align-items: center;
            padding: 20px 16px;
            border-bottom: 1px solid #e2e8f0;
            background: #ffffff;
            min-height: 70px;
            max-height: 70px;
            flex-shrink: 0;
            text-decoration: none;
        }

        .logo-image {
            max-width: 140px;
            height: 40px;
            object-fit: contain;
        }

        /* Sidebar Navigation */
        .sidebar-nav {
            flex: 1;
            overflow-y: auto;
            overflow-x: hidden;
            padding: 0;
            scrollbar-width: thin;
        }

        /* Sidebar Links */
        .sidebar-link {
            display: flex;
            align-items: center;
            padding: 16px 24px;
            color: #374151;
            font-size: 15px;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.2s ease;
            width: 100%;
            margin-bottom: 2px;
            border: none;
            background: none;
            text-align: left;
            position: relative;
            cursor: pointer;
            white-space: nowrap;
        }

        .sidebar-link:hover {
            background: #f8fafc;
            color: #1e293b;
        }

        .sidebar-link.active {
            background: #0055a5;
            color: white;
            box-shadow: 0 2px 4px 0 rgba(59, 130, 246, 0.3);
        }

        /* Sidebar Icons */
        .sidebar-icon {
            margin-right: 12px;
            font-size: 16px;
            width: 20px;
            text-align: center;
            flex-shrink: 0;
            display: inline-block;
            opacity: 1;
            visibility: visible;
        }

        .sidebar-link.active .sidebar-icon {
            color: white;
        }

        /* Menu Buttons */
        .sidebar-menu-btn {
            display: flex;
            align-items: center;
            padding: 16px 24px;
            color: #374151;
            font-size: 15px;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.2s ease;
            width: 100%;
            margin-bottom: 2px;
            border: none;
            background: none;
            text-align: left;
            position: relative;
            cursor: pointer;
            white-space: nowrap;
        }

        .sidebar-menu-btn:hover {
            background: #f8fafc;
            color: #1e293b;
        }

        .sidebar-menu-btn.active {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            color: #1e293b;
            border-left: 3px solid #0055a5;
        }

        .sidebar-menu-btn.active .sidebar-icon {
            color: #0055a5;
        }

        /* Chevron Icons */
        .sidebar-chevron {
            margin-left: auto;
            font-size: 12px;
            transition: transform 0.4s cubic-bezier(0.25, 0.46, 0.45, 0.94), opacity 0.3s ease;
            opacity: 0.7;
            cursor: pointer;
            padding: 4px;
            border-radius: 2px;
        }

        .sidebar-menu-btn.active .sidebar-chevron {
            transform: rotate(180deg);
            opacity: 1;
        }

        /* Submenu */
        .sidebar-submenu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94), opacity 0.3s ease 0.1s, transform 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            opacity: 0;
            transform: translateY(-20px) scale(0.98);
        }

        .sidebar-submenu.active {
            max-height: 500px;
            opacity: 1;
            transform: translateY(0) scale(1);
            border: none;
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            border-radius: 0;
            margin: 4px 0;
        }

        /* Sublinks */
        .sidebar-sublink {
            display: block;
            padding: 12px 24px 12px 56px;
            font-size: 14px;
            font-weight: 400;
            color: #6b7280;
            text-decoration: none;
            transition: all 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            position: relative;
            border-left: 2px solid transparent;
            opacity: 0;
            transform: translateX(-15px) translateY(-5px);
            white-space: nowrap;
            cursor: pointer;
        }

        .sidebar-submenu.active .sidebar-sublink {
            opacity: 1;
            transform: translateX(0) translateY(0);
        }

        .sidebar-sublink:hover {
            background: #f1f5f9;
            color: #374151;
        }

        .sidebar-sublink.active {
            background: linear-gradient(90deg, rgb(0, 85, 165) 0%, #f8fafc 100%);
            color: rgb(255, 255, 255);
            border-left-color: #0055a5;
            font-weight: 400;
        }

        /* Sidebar Footer */
        .sidebar-footer {
            flex-shrink: 0;
            background: #ffffff;
            border-top: 1px solid #e2e8f0;
            padding: 0;
            margin: 0;
        }

        .language-selector {
            margin-bottom: 12px;
            padding: 16px;
        }

        .language-select {
            width: 100%;
            padding: 8px 12px;
            border: 1px solid #d1d5db;
            background: white;
            font-size: 14px;
            color: #374151;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .language-select:focus {
            outline: none;
            border-color: #0055a5;
            box-shadow: 0 0 0 3px rgba(0, 85, 165, 0.1);
        }


        .sidebar-dropdown-content .sidebar-sublink {
            padding: 8px 16px;
            font-size: 13px;
            color: #64748b;
            display: block;
            text-decoration: none;
            transition: all 0.2s ease;
        }

        .sidebar-dropdown-content .sidebar-sublink:hover {
            color: #0055a5;
            background-color: #e2e8f0;
        }

        .sidebar-dropdown-content .sidebar-sublink.active {
            color: #0055a5;
            background-color: #e2e8f0;
            font-weight: 500;
        }

        /* Responsive Styles */
        @media (max-width: 1200px) {
            #sidebar {
                width: 250px !important;
            }
        }

        @media (max-width: 992px) {
            #sidebar {
                width: 240px !important;
            }
            
            .sidebar-link,
            .sidebar-menu-btn {
                padding: 14px 20px !important;
                font-size: 14px !important;
            }
            
            .sidebar-sublink {
                padding: 10px 20px !important;
                font-size: 13px !important;
            }
        }

        @media (max-width: 768px) {
            #sidebar {
                display: none !important;
                visibility: hidden !important;
                opacity: 0 !important;
                transform: translateX(-100%) !important;
                width: 0 !important;
                height: 0 !important;
                overflow: hidden !important;
            }
        }

        @media (max-width: 576px) {
            #sidebar {
                display: none !important;
                visibility: hidden !important;
                opacity: 0 !important;
                transform: translateX(-100%) !important;
                width: 0 !important;
                height: 0 !important;
                overflow: hidden !important;
            }
        }

        /* Scrollbar styles for webkit browsers */
        #sidebar::-webkit-scrollbar {
            width: 6px;
        }

        #sidebar::-webkit-scrollbar-track {
            background: #f1f5f9;
        }

        #sidebar::-webkit-scrollbar-thumb {
            background: #cbd5e1;
            border-radius: 3px;
        }

        #sidebar::-webkit-scrollbar-thumb:hover {
            background: #94a3b8;
        }
    </style>

    <script>
        // Optimized Sidebar Functionality
        (function() {
            'use strict';
            
            // Cache DOM elements
            const sidebar = document.getElementById('sidebar');
            const menuButtons = document.querySelectorAll('button[data-target]');
            const sublinks = document.querySelectorAll('a[data-page]');
            const dropdownIcons = document.querySelectorAll('i.fa-chevron-down');
            
            // Configuration
            const CONFIG = {
                mobileBreakpoint: 768,
                animationDelay: 100,
                transitionDuration: 300
            };

            // Utility Functions
            const isMobile = () => window.innerWidth <= CONFIG.mobileBreakpoint;
            const debounce = (func, wait) => {
                let timeout;
                return function executedFunction(...args) {
                    const later = () => {
                        clearTimeout(timeout);
                        func(...args);
                    };
                    clearTimeout(timeout);
                    timeout = setTimeout(later, wait);
                };
            };

            // Menu Management
            const MenuManager = {
                closeAllMenus() {
                    const openMenus = document.querySelectorAll('div[id$="Menu"]');
                    openMenus.forEach(menu => {
                        const isExpanded = menu.classList.contains('active');
                        if (isExpanded) {
                            menu.classList.remove('active');
                            
                            const button = document.querySelector(`[data-target="#${menu.id}"]`);
                            if (button) {
                                button.setAttribute('aria-expanded', 'false');
                                button.classList.remove('active');
                            }
                        }
                    });
                },

                toggleMenu(targetId) {
                    const targetElement = document.querySelector(targetId);
                    if (!targetElement) return;

                    const isExpanded = targetElement.classList.contains('active');
                    const button = document.querySelector(`[data-target="${targetId}"]`);
                    
                    if (isExpanded) {
                        // Close menu
                        targetElement.classList.remove('active');
                        
                        if (button) {
                            button.setAttribute('aria-expanded', 'false');
                            button.classList.remove('active');
                        }
                    } else {
                        // Close all other menus first
                        this.closeAllMenus();
                        
                        // Open this menu
                        targetElement.classList.add('active');
                        
                        if (button) {
                            button.setAttribute('aria-expanded', 'true');
                            button.classList.add('active');
                        }
                    }
                },

                expandCurrentSection() {
                    const currentUrl = window.location.pathname;
                    sublinks.forEach(link => {
                        if (link.getAttribute('href') === currentUrl) {
                            const parentMenu = link.closest('div[id$="Menu"]');
                            if (parentMenu) {
                                // Expand the menu
                                parentMenu.classList.add('active');
                                
                                const button = document.querySelector(`[data-target="#${parentMenu.id}"]`);
                                if (button) {
                                    button.setAttribute('aria-expanded', 'true');
                                    button.classList.add('active');
                                }
                            }
                        }
                    });
                }
            };

            // Event Handlers
            const EventHandlers = {
                handleMenuClick(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    const targetId = this.getAttribute('data-target');
                    MenuManager.toggleMenu(targetId);
                },

                handleDropdownClick(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    const parentButton = this.closest('.sidebar-toggle-btn');
                    if (parentButton) {
                        parentButton.click();
                    }
                },

                handleSublinkClick() {
                    if (isMobile()) {
                        setTimeout(() => {
                            MenuManager.closeAllMenus();
                        }, CONFIG.animationDelay);
                    }
                },

                handleOutsideClick(e) {
                    if (isMobile() && !e.target.closest('.sidebar')) {
                        MenuManager.closeAllMenus();
                    }
                },

                handleEscapeKey(e) {
                if (e.key === 'Escape') {
                        MenuManager.closeAllMenus();
                    }
                },

                handleResize: debounce(() => {
                    MenuManager.closeAllMenus();
                    
                setTimeout(() => {
                        MenuManager.expandCurrentSection();
                    }, CONFIG.animationDelay);
                }, CONFIG.transitionDuration)
            };


            // Page Refresh Function
            window.refreshContent = function() {
            const currentPath = window.location.pathname;
                const pageMap = {
                    '/job_card': 'job_card',
                    '/job_card/create': 'job_card',
                    '/inspection/inspection-report': 'inspection_report',
                    '/inspection/operator-daily-reporting': 'operator_daily_reporting',
                    '/inspection/incident-report': 'incident_report',
                    '/inspection/incident-checklist': 'incident_checklist',
                    '/inspection/reminder': 'reminder',
                    '/inspection/inspection2': 'inspection2',
                    '/inspection/do-inspection': 'do_inspection',
                    '/inspection/back-to-incident-report': 'back_to_incident_report',
                    '/vehicles/dvir-dot-inspection': 'dvir_dot_inspection',
                    '/maintenance/workorder': 'workorder',
                    '/maintenance/request': 'request_maintenance',
                    '/maintenance/service-schedule': 'service_schedule',
                    '/maintenance/parts-inventory': 'parts_inventory',
                    '/maintenance/labor-codes': 'labor_codes',
                    '/maintenance/task-master': 'task_master',
                    '/fuel/logger': 'fuel_logger',
                    '/fuel/bunker': 'fuel_bunker',
                    '/vehicles/inventory': 'vehicles_inventory',
                    '/vehicles/overview': 'vehicles_overview',
                    '/master-data/team': 'team_management',
                    '/master-data/documents': 'documents',
                    '/master-data/account': 'account',
                    '/master-data/subscription': 'subscription',
                    '/dashboard/excel-report': 'excel_report',
                    '/dashboard/inspection-kpi': 'inspection_kpi',
                    '/dashboard/maintenance-kpi': 'maintenance_kpi',
                    '/dashboard/fuel-management-kpi': 'fuel_management_kpi'
                };

                let pageToLoad = pageMap[currentPath] || 'dashboard';
                
                if (currentPath === '/' || currentPath.includes('/dashboard')) {
                    pageToLoad = 'dashboard';
            }
            
            if (typeof loadPageDynamic === 'function' && pageToLoad) {
                try {
                    loadPageDynamic(pageToLoad);
                } catch (error) {
                    console.error('Dynamic loading failed:', error);
                    window.location.reload();
                }
            } else {
                window.location.reload();
            }
            };

            // Fullscreen Toggle Function
            window.toggleFullscreen = function() {
            if (!document.fullscreenElement) {
                document.documentElement.requestFullscreen().catch(err => {
                    console.log('Error attempting to enable fullscreen:', err);
                });
            } else {
                document.exitFullscreen();
            }
            };

            // Initialize Sidebar
            function init() {
                if (!sidebar) return;

                // Bind event listeners
                menuButtons.forEach(button => {
                    button.addEventListener('click', EventHandlers.handleMenuClick);
                });

                dropdownIcons.forEach(icon => {
                    icon.addEventListener('click', EventHandlers.handleDropdownClick);
                });

                sublinks.forEach(link => {
                    link.addEventListener('click', EventHandlers.handleSublinkClick);
                });

                document.addEventListener('click', EventHandlers.handleOutsideClick);
                document.addEventListener('keydown', EventHandlers.handleEscapeKey);
                window.addEventListener('resize', EventHandlers.handleResize);

                // Initialize current section
                MenuManager.expandCurrentSection();
            }

            // Initialize when DOM is ready
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', init);
            } else {
                init();
            }
        })();
    </script>
</div>