import React from 'react';
import { createBottomTabNavigator } from '@react-navigation/bottom-tabs';
import { createDrawerNavigator } from '@react-navigation/drawer';
import { createStackNavigator } from '@react-navigation/stack';
import { View, Text } from 'react-native';
import Animated from 'react-native-reanimated';
import LinearGradient from 'react-native-linear-gradient';
import MaterialIcons from 'react-native-vector-icons/MaterialIcons';
import AntDesign from 'react-native-vector-icons/AntDesign';
import Octicons from 'react-native-vector-icons/Octicons';
import Ionicons from 'react-native-vector-icons/Ionicons';

import TeamemberHome from './Homepage/TeamemberHome';
import TeamAccount from './Homepage/TeamAccount';
import TeamdataSync from './Homepage/TeamdataSync';
import TeamMainheader from './TeamMainheader';

const Tab = createBottomTabNavigator();
const Drawer = createDrawerNavigator();
const Stack = createStackNavigator();

// Custom Drawer Content
const DrawerContent = () => (
  <View style={{ flex: 1, padding: 20 }}>
    <Text>Drawer Content</Text>
    <Animated.View style={{ width: 100, height: 100, backgroundColor: 'blue' }} />
  </View>
);

// Gradient Background for Tab Bar
const GradientBackground = () => (
  <LinearGradient colors={['#3481BC', '#025383']} style={{ flex: 1 }} />
);

// Tab Navigator
const TabNavigator = () => (
  <Tab.Navigator
    screenOptions={({ route }) => ({
      tabBarIcon: ({ color, size }) => {
        if (route.name === 'Team Home') {
          return <AntDesign name="questioncircleo" size={size} color={color} />;
        } else if (route.name === 'Team Sync') {
          return <Octicons name="sync" size={size} color={color} />;
        } else if (route.name === 'Team Account') {
          return <Ionicons name="person-outline" size={size} color={color} />;
        }
      },
      tabBarActiveTintColor: 'white',
      tabBarInactiveTintColor: 'white',
      tabBarLabelStyle: { fontSize: 14, fontWeight: 'bold' },
      tabBarStyle: { backgroundColor: 'transparent' },
      tabBarBackground: () => <GradientBackground />,
      tabBarItemStyle: ({ focused }) => ({
        backgroundColor: focused ? '#025383' : 'transparent',
        borderRadius: 20,
        margin: 5,
      }),
      headerShown: false,
    })}
  >
    <Tab.Screen name="Team Home" component={TeamemberHome} />
    <Tab.Screen name="Team Sync" component={TeamdataSync} />
    <Tab.Screen name="Team Account" component={TeamAccount} />
  </Tab.Navigator>
);

// Stack Navigator for Team Home (for potential future expansions)
const TeamStack = () => (
  <Stack.Navigator screenOptions={{ headerShown: true }}>
    <Stack.Screen
      name="TeamHome"
      component={TeamemberHome}
      options={{ title: 'Team Home' }}
    />
  </Stack.Navigator>
);

// Secondary Stack (mirroring the original structure)
const SecondaryStack = () => (
  <Stack.Navigator screenOptions={{ headerShown: true }}>
    <Stack.Screen
      name="TeamHomeSecondary"
      component={TeamemberHome}
      options={{ title: 'Team Home' }}
    />
  </Stack.Navigator>
);

// Main Drawer Navigator
const TeamMainHomeNavigations = () => (
  <Drawer.Navigator
    drawerContent={() => <DrawerContent />}
    screenOptions={{
      drawerPosition: 'left',
      drawerActiveTintColor: '#007AFF',
      drawerInactiveTintColor: 'gray',
      header: ({ navigation }) => <TeamMainheader navigation={navigation} />,
    }}
  >
    <Drawer.Screen
      name="Main"
      component={TabNavigator}
      options={{
        drawerIcon: ({ color, size }) => <MaterialIcons name="home" size={size} color={color} />,
      }}
    />
    <Drawer.Screen
      name="Team"
      component={TeamStack}
      options={{
        drawerIcon: ({ color, size }) => <MaterialIcons name="build" size={size} color={color} />,
      }}
    />
    <Drawer.Screen
      name="Secondary"
      component={SecondaryStack}
      options={{
        drawerIcon: ({ color, size }) => <MaterialIcons name="settings" size={size} color={color} />,
      }}
    />
  </Drawer.Navigator>
);

export default TeamMainHomeNavigations;