import React from 'react';
import { NavigationContainer } from '@react-navigation/native';
import { createStackNavigator } from '@react-navigation/stack';
import { createBottomTabNavigator } from '@react-navigation/bottom-tabs';
import MaterialIcons from 'react-native-vector-icons/MaterialIcons';

// Import screens
import MongoDBLoginScreen from '../Screens/MongoDBLoginScreen';
import MongoDBHomeScreen from '../MainHome/MongoDBHomeScreen';

// Create navigators
const Stack = createStackNavigator();
const Tab = createBottomTabNavigator();

// Main App Stack Navigator
const MainAppStack = () => {
  return (
    <Stack.Navigator
      initialRouteName="MongoDBHome"
      screenOptions={{
        headerShown: false,
        gestureEnabled: true,
        cardStyleInterpolator: ({ current, layouts }) => {
          return {
            cardStyle: {
              transform: [
                {
                  translateX: current.progress.interpolate({
                    inputRange: [0, 1],
                    outputRange: [layouts.screen.width, 0],
                  }),
                },
              ],
            },
          };
        },
      }}
    >
      <Stack.Screen name="MongoDBHome" component={MongoDBHomeScreen} />
      {/* Add other screens here as needed */}
    </Stack.Navigator>
  );
};

// Main Navigation Container
const MongoDBNavigation = () => {
  return (
    <NavigationContainer>
      <Stack.Navigator
        initialRouteName="MongoDBLogin"
        screenOptions={{
          headerShown: false,
          gestureEnabled: false,
        }}
      >
        <Stack.Screen name="MongoDBLogin" component={MongoDBLoginScreen} />
        <Stack.Screen name="MainApp" component={MainAppStack} />
      </Stack.Navigator>
    </NavigationContainer>
  );
};

export default MongoDBNavigation;
