import AsyncStorage from '@react-native-async-storage/async-storage';
import database from '@react-native-firebase/database';

// Filter team members by permissions (copied from TeamMemberHome)
export const filterTeamMembersByPermissions = (members, userCountry, userProject, userPermissions, adminUid) => {
  let filteredMembers = [...members];
  if (userPermissions.includes('OnlyMineView')) {
    filteredMembers = filteredMembers.filter(member => member.id === adminUid);
  } else {
    filteredMembers = filteredMembers.filter(member => {
      const countryMatch = userCountry.length === 0 || (member.countries && member.countries.some(c => userCountry.includes(c)));
      const projectMatch = userProject.length === 0 || (member.projects && member.projects.some(p => userProject.includes(p)));
      return countryMatch && projectMatch;
    });
  }
  return filteredMembers;
};

// Fetch and filter team members from Firebase
export const getFilteredTeamMembers = async (adminUid, userCountry, userProject, userPermissions) => {
  const teamMembersRef = database().ref(`/Globalusers/admins`);
  const snapshot = await teamMembersRef.once('value');
  const data = snapshot.val();
  let membersArray = [];
  if (data) {
    membersArray = Object.keys(data).map((key) => ({
      ...data[key],
      id: key,
      fullName: data[key].name || 'N/A',
      employeeNumber: data[key].employeeNumber || 'N/A',
      projects: data[key].projects || [],
      countries: data[key].countries || [],
      role: data[key].role || 'Operator',
      isBlocked: data[key].isBlocked || false,
      password: data[key].password || 'N/A',
      profilePic: data[key].profilePic || null,
      driverLicenseNumber: data[key].driverLicenseNumber || '',
      driverLicenseCode: data[key].driverLicenseCode || '',
      driverLicenseExpiry: data[key].driverLicenseExpiry || '',
      dateCompletedFirstAid: data[key].dateCompletedFirstAid || '',
      expiryDateFirstAid: data[key].expiryDateFirstAid || '',
      fireFightingDateAttended: data[key].fireFightingDateAttended || '',
      blastingLicenseDateIssued: data[key].blastingLicenseDateIssued || '',
    }));
  }
  return filterTeamMembersByPermissions(membersArray, userCountry, userProject, userPermissions, adminUid);
}; 