// import React, { useState, useEffect, useRef } from 'react';
// import {
//   View,
//   Text,
//   StyleSheet,
//   TouchableOpacity,
//   StatusBar,
//   TextInput,
//   Dimensions,
//   FlatList,
//   Modal,
//   Animated,
//   Image,
// } from 'react-native';
// import LinearGradient from 'react-native-linear-gradient';
// import MaterialIcons from 'react-native-vector-icons/MaterialIcons';
// import { useNavigation } from '@react-navigation/native';
// import Toast from 'react-native-toast-message';
// import firestore from '@react-native-firebase/firestore';

// const { width } = Dimensions.get('window');
// const TOTAL_HEADER_HEIGHT = width * 0.45;

// const Downloaded_checklist = () => {
//   const navigation = useNavigation();
//   const [searchQuery, setSearchQuery] = useState('');
//   const [downloadedChecklists, setDownloadedChecklists] = useState([]);
//   const [filteredChecklists, setFilteredChecklists] = useState([]);
//   const [showLoaderModal, setShowLoaderModal] = useState(false);
//   const [popupIndex, setPopupIndex] = useState(null);

//   // Animation setup for loader icon
//   const rotateAnim = useRef(new Animated.Value(0)).current;
//   const rotateInterpolate = rotateAnim.interpolate({
//     inputRange: [0, 1],
//     outputRange: ['0deg', '360deg'],
//   });

//   // Start animation when loader modal is shown
//   useEffect(() => {
//     if (showLoaderModal) {
//       Animated.loop(
//         Animated.timing(rotateAnim, {
//           toValue: 1,
//           duration: 1000,
//           useNativeDriver: true,
//         })
//       ).start();
//     } else {
//       rotateAnim.setValue(0);
//     }
//   }, [showLoaderModal]);

//   // Load downloaded checklists from Firestore
//   useEffect(() => {
//     const loadDownloadedChecklists = async () => {
//       try {
//         setShowLoaderModal(true);
//         const snapshot = await firestore()
//           .collection('users')
//           .doc('userId') // Replace with actual user ID
//           .collection('downloadedChecklists')
//           .get();

//         const downloadedItems = snapshot.docs.map(doc => ({
//           id: doc.id,
//           ...doc.data(),
//           selected: false,
//           downloaded: true,
//         }));

//         setDownloadedChecklists(downloadedItems);
//         setFilteredChecklists(downloadedItems);
//       } catch (error) {
//         console.error('Error loading downloaded checklists:', error);
//         Toast.show({
//           type: 'error',
//           text1: 'Error',
//           text2: 'Failed to load downloaded checklists',
//         });
//       } finally {
//         setShowLoaderModal(false);
//       }
//     };
//     loadDownloadedChecklists();
//   }, []);

//   // Handle search
//   const handleSearch = (text) => {
//     setSearchQuery(text);
//     const filtered = downloadedChecklists.filter(
//       checklist =>
//         checklist.title.toLowerCase().includes(text.toLowerCase()) ||
//         checklist.description.toLowerCase().includes(text.toLowerCase())
//     );
//     setFilteredChecklists(filtered);
//   };

//   // Handle checklist selection
//   const toggleSelection = (id) => {
//     const updatedChecklists = downloadedChecklists.map(checklist =>
//       checklist.id === id ? { ...checklist, selected: !checklist.selected } : checklist
//     );
//     setDownloadedChecklists(updatedChecklists);
//     setFilteredChecklists(updatedChecklists.filter(
//       item =>
//         item.title.toLowerCase().includes(searchQuery.toLowerCase()) ||
//         item.description.toLowerCase().includes(searchQuery.toLowerCase())
//     ));
//   };

//   // Handle delete
//   const handleDelete = async (checklist) => {
//     setShowLoaderModal(true);
//     setPopupIndex(null);
//     try {
//       // Delete from Firestore
//       await firestore()
//         .collection('users')
//         .doc('userId') // Replace with actual user ID
//         .collection('downloadedChecklists')
//         .doc(checklist.id)
//         .delete();

//       const updatedChecklists = downloadedChecklists.filter(item => item.id !== checklist.id);
//       setDownloadedChecklists(updatedChecklists);
//       setFilteredChecklists(updatedChecklists.filter(
//         item =>
//           item.title.toLowerCase().includes(searchQuery.toLowerCase()) ||
//           item.description.toLowerCase().includes(searchQuery.toLowerCase())
//       ));

//       Toast.show({
//         type: 'success',
//         text1: 'Success',
//         text2: `${checklist.title} deleted successfully`,
//       });
//     } catch (error) {
//       console.error('Error deleting checklist:', error);
//       Toast.show({
//         type: 'error',
//         text1: 'Error',
//         text2: 'Failed to delete checklist',
//       });
//     } finally {
//       setShowLoaderModal(false);
//     }
//   };

//   const renderActions = (checklist) => {
//     return (
//       <View style={styles.actionsRow}>
//         <TouchableOpacity style={styles.actionButton}>
//           <Text style={styles.actionButtonText}>Start Inspection</Text>
//         </TouchableOpacity>
//         <TouchableOpacity
//           style={styles.viewButton}
//           onPress={() => navigation.navigate('ChecklistViewfile', { checklistId: checklist.id })}
//         >
//           <Text style={styles.viewButtonText}>View</Text>
//         </TouchableOpacity>
//       </View>
//     );
//   };

//   const renderItem = ({ item, index }) => (
//     <View style={styles.card}>
//       <View style={styles.cardTopRow}>
//         <View style={styles.circleNumber}>
//           <Text style={styles.circleNumberText}>{index + 1}</Text>
//         </View>
//         <TouchableOpacity onPress={() => toggleSelection(item.id)}>
//           {item.selected ? (
//             <MaterialIcons name="check" size={22} color="#015185" style={styles.checkIcon} />
//           ) : (
//             <View style={styles.checkIcon} />
//           )}
//         </TouchableOpacity>
//         <TouchableOpacity
//           style={styles.menuButton}
//           onPress={() => setPopupIndex(popupIndex === index ? null : index)}
//         >
//           <MaterialIcons name="more-vert" size={22} color="#015185" />
//         </TouchableOpacity>
//         {popupIndex === index && (
//           <TouchableWithoutFeedback onPress={() => setPopupIndex(null)}>
//             <View style={styles.popupOverlay}>
//               <View style={styles.popupMenu}>
//                 <TouchableOpacity
//                   style={styles.popupItem}
//                   onPress={() => handleDelete(item)}
//                 >
//                   <Text style={styles.popupText}>Delete</Text>
//                 </TouchableOpacity>
//               </View>
//             </View>
//           </TouchableWithoutFeedback>
//         )}
//       </View>
//       <Text style={styles.cardTitle}>{item.title}</Text>
//       <Text style={styles.cardSubtitle}>{item.description}</Text>
//       {renderActions(item)}
//     </View>
//   );

//   return (
//     <View style={styles.container}>
//       {/* Header */}
//       <LinearGradient
//         colors={['#3481BC', '#025383']}
//         style={[styles.header, { height: TOTAL_HEADER_HEIGHT }]}
//       >
//         <StatusBar translucent backgroundColor="transparent" barStyle="light-content" />
//         <View style={styles.headerContent}>
//           <View style={styles.headerLeft}>
//             <TouchableOpacity onPress={() => navigation.goBack()}>
//               <MaterialIcons name="arrow-back" size={width * 0.06} color="#fff" />
//             </TouchableOpacity>
//             <Text style={styles.headerTitle} numberOfLines={1} ellipsizeMode="tail">
//               Downloaded Checklists
//             </Text>
//           </View>
//         </View>
//         <Text style={styles.subHeaderText}>Tap on list to preview items</Text>

//         {/* Search Bar */}
//         <View style={styles.searchContainer}>
//           <View style={styles.searchWrapper}>
//             <TextInput
//               style={styles.searchInput}
//               placeholder="Search checklists..."
//               placeholderTextColor="#888"
//               value={searchQuery}
//               onChangeText={handleSearch}
//             />
//             <MaterialIcons name="search" size={width * 0.05} color="#888" style={styles.bladeIcon} />
//           </View>
//         </View>
//       </LinearGradient>

//       {/* Custom Loader Modal */}
//       <Modal
//         transparent={true}
//         visible={showLoaderModal}
//         animationType="fade"
//         onRequestClose={() => setShowLoaderModal(false)}
//       >
//         <View style={styles.modalOverlay}>
//           <View style={styles.modalContent}>
//             <Text style={styles.modalText}>Please Wait</Text>
//             <View style={styles.syncIcondiv}>
//               <Animated.Image
//                 source={require('../../../Images/adminlogin/sync.png')}
//                 style={[styles.syncIcon, { transform: [{ rotate: rotateInterpolate }] }]}
//               />
//               <Text style={styles.modalTextadd}>Processing Checklist Data</Text>
//             </View>
//           </View>
//         </View>
//       </Modal>

//       {/* Checklist List */}
//       <FlatList
//         data={filteredChecklists}
//         renderItem={renderItem}
//         keyExtractor={(item) => item.id}
//         contentContainerStyle={styles.mainContent}
//         ListEmptyComponent={<Text style={styles.defaultText}>No downloaded checklists found</Text>}
//       />

//       {/* Toast Component */}
//       <Toast />
//     </View>
//   );
// };

// const styles = StyleSheet.create({
//   container: {
//     flex: 1,
//     backgroundColor: '#fff',
//   },
//   header: {
//     width: '100%',
//     justifyContent: 'center',
//   },
//   headerContent: {
//     flexDirection: 'row',
//     alignItems: 'center',
//     justifyContent: 'space-between',
//     paddingHorizontal: width * 0.04,
//     paddingTop: StatusBar.currentHeight || width * 0.1,
//   },
//   headerLeft: {
//     flexDirection: 'row',
//     alignItems: 'center',
//     marginTop: 20,
//     flex: 1,
//   },
//   headerTitle: {
//     color: '#fff',
//     fontSize: width * 0.05,
//     fontWeight: 'bold',
//     marginLeft: width * 0.025,
//     flex: 1,
//   },
//   subHeaderText: {
//     color: '#fff',
//     fontSize: width * 0.035,
//     paddingHorizontal: width * 0.04,
//     paddingTop: 5,
//     paddingBottom: 10,
//   },
//   searchContainer: {
//     flexDirection: 'row',
//     alignItems: 'center',
//     marginHorizontal: 16,
//     marginTop: 8,
//     marginBottom: 12,
//     backgroundColor: '#fff',
//     borderRadius: 25,
//     paddingHorizontal: 16,
//     borderWidth: 1,
//     borderColor: '#E0E0E0',
//     height: 44,
//   },
//   searchWrapper: {
//     flex: 1,
//     flexDirection: 'row',
//     alignItems: 'center',
//     backgroundColor: '#fff',
//     borderRadius: 25,
//     paddingHorizontal: width * 0.025,
//   },
//   searchInput: {
//     flex: 1,
//     fontSize: 16,
//     color: '#222',
//     backgroundColor: 'transparent',
//     paddingVertical: 0,
//   },
//   bladeIcon: {
//     marginLeft: 8,
//   },
//   mainContent: {
//     paddingHorizontal: 0,
//     paddingVertical: 0,
//     paddingBottom: 30,
//   },
//   defaultText: {
//     fontSize: 16,
//     color: '#888',
//     textAlign: 'center',
//     marginVertical: 20,
//   },
//   card: {
//     backgroundColor: '#F2F2F2',
//     borderRadius: 12,
//     marginHorizontal: 16,
//     marginTop: 18,
//     paddingVertical: 18,
//     paddingHorizontal: 12,
//     alignItems: 'center',
//     position: 'relative',
//     minHeight: 120,
//   },
//   cardTopRow: {
//     flexDirection: 'row',
//     alignItems: 'center',
//     width: '100%',
//     justifyContent: 'center',
//     marginBottom: 8,
//   },
//   circleNumber: {
//     width: 32,
//     height: 32,
//     borderRadius: 16,
//     backgroundColor: '#015185',
//     alignItems: 'center',
//     justifyContent: 'center',
//     position: 'absolute',
//     left: 0,
//     top: 0,
//   },
//   circleNumberText: {
//     color: '#fff',
//     fontWeight: 'bold',
//     fontSize: 18,
//   },
//   checkIcon: {
//     position: 'absolute',
//     right: 32,
//     top: 4,
//   },
//   menuButton: {
//     position: 'absolute',
//     right: 0,
//     top: 0,
//     padding: 4,
//   },
//   popupOverlay: {
//     position: 'absolute',
//     top: 30,
//     right: 0,
//     left: 0,
//     bottom: 0,
//     zIndex: 100,
//   },
//   popupMenu: {
//     position: 'absolute',
//     top: 0,
//     right: 0,
//     backgroundColor: '#fff',
//     borderRadius: 6,
//     elevation: 5,
//     shadowColor: '#000',
//     shadowOffset: { width: 0, height: 2 },
//     shadowOpacity: 0.15,
//     shadowRadius: 4,
//     zIndex: 101,
//     paddingHorizontal: 18,
//     paddingVertical: 10,
//     width: width * 0.3,
//   },
//   popupItem: {
//     paddingVertical: 4,
//   },
//   popupText: {
//     color: '#222',
//     fontSize: 15,
//   },
//   cardTitle: {
//     fontSize: 15,
//     fontWeight: 'bold',
//     color: '#222',
//     textAlign: 'center',
//     marginTop: 8,
//   },
//   cardSubtitle: {
//     fontSize: 13,
//     color: '#888',
//     textAlign: 'center',
//     marginBottom: 10,
//   },
//   actionsRow: {
//     flexDirection: 'row',
//     justifyContent: 'center',
//     marginTop: 4,
//   },
//   actionButton: {
//     backgroundColor: '#fff',
//     borderRadius: 4,
//     paddingHorizontal: 10,
//     paddingVertical: 4,
//     borderWidth: 1,
//     borderColor: '#015185',
//     marginHorizontal: 4,
//   },
//   actionButtonText: {
//     color: '#015185',
//     fontWeight: 'bold',
//     fontSize: 13,
//   },
//   viewButton: {
//     backgroundColor: '#015185',
//     borderRadius: 4,
//     paddingHorizontal: 10,
//     paddingVertical: 4,
//     marginHorizontal: 4,
//   },
//   viewButtonText: {
//     color: '#fff',
//     fontWeight: 'bold',
//     fontSize: 13,
//   },
//   modalOverlay: {
//     flex: 1,
//     backgroundColor: 'rgba(0,0,0,0.5)',
//     justifyContent: 'center',
//     alignItems: 'center',
//   },
//   modalContent: {
//     width: '70%',
//     backgroundColor: 'white',
//     borderRadius: 10,
//     padding: 20,
//     alignItems: 'center',
//   },
//   modalText: {
//     fontSize: 18,
//     marginBottom: 10,
//     color: '#333',
//   },
//   modalTextadd: {
//     fontSize: 14,
//     color: '#333',
//   },
//   syncIcon: {
//     width: 30,
//     height: 30,
//     marginRight: 10,
//   },
//   syncIcondiv: {
//     flexDirection: 'row',
//     alignItems: 'center',
//     justifyContent: 'center',
//   },
// });

// export default Downloaded_checklist;

import React, { useState, useEffect } from 'react';
import { View, Text, StyleSheet, TouchableOpacity, ActivityIndicator, Platform, ToastAndroid, Modal } from 'react-native';
import LinearGradient from 'react-native-linear-gradient';
import MaterialIcons from 'react-native-vector-icons/MaterialIcons';
import AsyncStorage from '@react-native-async-storage/async-storage';
import database from '@react-native-firebase/database';
import storage from '@react-native-firebase/storage';
import auth from '@react-native-firebase/auth';
import NetInfo from '@react-native-community/netinfo';
import Toast from 'react-native-toast-message';
import checklistData from './AllJsons.json'; // Path to your checklist JSON (ensure it contains the `checklist` array)
import { encode as b64encode } from 'base-64';
import { encode as utf8encode } from 'utf8';

const Downloaded_checklist = () => {
  const [isUploading, setIsUploading] = useState(false);
  const [uploadStatus, setUploadStatus] = useState('Ready to upload');
  const [permissionsModalVisible, setPermissionsModalVisible] = useState(false);
  const [userPermissions, setUserPermissions] = useState({
    countries: [],
    projects: [],
    checklistPermissions: [],
  });

  // Validate checklist data structure
  const validateChecklistData = (data) => {
    if (!data || !Array.isArray(data.checklist)) {
      return { valid: false, error: 'Checklist data must contain an array under the "checklist" key' };
    }
    for (const form of data.checklist) {
      if (
        !form.formTitle ||
        !form.inspectionItems ||
        !Array.isArray(form.inspectionItems) ||
        !form.inspectionMatrix ||
        !Array.isArray(form.inspectionMatrix)
      ) {
        return { valid: false, error: `Invalid form structure in ${form.formTitle || 'unknown form'}` };
      }
      for (const item of form.inspectionMatrix) {
        if (!item.item || !Array.isArray(item.checks) || item.checks.length !== 31) {
          return { valid: false, error: `Invalid inspection matrix in ${form.formTitle}` };
        }
      }
    }
    return { valid: true };
  };

  // Check network status
  const checkNetworkStatus = async () => {
    try {
      const netInfo = await NetInfo.fetch();
      return netInfo.isConnected;
    } catch (error) {
      console.error('Error checking network status:', error);
      return false;
    }
  };

  // Show toast notifications
  const showToast = (type, text1, text2) => {
    if (Platform.OS === 'android') {
      ToastAndroid.show(`${text1}: ${text2}`, ToastAndroid.LONG);
    } else {
      Toast.show({
        type,
        text1,
        text2,
        position: 'bottom',
      });
    }
  };

  // Fetch user permissions from Firebase
  const fetchUserPermissions = async () => {
    try {
      const userUid = await AsyncStorage.getItem('userUid');
      if (!userUid) {
        throw new Error('User not authenticated. Please log in again.');
      }

      const userSnapshot = await database()
        .ref(`/Globalusers/admins/${userUid}`)
        .once('value');
      const userData = userSnapshot.val();

      if (!userData) {
        throw new Error('User data not found.');
      }

      const checklistModule = userData.modules?.find((mod) => mod.module === 'checklist');
      const permissions = checklistModule?.permissions || [];

      setUserPermissions({
        countries: userData.countries || [],
        projects: userData.projects || [],
        checklistPermissions: permissions,
      });

      if (!permissions.includes('upload')) {
        throw new Error('User lacks permission to upload checklists.');
      }
    } catch (error) {
      console.error('Error fetching user permissions:', error);
      showToast('error', 'Error', error.message || 'Failed to fetch user permissions.');
      setUserPermissions({
        countries: [],
        projects: [],
        checklistPermissions: [],
      });
    }
  };

  // Upload checklist data to Firebase
  const uploadToFirebase = async () => {
    setIsUploading(true);
    setUploadStatus('Uploading...');

    try {
      const user = auth().currentUser;
      if (!user || user.email !== '2@gmail.com') {
        throw new Error('Please log in with 2@gmail.com');
      }

      const userUid = await AsyncStorage.getItem('userUid');
      if (!userUid) {
        throw new Error('User authentication data missing');
      }

      const isOnline = await checkNetworkStatus();
      if (!isOnline) {
        setUploadStatus('Failed: No internet connection');
        showToast('info', 'Offline', 'Data will be uploaded when online');
        await AsyncStorage.setItem('pendingChecklistUpload', JSON.stringify(checklistData));
        setIsUploading(false);
        return;
      }

      // Validate checklist data
      const validation = validateChecklistData(checklistData);
      if (!validation.valid) {
        throw new Error(validation.error);
      }

      console.log('Uploading checklist data:', checklistData.checklist.length, 'forms');

      // Firebase Realtime Database path
      const dbRef = database().ref('/DailyInspectionReportJsonChecklists/AllDailyReportChecklistsJson');

      // Upload to Realtime Database
      await dbRef.set(checklistData.checklist);
      console.log('Data uploaded to Realtime Database');

      // Upload to Firebase Storage
      const storageRef = storage().ref('/DailyInspectionReportJsonChecklists/AllDailyReportChecklistsJson/AllJsons.json');
      const jsonString = JSON.stringify(checklistData.checklist);
      const base64String = b64encode(utf8encode(jsonString));
      await storageRef.putString(base64String, 'base64', {
        contentType: 'application/json',
      });
      const downloadUrl = await storageRef.getDownloadURL();
      console.log('Data uploaded to Storage, download URL:', downloadUrl);

      // Update Realtime Database with download URL
      await dbRef.update({ downloadUrl });

      // Cache locally
      await AsyncStorage.setItem('checklist_data', JSON.stringify(checklistData.checklist));

      setUploadStatus('Success: Data uploaded to Firebase');
      showToast('success', 'Success', 'Data uploaded to Realtime Database and Storage');
      await AsyncStorage.removeItem('pendingChecklistUpload');
    } catch (error) {
      console.error('Error uploading to Firebase:', error);
      setUploadStatus(`Failed: ${error.message}`);
      showToast('error', 'Error', `Failed to upload data: ${error.message}`);
      await AsyncStorage.setItem('pendingChecklistUpload', JSON.stringify(checklistData));
    } finally {
      setIsUploading(false);
    }
  };

  // Check for pending uploads and initialize on mount
  useEffect(() => {
    const initialize = async () => {
      await fetchUserPermissions();

      const pendingData = await AsyncStorage.getItem('pendingChecklistUpload');
      if (pendingData && (await checkNetworkStatus())) {
        setIsUploading(true);
        setUploadStatus('Syncing pending upload...');
        try {
          const data = JSON.parse(pendingData);
          const validation = validateChecklistData({ checklist: data });
          if (!validation.valid) {
            throw new Error(validation.error);
          }

          console.log('Syncing pending data:', data.length, 'forms');

          // Firebase Realtime Database path
          const dbRef = database().ref('/DailyInspectionReportJsonChecklists/AllDailyReportChecklistsJson');

          // Upload to Realtime Database
          await dbRef.set(data);
          console.log('Pending data uploaded to Realtime Database');

          // Upload to Firebase Storage
          const storageRef = storage().ref('/DailyInspectionReportJsonChecklists/AllDailyReportChecklistsJson/AllJsons.json');
          const jsonString = JSON.stringify(data);
          const base64String = b64encode(utf8encode(jsonString));
          await storageRef.putString(base64String, 'base64', {
            contentType: 'application/json',
          });
          const downloadUrl = await storageRef.getDownloadURL();
          console.log('Pending data uploaded to Storage, download URL:', downloadUrl);

          // Update Realtime Database with download URL
          await dbRef.update({ downloadUrl });

          // Cache locally
          await AsyncStorage.setItem('checklist_data', JSON.stringify(data));

          setUploadStatus('Success: Pending data synced');
          showToast('success', 'Success', 'Pending data uploaded to Firebase');
          await AsyncStorage.removeItem('pendingChecklistUpload');
        } catch (error) {
          console.error('Error syncing pending upload:', error);
          setUploadStatus(`Failed to sync: ${error.message}`);
          showToast('error', 'Error', `Failed to sync pending data: ${error.message}`);
        } finally {
          setIsUploading(false);
        }
      }
    };

    initialize();

    const unsubscribe = auth().onAuthStateChanged((user) => {
      if (!user || user.email !== 'amit.owninfotech@gmail.com') {
        setUploadStatus('Please log in with amit.owninfotech@gmail.com');
      }
    });

    return () => unsubscribe();
  }, []);

  return (
    <View style={styles.container}>
      <LinearGradient colors={['#3481BC', '#025383']} style={styles.header}>
        <View style={styles.headerContent}>
          <TouchableOpacity onPress={() => {}}>
            <MaterialIcons name="arrow-back" size={24} color="#fff" />
          </TouchableOpacity>
          <Text style={styles.headerTitle}>Checklist Upload</Text>
          <View style={styles.headerRight}>
            <TouchableOpacity
              style={styles.iconButton}
              onPress={() => setPermissionsModalVisible(true)}
            >
              <MaterialIcons name="lock" size={24} color="#fff" />
            </TouchableOpacity>
          </View>
        </View>
      </LinearGradient>

      <View style={styles.mainContent}>
        <Text style={styles.countText}>
          Total Checklists: {checklistData?.checklist?.length || 0}
        </Text>
        <Text style={styles.statusText}>Status: {uploadStatus}</Text>
        <TouchableOpacity
          style={[styles.uploadButton, isUploading && styles.disabledButton]}
          onPress={uploadToFirebase}
          disabled={isUploading}
        >
          <LinearGradient colors={['#3481BC', '#025383']} style={styles.buttonGradient}>
            <Text style={styles.buttonText}>
              {isUploading ? 'Uploading...' : 'Upload Checklist Data'}
            </Text>
            {isUploading && <ActivityIndicator color="#fff" style={styles.loader} />}
          </LinearGradient>
        </TouchableOpacity>
      </View>

      <Modal
        visible={permissionsModalVisible}
        transparent={true}
        animationType="fade"
        onRequestClose={() => setPermissionsModalVisible(false)}
      >
        <View style={styles.modalOverlay}>
          <View style={styles.permissionsModalContent}>
            <Text style={styles.permissionsModalTitle}>User Permissions</Text>
            <View style={styles.permissionsSection}>
              <Text style={styles.permissionsLabel}>Countries</Text>
              <Text style={styles.permissionsValue}>
                {userPermissions.countries.length > 0
                  ? userPermissions.countries.join(', ')
                  : 'None'}
              </Text>
            </View>
            <View style={styles.permissionsSection}>
              <Text style={styles.permissionsLabel}>Projects</Text>
              <Text style={styles.permissionsValue}>
                {userPermissions.projects.length > 0
                  ? userPermissions.projects.join(', ')
                  : 'None'}
              </Text>
            </View>
            <View style={styles.permissionsSection}>
              <Text style={styles.permissionsLabel}>Checklist Permissions</Text>
              <Text style={styles.permissionsValue}>
                {userPermissions.checklistPermissions.length > 0
                  ? userPermissions.checklistPermissions.join(', ')
                  : 'None'}
              </Text>
            </View>
            <TouchableOpacity
              style={[styles.modalButton, styles.cancelButton]}
              onPress={() => setPermissionsModalVisible(false)}
            >
              <Text style={styles.modalButtonText}>Close</Text>
            </TouchableOpacity>
          </View>
        </View>
      </Modal>

      <Toast />
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: '#fff',
  },
  header: {
    paddingTop: Platform.OS === 'ios' ? 50 : 30,
    paddingBottom: 20,
    paddingHorizontal: 16,
  },
  headerContent: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
  },
  headerRight: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  headerTitle: {
    color: '#fff',
    fontSize: 20,
    fontWeight: 'bold',
    marginLeft: 10,
  },
  iconButton: {
    padding: 5,
  },
  mainContent: {
    flex: 1,
    padding: 16,
    justifyContent: 'center',
    alignItems: 'center',
  },
  statusText: {
    fontSize: 16,
    color: '#333',
    marginBottom: 20,
    textAlign: 'center',
  },
  uploadButton: {
    borderRadius: 8,
    overflow: 'hidden',
  },
  disabledButton: {
    opacity: 0.6,
  },
  buttonGradient: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingVertical: 12,
    paddingHorizontal: 24,
  },
  buttonText: {
    color: '#fff',
    fontSize: 16,
    fontWeight: '600',
  },
  loader: {
    marginLeft: 10,
  },
  modalOverlay: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: 'rgba(0,0,0,0.5)',
  },
  permissionsModalContent: {
    backgroundColor: '#fff',
    borderRadius: 10,
    padding: 20,
    width: '80%',
    alignItems: 'center',
  },
  permissionsModalTitle: {
    fontSize: 18,
    fontWeight: 'bold',
    color: '#3481BC',
    marginBottom: 15,
  },
  permissionsSection: {
    width: '100%',
    marginBottom: 15,
  },
  permissionsLabel: {
    fontSize: 16,
    fontWeight: '600',
    color: '#333',
    marginBottom: 5,
  },
  permissionsValue: {
    fontSize: 16,
    color: '#333',
    textAlign: 'left',
  },
  modalButton: {
    flex: 1,
    paddingVertical: 10,
    alignItems: 'center',
    borderRadius: 5,
    marginHorizontal: 5,
  },
  cancelButton: {
    backgroundColor: '#f0f0f0',
  },
  modalButtonText: {
    fontSize: 16,
    color: '#333',
    fontWeight: '600',
  },
  countText: {
    fontSize: 18,
    color: '#025383',
    fontWeight: 'bold',
    marginBottom: 10,
    textAlign: 'center',
  },
});

export default Downloaded_checklist;