#!/bin/bash

# Upload backend files to server
# Server: 168.231.113.219
# Directory: /root/node-mongo-api
# Password: 5aXBS2f-y/vwM8#

export SSHPASS='5aXBS2f-y/vwM8#'

echo "🚀 Uploading backend files to server..."
echo ""

# First, upload main backend files
echo "Step 1/3: Uploading backend files..."
sshpass -e scp -r -o ConnectTimeout=30 -o ServerAliveInterval=60 -o StrictHostKeyChecking=no \
    server.js \
    dbConnection.js \
    GlobalEquipmentJsonData.js \
    GlobalEDocumentsHandle3.js \
    GlobalAdminUsersHandle.js \
    GlobalInspectionHandler.js \
    GlobalJobcardReports.js \
    GlobalDVIRhandler.js \
    GlobalIncidentReportHandle.js \
    GlobalDailyReportsHandle.js \
    GlobalRequestMaintenanceHandler.js \
    GlobalFuelLogHandle.js \
    GlobalServiceSchdule.js \
    titandrillingchecklistsModule \
    GlobalLogbookHandle.js \
    GlobalHRformApplications.js \
    GlobalHSEInspectionHandler.js \
    NoticeWelltoall.js \
    PushNotificationHandler.js \
    GlobalNotificationsHandle.js \
    ProWebAdmin \
    root@168.231.113.219:/root/node-mongo-api/

if [ $? -eq 0 ]; then
    echo "Backend files uploaded!"
else
    echo " Backend files upload failed!"
    exit 1
fi

# Upload EmailsandPushN folder
echo ""
echo "Step 2/3: Uploading EmailsandPushN folder..."
sshpass -e scp -r -o ConnectTimeout=30 -o ServerAliveInterval=60 -o StrictHostKeyChecking=no \
    EmailsandPushN/ \
    root@168.231.113.219:/root/node-mongo-api/

if [ $? -eq 0 ]; then
    echo "EmailsandPushN folder uploaded!"
else
    echo " EmailsandPushN upload failed!"
    exit 1
fi

# Upload scripts folder (optional - skip if fails)
echo ""
echo "Step 3/3: Uploading scripts folder..."
if [ -d "../scripts" ]; then
    sshpass -e scp -r -o ConnectTimeout=30 -o ServerAliveInterval=60 -o StrictHostKeyChecking=no \
        ../scripts \
        root@168.231.113.219:/root/node-mongo-api/
    
    if [ $? -eq 0 ]; then
        echo "Scripts folder uploaded!"
    else
        echo "⚠️  Scripts upload failed (continuing anyway...)"
    fi
else
    echo "⚠️  Scripts folder not found (skipping...)"
fi

echo ""
echo "All files uploaded successfully!"
echo ""
echo "🔄 Restarting PM2 server..."
sshpass -e ssh -o ConnectTimeout=30 -o StrictHostKeyChecking=no root@168.231.113.219 "cd /root/node-mongo-api && pm2 restart titan-drilling-api"

if [ $? -eq 0 ]; then
    echo ""
    echo "Server restarted successfully!"
    echo ""
    echo "🎉 Deployment complete!"
    echo "📡 HR Notifications API: http://api.titandrillingzm.com:5027"
else
    echo ""
    echo "⚠️  Server restart failed - please restart manually"
fi

