@extends('welcome')

@section('title', 'Vehicles Overview')

@section('content')
<div class="vehicles-overview-container">
    <div class="vehicles-overview-header">
        <div class="header-content">
            <div class="page-title">
                <h1>Vehicles Overview</h1>
                <p>Search and view detailed information about your vehicles</p>
            </div>
        </div>
    </div>
    
    <div class="vehicles-overview-content">
        <div class="content-box">
            <div class="action-bar">
                <div class="action-content">
                    <div class="page-title">
                        <h1>Vehicle Search</h1>
                    </div>
                </div>
            </div>
            
            <div class="search-section">
                <div class="search-form">
                    <div class="form-grid">
                        <div class="form-group">
                            <label for="vnum" class="form-label">Serial Number</label>
                            <div class="input-with-icon">
                                <input type="text" class="form-control" placeholder="Input serial number/barcode and press enter" id="vnum">
                                <svg class="input-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="11" cy="11" r="8"/>
                                    <path d="m21 21-4.35-4.35"/>
                                </svg>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="regExpDate1" class="form-label">Registration Exp Date</label>
                            <input type="date" class="form-control" id="regExpDate1">
                        </div>
                        <div class="form-group">
                            <label for="regExpDate2" class="form-label">Registration Exp Date</label>
                            <input type="date" class="form-control" id="regExpDate2">
                        </div>
                        <div class="form-group">
                            <label class="form-label">&nbsp;</label>
                            <button class="btn-view" data-bs-toggle="modal" data-bs-target="#view-detail">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>
                                    <circle cx="12" cy="12" r="3"/>
                                </svg>
                                View Details
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function toggleSidebar() {
        const sidebar = document.querySelector('.sidebar');
        sidebar.classList.toggle('collapsed');
    }
</script>
<!-- Modern Vehicle Overview Modal -->
<div class="modal fade" id="view-detail" tabindex="-1" aria-labelledby="viewDetailModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="viewDetailModalLabel">Vehicle Overview - NO63850237 - Sample Vehicle-5230</h4>
                <button type="button" class="modal-close" data-bs-dismiss="modal" aria-label="Close">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"/>
                        <line x1="6" y1="6" x2="18" y2="18"/>
                    </svg>
                </button>
            </div>
            <div class="modal-body">
                <div class="modern-tabs">
                    <div class="tab-navigation">
                        <button class="tab-btn active" data-tab="tab-overview">
                            <span class="tab-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                                    <polyline points="9,22 9,12 15,12 15,22"/>
                                </svg>
                            </span>
                            <span class="tab-text">Overview</span>
                        </button>
                        <button class="tab-btn" data-tab="tab-meter-history">
                            <span class="tab-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 3v18h18"/>
                                    <path d="M18.7 8l-5.1 5.2-2.8-2.7L7 14.3"/>
                                </svg>
                            </span>
                            <span class="tab-text">Meter History</span>
                        </button>
                        <button class="tab-btn" data-tab="tab-inspection">
                            <span class="tab-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M9 12l2 2 4-4"/>
                                    <path d="M21 12c-1 0-3-1-3-3s2-3 3-3 3 1 3 3-2 3-3 3"/>
                                    <path d="M3 12c1 0 3-1 3-3s-2-3-3-3-3 1-3 3 2 3 3 3"/>
                                    <path d="M13 12h3a2 2 0 0 1 2 2v1"/>
                                    <path d="M11 12H8a2 2 0 0 0-2 2v1"/>
                                </svg>
                            </span>
                            <span class="tab-text">Inspection</span>
                            <span class="tab-badge">0</span>
                        </button>
                        <button class="tab-btn" data-tab="tab-work-order">
                            <span class="tab-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                    <polyline points="14,2 14,8 20,8"/>
                                    <line x1="16" y1="13" x2="8" y2="13"/>
                                    <line x1="16" y1="17" x2="8" y2="17"/>
                                    <polyline points="10,9 9,9 8,9"/>
                                </svg>
                            </span>
                            <span class="tab-text">Work Order</span>
                            <span class="tab-badge">0</span>
                        </button>
                        <button class="tab-btn" data-tab="tab-type">
                            <span class="tab-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="12" cy="12" r="10"/>
                                    <path d="M8 12h8"/>
                                    <path d="M12 8v8"/>
                                </svg>
                            </span>
                            <span class="tab-text">Type</span>
                            <span class="tab-badge">0</span>
                        </button>
                        <button class="tab-btn" data-tab="tab-schedule">
                            <span class="tab-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                                    <line x1="16" y1="2" x2="16" y2="6"/>
                                    <line x1="8" y1="2" x2="8" y2="6"/>
                                    <line x1="3" y1="10" x2="21" y2="10"/>
                                </svg>
                            </span>
                            <span class="tab-text">Schedule</span>
                            <span class="tab-badge">0</span>
                        </button>
                        <button class="tab-btn" data-tab="tab-incident">
                            <span class="tab-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"/>
                                    <line x1="12" y1="9" x2="12" y2="13"/>
                                    <line x1="12" y1="17" x2="12.01" y2="17"/>
                                </svg>
                            </span>
                            <span class="tab-text">Incident</span>
                            <span class="tab-badge">0</span>
                        </button>
                        <button class="tab-btn" data-tab="tab-fuel-log">
                            <span class="tab-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 3v18h18"/>
                                    <path d="M18.7 8l-5.1 5.2-2.8-2.7L7 14.3"/>
                                </svg>
                            </span>
                            <span class="tab-text">Fuel Log</span>
                            <span class="tab-badge">0</span>
                        </button>
                        <button class="tab-btn" data-tab="tab-documents">
                            <span class="tab-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                    <polyline points="14,2 14,8 20,8"/>
                                </svg>
                            </span>
                            <span class="tab-text">Documents</span>
                            <span class="tab-badge">0</span>
                        </button>
                        <button class="tab-btn" data-tab="tab-checklist">
                            <span class="tab-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M9 12l2 2 4-4"/>
                                    <path d="M21 12c-1 0-3-1-3-3s2-3 3-3 3 1 3 3-2 3-3 3"/>
                                    <path d="M3 12c1 0 3-1 3-3s-2-3-3-3-3 1-3 3 2 3 3 3"/>
                                    <path d="M13 12h3a2 2 0 0 1 2 2v1"/>
                                    <path d="M11 12H8a2 2 0 0 0-2 2v1"/>
                                </svg>
                            </span>
                            <span class="tab-text">Checklist</span>
                            <span class="tab-badge">0</span>
                        </button>
                        <button class="tab-btn" data-tab="tab-daily-report">
                            <span class="tab-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                    <polyline points="14,2 14,8 20,8"/>
                                    <line x1="16" y1="13" x2="8" y2="13"/>
                                    <line x1="16" y1="17" x2="8" y2="17"/>
                                </svg>
                            </span>
                            <span class="tab-text">Daily Reporting</span>
                            <span class="tab-badge">0</span>
                        </button>
                    </div>
                    <div class="tab-content">
                        <div id="tab-overview" class="tab-pane active">
                            <div class="overview-section">
                                <div class="vehicle-details">
                                    <div class="details-grid">
                                        <div class="detail-group">
                                            <div class="detail-item">
                                                <span class="detail-label">Vehicle Number</span>
                                                <span class="detail-value">NO63850237</span>
                                            </div>
                                            <div class="detail-item">
                                                <span class="detail-label">Vehicle Name</span>
                                                <span class="detail-value">Sample Vehicle-5230</span>
                                            </div>
                                            <div class="detail-item">
                                                <span class="detail-label">Vehicle Category</span>
                                                <span class="detail-value">Sample Category</span>
                                            </div>
                                            <div class="detail-item">
                                                <span class="detail-label">VIN</span>
                                                <span class="detail-value">VIN587956</span>
                                            </div>
                                            <div class="detail-item">
                                                <span class="detail-label">Meter Reading</span>
                                                <span class="detail-value">14562 Miles</span>
                                            </div>
                                            <div class="detail-item">
                                                <span class="detail-label">Status</span>
                                                <span class="detail-value status-warning">Maintenance Required</span>
                                            </div>
                                            <div class="detail-item">
                                                <span class="detail-label">Priority</span>
                                                <span class="detail-value">Normal</span>
                                            </div>
                                        </div>
                                        <div class="detail-group">
                                            <div class="detail-item">
                                                <span class="detail-label">Model</span>
                                                <span class="detail-value">326F</span>
                                            </div>
                                            <div class="detail-item">
                                                <span class="detail-label">Operator Name</span>
                                                <span class="detail-value">John</span>
                                            </div>
                                            <div class="detail-item">
                                                <span class="detail-label">Purchase Date</span>
                                                <span class="detail-value">17-Feb-2025 11:23 AM</span>
                                            </div>
                                            <div class="detail-item">
                                                <span class="detail-label">Warranty Expiry</span>
                                                <span class="detail-value">26-May-2023 03:31 PM</span>
                                            </div>
                                            <div class="detail-item">
                                                <span class="detail-label">Ownership Mode</span>
                                                <span class="detail-value">Owned Vehicle</span>
                                            </div>
                                            <div class="detail-item">
                                                <span class="detail-label">Asset Value</span>
                                                <span class="detail-value">$150,000</span>
                                            </div>
                                            <div class="detail-item">
                                                <span class="detail-label">Priority</span>
                                                <span class="detail-value">Normal</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="stats-section">
                                    <div class="stats-grid">
                                        <div class="stat-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">Total Maintenance Cost</span>
                                                <span class="stat-value">$0</span>
                                            </div>
                                        </div>
                                        <div class="stat-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M3 3v18h18"/>
                                                    <path d="M18.7 8l-5.1 5.2-2.8-2.7L7 14.3"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">Total Fuel Cost</span>
                                                <span class="stat-value">$0</span>
                                            </div>
                                        </div>
                                        <div class="stat-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M3 3v18h18"/>
                                                    <path d="M18.7 8l-5.1 5.2-2.8-2.7L7 14.3"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">Total Fuel Consumption</span>
                                                <span class="stat-value">0 L</span>
                                            </div>
                                        </div>
                                        <div class="stat-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M3 3v18h18"/>
                                                    <path d="M18.7 8l-5.1 5.2-2.8-2.7L7 14.3"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">Total Running</span>
                                                <span class="stat-value">0 hrs</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="issue-report-section">
                                    <h3 class="section-title">Issue Report</h3>
                                    <div class="stats-grid">
                                        <div class="stat-card issue-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M8 5H6a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h5.697M18 14v4h4m-4-7V7a2 2 0 0 0-2-2h-2"/>
                                                    <path d="M8 5a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v0a2 2 0 0 1-2 2h-2a2 2 0 0 1-2-2m6 13a4 4 0 1 0 8 0a4 4 0 1 0-8 0m-6-7h4m-4 4h3"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">Total Issue Reported</span>
                                                <span class="stat-value">0</span>
                                            </div>
                                        </div>
                                        <div class="stat-card issue-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                                    <polyline points="14,2 14,8 20,8"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">Open Issue</span>
                                                <span class="stat-value">0</span>
                                            </div>
                                        </div>
                                        <div class="stat-card issue-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M9 12l2 2 4-4"/>
                                                    <path d="M21 12c-1 0-3-1-3-3s2-3 3-3 3 1 3 3-2 3-3 3"/>
                                                    <path d="M3 12c1 0 3-1 3-3s-2-3-3-3-3 1-3 3 2 3 3 3"/>
                                                    <path d="M13 12h3a2 2 0 0 1 2 2v1"/>
                                                    <path d="M11 12H8a2 2 0 0 0-2 2v1"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">Resolved</span>
                                                <span class="stat-value">0</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="workorder-summary-section">
                                    <h3 class="section-title">Workorder Summary</h3>
                                    <div class="workorder-grid">
                                        <div class="stat-card workorder-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                                    <polyline points="14,2 14,8 20,8"/>
                                                    <line x1="16" y1="13" x2="8" y2="13"/>
                                                    <line x1="16" y1="17" x2="8" y2="17"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">Total Work Order</span>
                                                <span class="stat-value">1</span>
                                            </div>
                                        </div>
                                        <div class="stat-card workorder-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M9 12l2 2 4-4"/>
                                                    <path d="M21 12c-1 0-3-1-3-3s2-3 3-3 3 1 3 3-2 3-3 3"/>
                                                    <path d="M3 12c1 0 3-1 3-3s-2-3-3-3-3 1-3 3 2 3 3 3"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">Completed</span>
                                                <span class="stat-value">0</span>
                                            </div>
                                        </div>
                                        <div class="stat-card workorder-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">Initiated</span>
                                                <span class="stat-value">1</span>
                                            </div>
                                        </div>
                                        <div class="stat-card workorder-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <circle cx="12" cy="12" r="10"/>
                                                    <path d="M8 12h8"/>
                                                    <path d="M12 8v8"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">In Progress</span>
                                                <span class="stat-value">0</span>
                                            </div>
                                        </div>
                                        <div class="stat-card workorder-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"/>
                                                    <line x1="12" y1="9" x2="12" y2="13"/>
                                                    <line x1="12" y1="17" x2="12.01" y2="17"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">On Hold</span>
                                                <span class="stat-value">0</span>
                                            </div>
                                        </div>
                                        <div class="stat-card workorder-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M3 3v18h18"/>
                                                    <path d="M18.7 8l-5.1 5.2-2.8-2.7L7 14.3"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">Rework</span>
                                                <span class="stat-value">0</span>
                                            </div>
                                        </div>
                                        <div class="stat-card workorder-card">
                                            <div class="stat-icon">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                                                    <line x1="16" y1="2" x2="16" y2="6"/>
                                                    <line x1="8" y1="2" x2="8" y2="6"/>
                                                    <line x1="3" y1="10" x2="21" y2="10"/>
                                                </svg>
                                            </div>
                                            <div class="stat-content">
                                                <span class="stat-label">Postponed</span>
                                                <span class="stat-value">0</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="defective-items-section">
                                    <h3 class="section-title">Top Defective Items</h3>
                                    <div class="empty-state">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"/>
                                            <line x1="12" y1="9" x2="12" y2="13"/>
                                            <line x1="12" y1="17" x2="12.01" y2="17"/>
                                        </svg>
                                        <p>No Data Available</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="tab-meter-history" class="tab-pane fade p-0">
                            <div class="row" style="padding: 20px 10px;width: 100%;margin: auto;box-shadow: 0 0 14px #0055a51a;border-radius: 0 0px 10px 10px;">
                                <span class="empty-data">No Data</span>
                            </div>
                            <div class="table-box table-responsive mt-4">
                                <table class="table px-1">
                                    <thead class="table-primary">
                                        <tr>
                                            <th style="border-top-left-radius: 10px;">Vehicle</th>
                                            <th>Odometer</th>
                                            <th>Status</th>
                                            <th>Type</th>
                                            <th>Source</th>
                                            <th style="border-top-right-radius: 10px;">Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- <tr>
                                                <td>John</td>
                                                <td>Doe</td>
                                                <td>john@example.com</td>
                                            </tr>-->
                                    </tbody>
                                </table>
                                <span class="empty-data">No Data</span>
                            </div>
                        </div>

                        <div id="tab-meter-history" class="tab-pane fade p-0">
                            <div class="row" style="padding: 20px 10px;width: 100%;margin: auto;box-shadow: 0 0 14px #0055a51a;border-radius: 0 0px 10px 10px;">
                                <span class="empty-data">No Data</span>
                            </div>
                            <div class="table-box table-responsive mt-4">
                                <table class="table px-1">
                                    <thead class="table-primary">
                                        <tr>
                                            <th style="border-top-left-radius: 10px;">Vehicle</th>
                                            <th>Odometer</th>
                                            <th>Status</th>
                                            <th>Type</th>
                                            <th>Source</th>
                                            <th style="border-top-right-radius: 10px;">Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- <tr>
                                                <td>John</td>
                                                <td>Doe</td>
                                                <td>john@example.com</td>
                                            </tr>-->
                                    </tbody>
                                </table>
                                <span class="empty-data">No Data</span>
                            </div>
                        </div>
                        <div id="tab-nspection" class="tab-pane fade p-0">
                            <div class="row" style="padding: 20px 10px;width: 100%;margin: auto;box-shadow: 0 0 14px #0055a51a;border-radius: 0">
                                <h1 class="tab-inner-head">INSPECTION HISTORY</h1>
                            </div>
                            <div class="table-box table-responsive mt-0">
                                <table class="table px-1">
                                    <thead class="table-primary">
                                        <tr>
                                            <th style="border-top-left-radius: 10px;">Action</th>
                                            <th>Report Number</th>
                                            <th>Date</th>
                                            <th>Vehicle</th>
                                            <th>Location</th>
                                            <th>Inspector</th>
                                            <th>Fault</th>
                                            <th>Corrective Action</th>
                                            <th style="border-top-right-radius: 10px;">Linked Wo</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- <tr>
                                                <td>John</td>
                                                <td>Doe</td>
                                                <td>john@example.com</td>
                                            </tr>-->
                                    </tbody>
                                </table>
                                <span class="empty-data">No Data</span>
                            </div>
                        </div>
                        <div id="tab-work-order" class="tab-pane fade p-0">
                            <div class="row" style="padding: 20px 10px;width: 100%;margin: auto;box-shadow: 0 0 14px #0055a51a;border-radius: 0">
                                <h1 class="tab-inner-head">MAINTENANCE WORKORDER HISTORY</h1>
                            </div>
                            <div class="table-box table-responsive mt-0">
                                <table class="table px-1">
                                    <thead class="table-primary">
                                        <tr>
                                            <th style="border-top-left-radius: 10px;">Action</th>
                                            <th>WO Number</th>
                                            <th>Created Date</th>
                                            <th>Vehicle</th>
                                            <th>Due Date <br>Completed Date</th>
                                            <th>Status</th>
                                            <th>Priority</th>
                                            <th>Assigned</th>
                                            <th style="border-top-right-radius: 10px;">Memo</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- <tr>
                                                <td>John</td>
                                                <td>Doe</td>
                                                <td>john@example.com</td>
                                            </tr>-->
                                    </tbody>
                                </table>
                                <span class="empty-data">No Data</span>
                            </div>
                        </div>
                        <div id="tab-type" class="tab-pane fade p-0">
                            <div class="row" style="padding:10px;width: 100%;margin: auto;box-shadow: 0 0 14px #0055a51a;border-radius: 0">

                            </div>
                            <div class="table-box table-responsive mt-0">
                                <table class="table px-1">
                                    <thead class="table-primary">
                                        <tr>
                                            <th style="border-top-left-radius: 10px;">Tire Number</th>
                                            <th>Manufacturer</th>
                                            <th>Tire Condition</th>
                                            <th>Status</th>
                                            <th>Miles/KM Run</th>
                                            <th>Tread Depth</th>
                                            <th style="border-top-right-radius: 10px;">Mount Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- <tr>
                                                <td>John</td>
                                                <td>Doe</td>
                                                <td>john@example.com</td>
                                            </tr>-->
                                    </tbody>
                                </table>
                                <span class="empty-data">No Data</span>
                            </div>
                        </div>
                        <div id="tab-schedule" class="tab-pane fade p-0">
                            <div class="row" style="padding: 20px 10px;width: 100%;margin: auto;box-shadow: 0 0 14px #0055a51a;border-radius: 0">
                                <h1 class="tab-inner-head">SCHEDULES</h1>
                            </div>
                            <div class="table-box table-responsive mt-0">
                                <table class="table px-1">
                                    <thead class="table-primary">
                                        <tr>
                                            <th style="border-top-left-radius: 10px;">Action</th>
                                            <th>Schedule</th>
                                            <th>Vehicle Number</th>
                                            <th>Due</th>
                                            <th style="border-top-right-radius: 10px;">Workorder</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- <tr>
                                                <td>John</td>
                                                <td>Doe</td>
                                                <td>john@example.com</td>
                                            </tr>-->
                                    </tbody>
                                </table>
                                <span class="empty-data">No Data</span>
                            </div>
                        </div>
                        <div id="tab-incident" class="tab-pane fade p-0">
                            <div class="row" style="padding: 20px 10px;width: 100%;margin: auto;box-shadow: 0 0 14px #0055a51a;border-radius: 0">
                                <h1 class="tab-inner-head">INCIDENT REPORT</h1>
                            </div>
                            <div class="table-box table-responsive mt-0">
                                <table class="table px-1">
                                    <thead class="table-primary">
                                        <tr>
                                            <th style="border-top-left-radius: 10px;">Action</th>
                                            <th>Workorder</th>
                                            <th>Incident Date</th>
                                            <th>Incident Time</th>
                                            <th>Vehicle</th>
                                            <th>Location</th>
                                            <th>Reported By</th>
                                            <th style="border-top-right-radius: 10px;">Download Report</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- <tr>
                                                <td>John</td>
                                                <td>Doe</td>
                                                <td>john@example.com</td>
                                            </tr>-->
                                    </tbody>
                                </table>
                                <span class="empty-data">No Data</span>
                            </div>
                        </div>
                        <div id="tab-fuel-log" class="tab-pane fade p-0">
                            <div class="row" style="padding: 20px 10px;width: 100%;margin: auto;box-shadow: 0 0 14px #0055a51a;border-radius: 0">
                                <h1 class="tab-inner-head">FUEL LOG</h1>
                            </div>
                            <div class="table-box table-responsive mt-0">
                                <table class="table px-1">
                                    <thead class="table-primary">
                                        <tr>
                                            <th style="border-top-left-radius: 10px;">Action</th>
                                            <th>Vehicle</th>
                                            <th>Meter Reading</th>
                                            <th>Filling Date</th>
                                            <th>Filling Source</th>

                                            <th>Fuel QTY</th>
                                            <th>Fuel Cost</th>
                                            <th style="border-top-right-radius: 10px;">Receipt</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- <tr>
                                                <td>John</td>
                                                <td>Doe</td>
                                                <td>john@example.com</td>
                                            </tr>-->
                                    </tbody>
                                </table>
                                <span class="empty-data">No Data</span>
                            </div>
                        </div>
                        <div id="tab-documents" class="tab-pane fade p-0">
                            <div class="row" style="padding-top:20px;width: 100%;margin: auto;box-shadow: 0 0 14px #0055a51a;border-radius: 0">
                                <div class="row bg-blue py-2">
                                    <h1>Documents</h1>
                                    <div class="btns parts w-auto">
                                        <button class="btn" data-bs-toggle="modal" data-bs-target="#upload-document">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                                <path fill="currentColor" d="M11 16V7.85l-2.6 2.6L7 9l5-5l5 5l-1.4 1.45l-2.6-2.6V16zm-5 4q-.825 0-1.412-.587T4 18v-3h2v3h12v-3h2v3q0 .825-.587 1.413T18 20z" />
                                            </svg>Upload Document
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="table-box table-responsive mt-0">
                                <table class="table px-1">
                                    <thead class="table-primary">
                                        <tr>
                                            <th style="border-top-left-radius: 10px;">Document Type</th>
                                            <th>Description</th>
                                            <th style="border-top-right-radius: 10px;">Download</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- <tr>
                                                <td>John</td>
                                                <td>Doe</td>
                                                <td>john@example.com</td>
                                            </tr>-->
                                    </tbody>
                                </table>
                                <span class="empty-data">No Data</span>
                            </div>
                        </div>
                        <div id="tab-checklist" class="tab-pane fade p-0">
                            <div class="row" style="padding-top:20px;width: 100%;margin: auto;box-shadow: 0 0 14px #0055a51a;border-radius: 0">
                                <div class="row bg-blue py-2">
                                    <h1>Assign Inspection Form</h1>
                                    <div class="btns parts w-auto">
                                        <button class="btn" data-bs-toggle="modal" data-bs-target="#select-checklist">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 16 16">
                                                <path fill="currentColor" fill-rule="evenodd" d="M2.5 2a.5.5 0 0 0-.5.5v11a.5.5 0 0 0 .5.5h11a.5.5 0 0 0 .5-.5v-11a.5.5 0 0 0-.5-.5zM4 6h6V5H4zm7 0h1V5h-1zm-1 2.5H4v-1h6zm1 0h1v-1h-1zM10 11H4v-1h6zm1 0h1v-1h-1z" clip-rule="evenodd" />
                                            </svg>Checklist
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="table-box table-responsive mt-0 pt-2">
                                <!-- <table class="table px-1">
                                        <thead class="table-primary">
                                            <tr>
                                                <th style="border-top-left-radius: 10px;">Action</th>
                                                <th>Vehicle</th>
                                                <th>Meter Reading</th>
                                                <th>Filling Date</th>
                                                <th>Filling Source</th>
                                                
                                                <th>Fuel QTY</th>
                                                <th>Fuel Cost</th>
                                                <th style="border-top-right-radius: 10px;">Receipt</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table> -->
                                <span class="empty-data">No Data</span>
                            </div>
                        </div>
                        <div id="tab-daily-report" class="tab-pane fade p-0">
                            <div class="row" style="padding: 20px 10px;width: 100%;margin: auto;box-shadow: 0 0 14px #0055a51a;border-radius: 0">
                                <h1 class="tab-inner-head">OPERATOR DAILY REPORTING</h1>
                            </div>
                            <div class="table-box table-responsive mt-0">
                                <table class="table px-1">
                                    <thead class="table-primary">
                                        <tr>
                                            <th style="border-top-left-radius: 10px;">Action</th>

                                            <th>Report Number</th>
                                            <th>Start Date</th>
                                            <th>Vehicle</th>
                                            <th>Mon</th>

                                            <th>Tue</th>
                                            <th>Wed</th>
                                            <th>Thu</th>

                                            <th>Fri</th>
                                            <th>Sat</th>
                                            <th style="border-top-right-radius: 10px;">Submitted Report</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- <tr>
                                                <td>John</td>
                                                <td>Doe</td>
                                                <td>john@example.com</td>
                                            </tr>-->
                                    </tbody>
                                </table>
                                <span class="empty-data">No Data</span>
                            </div>
                        </div>
                    </div>
                    <!-- <div class="tab-bottom-text">
                            <p>Let our team help you convert your paper form to digital.</p>
                        </div> -->
                </div>
            <div class="modal-footer">
                <button type="button" class="btn-cancel" data-bs-dismiss="modal">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"/>
                        <line x1="6" y1="6" x2="18" y2="18"/>
                    </svg>
                    Close
                </button>
            </div>
            </div>
        </div>
    </div>
</div>
<!-- Upload Vehicle Document popup -->
<div class="modal search-popup" id="upload-document">
    <div class="modal-dialog" style="">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Upload Vehicle Document</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form class="form-inline" action="">
                    <div class="input-group">
                        <label for="">Document Type * :</label>
                        <select class="form-select" id="" name="">
                            <option>Invoice</option>
                            <option>Insurance</option>
                            <option>Registration</option>
                            <option>Manual</option>
                            <option>Warranty</option>

                            <option>Purchase Order</option>

                            <option>Quotation</option>
                            <option>Miscellaneous</option>


                        </select>
                    </div>
                    <div class="input-group">
                        <label for="">Document Description :</label>
                        <input type="text" class="form-control" placeholder="" id="">
                    </div>
                    <div class="input-group">
                        <label for="text">Select File * :</label>
                        <input class="form-control" type="file" id="" placeholder="Choose a file for uploading...">
                    </div>
                    <div class="row my-3 align-items-center justify-content-center">
                        <button type="button" class="save btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 5v9m-5 0H5a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-2M8 9l4-5l4 5m1 8h.01" />
                            </svg>Upload</button>
                        <!-- Modal footer -->
                        <div class="modal-footer col-md-4 p-0 w-auto">
                            <button type="button" class="save btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 24 24">
                                    <path fill="currentColor" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                                </svg>Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Select Inspection Checklist popup -->
<div class="modal search-popup" id="select-checklist">
    <div class="modal-dialog" style="">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Select Inspection Checklist</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form class="form-inline" action="">
                    <div class="input-group searchwicon">
                        <div class="input-group-text br-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                <path fill="currentColor" d="M15.5 14h-.79l-.28-.27A6.47 6.47 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14" />
                            </svg>
                        </div>
                        <input type="text" class="form-control" placeholder="Search">
                    </div>
                    <span class="empty-data">No Data</span>
                    <div class="row my-3 align-items-center justify-content-center">
                        <button type="button" class="save btn btn-danger" data-bs-dismiss="modal">Select</button>
                        <!-- Modal footer -->
                        <div class="modal-footer col-md-4 p-0 w-auto">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                    <path fill="currentColor" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                                </svg>Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Sorting Popup modals -->
<div class="modal" id="sorting">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Sorting</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form action="">
                    <form action="">
                        <h1>Sort Order</h1>
                        <div class="form-check">
                            <input type="radio" class="form-check-input" id="radio1" name="optradio" value="Ascending" checked>
                            <label class="form-check-label" for="radio1">Ascending</label>
                        </div>
                        <div class="form-check">
                            <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Descending">
                            <label class="form-check-label" for="radio2">Descending</label>
                        </div>
                    </form>
                    <h1>Sort By</h1>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio1" name="optradio" value="Report Number" checked>
                        <label class="form-check-label" for="radio1">Vehicle Number</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Vehicle Number">
                        <label class="form-check-label" for="radio2">Category</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Start Date">
                        <label class="form-check-label" for="radio2">Vehicle Name</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Vehicle Name">
                        <label class="form-check-label" for="radio2">Status</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Vehicle Name">
                        <label class="form-check-label" for="radio2">Meter</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Vehicle Name">
                        <label class="form-check-label" for="radio2">Model</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Vehicle Name">
                        <label class="form-check-label" for="radio2">Operator</label>
                    </div>
                    <div class="row my-3 align-items-center justify-content-center">
                        <button type="submit" class="save btn btn-danger col-md-4 mx-2">Ok</button>
                        <button type="reset" class="save btn btn-danger col-md-4 mx-2">Reset</button>
                        <!-- Modal footer -->
                        <div class="modal-footer col-md-4 p-0">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    var dropdown = document.getElementsByClassName("dropdown-btn");
    var i;

    for (i = 0; i < dropdown.length; i++) {
        dropdown[i].addEventListener("click", function() {
            this.classList.toggle("active");
            var dropdownContent = this.nextElementSibling;
            if (dropdownContent.style.display === "block") {
                dropdownContent.style.display = "none";
            } else {
                dropdownContent.style.display = "block";
            }
        });
    }
</script>
@endsection

<style>
/* Import Google Fonts for better typography */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* ===== MAIN CONTAINER ===== */
.vehicles-overview-container {
    min-height: 100vh;
}

/* ===== HEADER STYLES ===== */
.vehicles-overview-header {
    background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
    padding: 2rem 0;
    margin-bottom: 0;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    display: none;
}

.header-content {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 2rem;
}

.page-title h1 {
    font-size: 2.5rem;
    font-weight: 700;
    color: #ffffff;
    margin: 0 0 0.5rem 0;
    letter-spacing: -0.025em;
}

.page-title p {
    font-size: 1.125rem;
    color: #cbd5e1;
    margin: 0;
    font-weight: 400;
}

/* ===== MAIN CONTENT ===== */
.vehicles-overview-content {

}

.content-box {
    background: white;
    padding: 32px 32px 32px 40px;
    border-radius: 0;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    border: 1px solid #e2e8f0;
    margin-bottom: 2rem;
}

/* ===== ACTION BAR ===== */
.action-bar {
    background: transparent;
    border: none;
    border-radius: 0;
    padding: 0;
    margin-bottom: 32px;
    box-shadow: none;
}

.action-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 1rem;
    flex-wrap: wrap;
}

.page-title h1, .page-title h2 {
    color: #0f172a;
    font-weight: 700;
    font-size: 32px;
    line-height: 1.2;
    letter-spacing: -0.025em;
    margin: 0;
}

.page-title h2 {
    font-size: 24px;
}

/* ===== SEARCH SECTION ===== */
.search-section {
    margin-top: 2rem;
}

.search-form {
    background: #f8fafc;
    padding: 2rem;
    border-radius: 0;
    border: 1px solid #e2e8f0;
}

.form-grid {
    display: grid;
    grid-template-columns: 2fr 1fr 1fr auto;
    gap: 1.5rem;
    align-items: end;
}

.form-group {
    display: flex;
    flex-direction: column;
}

.form-label {
    font-weight: 600;
    color: #374151;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
}

.form-control {
    border: 2px solid #e2e8f0;
    border-radius: 0;
    padding: 0.75rem 1rem;
    font-size: 0.875rem;
    font-weight: 500;
    color: #1e293b;
    background: #ffffff;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
}

.form-control:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.form-control::placeholder {
    color: #94a3b8;
    font-weight: 400;
}

.input-with-icon {
    position: relative;
}

.input-icon {
    position: absolute;
    right: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #64748b;
    pointer-events: none;
}

/* ===== BUTTON STYLES ===== */
.btn-view {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: #0055a5;
    color: #ffffff;
    border: none;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    /* font-family: 'Inter', sans-serif; */
    cursor: pointer;
    transition: all 0.2s ease;
    /* box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2); */
    white-space: nowrap;
}

.btn-view:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-1px);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    color: black !important;
}

/* ===== MODAL STYLES ===== */
.modal {
    font-family: 'Inter', sans-serif;
}

.modal.show {
    display: block;
}

.modal.fade .modal-dialog {
    transition: transform 0.3s ease-out;
    transform: translate(0, -50px);
}

.modal.show .modal-dialog {
    transform: none;
}

.modal-dialog {
    max-width: 100%;
    margin: 0;
}

.modal-dialog.modal-fullscreen {
    max-width: 100%;
    height: 100%;
    margin: 0;
}

.modal-content {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
    height: 100vh;
    display: flex;
    flex-direction: column;
}

.modal-header {
    background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
    color: #ffffff;
    border-bottom: 1px solid #e2e8f0;
    padding: 1.5rem 2rem;
    border-radius: 0;
    flex-shrink: 0;
}

.modal-title {
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0;
    color: #ffffff;
}

.modal-close {
    background: none;
    border: none;
    color: #ffffff;
    font-size: 1.5rem;
    cursor: pointer;
    padding: 0;
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 0;
    transition: background-color 0.2s;
}

.modal-close:hover {
    background-color: rgba(255, 255, 255, 0.1);
}

.modal-body {
    padding: 0;
    flex: 1;
    overflow-y: auto;
}

.modal-footer {
    background: #f8fafc;
    border-top: 1px solid #e2e8f0;
    padding: 1.5rem 2rem;
    display: flex;
    justify-content: flex-end;
    gap: 1rem;
    border-radius: 0;
    flex-shrink: 0;
}

/* ===== MODERN TABS ===== */
.modern-tabs {
    height: 100%;
    display: flex;
    flex-direction: column;
}

.tab-navigation {
    background: #f8fafc;
    border-bottom: 1px solid #e2e8f0;
    padding: 0 2rem;
    display: flex;
    gap: 0.5rem;
    overflow-x: auto;
    flex-shrink: 0;
}

.tab-btn {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 1rem 1.5rem;
    background: transparent;
    border: none;
    border-radius: 0;
    color: #64748b;
    font-size: 0.875rem;
    font-weight: 500;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
    white-space: nowrap;
    position: relative;
}

.tab-btn:hover {
    background: #e2e8f0;
    color: #374151;
}

.tab-btn.active {
    background: #ffffff;
    color: #1e293b;
    border-bottom: 2px solid #3b82f6;
}

.tab-icon {
    display: flex;
    align-items: center;
    justify-content: center;
}

.tab-text {
    font-weight: 500;
}

.tab-badge {
    background: #ef4444;
    color: #ffffff;
    font-size: 0.75rem;
    font-weight: 600;
    padding: 0.25rem 0.5rem;
    border-radius: 0;
    min-width: 20px;
    text-align: center;
}

.tab-content {
    flex: 1;
    padding: 2rem;
    overflow-y: auto;
}

.tab-pane {
    display: none;
}

.tab-pane.active {
    display: block;
}

/* ===== OVERVIEW SECTION ===== */
.overview-section {
    display: flex;
    flex-direction: column;
    gap: 2rem;
}

.vehicle-details {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    padding: 2rem;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
}

.details-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 2rem;
}

.detail-group {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.detail-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.75rem 0;
    border-bottom: 1px solid #f1f5f9;
}

.detail-item:last-child {
    border-bottom: none;
}

.detail-label {
    font-weight: 600;
    color: #64748b;
    font-size: 0.875rem;
}

.detail-value {
    font-weight: 500;
    color: #1e293b;
    font-size: 0.875rem;
}

.detail-value.status-warning {
    background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
    color: #ffffff;
    padding: 0.25rem 0.75rem;
    border-radius: 0;
    font-size: 0.75rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

/* ===== STATS SECTIONS ===== */
.stats-section, .issue-report-section, .workorder-summary-section, .defective-items-section {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    padding: 2rem;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
}

.section-title {
    font-size: 1.25rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0 0 1.5rem 0;
    padding-bottom: 0.75rem;
    border-bottom: 2px solid #e2e8f0;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1.5rem;
}

.workorder-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 1.5rem;
}

.stat-card {
    background: #f8fafc;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    padding: 1.5rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    transition: all 0.2s ease;
}

.stat-card:hover {
    background: #f1f5f9;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

.stat-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 48px;
    height: 48px;
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    color: #ffffff;
    border-radius: 0;
    flex-shrink: 0;
}

.stat-content {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.stat-label {
    font-size: 0.75rem;
    font-weight: 600;
    color: #64748b;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: 700;
    color: #1e293b;
}

.issue-card .stat-icon {
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
}

.workorder-card .stat-icon {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
}

/* ===== EMPTY STATE ===== */
.empty-state {
    padding: 3rem 2rem;
    text-align: center;
    background: #f8fafc;
    border: 2px dashed #cbd5e1;
    border-radius: 0;
    min-height: 120px;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    gap: 1rem;
}

.empty-state svg {
    color: #cbd5e1;
}

.empty-state p {
    color: #64748b;
    font-size: 0.875rem;
    margin: 0;
    font-weight: 500;
}

/* ===== BUTTON STYLES ===== */
.btn-cancel {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: #ffffff;
    color: #64748b;
    border: 2px solid #e2e8f0;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-cancel:hover {
    background: #f8fafc;
    border-color: #cbd5e1;
    color: #475569;
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 1200px) {
    .vehicles-overview-container {
        padding: 0;
    }
    
    .content-box {
        padding: 24px 24px 24px 32px;
    }
    
    .form-grid {
        grid-template-columns: 2fr 1fr 1fr auto;
        gap: 1.25rem;
    }
    
    .details-grid {
        grid-template-columns: 1fr 1fr;
        gap: 1.5rem;
    }
    
    .stats-grid {
        grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    }
    
    .workorder-grid {
        grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
    }
}

@media (max-width: 992px) {
    .vehicles-overview-content {
        padding: 20px 0 0 12px;
    }
    
    .content-box {
        padding: 20px 20px 20px 28px;
        margin-left: 0.25rem;
    }
    
    .page-title h1, .page-title h2 {
        font-size: 28px;
    }
    
    .form-grid {
        grid-template-columns: 1fr 1fr;
        gap: 1rem;
    }
    
    .btn-view {
        padding: 0.75rem 1.25rem;
        font-size: 0.8rem;
    }
    
    .details-grid {
        grid-template-columns: 1fr;
        gap: 1.25rem;
    }
    
    .stats-grid, .workorder-grid {
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 1.25rem;
    }
    
    .tab-navigation {
        padding: 0 1.5rem;
        flex-wrap: wrap;
        gap: 0.25rem;
    }
    
    .tab-btn {
        padding: 0.875rem 1.25rem;
        font-size: 0.8rem;
    }
    
    .tab-content {
        padding: 1.5rem;
    }
    
    .modal-header, .modal-footer {
        padding: 1.25rem 1.5rem;
    }
    
    .vehicle-details, .stats-section, .issue-report-section, .workorder-summary-section, .defective-items-section {
        padding: 1.75rem;
    }
}

@media (max-width: 768px) {
    .header-content {
        padding: 0 1rem;
    }
    
    .vehicles-overview-content {
        padding: 1rem 1rem 1rem 2rem;
    }
    
    .content-box {
        padding: 1.5rem 1.5rem 1.5rem 2rem;
        margin-left: 0.25rem;
    }
    
    .page-title h1 {
        font-size: 2rem;
    }
    
    .page-title h2 {
        font-size: 1.5rem;
    }
    
    .form-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .btn-view {
        width: 100%;
        justify-content: center;
    }
    
    .details-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .stats-grid, .workorder-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .tab-navigation {
        padding: 0 1rem;
        flex-wrap: wrap;
        gap: 0.25rem;
    }
    
    .tab-btn {
        padding: 0.75rem 1rem;
        font-size: 0.8rem;
        flex: 1;
        min-width: 120px;
    }
    
    .tab-content {
        padding: 1rem;
    }
    
    .modal-header, .modal-footer {
        padding: 1rem 1.5rem;
    }
    
    .vehicle-details, .stats-section, .issue-report-section, .workorder-summary-section, .defective-items-section {
        padding: 1.5rem;
    }
    
    .stat-card {
        padding: 1.25rem;
    }
    
    .stat-icon {
        width: 44px;
        height: 44px;
    }
    
    .stat-value {
        font-size: 1.375rem;
    }
}

@media (max-width: 576px) {
    .vehicles-overview-content {
        padding: 0.75rem 0.75rem 0.75rem 1.5rem;
    }
    
    .content-box {
        padding: 1.25rem 1.25rem 1.25rem 1.75rem;
        margin-left: 0.125rem;
    }
    
    .page-title h1 {
        font-size: 1.75rem;
    }
    
    .page-title h2 {
        font-size: 1.25rem;
    }
    
    .search-form {
        padding: 1.5rem;
    }
    
    .form-grid {
        gap: 0.875rem;
    }
    
    .form-control {
        padding: 0.625rem 0.875rem;
        font-size: 0.8rem;
    }
    
    .btn-view {
        padding: 0.625rem 1rem;
        font-size: 0.8rem;
    }
    
    .tab-navigation {
        padding: 0 0.75rem;
        gap: 0.125rem;
    }
    
    .tab-btn {
        padding: 0.625rem 0.75rem;
        font-size: 0.75rem;
        min-width: 100px;
    }
    
    .tab-content {
        padding: 0.875rem;
    }
    
    .modal-header, .modal-footer {
        padding: 0.875rem 1.25rem;
    }
    
    .vehicle-details, .stats-section, .issue-report-section, .workorder-summary-section, .defective-items-section {
        padding: 1.25rem;
    }
    
    .stat-card {
        padding: 1rem;
    }
    
    .stat-icon {
        width: 40px;
        height: 40px;
    }
    
    .stat-value {
        font-size: 1.25rem;
    }
    
    .detail-item {
        padding: 0.625rem 0;
    }
    
    .detail-label, .detail-value {
        font-size: 0.8rem;
    }
}

@media (max-width: 480px) {
    .vehicles-overview-content {
        padding: 0.5rem 0.5rem 0.5rem 1.25rem;
    }
    
    .content-box {
        padding: 1rem 1rem 1rem 1.5rem;
        margin-left: 0;
    }
    
    .page-title h1 {
        font-size: 1.5rem;
    }
    
    .page-title h2 {
        font-size: 1.125rem;
    }
    
    .search-form {
        padding: 1.25rem;
    }
    
    .form-grid {
        gap: 0.75rem;
    }
    
    .form-control {
        padding: 0.5rem 0.75rem;
        font-size: 0.75rem;
    }
    
    .btn-view {
        padding: 0.5rem 0.875rem;
        font-size: 0.75rem;
    }
    
    .tab-navigation {
        padding: 0 0.5rem;
        gap: 0.125rem;
    }
    
    .tab-btn {
        padding: 0.5rem 0.625rem;
        font-size: 0.7rem;
        min-width: 90px;
    }
    
    .tab-content {
        padding: 0.75rem;
    }
    
    .modal-header, .modal-footer {
        padding: 0.75rem 1rem;
    }
    
    .vehicle-details, .stats-section, .issue-report-section, .workorder-summary-section, .defective-items-section {
        padding: 1rem;
    }
    
    .stat-card {
        padding: 0.875rem;
    }
    
    .stat-icon {
        width: 36px;
        height: 36px;
    }
    
    .stat-value {
        font-size: 1.125rem;
    }
    
    .detail-item {
        padding: 0.5rem 0;
    }
    
    .detail-label, .detail-value {
        font-size: 0.75rem;
    }
    
    .section-title {
        font-size: 1.125rem;
    }
}

/* ===== LANDSCAPE ORIENTATION ===== */
@media (max-width: 768px) and (orientation: landscape) {
    .vehicles-overview-content {
        padding: 0.5rem 0.5rem 0.5rem 1.5rem;
    }
    
    .content-box {
        padding: 1rem 1rem 1rem 1.5rem;
    }
    
    .tab-navigation {
        padding: 0 0.75rem;
    }
    
    .tab-btn {
        padding: 0.5rem 0.75rem;
        font-size: 0.75rem;
    }
    
    .tab-content {
        padding: 0.75rem;
    }
}

/* ===== TOUCH DEVICES ===== */
@media (hover: none) and (pointer: coarse) {
    .btn-view, .tab-btn, .btn-cancel {
        min-height: 44px;
        min-width: 44px;
    }
    
    .form-control {
        min-height: 44px;
    }
    
    .tab-btn {
        padding: 0.875rem 1rem;
    }
}

/* ===== HIGH DPI DISPLAYS ===== */
@media (-webkit-min-device-pixel-ratio: 2), (min-resolution: 192dpi) {
    .stat-icon svg,
    .tab-icon svg,
    .input-icon svg {
        transform: scale(0.9);
    }
}

/* ===== ACCESSIBILITY ===== */
@media (prefers-reduced-motion: reduce) {
    * {
        animation-duration: 0.01ms !important;
        animation-iteration-count: 1 !important;
        transition-duration: 0.01ms !important;
    }
}

/* ===== FOCUS STYLES ===== */
button:focus-visible,
input:focus-visible,
select:focus-visible {
    outline: 2px solid #3b82f6;
    outline-offset: 2px;
}

/* ===== PRINT STYLES ===== */
@media print {
    .action-bar,
    .modal {
        display: none !important;
    }
    
    .vehicles-overview-container {
        background: white;
    }
    
    .vehicles-overview-header {
        background: white;
        color: black;
    }
}
</style>

<script>
// Modern Tab Functionality
document.addEventListener('DOMContentLoaded', function() {
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabPanes = document.querySelectorAll('.tab-pane');
    
    tabButtons.forEach(button => {
        button.addEventListener('click', function() {
            const targetTab = this.getAttribute('data-tab');
            
            // Remove active class from all buttons and panes
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabPanes.forEach(pane => pane.classList.remove('active'));
            
            // Add active class to clicked button and corresponding pane
            this.classList.add('active');
            const targetPane = document.getElementById(targetTab);
            if (targetPane) {
                targetPane.classList.add('active');
            }
        });
    });
    
    // Search functionality
    const searchInput = document.getElementById('vnum');
    if (searchInput) {
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                // Trigger search or view details
                const viewButton = document.querySelector('[data-bs-target="#view-detail"]');
                if (viewButton) {
                    viewButton.click();
                }
            }
        });
    }
});
</script>