@extends('welcome')

@section('title', 'Account')

@section('content')
<div class="account-container">
    <header class="account-header" role="banner">
        <div class="header-content">
            <div class="page-title">
                <h1>Account Management</h1>
                <p>Manage your account settings, business profile, and preferences</p>
            </div>
        </div>
    </header>
    
    <main class="account-content" role="main">
        <div class="content-box">
            <div class="action-bar">
                <div class="action-content">
                    <div class="page-title">
                        <h1>User Name</h1>
                    </div>
                </div>
            </div>
            
            <nav class="modern-tabs" role="navigation" aria-label="Account settings navigation">
                <div class="tab-navigation" role="tablist">
                    <button class="tab-btn active" data-tab="setting" role="tab" aria-selected="true" aria-controls="setting" id="tab-setting">
                        <svg class="tab-icon" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                            <circle cx="12" cy="12" r="3"/>
                            <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1 1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"/>
                        </svg>
                        <span class="tab-text">Settings</span>
                    </button>
                    <button class="tab-btn" data-tab="business-profile" role="tab" aria-selected="false" aria-controls="business-profile" id="tab-business-profile">
                        <svg class="tab-icon" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                            <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/>
                            <circle cx="9" cy="7" r="4"/>
                            <path d="M22 21v-2a4 4 0 0 0-3-3.87"/>
                            <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                        </svg>
                        <span class="tab-text">Business Profile</span>
                    </button>
                    <button class="tab-btn" data-tab="notification" role="tab" aria-selected="false" aria-controls="notification" id="tab-notification">
                        <svg class="tab-icon" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                            <path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9"/>
                            <path d="M13.73 21a2 2 0 0 1-3.46 0"/>
                        </svg>
                        <span class="tab-text">Notification</span>
                    </button>
                    <button class="tab-btn" data-tab="custom-field" role="tab" aria-selected="false" aria-controls="custom-field" id="tab-custom-field">
                        <svg class="tab-icon" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                            <rect x="3" y="3" width="18" height="18" rx="2" ry="2"/>
                            <line x1="9" y1="9" x2="15" y2="15"/>
                            <line x1="15" y1="9" x2="9" y2="15"/>
                        </svg>
                        <span class="tab-text">Custom Field</span>
                    </button>
                    <button class="tab-btn" data-tab="help-support" role="tab" aria-selected="false" aria-controls="help-support" id="tab-help-support">
                        <svg class="tab-icon" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                            <circle cx="12" cy="12" r="10"/>
                            <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"/>
                            <line x1="12" y1="17" x2="12.01" y2="17"/>
                        </svg>
                        <span class="tab-text">Help & Support</span>
                    </button>
                </div>
                <div class="tab-content">
                    <div id="setting" class="tab-pane active" role="tabpanel" aria-labelledby="tab-setting">
                        <div class="settings-grid">
                            <div class="settings-card">
                                <div class="settings-header">
                                    <h3>Inspection Settings</h3>
                                    <button class="btn-edit" data-bs-toggle="modal" data-bs-target="#inspection-edit">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M7 7H6a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2v-1"/>
                                            <path d="M20.385 6.585a2.1 2.1 0 0 0-2.97-2.97L9 12v3h3zM16 5l3 3"/>
                                        </svg>
                                        Edit
                                    </button>
                                </div>
                                <div class="settings-table">
                                    <div class="setting-row">
                                        <span class="setting-label">Report Header</span>
                                        <span class="setting-value">Heavy Vehicle Inspection Report</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Left Footer</span>
                                        <span class="setting-value">HVI App</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Right Footer (Address)</span>
                                        <span class="setting-value">www.heavyvehicleinspection.com</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Report Prefix</span>
                                        <span class="setting-value">HVI</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Report Start Number</span>
                                        <span class="setting-value">1000</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Inspection Note Required</span>
                                        <span class="setting-value status-off">OFF</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Inspection Image Required</span>
                                        <span class="setting-value status-off">OFF</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Time Zone</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                </div>
                            </div>
                            <div class="settings-card">
                                <div class="settings-header">
                                    <h3>Workorder Settings</h3>
                                    <button class="btn-edit" data-bs-toggle="modal" data-bs-target="#workorder-edit">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M7 7H6a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2v-1"/>
                                            <path d="M20.385 6.585a2.1 2.1 0 0 0-2.97-2.97L9 12v3h3zM16 5l3 3"/>
                                        </svg>
                                        Edit
                                    </button>
                                </div>
                                <div class="settings-table">
                                    <div class="setting-row">
                                        <span class="setting-label">WorkOrder Prefix</span>
                                        <span class="setting-value">WO</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">WorkOrder Start Number</span>
                                        <span class="setting-value">1000</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Currency</span>
                                        <span class="setting-value">USD</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Tax(%)</span>
                                        <span class="setting-value">0</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Tax on parts cost</span>
                                        <span class="setting-value status-off">OFF</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Tax on labor cost</span>
                                        <span class="setting-value status-off">OFF</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Tax on additional cost</span>
                                        <span class="setting-value status-off">OFF</span>
                                    </div>
                                </div>
                            </div>
                            <div class="settings-card">
                                <div class="settings-header">
                                    <h3>Fuel Settings</h3>
                                    <button class="btn-edit" data-bs-toggle="modal" data-bs-target="#fuel-edit">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M7 7H6a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2v-1"/>
                                            <path d="M20.385 6.585a2.1 2.1 0 0 0-2.97-2.97L9 12v3h3zM16 5l3 3"/>
                                        </svg>
                                        Edit
                                    </button>
                                </div>
                                <div class="settings-table">
                                    <div class="setting-row">
                                        <span class="setting-label">Fuel Bunker Low Alert(%)</span>
                                        <span class="setting-value">30</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Stop fuel issuing at limit(%)</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                </div>
                            </div>
                            <div class="settings-card">
                                <div class="settings-header">
                                    <h3>Schedule Settings</h3>
                                    <button class="btn-edit" data-bs-toggle="modal" data-bs-target="#schedule-edit">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M7 7H6a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2v-1"/>
                                            <path d="M20.385 6.585a2.1 2.1 0 0 0-2.97-2.97L9 12v3h3zM16 5l3 3"/>
                                        </svg>
                                        Edit
                                    </button>
                                </div>
                                <div class="settings-table">
                                    <div class="setting-row">
                                        <span class="setting-label">Schedule ID Prefix</span>
                                        <span class="setting-value">SCH</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Schedule ID Start Number</span>
                                        <span class="setting-value">1000</span>
                                    </div>
                                </div>
                            </div>
                            <div class="settings-card">
                                <div class="settings-header">
                                    <h3>Purchase Order Settings</h3>
                                    <button class="btn-edit" data-bs-toggle="modal" data-bs-target="#purchase-edit">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M7 7H6a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2v-1"/>
                                            <path d="M20.385 6.585a2.1 2.1 0 0 0-2.97-2.97L9 12v3h3zM16 5l3 3"/>
                                        </svg>
                                        Edit
                                    </button>
                                </div>
                                <div class="settings-table">
                                    <div class="setting-row">
                                        <span class="setting-label">Pre approved limit</span>
                                        <span class="setting-value">0</span>
                                    </div>
                                </div>
                            </div>
                            <div class="settings-card logo-card">
                                <div class="settings-header">
                                    <h3>Company Logo</h3>
                                </div>
                                <div class="logo-section">
                                    <div class="logo-preview">
                                        <img src="HVI-logo.png" alt="Company Logo" class="company-logo">
                                    </div>
                                    <button type="button" class="btn-upload-logo" data-bs-toggle="modal" data-bs-target="#select-image">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M12 5v9m-5 0H5a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-2M8 9l4-5l4 5m1 8h.01"/>
                                        </svg>
                                        Set your company Logo
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                                <div id="business-profile" class="tab-pane" role="tabpanel" aria-labelledby="tab-business-profile">
                        <div class="profile-section">
                            <div class="settings-card">
                                <div class="settings-header">
                                    <h3>User Profile</h3>
                                    <button class="btn-edit" data-bs-toggle="modal" data-bs-target="#profile-edit">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M7 7H6a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2v-1"/>
                                            <path d="M20.385 6.585a2.1 2.1 0 0 0-2.97-2.97L9 12v3h3zM16 5l3 3"/>
                                        </svg>
                                        Edit
                                    </button>
                                </div>
                                <div class="settings-table">
                                    <div class="setting-row">
                                        <span class="setting-label">Location</span>
                                        <span class="setting-value">India</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Company Name</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Company Address</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Contact Number</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Country</span>
                                        <span class="setting-value">India</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Admin Name</span>
                                        <span class="setting-value">Dummy Text</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                                <div id="notification" class="tab-pane" role="tabpanel" aria-labelledby="tab-notification">
                        <div class="notification-section">
                            <div class="settings-card">
                                <div class="settings-header">
                                    <h3>Notification Settings</h3>
                                    <button class="btn-edit" data-bs-toggle="modal" data-bs-target="#add-notification">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M18 12.998h-5v5a1 1 0 0 1-2 0v-5H6a1 1 0 0 1 0-2h5v-5a1 1 0 0 1 2 0v5h5a1 1 0 0 1 0 2"/>
                                        </svg>
                                        Add
                                    </button>
                                </div>
                                <div class="settings-table">
                                    <div class="setting-row">
                                        <span class="setting-label">Team</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Email</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Inspection</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Workorder</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Incident</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Fuel Bunker Alert</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Management Report</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Schedule Report</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">Parts Report</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">PO Demand Report</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                    <div class="setting-row">
                                        <span class="setting-label">PO Approval</span>
                                        <span class="setting-value">-</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                                <div id="custom-field" class="tab-pane" role="tabpanel" aria-labelledby="tab-custom-field">
                        <div class="custom-fields-section">
                            <div class="section-header">
                                <h2>Custom Business Fields</h2>
                            </div>
                            <div class="custom-fields-grid">
                                <div class="custom-field-card">
                                    <div class="field-header">
                                        <h3>General Inspection</h3>
                                    </div>
                                    <form class="custom-field-form" action="">
                                        <div class="field-group">
                                            <label for="field1">Field 1:</label>
                                            <div class="field-input-group">
                                                <input type="text" class="form-control" id="field1" placeholder="" value="">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="field1Switch">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="field-group">
                                            <label for="field2">Field 2:</label>
                                            <div class="field-input-group">
                                                <input type="text" class="form-control" id="field2" placeholder="" value="">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="field2Switch">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="field-group">
                                            <label for="field3">Field 3:</label>
                                            <div class="field-input-group">
                                                <input type="text" class="form-control" id="field3" placeholder="" value="">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="field3Switch">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="field-group">
                                            <label for="field4">Field 4:</label>
                                            <div class="field-input-group">
                                                <input type="text" class="form-control" id="field4" placeholder="" value="">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="field4Switch">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="field-group">
                                            <label for="field5">Field 5:</label>
                                            <div class="field-input-group">
                                                <input type="text" class="form-control" id="field5" placeholder="" value="">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="field5Switch">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="field-group">
                                            <label for="signature1">Signature 1:</label>
                                            <div class="field-input-group">
                                                <input type="text" class="form-control" id="signature1" placeholder="" value="">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="signature1Switch">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="field-group">
                                            <label for="signature2">Signature 2:</label>
                                            <div class="field-input-group">
                                                <input type="text" class="form-control" id="signature2" placeholder="" value="">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="signature2Switch">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="field-group">
                                            <label for="defaultSignature">Default Signature Name:</label>
                                            <div class="field-input-group">
                                                <input type="text" class="form-control" id="defaultSignature" placeholder="" value="">
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="defaultSignatureSwitch">
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="container active p-0 custom-w" style="box-shadow: 0px 0px 14px 0px #0055A51A;border-radius: 10px;">
                                    <div class="row bg-blue py-2">
                                        <h1>Operator Daily Reporting</h1>
                                        <!-- <div class="btns parts">
                                            <button class="btn" data-bs-toggle="modal" data-bs-target="#add-notification">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="34" height="34" viewBox="0 0 24 24">
                                                    <path fill="currentColor" d="M18 12.998h-5v5a1 1 0 0 1-2 0v-5H6a1 1 0 0 1 0-2h5v-5a1 1 0 0 1 2 0v5h5a1 1 0 0 1 0 2"></path>
                                                </svg>Add
                                            </button>
                                        </div> -->
                                    </div>
                                    <form class="form-inline user-edit p-3" action="">
                                        <div class="input-group">
                                            <label for="">Field 1:</label>
                                            <input type="text" class="form-control" placeholder="" value="">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                                            </div>
                                        </div>
                                        <div class="input-group">
                                            <label for="">Field 2:</label>
                                            <input type="text" class="form-control" placeholder="" value="">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                                            </div>
                                        </div>
                                        <div class="input-group">
                                            <label for="">Field 3:</label>
                                            <input type="text" class="form-control" placeholder="" value="">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                                            </div>
                                        </div>
                                        <div class="input-group">
                                            <label for="">Field 4:</label>
                                            <input type="text" class="form-control" placeholder="" value="">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                                            </div>
                                        </div>
                                        <div class="input-group">
                                            <label for="">Field 5:</label>
                                            <input type="text" class="form-control" placeholder="" value="">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                                            </div>
                                        </div>
                                        <div class="input-group">
                                            <label for="">Signature 1:</label>
                                            <input type="text" class="form-control" placeholder="" value="">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                                            </div>
                                        </div>
                                        <div class="input-group">
                                            <label for="">Signature 2:</label>
                                            <input type="text" class="form-control" placeholder="" value="">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="row">
                                <div class="container active p-0 mt-5 custom-w" style="    box-shadow: 0px 0px 14px 0px #0055A51A;border-radius: 10px;margin-left: 12px;">
                                    <div class="row bg-blue py-2">
                                        <h1>WorkOrder</h1>
                                        <!-- <div class="btns parts">
                                            <button class="btn" data-bs-toggle="modal" data-bs-target="#add-notification">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="34" height="34" viewBox="0 0 24 24">
                                                    <path fill="currentColor" d="M18 12.998h-5v5a1 1 0 0 1-2 0v-5H6a1 1 0 0 1 0-2h5v-5a1 1 0 0 1 2 0v5h5a1 1 0 0 1 0 2"></path>
                                                </svg>Add
                                            </button>
                                        </div> -->
                                    </div>
                                    <form class="form-inline user-edit p-3" action="">
                                        <div class="input-group">
                                            <label for="">Field 1:</label>
                                            <input type="text" class="form-control" placeholder="" value="">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                                            </div>
                                        </div>
                                        <div class="input-group">
                                            <label for="">Field 2:</label>
                                            <input type="text" class="form-control" placeholder="" value="">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                                            </div>
                                        </div>
                                        <div class="input-group">
                                            <label for="">Field 3:</label>
                                            <input type="text" class="form-control" placeholder="" value="">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                                            </div>
                                        </div>
                                        <div class="input-group">
                                            <label for="">Field 4:</label>
                                            <input type="text" class="form-control" placeholder="" value="">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                                            </div>
                                        </div>
                                        <div class="input-group">
                                            <label for="">Field 5:</label>
                                            <input type="text" class="form-control" placeholder="" value="">
                                            <div class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                                <div id="help-support" class="tab-pane" role="tabpanel" aria-labelledby="tab-help-support">
                        <div class="help-support-section">
                            <div class="help-card">
                                <div class="help-header">
                                    <h2>Need Help?</h2>
                                    <p>If you get any problem related to software please reach us on</p>
                                </div>
                                <div class="contact-methods">
                                    <a href="mailto:contact@heavyvehicleinspection.com" class="contact-link">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"/>
                                            <polyline points="22,6 12,13 2,6"/>
                                        </svg>
                                        contact@heavyvehicleinspection.com
                                    </a>
                                    <a href="tel:+1 315-888-1995" class="contact-link">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"/>
                                        </svg>
                                        +1 315-888-1995
                                    </a>
                                </div>
                                <div class="app-downloads">
                                    <h3>Download Our Mobile App</h3>
                                    <div class="download-buttons">
                                        <img src="app-storres.png" alt="Download on App Store" class="download-btn">
                                        <img src="google-play.png" alt="Get it on Google Play" class="download-btn">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>

<script>
(function() {
    'use strict';

    // Configuration object
    const CONFIG = {
        selectors: {
            sidebar: '.sidebar',
            tabButtons: '.tab-btn',
            tabPanes: '.tab-pane',
            modals: '.modal',
            backdrop: '.modal-backdrop'
        },
        classes: {
            collapsed: 'collapsed',
            active: 'active',
            show: 'show',
            modalOpen: 'modal-open'
        },
        messages: {
            tabSwitched: 'Tab switched successfully',
            formSaved: 'Settings saved successfully',
            formError: 'Error saving settings'
        },
        timing: {
            notificationDelay: 100,
            notificationDuration: 3000,
            animationDuration: 300
        },
        zIndex: {
            notification: 10001
        }
    };

    // DOM elements cache
    let elements = {};

    // Initialize DOM elements
    function initElements() {
        elements = {
            sidebar: document.querySelector(CONFIG.selectors.sidebar),
            tabButtons: document.querySelectorAll(CONFIG.selectors.tabButtons),
            tabPanes: document.querySelectorAll(CONFIG.selectors.tabPanes),
            modals: document.querySelectorAll(CONFIG.selectors.modals),
            backdrop: document.querySelector(CONFIG.selectors.backdrop)
        };
    }

    // Toggle sidebar
    function toggleSidebar() {
        if (elements.sidebar) {
            elements.sidebar.classList.toggle(CONFIG.classes.collapsed);
        }
    }

    // Initialize tab functionality
    function initTabs() {
        elements.tabButtons.forEach(button => {
            button.addEventListener('click', function() {
                const targetTab = this.getAttribute('data-tab');
                
                // Remove active class from all buttons and panes
                elements.tabButtons.forEach(btn => {
                    btn.classList.remove(CONFIG.classes.active);
                    btn.setAttribute('aria-selected', 'false');
                });
                elements.tabPanes.forEach(pane => {
                    pane.classList.remove(CONFIG.classes.active);
                });

                // Add active class to clicked button and corresponding pane
                this.classList.add(CONFIG.classes.active);
                this.setAttribute('aria-selected', 'true');
                
                const targetPane = document.getElementById(targetTab);
                if (targetPane) {
                    targetPane.classList.add(CONFIG.classes.active);
                }
            });
        });
    }

    // Show notification
    function showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `account-notification account-notification-${type}`;
        notification.textContent = message;

        notification.style.cssText = `
            position: fixed;
            top: 80px;
            right: 20px;
            padding: 12px 20px;
            border-radius: 0;
            color: white;
            font-weight: 500;
            font-size: 14px;
            z-index: ${CONFIG.zIndex.notification};
            opacity: 0;
            transform: translateX(100%);
            transition: all ${CONFIG.timing.animationDuration}ms ease;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            font-family: var(--font-family, 'Inter', sans-serif);
        `;

        // Set background based on type
        const backgrounds = {
            success: 'linear-gradient(135deg, #10b981 0%, #059669 100%)',
            error: 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)',
            warning: 'linear-gradient(135deg, #f59e0b 0%, #d97706 100%)',
            info: 'linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%)'
        };

        notification.style.background = backgrounds[type] || backgrounds.info;

        document.body.appendChild(notification);

        // Animate in
        setTimeout(() => {
            notification.style.opacity = '1';
            notification.style.transform = 'translateX(0)';
        }, CONFIG.timing.notificationDelay);

        // Animate out and remove
        setTimeout(() => {
            notification.style.opacity = '0';
            notification.style.transform = 'translateX(100%)';
            setTimeout(() => {
                if (notification.parentNode) {
                    document.body.removeChild(notification);
                }
            }, CONFIG.timing.animationDuration);
        }, CONFIG.timing.notificationDuration);
    }

    // Initialize form handlers
    function initFormHandlers() {
        const forms = document.querySelectorAll('form');
        forms.forEach(form => {
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Simulate form submission
                showNotification(CONFIG.messages.formSaved, 'success');
                
                // Close modal if it's inside one
                const modal = this.closest('.modal');
                if (modal) {
                    const bsModal = bootstrap.Modal.getInstance(modal);
                    if (bsModal) {
                        bsModal.hide();
                    }
                }
            });
        });
    }

    // Initialize modal handlers
    function initModalHandlers() {
        elements.modals.forEach(modal => {
            modal.addEventListener('hidden.bs.modal', function() {
                // Reset form when modal is closed
                const form = this.querySelector('form');
                if (form) {
                    form.reset();
                }
            });
        });
    }

    // Initialize the application
    function init() {
        initElements();
        initTabs();
        initFormHandlers();
        initModalHandlers();
    }

    // Make functions globally accessible
    window.toggleSidebar = toggleSidebar;
    window.showNotification = showNotification;

    // Initialize when DOM is ready
    document.addEventListener('DOMContentLoaded', init);
})();
</script>
<!-- Inspection Edit Popup modals -->
<div class="modal user-edit" id="inspection-edit">
    <div class="modal-dialog" style="">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Inspection Settings</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form class="form-inline" action="">
                    <div class="input-group">
                        <label for="">Report Header :</label>
                        <input type="text" class="form-control" placeholder="" value="Heavy Vehicle Inspection Report">
                    </div>
                    <div class="input-group">
                        <label for="">Left Footer :</label>
                        <input type="text" class="form-control" placeholder="" value="HVI App">
                    </div>
                    <div class="input-group">
                        <label for="">Right Footer (Address) :</label>
                        <input type="text" class="form-control" placeholder="" value="www.heavyvehicleinspection.com">
                    </div>
                    <div class="input-group">
                        <label for="">Report Prefix :</label>
                        <input type="text" class="form-control" placeholder="" value="HVI">
                    </div>
                    <div class="input-group">
                        <label for="">Report Start Number :</label>
                        <input type="text" class="form-control" placeholder="" value="1000">
                    </div>
                    <div class="input-group">
                        <label for="">Inspection Note Required :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <label class="form-check-label" for="flexSwitchCheckDefault">No</label>
                        </div>
                    </div>
                    <div class="input-group">
                        <label for="">Inspection Image Required :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <label class="form-check-label" for="flexSwitchCheckDefault">No</label>
                        </div>
                    </div>
                    <div class="input-group">
                        <label for="">Time Zone :</label>
                        <input type="text" class="form-control" placeholder="+05:30">
                    </div>
                </form>
                <div class="row my-3 align-items-center justify-content-center">
                    <button type="submit" class="save btn btn-danger col-md-4 mx-2" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                            <path fill="currentColor" d="M17 3H5a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14c1.1 0 2-.9 2-2V7zm2 16H5V5h11.17L19 7.83zm-7-7c-1.66 0-3 1.34-3 3s1.34 3 3 3s3-1.34 3-3s-1.34-3-3-3M6 6h9v4H6z" />
                        </svg> Save</button>
                    <!-- Modal footer -->
                    <div class="modal-footer col-md-4 p-0 w-auto">
                        <button type="button" class="save btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 24 24">
                                <path fill="currentColor" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                            </svg>Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Workorder Edit Popup modals -->
<div class="modal user-edit" id="workorder-edit">
    <div class="modal-dialog" style="">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Workorder Settings</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form class="form-inline" action="">
                    <div class="input-group">
                        <label for="">WorkOrder Prefix :</label>
                        <input type="text" class="form-control" placeholder="" value="WO">
                    </div>
                    <div class="input-group">
                        <label for="">WorkOrder Start Number :</label>
                        <input type="text" class="form-control" placeholder="" value="1000">
                    </div>
                    <div class="input-group">
                        <label for="">Currency :</label>
                        <input type="text" class="form-control" placeholder="" value="USD">
                    </div>
                    <div class="input-group">
                        <label for="">Tax :</label>
                        <input type="text" class="form-control" placeholder="" value="0">
                    </div>
                    <div class="input-group">
                        <label for="">Tax on parts cost :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <label class="form-check-label" for="flexSwitchCheckDefault">No</label>
                        </div>
                    </div>
                    <div class="input-group">
                        <label for="">Tax on labor cost :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <label class="form-check-label" for="flexSwitchCheckDefault">No</label>
                        </div>
                    </div>
                    <div class="input-group">
                        <label for="">Tax on additional cost :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <label class="form-check-label" for="flexSwitchCheckDefault">No</label>
                        </div>
                    </div>
                </form>
                <div class="row my-3 align-items-center justify-content-center">
                    <button type="submit" class="save btn btn-danger col-md-4 mx-2" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                            <path fill="currentColor" d="M17 3H5a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14c1.1 0 2-.9 2-2V7zm2 16H5V5h11.17L19 7.83zm-7-7c-1.66 0-3 1.34-3 3s1.34 3 3 3s3-1.34 3-3s-1.34-3-3-3M6 6h9v4H6z" />
                        </svg> Save</button>
                    <!-- Modal footer -->
                    <div class="modal-footer col-md-4 p-0 w-auto">
                        <button type="button" class="save btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 24 24">
                                <path fill="currentColor" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                            </svg>Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Fuel Edit Popup modals -->
<div class="modal user-edit" id="fuel-edit">
    <div class="modal-dialog" style="">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Fuel Settings</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form class="form-inline" action="">
                    <div class="input-group">
                        <label for="">Fuel Bunker Low Alert(%) :</label>
                        <input type="text" class="form-control" placeholder="" value="30%">
                    </div>
                    <div class="input-group">
                        <label for="">Stop fuel issuing at limit(%) :</label>
                        <input type="text" class="form-control" placeholder="" value="">
                    </div>
                </form>
                <div class="row my-3 align-items-center justify-content-center">
                    <button type="submit" class="save btn btn-danger col-md-4 mx-2" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                            <path fill="currentColor" d="M17 3H5a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14c1.1 0 2-.9 2-2V7zm2 16H5V5h11.17L19 7.83zm-7-7c-1.66 0-3 1.34-3 3s1.34 3 3 3s3-1.34 3-3s-1.34-3-3-3M6 6h9v4H6z" />
                        </svg> Save</button>
                    <!-- Modal footer -->
                    <div class="modal-footer col-md-4 p-0 w-auto">
                        <button type="button" class="save btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 24 24">
                                <path fill="currentColor" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                            </svg>Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Schedule Edit Popup modals -->
<div class="modal user-edit" id="schedule-edit">
    <div class="modal-dialog" style="">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Schedule Settings</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form class="form-inline" action="">
                    <div class="input-group">
                        <label for="">Schedule ID Prefix :</label>
                        <input type="text" class="form-control" placeholder="" value="SCH">
                    </div>
                    <div class="input-group">
                        <label for="">Schedule ID Start Number :</label>
                        <input type="text" class="form-control" placeholder="" value="1000">
                    </div>
                </form>
                <div class="row my-3 align-items-center justify-content-center">
                    <button type="submit" class="save btn btn-danger col-md-4 mx-2" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                            <path fill="currentColor" d="M17 3H5a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14c1.1 0 2-.9 2-2V7zm2 16H5V5h11.17L19 7.83zm-7-7c-1.66 0-3 1.34-3 3s1.34 3 3 3s3-1.34 3-3s-1.34-3-3-3M6 6h9v4H6z" />
                        </svg> Save</button>
                    <!-- Modal footer -->
                    <div class="modal-footer col-md-4 p-0 w-auto">
                        <button type="button" class="save btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 24 24">
                                <path fill="currentColor" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                            </svg>Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Purchase Edit Popup modals -->
<div class="modal user-edit" id="purchase-edit">
    <div class="modal-dialog" style="">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Purchase Order settings</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form class="form-inline" action="">
                    <div class="input-group">
                        <label for="">Pre Approved Limit :</label>
                        <input type="text" class="form-control" placeholder="" value="0">
                    </div>
                </form>
                <div class="row my-3 align-items-center justify-content-center">
                    <button type="submit" class="save btn btn-danger col-md-4 mx-2" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                            <path fill="currentColor" d="M17 3H5a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14c1.1 0 2-.9 2-2V7zm2 16H5V5h11.17L19 7.83zm-7-7c-1.66 0-3 1.34-3 3s1.34 3 3 3s3-1.34 3-3s-1.34-3-3-3M6 6h9v4H6z" />
                        </svg> Save</button>
                    <!-- Modal footer -->
                    <div class="modal-footer col-md-4 p-0 w-auto">
                        <button type="button" class="save btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 24 24">
                                <path fill="currentColor" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                            </svg>Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Upload Receipt Image popup -->
<div class="modal search-popup" id="select-image">
    <div class="modal-dialog" style="">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Upload Image</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form class="form-inline" action="">
                    <div class="input-group">
                        <input class="form-control" type="file" id="" placeholder="Choose a file for uploading...">
                    </div>
                    <div class="row my-3 align-items-center justify-content-center">
                        <button type="button" class="save btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 5v9m-5 0H5a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-2M8 9l4-5l4 5m1 8h.01" />
                            </svg>Upload</button>
                        <!-- Modal footer -->
                        <div class="modal-footer col-md-4 p-0 w-auto">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                    <path fill="currentColor" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                                </svg>Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!--Profile Info Edit Popup modals -->
<div class="modal user-edit" id="profile-edit">
    <div class="modal-dialog" style="">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Edit Profile Info</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form class="form-inline" action="">
                    <div class="input-group">
                        <label for="">Location :</label>
                        <input type="text" class="form-control" placeholder="" value="India">
                    </div>
                    <div class="input-group">
                        <label for="">Company Name :</label>
                        <input type="text" class="form-control" placeholder="" value="">
                    </div>
                    <div class="input-group">
                        <label for="">Company Address :</label>
                        <input type="text" class="form-control" placeholder="" value="">
                    </div>
                    <div class="input-group">
                        <label for="">Contact Number :</label>
                        <input type="text" class="form-control" placeholder="" value="">
                    </div>
                    <div class="input-group">
                        <label for="">Admin Name :</label>
                        <input type="text" class="form-control" placeholder="" value="Dummy Text">
                    </div>
                    <div class="input-group">
                        <label for="">Country :</label>
                        <input type="text" class="form-control" placeholder="India">
                    </div>
                </form>
                <div class="row my-3 align-items-center justify-content-center">
                    <button type="submit" class="save btn btn-danger col-md-4 mx-2" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                            <path fill="currentColor" d="M17 3H5a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14c1.1 0 2-.9 2-2V7zm2 16H5V5h11.17L19 7.83zm-7-7c-1.66 0-3 1.34-3 3s1.34 3 3 3s3-1.34 3-3s-1.34-3-3-3M6 6h9v4H6z" />
                        </svg> Save</button>
                    <!-- Modal footer -->
                    <div class="modal-footer col-md-4 p-0 w-auto">
                        <button type="button" class="save btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 24 24">
                                <path fill="currentColor" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                            </svg>Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Notification Popup modals -->
<div class="modal user-edit" id="add-notification">
    <div class="modal-dialog" style="">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Add Notification</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form class="form-inline" action="">
                    <div class="input-group">
                        <label for="">Team Member * :</label>
                        <input type="text" class="form-control" placeholder="" value="">
                    </div>
                    <div class="input-group">
                        <label for="">Email :</label>
                        <input type="text" class="form-control" placeholder="" value="">
                    </div>
                    <div class="row app-email">
                        <div style="width:30%"></div>
                        <div style="width:30%"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 36 36">
                                <path fill="currentColor" d="M32 6H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h28a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2m-1.54 22H5.66l7-7.24l-1.44-1.39L4 26.84V9.52l12.43 12.37a2 2 0 0 0 2.82 0L32 9.21v17.5l-7.36-7.36l-1.41 1.41ZM5.31 8h25.07L17.84 20.47Z" class="clr-i-outline clr-i-outline-path-1" />
                                <path fill="none" d="M0 0h36v36H0z" />
                            </svg> Email Notification</div>
                        <div style="width:30%"> <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 32 32">
                                <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 25h2M11 3h10a2 2 0 0 1 2 2v22a2 2 0 0 1-2 2H11a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2" />
                            </svg>App Notification</div>
                    </div>
                    <div class="input-group">
                        <label for="">Inspection :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                        </div>
                    </div>
                    <div class="input-group">
                        <label for="">Workorder :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                        </div>
                    </div>
                    <div class="input-group">
                        <label for="">Incident Report :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                        </div>
                    </div>
                    <div class="input-group">
                        <label for="">Fuel Bunker Alert :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                        </div>
                    </div>
                    <div class="input-group">
                        <label for="">Management Report :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                        </div>
                    </div>
                    <div class="input-group">
                        <label for="">Schedule Report :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                        </div>
                    </div>
                    <div class="input-group">
                        <label for="">Parts Report :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                        </div>
                    </div>
                    <div class="input-group">
                        <label for="">PO Demand Report :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                        </div>
                    </div>
                    <div class="input-group">
                        <label for="">PO Approval :</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                            <input class="form-check-input" type="checkbox" id="flexSwitchCheckDefault">
                        </div>
                    </div>
                </form>
                <div class="row my-3 align-items-center justify-content-center">
                    <button type="submit" class="save btn btn-danger col-md-4 mx-2" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="34" height="34" viewBox="0 0 24 24">
                            <path fill="currentColor" d="M18 12.998h-5v5a1 1 0 0 1-2 0v-5H6a1 1 0 0 1 0-2h5v-5a1 1 0 0 1 2 0v5h5a1 1 0 0 1 0 2"></path>
                        </svg>Add</button>
                    <!-- Modal footer -->
                    <div class="modal-footer col-md-4 p-0 w-auto">
                        <button type="button" class="save btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 24 24">
                                <path fill="currentColor" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                            </svg>Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    var dropdown = document.getElementsByClassName("dropdown-btn");
    var i;

    for (i = 0; i < dropdown.length; i++) {
        dropdown[i].addEventListener("click", function() {
            this.classList.toggle("active");
            var dropdownContent = this.nextElementSibling;
            if (dropdownContent.style.display === "block") {
                dropdownContent.style.display = "none";
            } else {
                dropdownContent.style.display = "block";
            }
        });
    }
</script>
@endsection

<style>
/* Import Google Fonts for better typography */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* ===== CSS VARIABLES ===== */
:root {
    /* Primary Colors */
    --primary-color: #0055a5;
    --primary-hover: rgba(255, 255, 255, 0.2);
    --secondary-color: #64748b;
    --secondary-hover: #475569;
    --success-color: #10b981;
    --success-hover: #059669;
    --warning-color: #f59e0b;
    --warning-hover: #d97706;
    --danger-color: #ef4444;
    --danger-hover: #dc2626;
    --info-color: #3b82f6;
    --info-hover: #1d4ed8;

    /* Text Colors */
    --text-primary: #0f172a;
    --text-secondary: #64748b;
    --text-muted: #94a3b8;
    --text-light: #cbd5e1;
    --text-white: #ffffff;

    /* Background Colors */
    --bg-primary: #f8fafc;
    --bg-secondary: #f1f5f9;
    --bg-white: #ffffff;
    --bg-hover: #f8fafc;
    --bg-gradient: linear-gradient(135deg, #1e293b 0%, #334155 100%);

    /* Border Colors */
    --border-color: #e2e8f0;
    --border-light: #f1f5f9;

    /* Shadows */
    --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    --shadow-lg: 0 10px 25px rgba(0, 0, 0, 0.1);

    /* Border Radius */
    --radius-sm: 0;
    --radius-md: 0;
    --radius-lg: 0;

    /* Transitions */
    --transition-base: all 0.2s ease;
    --transition-slow: all 0.3s ease;

    /* Typography */
    --font-family: 'Inter', sans-serif;

    /* Z-Index */
    --z-index-modal: 1050;
    --z-index-notification: 10001;
}

/* ===== MAIN CONTAINER ===== */
.account-container {
    min-height: 100vh;
    background: var(--bg-primary);
    font-family: var(--font-family);
    padding: 0;
    margin: 0;
    overflow-x: hidden;
    overflow-y: visible;
}

/* ===== HEADER STYLES ===== */
.account-header {
    background: var(--bg-gradient);
    padding: 2rem 0;
    margin-bottom: 0;
    box-shadow: var(--shadow-md);
    display: none;
}

.header-content {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 2rem;
}

.page-title h1 {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--text-white);
    margin: 0 0 0.5rem 0;
    letter-spacing: -0.025em;
}

.page-title p {
    font-size: 1.125rem;
    color: var(--text-light);
    margin: 0;
    font-weight: 400;
}

/* ===== MAIN CONTENT ===== */
.account-content {
    min-height: 100vh;
}

.content-box {
    background: var(--bg-white);
    padding: 32px 32px 32px 40px;
    border-radius: var(--radius-sm);
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--border-color);
    font-family: var(--font-family);
    margin-bottom: 2rem;
}

/* ===== ACTION BAR ===== */
.action-bar {
    background: transparent;
    border: none;
    border-radius: var(--radius-sm);
    padding: 0;
    margin-bottom: 32px;
    box-shadow: none;
}

.action-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 1rem;
    flex-wrap: wrap;
}

.page-title h1, .page-title h2 {
    color: var(--text-primary);
    font-weight: 700;
    font-size: 32px;
    line-height: 1.2;
    letter-spacing: -0.025em;
    margin: 0;
}

.page-title h2 {
    font-size: 24px;
}

/* ===== MODERN TABS ===== */
.modern-tabs {
    margin-top: 2rem;
}

.tab-navigation {
    display: flex;
    background: #f8fafc;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    padding: 0.5rem;
    margin-bottom: 2rem;
    gap: 0.5rem;
    overflow-x: auto;
}

.tab-btn {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: transparent;
    border: none;
    border-radius: 0;
    color: #64748b;
    font-size: 0.875rem;
    font-weight: 600;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
    white-space: nowrap;
    min-width: fit-content;
}

.tab-btn:hover {
    background: #f1f5f9;
    color: #475569;
}

.tab-btn.active {
    background: #0055a5;
    color: #ffffff;
    box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2);
}

.tab-icon {
    width: 18px;
    height: 18px;
    flex-shrink: 0;
}

.tab-text {
    font-weight: 600;
}

/* ===== TAB CONTENT ===== */
.tab-content {
    margin-top: 0;
}

.tab-pane {
    display: none;
}

.tab-pane.active {
    display: block;
}

/* ===== SETTINGS GRID ===== */
.settings-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
    gap: 2rem;
    margin-bottom: 2rem;
}

.settings-card {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    overflow: hidden;
}

.settings-header {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    padding: 1.5rem 2rem;
    border-bottom: 1px solid #e2e8f0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.settings-header h3 {
    font-size: 1.25rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
}

.btn-edit {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 1rem;
    background: #0055a5;
    color: #ffffff;
    border: none;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    /* font-family: 'Inter', sans-serif; */
    cursor: pointer;
    transition: all 0.2s ease;
    /* box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2); */
}

.btn-edit:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-1px);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    color: black !important;
}

/* ===== SETTINGS TABLE ===== */
.settings-table {
    padding: 0;
}

.setting-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem 2rem;
    border-bottom: 1px solid #f1f5f9;
    transition: background-color 0.2s ease;
}

.setting-row:last-child {
    border-bottom: none;
}

.setting-row:hover {
    background: #f8fafc;
}

.setting-label {
    font-weight: 600;
    color: #374151;
    font-size: 0.875rem;
}

.setting-value {
    color: #1e293b;
    font-size: 0.875rem;
    font-weight: 500;
}

.setting-value.status-off {
    color: #ef4444;
    font-weight: 600;
}

/* ===== LOGO CARD ===== */
.logo-card {
    grid-column: 1 / -1;
}

.logo-card .logo-section {
    text-align: center;
    padding: 20px;
}

.logo-preview {
    margin-bottom: 1.5rem;
}

.company-logo {
    max-width: 200px;
    max-height: 100px;
    object-fit: contain;
}

.btn-upload-logo {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: #00B894;
    color: #ffffff;
    border: none;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    /* font-family: 'Inter', sans-serif; */
    cursor: pointer;
    transition: all 0.2s ease;
    /* box-shadow: 0 2px 4px rgba(16, 185, 129, 0.2); */
}

.btn-upload-logo:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-1px);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    color: black !important;
}

/* ===== CUSTOM FIELDS ===== */
.custom-fields-section {
    margin-top: 2rem;
}

.section-header {
    margin-bottom: 2rem;
}

.section-header h2 {
    font-size: 1.5rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
}

.custom-fields-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(500px, 1fr));
    gap: 2rem;
}

.custom-field-card {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    overflow: hidden;
}

.field-header {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    padding: 1.5rem 2rem;
    border-bottom: 1px solid #e2e8f0;
}

.field-header h3 {
    font-size: 1.25rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
}

.custom-field-form {
    padding: 2rem;
}

.field-group {
    margin-bottom: 1.5rem;
}

.field-group label {
    display: block;
    font-weight: 600;
    color: #374151;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
}

.field-input-group {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.field-input-group .form-control {
    flex: 1;
    border: 2px solid #e2e8f0;
    border-radius: 0;
    padding: 0.75rem 1rem;
    font-size: 0.875rem;
    font-weight: 500;
    color: #1e293b;
    background: #ffffff;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
}

.field-input-group .form-control:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.form-check.form-switch {
    margin: 0;
}

.form-check-input {
    width: 3rem;
    height: 1.5rem;
    border-radius: 0;
    border: 2px solid #e2e8f0;
    background-color: #ffffff;
    transition: all 0.2s ease;
}

.form-check-input:checked {
    background-color: #3b82f6;
    border-color: #3b82f6;
}

/* ===== HELP SUPPORT ===== */
.help-support-section {
    margin-top: 2rem;
}

.help-card {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    padding: 3rem 2rem;
    text-align: center;
    max-width: 600px;
    margin: 0 auto;
}

.help-header h2 {
    font-size: 2rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0 0 1rem 0;
}

.help-header p {
    font-size: 1.125rem;
    color: #64748b;
    margin: 0 0 2rem 0;
}

.contact-methods {
    display: flex;
    flex-direction: column;
    gap: 1rem;
    margin-bottom: 3rem;
}

.contact-link {
    display: inline-flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 2rem;
    background: #f8fafc;
    border: 2px solid #e2e8f0;
    border-radius: 0;
    color: #1e293b;
    text-decoration: none;
    font-weight: 600;
    font-size: 1rem;
    transition: all 0.2s ease;
}

.contact-link:hover {
    background: #f1f5f9;
    border-color: #3b82f6;
    color: #3b82f6;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(59, 130, 246, 0.1);
}

.app-downloads h3 {
    font-size: 1.5rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0 0 1.5rem 0;
}

.download-buttons {
    display: flex;
    justify-content: center;
    gap: 1rem;
    flex-wrap: wrap;
}

.download-btn {
    height: 60px;
    transition: transform 0.2s ease;
}

.download-btn:hover {
    transform: scale(1.05);
}

/* ===== MODAL STYLES ===== */
.modal {
    font-family: 'Inter', sans-serif;
}

.modal.show {
    display: block;
}

.modal.fade .modal-dialog {
    transition: transform 0.3s ease-out;
    transform: translate(0, -50px);
}

.modal.show .modal-dialog {
    transform: none;
}

.modal-dialog {
    max-width: 100%;
    margin: 1.75rem auto;
}

.modal-content {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
}

.modal-header {
    background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
    color: #ffffff;
    border-bottom: 1px solid #e2e8f0;
    padding: 1.5rem 2rem;
    border-radius: 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.modal-title {
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0;
    color: #ffffff;
}

.modal-body {
    padding: 2rem;
}

.modal-footer {
    background: #f8fafc;
    border-top: 1px solid #e2e8f0;
    padding: 1.5rem 2rem;
    display: flex;
    justify-content: flex-end;
    gap: 1rem;
    border-radius: 0;
}

/* ===== FORM STYLES ===== */
.form-inline {
    width: 100%;
}

.input-group {
    margin-bottom: 1.5rem;
}

.input-group label {
    display: block;
    font-weight: 600;
    color: #374151;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
}

.form-control {
    border: 2px solid #e2e8f0;
    border-radius: 0;
    padding: 0.75rem 1rem;
    font-size: 0.875rem;
    font-weight: 500;
    color: #1e293b;
    background: #ffffff;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
    width: 100%;
}

.form-control:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

/* ===== BUTTON STYLES ===== */
.btn, .save {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    color: #ffffff;
    border: none;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
    box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2);
    text-decoration: none;
}

.btn:hover, .save:hover {
    background: linear-gradient(135deg, #1d4ed8 0%, #1e40af 100%);
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(59, 130, 246, 0.3);
}

.btn-danger {
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    box-shadow: 0 2px 4px rgba(239, 68, 68, 0.2);
}

.btn-danger:hover {
    background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
    box-shadow: 0 4px 8px rgba(239, 68, 68, 0.3);
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 1200px) {
    .account-container {
        padding: 16px;
    }
    
    .content-box {
        padding: 24px 24px 24px 32px;
        margin-left: 0.25rem;
    }
    
    .settings-grid {
        grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
        gap: 1.5rem;
    }
    
    .custom-fields-grid {
        grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
        gap: 1.5rem;
    }
    
    .modal-dialog {
        width: 90%;
        max-width: 800px;
    }
}

@media (max-width: 992px) {
    .account-container {
        padding: 12px;
    }
    
    .content-box {
        padding: 20px 20px 20px 28px;
        margin-left: 0.125rem;
    }
    
    .page-title h1 {
        font-size: 28px;
    }
    
    .page-title h2 {
        font-size: 22px;
    }
    
    .tab-navigation {
        flex-wrap: wrap;
        gap: 0.25rem;
    }
    
    .tab-btn {
        padding: 0.625rem 1.25rem;
        font-size: 0.8rem;
    }
    
    .settings-grid {
        grid-template-columns: 1fr;
        gap: 1.25rem;
    }
    
    .custom-fields-grid {
        grid-template-columns: 1fr;
        gap: 1.25rem;
    }
    
    .settings-header {
        padding: 1.25rem 1.5rem;
        flex-direction: column;
        gap: 0.75rem;
        align-items: flex-start;
    }
    
    .setting-row {
        padding: 0.875rem 1.5rem;
    }
    
    .field-input-group {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
    }
    
    .modal-dialog {
        width: 95%;
        max-width: 700px;
    }
}

@media (max-width: 768px) {
    .account-container {
        padding: 8px;
    }
    
    .content-box {
        padding: 16px 16px 16px 20px;
        margin-left: 0;
    }
    
    .page-title h1 {
        font-size: 24px;
    }
    
    .page-title h2 {
        font-size: 20px;
    }
    
    .tab-navigation {
        flex-direction: column;
        gap: 0.125rem;
        padding: 0.25rem;
    }
    
    .tab-btn {
        justify-content: flex-start;
        padding: 0.875rem 1.25rem;
        font-size: 0.875rem;
        width: 100%;
    }
    
    .settings-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .custom-fields-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .settings-header {
        padding: 1rem 1.25rem;
        flex-direction: column;
        gap: 0.75rem;
        align-items: flex-start;
    }
    
    .settings-header h3 {
        font-size: 1.125rem;
    }
    
    .btn-edit {
        padding: 0.5rem 0.875rem;
        font-size: 0.8rem;
    }
    
    .setting-row {
        padding: 0.75rem 1.25rem;
        flex-direction: column;
        align-items: flex-start;
        gap: 0.375rem;
    }
    
    .setting-label {
        font-size: 0.8rem;
    }
    
    .setting-value {
        font-size: 0.8rem;
    }
    
    .field-input-group {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
    }
    
    .field-input-group .form-control {
        width: 100%;
        padding: 0.625rem 0.875rem;
        font-size: 0.8rem;
    }
    
    .form-check-input {
        width: 2.5rem;
        height: 1.25rem;
    }
    
    .contact-methods {
        gap: 0.5rem;
    }
    
    .contact-link {
        padding: 0.75rem 1.25rem;
        font-size: 0.8rem;
    }
    
    .download-buttons {
        flex-direction: column;
        align-items: center;
        gap: 0.75rem;
    }
    
    .download-btn {
        height: 50px;
    }
    
    .modal-dialog {
        margin: 0.5rem;
        width: 95%;
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 1rem 1.25rem;
    }
    
    .modal-title {
        font-size: 1.25rem;
    }
    
    .input-group {
        margin-bottom: 1rem;
    }
    
    .input-group label {
        font-size: 0.8rem;
        margin-bottom: 0.375rem;
    }
    
    .form-control {
        padding: 0.625rem 0.875rem;
        font-size: 0.8rem;
    }
    
    .btn, .save {
        padding: 0.625rem 1.25rem;
        font-size: 0.8rem;
    }
}

@media (max-width: 576px) {
    .account-container {
        padding: 4px;
    }
    
    .content-box {
        padding: 12px 12px 12px 16px;
    }
    
    .page-title h1 {
        font-size: 20px;
    }
    
    .page-title h2 {
        font-size: 18px;
    }
    
    .tab-navigation {
        padding: 0.125rem;
    }
    
    .tab-btn {
        padding: 0.75rem 1rem;
        font-size: 0.8rem;
    }
    
    .tab-icon {
        width: 16px;
        height: 16px;
    }
    
    .settings-grid {
        gap: 0.75rem;
    }
    
    .custom-fields-grid {
        gap: 0.75rem;
    }
    
    .settings-header {
        padding: 0.875rem 1rem;
    }
    
    .settings-header h3 {
        font-size: 1rem;
    }
    
    .btn-edit {
        padding: 0.375rem 0.75rem;
        font-size: 0.75rem;
    }
    
    .setting-row {
        padding: 0.625rem 1rem;
    }
    
    .setting-label {
        font-size: 0.75rem;
    }
    
    .setting-value {
        font-size: 0.75rem;
    }
    
    .custom-field-form {
        padding: 1rem;
    }
    
    .field-group {
        margin-bottom: 1rem;
    }
    
    .field-group label {
        font-size: 0.75rem;
    }
    
    .field-input-group .form-control {
        padding: 0.5rem 0.75rem;
        font-size: 0.75rem;
    }
    
    .form-check-input {
        width: 2rem;
        height: 1rem;
    }
    
    .help-card {
        padding: 1.5rem 1rem;
    }
    
    .help-header h2 {
        font-size: 1.25rem;
    }
    
    .help-header p {
        font-size: 0.875rem;
    }
    
    .contact-link {
        padding: 0.625rem 1rem;
        font-size: 0.75rem;
    }
    
    .download-btn {
        height: 45px;
    }
    
    .modal-dialog {
        margin: 0.25rem;
        width: 98%;
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 0.75rem 1rem;
    }
    
    .modal-title {
        font-size: 1.125rem;
    }
    
    .input-group {
        margin-bottom: 0.75rem;
    }
    
    .input-group label {
        font-size: 0.75rem;
    }
    
    .form-control {
        padding: 0.5rem 0.75rem;
        font-size: 0.75rem;
    }
    
    .btn, .save {
        padding: 0.5rem 1rem;
        font-size: 0.75rem;
    }
}

@media (max-width: 480px) {
    .account-container {
        padding: 2px;
    }
    
    .content-box {
        padding: 8px 8px 8px 12px;
    }
    
    .page-title h1 {
        font-size: 18px;
    }
    
    .page-title h2 {
        font-size: 16px;
    }
    
    .tab-btn {
        padding: 0.625rem 0.875rem;
        font-size: 0.75rem;
    }
    
    .tab-icon {
        width: 14px;
        height: 14px;
    }
    
    .settings-grid {
        gap: 0.5rem;
    }
    
    .custom-fields-grid {
        gap: 0.5rem;
    }
    
    .settings-header {
        padding: 0.75rem 0.875rem;
    }
    
    .settings-header h3 {
        font-size: 0.875rem;
    }
    
    .btn-edit {
        padding: 0.25rem 0.625rem;
        font-size: 0.7rem;
    }
    
    .setting-row {
        padding: 0.5rem 0.875rem;
    }
    
    .setting-label {
        font-size: 0.7rem;
    }
    
    .setting-value {
        font-size: 0.7rem;
    }
    
    .custom-field-form {
        padding: 0.75rem;
    }
    
    .field-group {
        margin-bottom: 0.75rem;
    }
    
    .field-group label {
        font-size: 0.7rem;
    }
    
    .field-input-group .form-control {
        padding: 0.375rem 0.625rem;
        font-size: 0.7rem;
    }
    
    .form-check-input {
        width: 1.75rem;
        height: 0.875rem;
    }
    
    .help-card {
        padding: 1rem 0.75rem;
    }
    
    .help-header h2 {
        font-size: 1.125rem;
    }
    
    .help-header p {
        font-size: 0.8rem;
    }
    
    .contact-link {
        padding: 0.5rem 0.875rem;
        font-size: 0.7rem;
    }
    
    .download-btn {
        height: 40px;
    }
    
    .modal-dialog {
        margin: 0.125rem;
        width: 100%;
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 0.625rem 0.75rem;
    }
    
    .modal-title {
        font-size: 1rem;
    }
    
    .input-group {
        margin-bottom: 0.625rem;
    }
    
    .input-group label {
        font-size: 0.7rem;
    }
    
    .form-control {
        padding: 0.375rem 0.625rem;
        font-size: 0.7rem;
    }
    
    .btn, .save {
        padding: 0.375rem 0.875rem;
        font-size: 0.7rem;
    }
}

/* ===== TABLET LANDSCAPE OPTIMIZATION ===== */
@media (max-width: 1024px) and (orientation: landscape) {
    .account-container {
        padding: 12px;
    }
    
    .content-box {
        padding: 16px 16px 16px 24px;
    }
    
    .tab-navigation {
        flex-direction: row;
        flex-wrap: wrap;
    }
    
    .tab-btn {
        flex: 1;
        min-width: 120px;
    }
    
    .settings-grid {
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    }
}

/* ===== MOBILE LANDSCAPE OPTIMIZATION ===== */
@media (max-width: 896px) and (orientation: landscape) {
    .account-container {
        padding: 8px;
    }
    
    .content-box {
        padding: 12px 12px 12px 16px;
    }
    
    .page-title h1 {
        font-size: 20px;
    }
    
    .tab-navigation {
        flex-direction: row;
        overflow-x: auto;
    }
    
    .tab-btn {
        white-space: nowrap;
        min-width: auto;
    }
}

/* ===== CUSTOM FIELDS RESPONSIVE IMPROVEMENTS ===== */
@media (max-width: 768px) {
    .custom-w {
        margin-left: 0 !important;
        margin-top: 1rem !important;
    }
    
    .bg-blue h1 {
        font-size: 1.125rem;
        padding: 0.75rem 1rem;
    }
    
    .form-inline.user-edit {
        padding: 1rem !important;
    }
    
    .input-group {
        margin-bottom: 0.75rem;
    }
    
    .input-group label {
        font-size: 0.8rem;
        margin-bottom: 0.25rem;
    }
    
    .input-group .form-control {
        padding: 0.5rem 0.75rem;
        font-size: 0.8rem;
    }
    
    .form-check.form-switch {
        margin-left: 0.5rem;
    }
}

/* ===== MODAL RESPONSIVE IMPROVEMENTS ===== */
@media (max-width: 768px) {
    .modal {
        align-items: flex-start;
        padding-top: 20px;
    }
    
    .modal-dialog {
        margin: 0;
    }
    
    .modal-content {
        border-radius: 0;
    }
    
    .modal-footer {
        flex-direction: column;
        gap: 0.5rem;
    }
    
    .btn {
        width: 100%;
        justify-content: center;
    }
}

/* ===== ACCESSIBILITY IMPROVEMENTS ===== */
@media (prefers-reduced-motion: reduce) {
    * {
        transition: none !important;
        animation: none !important;
    }
}

/* ===== HIGH DPI DISPLAYS ===== */
@media (-webkit-min-device-pixel-ratio: 2), (min-resolution: 192dpi) {
    .tab-icon,
    .btn-edit svg,
    .btn-upload-logo svg,
    .contact-link svg {
        image-rendering: -webkit-optimize-contrast;
        image-rendering: crisp-edges;
    }
}

/* ===== ACCESSIBILITY ===== */
@media (prefers-reduced-motion: reduce) {
    * {
        animation-duration: 0.01ms !important;
        animation-iteration-count: 1 !important;
        transition-duration: 0.01ms !important;
    }
}

/* ===== FOCUS STYLES ===== */
button:focus-visible,
input:focus-visible,
select:focus-visible,
a:focus-visible {
    outline: 2px solid #3b82f6;
    outline-offset: 2px;
}

/* ===== PRINT STYLES ===== */
@media print {
    .tab-navigation,
    .modal {
        display: none !important;
    }
    
    .account-container {
        background: white;
    }
    
    .account-header {
        background: white;
        color: black;
    }
    
    .tab-pane {
        display: block !important;
    }
}

/* ===== ENHANCED RESPONSIVE DESIGN ===== */
@media (max-width: 1400px) {
    .account-container {
        padding: 18px;
    }
    
    .account-header {
        margin-bottom: 20px;
    }
    
    .header-content {
        padding: 28px;
    }
}

@media (max-width: 1200px) {
    .account-container {
        padding: 16px;
    }
    
    .header-content {
        padding: 24px;
    }
    
    .account-content {
        padding: 20px;
    }
    
    .account-grid {
        grid-template-columns: 1fr;
        gap: 20px;
    }
}

@media (max-width: 992px) {
    .account-container {
        padding: 14px;
    }
    
    .account-header {
        margin-bottom: 16px;
    }
    
    .header-content {
        padding: 20px;
    }
    
    .page-title h1 {
        font-size: 28px;
    }
    
    .page-title p {
        font-size: 15px;
    }
    
    .account-content {
        padding: 16px;
    }
    
    .account-grid {
        gap: 16px;
    }
    
    .account-section {
        padding: 16px;
    }
    
    .account-section h3 {
        font-size: 20px;
    }
}

@media (max-width: 768px) {
    .account-container {
        padding: 12px;
    }
    
    .header-content {
        padding: 16px;
    }
    
    .page-title h1 {
        font-size: 24px;
    }
    
    .page-title p {
        font-size: 14px;
    }
    
    .account-content {
        padding: 12px;
    }
    
    .account-grid {
        gap: 12px;
    }
    
    .account-section {
        padding: 12px;
    }
    
    .account-section h3 {
        font-size: 18px;
    }
    
    .form-group {
        margin-bottom: 16px;
    }
    
    .form-control,
    .form-select {
        padding: 8px 12px;
        font-size: 14px;
    }
    
    .btn-primary,
    .btn-secondary {
        padding: 10px 16px;
        font-size: 14px;
    }
}

@media (max-width: 576px) {
    .account-container {
        padding: 8px;
    }
    
    .header-content {
        padding: 12px;
    }
    
    .page-title h1 {
        font-size: 20px;
    }
    
    .page-title p {
        font-size: 13px;
    }
    
    .account-content {
        padding: 10px;
    }
    
    .account-grid {
        gap: 10px;
    }
    
    .account-section {
        padding: 10px;
    }
    
    .account-section h3 {
        font-size: 16px;
    }
    
    .form-group {
        margin-bottom: 12px;
    }
    
    .form-control,
    .form-select {
        padding: 6px 10px;
        font-size: 13px;
    }
    
    .btn-primary,
    .btn-secondary {
        padding: 8px 12px;
        font-size: 13px;
    }
}

@media (max-width: 480px) {
    .account-container {
        padding: 6px;
    }
    
    .header-content {
        padding: 10px;
    }
    
    .page-title h1 {
        font-size: 18px;
    }
    
    .page-title p {
        font-size: 12px;
    }
    
    .account-content {
        padding: 8px;
    }
    
    .account-grid {
        gap: 8px;
    }
    
    .account-section {
        padding: 8px;
    }
    
    .account-section h3 {
        font-size: 14px;
    }
    
    .form-group {
        margin-bottom: 10px;
    }
    
    .form-control,
    .form-select {
        padding: 5px 8px;
        font-size: 12px;
    }
    
    .btn-primary,
    .btn-secondary {
        padding: 6px 10px;
        font-size: 12px;
    }
}
</style>

<script>
// Modern Account Management Functionality
document.addEventListener('DOMContentLoaded', function() {
    // Tab switching functionality
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabPanes = document.querySelectorAll('.tab-pane');
    
    tabButtons.forEach(button => {
        button.addEventListener('click', function() {
            const targetTab = this.getAttribute('data-tab');
            
            // Remove active class from all tabs and panes
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabPanes.forEach(pane => pane.classList.remove('active'));
            
            // Add active class to clicked tab and corresponding pane
            this.classList.add('active');
            const targetPane = document.getElementById(targetTab);
            if (targetPane) {
                targetPane.classList.add('active');
            }
        });
    });
    
    // Form validation
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            // Add form submission logic here
            console.log('Form submitted');
        });
    });
    
    // Modal handling
    const modals = document.querySelectorAll('.modal');
    modals.forEach(modal => {
        modal.addEventListener('hidden.bs.modal', function() {
            // Reset form when modal is closed
            const form = this.querySelector('form');
            if (form) {
                form.reset();
            }
        });
    });
    
    // Custom field switches
    const switches = document.querySelectorAll('.form-check-input');
    switches.forEach(switchEl => {
        switchEl.addEventListener('change', function() {
            const input = this.closest('.field-input-group').querySelector('.form-control');
            if (input) {
                input.disabled = !this.checked;
                input.style.opacity = this.checked ? '1' : '0.5';
            }
        });
    });
});
</script>