@extends('welcome')

@section('title', 'Incident Checklist')

@section('content')
<div class="checklist-container" role="main">
    <!-- Header Section -->
    <header class="checklist-header">
        <div class="header-content">
            <div class="page-title">
                <h1>Incident Checklist</h1>
                <p>Create and manage custom inspection checklists for incident reporting</p>
            </div>
            <div class="header-actions">
                <div class="search-container">
                    <div class="search-input-wrapper">
                        <svg class="search-icon" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                            <circle cx="11" cy="11" r="8"></circle>
                            <path d="m21 21-4.35-4.35"></path>
                        </svg>
                        <input type="text" class="search-input" placeholder="Search checklists..." id="searchInput" aria-label="Search checklists" autocomplete="off">
                    </div>
                </div>
                <div class="action-buttons">
                    <button class="btn-primary" data-bs-toggle="modal" data-bs-target="#add-checklist" aria-label="Create new checklist">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                            <line x1="12" y1="5" x2="12" y2="19"></line>
                            <line x1="5" y1="12" x2="19" y2="12"></line>
                        </svg>
                        Create New Checklist
                    </button>
                </div>
            </div>
        </div>
    </header>



    
    
    <!-- Tab Section -->
    <div class="tab-section">
        <div class="tab-container">
            <!-- Tab Navigation -->
            <nav class="tab-navigation" role="navigation" aria-label="Checklist tabs">
                <ul class="tab-list" role="tablist">
                    <li class="tab-item">
                        <button class="tab-button active" data-bs-toggle="pill" data-bs-target="#custom-checklist" role="tab" aria-selected="true" aria-controls="custom-checklist" id="custom-tab">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                                <path d="M9 11H5a2 2 0 0 0-2 2v3c0 1.1.9 2 2 2h4m0-7v7m0-7h10a2 2 0 0 1 2 2v3c0 1.1-.9 2-2 2H9m0-7V9a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v2"></path>
                            </svg>
                            Custom Inspection Checklist
                        </button>
                    </li>
                    <li class="tab-item">
                        <button class="tab-button" data-bs-toggle="modal" data-bs-target="#library-checklist" role="tab" aria-selected="false" aria-label="Open library checklist modal">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                                <path d="M4 19.5A2.5 2.5 0 0 1 6.5 17H20"></path>
                                <path d="M6.5 2H20v20H6.5A2.5 2.5 0 0 1 4 19.5v-15A2.5 2.5 0 0 1 6.5 2z"></path>
                            </svg>
                            Library Checklist
                        </button>
                    </li>
                </ul>
            </nav>
            
            <!-- Tab Content -->
            <div class="tab-content">
                <div id="custom-checklist" class="tab-pane active" role="tabpanel" aria-labelledby="custom-tab">
                    <div class="tab-content-body">
                        <div class="empty-state" role="status" aria-live="polite">
                            <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                                <path d="M9 11H5a2 2 0 0 0-2 2v3c0 1.1.9 2 2 2h4m0-7v7m0-7h10a2 2 0 0 1 2 2v3c0 1.1-.9 2-2 2H9m0-7V9a2 2 0 0 1 2-2h2a2 2 0 0 1 2 2v2"></path>
                            </svg>
                            <h3>No Custom Checklists</h3>
                            <p>Create your first custom inspection checklist to get started with incident reporting.</p>
                            <button class="btn-primary" data-bs-toggle="modal" data-bs-target="#add-checklist" aria-label="Create your first checklist">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                                    <line x1="12" y1="5" x2="12" y2="19"></line>
                                    <line x1="5" y1="12" x2="19" y2="12"></line>
                                </svg>
                                Create Your First Checklist
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Help Text -->
            <aside class="help-section" role="complementary" aria-label="Help information">
                <div class="help-content">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                        <circle cx="12" cy="12" r="10"></circle>
                        <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path>
                        <line x1="12" y1="17" x2="12.01" y2="17"></line>
                    </svg>
                    <p>Let our team help you convert your paper form to digital.</p>
                </div>
            </aside>
        </div>
    </div>
</div>
<!-- Custom Inspection Checklist Modal -->
<div class="modal fade" id="add-checklist" tabindex="-1" aria-labelledby="addChecklistModalLabel" aria-hidden="true" role="dialog">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addChecklistModalLabel">Create New Checklist</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close modal"></button>
            </div>
            <div class="modal-body">
                <form id="checklistForm" role="form" novalidate>
                    <div class="form-group">
                        <label for="checklistTitle" class="form-label">Checklist Title <span class="sr-only">(required)</span></label>
                        <input type="text" class="form-control" id="checklistTitle" placeholder="Enter checklist title" required aria-required="true" aria-describedby="titleHelp">
                        <div id="titleHelp" class="sr-only">Enter a descriptive title for your checklist</div>
                    </div>
                    <div class="form-group">
                        <label for="checklistDescription" class="form-label">Checklist Description</label>
                        <textarea class="form-control" id="checklistDescription" rows="4" placeholder="Enter checklist description" aria-describedby="descriptionHelp"></textarea>
                        <div id="descriptionHelp" class="sr-only">Optional description to help identify this checklist</div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-cancel" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn-save" onclick="saveChecklist()" aria-describedby="saveHelp">Save Checklist</button>
                <div id="saveHelp" class="sr-only">Save the checklist and close this modal</div>
            </div>
        </div>
    </div>
</div>
<!-- Library Checklist Modal -->
<div class="modal fade" id="library-checklist" tabindex="-1" aria-labelledby="libraryChecklistModalLabel" aria-hidden="true" role="dialog">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="libraryChecklistModalLabel">Library Checklist</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close modal"></button>
            </div>
            <div class="modal-body">
                <div class="library-content">
                    <div class="library-info">
                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                            <path d="M4 19.5A2.5 2.5 0 0 1 6.5 17H20"></path>
                            <path d="M6.5 2H20v20H6.5A2.5 2.5 0 0 1 4 19.5v-15A2.5 2.5 0 0 1 6.5 2z"></path>
                        </svg>
                        <h4>Pre-built Checklist Templates</h4>
                        <p>Choose from our library of professionally designed inspection checklists for various industries and use cases.</p>
                    </div>
                    <div class="library-features" role="list" aria-label="Library features">
                        <div class="feature-item" role="listitem">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                                <polyline points="20,6 9,17 4,12"></polyline>
                            </svg>
                            <span>Industry-specific templates</span>
                        </div>
                        <div class="feature-item" role="listitem">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                                <polyline points="20,6 9,17 4,12"></polyline>
                            </svg>
                            <span>Compliance-ready formats</span>
                        </div>
                        <div class="feature-item" role="listitem">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                                <polyline points="20,6 9,17 4,12"></polyline>
                            </svg>
                            <span>Customizable to your needs</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-cancel" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn-primary" onclick="browseLibrary()" aria-describedby="browseHelp">Browse Library</button>
                <div id="browseHelp" class="sr-only">Open the library browser to view available templates</div>
            </div>
        </div>
    </div>
</div>
<!-- Step 3: Inspection Summary -->
<div class="form-section" id="step3-summary" style="display: none;">
    <div class="form-header">
        <h2>3. Inspection Summary</h2>
        <p>This is Step 3. (Dummy content for now)</p>
        <div style="padding: 40px 0; text-align: center; font-size: 22px; color: #0055a5;">
            <strong>Step 3 Dummy Text: Inspection Summary goes here.</strong>
        </div>
        <button type="button" class="btn-cancel" onclick="goToStep2()">Back to Step 2</button>
    </div>
</div>
<div class="form-actions">
    <button type="button" class="btn-next" onclick="goToStep3()">
        Next Step
    </button>
</div>
<script>
(function() {
    'use strict';
    
    // Configuration object
    const CONFIG = {
        selectors: {
            searchInput: '#searchInput',
            checklistForm: '#checklistForm',
            checklistTitle: '#checklistTitle',
            checklistDescription: '#checklistDescription',
            addChecklistModal: '#add-checklist',
            libraryChecklistModal: '#library-checklist',
            doInspectionContainer: '#do-inspection-container',
            step3Summary: '#step3-summary'
        },
        messages: {
            titleRequired: 'Please enter a checklist title',
            checklistCreated: 'Checklist created successfully!',
            libraryComingSoon: 'Library browser coming soon!',
            pageLoaded: 'Incident Checklist page loaded'
        },
        timing: {
            notificationTimeout: 5000
        }
    };
    
    // DOM elements cache
    let elements = {};
    
    // Initialize DOM elements
    function initElements() {
        elements = {
            searchInput: document.querySelector(CONFIG.selectors.searchInput),
            checklistForm: document.querySelector(CONFIG.selectors.checklistForm),
            checklistTitle: document.querySelector(CONFIG.selectors.checklistTitle),
            checklistDescription: document.querySelector(CONFIG.selectors.checklistDescription),
            addChecklistModal: document.querySelector(CONFIG.selectors.addChecklistModal),
            libraryChecklistModal: document.querySelector(CONFIG.selectors.libraryChecklistModal),
            doInspectionContainer: document.querySelector(CONFIG.selectors.doInspectionContainer),
            step3Summary: document.querySelector(CONFIG.selectors.step3Summary)
        };
    }
    
    // Search functionality
    function initSearch() {
        if (elements.searchInput) {
            elements.searchInput.addEventListener('input', function() {
                const searchTerm = this.value.toLowerCase();
                console.log('Searching for:', searchTerm);
                // Add search functionality here
            });
        }
    }
    
    // Save checklist functionality
    function saveChecklist() {
        const title = elements.checklistTitle?.value || '';
        const description = elements.checklistDescription?.value || '';
        
        if (!title.trim()) {
            showNotification(CONFIG.messages.titleRequired, 'warning');
            return;
        }
        
        console.log('Saving checklist:', { title, description });
        
        // Close modal
        const modal = bootstrap.Modal.getInstance(elements.addChecklistModal);
        if (modal) {
            modal.hide();
        }
        
        // Show success notification
        showNotification(CONFIG.messages.checklistCreated, 'success');
        
        // Reset form
        if (elements.checklistForm) {
            elements.checklistForm.reset();
        }
    }
    
    // Browse library functionality
    function browseLibrary() {
        console.log('Opening library browser');
        showNotification(CONFIG.messages.libraryComingSoon, 'info');
    }
    
    // Notification system
    function showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
        notification.style.cssText = `top: 20px; right: 20px; z-index: ${CONFIG.timing.notificationTimeout}; min-width: 300px;`;
        notification.innerHTML = `
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        `;
        
        document.body.appendChild(notification);
        
        setTimeout(() => {
            if (notification.parentNode) {
                notification.remove();
            }
        }, CONFIG.timing.notificationTimeout);
    }
    
    // Step navigation functions
    function goToStep3() {
        // Add your Step 2 validation here if needed
        // For now, just hide Step 2 and show Step 3
        if (elements.doInspectionContainer) {
            elements.doInspectionContainer.style.display = 'none';
        }
        if (elements.step3Summary) {
            elements.step3Summary.style.display = 'block';
        }
        updateStepIndicator(3);
    }
    
    
    function goToStep2() {
        // Go back to Step 2 from Step 3
        if (elements.step3Summary) {
            elements.step3Summary.style.display = 'none';
        }
        if (elements.doInspectionContainer) {
            elements.doInspectionContainer.style.display = 'block';
        }
        updateStepIndicator(2);
    }
    
    function updateStepIndicator(step) {
        // Add step indicator update logic here
        console.log(`Updated to step ${step}`);
    }
    
    // Initialize page
    function init() {
        initElements();
        initSearch();
        
        console.log(CONFIG.messages.pageLoaded);
        
        // Add focus to search input on page load
        if (elements.searchInput) {
            elements.searchInput.focus();
        }
    }
    
    // Event listeners
    document.addEventListener('DOMContentLoaded', init);
    
    // Make functions globally accessible
    window.saveChecklist = saveChecklist;
    window.browseLibrary = browseLibrary;
    window.goToStep3 = goToStep3;
    window.goToStep2 = goToStep2;
    window.updateStepIndicator = updateStepIndicator;
    
})();
</script>
<style>
/* Import Google Fonts for better typography */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* CSS Variables for consistent theming */
:root {
    --primary-color: #0055a5;
    --primary-hover: #003d7a;
    --secondary-color: #3b82f6;
    --secondary-hover: #2563eb;
    --success-color: #10b981;
    --success-hover: #059669;
    --warning-color: #f59e0b;
    --warning-hover: #d97706;
    --text-primary: #0f172a;
    --text-secondary: #374151;
    --text-muted: #64748b;
    --text-light: #9ca3af;
    --bg-primary: #f8fafc;
    --bg-secondary: #f1f5f9;
    --bg-white: #ffffff;
    --bg-hover: rgba(59, 130, 246, 0.05);
    --border-color: #e2e8f0;
    --border-light: #d1d5db;
    --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
    --shadow-md: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    --shadow-lg: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    --radius-sm: 0;
    --radius-md: 0;
    --radius-lg: 0;
    --transition-base: all 0.2s ease;
    --transition-slow: all 0.3s ease;
    --font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    --z-index-modal: 1050;
    --z-index-notification: 9999;
}

/* Main Container */
.checklist-container {
    min-height: 100vh;
}

/* Header Section */
.checklist-header {
    background: var(--bg-white);
    border: 1px solid var(--border-color);
    box-shadow: var(--shadow-md);
    border-radius: var(--radius-sm);
    margin-bottom: 24px;
}

.header-content {
    padding: 32px;
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: 24px;
}

.page-title h1 {
    color: var(--text-primary);
    font-weight: 700;
    font-size: 32px;
    line-height: 1.2;
    letter-spacing: -0.025em;
    margin: 0 0 8px 0;
}

.page-title p {
    color: var(--text-muted);
    font-weight: 400;
    font-size: 16px;
    line-height: 1.5;
    margin: 0;
}

.header-actions {
    display: flex;
    align-items: center;
    gap: 20px;
    flex-wrap: wrap;
}

/* Search Container */
.search-container {
    position: relative;
}

.search-input-wrapper {
    position: relative;
    display: flex;
    align-items: center;
}

.search-icon {
    position: absolute;
    left: 16px;
    z-index: 2;
    color: var(--text-muted);
    width: 16px;
    height: 16px;
}

.search-input {
    padding: 12px 16px 12px 44px;
    border: 1px solid var(--border-light);
    border-radius: var(--radius-sm);
    height: 44px;
    width: 300px;
    font-size: 14px;
    font-weight: 400;
    color: var(--text-secondary);
    background: var(--bg-white);
    transition: var(--transition-base);
}

.search-input:focus {
    outline: none;
    border-color: var(--secondary-color);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.search-input::placeholder {
    color: var(--text-light);
}

/* Action Buttons */
.action-buttons {
    display: flex;
    gap: 12px;
    align-items: center;
}

.btn-primary {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border: none;
    border-radius: var(--radius-sm);
    font-size: 14px;
    font-weight: 500;
    text-decoration: none;
    transition: var(--transition-base);
    cursor: pointer;
    box-shadow: var(--shadow-sm);
    background: var(--primary-color);
    color: var(--bg-white);
}

.btn-primary:hover {
    background: var(--primary-hover);
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
    color: var(--bg-white);
}

/* Tab Section */
.tab-section {
    background: var(--bg-white);
    border: 1px solid var(--border-color);
    box-shadow: var(--shadow-md);
    border-radius: var(--radius-sm);
    overflow: hidden;
}

.tab-container {
    padding: 0;
}

/* Tab Navigation */
.tab-navigation {
    background: linear-gradient(135deg, var(--bg-primary) 0%, var(--bg-secondary) 100%);
    border-bottom: 1px solid var(--border-color);
    padding: 0;
}

.tab-list {
    display: flex;
    list-style: none;
    margin: 0;
    padding: 0;
}

.tab-item {
    flex: 1;
}

.tab-button {
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 16px 24px;
    border: none;
    background: transparent;
    color: var(--text-muted);
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
    border-bottom: 3px solid transparent;
}

.tab-button:hover {
    background: var(--bg-hover);
    color: var(--secondary-color);
}

.tab-button.active {
    background: var(--bg-white);
    color: var(--secondary-color);
    border-bottom-color: var(--secondary-color);
    box-shadow: 0 -2px 4px rgba(0, 0, 0, 0.05);
}

.tab-button svg {
    flex-shrink: 0;
}

/* Tab Content */
.tab-content {
    min-height: 400px;
}

.tab-content-body {
    padding: 48px 24px;
}

/* Empty State */
.empty-state {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;
    gap: 24px;
}

.empty-state svg {
    color: var(--text-light);
}

.empty-state h3 {
    color: var(--text-secondary);
    font-weight: 600;
    font-size: 20px;
    margin: 0;
}

.empty-state p {
    color: var(--text-muted);
    font-weight: 400;
    font-size: 16px;
    margin: 0;
    max-width: 400px;
}

/* Help Section */
.help-section {
    background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
    border-top: 1px solid var(--border-color);
    padding: 20px 24px;
}

.help-content {
    display: flex;
    align-items: center;
    gap: 12px;
    color: #0369a1;
    font-size: 14px;
    font-weight: 400;
}

.help-content svg {
    flex-shrink: 0;
    color: #0284c7;
}

/* Modal Styling */
.modal-content {
    border: 1px solid var(--border-color);
    border-radius: var(--radius-sm);
    box-shadow: var(--shadow-lg);
}

.modal-header {
    background: linear-gradient(135deg, var(--bg-primary) 0%, var(--bg-secondary) 100%);
    border-bottom: 1px solid var(--border-color);
    padding: 20px 24px;
}

.modal-title {
    color: var(--text-primary);
    font-weight: 600;
    font-size: 18px;
    margin: 0;
}

.btn-close {
    background: none;
    border: none;
    font-size: 24px;
    color: var(--text-muted);
    opacity: 1;
    transition: var(--transition-base);
}

.btn-close:hover {
    color: var(--text-secondary);
    transform: scale(1.1);
}

.modal-body {
    padding: 24px;
}

/* Form Styling */
.form-group {
    margin-bottom: 20px;
}

.form-label {
    display: block;
    color: var(--text-secondary);
    font-weight: 500;
    font-size: 14px;
    margin-bottom: 8px;
}

.form-control {
    width: 100%;
    padding: 12px 16px;
    border: 1px solid var(--border-light);
    border-radius: var(--radius-sm);
    font-size: 14px;
    font-weight: 400;
    color: var(--text-secondary);
    background: var(--bg-white);
    transition: var(--transition-base);
}

.form-control:focus {
    outline: none;
    border-color: var(--secondary-color);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.form-control::placeholder {
    color: var(--text-light);
}

textarea.form-control {
    resize: vertical;
    min-height: 100px;
}

/* Library Content */
.library-content {
    text-align: center;
    padding: 20px 0;
}

.library-info {
    margin-bottom: 32px;
}

.library-info svg {
    color: var(--secondary-color);
    margin-bottom: 16px;
}

.library-info h4 {
    color: var(--text-primary);
    font-weight: 600;
    font-size: 20px;
    margin: 0 0 8px 0;
}

.library-info p {
    color: var(--text-muted);
    font-weight: 400;
    font-size: 16px;
    margin: 0;
    max-width: 500px;
    margin-left: auto;
    margin-right: auto;
}

.library-features {
    display: flex;
    flex-direction: column;
    gap: 12px;
    max-width: 400px;
    margin: 0 auto;
}

.feature-item {
    display: flex;
    align-items: center;
    gap: 12px;
    color: var(--text-secondary);
    font-size: 14px;
    font-weight: 400;
}

.feature-item svg {
    color: var(--success-color);
    flex-shrink: 0;
}

/* Modal Footer */
.modal-footer {
    background: var(--bg-primary);
    border-top: 1px solid var(--border-color);
    padding: 16px 24px;
    display: flex;
    gap: 12px;
    justify-content: flex-end;
}

.btn-cancel, .btn-save {
    padding: 10px 20px;
    border: none;
    border-radius: var(--radius-sm);
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
}

.btn-cancel {
    background: #f3f4f6;
    color: var(--text-secondary);
}

.btn-cancel:hover {
    background: #e5e7eb;
    color: var(--text-primary);
}

.btn-save {
    background: linear-gradient(135deg, var(--secondary-color) 0%, #1d4ed8 100%);
    color: var(--bg-white);
}

.btn-save:hover {
    background: linear-gradient(135deg, var(--secondary-hover) 0%, #1e40af 100%);
    transform: translateY(-1px);
    box-shadow: var(--shadow-sm);
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 1200px) {
    .checklist-container {
        padding: 20px;
    }
    
    .header-content {
        padding: 24px;
    }
    
    .search-input {
        width: 250px;
    }
    
    .tab-content-body {
        padding: 40px 20px;
    }
}

@media (max-width: 992px) {
    .checklist-container {
        padding: 16px;
    }
    
    .header-content {
        padding: 20px;
        flex-direction: column;
        align-items: stretch;
        gap: 20px;
    }
    
    .page-title h1 {
        font-size: 28px;
    }
    
    .page-title p {
        font-size: 15px;
    }
    
    .header-actions {
        justify-content: space-between;
        flex-wrap: wrap;
        gap: 16px;
    }
    
    .search-input {
        width: 100%;
        max-width: 300px;
    }
    
    .action-buttons {
        flex-wrap: wrap;
    }
    
    .tab-button {
        padding: 14px 20px;
        font-size: 14px;
    }
    
    .tab-content-body {
        padding: 36px 20px;
    }
    
    .empty-state h3 {
        font-size: 19px;
    }
    
    .empty-state p {
        font-size: 15px;
    }
    
    .modal-dialog {
        margin: 1rem;
        max-width: calc(100% - 2rem);
    }
    
    .modal-body {
        padding: 20px;
    }
    
    .modal-footer {
        padding: 16px 20px;
        flex-direction: column;
        gap: 8px;
    }
    
    .btn-cancel, .btn-save {
        width: 100%;
        justify-content: center;
    }
}

@media (max-width: 768px) {
    .checklist-container {
        padding: 0;
    }
    
    .checklist-header {
        margin: 0 16px 16px 16px;
    }
    
    .header-content {
        padding: 16px;
        gap: 16px;
    }
    
    .page-title h1 {
        font-size: 24px;
        margin-bottom: 6px;
    }
    
    .page-title p {
        font-size: 14px;
    }
    
    .header-actions {
        flex-direction: column;
        align-items: stretch;
        gap: 12px;
    }
    
    .search-container {
        width: 100%;
    }
    
    .search-input {
        width: 100%;
        padding: 12px 16px 12px 44px;
        font-size: 16px;
        min-height: 48px;
    }
    
    .action-buttons {
        justify-content: center;
    }
    
    .btn-primary {
        flex: 1;
        justify-content: center;
        min-width: 140px;
        padding: 12px 20px;
        font-size: 14px;
        min-height: 48px;
    }
    
    .tab-section {
        margin: 0 16px 16px 16px;
    }
    
    .tab-button {
        padding: 12px 16px;
        font-size: 13px;
        min-height: 48px;
    }
    
    .tab-content-body {
        padding: 32px 16px;
    }
    
    .empty-state {
        gap: 20px;
    }
    
    .empty-state svg {
        width: 56px;
        height: 56px;
    }
    
    .empty-state h3 {
        font-size: 18px;
    }
    
    .empty-state p {
        font-size: 14px;
        max-width: 350px;
    }
    
    .empty-state .btn-primary {
        padding: 12px 20px;
        font-size: 14px;
        min-height: 48px;
    }
    
    .help-section {
        padding: 16px;
    }
    
    .help-content {
        font-size: 13px;
        gap: 10px;
    }
    
    .modal-dialog {
        margin: 0.5rem;
        max-width: calc(100% - 1rem);
    }
    
    .modal-header {
        padding: 16px;
    }
    
    .modal-title {
        font-size: 16px;
    }
    
    .modal-body {
        padding: 16px;
    }
    
    .form-group {
        margin-bottom: 16px;
    }
    
    .form-label {
        font-size: 13px;
        margin-bottom: 6px;
    }
    
    .form-control {
        padding: 12px 14px;
        font-size: 16px;
        min-height: 48px;
    }
    
    textarea.form-control {
        min-height: 100px;
    }
    
    .modal-footer {
        padding: 12px 16px;
        flex-direction: column;
        gap: 8px;
    }
    
    .btn-cancel, .btn-save {
        width: 100%;
        justify-content: center;
        padding: 12px 16px;
        font-size: 14px;
        min-height: 48px;
    }
    
    .library-content {
        padding: 16px 0;
    }
    
    .library-info {
        margin-bottom: 24px;
    }
    
    .library-info svg {
        width: 40px;
        height: 40px;
        margin-bottom: 12px;
    }
    
    .library-info h4 {
        font-size: 18px;
    }
    
    .library-info p {
        font-size: 14px;
        max-width: 400px;
    }
    
    .library-features {
        align-items: flex-start;
        gap: 10px;
    }
    
    .feature-item {
        font-size: 13px;
        gap: 10px;
    }
}

@media (max-width: 576px) {
    .checklist-container {
        padding: 0;
    }
    
    .checklist-header {
        margin: 0 12px 12px 12px;
    }
    
    .header-content {
        padding: 12px;
        gap: 12px;
    }
    
    .page-title h1 {
        font-size: 20px;
        margin-bottom: 4px;
    }
    
    .page-title p {
        font-size: 13px;
    }
    
    .search-input {
        padding: 10px 14px 10px 40px;
        font-size: 16px;
        min-height: 44px;
    }
    
    .search-icon {
        left: 14px;
        width: 14px;
        height: 14px;
    }
    
    .btn-primary {
        padding: 10px 16px;
        font-size: 13px;
        min-height: 44px;
    }
    
    .tab-section {
        margin: 0 12px 12px 12px;
    }
    
    .tab-button {
        padding: 10px 12px;
        font-size: 12px;
        min-height: 44px;
    }
    
    .tab-content-body {
        padding: 24px 12px;
    }
    
    .empty-state {
        gap: 16px;
    }
    
    .empty-state svg {
        width: 48px;
        height: 48px;
    }
    
    .empty-state h3 {
        font-size: 16px;
    }
    
    .empty-state p {
        font-size: 13px;
        max-width: 300px;
    }
    
    .empty-state .btn-primary {
        padding: 10px 16px;
        font-size: 13px;
        min-height: 44px;
    }
    
    .help-section {
        padding: 12px;
    }
    
    .help-content {
        font-size: 12px;
        gap: 8px;
    }
    
    .help-content svg {
        width: 16px;
        height: 16px;
    }
    
    .modal-dialog {
        margin: 0.25rem;
        max-width: calc(100% - 0.5rem);
    }
    
    .modal-header {
        padding: 12px;
    }
    
    .modal-title {
        font-size: 15px;
    }
    
    .modal-body {
        padding: 12px;
    }
    
    .form-group {
        margin-bottom: 12px;
    }
    
    .form-label {
        font-size: 12px;
        margin-bottom: 4px;
    }
    
    .form-control {
        padding: 10px 12px;
        font-size: 16px;
        min-height: 44px;
    }
    
    textarea.form-control {
        min-height: 80px;
    }
    
    .modal-footer {
        padding: 10px 12px;
    }
    
    .btn-cancel, .btn-save {
        padding: 10px 12px;
        font-size: 13px;
        min-height: 44px;
    }
    
    .library-content {
        padding: 12px 0;
    }
    
    .library-info {
        margin-bottom: 20px;
    }
    
    .library-info svg {
        width: 36px;
        height: 36px;
        margin-bottom: 10px;
    }
    
    .library-info h4 {
        font-size: 16px;
    }
    
    .library-info p {
        font-size: 13px;
        max-width: 350px;
    }
    
    .library-features {
        gap: 8px;
    }
    
    .feature-item {
        font-size: 12px;
        gap: 8px;
    }
    
    .feature-item svg {
        width: 16px;
        height: 16px;
    }
}

@media (max-width: 480px) {
    .checklist-header {
        margin: 0 8px 8px 8px;
    }
    
    .header-content {
        padding: 10px;
        gap: 10px;
    }
    
    .page-title h1 {
        font-size: 18px;
        margin-bottom: 3px;
    }
    
    .page-title p {
        font-size: 12px;
    }
    
    .search-input {
        padding: 8px 12px 8px 36px;
        font-size: 16px;
        min-height: 40px;
    }
    
    .search-icon {
        left: 12px;
        width: 12px;
        height: 12px;
    }
    
    .btn-primary {
        padding: 8px 12px;
        font-size: 12px;
        min-height: 40px;
    }
    
    .tab-section {
        margin: 0 8px 8px 8px;
    }
    
    .tab-button {
        padding: 8px 10px;
        font-size: 11px;
        min-height: 40px;
    }
    
    .tab-content-body {
        padding: 20px 10px;
    }
    
    .empty-state {
        gap: 12px;
    }
    
    .empty-state svg {
        width: 40px;
        height: 40px;
    }
    
    .empty-state h3 {
        font-size: 15px;
    }
    
    .empty-state p {
        font-size: 12px;
        max-width: 250px;
    }
    
    .empty-state .btn-primary {
        padding: 8px 12px;
        font-size: 12px;
        min-height: 40px;
    }
    
    .help-section {
        padding: 10px;
    }
    
    .help-content {
        font-size: 11px;
        gap: 6px;
    }
    
    .help-content svg {
        width: 14px;
        height: 14px;
    }
    
    .modal-dialog {
        margin: 0.125rem;
        max-width: calc(100% - 0.25rem);
    }
    
    .modal-header {
        padding: 10px;
    }
    
    .modal-title {
        font-size: 14px;
    }
    
    .modal-body {
        padding: 10px;
    }
    
    .form-group {
        margin-bottom: 10px;
    }
    
    .form-label {
        font-size: 11px;
        margin-bottom: 3px;
    }
    
    .form-control {
        padding: 8px 10px;
        font-size: 16px;
        min-height: 40px;
    }
    
    textarea.form-control {
        min-height: 70px;
    }
    
    .modal-footer {
        padding: 8px 10px;
    }
    
    .btn-cancel, .btn-save {
        padding: 8px 10px;
        font-size: 12px;
        min-height: 40px;
    }
    
    .library-content {
        padding: 10px 0;
    }
    
    .library-info {
        margin-bottom: 16px;
    }
    
    .library-info svg {
        width: 32px;
        height: 32px;
        margin-bottom: 8px;
    }
    
    .library-info h4 {
        font-size: 14px;
    }
    
    .library-info p {
        font-size: 12px;
        max-width: 300px;
    }
    
    .library-features {
        gap: 6px;
    }
    
    .feature-item {
        font-size: 11px;
        gap: 6px;
    }
    
    .feature-item svg {
        width: 14px;
        height: 14px;
    }
}

@media (max-width: 360px) {
    .checklist-header {
        margin: 0 6px 6px 6px;
    }
    
    .header-content {
        padding: 8px;
        gap: 8px;
    }
    
    .page-title h1 {
        font-size: 16px;
        margin-bottom: 2px;
    }
    
    .page-title p {
        font-size: 11px;
    }
    
    .search-input {
        padding: 6px 10px 6px 32px;
        font-size: 16px;
        min-height: 36px;
    }
    
    .search-icon {
        left: 10px;
        width: 10px;
        height: 10px;
    }
    
    .btn-primary {
        padding: 6px 10px;
        font-size: 11px;
        min-height: 36px;
    }
    
    .tab-section {
        margin: 0 6px 6px 6px;
    }
    
    .tab-button {
        padding: 6px 8px;
        font-size: 10px;
        min-height: 36px;
    }
    
    .tab-content-body {
        padding: 16px 8px;
    }
    
    .empty-state {
        gap: 10px;
    }
    
    .empty-state svg {
        width: 36px;
        height: 36px;
    }
    
    .empty-state h3 {
        font-size: 14px;
    }
    
    .empty-state p {
        font-size: 11px;
        max-width: 200px;
    }
    
    .empty-state .btn-primary {
        padding: 6px 10px;
        font-size: 11px;
        min-height: 36px;
    }
    
    .help-section {
        padding: 8px;
    }
    
    .help-content {
        font-size: 10px;
        gap: 4px;
    }
    
    .help-content svg {
        width: 12px;
        height: 12px;
    }
    
    .modal-dialog {
        margin: 0.0625rem;
        max-width: calc(100% - 0.125rem);
    }
    
    .modal-header {
        padding: 8px;
    }
    
    .modal-title {
        font-size: 13px;
    }
    
    .modal-body {
        padding: 8px;
    }
    
    .form-group {
        margin-bottom: 8px;
    }
    
    .form-label {
        font-size: 10px;
        margin-bottom: 2px;
    }
    
    .form-control {
        padding: 6px 8px;
        font-size: 16px;
        min-height: 36px;
    }
    
    textarea.form-control {
        min-height: 60px;
    }
    
    .modal-footer {
        padding: 6px 8px;
    }
    
    .btn-cancel, .btn-save {
        padding: 6px 8px;
        font-size: 11px;
        min-height: 36px;
    }
    
    .library-content {
        padding: 8px 0;
    }
    
    .library-info {
        margin-bottom: 12px;
    }
    
    .library-info svg {
        width: 28px;
        height: 28px;
        margin-bottom: 6px;
    }
    
    .library-info h4 {
        font-size: 13px;
    }
    
    .library-info p {
        font-size: 11px;
        max-width: 250px;
    }
    
    .library-features {
        gap: 4px;
    }
    
    .feature-item {
        font-size: 10px;
        gap: 4px;
    }
    
    .feature-item svg {
        width: 12px;
        height: 12px;
    }
}

/* Accessibility and Focus Styles */
@media (prefers-reduced-motion: reduce) {
    * {
        transition: none !important;
        animation: none !important;
    }
}

.btn-primary:focus,
.search-input:focus,
.form-control:focus,
.tab-button:focus,
.btn-cancel:focus,
.btn-save:focus {
    outline: 2px solid var(--secondary-color);
    outline-offset: 2px;
}

/* Smooth animations */
* {
    transition: var(--transition-base);
}

/* Icon improvements */
.btn-primary svg,
.tab-button svg,
.feature-item svg {
    flex-shrink: 0;
}

/* Screen reader only content */
.sr-only {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}

/* Print styles */
@media print {
    .checklist-container {
        background: white !important;
        padding: 0 !important;
    }
    
    .checklist-header,
    .tab-section {
        box-shadow: none !important;
        border: 1px solid #000 !important;
    }
    
    .btn-primary,
    .btn-cancel,
    .btn-save {
        display: none !important;
    }
}

</style>
@endsection