@extends('welcome')

@section('title', 'Team KPI Reporting')

@section('styles')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Jost:wght@300;400;500;600;700&display=swap" rel="stylesheet">
@endsection

@section('content')
<div class="team-kpi-container">
    <!-- Header -->
    <div class="header-gradient">
        <div class="header-content">
            <div class="header-left">
                <a href="{{ url()->previous() }}" class="back-button">
                    <i class="fas fa-arrow-left"></i>
                </a>
                <h1 class="header-title">Team KPI Reporting</h1>
            </div>
            <div class="header-right">
                <button type="button" class="create-btn" id="refresh-btn">
                    <i class="fas fa-sync-alt"></i>
                    Refresh
                </button>
            </div>
        </div>
    </div>
    
    <div class="team-kpi-content">
        <div class="content-box">
            <div class="section-title">
                <h2>Inspections Completed by</h2>
            </div>
            
            <div class="top-buttons-row">
                <a href="{{ route('dashboard.team_kpi.supervisor') }}" class="big-button">
                    <i class="fas fa-user-tie"></i>
                    <span>Supervisor</span>
                </a>
                <a href="{{ route('dashboard.team_kpi.sites') }}" class="big-button">
                    <i class="fas fa-map-marker-alt"></i>
                    <span>Sites</span>
                </a>
            </div>
            
            <div class="single-button-row">
                <a href="{{ route('dashboard.team_kpi.employees') }}" class="single-button">
                    <i class="fas fa-users"></i>
                    <span>Employees</span>
                </a>
            </div>
            
            <hr class="divider">
            
            <div class="grid-buttons">
                <a href="{{ route('dashboard.team_kpi.inspections_closed') }}" class="grid-button">
                    <i class="fas fa-check-circle"></i>
                    <span>Inspections Closed in a Given Period</span>
                </a>
                <a href="{{ route('dashboard.team_kpi.inspections_opened') }}" class="grid-button">
                    <i class="fas fa-folder-open"></i>
                    <span>Inspections Opened in a Given Period</span>
                </a>
                <a href="{{ route('dashboard.team_kpi.employees_participated') }}" class="grid-button">
                    <i class="fas fa-user-check"></i>
                    <span>Employees Who Participated in Jobs in a Given Period</span>
                </a>
                <a href="{{ route('dashboard.team_kpi.employees_closed') }}" class="grid-button">
                    <i class="fas fa-user-clock"></i>
                    <span>Employees Who Closed Jobs in a Given Period</span>
                </a>
            </div>
            
            <div class="single-button-row" style="margin-top: 20px;">
                <a href="{{ route('dashboard.team_kpi.equipment_status') }}" class="single-button">
                    <i class="fas fa-cogs"></i>
                    <span>Equipment Status KPI</span>
                </a>
            </div>
        </div>
    </div>
</div>
<script>
    function toggleSidebar() {
        const sidebar = document.querySelector('.sidebar');
        sidebar.classList.toggle('collapsed');
    }
</script>

<style>
:root {
    --primary-color: #0055a5;
    --primary-hover: #003f7d;
    --text-primary: #212529;
    --text-secondary: #6c757d;
    --bg-light: #f8fafc;
    --bg-white: #ffffff;
    --border-light: #e2e8f0;
    --shadow-sm: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    --shadow-md: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    --radius-md: 0.375rem;
    --radius-lg: 0.5rem;
    --transition-base: all 0.15s ease-in-out;
    --font-family: 'Jost', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
}

.team-kpi-container {
    min-height: 100vh;
    background: var(--bg-light);
    font-family: var(--font-family);
    padding: 0;
    margin: 0;
}

.header-gradient {
    background: #0055a5;
    padding: 20px 0;
    box-shadow: 0 4px 12px rgba(0, 85, 165, 0.3);
}

.header-content {
    width: 100%;
    padding: 0 20px;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.header-left {
    display: flex;
    align-items: center;
    gap: 15px;
}

.back-button {
    color: white;
    font-size: 20px;
    text-decoration: none;
    padding: 8px;
    border-radius: 50%;
    transition: var(--transition-base);
}

.back-button:hover {
    background-color: rgba(255, 255, 255, 0.1);
}

.header-title {
    color: white;
    font-size: 28px;
    font-weight: 700;
    margin: 0;
}

.header-right {
    display: flex;
    gap: 15px;
}

.create-btn {
    background: white;
    color: var(--primary-color);
    border: none;
    padding: 12px 24px;
    border-radius: var(--radius-md);
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: var(--transition-base);
    box-shadow: var(--shadow-sm);
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

.create-btn:hover {
    background: rgba(255, 255, 255, 0.9);
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

.team-kpi-content {
    padding: 30px 20px;
}

.content-box {
    background: white;
    padding: 30px;
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-md);
    border: 1px solid var(--border-light);
}

.section-title {
    text-align: center;
    margin-bottom: 30px;
}

.section-title h2 {
    color: #025383;
    font-size: 24px;
    font-weight: 700;
    margin: 0;
}

.top-buttons-row {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 20px;
    margin-bottom: 20px;
}

.big-button {
    background: #0055a5;
    border-radius: var(--radius-md);
    padding: 30px 20px;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 12px;
    color: white;
    text-decoration: none;
    box-shadow: var(--shadow-md);
    transition: var(--transition-base);
}

.big-button:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 16px rgba(0, 85, 165, 0.3);
    background: #003f7d;
}

.big-button i {
    font-size: 32px;
}

.big-button span {
    font-size: 18px;
    font-weight: 600;
}

.single-button-row {
    margin-bottom: 30px;
}

.single-button {
    background: #0055a5;
    border-radius: var(--radius-md);
    padding: 30px 20px;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 12px;
    color: white;
    text-decoration: none;
    box-shadow: var(--shadow-md);
    transition: var(--transition-base);
    width: 100%;
}

.single-button:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 16px rgba(0, 85, 165, 0.3);
    background: #003f7d;
}

.single-button i {
    font-size: 32px;
}

.single-button span {
    font-size: 18px;
    font-weight: 600;
}

.divider {
    border: none;
    border-top: 2px solid #d1d5db;
    margin: 30px 0;
}

.grid-buttons {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 15px;
}

.grid-button {
    background: #0055a5;
    border-radius: var(--radius-md);
    padding: 25px 15px;
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
    color: white;
    text-decoration: none;
    box-shadow: var(--shadow-md);
    transition: var(--transition-base);
    text-align: center;
}

.grid-button:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 16px rgba(0, 85, 165, 0.3);
    background: #003f7d;
}

.grid-button i {
    font-size: 24px;
}

.grid-button span {
    font-size: 14px;
    font-weight: 600;
    line-height: 1.4;
}

@media (max-width: 768px) {
    .header-title {
        font-size: 24px;
    }
    
    .top-buttons-row,
    .grid-buttons {
        grid-template-columns: 1fr;
    }
    
    .content-box {
        padding: 20px;
    }
}

@media (max-width: 480px) {
    .header-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 15px;
    }
    
    .header-right {
        width: 100%;
    }
    
    .create-btn {
        width: 100%;
        justify-content: center;
    }
}
</style>
@endsection

