@extends('welcome')

@section('title', 'Account Deletion Request Details - Admin Panel')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-danger text-white d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">
                        <i class="fas fa-user-times me-2"></i>
                        Account Deletion Request Details
                    </h4>
                    <a href="{{ route('account-deletion.admin.index') }}" class="btn btn-light">
                        <i class="fas fa-arrow-left me-2"></i>Back to List
                    </a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show">
                            <i class="fas fa-check-circle me-2"></i>
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0">Request Information</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-sm-3"><strong>Request ID:</strong></div>
                                        <div class="col-sm-9">#{{ $request->id }}</div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-3"><strong>Email Address:</strong></div>
                                        <div class="col-sm-9">{{ $request->email }}</div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-3"><strong>Phone Number:</strong></div>
                                        <div class="col-sm-9">{{ $request->phone_number }}</div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-3"><strong>NRC ID:</strong></div>
                                        <div class="col-sm-9">{{ $request->nrc_id }}</div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-3"><strong>Status:</strong></div>
                                        <div class="col-sm-9">
                                            @if($request->status == 'pending')
                                                <span class="badge bg-warning fs-6">Pending</span>
                                            @elseif($request->status == 'approved')
                                                <span class="badge bg-success fs-6">Approved</span>
                                            @else
                                                <span class="badge bg-danger fs-6">Rejected</span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col-sm-3"><strong>Requested Date:</strong></div>
                                        <div class="col-sm-9">{{ $request->created_at->format('F d, Y \a\t H:i A') }}</div>
                                    </div>
                                    @if($request->processed_at)
                                        <div class="row mb-3">
                                            <div class="col-sm-3"><strong>Processed Date:</strong></div>
                                            <div class="col-sm-9">{{ $request->processed_at->format('F d, Y \a\t H:i A') }}</div>
                                        </div>
                                    @endif
                                    @if($request->processedBy)
                                        <div class="row mb-3">
                                            <div class="col-sm-3"><strong>Processed By:</strong></div>
                                            <div class="col-sm-9">{{ $request->processedBy->name }}</div>
                                        </div>
                                    @endif
                                    @if($request->reason)
                                        <div class="row mb-3">
                                            <div class="col-sm-3"><strong>Reason:</strong></div>
                                            <div class="col-sm-9">
                                                <div class="bg-light p-3 rounded">
                                                    {{ $request->reason }}
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                    @if($request->admin_notes)
                                        <div class="row mb-3">
                                            <div class="col-sm-3"><strong>Admin Notes:</strong></div>
                                            <div class="col-sm-9">
                                                <div class="bg-light p-3 rounded">
                                                    {{ $request->admin_notes }}
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            @if($request->status == 'pending')
                                <div class="card">
                                    <div class="card-header bg-warning text-dark">
                                        <h5 class="mb-0">Actions</h5>
                                    </div>
                                    <div class="card-body">
                                        <button type="button" 
                                                class="btn btn-success w-100 mb-3" 
                                                data-bs-toggle="modal" 
                                                data-bs-target="#approveModal">
                                            <i class="fas fa-check me-2"></i>Approve Request
                                        </button>
                                        <button type="button" 
                                                class="btn btn-danger w-100" 
                                                data-bs-toggle="modal" 
                                                data-bs-target="#rejectModal">
                                            <i class="fas fa-times me-2"></i>Reject Request
                                        </button>
                                    </div>
                                </div>
                            @else
                                <div class="card">
                                    <div class="card-header bg-info text-white">
                                        <h5 class="mb-0">Request Status</h5>
                                    </div>
                                    <div class="card-body text-center">
                                        @if($request->status == 'approved')
                                            <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                                            <p class="text-success fw-bold">This request has been approved</p>
                                        @else
                                            <i class="fas fa-times-circle fa-3x text-danger mb-3"></i>
                                            <p class="text-danger fw-bold">This request has been rejected</p>
                                        @endif
                                    </div>
                                </div>
                            @endif

                            <div class="card mt-3">
                                <div class="card-header">
                                    <h5 class="mb-0">Quick Actions</h5>
                                </div>
                                <div class="card-body">
                                    <a href="mailto:{{ $request->email }}" class="btn btn-outline-primary w-100 mb-2">
                                        <i class="fas fa-envelope me-2"></i>Send Email
                                    </a>
                                    <a href="tel:{{ $request->phone_number }}" class="btn btn-outline-success w-100">
                                        <i class="fas fa-phone me-2"></i>Call User
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Approve Modal -->
<div class="modal fade" id="approveModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">Approve Deletion Request</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('account-deletion.admin.approve', $request->id) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <p>Are you sure you want to approve this account deletion request?</p>
                    <div class="mb-3">
                        <label for="admin_notes_approve" class="form-label">Admin Notes (Optional)</label>
                        <textarea class="form-control" 
                                  id="admin_notes_approve" 
                                  name="admin_notes" 
                                  rows="3" 
                                  placeholder="Add any notes about this approval"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Approve Request</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title">Reject Deletion Request</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('account-deletion.admin.reject', $request->id) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <p>Are you sure you want to reject this account deletion request?</p>
                    <div class="mb-3">
                        <label for="admin_notes_reject" class="form-label">Reason for Rejection *</label>
                        <textarea class="form-control @error('admin_notes') is-invalid @enderror" 
                                  id="admin_notes_reject" 
                                  name="admin_notes" 
                                  rows="3" 
                                  placeholder="Please provide a reason for rejection"
                                  required></textarea>
                        @error('admin_notes')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Reject Request</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
