const mongoose = require('mongoose');

// MongoDB connection
const MONGODB_URI = 'mongodb://titandrillingadminuser:mrdThsSnATwD231hbOPmnhj@168.231.113.219:27017/titan_drilling?authSource=admin';

async function testCustomChecklists() {
  try {
    console.log('🔌 Connecting to MongoDB...');
    await mongoose.connect(MONGODB_URI, {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });
    console.log('✅ Connected to MongoDB');

    const db = mongoose.connection.db;
    
    // List all collections
    const collections = await db.listCollections().toArray();
    console.log('📋 Available collections:', collections.map(c => c.name));
    
    // Check customchecklists collection
    const customChecklistsCollection = db.collection('customchecklists');
    const count = await customChecklistsCollection.countDocuments({});
    console.log('📊 Total documents in customchecklists:', count);
    
    if (count > 0) {
      const allDocs = await customChecklistsCollection.find({}).toArray();
      console.log('📋 All custom checklists:');
      allDocs.forEach((doc, index) => {
        console.log(`  ${index + 1}. ID: ${doc._id}, Title: ${doc.title}, Created: ${doc.createdAt}`);
      });
    }
    
    // Check if there are any documents with the test ID we created
    const testDoc = await customChecklistsCollection.findOne({ _id: 'test_custom_123' });
    if (testDoc) {
      console.log('✅ Found test document:', testDoc);
    } else {
      console.log('❌ Test document not found');
    }
    
  } catch (error) {
    console.error('❌ Error:', error);
  } finally {
    await mongoose.disconnect();
    console.log('🔌 Disconnected from MongoDB');
  }
}

testCustomChecklists();
