# Incident Report MongoDB Migration

## Overview
This document outlines the migration of Incident Report functionality from Firebase to MongoDB, including file storage on the backend server.

## Backend Changes

### 1. GlobalIncidentReportHandle.js
- **Port**: 5007
- **Database**: MongoDB (titan_drilling)
- **Collection**: IncidentReports
- **File Storage**: `/root/node-mongo-api/uploads/documents/IncidentReportsdocx/`

### 2. File Upload Configuration
- **PDF Storage**: `/root/node-mongo-api/uploads/documents/IncidentReportsdocx/`
- **Image Storage**: Same directory as PDFs
- **File Access URL**: `http://168.231.113.219:5007/uploads/documents/IncidentReportsdocx/{filename}`

### 3. API Endpoints

#### Core CRUD Operations
- `GET /incident-reports/:adminUid` - Get all reports for user
- `GET /incident-reports` - Get all reports (admin access)
- `GET /incident-reports/:adminUid/:reportId` - Get single report
- `POST /incident-reports` - Create new report
- `PUT /incident-reports/:adminUid/:reportId` - Update report
- `DELETE /incident-reports/:adminUid/:reportId` - Delete report
- `PATCH /incident-reports/:adminUid/:reportId/archive` - Archive/unarchive

#### File Upload Endpoints
- `POST /incident-reports/:adminUid/:reportId/upload-pdf` - Upload PDF
- `POST /incident-reports/:adminUid/:reportId/upload-images` - Upload images (up to 9)

#### Statistics
- `GET /incident-reports/stats/:adminUid` - Get report statistics

### 4. MongoDB Schema
```javascript
{
  _id: String, // Primary key
  id: String, // Same as _id for compatibility
  adminUid: String, // User who created the report
  incidentNumber: String, // Auto-generated (e.g., ZAM-KOB-INC-001)
  incidentDate: Date,
  incidentArea: String,
  severity: String,
  incidentCategory: String,
  country: String,
  project: String,
  selectedIncidents: Object, // Checkbox selections
  involvesEquipment: Boolean,
  vehicleId: String,
  vehicleName: String,
  personInvolved: String,
  coordinates: String,
  otherIncidentNote: String,
  createdAt: Date,
  isArchived: Boolean,
  pdfDownloadUrl: String, // Server URL to PDF
  step1: Object, // Original step 1 data
  step2: Object, // Step 2 data including images
  uploadTimestamp: Date
}
```

## Frontend Changes

### 1. CreateIncidentReport.js
- Removed Firebase database import
- Updated `generateIncidentNumber()` to use MongoDB API
- Incident number generation now queries MongoDB for existing reports

### 2. IncidentReportStep2.js
- Removed Firebase storage imports
- Updated `uploadImageToServer()` to use backend file upload
- Updated `saveReportToMongoDB()` to use MongoDB API
- Updated `generateReport()` to upload files to server and save to MongoDB

### 3. IncidentReport.js (Home Page)
- Already migrated to use MongoDB API endpoints
- Uses `http://168.231.113.219:5007` for all operations

## File Storage Structure

```
/root/node-mongo-api/uploads/documents/IncidentReportsdocx/
├── pdf-{timestamp}-{random}.pdf
├── images-{timestamp}-{random}.jpg
├── images-{timestamp}-{random}.png
└── ...
```

## Migration Benefits

1. **Centralized Storage**: All files stored on backend server
2. **Better Organization**: Structured file paths for easy management
3. **MongoDB Integration**: Consistent with other modules
4. **Scalability**: Better performance with MongoDB indexing
5. **Backup**: Easier to backup files and database together

## Deployment Steps

1. Ensure MongoDB is running on port 27017
2. Create upload directory: `mkdir -p /root/node-mongo-api/uploads/documents/IncidentReportsdocx`
3. Set proper permissions: `chmod 755 /root/node-mongo-api/uploads/documents/IncidentReportsdocx`
4. Start the Incident Report handler: `node GlobalIncidentReportHandle.js`
5. Update frontend to use new API endpoints

## Testing

1. Test incident report creation
2. Test PDF generation and upload
3. Test image upload (up to 9 images)
4. Test report viewing and archiving
5. Test permissions and filtering

## Notes

- All existing Firebase data needs to be migrated to MongoDB
- File URLs are now server-based instead of Firebase Storage URLs
- Incident number generation is now based on MongoDB queries
- No more Firebase dependencies in the frontend