# HSE Inspection MongoDB Migration - Complete Guide

## ✅ Migration Complete

The HSE Inspection module has been fully migrated from Firebase to MongoDB on port **5014**.

## 📊 Backend Setup

### Server Details
- **Port**: 5014
- **Collection**: `globalhseinspections`
- **Counter Collection**: `hsecounters`
- **Document Path**: `/root/node-mongo-api/uploads/documents/HSEinspectiondocx/{uid}/`

### Files Created/Modified
1. `backend/GlobalHSEInspectionHandler.js` - Main HSE backend handler
2. `backend/server.js` - Added HSE handler initialization
3. `backend/upload-to-server.sh` - Added HSE handler to upload script
4. `components/ConfigMongo/HSEInspectionMongoConfig.js` - Frontend API configuration

## 🚀 Deployment Steps

### 1. Upload Backend to Server
```bash
cd backend
./upload-to-server.sh
```

### 2. SSH to Server and Restart
```bash
ssh root@168.231.113.219
# Password: 5aXBS2f-y/vwM8#

cd /root/node-mongo-api
pm2 restart titan-drilling-api
pm2 logs titan-drilling-api
```

### 3. Verify Server is Running
```bash
curl http://168.231.113.219:5014/hse-inspections
# Should return: {"status":"OK","service":"HSE Inspection Handler","port":5014,...}
```

### 4. Test Counter Endpoint
```bash
curl http://168.231.113.219:5014/hse-inspections/counter/current
# Should return: {"success":true,"data":{"currentNumber":0,"nextNumber":"001",...}}
```

## 📱 Frontend Migration

### Files Migrated
1. ✅ `HSEInspectionHome.js` - Main listing screen
2. ✅ `Hsemodule43step1.js` - Step 1 (HSE Information)
3. ✅ `Hsemodule43step3.js` - Step 3 (Report Generation & PDF Upload)
4. ✅ `HSEselecteq.js` - Equipment selection

### Changes Made
- Removed all Firebase imports (`database`, `storage`, `auth`)
- Added MongoDB API imports (`HSEInspectionAPI`, `EquipmentAPI`, `MongoAPI`)
- Updated all data fetching to use MongoDB endpoints
- Enhanced error logging for debugging
- Migrated PDF upload to MongoDB backend
- Migrated report saving to MongoDB

## 🔐 Permissions

The HSE module uses the same permission system as Inspection Reports:

### Module Name: `hseInspection`

### Permissions:
- `view` - View all HSE inspections (filtered by country/project)
- `onlyMineView` - View only own HSE inspections
- `create` - Create new HSE inspections
- `update` - Update HSE inspections
- `delete` - Delete HSE inspections

### Example User Structure in MongoDB:
```javascript
{
  _id: "user123",
  fullName: "John Doe",
  countries: ["Zambia", "DRC"],
  projects: ["Kansanshi", "Kobold"],
  modules: [
    {
      module: "hseInspection",
      permissions: ["view", "create"]
    }
  ]
}
```

## 🐛 Troubleshooting

### If Reports Not Saving:

1. **Check Backend is Running**
   ```bash
   pm2 status
   # Should show titan-drilling-api is online
   ```

2. **Check Logs**
   ```bash
   pm2 logs titan-drilling-api --lines 100
   ```

3. **Test API Directly**
   ```bash
   # Test health check
   curl http://168.231.113.219:5014/hse-inspections
   
   # Test counter
   curl http://168.231.113.219:5014/hse-inspections/counter/current
   ```

4. **Check MongoDB Connection**
   - Server should log: `✅ MongoDB connected successfully for HSE Inspection Handler`

5. **Check Frontend Logs**
   - Open React Native debugger
   - Look for console.log messages:
     - `📤 Creating HSE Inspection:`
     - `📥 Response status:`
     - `📥 Response data:`
     - `✅ HSE Inspection Report saved to MongoDB:`

### Common Issues

**Error: "Failed to save report to MongoDB"**
- Backend server not running on port 5014
- MongoDB connection failed
- Network connectivity issue
- Check console logs for detailed error

**Error: "Failed to upload PDF"**
- File path permissions issue
- Directory `/root/node-mongo-api/uploads/documents/HSEinspectiondocx/` not created
- Multer upload failed

**Error: "Permission Denied"**
- User doesn't have `hseInspection` module in their permissions
- Check user document in MongoDB `globalusers` collection

## 📋 API Endpoints

### Health Check
`GET http://168.231.113.219:5014/hse-inspections`

### Counter Management
- `GET /hse-inspections/counter/current` - Get current counter
- `POST /hse-inspections/counter/increment` - Increment counter

### File Management
- `POST /hse-inspections/upload-pdf/:userId` - Upload PDF
- `POST /hse-inspections/upload-attachment/:userId` - Upload attachment
- `GET /hse-inspections/download-file/:userId/:fileName` - Download file

### Reports
- `GET /hse-inspections/all` - Get all inspections
- `GET /hse-inspections/:userId` - Get user's inspections
- `GET /hse-inspections/report/:reportId` - Get specific inspection
- `POST /hse-inspections` - Create inspection
- `PUT /hse-inspections/:userId/:reportId` - Update inspection
- `PUT /hse-inspections/:userId/:reportId/complete` - Complete inspection
- `DELETE /hse-inspections/:userId/:reportId` - Delete inspection

### Statistics & Search
- `GET /hse-inspections/:userId/stats` - Get statistics
- `GET /hse-inspections/:userId/search?q=query` - Search inspections

## 🎯 Next Steps

1. Upload backend files to server
2. Restart PM2
3. Verify backend is running
4. Test creating a new HSE inspection
5. Verify PDF generation and upload
6. Check MongoDB for saved data

## ✨ Benefits of MongoDB Migration

- ✅ Faster data retrieval with indexes
- ✅ Better query performance
- ✅ Structured schema validation
- ✅ Offline caching maintained
- ✅ Permission-based data filtering
- ✅ Centralized file storage on server
- ✅ Better error handling and logging

