#!/bin/bash

echo "🚀 Deploying All Notification Services to Server..."
echo ""

SERVER="root@168.231.113.219"
REMOTE_DIR="/root/node-mongo-api"

echo "📦 Uploading notification services..."

# Upload all notification services
scp -r EmailsandPushN/*.js $SERVER:$REMOTE_DIR/EmailsandPushN/

echo "✅ Files uploaded"
echo ""
echo "🔄 Restarting PM2..."

ssh $SERVER << 'EOF'
cd /root/node-mongo-api
pm2 restart titan-drilling-api
sleep 3
pm2 logs --lines 50
EOF

echo ""
echo "✅ Deployment complete!"
echo "🔗 Check notification services at:"
echo "   - http://168.231.113.219:5019/health (Inspection)"
echo "   - http://168.231.113.219:5020/health (DVIR)"
echo "   - http://168.231.113.219:5021/health (Incident)"
echo "   - http://168.231.113.219:5022/health (Request Maintenance)"
echo "   - http://168.231.113.219:5023/health (Job Card)"
echo "   - http://168.231.113.219:5024/health (Service Schedule)"
echo "   - http://168.231.113.219:5025/health (Fuel Log)"
echo "   - http://168.231.113.219:5026/health (Logbook)"
echo "   - http://168.231.113.219:5027/health (HR Application)"

