<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Job Card: {{ $workOrderData['title'] ?? 'Untitled' }}</title>
    <style>
        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            padding: 24px;
            font-size: 13px;
            background: #f8f9fa;
            color: #222;
        }
        .header, .section {
            border-radius: 8px;
            background: #fff;
            box-shadow: 0 1px 4px #e0e0e0;
            padding: 16px 20px;
            margin-bottom: 18px;
        }
        .header-table, .checklist-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        .header-table td {
            border: none;
            padding: 3px 0;
        }
        .checklist-table th, .checklist-table td {
            border: 1px solid #e0e0e0;
            padding: 7px 6px;
            text-align: left;
        }
        .title {
            text-align: center;
            font-weight: bold;
            font-size: 22px;
            margin: 24px 0 18px 0;
            color: #015185;
            letter-spacing: 1px;
        }
        .notes {
            font-size: 11px;
            margin-bottom: 10px;
            color: #888;
        }
        .checklist-table th {
            background-color: #015185;
            color: #fff;
            font-weight: 600;
            font-size: 14px;
        }
        .summary-section {
            margin-top: 24px;
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 1px 4px #e0e0e0;
            padding: 18px 20px;
        }
        .summary-section h3 {
            color: #015185;
            font-size: 16px;
            margin-bottom: 10px;
            border-bottom: 1.5px solid #e0e0e0;
            padding-bottom: 2px;
        }
        .summary-section p {
            margin: 5px 0;
        }
        .section strong {
            color: #015185;
        }
        .section label {
            color: #888;
            font-weight: 400;
        }
    </style>
</head>
<body>
    <div class="header">
        <table class="header-table">
            <tr>
                <td rowspan="5">
                    <img src="https://www.titanafricadrilling.com/wp-content/uploads/2022/10/titan-drlling_blue.png" alt="Logo" width="100">
                </td>
                <td><strong>Document Name:</strong> HSE-FOR-8.1.2 Job Card</td>
            </tr>
            <tr><td><strong>Document ID:</strong> HSE-029</td></tr>
            <tr><td><strong>Version Date:</strong> 05/08/2021</td></tr>
            <tr><td><strong>Version:</strong> 1</td></tr>
            <tr><td><strong>Approved:</strong> HSM</td></tr>
        </table>
    </div>

    <div class="title">JOB CARD</div>
    
    <div class="section">
        <div style="display: flex; flex-wrap: wrap; gap: 18px 32px;">
            <div><strong>NO:</strong> {{ $workOrderData['requestNumber'] ?? 'N/A' }}</div>
            <div><strong>DATE:</strong> {{ date('Y-m-d') }}</div>
            <div><strong>COUNTRY:</strong> {{ $workOrderData['country'] ?? 'N/A' }}</div>
            <div><strong>PROJECT:</strong> {{ $workOrderData['project'] ?? 'N/A' }}</div>
            <div><strong>EQUIPMENT:</strong> {{ $workOrderData['equipment_name'] ?? 'N/A' }}</div>
            <div><strong>CREATED AT:</strong> {{ $workOrderData['created_at'] ?? date('Y-m-d H:i:s') }}</div>
        </div>
    </div>

    <div class="summary-section">
        <h3>Job Card Details</h3>
        <div style="display: flex; flex-wrap: wrap; gap: 12px 32px;">
            <div><strong>Title:</strong> {{ $workOrderData['title'] ?? 'N/A' }}</div>
            <div><strong>Country:</strong> {{ $workOrderData['country'] ?? 'N/A' }}</div>
            <div><strong>Project:</strong> {{ $workOrderData['project'] ?? 'N/A' }}</div>
            <div><strong>Memo:</strong> {{ $workOrderData['memo'] ?? 'N/A' }}</div>
            <div><strong>Priority:</strong> {{ $workOrderData['priority'] ?? 'N/A' }}</div>
            <div><strong>Assigned To:</strong> 
                @if(isset($workOrderData['assign_to']) && is_array($workOrderData['assign_to']))
                    {{ implode(', ', array_column($workOrderData['assign_to'], 'name')) }}
                @else
                    None
                @endif
            </div>
            <div><strong>Start Date:</strong> {{ $workOrderData['start_date'] ?? 'N/A' }}</div>
            <div><strong>Due Date:</strong> {{ $workOrderData['due_date'] ?? 'N/A' }}</div>
            <div><strong>Job Card Type:</strong> {{ $workOrderData['work_order_type'] ?? 'N/A' }}</div>
            <div><strong>Estimated Cost:</strong> {{ $workOrderData['estimated_cost'] ?? 'N/A' }}</div>
            <div><strong>Estimated Labor Time:</strong> {{ $workOrderData['estimated_labor_time'] ?? 'N/A' }}</div>
        </div>
    </div>

    <div class="summary-section">
        <h3>Cost Details</h3>
        <div style="display: flex; flex-wrap: wrap; gap: 12px 32px;">
            <div><strong>Part & Material Cost:</strong> {{ $workOrderData['part_material_cost'] ?? '0.00' }}</div>
            <div><strong>Total Labor Cost:</strong> {{ $workOrderData['total_labor_cost'] ?? '0.00' }}</div>
            <div><strong>Additional Cost:</strong> {{ $workOrderData['additional_cost'] ?? '0.00' }}</div>
            <div><strong>Tax Amount:</strong> {{ $workOrderData['tax_amount'] ?? '0.00' }} ({{ $workOrderData['tax_percentage'] ?? '0' }}%)</div>
            <div><strong>Total WO Cost:</strong> {{ $workOrderData['total_wo_cost'] ?? '0.00' }}</div>
        </div>
    </div>

    @if(isset($workOrderData['items']) && is_array($workOrderData['items']))
        @php
            $tasks = array_filter($workOrderData['items'], function($item) {
                return isset($item['category']) && $item['category'] === 'Task';
            });
            $parts = array_filter($workOrderData['items'], function($item) {
                return isset($item['category']) && $item['category'] === 'Parts';
            });
            $labor = array_filter($workOrderData['items'], function($item) {
                return isset($item['category']) && $item['category'] === 'Labor';
            });
            $additionalCosts = array_filter($workOrderData['items'], function($item) {
                return isset($item['category']) && $item['category'] === 'Additional Cost';
            });
            $remarks = array_filter($workOrderData['items'], function($item) {
                return isset($item['category']) && $item['category'] === 'Remarks';
            });
        @endphp

        @if(count($tasks) > 0)
            <div class="summary-section">
                <h3>Tasks</h3>
                <table class="checklist-table">
                    <tr>
                        <th>#</th>
                        <th>Description</th>
                        <th>Type</th>
                        <th>Status</th>
                        <th>Note</th>
                    </tr>
                    @foreach($tasks as $index => $task)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $task['text'] ?? 'N/A' }}</td>
                            <td>{{ $task['type'] ?? 'N/A' }}</td>
                            <td>{{ $task['status'] ?? 'N/A' }}</td>
                            <td>{{ $task['note'] ?? 'N/A' }}</td>
                        </tr>
                    @endforeach
                </table>
            </div>
        @endif

        @if(count($labor) > 0)
            <div class="summary-section">
                <h3>Labor</h3>
                <table class="checklist-table">
                    <tr>
                        <th>#</th>
                        <th>Worker</th>
                        <th>Code</th>
                        <th>Rate</th>
                        <th>Time</th>
                    </tr>
                    @foreach($labor as $index => $item)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $item['worker'] ?? 'N/A' }}</td>
                            <td>{{ $item['code'] ?? 'N/A' }}</td>
                            <td>{{ $item['rate'] ?? 'N/A' }}</td>
                            <td>{{ $item['hours'] ?? '0' }}h {{ $item['minutes'] ?? '0' }}m</td>
                        </tr>
                    @endforeach
                </table>
            </div>
        @endif

        @if(count($parts) > 0)
            <div class="summary-section">
                <h3>Parts</h3>
                <table class="checklist-table">
                    <tr>
                        <th>#</th>
                        <th>Item No</th>
                        <th>Part No</th>
                        <th>Name</th>
                        <th>Quantity</th>
                        <th>Cost</th>
                    </tr>
                    @foreach($parts as $index => $item)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $item['itemNumber'] ?? 'N/A' }}</td>
                            <td>{{ $item['partNumber'] ?? 'N/A' }}</td>
                            <td>{{ $item['itemName'] ?? 'N/A' }}</td>
                            <td>{{ $item['quantity'] ?? '0' }} {{ $item['unit'] ?? 'N/A' }}</td>
                            <td>{{ $item['itemCost'] ?? 'N/A' }}</td>
                        </tr>
                    @endforeach
                </table>
            </div>
        @endif

        @if(count($additionalCosts) > 0)
            <div class="summary-section">
                <h3>Additional Costs</h3>
                <table class="checklist-table">
                    <tr>
                        <th>#</th>
                        <th>Description</th>
                        <th>Amount</th>
                    </tr>
                    @foreach($additionalCosts as $index => $item)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $item['description'] ?? 'N/A' }}</td>
                            <td>{{ $item['amount'] ?? 'N/A' }}</td>
                        </tr>
                    @endforeach
                </table>
            </div>
        @endif

        @if(count($remarks) > 0)
            <div class="summary-section">
                <h3>Remarks</h3>
                <table class="checklist-table">
                    <tr>
                        <th>#</th>
                        <th>Description</th>
                    </tr>
                    @foreach($remarks as $index => $item)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $item['description'] ?? 'N/A' }}</td>
                        </tr>
                    @endforeach
                </table>
            </div>
        @endif
    @endif
</body>
</html>
