<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Http;
use App\Http\Controllers\InspectionController;
use App\Http\Controllers\MaintenanceController;
use App\Http\Controllers\FuelManagementController;
use App\Http\Controllers\VehicleController;
use App\Http\Controllers\MasterDataController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AnalyticsController;
use App\Http\Controllers\DvirController;
use App\Http\Controllers\DvirReportController;
use App\Http\Controllers\DynamicPageController;
use App\Http\Controllers\userPageController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AccountDeletionController;
use App\Http\Controllers\NoticeController;

// Admin Authentication routes
Route::get('/admin/login', [AuthController::class, 'showLoginForm'])->name('admin.login');

Route::get('/login', function () {
    return redirect()->route('admin.login');
})->name('login');

Route::post('/admin/login', [AuthController::class, 'login'])->name('admin.login.store');

Route::post('/admin/logout', [AuthController::class, 'logout'])->name('admin.logout');

Route::get('/admin/logout', [AuthController::class, 'logout'])->name('admin.logout.get');

// Test route to verify routing is working
Route::get('/test-logout', function() {
    return 'Logout route test - working!';
});

// Admin Dashboard (Protected routes)
Route::middleware(['auth'])->group(function () {
    Route::get('/admin/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('/profile', function () {
        return view('profile');
    })->name('profile');
    Route::get('/logbook', function () {
        return view('logbook');
    })->name('logbook');
    Route::get('/logbook/create', function () {
        return view('logbook.create');
    })->name('logbook.create');
    Route::post('/change-password', [AuthController::class, 'changePassword'])->name('change-password');
    Route::get('/users', [userPageController::class, 'index'])->name('users');
    Route::get('/add-user', function () {
        return view('auth.add-user');
    })->name('add-user');
    Route::get('/hr-admin-dashboard', function () {
        return view('hr.hr-admin-dashboard');
    })->name('hr.admin.dashboard');
    Route::get('/create-application', function () {
        return view('hr.create-application');
    })->name('hr.create.application');
    Route::get('/leave-applications', function () {
        return view('hr.leave-applications');
    })->name('hr.leave.applications');
    Route::get('/appeal-applications', function () {
        return view('hr.appeal-applications');
    })->name('hr.appeal.applications');
    Route::get('/funeral-applications', function () {
        return view('hr.funeral-applications');
    })->name('hr.funeral.applications');
    Route::get('/grievance-applications', function () {
        return view('hr.grievance-applications');
    })->name('hr.grievance.applications');
    Route::get('/hospital-attendance', function () {
        return view('hr.hospital-attendance');
    })->name('hr.hospital.attendance');
    Route::get('/salary-advance', function () {
        return view('hr.salary-advance');
    })->name('hr.salary.advance');
});

// Admin Password reset routes
Route::get('/admin/forgot-password', function () {
    return view('auth.forgot-password');
})->name('password.request');


Route::post('/admin/forgot-password', function () {
    // Handle admin password reset request
    return redirect()->back()->with('status', 'Password reset link sent!');
})->name('password.email');

Route::get('/admin/reset-password/{token}', function ($token) {
    return view('auth.reset-password', ['token' => $token]);
})->name('password.reset');

Route::post('/admin/reset-password', function () {
    // Handle admin password reset
    return redirect()->route('admin.login')->with('status', 'Password reset successfully!');
})->name('password.update');

// Welcome route (dashboard) - Protected
Route::middleware(['auth'])->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/enhanced-dashboard', [DashboardController::class, 'enhanced'])->name('enhanced.dashboard');
});

// Test routes - Protected
Route::middleware(['auth'])->group(function () {
    Route::get('/test-mongodb', [DashboardController::class, 'testMongoDB'])->name('test.mongodb');
    Route::get('/test-inspection', [DashboardController::class, 'testInspectionData'])->name('test.inspection');
    Route::get('/test-service-schedule', [DashboardController::class, 'testServiceScheduleData'])->name('test.service.schedule');
    Route::get('/test-maintenance', [DashboardController::class, 'testMaintenanceRequests'])->name('test.maintenance');
    Route::get('/demo', function () {
        return view('demo.dynamic-form');
    })->name('demo.form');
});

// Inspection routes - Protected
Route::middleware(['auth'])->prefix('inspection')->name('inspection.')->group(function () {
    Route::get('/', [InspectionController::class, 'index'])->name('index');
    Route::get('/inspection-report', [InspectionController::class, 'inspectionReport'])->name('inspection_report');
    Route::get('/create-inspection-report', [InspectionController::class, 'inspection2'])->name('inspection2');
    Route::get('/do_inspection', [InspectionController::class, 'doInspection'])->name('do_inspection');
    Route::post('/store', [InspectionController::class, 'store'])->name('store');
    Route::post('/store-inspection', [InspectionController::class, 'storeInspection'])->name('store_inspection');
    Route::get('/incident_report', [InspectionController::class, 'incidentReport'])->name('incident_report');
    Route::get('/create-incident-report', [InspectionController::class, 'createIncident'])->name('create_incident_report');
    Route::post('/store-incident-report', [InspectionController::class, 'storeIncident'])->name('store_incident_report');
    Route::get('/back_to_incident_report', [InspectionController::class, 'backToIncidentReport'])->name('back_to_incident_report');
    Route::get('/incident_checklist', [InspectionController::class, 'incidentChecklist'])->name('incident_checklist');
    Route::get('/reminder', [InspectionController::class, 'reminder'])->name('reminder');
    Route::get('/operator_daily_reporting', [InspectionController::class, 'operatorDailyReporting'])->name('operator_daily_reporting');
    Route::get('/test-data', [InspectionController::class, 'testInspectionData'])->name('test_data');
    Route::get('/get-operator-daily-reports', [InspectionController::class, 'getOperatorDailyReports'])->name('get_operator_daily_reports');
    Route::get('/get-incident-reports', [InspectionController::class, 'getIncidentReports'])->name('get_incident_reports');
    Route::get('/debug-firebase-data', [InspectionController::class, 'debugFirebaseData'])->name('debug_firebase_data');
    Route::get('/create-incident', [InspectionController::class, 'createIncident'])->name('create_incident');
    Route::post('/store-incident', [InspectionController::class, 'storeIncident'])->name('store_incident');
    Route::get('/view-pdf/{id}', [InspectionController::class, 'viewInspectionPdf'])->name('view_pdf');
    Route::get('/view-dvir/{id}', [InspectionController::class, 'viewDvirPdf'])->name('view_dvir');
    Route::get('/view-incident/{id}', [InspectionController::class, 'viewIncidentPdf'])->name('view_incident');
    Route::get('/download-incident/{id}', [InspectionController::class, 'downloadIncidentPdf'])->name('download_incident');
    Route::get('/document-upload', function () {
        return view('inspection.document-upload');
    })->name('document_upload');

});

// Direct route for create-inspection-report (fallback)
Route::get('/create-inspection-report', [InspectionController::class, 'inspection2'])->name('inspection2.direct');

// Job Card routes
Route::middleware(['auth'])->group(function () {
    Route::get('/job_card', [InspectionController::class, 'jobCardIndex'])->name('job_card');
    Route::get('/job_card/create', [InspectionController::class, 'jobCard'])->name('job_card.create');
    Route::get('/get-job-cards', [InspectionController::class, 'getJobCards'])->name('get_job_cards');
});

// Clear cache route for debugging
Route::get('/clear-cache', function() {
    \Artisan::call('cache:clear');
    \Artisan::call('route:clear');
    \Artisan::call('view:clear');
    return 'Cache cleared successfully!';
})->name('clear.cache');

// Maintenance routes - Protected
Route::middleware(['auth'])->prefix('maintenance')->name('maintenance.')->group(function () {
    Route::get('/workorder', [MaintenanceController::class, 'workorder'])->name('workorder');
    Route::get('/request', [MaintenanceController::class, 'requestMaintenance'])->name('request');
    Route::get('/service_schedule', [MaintenanceController::class, 'serviceSchedule'])->name('service_schedule');
    Route::get('/create-schedule', [MaintenanceController::class, 'createSchedule'])->name('create_schedule');
    Route::get('/parts_inventory', [MaintenanceController::class, 'partsInventory'])->name('parts_inventory');
    Route::get('/labor_codes', [MaintenanceController::class, 'laborCodes'])->name('labor_codes');
    Route::get('/task_master', [MaintenanceController::class, 'taskMaster'])->name('task_master');
    Route::post('/store-request', [MaintenanceController::class, 'storeRequest'])->name('store_request');
    Route::post('/store-schedule', [MaintenanceController::class, 'storeSchedule'])->name('store_schedule');
    Route::get('/test-service-schedule-firebase', [MaintenanceController::class, 'testServiceScheduleFirebase'])->name('test_service_schedule_firebase');
    Route::get('/test-schedule-count', [MaintenanceController::class, 'testScheduleCount'])->name('test_schedule_count');
});

// Fuel Management routes - Protected
Route::middleware(['auth'])->prefix('fuel')->name('fuel.')->group(function () {
    Route::get('/logger', [FuelManagementController::class, 'fuelLogger'])->name('logger');
    Route::get('/bunker', [FuelManagementController::class, 'fuelBunker'])->name('bunker');
    Route::get('/new-entry', function () {
        return view('fuel_management.new-fuel-entry');
    })->name('new-entry');
});

// Vehicle routes - Protected
Route::middleware(['auth'])->prefix('vehicles')->name('vehicles.')->group(function () {
    Route::get('/inventory', [VehicleController::class, 'inventory'])->name('inventory');
    Route::get('/overview', [VehicleController::class, 'overview'])->name('overview');
    Route::get('/add-vehicle', [VehicleController::class, 'addVehicle'])->name('add-vehicle');
    Route::get('/dvir_dot_inspection', [VehicleController::class, 'dvirDotInspection'])->name('dvir_dot_inspection');
    Route::get('/test-dvir-structure', [VehicleController::class, 'testDvirDataStructure'])->name('test_dvir_structure');
    Route::get('/test-equipment-data', [VehicleController::class, 'testEquipmentData'])->name('test_equipment_data');
});

// Equipment/Vehicles API routes - Protected (MongoDB)
Route::middleware(['auth'])->prefix('api/equipment')->name('api.equipment.')->group(function () {
    Route::get('/all', [VehicleController::class, 'getAllEquipment'])->name('all');
    Route::delete('/delete/{equipmentId}', [VehicleController::class, 'deleteEquipment'])->name('delete');
});

// API routes for storing data - Protected
Route::middleware(['auth'])->group(function () {
    Route::post('/api/store-equipment', [VehicleController::class, 'storeEquipment'])->name('api.store.equipment');
    Route::post('/api/store-schedule', [MaintenanceController::class, 'storeSchedule'])->name('api.store.schedule');
});

// Firebase API routes - Protected
Route::middleware(['auth'])->prefix('api/firebase')->name('api.firebase.')->group(function () {
    Route::get('/equipment', [VehicleController::class, 'getFirebaseEquipment'])->name('equipment');
    Route::post('/workorder/store', [VehicleController::class, 'storeWorkOrderToFirebase'])->name('workorder.store');
});

// API routes for inspection data from MongoDB - Protected
Route::middleware(['auth'])->group(function () {
    Route::get('/api/inspections/test-mongo', [InspectionController::class, 'testMongoConnection'])->name('api.inspections.test.mongo');
    Route::get('/api/inspections/all', [InspectionController::class, 'getAllInspectionReports'])->name('api.inspections.all');
    Route::post('/api/inspections/create', [InspectionController::class, 'createInspectionReport'])->name('api.inspections.create');
    Route::delete('/api/inspections/delete/{inspectionId}', [InspectionController::class, 'deleteInspectionReport'])->name('api.inspections.delete');
    Route::get('/api/inspections/view-pdf', [InspectionController::class, 'viewPdfProxy'])->name('api.inspections.view.pdf');
    Route::get('/api/fetch-equipment-from-firebase', [InspectionController::class, 'fetchEquipmentFromFirebase'])->name('api.fetch.equipment.firebase');
    Route::get('/api/fetch-inspection-reports', [InspectionController::class, 'fetchInspectionReportsForLinking'])->name('api.fetch.inspection.reports');
    Route::get('/api/fetch-inspection-details', [InspectionController::class, 'fetchInspectionDetailsByKey'])->name('api.fetch.inspection.details');

// Incident Report API Routes
Route::post('/api/incident-report/store', [App\Http\Controllers\IncidentController::class, 'store'])->name('api.incident.store');
Route::post('/api/generate-incident-pdf', [App\Http\Controllers\IncidentController::class, 'generateIncidentPdfApi'])->name('api.generate.incident.pdf');
Route::get('/api/incident-report/view/{id}', [App\Http\Controllers\IncidentController::class, 'view'])->name('api.incident.view');
    Route::get('/api/fetch-checklists-from-firebase', [InspectionController::class, 'fetchChecklistsFromFirebase'])->name('api.fetch.checklists.firebase');
});

// API routes for saving inspection reports and generating PDFs - Protected
Route::middleware(['auth'])->group(function () {
    Route::post('/api/save-inspection-report', [InspectionController::class, 'saveInspectionReport'])->name('api.save.inspection.report');
    Route::post('/api/generate-inspection-pdf', [InspectionController::class, 'generateInspectionPdf'])->name('api.generate.inspection.pdf');
});

// Users Page Route - Protected
Route::middleware(['auth'])->group(function () {
    Route::get('/users', [UserController::class, 'index'])->name('users');
});

// User Management API routes - Protected (MongoDB)
Route::middleware(['auth'])->prefix('api/users')->name('api.users.')->group(function () {
    Route::post('/save', [UserController::class, 'saveUser'])->name('save');
    Route::get('/all', [UserController::class, 'getAllUsers'])->name('all');
    Route::get('/get/{userId}', [UserController::class, 'getUserById'])->name('get');
    Route::put('/update/{userId}', [UserController::class, 'updateUser'])->name('update');
    Route::delete('/delete/{userId}', [UserController::class, 'deleteUser'])->name('delete');
});

// API routes for DVIR reports
// API routes for DVIR - Protected
Route::middleware(['auth'])->group(function () {
    Route::post('/api/save-dvir-report', [DvirController::class, 'saveDvirReport'])->name('api.save.dvir.report');
    Route::post('/api/generate-dvir-pdf', [DvirController::class, 'generateDvirPdf'])->name('api.generate.dvir.pdf');
    Route::get('/api/get-dvir-reports', [DvirController::class, 'getDvirReports'])->name('api.get.dvir.reports');
    Route::get('/api/equipment', [VehicleController::class, 'getFirebaseEquipment'])->name('api.equipment');
    
    // New DVIR Report API routes
    Route::post('/api/dvir-reports/save', [DvirReportController::class, 'saveReport'])->name('api.dvir.reports.save');
    Route::get('/api/dvir-reports/{userId}', [DvirReportController::class, 'getReports'])->name('api.dvir.reports.get');
    Route::get('/api/dvir-reports/{userId}/{reportId}', [DvirReportController::class, 'getReport'])->name('api.dvir.reports.get.single');
    Route::put('/api/dvir-reports/{userId}/{reportId}', [DvirReportController::class, 'updateReport'])->name('api.dvir.reports.update');
    Route::delete('/api/dvir-reports/{userId}/{reportId}', [DvirReportController::class, 'deleteReport'])->name('api.dvir.reports.delete');
    
    // Test route for Firebase equipment data
    Route::get('/test-firebase-equipment', function() {
        try {
            $response = Http::get('https://titan-drilling-1f8e9-default-rtdb.firebaseio.com/EquipmentsDataJSON/GlobalEquipmentJsonData.json');
            
            if ($response->successful()) {
                $equipmentData = $response->json() ?? [];
                return response()->json([
                    'success' => true,
                    'status' => $response->status(),
                    'total_records' => is_array($equipmentData) ? count($equipmentData) : 'Not array',
                    'sample_data' => is_array($equipmentData) && !empty($equipmentData) ? array_slice($equipmentData, 0, 3) : 'No data',
                    'message' => 'Firebase connection successful'
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'status' => $response->status(),
                    'message' => 'Failed to connect to Firebase'
                ]);
            }
        } catch (Exception $e) {
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'message' => 'Error connecting to Firebase'
            ]);
        }
    });
});

// Test route for DVIR DOT Inspection
// DVIR routes - Protected
Route::middleware(['auth'])->group(function () {
    Route::get('/test-dvir', function() {
        return view('dvir_dot_inspection.DVIR_DOT_Inspection');
    })->name('test.dvir');

    Route::get('/dvir-dot-inspection', [App\Http\Controllers\VehicleController::class, 'dvirDotInspection'])->name('dvir.dot.inspection');

    Route::get('/dvir-dot-inspection/create', function() {
        return view('dvir_dot_inspection.create_dvir_inspection');
    })->name('dvir.dot.inspection.create');

    Route::get('/dvir-dot-inspection/create-dvir-report', function() {
        return view('dvir_dot_inspection.create_dvir_report');
    })->name('dvir.dot.inspection.create.report');

    Route::get('/dvir-dot-inspection/create-dvir-report-step1', function() {
        return view('dvir_dot_inspection.create_dvir_report_step1');
    })->name('dvir.dot.inspection.create.report.step1');

    // Test route for DVIR Firebase integration
    Route::get('/test-dvir-firebase', function() {
        try {
            $dvirFirebaseService = app(\App\Services\DvirFirebaseService::class);
            $testUserId = 'cahj3jJqe5Z16pQdLGSWrNgm84o1';
            
            // Test getting reports
            $result = $dvirFirebaseService->getDvirReports($testUserId);
            
            return response()->json([
                'success' => true,
                'message' => 'DVIR Firebase service test successful',
                'firebase_url' => 'https://titan-drilling-1f8e9-default-rtdb.firebaseio.com/GlobalDvirReports/admins/' . $testUserId . '/inspectionReports',
                'result' => $result
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'DVIR Firebase service test failed',
                'error' => $e->getMessage()
            ], 500);
        }
    })->name('test.dvir.firebase');

    // Test route to create a sample DVIR report
    Route::get('/test-create-dvir', function() {
        try {
            $dvirFirebaseService = app(\App\Services\DvirFirebaseService::class);
            $testUserId = 'cahj3jJqe5Z16pQdLGSWrNgm84o1';
            
            $sampleReport = [
                'id' => 'test_' . time(),
                'dvirNumber' => 'DVIR-TEST-001',
                'step1' => [
                    'country' => 'Zambia',
                    'project' => 'Test Project',
                    'inspector' => 'Test Inspector',
                    'selectedEquipment' => [
                        'id' => 'test_equipment',
                        'registrationNumber' => 'TEST-123',
                        'make' => 'Test Make',
                        'model' => 'Test Model'
                    ],
                    'timestamp' => time()
                ],
                'step2' => [
                    'items' => [
                        [
                            'itemId' => 'req1',
                            'label' => 'Test requirement',
                            'note' => 'Test note',
                            'section' => 'Requirements',
                            'status' => 'Yes',
                            'photo' => null
                        ]
                    ],
                    'timestamp' => time()
                ],
                'step3' => [
                    'dvirNumber' => 'DVIR-TEST-001',
                    'equipmentStatus' => 'Fit to travel',
                    'overallCondition' => 'Good',
                    'safeToUse' => 'Yes',
                    'faultyItems' => 0,
                    'signatureData' => 'data:image/png;base64,test',
                    'signatureStatus' => true,
                    'signatureDownloadUrl' => 'https://test.com/signature.png',
                    'pdfDownloadUrl' => 'https://test.com/report.pdf',
                    'createdAt' => now()->toISOString(),
                    'timestamp' => time()
                ],
                'createdAt' => now()->toISOString()
            ];
            
            $result = $dvirFirebaseService->saveDvirReport($testUserId, $sampleReport);
            
            return response()->json([
                'success' => true,
                'message' => 'Test DVIR report created',
                'result' => $result
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Test DVIR creation failed',
                'error' => $e->getMessage()
            ], 500);
        }
    })->name('test.create.dvir');

});

// Test Firebase API endpoints - Protected
Route::middleware(['auth'])->group(function () {
    Route::get('/test-firebase-apis', function() {
        return view('test.firebase-apis');
    })->name('test.firebase.apis');

    Route::get('/test-workorder-form', function() {
        return view('maintenance.CreateNewWorkorder');
    })->name('test.workorder.form');

    Route::get('/work-order', function() {
        return view('maintenance.CreateNewWorkorder');
    })->name('workorder.create');
});

// Test DVIR data fetching - Protected
Route::middleware(['auth'])->get('/test-dvir-data', function() {
    try {
        $response = Http::get('https://titan-drilling-c4752-default-rtdb.firebaseio.com/GlobalDvirReports/admins/cahj3jJqe5Z16pQdLGSWrNGm84o1/inspectionReports.json');
        
        if ($response->successful()) {
            $dvirData = $response->json() ?? [];
            return response()->json([
                'success' => true,
                'status' => $response->status(),
                'total_records' => is_array($dvirData) ? count($dvirData) : 'Not array',
                'sample_data' => is_array($dvirData) && !empty($dvirData) ? array_slice($dvirData, 0, 3, true) : [],
                'message' => 'DVIR data retrieved successfully'
            ]);
        } else {
            return response()->json([
                'success' => false,
                'status' => $response->status(),
                'message' => 'Failed to fetch DVIR data'
            ], 500);
        }
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'error' => $e->getMessage(),
            'message' => 'Error fetching DVIR data'
        ], 500);
    }
})->name('test.dvir.data');

// Test DVIR save structure - Protected
Route::middleware(['auth'])->get('/test-dvir-save-structure', function() {
    try {
        // Sample data structure that matches our new format
        $sampleData = [
            'requestNumber' => 'ZAM-KOB-DVIR-TEST',
            'step1' => [
                'country' => 'Zambia',
                'project' => 'Kobold',
                'inspector' => 'Test Inspector',
                'equipment' => [
                    'id' => 'test_equipment',
                    'equipmentName' => 'Test Vehicle',
                    'model' => 'Test Model'
                ],
                'meterReading' => '1000'
            ],
            'step2' => [
                'inspectionSelections' => [
                    'req1' => 'Yes',
                    'req2' => 'Yes',
                    'haz1' => 'Yes'
                ],
                'inspectionNotes' => [],
                'inspectionImages' => [],
                'faultyItemsCount' => 0
            ],
            'step3' => [
                'overallCondition' => 'Proceed with journey',
                'driverStatus' => 'Fit to travel',
                'safeToUse' => 'Yes',
                'additionalNotes' => 'Test notes',
                'signature' => 'data:image/png;base64,test'
            ]
        ];
        
        return response()->json([
            'success' => true,
            'message' => 'Sample DVIR data structure for testing',
            'sample_data' => $sampleData,
            'expected_firebase_structure' => [
                'createdAt' => 'ISO timestamp',
                'dvirNumber' => 'DVIR-XXX',
                'id' => 'timestamp',
                'step1' => 'Transformed step1 data',
                'step2' => 'Transformed step2 data with items array',
                'step3' => 'Transformed step3 data'
            ]
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'error' => $e->getMessage(),
            'message' => 'Error generating test structure'
        ], 500);
    }
})->name('test.dvir.save.structure');

// Master Data routes - Protected
Route::middleware(['auth'])->prefix('master-data')->name('master_data.')->group(function () {
    Route::get('/team', [MasterDataController::class, 'teamManagement'])->name('team');
    Route::get('/documents', [MasterDataController::class, 'documents'])->name('documents');
    Route::get('/account', [MasterDataController::class, 'account'])->name('account');
    Route::get('/subscription', [MasterDataController::class, 'subscription'])->name('subscription');
});

// Dashboard and Analytics routes
Route::middleware(['auth'])->prefix('dashboard')->name('dashboard.')->group(function () {
    Route::get('/excel-report', [AnalyticsController::class, 'excelReport'])->name('excel_report');
    Route::get('/inspection-kpi', [AnalyticsController::class, 'inspectionKpi'])->name('inspection_kpi');
    Route::get('/incident-kpi', [AnalyticsController::class, 'incidentKpi'])->name('incident_kpi');
    Route::get('/logbook-kpi', [AnalyticsController::class, 'logbookKpi'])->name('logbook_kpi');
    Route::get('/maintenance-kpi', [AnalyticsController::class, 'maintenanceKpi'])->name('maintenance_kpi');
    Route::get('/workorder-kpi', [AnalyticsController::class, 'workorderKpi'])->name('workorder_kpi');
    Route::get('/fuel-management-kpi', [AnalyticsController::class, 'fuelManagementKpi'])->name('fuel_management_kpi');
    Route::get('/equipment-kpi', [AnalyticsController::class, 'equipmentKpi'])->name('equipment_kpi');
    Route::get('/team-kpi', [AnalyticsController::class, 'teamKpi'])->name('team_kpi');
    Route::get('/team-employees-kpi', [AnalyticsController::class, 'teamEmployeesKpi'])->name('team_employees_kpi');
    
    // Team KPI Reporting Sub-routes
    Route::prefix('team-kpi')->name('team_kpi.')->group(function () {
        Route::get('/home', [AnalyticsController::class, 'teamKpiHome'])->name('home');
        Route::get('/employees', [AnalyticsController::class, 'teamKpiEmployees'])->name('employees');
        Route::get('/supervisor', [AnalyticsController::class, 'teamKpiSupervisor'])->name('supervisor');
        Route::get('/sites', [AnalyticsController::class, 'teamKpiSites'])->name('sites');
        Route::get('/inspections-closed', [AnalyticsController::class, 'teamKpiInspectionsClosed'])->name('inspections_closed');
        Route::get('/inspections-opened', [AnalyticsController::class, 'teamKpiInspectionsOpened'])->name('inspections_opened');
        Route::get('/employees-participated', [AnalyticsController::class, 'teamKpiEmployeesParticipated'])->name('employees_participated');
        Route::get('/employees-closed', [AnalyticsController::class, 'teamKpiEmployeesClosed'])->name('employees_closed');
        Route::get('/equipment-status', [AnalyticsController::class, 'teamKpiEquipmentStatus'])->name('equipment_status');
    });
});

// Workorder routes - Protected
Route::middleware(['auth'])->group(function () {
    Route::get('/workorders', [MaintenanceController::class, 'workorder'])->name('workorders.index');
    Route::get('/workorders/test-data', [MaintenanceController::class, 'testWorkorderData']);
    
    // New work order routes
    Route::get('/maintenance/work-orders', [MaintenanceController::class, 'workorder'])->name('maintenance.workorders');
    Route::get('/maintenance/work-orders/create', [App\Http\Controllers\WorkorderController::class, 'create'])->name('maintenance.workorders.create');
    Route::post('/maintenance/work-orders', [App\Http\Controllers\WorkorderController::class, 'store'])->name('maintenance.workorders.store');
    Route::get('/maintenance/work-orders/{id}', [App\Http\Controllers\WorkorderController::class, 'show'])->name('maintenance.workorders.show');
    Route::get('/maintenance/work-orders/{id}/pdf', [App\Http\Controllers\WorkorderController::class, 'pdf'])->name('maintenance.workorders.pdf');
    
    // Job Card routes
    Route::get('/maintenance/job-cards', function () {
        return view('maintenance.JobCard');
    })->name('maintenance.jobcards');
    
    // Maintenance Request routes
    Route::get('/maintenance/request/create', [App\Http\Controllers\MaintenanceRequestController::class, 'create'])->name('maintenance.request.create');
    Route::post('/maintenance/request', [App\Http\Controllers\MaintenanceRequestController::class, 'store'])->name('maintenance.request.store');
    Route::get('/maintenance/request/{id}', [App\Http\Controllers\MaintenanceRequestController::class, 'show'])->name('maintenance.request.show');
    Route::get('/maintenance/request/{id}/pdf', [App\Http\Controllers\MaintenanceRequestController::class, 'pdf'])->name('maintenance.request.pdf');

    // API routes for modals
    Route::get('/api/equipment', [App\Http\Controllers\MaintenanceRequestController::class, 'getEquipment'])->name('api.equipment');
    Route::get('/api/users', [App\Http\Controllers\MaintenanceRequestController::class, 'getUsers'])->name('api.users');
    Route::get('/api/inspections', [App\Http\Controllers\WorkorderController::class, 'getInspections'])->name('api.inspections');
    Route::get('/api/work-orders', [App\Http\Controllers\WorkorderController::class, 'getWorkOrders'])->name('api.work-orders');
});
// Maintenance API routes - Protected
Route::middleware(['auth'])->group(function () {
    Route::get('/create-workorder', [MaintenanceController::class, 'createWorkorder'])->name('maintenance.workorders.create');
    Route::post('/workorders/store', [MaintenanceController::class, 'storeWorkorder'])->name('workorders.store');
    Route::get('/view-workorder/{id}', [MaintenanceController::class, 'viewWorkorderPdf'])->name('view_workorder');
});

// Request Maintenance routes
// Maintenance request routes - Protected
Route::middleware(['auth'])->group(function () {
    Route::get('/request-maintenance', function() {
        return view('maintenance.Request_Maintenance');
    })->name('request.maintenance');
    
    Route::get('/create-new-request-maintenance', function() {
        return view('maintenance.Create_New_Request_Maintenance');
    })->name('create.request.maintenance');
    
    Route::get('/create-new-request-maintenance-react', function() {
        return view('maintenance.Create_New_Request_Maintenance_React');
    })->name('maintenance.request.create.react');
});

// Dynamic page loading route - Protected
Route::middleware(['auth'])->post('/load-page', [DynamicPageController::class, 'loadPage'])->name('load.page');

// Test User Firebase connection
Route::middleware(['auth'])->get('/test-user-firebase-connection', function() {
    try {
        $userFirebaseService = app(\App\Services\UserFirebaseService::class);
        $testUserData = [
            'name' => 'Test User',
            'email' => 'test' . time() . '@example.com',
            'password' => 'testpassword123!',
            'mobile' => '+260123456789',
            'role' => 'Supervisor',
            'department' => 'Operations',
            'nrcIdNumber' => '123456/78/9',
            'employeeNumber' => 'EMP' . time(),
            'engagementDate' => now()->toISOString(),
            'countries' => ['Zambia'],
            'projects' => ['Kobold', 'Kansanshi'],
            'modules' => [
                [
                    'module' => 'inspectionReport',
                    'permissions' => ['create', 'view']
                ],
                [
                    'module' => 'maintenance',
                    'permissions' => ['create', 'edit', 'view']
                ]
            ],
            'sourceKey' => 'test_' . time()
        ];

        $result = $userFirebaseService->saveNewUser($testUserData);

        return response()->json([
            'success' => true,
            'message' => 'User Firebase connection test successful',
            'result' => $result,
            'firebase_url' => 'https://titan-drilling-1f8e9-default-rtdb.firebaseio.com/Globalusers/admins',
            'test_data' => $testUserData
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => 'User Firebase connection test failed',
            'error' => $e->getMessage(),
            'trace' => $e->getTraceAsString()
        ], 500);
    }
})->name('test.user.firebase.connection');

// Account Deletion routes
Route::get('/account-deletion-request', [AccountDeletionController::class, 'showForm'])->name('account-deletion.request');
Route::post('/account-deletion-request', [AccountDeletionController::class, 'submitRequest'])->name('account-deletion.submit');

// Admin Account Deletion Management routes - Protected
Route::middleware(['auth'])->prefix('admin/account-deletion')->name('account-deletion.admin.')->group(function () {
    Route::get('/', [AccountDeletionController::class, 'adminIndex'])->name('index');
    Route::get('/{id}', [AccountDeletionController::class, 'adminShow'])->name('show');
    Route::post('/{id}/approve', [AccountDeletionController::class, 'adminApprove'])->name('approve');
    Route::post('/{id}/reject', [AccountDeletionController::class, 'adminReject'])->name('reject');
});

// Notice Board routes - Protected
Route::middleware(['auth'])->prefix('notice')->name('notice.')->group(function () {
    Route::get('/', [NoticeController::class, 'index'])->name('index');
    Route::get('/create', [NoticeController::class, 'create'])->name('create');
    Route::post('/', [NoticeController::class, 'store'])->name('store');
    Route::get('/{id}', [NoticeController::class, 'show'])->name('show');
    Route::delete('/{id}', [NoticeController::class, 'destroy'])->name('destroy');
});

// Maintenance Request routes - Protected
Route::middleware(['auth'])->prefix('maintenance-request')->name('maintenance.request.')->group(function () {
    Route::get('/create', [App\Http\Controllers\MaintenanceRequestController::class, 'create'])->name('create');
    Route::post('/', [App\Http\Controllers\MaintenanceRequestController::class, 'store'])->name('store');
    Route::get('/{id}', [App\Http\Controllers\MaintenanceRequestController::class, 'show'])->name('show');
    Route::get('/{id}/pdf', [App\Http\Controllers\MaintenanceRequestController::class, 'pdf'])->name('pdf');
    Route::get('/test/number-generation', [App\Http\Controllers\MaintenanceRequestController::class, 'testNumberGeneration'])->name('test.number');
    Route::get('/test/update-counter', [App\Http\Controllers\MaintenanceRequestController::class, 'testUpdateCounter'])->name('test.counter');
});

// Privacy Policy route
Route::get('/privacy-policy', function () {
    return response()->file(base_path('AppContent/Privacy-Policy'));
})->name('privacy.policy');

// Fallback route for 404
Route::fallback(function () {
    return view('errors.404');
})->name('fallback');
?>