import React, { useState, useEffect, useRef } from 'react';
import {
  View,
  Text,
  StyleSheet,
  TouchableOpacity,
  StatusBar,
  TextInput,
  Image,
  Dimensions,
  Animated,
  Modal,
  FlatList,
} from 'react-native';
import LinearGradient from 'react-native-linear-gradient';
import MaterialIcons from 'react-native-vector-icons/MaterialIcons';
import Ionicons from 'react-native-vector-icons/Ionicons';
import { useNavigation } from '@react-navigation/native';
import AsyncStorage from '@react-native-async-storage/async-storage';

const { width, height } = Dimensions.get('window');
const TOTAL_HEADER_HEIGHT = width < 350 ? width * 0.28 : width * 0.33;

const HR_Form = () => {
  const navigation = useNavigation();
  const [syncModalVisible, setSyncModalVisible] = useState(false);
  const [isRefreshing, setIsRefreshing] = useState(false);

  const rotateAnim = useRef(new Animated.Value(0)).current;
  const rotateInterpolate = rotateAnim.interpolate({
    inputRange: [0, 1],
    outputRange: ['0deg', '360deg'],
  });


  const handleRefresh = () => {
    setIsRefreshing(true);
    setSyncModalVisible(true);

    Animated.loop(
      Animated.timing(rotateAnim, {
        toValue: 1,
        duration: 1000,
        useNativeDriver: true,
      })
    ).start();

    setTimeout(() => {
      setIsRefreshing(false);
      setSyncModalVisible(false);
      rotateAnim.setValue(0);
    }, 2000);
  };

  return (
    <View style={styles.container}>
      <LinearGradient
        colors={['#3481BC', '#025383']}
        style={[styles.header, { height: TOTAL_HEADER_HEIGHT }]}
      >
        <StatusBar translucent backgroundColor="transparent" barStyle="light-content" />
        <View style={styles.headerContent}>
          <View style={styles.headerLeft}>
            <TouchableOpacity onPress={() => navigation.goBack()}>
              <MaterialIcons name="arrow-back" size={width * 0.06} color="#fff" />
            </TouchableOpacity>
            <Text style={styles.headerTitle}>Leave Request</Text>
          </View>
          <View style={styles.headerRight}>
            <TouchableOpacity style={styles.iconButton} onPress={handleRefresh}>
              <Image
                source={require('../../../Images/adminhome/equp/cloud_1.png')}
                style={styles.icons12}
              />
            </TouchableOpacity>
          </View>
        </View>
      </LinearGradient>

      <Modal visible={syncModalVisible} transparent animationType="fade">
        <View style={styles.syncModalContainer}>
          <View style={styles.syncModalContent}>
            <Text style={styles.syncModalText}>Please Wait</Text>
            <View style={styles.syncIcondiv}>
              <Animated.Image
                source={require('../../../Images/adminlogin/sync.png')}
                style={[styles.syncIcon, { transform: [{ rotate: rotateInterpolate }] }]}
              />
              <Text style={styles.syncModalTextadd}>Cloud Data Sync in Progress</Text>
            </View>
          </View>
        </View>
      </Modal>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: '#f0f0f0',
  },
  header: {
    width: '100%',
    justifyContent: 'center',
  },
  headerContent: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    paddingHorizontal: width < 350 ? width * 0.03 : width * 0.04,
    paddingTop: StatusBar.currentHeight || (width < 350 ? width * 0.08 : width * 0.1),
  },
  headerLeft: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  headerRight: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  headerTitle: {
    color: '#fff',
    fontSize: width < 350 ? width * 0.045 : width * 0.05,
    fontWeight: 'bold',
    marginLeft: width < 350 ? width * 0.02 : width * 0.025,
  },
  iconButton: {
    padding: width < 350 ? width * 0.01 : width * 0.012,
    marginLeft: width < 350 ? width * 0.02 : width * 0.025,
  },
  icons12: {
    width: width < 350 ? width * 0.06 : width * 0.07,
    height: width < 350 ? width * 0.055 : width * 0.06,
  },
  searchContainer: {
    flexDirection: 'row',
    paddingHorizontal: width * 0.04,
    paddingVertical: width * 0.025,
    alignItems: 'center',
    width: '100%',
  },
  searchWrapper: {
    flex: 1,
    flexDirection: 'row',
    alignItems: 'center',
    backgroundColor: '#fff',
    borderRadius: width * 0.09,
    paddingHorizontal: width * 0.025,
    marginRight: width * 0.025,
  },
  searchInput: {
    flex: 1,
    height: width * 0.1,
    color: '#333',
    fontSize: width * 0.04,
  },
  bladeIcon: {
    marginLeft: width * 0.012,
  },
  filterButton: {
    padding: width * 0.012,
  },
  listContent: {
    paddingHorizontal: width * 0.04,
    paddingVertical: width * 0.025,
    paddingBottom: width * 0.3,
  },
  partItemCustom: {
    backgroundColor: '#fff',
    borderRadius: width * 0.02,
    borderWidth: 1,
    borderColor: '#e0e0e0',
    padding: 0,
    marginBottom: width * 0.03,
    shadowColor: '#000',
    shadowOffset: { width: 0, height: 1 },
    shadowOpacity: 0.05,
    shadowRadius: 2,
    elevation: 1,
    overflow: 'hidden',
  },
  partIdRowCustom: {
    backgroundColor: '#ededed',
    paddingVertical: width * 0.018,
    paddingHorizontal: width * 0.025,
    borderTopLeftRadius: width * 0.02,
    borderTopRightRadius: width * 0.02,
  },
  partIdCustom: {
    fontSize: width * 0.04,
    fontWeight: 'bold',
    color: '#222',
  },
  detailRowWithLine: {
    flexDirection: 'row',
    alignItems: 'stretch',
    borderBottomWidth: 1,
    borderBottomColor: '#ededed',
    minHeight: width * 0.1,
    paddingHorizontal: width * 0.025,
  },
  detailRowLast: {
    flexDirection: 'row',
    alignItems: 'stretch',
    paddingHorizontal: width * 0.025,
  },
  partLabelCustom: {
    fontSize: width * 0.035,
    color: '#888',
    fontWeight: 'bold',
    width: '38%',
    textAlignVertical: 'center',
    textAlign: 'left',
    paddingVertical: width * 0.03,
  },
  valueColWrapNoDivider: {
    flex: 1,
    flexDirection: 'row',
    alignItems: 'center',
  },
  partValueCustom: {
    fontSize: width * 0.035,
    color: '#222',
    textAlign: 'left',
    textAlignVertical: 'center',
    flexShrink: 1,
  },
  supplierRow: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'flex-start',
    flex: 1,
  },
  moreIconButton: {
    marginLeft: width * 0.3,
    padding: width * 0.01,
  },
  buttonContainer: {
    position: 'absolute',
    bottom: '5%',
    width: '100%',
    alignItems: 'center',
  },
  buttonGradient: {
    borderRadius: width * 0.012,
    overflow: 'hidden',
  },
  startButton: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingVertical: width * 0.025,
    paddingHorizontal: width * 0.05,
  },
  buttonText: {
    color: '#fff',
    fontSize: width * 0.04,
    fontWeight: 'bold',
    marginLeft: width * 0.012,
  },
  syncModalContainer: {
    flex: 1,
    backgroundColor: 'rgba(0,0,0,0.5)',
    justifyContent: 'center',
    alignItems: 'center',
  },
  syncModalContent: {
    width: width < 350 ? '80%' : '70%',
    backgroundColor: 'white',
    borderRadius: 10,
    padding: width < 350 ? 15 : 20,
    alignItems: 'center',
  },
  syncModalText: {
    fontSize: width < 350 ? 16 : 18,
    marginBottom: 10,
    color: '#333',
  },
  syncIcon: {
    width: width < 350 ? 25 : 30,
    height: width < 350 ? 25 : 30,
    marginRight: width < 350 ? 8 : 10,
  },
  syncModalTextadd: {
    fontSize: width < 350 ? 12 : 14,
    color: '#333',
  },
  syncIcondiv: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
});

export default HR_Form;