const HSE_132_Json = {
  document_name: "HSE-FOR-8.1.1 REHABILITATION CHECKLIST",
  document_id: "HSE-132",
  version_date: "05/05/2024",
  version: "1",
  approved_by: "HSM",
  sections: [
    {
      name: "General Inspection Details",
      items: [
        {
          key: "rigName",
          itemName: "RIG NAME",
          inputType: "text",
          required: true,
          placeholder: "Enter rig name"
        },
        {
          key: "location",
          itemName: "LOCATION",
          inputType: "text",
          required: true,
          placeholder: "Enter location"
        },
        {
          key: "holeId",
          itemName: "HOLE ID",
          inputType: "text",
          required: true,
          placeholder: "Enter hole ID"
        },
        {
          key: "dateOfInspection",
          itemName: "DATE OF INSPECTION",
          inputType: "date",
          required: true
        },
        {
          key: "time",
          itemName: "TIME",
          inputType: "time",
          required: true
        }
      ]
    },
    {
      name: "Environmental Rehabilitation Checklist",
      items: [
        {
          key: "oilSpillsCleaned",
          itemName: "Oils spills cleaned",
          inputType: "Yes/No",
          required: true,
          options: ["Yes", "No"],
          comments: true
        },
        {
          key: "freeFromChemicalSpills",
          itemName: "Free from chemical spills",
          inputType: "Yes/No",
          required: true,
          options: ["Yes", "No"],
          comments: true
        },
        {
          key: "sumpClosed",
          itemName: "Sump closed",
          inputType: "Yes/No",
          required: true,
          options: ["Yes", "No"],
          comments: true
        },
        {
          key: "freeFromOtherWaste",
          itemName: "Free from other waste",
          inputType: "Yes/No",
          required: true,
          options: ["Yes", "No"],
          comments: true
        },
        {
          key: "surroundingArea",
          itemName: "Surrounding area",
          inputType: "Yes/No",
          required: true,
          options: ["Yes", "No"],
          comments: true
        }
      ]
    },
    {
      name: "Personnel Information",
      items: [
        {
          key: "supervisorName",
          itemName: "SUPERVISORS NAME",
          inputType: "text",
          required: true,
          placeholder: "Enter supervisor name"
        },
        {
          key: "supervisorDate",
          itemName: "SUPERVISOR DATE",
          inputType: "date",
          required: true
        },
        {
          key: "supervisorSignature",
          itemName: "SUPERVISOR SIGNATURE",
          inputType: "signature",
          required: true
        },
        {
          key: "hseOfficerName",
          itemName: "HSE OFFICER NAME",
          inputType: "text",
          required: true,
          placeholder: "Enter HSE officer name"
        },
        {
          key: "hseOfficerDate",
          itemName: "HSE OFFICER DATE",
          inputType: "date",
          required: true
        },
        {
          key: "hseOfficerSignature",
          itemName: "HSE OFFICER SIGNATURE",
          inputType: "signature",
          required: true
        }
      ]
    }
  ],
  metadata: {
    company: "TITAN DRILLING",
    formType: "Environmental Rehabilitation Checklist",
    category: "HSE",
    subcategory: "Environmental",
    lastUpdated: "2024-05-05",
    createdBy: "HSM",
    status: "Active"
  },
  validation: {
    requiredFields: [
      "rigName",
      "location", 
      "holeId",
      "dateOfInspection",
      "time",
      "oilSpillsCleaned",
      "freeFromChemicalSpills",
      "sumpClosed",
      "freeFromOtherWaste",
      "surroundingArea",
      "supervisorName",
      "supervisorDate",
      "supervisorSignature",
      "hseOfficerName",
      "hseOfficerDate",
      "hseOfficerSignature"
    ],
    checklistItems: [
      "oilSpillsCleaned",
      "freeFromChemicalSpills", 
      "sumpClosed",
      "freeFromOtherWaste",
      "surroundingArea"
    ]
  },
  instructions: {
    general: "Complete all fields marked with * (required)",
    checklist: "Mark each environmental rehabilitation item as 'Ok' or 'Not Ok' and provide comments if necessary",
    signatures: "Both supervisor and HSE officer must sign and date the form",
    comments: "Use the comments section to provide additional details for any 'Not Ok' items"
  }
};

export default HSE_132_Json;
