@extends('welcome')

@section('title', 'View Notice')

@section('content')
<div class="view-notice-container">
    <div class="view-notice-header">
        <div class="header-content">
            <div class="page-title">
                <h1>Notice Details</h1>
                <p>View notice information and details</p>
            </div>
            <div class="header-actions">
                <a href="{{ route('notice.index') }}" class="btn-back">
                    <i class="fas fa-arrow-left"></i>
                    Back to Notices
                </a>
                <button class="btn-delete" onclick="deleteNotice('{{ $notice['noticeId'] }}')">
                    <i class="fas fa-trash"></i>
                    Delete Notice
                </button>
            </div>
        </div>
    </div>
    
    <div class="view-notice-content">
        <div class="content-box">
            <div class="notice-details">
                <div class="notice-header">
                    <h2 class="notice-title">{{ $notice['title'] }}</h2>
                    <div class="notice-meta">
                        <span class="notice-date">{{ \Carbon\Carbon::parse($notice['createdAt'])->format('M d, Y \a\t g:i A') }}</span>
                        <span class="notice-author">By: Admin</span>
                    </div>
                </div>
                
                <div class="notice-content">
                    @if(isset($notice['imageUrl']) && $notice['imageUrl'])
                        <div class="notice-image">
                            <img src="{{ $notice['imageUrl'] }}" alt="Notice Image" class="notice-img">
                        </div>
                    @endif
                    
                    <div class="notice-description">
                        {!! nl2br(e($notice['description'])) !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal-overlay" id="deleteModal" style="display: none;">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Delete Notice</h3>
            <button class="modal-close" onclick="closeDeleteModal()">&times;</button>
        </div>
        <div class="modal-body">
            <p>Are you sure you want to delete this notice? This action cannot be undone.</p>
        </div>
        <div class="modal-footer">
            <button class="btn-cancel" onclick="closeDeleteModal()">Cancel</button>
            <button class="btn-confirm-delete" onclick="confirmDelete()">Delete</button>
        </div>
    </div>
</div>

<style>
/* View Notice Styles */
.view-notice-container {
    min-height: 100vh;
    background: #f8fafc;
    font-family: 'Inter', sans-serif;
}

.view-notice-header {
    background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
    padding: 2rem 0;
    margin-bottom: 0;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

.header-content {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 2rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.page-title h1 {
    font-size: 2.5rem;
    font-weight: 700;
    color: #ffffff;
    margin: 0 0 0.5rem 0;
    letter-spacing: -0.025em;
}

.page-title p {
    font-size: 1.125rem;
    color: #cbd5e1;
    margin: 0;
    font-weight: 400;
}

.header-actions {
    display: flex;
    gap: 1rem;
    align-items: center;
}

.btn-back, .btn-delete {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    border: none;
    border-radius: 8px;
    font-size: 0.875rem;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.2s ease;
    cursor: pointer;
}

.btn-back {
    background: #f1f5f9;
    color: #374151;
}

.btn-back:hover {
    background: #e2e8f0;
    color: #1e293b;
}

.btn-delete {
    background: #dc2626;
    color: #ffffff;
}

.btn-delete:hover {
    background: #b91c1c;
}

.view-notice-content {
    padding: 2rem;
}

.content-box {
    background: white;
    border-radius: 12px;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1);
    border: 1px solid #e2e8f0;
    overflow: hidden;
    max-width: 800px;
    margin: 0 auto;
}

.notice-details {
    padding: 2rem;
}

.notice-header {
    margin-bottom: 2rem;
    padding-bottom: 1rem;
    border-bottom: 2px solid #e2e8f0;
}

.notice-title {
    font-size: 2rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0 0 1rem 0;
    line-height: 1.2;
}

.notice-meta {
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 0.875rem;
    color: #6b7280;
}

.notice-date {
    font-weight: 500;
}

.notice-author {
    font-style: italic;
}

.notice-content {
    margin-top: 1.5rem;
}

.notice-image {
    margin: 1.5rem 0;
    text-align: center;
}

.notice-img {
    max-width: 100%;
    height: auto;
    max-height: 400px;
    border-radius: 12px;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
}

.notice-description {
    font-size: 1rem;
    line-height: 1.7;
    color: #374151;
    white-space: pre-wrap;
}

/* Modal Styles */
.modal-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 1000;
}

.modal-content {
    background: white;
    border-radius: 12px;
    width: 90%;
    max-width: 400px;
    box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
}

.modal-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1.5rem;
    border-bottom: 1px solid #e2e8f0;
}

.modal-header h3 {
    margin: 0;
    font-size: 1.25rem;
    font-weight: 600;
    color: #1e293b;
}

.modal-close {
    background: none;
    border: none;
    font-size: 1.5rem;
    color: #6b7280;
    cursor: pointer;
    padding: 0;
    width: 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    transition: all 0.2s ease;
}

.modal-close:hover {
    background: #f1f5f9;
    color: #374151;
}

.modal-body {
    padding: 1.5rem;
}

.modal-body p {
    margin: 0;
    color: #4b5563;
    line-height: 1.6;
}

.modal-footer {
    display: flex;
    justify-content: flex-end;
    gap: 1rem;
    padding: 1.5rem;
    border-top: 1px solid #e2e8f0;
}

.btn-cancel, .btn-confirm-delete {
    padding: 0.75rem 1.5rem;
    border: none;
    border-radius: 8px;
    font-size: 0.875rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-cancel {
    background: #f1f5f9;
    color: #374151;
}

.btn-cancel:hover {
    background: #e2e8f0;
}

.btn-confirm-delete {
    background: #dc2626;
    color: #ffffff;
}

.btn-confirm-delete:hover {
    background: #b91c1c;
}

/* Responsive Design */
@media (max-width: 768px) {
    .header-content {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
    }
    
    .page-title h1 {
        font-size: 2rem;
    }
    
    .view-notice-content {
        padding: 1rem;
    }
    
    .notice-details {
        padding: 1.5rem;
    }
    
    .notice-title {
        font-size: 1.5rem;
    }
    
    .notice-meta {
        flex-direction: column;
        gap: 0.5rem;
        align-items: flex-start;
    }
    
    .header-actions {
        flex-direction: column;
        width: 100%;
    }
    
    .btn-back, .btn-delete {
        width: 100%;
        justify-content: center;
    }
}
</style>

<script>
// Delete notice functions
function deleteNotice(noticeId) {
    document.getElementById('deleteModal').style.display = 'flex';
}

function closeDeleteModal() {
    document.getElementById('deleteModal').style.display = 'none';
}

function confirmDelete() {
    // Create a form to submit DELETE request
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = `/notice/{{ $notice['noticeId'] }}`;
    
    // Add CSRF token
    const csrfToken = document.createElement('input');
    csrfToken.type = 'hidden';
    csrfToken.name = '_token';
    csrfToken.value = '{{ csrf_token() }}';
    form.appendChild(csrfToken);
    
    // Add method override for DELETE
    const methodField = document.createElement('input');
    methodField.type = 'hidden';
    methodField.name = '_method';
    methodField.value = 'DELETE';
    form.appendChild(methodField);
    
    document.body.appendChild(form);
    form.submit();
}

// Close modal when clicking outside
document.getElementById('deleteModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeDeleteModal();
    }
});
</script>
@endsection
