@extends('welcome')

@section('title', 'Team Management')

@section('content')
<div class="team-management-container">
    <div class="team-management-header">
        <div class="header-content">
            <div class="page-title">
                <h1>Team Management</h1>
                <p>Manage your team members, roles, and permissions</p>
            </div>
        </div>
    </div>
    
    <div class="team-management-content">
        <div class="content-box">
            <div class="action-bar">
                <div class="action-content">
                    <div class="page-title">
                        <h1>Team Members</h1>
                    </div>
                    <div class="action-buttons">
                        <div class="search-section">
                            <div class="search-container">
                                <svg class="search-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="11" cy="11" r="8"/>
                                    <path d="m21 21-4.35-4.35"/>
                                </svg>
                                <input type="text" class="search-input" placeholder="Search team members...">
                            </div>
                        </div>
                        <button class="btn-create" data-bs-toggle="modal" data-bs-target="#add-documents">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/>
                                <circle cx="9" cy="7" r="4"/>
                                <line x1="19" y1="8" x2="19" y2="14"/>
                                <line x1="22" y1="11" x2="16" y2="11"/>
                            </svg>
                            Add Team Member
                        </button>
                        <button class="btn-secondary" data-bs-toggle="modal" data-bs-target="#sorting">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M3 6h18"/>
                                <path d="M7 12h10"/>
                                <path d="M10 18h4"/>
                            </svg>
                            Sort
                        </button>
                        <button class="btn-secondary">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/>
                                <polyline points="7,10 12,15 17,10"/>
                                <line x1="12" y1="15" x2="12" y2="3"/>
                            </svg>
                            Export
                        </button>
                    </div>
                </div>
            </div>
            
            <div class="table-section">
                <div class="table-container">
                    <table class="team-management-table">
                        <thead class="table-header">
                            <tr>
                                <th>Action</th>
                                <th>Name</th>
                                <th>User ID</th>
                                <th>Notification Email</th>
                                <th>Assigned Vehicle</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody class="table-body">
                            <tr class="empty-row">
                                <td colspan="6">
                                    <div class="empty-state">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/>
                                            <circle cx="9" cy="7" r="4"/>
                                            <line x1="19" y1="8" x2="19" y2="14"/>
                                            <line x1="22" y1="11" x2="16" y2="11"/>
                                        </svg>
                                        <p>No team members found</p>
                                        <span>Add your first team member to get started</span>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function toggleSidebar() {
        const sidebar = document.querySelector('.sidebar');
        sidebar.classList.toggle('collapsed');
    }
</script>
<!-- Modern Add Team Member Modal -->
<div class="modal fade" id="add-documents" tabindex="-1" aria-labelledby="addTeamMemberModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="addTeamMemberModalLabel">Add Team Member</h4>
                <button type="button" class="modal-close" data-bs-dismiss="modal" aria-label="Close">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"/>
                        <line x1="6" y1="6" x2="18" y2="18"/>
                    </svg>
                </button>
            </div>
            <div class="modal-body">
                <form class="team-member-form" action="">
                    <div class="form-grid">
                        <div class="form-group">
                            <label for="role" class="form-label">Role *</label>
                            <select class="form-select" id="role" name="role" required>
                                <option value="">Select Role</option>
                                <option value="operator">Operator</option>
                                <option value="technician">Technician</option>
                                <option value="employee">Employee</option>
                                <option value="sub_admin">Sub Admin</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="name" class="form-label">Name *</label>
                            <input type="text" class="form-control" id="name" name="name" placeholder="Enter full name" required>
                        </div>
                        <div class="form-group">
                            <label for="user_id" class="form-label">User ID *</label>
                            <input type="text" class="form-control" id="user_id" name="user_id" placeholder="Enter user ID" required>
                        </div>
                        <div class="form-group">
                            <label for="password" class="form-label">Password *</label>
                            <input type="password" class="form-control" id="password" name="password" placeholder="Enter password" required>
                        </div>
                        <div class="form-group">
                            <label for="access_area" class="form-label">User Access Area *</label>
                            <select class="form-select" id="access_area" name="access_area" required>
                                <option value="">Select Access Area</option>
                                <option value="driving_licence">Driving Licence</option>
                                <option value="health_insurance">Health Insurance</option>
                                <option value="drug_test">Drug Test Certificate</option>
                                <option value="medical_cert">Medical Certificate</option>
                                <option value="id_card">ID Card</option>
                                <option value="miscellaneous">Miscellaneous</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="primary_site" class="form-label">Primary Site/Project *</label>
                            <select class="form-select" id="primary_site" name="primary_site" required>
                                <option value="">Select Primary Site</option>
                                <option value="default_site">Default Site</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="secondary_site" class="form-label">Secondary Site/Project</label>
                            <div class="input-with-select">
                                <input type="text" class="form-control" id="secondary_site" name="secondary_site" placeholder="Select secondary site/project" readonly>
                                <button type="button" class="btn-select" data-bs-toggle="modal" data-bs-target="#select-checklist">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M3 3h18v18H3zM9 9h6v6H9z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="mobile" class="form-label">Mobile</label>
                            <input type="tel" class="form-control" id="mobile" name="mobile" placeholder="Enter mobile number">
                        </div>
                        <div class="form-group">
                            <label for="email" class="form-label">Notification Email</label>
                            <input type="email" class="form-control" id="email" name="email" placeholder="Enter email address">
                        </div>
                        <div class="form-group">
                            <label class="form-label">Make Approver</label>
                            <div class="checkbox-group">
                                <label class="checkbox-label">
                                    <input type="radio" class="checkbox-custom" name="approver" value="yes" checked>
                                    <span class="checkmark"></span>
                                    Yes
                                </label>
                                <label class="checkbox-label">
                                    <input type="radio" class="checkbox-custom" name="approver" value="no">
                                    <span class="checkmark"></span>
                                    No
                                </label>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Profile Image</label>
                            <button type="button" class="btn-upload" data-bs-toggle="modal" data-bs-target="#select-image">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M14.5 4h-5L7 7H4a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-3l-2.5-3z"/>
                                    <circle cx="12" cy="13" r="3"/>
                                </svg>
                                Upload Image
                            </button>
                        </div>
                    </div>
                    
                    <div class="vehicle-assignment-section">
                        <div class="section-header">
                            <h3>Vehicle Assignment</h3>
                            <button type="button" class="btn-select-vehicle" data-bs-toggle="modal" data-bs-target="#Parts-Material">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/>
                                    <circle cx="9" cy="7" r="4"/>
                                    <line x1="19" y1="8" x2="19" y2="14"/>
                                    <line x1="22" y1="11" x2="16" y2="11"/>
                                </svg>
                                Select Vehicle
                            </button>
                        </div>
                        <div class="assigned-vehicles">
                            <div class="empty-state">
                                <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/>
                                    <circle cx="9" cy="7" r="4"/>
                                    <line x1="19" y1="8" x2="19" y2="14"/>
                                    <line x1="22" y1="11" x2="16" y2="11"/>
                                </svg>
                                <p>No vehicles assigned</p>
                                <span>Click "Select Vehicle" to assign vehicles</span>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-cancel" data-bs-dismiss="modal">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"/>
                        <line x1="6" y1="6" x2="18" y2="18"/>
                    </svg>
                    Cancel
                </button>
                <button type="submit" class="btn-save" form="team-member-form">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/>
                        <circle cx="9" cy="7" r="4"/>
                        <line x1="19" y1="8" x2="19" y2="14"/>
                        <line x1="22" y1="11" x2="16" y2="11"/>
                    </svg>
                    Add Team Member
                </button>
            </div>
        </div>
    </div>
</div>
<!-- Modern Vehicle Selection Modal -->
<div class="modal fade" id="Parts-Material" tabindex="-1" aria-labelledby="selectVehicleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="selectVehicleModalLabel">Select Vehicle</h4>
                <button type="button" class="modal-close" data-bs-dismiss="modal" aria-label="Close">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"/>
                        <line x1="6" y1="6" x2="18" y2="18"/>
                    </svg>
                </button>
            </div>
            <div class="modal-body">
                <div class="vehicle-selection-header">
                    <h3>Vehicle Inventory</h3>
                    <div class="action-buttons">
                        <div class="search-section">
                            <div class="search-container">
                                <svg class="search-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="11" cy="11" r="8"/>
                                    <path d="m21 21-4.35-4.35"/>
                                </svg>
                                <input type="text" class="search-input" placeholder="Search vehicles...">
                            </div>
                        </div>
                        <button class="btn-secondary" data-bs-toggle="modal" data-bs-target="#part-sorting">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M3 6h18"/>
                                <path d="M7 12h10"/>
                                <path d="M10 18h4"/>
                            </svg>
                            Sort
                        </button>
                    </div>
                </div>
                <div class="table-section">
                    <div class="table-container">
                        <table class="vehicle-selection-table">
                            <thead class="table-header">
                                <tr>
                                    <th>Vehicle Number</th>
                                    <th>Category</th>
                                    <th>Vehicle Name</th>
                                    <th>Location</th>
                                </tr>
                            </thead>
                            <tbody class="table-body">
                                <tr class="empty-row">
                                    <td colspan="4">
                                        <div class="empty-state">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/>
                                                <circle cx="9" cy="7" r="4"/>
                                                <line x1="19" y1="8" x2="19" y2="14"/>
                                                <line x1="22" y1="11" x2="16" y2="11"/>
                                            </svg>
                                            <p>No vehicles found</p>
                                            <span>No vehicles available for assignment</span>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-cancel" data-bs-dismiss="modal">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"/>
                        <line x1="6" y1="6" x2="18" y2="18"/>
                    </svg>
                    Cancel
                </button>
                <button type="button" class="btn-save" data-bs-dismiss="modal">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M20 6L9 17l-5-5"/>
                    </svg>
                    Done
                </button>
            </div>
        </div>
    </div>
</div>
<!-- Modern Sorting Modal -->
<div class="modal fade" id="sorting" tabindex="-1" aria-labelledby="sortingModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="sortingModalLabel">Sorting Options</h4>
                <button type="button" class="modal-close" data-bs-dismiss="modal" aria-label="Close">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"/>
                        <line x1="6" y1="6" x2="18" y2="18"/>
                    </svg>
                </button>
            </div>
            <div class="modal-body">
                <form class="sorting-form" action="">
                    <div class="form-section">
                        <h3>Sort Order</h3>
                        <div class="radio-group">
                            <label class="radio-label">
                                <input type="radio" class="radio-custom" name="sort_order" value="ascending" checked>
                                <span class="radiomark"></span>
                                Ascending
                            </label>
                            <label class="radio-label">
                                <input type="radio" class="radio-custom" name="sort_order" value="descending">
                                <span class="radiomark"></span>
                                Descending
                            </label>
                        </div>
                    </div>
                    <div class="form-section">
                        <h3>Sort By</h3>
                        <div class="radio-group">
                            <label class="radio-label">
                                <input type="radio" class="radio-custom" name="sort_by" value="name" checked>
                                <span class="radiomark"></span>
                                Name
                            </label>
                            <label class="radio-label">
                                <input type="radio" class="radio-custom" name="sort_by" value="user_id">
                                <span class="radiomark"></span>
                                User ID
                            </label>
                            <label class="radio-label">
                                <input type="radio" class="radio-custom" name="sort_by" value="email">
                                <span class="radiomark"></span>
                                Notification Email
                            </label>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-cancel" data-bs-dismiss="modal">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"/>
                        <line x1="6" y1="6" x2="18" y2="18"/>
                    </svg>
                    Cancel
                </button>
                <button type="reset" class="btn-secondary" form="sorting-form">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M3 12a9 9 0 1 0 9-9 9.75 9.75 0 0 0-6.74 2.74L3 8"/>
                        <path d="M3 3v5h5"/>
                    </svg>
                    Reset
                </button>
                <button type="submit" class="btn-save" form="sorting-form">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M20 6L9 17l-5-5"/>
                    </svg>
                    Apply
                </button>
            </div>
        </div>
    </div>
</div>
<!-- Part Sorting Popup modals -->
<div class="modal" id="part-sorting">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Sorting</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form action="">
                    <form action="">
                        <h1>Sort Order</h1>
                        <div class="form-check">
                            <input type="radio" class="form-check-input" id="radio1" name="optradio" value="Ascending" checked>
                            <label class="form-check-label" for="radio1">Ascending</label>
                        </div>
                        <div class="form-check">
                            <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Descending">
                            <label class="form-check-label" for="radio2">Descending</label>
                        </div>
                    </form>
                    <h1>Sort By</h1>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Vehicle Number" checked>
                        <label class="form-check-label" for="radio2">Vehicle Number</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Start Date">
                        <label class="form-check-label" for="radio2">Category</label>
                    </div>
                    <div class="form-check">
                        <input type="radio" class="form-check-input" id="radio2" name="optradio" value="Vehicle Number">
                        <label class="form-check-label" for="radio2">Vehicle Name</label>
                    </div>
                    <div class="row my-3 align-items-center justify-content-center">
                        <button type="submit" class="save btn btn-danger col-md-4 mx-2">Ok</button>
                        <button type="reset" class="save btn btn-danger col-md-4 mx-2">Reset</button>
                        <!-- Modal footer -->
                        <div class="modal-footer col-md-4 p-0">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Upload Receipt Image popup -->
<div class="modal search-popup" id="select-image">
    <div class="modal-dialog" style="">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Upload Image</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form class="form-inline" action="">
                    <div class="input-group">
                        <input class="form-control" type="file" id="" placeholder="Choose a file for uploading...">
                    </div>
                    <div class="row my-3 align-items-center justify-content-center">
                        <button type="button" class="save btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 5v9m-5 0H5a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-4a1 1 0 0 0-1-1h-2M8 9l4-5l4 5m1 8h.01" />
                            </svg>Upload</button>
                        <!-- Modal footer -->
                        <div class="modal-footer col-md-4 p-0 w-auto">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                    <path fill="currentColor" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                                </svg>Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Select Participants popup -->
<div class="modal search-popup" id="select-checklist">
    <div class="modal-dialog" style="">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Select Site/Project</h4>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <form class="form-inline" action="">
                    <div class="input-group searchwicon">
                        <div class="input-group-text br-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                <path fill="currentColor" d="M15.5 14h-.79l-.28-.27A6.47 6.47 0 0 0 16 9.5A6.5 6.5 0 1 0 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5S14 7.01 14 9.5S11.99 14 9.5 14" />
                            </svg>
                        </div>
                        <input type="text" class="form-control" placeholder="Search">
                    </div>
                    <span class="empty-data">No Data</span>
                    <div class="row my-3 align-items-center justify-content-center">
                        <button type="button" class="save btn btn-danger" data-bs-dismiss="modal">Select</button>
                        <!-- Modal footer -->
                        <div class="modal-footer col-md-4 p-0 w-auto">
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                    <path fill="currentColor" fill-rule="evenodd" d="M7.345 4.017a42.3 42.3 0 0 1 9.31 0c1.713.192 3.095 1.541 3.296 3.26a40.7 40.7 0 0 1 0 9.446c-.201 1.719-1.583 3.068-3.296 3.26a42.3 42.3 0 0 1-9.31 0c-1.713-.192-3.095-1.541-3.296-3.26a40.7 40.7 0 0 1 0-9.445a3.734 3.734 0 0 1 3.295-3.26M8.47 8.47a.75.75 0 0 1 1.06 0L12 10.94l2.47-2.47a.75.75 0 1 1 1.06 1.06L13.06 12l2.47 2.47a.75.75 0 0 1-1.06 1.06L12 13.06l-2.47 2.47a.75.75 0 1 1-1.06-1.06L10.94 12L8.47 9.53a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />
                                </svg>Cancel</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    var dropdown = document.getElementsByClassName("dropdown-btn");
    var i;

    for (i = 0; i < dropdown.length; i++) {
        dropdown[i].addEventListener("click", function() {
            this.classList.toggle("active");
            var dropdownContent = this.nextElementSibling;
            if (dropdownContent.style.display === "block") {
                dropdownContent.style.display = "none";
            } else {
                dropdownContent.style.display = "block";
            }
        });
    }
</script>
@endsection

<style>
/* Import Google Fonts for better typography */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* ===== MAIN CONTAINER ===== */
.team-management-container {
    min-height: 100vh;
    background: #f8fafc;
    font-family: 'Inter', sans-serif;
    padding: 0;
    margin: 0;
    overflow-x: hidden;
    overflow-y: visible;
}

/* ===== HEADER STYLES ===== */
.team-management-header {
    background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
    padding: 2rem 0;
    margin-bottom: 0;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    display: none;
}

.header-content {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 2rem;
}

.page-title h1 {
    font-size: 2.5rem;
    font-weight: 700;
    color: #ffffff;
    margin: 0 0 0.5rem 0;
    letter-spacing: -0.025em;
}

.page-title p {
    font-size: 1.125rem;
    color: #cbd5e1;
    margin: 0;
    font-weight: 400;
}

/* ===== MAIN CONTENT ===== */
.team-management-content {
    min-height: 100vh;
}

.content-box {
    background: white;
    padding: 32px 32px 32px 40px;
    border-radius: 0;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    border: 1px solid #e2e8f0;
    font-family: 'Inter', sans-serif;
    margin-bottom: 2rem;
}

/* ===== ACTION BAR ===== */
.action-bar {
    background: transparent;
    border: none;
    border-radius: 0;
    padding: 0;
    margin-bottom: 32px;
    box-shadow: none;
}

.action-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 1rem;
    flex-wrap: wrap;
}

.page-title h1, .page-title h2 {
    color: #0f172a;
    font-weight: 700;
    font-size: 32px;
    line-height: 1.2;
    letter-spacing: -0.025em;
    margin: 0;
}

.page-title h2 {
    font-size: 24px;
}

.action-buttons {
    display: flex;
    align-items: center;
    gap: 1rem;
    flex-wrap: wrap;
}

/* ===== SEARCH SECTION ===== */
.search-section {
    position: relative;
}

.search-container {
    position: relative;
    display: flex;
    align-items: center;
}

.search-icon {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #64748b;
    pointer-events: none;
    z-index: 2;
}

.search-input {
    padding: 0.75rem 1rem 0.75rem 3rem;
    border: 2px solid #e2e8f0;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 500;
    color: #1e293b;
    background: #ffffff;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
    min-width: 300px;
}

.search-input:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.search-input::placeholder {
    color: #94a3b8;
    font-weight: 400;
}

/* ===== BUTTON STYLES ===== */
.btn-create {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: #0055a5;
    color: #ffffff;
    border: none;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    /* font-family: 'Inter', sans-serif; */
    cursor: pointer;
    transition: all 0.2s ease;
    /* box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2); */
    white-space: nowrap;
}

.btn-create:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-1px);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    color: black !important;
}

.btn-secondary {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: #ffffff;
    color: #64748b;
    border: 2px solid #e2e8f0;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
    white-space: nowrap;
}

.btn-secondary:hover {
    background: #f8fafc;
    border-color: #cbd5e1;
    color: #475569;
    transform: translateY(-1px);
}

/* ===== TABLE STYLES ===== */
.table-section {
    margin-top: 2rem;
}

.table-container {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    overflow: hidden;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
}

.team-management-table {
    width: 100%;
    border-collapse: collapse;
    font-family: 'Inter', sans-serif;
}

.table-header {
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
}

.table-header th {
    padding: 1rem 1.5rem;
    text-align: left;
    font-weight: 600;
    color: #374151;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    border-bottom: 2px solid #e2e8f0;
}

.table-body tr {
    border-bottom: 1px solid #f1f5f9;
    transition: background-color 0.2s ease;
}

.table-body tr:hover {
    background: #f8fafc;
}

.table-body td {
    padding: 1rem 1.5rem;
    color: #1e293b;
    font-size: 0.875rem;
    font-weight: 500;
}

/* ===== EMPTY STATE ===== */
.empty-state {
    padding: 3rem 2rem;
    text-align: center;
    background: #f8fafc;
    border: 2px dashed #cbd5e1;
    border-radius: 0;
    min-height: 200px;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    gap: 1rem;
}

.empty-state svg {
    color: #cbd5e1;
}

.empty-state p {
    color: #64748b;
    font-size: 1rem;
    margin: 0;
    font-weight: 600;
}

.empty-state span {
    color: #94a3b8;
    font-size: 0.875rem;
    margin: 0;
    font-weight: 400;
}

/* ===== MODAL STYLES ===== */
.modal {
    font-family: 'Inter', sans-serif;
}

.modal.show {
    display: block;
}

.modal.fade .modal-dialog {
    transition: transform 0.3s ease-out;
    transform: translate(0, -50px);
}

.modal.show .modal-dialog {
    transform: none;
}

.modal-dialog {
    max-width: 100%;
    margin: 1.75rem auto;
}

.modal-dialog.modal-xl {
    max-width: 1140px;
}

.modal-dialog.modal-lg {
    max-width: 800px;
}

.modal-content {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
}

.modal-header {
    background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
    color: #ffffff;
    border-bottom: 1px solid #e2e8f0;
    padding: 1.5rem 2rem;
    border-radius: 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.modal-title {
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0;
    color: #ffffff;
}

.modal-close {
    background: none;
    border: none;
    color: #ffffff;
    font-size: 1.5rem;
    cursor: pointer;
    padding: 0;
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 0;
    transition: background-color 0.2s;
}

.modal-close:hover {
    background-color: rgba(255, 255, 255, 0.1);
}

.modal-body {
    padding: 2rem;
}

.modal-footer {
    background: #f8fafc;
    border-top: 1px solid #e2e8f0;
    padding: 1.5rem 2rem;
    display: flex;
    justify-content: flex-end;
    gap: 1rem;
    border-radius: 0;
}

/* ===== FORM STYLES ===== */
.team-member-form {
    width: 100%;
}

.form-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.form-group {
    display: flex;
    flex-direction: column;
}

.form-label {
    font-weight: 600;
    color: #374151;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
}

.form-control, .form-select {
    border: 2px solid #e2e8f0;
    border-radius: 0;
    padding: 0.75rem 1rem;
    font-size: 0.875rem;
    font-weight: 500;
    color: #1e293b;
    background: #ffffff;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
}

.form-control:focus, .form-select:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.form-control::placeholder {
    color: #94a3b8;
    font-weight: 400;
}

.input-with-select {
    position: relative;
    display: flex;
}

.input-with-select .form-control {
    flex: 1;
    border-right: none;
}

.btn-select {
    background: #f8fafc;
    border: 2px solid #e2e8f0;
    border-left: none;
    padding: 0.75rem;
    cursor: pointer;
    transition: all 0.2s ease;
    display: flex;
    align-items: center;
    justify-content: center;
}

.btn-select:hover {
    background: #f1f5f9;
    border-color: #cbd5e1;
}

/* ===== CHECKBOX AND RADIO STYLES ===== */
.checkbox-group, .radio-group {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.checkbox-label, .radio-label {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    cursor: pointer;
    font-size: 0.875rem;
    font-weight: 500;
    color: #374151;
}

.checkbox-custom, .radio-custom {
    display: none;
}

.checkmark, .radiomark {
    width: 20px;
    height: 20px;
    border: 2px solid #d1d5db;
    border-radius: 0;
    position: relative;
    transition: all 0.2s ease;
}

.radiomark {
    border-radius: 50%;
}

.checkbox-custom:checked + .checkmark,
.radio-custom:checked + .radiomark {
    background: #3b82f6;
    border-color: #3b82f6;
}

.checkbox-custom:checked + .checkmark::after {
    content: '';
    position: absolute;
    left: 6px;
    top: 2px;
    width: 6px;
    height: 10px;
    border: solid #ffffff;
    border-width: 0 2px 2px 0;
    transform: rotate(45deg);
}

.radio-custom:checked + .radiomark::after {
    content: '';
    position: absolute;
    left: 50%;
    top: 50%;
    width: 8px;
    height: 8px;
    background: #ffffff;
    border-radius: 50%;
    transform: translate(-50%, -50%);
}

/* ===== VEHICLE ASSIGNMENT SECTION ===== */
.vehicle-assignment-section {
    margin-top: 2rem;
    padding-top: 2rem;
    border-top: 2px solid #e2e8f0;
}

.section-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1.5rem;
}

.section-header h3 {
    font-size: 1.25rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
}

.btn-select-vehicle {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: #ffffff;
    border: none;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
    box-shadow: 0 2px 4px rgba(16, 185, 129, 0.2);
}

.btn-select-vehicle:hover {
    background: linear-gradient(135deg, #059669 0%, #047857 100%);
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(16, 185, 129, 0.3);
}

.assigned-vehicles {
    min-height: 120px;
}

/* ===== UPLOAD BUTTON ===== */
.btn-upload {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: #ffffff;
    color: #64748b;
    border: 2px solid #e2e8f0;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-upload:hover {
    background: #f8fafc;
    border-color: #cbd5e1;
    color: #475569;
}

/* ===== MODAL FOOTER BUTTONS ===== */
.btn-save {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    color: #ffffff;
    border: none;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
    box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2);
}

.btn-save:hover {
    background: linear-gradient(135deg, #1d4ed8 0%, #1e40af 100%);
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(59, 130, 246, 0.3);
}

.btn-cancel {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: #ffffff;
    color: #64748b;
    border: 2px solid #e2e8f0;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-cancel:hover {
    background: #f8fafc;
    border-color: #cbd5e1;
    color: #475569;
}

/* ===== VEHICLE SELECTION MODAL ===== */
.vehicle-selection-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1.5rem;
    padding-bottom: 1rem;
    border-bottom: 2px solid #e2e8f0;
}

.vehicle-selection-header h3 {
    font-size: 1.25rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0;
}

.vehicle-selection-table {
    width: 100%;
    border-collapse: collapse;
    font-family: 'Inter', sans-serif;
}

/* ===== SORTING MODAL ===== */
.sorting-form, .vehicle-sorting-form {
    width: 100%;
}

.form-section {
    margin-bottom: 2rem;
}

.form-section h3 {
    font-size: 1.125rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0 0 1rem 0;
    padding-bottom: 0.5rem;
    border-bottom: 1px solid #e2e8f0;
}

/* ===== IMAGE UPLOAD MODAL ===== */
.image-upload-form {
    width: 100%;
}

.upload-section {
    margin-bottom: 2rem;
}

.upload-area {
    border: 2px dashed #cbd5e1;
    border-radius: 0;
    padding: 3rem 2rem;
    text-align: center;
    background: #f8fafc;
    transition: all 0.2s ease;
    cursor: pointer;
}

.upload-area:hover {
    border-color: #3b82f6;
    background: #f0f9ff;
}

.upload-area svg {
    color: #cbd5e1;
    margin-bottom: 1rem;
}

.upload-area p {
    color: #64748b;
    font-size: 1rem;
    font-weight: 600;
    margin: 0 0 0.5rem 0;
}

.upload-area span {
    color: #94a3b8;
    font-size: 0.875rem;
    margin: 0 0 1rem 0;
    display: block;
}

.file-input {
    display: none;
}

.file-label {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    color: #ffffff;
    border: none;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
    box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2);
}

.file-label:hover {
    background: linear-gradient(135deg, #1d4ed8 0%, #1e40af 100%);
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(59, 130, 246, 0.3);
}

/* ===== SITE SELECTION MODAL ===== */
.site-selection-form {
    width: 100%;
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 1200px) {
    .team-management-container {
        padding: 0;
    }
    
    .team-management-content {
        padding: 20px 0 0 14px;
    }
    
    .content-box {
        padding: 28px 28px 28px 36px;
        margin-left: 0.5rem;
    }
    
    .action-content {
        flex-direction: column;
        align-items: stretch;
        gap: 16px;
    }
    
    .action-buttons {
        justify-content: center;
        flex-wrap: wrap;
    }
    
    .search-input {
        min-width: 280px;
    }
    
    .form-grid {
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 1.25rem;
    }
    
    .modal-dialog {
        margin: 1rem;
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 1.25rem 1.75rem;
    }
}

@media (max-width: 992px) {
    .team-management-header {
        padding: 1.5rem 0;
    }
    
    .page-title h1 {
        font-size: 2.25rem;
    }
    
    .page-title h2 {
        font-size: 1.75rem;
    }
    
    .action-bar {
        padding: 0;
        margin-bottom: 24px;
    }
    
    .action-buttons {
        gap: 8px;
    }
    
    .action-buttons button {
        padding: 8px 12px;
        font-size: 13px;
    }
    
    .search-input {
        min-width: 250px;
    }
    
    .form-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .table-container {
        overflow-x: auto;
    }
    
    .team-management-table {
        min-width: 600px;
    }
    
    .table-header th:first-child,
    .table-body td:first-child {
        position: sticky;
        left: 0;
        background: #f8fafc;
        z-index: 1;
    }
    
    .modal-dialog {
        margin: 0.5rem;
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 1rem 1.5rem;
    }
    
    .checkbox-group, .radio-group {
        flex-direction: column;
        gap: 0.75rem;
    }
    
    .section-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
}

@media (max-width: 768px) {
    .header-content {
        padding: 0 1rem;
    }
    
    .team-management-content {
        padding: 1rem 1rem 1rem 2rem;
    }
    
    .content-box {
        padding: 1.5rem 1.5rem 1.5rem 2rem;
        margin-left: 0.25rem;
    }
    
    .page-title h1 {
        font-size: 2rem;
    }
    
    .page-title h2 {
        font-size: 1.5rem;
    }
    
    .action-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 1.5rem;
    }
    
    .action-buttons {
        width: 100%;
        justify-content: flex-start;
        flex-wrap: wrap;
    }
    
    .search-section {
        width: 100%;
        margin-bottom: 1rem;
    }
    
    .search-input {
        min-width: 250px;
        width: 100%;
    }
    
    .form-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .table-container {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }
    
    .team-management-table {
        min-width: 500px;
    }
    
    .table-header th:first-child,
    .table-body td:first-child {
        position: sticky;
        left: 0;
        background: #f8fafc;
        z-index: 1;
    }
    
    .modal-dialog {
        margin: 0.5rem;
    }
    
    .modal-dialog.modal-xl {
        max-width: calc(100% - 1rem);
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 1rem 1.5rem;
    }
    
    .checkbox-group, .radio-group {
        flex-direction: column;
        gap: 0.75rem;
    }
    
    .section-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
    
    .vehicle-selection-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
    
    .vehicle-selection-header .action-buttons {
        width: 100%;
    }
}

@media (max-width: 576px) {
    .team-management-content {
        padding: 0.75rem 0.75rem 0.75rem 1.5rem;
    }
    
    .content-box {
        padding: 1rem 1rem 1rem 1.5rem;
        margin-left: 0.25rem;
    }
    
    .page-title h1 {
        font-size: 1.75rem;
    }
    
    .page-title h2 {
        font-size: 1.25rem;
    }
    
    .action-buttons {
        flex-direction: column;
        gap: 0.75rem;
    }
    
    .action-buttons button {
        width: 100%;
        justify-content: center;
        padding: 12px 16px;
        font-size: 14px;
    }
    
    .search-input {
        min-width: 200px;
        width: 100%;
        padding: 10px 12px 10px 2.5rem;
        font-size: 14px;
    }
    
    .form-grid {
        grid-template-columns: 1fr;
        gap: 0.75rem;
    }
    
    .form-group {
        margin-bottom: 1rem;
    }
    
    .form-control, .form-select {
        padding: 10px 12px;
        font-size: 14px;
    }
    
    .table-container {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }
    
    .team-management-table {
        min-width: 450px;
    }
    
    .table-header th,
    .table-body td {
        padding: 0.75rem 1rem;
        font-size: 0.8rem;
    }
    
    .table-header th:first-child,
    .table-body td:first-child {
        position: sticky;
        left: 0;
        background: #f8fafc;
        z-index: 1;
    }
    
    .modal-dialog {
        margin: 0.25rem;
        max-width: calc(100% - 0.5rem);
    }
    
    .modal-dialog.modal-xl {
        max-width: calc(100% - 0.5rem);
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 0.75rem 1rem;
    }
    
    .modal-title {
        font-size: 1.25rem;
    }
    
    .checkbox-group, .radio-group {
        flex-direction: column;
        gap: 0.5rem;
    }
    
    .section-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.75rem;
    }
    
    .vehicle-selection-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.75rem;
    }
    
    .vehicle-selection-header .action-buttons {
        width: 100%;
    }
    
    .vehicle-selection-header .search-section {
        width: 100%;
    }
    
    .vehicle-selection-header .search-input {
        width: 100%;
    }
    
    .empty-state {
        padding: 2rem 1rem;
        min-height: 150px;
    }
    
    .empty-state svg {
        width: 32px;
        height: 32px;
    }
    
    .empty-state p {
        font-size: 0.875rem;
    }
    
    .empty-state span {
        font-size: 0.75rem;
    }
}

@media (max-width: 480px) {
    .team-management-content {
        padding: 0.5rem 0.5rem 0.5rem 1rem;
    }
    
    .content-box {
        padding: 0.75rem 0.75rem 0.75rem 1rem;
        margin-left: 0.25rem;
    }
    
    .page-title h1 {
        font-size: 1.5rem;
    }
    
    .page-title h2 {
        font-size: 1.125rem;
    }
    
    .action-buttons button {
        padding: 10px 14px;
        font-size: 13px;
    }
    
    .search-input {
        min-width: 180px;
        padding: 8px 10px 8px 2.25rem;
        font-size: 13px;
    }
    
    .form-control, .form-select {
        padding: 8px 10px;
        font-size: 13px;
    }
    
    .table-header th,
    .table-body td {
        padding: 0.5rem 0.75rem;
        font-size: 0.75rem;
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 0.5rem 0.75rem;
    }
    
    .modal-title {
        font-size: 1.125rem;
    }
    
    .empty-state {
        padding: 1.5rem 0.75rem;
        min-height: 120px;
    }
    
    .empty-state svg {
        width: 24px;
        height: 24px;
    }
    
    .empty-state p {
        font-size: 0.8rem;
    }
    
    .empty-state span {
        font-size: 0.7rem;
    }
}

/* ===== LANDSCAPE ORIENTATION ===== */
@media (max-width: 768px) and (orientation: landscape) {
    .team-management-content {
        padding: 0.5rem 0.5rem 0.5rem 1rem;
    }
    
    .content-box {
        padding: 1rem 1rem 1rem 1.5rem;
        margin-left: 0.25rem;
    }
    
    .modal-dialog {
        margin: 0.25rem;
        max-width: calc(100% - 0.5rem);
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 0.75rem 1rem;
    }
}

/* ===== TOUCH DEVICES ===== */
@media (hover: none) and (pointer: coarse) {
    .action-buttons button,
    .btn-create,
    .btn-secondary,
    .btn-save,
    .btn-cancel,
    .btn-select-vehicle,
    .btn-upload {
        min-height: 44px;
        padding: 12px 16px;
    }
    
    .form-control,
    .form-select {
        min-height: 44px;
        padding: 12px 16px;
    }
    
    .search-input {
        min-height: 44px;
        padding: 12px 16px 12px 3rem;
    }
    
    .modal-close {
        min-width: 44px;
        min-height: 44px;
    }
    
    .checkbox-label,
    .radio-label {
        min-height: 44px;
        padding: 8px 0;
    }
}

/* ===== ACCESSIBILITY ===== */
@media (prefers-reduced-motion: reduce) {
    * {
        animation-duration: 0.01ms !important;
        animation-iteration-count: 1 !important;
        transition-duration: 0.01ms !important;
    }
}

/* ===== FOCUS STYLES ===== */
button:focus-visible,
input:focus-visible,
select:focus-visible {
    outline: 2px solid #3b82f6;
    outline-offset: 2px;
}

/* ===== PRINT STYLES ===== */
@media print {
    .action-bar,
    .modal {
        display: none !important;
    }
    
    .team-management-container {
        background: white;
    }
    
    .team-management-header {
        background: white;
        color: black;
    }
}
</style>

<script>
// Modern Team Management Functionality
document.addEventListener('DOMContentLoaded', function() {
    // Search functionality
    const searchInput = document.querySelector('.search-input');
    if (searchInput) {
        searchInput.addEventListener('input', function(e) {
            const searchTerm = e.target.value.toLowerCase();
            // Add search logic here
            console.log('Searching for:', searchTerm);
        });
    }
    
    // Form validation
    const teamMemberForm = document.querySelector('.team-member-form');
    if (teamMemberForm) {
        teamMemberForm.addEventListener('submit', function(e) {
            e.preventDefault();
            // Add form submission logic here
            console.log('Form submitted');
        });
    }
    
    // File upload handling
    const fileInput = document.querySelector('.file-input');
    if (fileInput) {
        fileInput.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                console.log('File selected:', file.name);
            }
        });
    }
    
    // Modal handling
    const modals = document.querySelectorAll('.modal');
    modals.forEach(modal => {
        modal.addEventListener('hidden.bs.modal', function() {
            // Reset form when modal is closed
            const form = this.querySelector('form');
            if (form) {
                form.reset();
            }
        });
    });
});
</script>