@extends('welcome')

@section('title', 'Do Inspection')

@section('content')
<div class="do-inspection-container" role="main" aria-label="Vehicle Inspection Checklist">
    <!-- Header Section -->
    <header class="inspection-header" role="banner">
        <div class="header-content">
            <div class="page-title">
                <h1>2. Do Inspection</h1>
                <p>Complete the vehicle inspection checklist by examining each component</p>
            </div>
        </div>
    </header>

    <!-- Inspection Table Section -->
    <section class="inspection-table-section" aria-labelledby="inspection-title">
        <div class="table-container">
            <table class="inspection-table" role="table" aria-label="Vehicle Inspection Checklist">
                <thead class="table-header" role="rowgroup">
                    <tr role="row">
                        <th role="columnheader" scope="col">Inspection Item</th>
                        <th class="text-center ms-auto" role="columnheader" scope="col">Action</th>
                        <th class="text-center" role="columnheader" scope="col">Result</th>
                        <th class="text-center" role="columnheader" scope="col">Note</th>
                        <th class="text-center" role="columnheader" scope="col">Image</th>
                    </tr>
                </thead>
                <tbody class="table-body" role="rowgroup">
                    <!-- Body Section -->
                    <tr class="expandable-row custom-toggle" data-target=".body-section" aria-expanded="false" role="row" tabindex="0" aria-label="Body inspection section">
                        <td class="section-header-cell" role="cell">
                            <div class="section-header">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="toggle-icon" aria-hidden="true">
                                    <path d="M6 9l6 6 6-6"/>
                                </svg>
                                <span class="section-title">Body</span>
                            </div>
                        </td>
                        <td class="text-center" role="cell">-</td>
                        <td class="text-center" role="cell">-</td>
                        <td class="text-center" role="cell">-</td>
                        <td class="text-center" role="cell">-</td>
                    </tr>
                    <tr class="collapse nested-row body-section" id="body-section1" role="row">
                        <td class="item-cell" role="cell">Air, Electrical, Hydraulic Lines</td>
                        <td class="text-center" role="cell">
                            <button class="btn-inspect" type="button" onclick="openModal()" aria-label="Inspect Air, Electrical, Hydraulic Lines">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                    <polyline points="14,2 14,8 20,8"/>
                                    <line x1="16" y1="13" x2="8" y2="13"/>
                                    <line x1="16" y1="17" x2="8" y2="17"/>
                                </svg>
                                Inspect
                            </button>
                        </td>
                        <td class="text-center" role="cell">
                            <div class="status-indicator">
                                <span class="status-text" aria-live="polite">Pending</span>
                            </div>
                        </td>
                        <td class="text-center" role="cell">
                            <button class="btn-note" onclick="openModal()" aria-label="Add note for Air, Electrical, Hydraulic Lines">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                    <polyline points="14,2 14,8 20,8"/>
                                    <line x1="16" y1="13" x2="8" y2="13"/>
                                    <line x1="16" y1="17" x2="8" y2="17"/>
                                </svg>
                            </button>
                        </td>
                        <td class="text-center" role="cell">
                            <button class="btn-image" onclick="openModal()" aria-label="Add image for Air, Electrical, Hydraulic Lines">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                                    <rect x="3" y="3" width="18" height="18" rx="2" ry="2"/>
                                    <circle cx="8.5" cy="8.5" r="1.5"/>
                                    <polyline points="21,15 16,10 5,21"/>
                                </svg>
                            </button>
                        </td>
                    </tr>
                    <tr class="collapse nested-row body-section" id="body-section2">
                        <td class="item-cell">Pinte Hook</td>
                        <td class="text-center">
                            <button class="btn-inspect" type="button" onclick="openModal()">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                    <polyline points="14,2 14,8 20,8"/>
                                    <line x1="16" y1="13" x2="8" y2="13"/>
                                    <line x1="16" y1="17" x2="8" y2="17"/>
                                </svg>
                                Inspect
                            </button>
                        </td>
                        <td class="text-center">
                            <div class="status-indicator">
                                <span class="status-text">Pending</span>
                            </div>
                        </td>
                        <td class="text-center">
                            <button class="btn-note" onclick="openModal()">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                    <polyline points="14,2 14,8 20,8"/>
                                    <line x1="16" y1="13" x2="8" y2="13"/>
                                    <line x1="16" y1="17" x2="8" y2="17"/>
                                </svg>
                            </button>
                        </td>
                        <td class="text-center">
                            <button class="btn-image" onclick="openModal()">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <rect x="3" y="3" width="18" height="18" rx="2" ry="2"/>
                                    <circle cx="8.5" cy="8.5" r="1.5"/>
                                    <polyline points="21,15 16,10 5,21"/>
                                </svg>
                            </button>
                        </td>
                    </tr>

            <!-- Brake, Wheel and Tire Section -->
            <tr class="do-inspection-expandable-row custom-toggle" data-target=".do-inspection-brake-section" aria-expanded="false">
                <td class="section-header-cell">
                    <div class="section-header">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="do-inspection-toggle-icon">
                            <path d="M6 9l6 6 6-6"/>
                        </svg>
                        <span class="section-title">Brake, Wheel and Tire</span>
                    </div>
                </td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
            </tr>
            <tr class="collapse do-inspection-nested-row do-inspection-brake-section" id="do-inspection-brake-section1">
                <td>Drives</td>
                <td>
                    <button class="do-inspection-inspect-button" type="button" onclick="openModal()">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                            <g fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                <path d="M20 12V5.749a.6.6 0 0 0-.176-.425l-3.148-3.148A.6.6 0 0 0 16.252 2H4.6a.6.6 0 0 0-.6.6v18.8a.6.6 0 0 0 .6.6H11M8 10h8M8 6h4m-4 8h3m9.5 6.5L22 22" />
                                <path d="M15 18a3 3 0 1 0 6 0a3 3 0 0 0-6 0m1-16v3.4a.6.6 0 0 0 .6.6H20" />
                            </g>
                        </svg>
                        Inspection
                    </button>
                </td>
                <td class="do-inspection-icon-cell"></td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 48 48">
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="M41.038 12.488a1.84 1.84 0 0 0-1.842-1.842H8.804a1.84 1.84 0 0 0-1.842 1.842v23.024a1.84 1.84 0 0 0 1.842 1.842h30.392a1.84 1.84 0 0 0 1.842-1.842Z" stroke-width="1" />
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="m38.06 10.646l-.582-2.176a1.84 1.84 0 0 0-2.256-1.302l-12.98 3.478M41.038 33.26l1.096-.294a1.84 1.84 0 0 0 1.303-2.256l-2.4-8.953M9.94 37.354l.582 2.176a1.84 1.84 0 0 0 2.256 1.302l12.98-3.478M6.962 14.74l-1.096.294a1.84 1.84 0 0 0-1.303 2.256l2.414 9.008m5.971-10.126h22.103m-22.103 5.219h22.103m-22.103 5.218h22.103m-22.103 5.219H24" stroke-width="1" />
                    </svg>
                </td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 24 24">
                        <path fill="#0055A5" d="M5 3h13a3 3 0 0 1 3 3v13a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3m0 1a2 2 0 0 0-2 2v11.59l4.29-4.3l2.5 2.5l5-5L20 16V6a2 2 0 0 0-2-2zm4.79 13.21l-2.5-2.5L3 19a2 2 0 0 0 2 2h13a2 2 0 0 0 2-2v-1.59l-5.21-5.2zM7.5 6A2.5 2.5 0 0 1 10 8.5A2.5 2.5 0 0 1 7.5 11A2.5 2.5 0 0 1 5 8.5A2.5 2.5 0 0 1 7.5 6m0 1A1.5 1.5 0 0 0 6 8.5A1.5 1.5 0 0 0 7.5 10A1.5 1.5 0 0 0 9 8.5A1.5 1.5 0 0 0 7.5 7" />
                    </svg>
                </td>
            </tr>
            <tr class="collapse do-inspection-nested-row do-inspection-brake-section" id="do-inspection-brake-section2">
                <td>Steers</td>
                <td>
                    <button class="do-inspection-inspect-button" type="button" onclick="openModal()">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                            <g fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                <path d="M20 12V5.749a.6.6 0 0 0-.176-.425l-3.148-3.148A.6.6 0 0 0 16.252 2H4.6a.6.6 0 0 0-.6.6v18.8a.6.6 0 0 0 .6.6H11M8 10h8M8 6h4m-4 8h3m9.5 6.5L22 22" />
                                <path d="M15 18a3 3 0 1 0 6 0a3 3 0 0 0-6 0m1-16v3.4a.6.6 0 0 0 .6.6H20" />
                            </g>
                        </svg>
                        Inspection
                    </button>
                </td>
                <td class="do-inspection-icon-cell"></td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 48 48">
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="M41.038 12.488a1.84 1.84 0 0 0-1.842-1.842H8.804a1.84 1.84 0 0 0-1.842 1.842v23.024a1.84 1.84 0 0 0 1.842 1.842h30.392a1.84 1.84 0 0 0 1.842-1.842Z" stroke-width="1" />
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="m38.06 10.646l-.582-2.176a1.84 1.84 0 0 0-2.256-1.302l-12.98 3.478M41.038 33.26l1.096-.294a1.84 1.84 0 0 0 1.303-2.256l-2.4-8.953M9.94 37.354l.582 2.176a1.84 1.84 0 0 0 2.256 1.302l12.98-3.478M6.962 14.74l-1.096.294a1.84 1.84 0 0 0-1.303 2.256l2.414 9.008m5.971-10.126h22.103m-22.103 5.219h22.103m-22.103 5.218h22.103m-22.103 5.219H24" stroke-width="1" />
                    </svg>
                </td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 24 24">
                        <path fill="#0055A5" d="M5 3h13a3 3 0 0 1 3 3v13a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3m0 1a2 2 0 0 0-2 2v11.59l4.29-4.3l2.5 2.5l5-5L20 16V6a2 2 0 0 0-2-2zm4.79 13.21l-2.5-2.5L3 19a2 2 0 0 0 2 2h13a2 2 0 0 0 2-2v-1.59l-5.21-5.2zM7.5 6A2.5 2.5 0 0 1 10 8.5A2.5 2.5 0 0 1 7.5 11A2.5 2.5 0 0 1 5 8.5A2.5 2.5 0 0 1 7.5 6m0 1A1.5 1.5 0 0 0 6 8.5A1.5 1.5 0 0 0 7.5 10A1.5 1.5 0 0 0 9 8.5A1.5 1.5 0 0 0 7.5 7" />
                    </svg>
                </td>
            </tr>

            <!-- Cab Section -->
            <tr class="do-inspection-expandable-row custom-toggle" data-target=".do-inspection-cab-section" aria-expanded="false">
                <td class="section-header-cell">
                    <div class="section-header">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="do-inspection-toggle-icon">
                            <path d="M6 9l6 6 6-6"/>
                        </svg>
                        <span class="section-title">Cab</span>
                    </div>
                </td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
            </tr>
            <tr class="collapse do-inspection-nested-row do-inspection-cab-section" id="do-inspection-cab-section1">
                <td>Clutch</td>
                <td>
                    <button class="do-inspection-inspect-button" type="button" onclick="openModal()">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                            <g fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                <path d="M20 12V5.749a.6.6 0 0 0-.176-.425l-3.148-3.148A.6.6 0 0 0 16.252 2H4.6a.6.6 0 0 0-.6.6v18.8a.6.6 0 0 0 .6.6H11M8 10h8M8 6h4m-4 8h3m9.5 6.5L22 22" />
                                <path d="M15 18a3 3 0 1 0 6 0a3 3 0 0 0-6 0m1-16v3.4a.6.6 0 0 0 .6.6H20" />
                            </g>
                        </svg>
                        Inspection
                    </button>
                </td>
                <td class="do-inspection-icon-cell"></td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 48 48">
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="M41.038 12.488a1.84 1.84 0 0 0-1.842-1.842H8.804a1.84 1.84 0 0 0-1.842 1.842v23.024a1.84 1.84 0 0 0 1.842 1.842h30.392a1.84 1.84 0 0 0 1.842-1.842Z" stroke-width="1" />
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="m38.06 10.646l-.582-2.176a1.84 1.84 0 0 0-2.256-1.302l-12.98 3.478M41.038 33.26l1.096-.294a1.84 1.84 0 0 0 1.303-2.256l-2.4-8.953M9.94 37.354l.582 2.176a1.84 1.84 0 0 0 2.256 1.302l12.98-3.478M6.962 14.74l-1.096.294a1.84 1.84 0 0 0-1.303 2.256l2.414 9.008m5.971-10.126h22.103m-22.103 5.219h22.103m-22.103 5.218h22.103m-22.103 5.219H24" stroke-width="1" />
                    </svg>
                </td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 24 24">
                        <path fill="#0055A5" d="M5 3h13a3 3 0 0 1 3 3v13a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3m0 1a2 2 0 0 0-2 2v11.59l4.29-4.3l2.5 2.5l5-5L20 16V6a2 2 0 0 0-2-2zm4.79 13.21l-2.5-2.5L3 19a2 2 0 0 0 2 2h13a2 2 0 0 0 2-2v-1.59l-5.21-5.2zM7.5 6A2.5 2.5 0 0 1 10 8.5A2.5 2.5 0 0 1 7.5 11A2.5 2.5 0 0 1 5 8.5A2.5 2.5 0 0 1 7.5 6m0 1A1.5 1.5 0 0 0 6 8.5A1.5 1.5 0 0 0 7.5 10A1.5 1.5 0 0 0 9 8.5A1.5 1.5 0 0 0 7.5 7" />
                    </svg>
                </td>
            </tr>
            <tr class="collapse do-inspection-nested-row do-inspection-cab-section" id="do-inspection-cab-section2">
                <td>Back-up alarm</td>
                <td>
                    <button class="do-inspection-inspect-button" type="button" onclick="openModal()">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                            <g fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                <path d="M20 12V5.749a.6.6 0 0 0-.176-.425l-3.148-3.148A.6.6 0 0 0 16.252 2H4.6a.6.6 0 0 0-.6.6v18.8a.6.6 0 0 0 .6.6H11M8 10h8M8 6h4m-4 8h3m9.5 6.5L22 22" />
                                <path d="M15 18a3 3 0 1 0 6 0a3 3 0 0 0-6 0m1-16v3.4a.6.6 0 0 0 .6.6H20" />
                            </g>
                        </svg>
                        Inspection
                    </button>
                </td>
                <td class="do-inspection-icon-cell"></td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 48 48">
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="M41.038 12.488a1.84 1.84 0 0 0-1.842-1.842H8.804a1.84 1.84 0 0 0-1.842 1.842v23.024a1.84 1.84 0 0 0 1.842 1.842h30.392a1.84 1.84 0 0 0 1.842-1.842Z" stroke-width="1" />
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="m38.06 10.646l-.582-2.176a1.84 1.84 0 0 0-2.256-1.302l-12.98 3.478M41.038 33.26l1.096-.294a1.84 1.84 0 0 0 1.303-2.256l-2.4-8.953M9.94 37.354l.582 2.176a1.84 1.84 0 0 0 2.256 1.302l12.98-3.478M6.962 14.74l-1.096.294a1.84 1.84 0 0 0-1.303 2.256l2.414 9.008m5.971-10.126h22.103m-22.103 5.219h22.103m-22.103 5.218h22.103m-22.103 5.219H24" stroke-width="1" />
                    </svg>
                </td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 24 24">
                        <path fill="#0055A5" d="M5 3h13a3 3 0 0 1 3 3v13a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3m0 1a2 2 0 0 0-2 2v11.59l4.29-4.3l2.5 2.5l5-5L20 16V6a2 2 0 0 0-2-2zm4.79 13.21l-2.5-2.5L3 19a2 2 0 0 0 2 2h13a2 2 0 0 0 2-2v-1.59l-5.21-5.2zM7.5 6A2.5 2.5 0 0 1 10 8.5A2.5 2.5 0 0 1 7.5 11A2.5 2.5 0 0 1 5 8.5A2.5 2.5 0 0 1 7.5 6m0 1A1.5 1.5 0 0 0 6 8.5A1.5 1.5 0 0 0 7.5 10A1.5 1.5 0 0 0 9 8.5A1.5 1.5 0 0 0 7.5 7" />
                    </svg>
                </td>
            </tr>

            <!-- Chassis/Frame Section -->
            <tr class="do-inspection-expandable-row custom-toggle" data-target=".do-inspection-chassis-section" aria-expanded="false">
                <td class="section-header-cell">
                    <div class="section-header">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="do-inspection-toggle-icon">
                            <path d="M6 9l6 6 6-6"/>
                        </svg>
                        <span class="section-title">Chassis/Frame</span>
                    </div>
                </td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
            </tr>
            <tr class="collapse do-inspection-nested-row do-inspection-chassis-section" id="do-inspection-chassis-section1">
                <td>Exhaust System</td>
                <td>
                    <button class="do-inspection-inspect-button" type="button" onclick="openModal()">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                            <g fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                <path d="M20 12V5.749a.6.6 0 0 0-.176-.425l-3.148-3.148A.6.6 0 0 0 16.252 2H4.6a.6.6 0 0 0-.6.6v18.8a.6.6 0 0 0 .6.6H11M8 10h8M8 6h4m-4 8h3m9.5 6.5L22 22" />
                                <path d="M15 18a3 3 0 1 0 6 0a3 3 0 0 0-6 0m1-16v3.4a.6.6 0 0 0 .6.6H20" />
                            </g>
                        </svg>
                        Inspection
                    </button>
                </td>
                <td class="do-inspection-icon-cell"></td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 48 48">
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="M41.038 12.488a1.84 1.84 0 0 0-1.842-1.842H8.804a1.84 1.84 0 0 0-1.842 1.842v23.024a1.84 1.84 0 0 0 1.842 1.842h30.392a1.84 1.84 0 0 0 1.842-1.842Z" stroke-width="1" />
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="m38.06 10.646l-.582-2.176a1.84 1.84 0 0 0-2.256-1.302l-12.98 3.478M41.038 33.26l1.096-.294a1.84 1.84 0 0 0 1.303-2.256l-2.4-8.953M9.94 37.354l.582 2.176a1.84 1.84 0 0 0 2.256 1.302l12.98-3.478M6.962 14.74l-1.096.294a1.84 1.84 0 0 0-1.303 2.256l2.414 9.008m5.971-10.126h22.103m-22.103 5.219h22.103m-22.103 5.218h22.103m-22.103 5.219H24" stroke-width="1" />
                    </svg>
                </td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 24 24">
                        <path fill="#0055A5" d="M5 3h13a3 3 0 0 1 3 3v13a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3m0 1a2 2 0 0 0-2 2v11.59l4.29-4.3l2.5 2.5l5-5L20 16V6a2 2 0 0 0-2-2zm4.79 13.21l-2.5-2.5L3 19a2 2 0 0 0 2 2h13a2 2 0 0 0 2-2v-1.59l-5.21-5.2zM7.5 6A2.5 2.5 0 0 1 10 8.5A2.5 2.5 0 0 1 7.5 11A2.5 2.5 0 0 1 5 8.5A2.5 2.5 0 0 1 7.5 6m0 1A1.5 1.5 0 0 0 6 8.5A1.5 1.5 0 0 0 7.5 10A1.5 1.5 0 0 0 9 8.5A1.5 1.5 0 0 0 7.5 7" />
                    </svg>
                </td>
            </tr>
            <tr class="collapse do-inspection-nested-row do-inspection-chassis-section" id="do-inspection-chassis-section2">
                <td>Cab</td>
                <td>
                    <button class="do-inspection-inspect-button" type="button" onclick="openModal()">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                            <g fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                <path d="M20 12V5.749a.6.6 0 0 0-.176-.425l-3.148-3.148A.6.6 0 0 0 16.252 2H4.6a.6.6 0 0 0-.6.6v18.8a.6.6 0 0 0 .6.6H11M8 10h8M8 6h4m-4 8h3m9.5 6.5L22 22" />
                                <path d="M15 18a3 3 0 1 0 6 0a3 3 0 0 0-6 0m1-16v3.4a.6.6 0 0 0 .6.6H20" />
                            </g>
                        </svg>
                        Inspection
                    </button>
                </td>
                <td class="do-inspection-icon-cell"></td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 48 48">
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="M41.038 12.488a1.84 1.84 0 0 0-1.842-1.842H8.804a1.84 1.84 0 0 0-1.842 1.842v23.024a1.84 1.84 0 0 0 1.842 1.842h30.392a1.84 1.84 0 0 0 1.842-1.842Z" stroke-width="1" />
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="m38.06 10.646l-.582-2.176a1.84 1.84 0 0 0-2.256-1.302l-12.98 3.478M41.038 33.26l1.096-.294a1.84 1.84 0 0 0 1.303-2.256l-2.4-8.953M9.94 37.354l.582 2.176a1.84 1.84 0 0 0 2.256 1.302l12.98-3.478M6.962 14.74l-1.096.294a1.84 1.84 0 0 0-1.303 2.256l2.414 9.008m5.971-10.126h22.103m-22.103 5.219h22.103m-22.103 5.218h22.103m-22.103 5.219H24" stroke-width="1" />
                    </svg>
                </td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 24 24">
                        <path fill="#0055A5" d="M5 3h13a3 3 0 0 1 3 3v13a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3m0 1a2 2 0 0 0-2 2v11.59l4.29-4.3l2.5 2.5l5-5L20 16V6a2 2 0 0 0-2-2zm4.79 13.21l-2.5-2.5L3 19a2 2 0 0 0 2 2h13a2 2 0 0 0 2-2v-1.59l-5.21-5.2zM7.5 6A2.5 2.5 0 0 1 10 8.5A2.5 2.5 0 0 1 7.5 11A2.5 2.5 0 0 1 5 8.5A2.5 2.5 0 0 1 7.5 6m0 1A1.5 1.5 0 0 0 6 8.5A1.5 1.5 0 0 0 7.5 10A1.5 1.5 0 0 0 9 8.5A1.5 1.5 0 0 0 7.5 7" />
                    </svg>
                </td>
            </tr>

            <!-- Liftgate Inspection Section -->
            <tr class="do-inspection-expandable-row custom-toggle" data-target=".do-inspection-liftgate-section" aria-expanded="false">
                <td class="section-header-cell">
                    <div class="section-header">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="do-inspection-toggle-icon">
                            <path d="M6 9l6 6 6-6"/>
                        </svg>
                        <span class="section-title">Liftgate Inspection</span>
                    </div>
                </td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
            </tr>
            <tr class="collapse do-inspection-nested-row do-inspection-liftgate-section" id="do-inspection-liftgate-section1">
                <td>Hydraulic System</td>
                <td>
                    <button class="do-inspection-inspect-button" type="button" onclick="openModal()">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                            <g fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                <path d="M20 12V5.749a.6.6 0 0 0-.176-.425l-3.148-3.148A.6.6 0 0 0 16.252 2H4.6a.6.6 0 0 0-.6.6v18.8a.6.6 0 0 0 .6.6H11M8 10h8M8 6h4m-4 8h3m9.5 6.5L22 22" />
                                <path d="M15 18a3 3 0 1 0 6 0a3 3 0 0 0-6 0m1-16v3.4a.6.6 0 0 0 .6.6H20" />
                            </g>
                        </svg>
                        Inspection
                    </button>
                </td>
                <td class="do-inspection-icon-cell"></td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 48 48">
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="M41.038 12.488a1.84 1.84 0 0 0-1.842-1.842H8.804a1.84 1.84 0 0 0-1.842 1.842v23.024a1.84 1.84 0 0 0 1.842 1.842h30.392a1.84 1.84 0 0 0 1.842-1.842Z" stroke-width="1" />
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="m38.06 10.646l-.582-2.176a1.84 1.84 0 0 0-2.256-1.302l-12.98 3.478M41.038 33.26l1.096-.294a1.84 1.84 0 0 0 1.303-2.256l-2.4-8.953M9.94 37.354l.582 2.176a1.84 1.84 0 0 0 2.256 1.302l12.98-3.478M6.962 14.74l-1.096.294a1.84 1.84 0 0 0-1.303 2.256l2.414 9.008m5.971-10.126h22.103m-22.103 5.219h22.103m-22.103 5.218h22.103m-22.103 5.219H24" stroke-width="1" />
                    </svg>
                </td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 24 24">
                        <path fill="#0055A5" d="M5 3h13a3 3 0 0 1 3 3v13a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3m0 1a2 2 0 0 0-2 2v11.59l4.29-4.3l2.5 2.5l5-5L20 16V6a2 2 0 0 0-2-2zm4.79 13.21l-2.5-2.5L3 19a2 2 0 0 0 2 2h13a2 2 0 0 0 2-2v-1.59l-5.21-5.2zM7.5 6A2.5 2.5 0 0 1 10 8.5A2.5 2.5 0 0 1 7.5 11A2.5 2.5 0 0 1 5 8.5A2.5 2.5 0 0 1 7.5 6m0 1A1.5 1.5 0 0 0 6 8.5A1.5 1.5 0 0 0 7.5 10A1.5 1.5 0 0 0 9 8.5A1.5 1.5 0 0 0 7.5 7" />
                    </svg>
                </td>
            </tr>
            <tr class="collapse do-inspection-nested-row do-inspection-liftgate-section" id="do-inspection-liftgate-section2">
                <td>Platform Condition</td>
                <td>
                    <button class="do-inspection-inspect-button" type="button" onclick="openModal()">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                            <g fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                <path d="M20 12V5.749a.6.6 0 0 0-.176-.425l-3.148-3.148A.6.6 0 0 0 16.252 2H4.6a.6.6 0 0 0-.6.6v18.8a.6.6 0 0 0 .6.6H11M8 10h8M8 6h4m-4 8h3m9.5 6.5L22 22" />
                                <path d="M15 18a3 3 0 1 0 6 0a3 3 0 0 0-6 0m1-16v3.4a.6.6 0 0 0 .6.6H20" />
                            </g>
                        </svg>
                        Inspection
                    </button>
                </td>
                <td class="do-inspection-icon-cell"></td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 48 48">
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="M41.038 12.488a1.84 1.84 0 0 0-1.842-1.842H8.804a1.84 1.84 0 0 0-1.842 1.842v23.024a1.84 1.84 0 0 0 1.842 1.842h30.392a1.84 1.84 0 0 0 1.842-1.842Z" stroke-width="1" />
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="m38.06 10.646l-.582-2.176a1.84 1.84 0 0 0-2.256-1.302l-12.98 3.478M41.038 33.26l1.096-.294a1.84 1.84 0 0 0 1.303-2.256l-2.4-8.953M9.94 37.354l.582 2.176a1.84 1.84 0 0 0 2.256 1.302l12.98-3.478M6.962 14.74l-1.096.294a1.84 1.84 0 0 0-1.303 2.256l2.414 9.008m5.971-10.126h22.103m-22.103 5.219h22.103m-22.103 5.218h22.103m-22.103 5.219H24" stroke-width="1" />
                    </svg>
                </td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 24 24">
                        <path fill="#0055A5" d="M5 3h13a3 3 0 0 1 3 3v13a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3m0 1a2 2 0 0 0-2 2v11.59l4.29-4.3l2.5 2.5l5-5L20 16V6a2 2 0 0 0-2-2zm4.79 13.21l-2.5-2.5L3 19a2 2 0 0 0 2 2h13a2 2 0 0 0 2-2v-1.59l-5.21-5.2zM7.5 6A2.5 2.5 0 0 1 10 8.5A2.5 2.5 0 0 1 7.5 11A2.5 2.5 0 0 1 5 8.5A2.5 2.5 0 0 1 7.5 6m0 1A1.5 1.5 0 0 0 6 8.5A1.5 1.5 0 0 0 7.5 10A1.5 1.5 0 0 0 9 8.5A1.5 1.5 0 0 0 7.5 7" />
                    </svg>
                </td>
            </tr>

            <!-- Walk-Around Section -->
            <tr class="do-inspection-expandable-row custom-toggle" data-target=".do-inspection-walk-around-section" aria-expanded="false">
                <td class="section-header-cell">
                    <div class="section-header">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="do-inspection-toggle-icon">
                            <path d="M6 9l6 6 6-6"/>
                        </svg>
                        <span class="section-title">Walk-Around</span>
                    </div>
                </td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
                <td class="text-center">-</td>
            </tr>
            <tr class="collapse do-inspection-nested-row do-inspection-walk-around-section" id="do-inspection-walk-around-section1">
                <td>Exterior Lights</td>
                <td>
                    <button class="do-inspection-inspect-button" type="button" onclick="openModal()">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                            <g fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                <path d="M20 12V5.749a.6.6 0 0 0-.176-.425l-3.148-3.148A.6.6 0 0 0 16.252 2H4.6a.6.6 0 0 0-.6.6v18.8a.6.6 0 0 0 .6.6H11M8 10h8M8 6h4m-4 8h3m9.5 6.5L22 22" />
                                <path d="M15 18a3 3 0 1 0 6 0a3 3 0 0 0-6 0m1-16v3.4a.6.6 0 0 0 .6.6H20" />
                            </g>
                        </svg>
                        Inspection
                    </button>
                </td>
                <td class="do-inspection-icon-cell"></td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 48 48">
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="M41.038 12.488a1.84 1.84 0 0 0-1.842-1.842H8.804a1.84 1.84 0 0 0-1.842 1.842v23.024a1.84 1.84 0 0 0 1.842 1.842h30.392a1.84 1.84 0 0 0 1.842-1.842Z" stroke-width="1" />
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="m38.06 10.646l-.582-2.176a1.84 1.84 0 0 0-2.256-1.302l-12.98 3.478M41.038 33.26l1.096-.294a1.84 1.84 0 0 0 1.303-2.256l-2.4-8.953M9.94 37.354l.582 2.176a1.84 1.84 0 0 0 2.256 1.302l12.98-3.478M6.962 14.74l-1.096.294a1.84 1.84 0 0 0-1.303 2.256l2.414 9.008m5.971-10.126h22.103m-22.103 5.219h22.103m-22.103 5.218h22.103m-22.103 5.219H24" stroke-width="1" />
                    </svg>
                </td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 24 24">
                        <path fill="#0055A5" d="M5 3h13a3 3 0 0 1 3 3v13a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3m0 1a2 2 0 0 0-2 2v11.59l4.29-4.3l2.5 2.5l5-5L20 16V6a2 2 0 0 0-2-2zm4.79 13.21l-2.5-2.5L3 19a2 2 0 0 0 2 2h13a2 2 0 0 0 2-2v-1.59l-5.21-5.2zM7.5 6A2.5 2.5 0 0 1 10 8.5A2.5 2.5 0 0 1 7.5 11A2.5 2.5 0 0 1 5 8.5A2.5 2.5 0 0 1 7.5 6m0 1A1.5 1.5 0 0 0 6 8.5A1.5 1.5 0 0 0 7.5 10A1.5 1.5 0 0 0 9 8.5A1.5 1.5 0 0 0 7.5 7" />
                    </svg>
                </td>
            </tr>
            <tr class="collapse do-inspection-nested-row do-inspection-walk-around-section" id="do-inspection-walk-around-section2">
                <td>Reflectors</td>
                <td>
                    <button class="do-inspection-inspect-button" type="button" onclick="openModal()">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                            <g fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                                <path d="M20 12V5.749a.6.6 0 0 0-.176-.425l-3.148-3.148A.6.6 0 0 0 16.252 2H4.6a.6.6 0 0 0-.6.6v18.8a.6.6 0 0 0 .6.6H11M8 10h8M8 6h4m-4 8h3m9.5 6.5L22 22" />
                                <path d="M15 18a3 3 0 1 0 6 0a3 3 0 0 0-6 0m1-16v3.4a.6.6 0 0 0 .6.6H20" />
                            </g>
                        </svg>
                        Inspection
                    </button>
                </td>
                <td class="do-inspection-icon-cell"></td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 48 48">
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="M41.038 12.488a1.84 1.84 0 0 0-1.842-1.842H8.804a1.84 1.84 0 0 0-1.842 1.842v23.024a1.84 1.84 0 0 0 1.842 1.842h30.392a1.84 1.84 0 0 0 1.842-1.842Z" stroke-width="1" />
                        <path fill="none" stroke="#0055A5" stroke-linecap="round" stroke-linejoin="round" d="m38.06 10.646l-.582-2.176a1.84 1.84 0 0 0-2.256-1.302l-12.98 3.478M41.038 33.26l1.096-.294a1.84 1.84 0 0 0 1.303-2.256l-2.4-8.953M9.94 37.354l.582 2.176a1.84 1.84 0 0 0 2.256 1.302l12.98-3.478M6.962 14.74l-1.096.294a1.84 1.84 0 0 0-1.303 2.256l2.414 9.008m5.971-10.126h22.103m-22.103 5.219h22.103m-22.103 5.218h22.103m-22.103 5.219H24" stroke-width="1" />
                    </svg>
                </td>
                <td class="do-inspection-icon-cell">
                    <svg xmlns="http://www.w3.org/2000/svg" onclick="openModal()" width="30" height="30" viewBox="0 0 24 24">
                        <path fill="#0055A5" d="M5 3h13a3 3 0 0 1 3 3v13a3 3 0 0 1-3 3H5a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3m0 1a2 2 0 0 0-2 2v11.59l4.29-4.3l2.5 2.5l5-5L20 16V6a2 2 0 0 0-2-2zm4.79 13.21l-2.5-2.5L3 19a2 2 0 0 0 2 2h13a2 2 0 0 0 2-2v-1.59l-5.21-5.2zM7.5 6A2.5 2.5 0 0 1 10 8.5A2.5 2.5 0 0 1 7.5 11A2.5 2.5 0 0 1 5 8.5A2.5 2.5 0 0 1 7.5 6m0 1A1.5 1.5 0 0 0 6 8.5A1.5 1.5 0 0 0 7.5 10A1.5 1.5 0 0 0 9 8.5A1.5 1.5 0 0 0 7.5 7" />
                    </svg>
                </td>
            </tr>

                </tbody>
            </table>
        </div>
    </div>

    <!-- Completion Button -->
    <div class="completion-section">
        <button class="btn-complete" onclick="completeInspection()" aria-label="Complete inspection and generate report">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" aria-hidden="true">
                <path d="M9 12l2 2 4-4"/>
                <path d="M21 12c-1 0-3-1-3-3s2-3 3-3 3 1 3 3-2 3-3 3"/>
                <path d="M3 12c1 0 3-1 3-3s-2-3-3-3-3 1-3 3 2 3 3 3"/>
                <path d="M13 12h3"/>
                <path d="M8 12H5"/>
            </svg>
            <span>Inspection Completed</span>
        </button>
    </div>
</div>



<!-- Modal Popup -->
<div id="inspectionModal" class="modal-overlay">
    <div class="modal-content">
        <div class="modal-header">
            <h2>Inspection Item</h2>
            <button class="btn-close" onclick="closeModal()">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="18" y1="6" x2="6" y2="18"/>
                    <line x1="6" y1="6" x2="18" y2="18"/>
                </svg>
            </button>
        </div>

        <div class="modal-body">
            <div class="item-title">
                <h3>Air, Electrical, Hydraulic Lines</h3>
            </div>
            
            <div class="condition-section">
                <label class="section-label">Condition *</label>
                <div class="condition-options">
                    <label class="option-item good">
                        <input type="radio" name="condition" value="good">
                        <span class="option-text">Good</span>
                    </label>
                    <label class="option-item repair">
                        <input type="radio" name="condition" value="repair">
                        <span class="option-text">Repair</span>
                    </label>
                    <label class="option-item replace">
                        <input type="radio" name="condition" value="replace">
                        <span class="option-text">Replace</span>
                    </label>
                    <label class="option-item na">
                        <input type="radio" name="condition" value="na">
                        <span class="option-text">N/A</span>
                    </label>
                </div>
            </div>
            
            <div class="note-section">
                <label class="section-label">Inspection Note *</label>
                <textarea class="note-textarea" placeholder="Enter your notes here..."></textarea>
            </div>
            
            <div class="image-section">
                <label class="section-label">Upload Image</label>
                <div class="image-preview">
                    <img id="imagePreview" src="https://via.placeholder.com/400x200" alt="Uploaded Image">
                </div>
                <input type="file" id="imageUpload" accept="image/*" style="display: none;">
                <button class="btn-upload" onclick="document.getElementById('imageUpload').click()">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/>
                        <polyline points="7,10 12,15 17,10"/>
                        <line x1="12" y1="15" x2="12" y2="3"/>
                    </svg>
                    Upload Image
                </button>
            </div>
        </div>
        
        <div class="modal-footer">
            <button class="btn-cancel" onclick="closeModal()">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="18" y1="6" x2="6" y2="18"/>
                    <line x1="6" y1="6" x2="18" y2="18"/>
                </svg>
                Cancel
            </button>
            <button class="btn-save" onclick="saveInspection()">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M9 12l2 2 4-4"/>
                    <path d="M21 12c-1 0-3-1-3-3s2-3 3-3 3 1 3 3-2 3-3 3"/>
                    <path d="M3 12c1 0 3-1 3-3s-2-3-3-3-3 1-3 3 2 3 3 3"/>
                </svg>
                Save Inspection
            </button>
        </div>
    </div>
</div>

<style>
/* Import Google Fonts for better typography */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* CSS Variables for consistent theming */
:root {
    --primary-color: #0055a5;
    --primary-hover: rgba(255, 255, 255, 0.2);
    --success-color: #10b981;
    --success-hover: #059669;
    --error-color: #ef4444;
    --error-hover: #dc2626;
    --warning-color: #f59e0b;
    --warning-hover: #d97706;
    --text-primary: #0f172a;
    --text-secondary: #374151;
    --text-muted: #64748b;
    --text-light: #6b7280;
    --bg-primary: #f8fafc;
    --bg-white: #ffffff;
    --bg-hover: #f1f5f9;
    --bg-light: #f9fafb;
    --border-color: #e2e8f0;
    --border-light: #d1d5db;
    --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    --shadow-md: 0 2px 4px rgba(16, 185, 129, 0.2);
    --shadow-lg: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    --shadow-modal: 0 10px 25px rgba(0, 0, 0, 0.2);
    --radius-sm: 0;
    --radius-md: 0;
    --radius-lg: 0;
    --transition-base: all 0.2s ease;
    --transition-slow: all 0.3s ease;
    --font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    --z-index-modal: 1000;
    --z-index-notification: 10000;
}

/* Main Container */
.do-inspection-container {
    min-height: 100vh;
}

/* Header Section */
.inspection-header {
    background: var(--bg-white);
    border: 1px solid var(--border-color);
    box-shadow: var(--shadow-sm);
    border-radius: var(--radius-sm);
    margin-bottom: 24px;
}

.header-content {
    padding: 32px;
}

.page-title h1 {
    color: var(--text-primary);
    font-weight: 700;
    font-size: 32px;
    line-height: 1.2;
    letter-spacing: -0.025em;
    margin: 0 0 8px 0;
}

.page-title p {
    color: var(--text-muted);
    font-weight: 400;
    font-size: 16px;
    line-height: 1.5;
    margin: 0;
}

/* Table Section */
.inspection-table-section {
    background: var(--bg-white);
    border: 1px solid var(--border-color);
    box-shadow: var(--shadow-sm);
    border-radius: var(--radius-sm);
    margin-bottom: 24px;
}

.table-container {
    overflow-x: auto;
}

.inspection-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 14px;
    table-layout: fixed;
}

.inspection-table th:nth-child(1) { width: 40%; }
.inspection-table th:nth-child(2) { width: 15%; }
.inspection-table th:nth-child(3) { width: 15%; }
.inspection-table th:nth-child(4) { width: 15%; }
.inspection-table th:nth-child(5) { width: 15%; }

.table-header th {
    background: linear-gradient(135deg, var(--bg-primary) 0%, var(--bg-hover) 100%);
    color: var(--text-secondary);
    font-weight: 600;
    font-size: 14px;
    padding: 16px 12px;
    text-align: left;
    border-bottom: 1px solid var(--border-color);
    border-radius: var(--radius-sm);
}

.table-header th.text-center {
    text-align: center;
}

.table-body td {
    padding: 12px;
    border-bottom: 1px solid var(--bg-hover);
    vertical-align: middle;
}

/* Expandable Rows */
.expandable-row {
    cursor: pointer !important;
    background: var(--bg-primary);
    transition: var(--transition-base);
}

.expandable-row:hover {
    background: var(--bg-hover);
}

/* Do Inspection specific expandable rows */
.do-inspection-expandable-row {
    cursor: pointer !important;
    background: var(--bg-primary);
    transition: var(--transition-base);
}

.do-inspection-expandable-row:hover {
    background: var(--bg-hover);
}

.section-header-cell {
    padding: 16px 12px !important;
}

.section-header {
    display: flex;
    align-items: center;
    gap: 12px;
    justify-content: flex-start;
}

.toggle-icon {
    color: var(--text-light);
    transition: transform var(--transition-base);
}

.expandable-row[aria-expanded="true"] .toggle-icon {
    transform: rotate(180deg);
}

/* Do Inspection toggle icons */
.do-inspection-toggle-icon {
    color: var(--text-light);
    transition: transform var(--transition-base);
    cursor: pointer;
}

.do-inspection-expandable-row[aria-expanded="true"] .do-inspection-toggle-icon {
    transform: rotate(180deg);
}

.section-title {
    color: var(--text-primary);
    font-weight: 600;
    font-size: 16px;
}

/* Nested Rows */
.nested-row {
    background: var(--bg-white);
}

.do-inspection-nested-row {
    background: var(--bg-white);
}

.do-inspection-nested-row td {
    padding: 12px;
    border-bottom: 1px solid #f1f5f9;
    vertical-align: middle;
}

.do-inspection-nested-row td:nth-child(2) {
    text-align: right;
}

.do-inspection-nested-row td:nth-child(3) {
    text-align: right;
}

.do-inspection-nested-row td:nth-child(4) {
    text-align: right;
}

.do-inspection-nested-row td:nth-child(5) {
    text-align: right;
}

.do-inspection-nested-row td:first-child {
    color: var(--text-secondary);
    font-weight: 500;
    padding-left: 40px !important;
    text-align: left;
}

.item-cell {
    color: var(--text-secondary);
    font-weight: 500;
    padding-left: 40px !important;
}

/* Do Inspection specific styling */
.do-inspection-inspect-button {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 8px 16px;
    border: none;
    border-radius: var(--radius-sm);
    background: var(--primary-color);
    color: var(--bg-white);
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
    width: auto;
    justify-content: center;
    margin-left: auto;
}

.do-inspection-inspect-button:hover {
    background: rgba(0, 85, 165, 0.8);
    transform: translateY(-1px);
    box-shadow: var(--shadow-lg);
}

.do-inspection-icon-cell {
    text-align: right;
    vertical-align: middle;
    padding: 8px;
}

.do-inspection-icon-cell svg {
    cursor: pointer;
    transition: var(--transition-base);
    display: inline-block;
    margin-left: auto;
}

.do-inspection-icon-cell svg:hover {
    transform: scale(1.1);
    opacity: 0.8;
}

/* Ensure collapse functionality works properly */
.collapse {
    display: none;
    overflow: hidden;
    transition: var(--transition-slow);
}

.collapse.show {
    display: block !important;
}

/* Smooth collapse animation */
.collapse {
    transition: max-height 0.3s ease, opacity 0.3s ease;
}

.collapse:not(.show) {
    max-height: 0;
    opacity: 0;
}

.collapse.show {
    max-height: 1000px;
    opacity: 1;
}

/* Buttons */
.btn-inspect {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 8px 16px;
    border: none;
    border-radius: var(--radius-sm);
    background: var(--primary-color);
    color: var(--bg-white);
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
}

.btn-inspect:hover {
    background: var(--primary-hover);
    transform: translateY(-1px);
    box-shadow: var(--shadow-lg);
    color: var(--text-primary);
}

.btn-note,
.btn-image {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border: 1px solid var(--border-light);
    border-radius: var(--radius-sm);
    background: var(--bg-white);
    color: var(--text-light);
    cursor: pointer;
    transition: var(--transition-base);
}

.btn-note:hover,
.btn-image:hover {
    background: var(--bg-light);
    border-color: var(--primary-color);
    color: var(--primary-color);
}

/* Status Indicator */
.status-indicator {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 4px 12px;
    border-radius: var(--radius-sm);
    background: #fef3c7;
    border: 1px solid var(--warning-color);
}

.status-text {
    color: #92400e;
    font-size: 12px;
    font-weight: 500;
}

/* Completion Section */
.completion-section {
    display: flex;
    justify-content: center;
    padding: 24px;
}

.btn-complete {
    display: inline-flex;
    align-items: center;
    gap: 12px;
    padding: 16px 32px;
    border: none;
    border-radius: var(--radius-sm);
    background: var(--primary-color);
    color: var(--bg-white);
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: var(--transition-base);
    box-shadow: var(--shadow-md);
}

.btn-complete:hover {
    background: var(--primary-hover);
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
    color: var(--text-primary);
}

/* Modal Styles */
.modal-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    justify-content: center;
    align-items: center;
    z-index: var(--z-index-modal);
}

.modal-content {
    background: var(--bg-white);
    border-radius: var(--radius-sm);
    width: 90%;
    max-width: 600px;
    max-height: 90vh;
    overflow-y: auto;
    box-shadow: var(--shadow-modal);
    z-index: 1000222;
}

.modal-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 24px;
    border-bottom: 1px solid var(--border-color);
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    color: var(--bg-white);
}

.modal-header h2 {
    margin: 0;
    font-size: 20px;
    font-weight: 600;
}

.btn-close {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 32px;
    height: 32px;
    border: none;
    background: rgba(255, 255, 255, 0.2);
    color: var(--bg-white);
    cursor: pointer;
    transition: var(--transition-base);
    border-radius: var(--radius-sm);
}

.btn-close:hover {
    background: rgba(255, 255, 255, 0.3);
}

.modal-body {
    padding: 24px;
}

.item-title {
    margin-bottom: 24px;
    text-align: center;
}

.item-title h3 {
    color: var(--text-primary);
    font-size: 18px;
    font-weight: 600;
    margin: 0;
}

.section-label {
    display: block;
    color: var(--text-secondary);
    font-weight: 500;
    font-size: 14px;
    margin-bottom: 12px;
}

.condition-section {
    margin-bottom: 24px;
}

.condition-options {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
    gap: 12px;
}

.option-item {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 12px;
    border: 1px solid var(--border-light);
    border-radius: var(--radius-sm);
    cursor: pointer;
    transition: var(--transition-base);
}

.option-item:hover {
    background: var(--bg-light);
}

.option-item.good {
    border-color: var(--success-color);
}

.option-item.repair {
    border-color: var(--warning-color);
}

.option-item.replace {
    border-color: var(--error-color);
}

.option-item.na {
    border-color: var(--text-light);
}

.option-item input[type="radio"] {
    margin: 0;
    width: 16px;
    height: 16px;
}

.option-text {
    font-size: 14px;
    font-weight: 500;
    color: var(--text-secondary);
}

.note-section {
    margin-bottom: 24px;
}

.note-textarea {
    width: 100%;
    min-height: 100px;
    padding: 12px;
    border: 1px solid var(--border-light);
    border-radius: var(--radius-sm);
    font-size: 14px;
    font-family: inherit;
    resize: vertical;
    transition: border-color var(--transition-base);
}

.note-textarea:focus {
    outline: none;
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.image-section {
    margin-bottom: 24px;
}

.image-preview {
    width: 100%;
    height: 200px;
    background: var(--bg-light);
    border: 1px solid var(--border-light);
    border-radius: var(--radius-sm);
    overflow: hidden;
    margin-bottom: 12px;
}

.image-preview img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.btn-upload {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border: 1px solid var(--primary-color);
    border-radius: var(--radius-sm);
    background: var(--bg-white);
    color: var(--primary-color);
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
}

.btn-upload:hover {
    background: var(--primary-color);
    color: var(--bg-white);
}

.modal-footer {
    display: flex;
    gap: 12px;
    padding: 24px;
    border-top: 1px solid var(--border-color);
    justify-content: flex-end;
}

.btn-cancel {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border: 1px solid var(--border-light);
    border-radius: var(--radius-sm);
    background: var(--bg-white);
    color: var(--text-light);
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
}

.btn-cancel:hover {
    background: var(--bg-light);
    border-color: #9ca3af;
    color: var(--text-secondary);
}

.btn-save {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border: none;
    border-radius: var(--radius-sm);
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    color: var(--bg-white);
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
}

.btn-save:hover {
    background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2);
}

/* ===== ACCESSIBILITY & FOCUS STATES ===== */
@media (prefers-reduced-motion: reduce) {
    * {
        transition: none !important;
        animation: none !important;
    }
}

.btn-inspect:focus,
.btn-note:focus,
.btn-image:focus,
.btn-complete:focus,
.btn-close:focus,
.btn-upload:focus,
.btn-cancel:focus,
.btn-save:focus,
.do-inspection-inspect-button:focus {
    outline: 2px solid var(--primary-color);
    outline-offset: 2px;
}

.btn-inspect:focus-visible,
.btn-note:focus-visible,
.btn-image:focus-visible,
.btn-complete:focus-visible,
.btn-close:focus-visible,
.btn-upload:focus-visible,
.btn-cancel:focus-visible,
.btn-save:focus-visible,
.do-inspection-inspect-button:focus-visible {
    outline: 2px solid var(--primary-color);
    outline-offset: 2px;
}

/* ===== PRINT STYLES ===== */
@media print {
    .do-inspection-container {
        background: white;
        padding: 0;
    }
    
    .inspection-header,
    .inspection-table-section {
        box-shadow: none;
        border: 1px solid #000;
        break-inside: avoid;
    }
    
    .btn-inspect,
    .btn-note,
    .btn-image,
    .btn-complete,
    .do-inspection-inspect-button {
        display: none;
    }
    
    .modal-overlay {
        display: none !important;
    }
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 1200px) {
    .do-inspection-container {
        padding: 20px;
    }
    
    .header-content {
        padding: 24px;
    }
    
    .inspection-table-section {
        margin-bottom: 20px;
    }
    
    .completion-section {
        padding: 20px;
    }
}

@media (max-width: 992px) {
    .do-inspection-container {
        padding: 16px;
    }
    
    .header-content {
        padding: 20px;
    }
    
    .page-title h1 {
        font-size: 24px;
    }
    
    .page-title p {
        font-size: 14px;
    }
    
    .inspection-table-section {
        margin-bottom: 18px;
    }
    
    .table-header th {
        padding: 14px 10px;
        font-size: 13px;
    }
    
    .table-body td {
        padding: 10px;
    }
    
    .section-title {
        font-size: 15px;
    }
    
    .item-cell {
        font-size: 14px;
        padding-left: 32px !important;
    }
    
    .btn-inspect {
        padding: 7px 14px;
        font-size: 13px;
    }
    
    .do-inspection-inspect-button {
        padding: 7px 14px;
        font-size: 13px;
    }
    
    .btn-note,
    .btn-image {
        width: 36px;
        height: 36px;
    }
    
    .do-inspection-icon-cell svg {
        width: 26px;
        height: 26px;
    }
    
    .condition-options {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .completion-section {
        padding: 18px;
    }
    
    .btn-complete {
        padding: 15px 30px;
        font-size: 15px;
    }
}

@media (max-width: 768px) {
    .do-inspection-container {
        padding: 0;
    }
    
    .inspection-header {
        margin: 0 16px 16px 16px;
    }
    
    .header-content {
        padding: 16px;
    }
    
    .page-title h1 {
        font-size: 20px;
        margin-bottom: 6px;
    }
    
    .page-title p {
        font-size: 13px;
    }
    
    .inspection-table-section {
        margin: 0 16px 16px 16px;
    }
    
    .table-container {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        border: 1px solid #e2e8f0;
    }
    
    .inspection-table {
        min-width: 600px;
        font-size: 12px;
    }
    
    .table-header th {
        padding: 12px 8px;
        font-size: 11px;
        background-color: #f8fafc;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .table-body td {
        padding: 8px;
        font-size: 11px;
    }
    
    .section-header-cell {
        padding: 12px 8px !important;
    }
    
    .section-header {
        gap: 8px;
    }
    
    .section-title {
        font-size: 14px;
    }
    
    .item-cell {
        font-size: 12px;
        padding-left: 20px !important;
    }
    
    .btn-inspect {
        padding: 6px 12px;
        font-size: 11px;
        min-height: 32px;
    }
    
    .do-inspection-inspect-button {
        padding: 6px 12px;
        font-size: 11px;
        min-height: 32px;
    }
    
    .btn-note,
    .btn-image {
        width: 32px;
        height: 32px;
    }
    
    .do-inspection-icon-cell {
        padding: 6px;
    }
    
    .do-inspection-icon-cell svg {
        width: 24px;
        height: 24px;
    }
    
    .status-indicator {
        padding: 3px 8px;
    }
    
    .status-text {
        font-size: 10px;
    }
    
    .modal-content {
        width: 95%;
        margin: 1rem;
        max-width: calc(100% - 2rem);
    }
    
    .modal-header {
        padding: 16px;
    }
    
    .modal-header h2 {
        font-size: 18px;
    }
    
    .modal-body {
        padding: 16px;
    }
    
    .item-title h3 {
        font-size: 16px;
    }
    
    .section-label {
        font-size: 13px;
        margin-bottom: 8px;
    }
    
    .condition-options {
        grid-template-columns: 1fr;
        gap: 8px;
    }
    
    .option-item {
        padding: 10px;
    }
    
    .option-text {
        font-size: 13px;
    }
    
    .note-textarea {
        min-height: 80px;
        font-size: 14px;
    }
    
    .image-preview {
        height: 150px;
    }
    
    .btn-upload {
        padding: 10px 16px;
        font-size: 13px;
    }
    
    .modal-footer {
        padding: 16px;
        flex-direction: column;
        gap: 8px;
    }
    
    .btn-cancel,
    .btn-save {
        width: 100%;
        justify-content: center;
        padding: 12px 16px;
        font-size: 14px;
    }
    
    .completion-section {
        padding: 16px;
        margin: 0 16px 16px 16px;
    }
    
    .btn-complete {
        padding: 14px 28px;
        font-size: 15px;
        min-height: 48px;
        width: 100%;
        justify-content: center;
    }
    
    /* Inspection Summary Section */
    #Inspection-Summary-main {
        margin: 0 16px 16px 16px !important;
        padding: 16px !important;
    }
    
    #Inspection-Summary-main h3 {
        font-size: 18px;
        margin-bottom: 16px;
    }
    
    #Inspection-Summary-main .row {
        margin: 0;
    }
    
    #Inspection-Summary-main .col-md-6 {
        padding: 0;
        margin-bottom: 16px;
    }
    
    #Inspection-Summary-main .mb-3 {
        margin-bottom: 12px !important;
        flex-direction: column;
        align-items: flex-start !important;
        gap: 8px !important;
    }
    
    #Inspection-Summary-main .form-label {
        font-size: 13px;
        font-weight: 600;
        margin-bottom: 4px;
    }
    
    #Inspection-Summary-main .form-select,
    #Inspection-Summary-main .form-control {
        width: 100%;
        padding: 10px 12px;
        font-size: 14px;
        min-height: 44px;
    }
    
    #Inspection-Summary-main .yes-no-checkbox-main-Inspection-Summary {
        display: flex;
        gap: 16px;
        width: 100%;
    }
    
    #Inspection-Summary-main .form-check {
        flex: 1;
    }
    
    #Inspection-Summary-main .form-check-label {
        font-size: 13px;
    }
    
    #Inspection-Summary-main .Inspection-Summary-btn {
        width: 100%;
        padding: 14px 20px;
        font-size: 15px;
        min-height: 48px;
        justify-content: center;
    }
}

@media (max-width: 576px) {
    .do-inspection-container {
        padding: 0;
    }
    
    .inspection-header {
        margin: 0 12px 12px 12px;
    }
    
    .header-content {
        padding: 12px;
    }
    
    .page-title h1 {
        font-size: 18px;
        margin-bottom: 4px;
    }
    
    .page-title p {
        font-size: 12px;
    }
    
    .inspection-table-section {
        margin: 0 12px 12px 12px;
    }
    
    .inspection-table {
        min-width: 500px;
        font-size: 11px;
    }
    
    .table-header th {
        padding: 10px 6px;
        font-size: 10px;
    }
    
    .table-body td {
        padding: 6px;
        font-size: 10px;
    }
    
    .section-header-cell {
        padding: 10px 6px !important;
    }
    
    .section-header {
        gap: 6px;
    }
    
    .section-title {
        font-size: 13px;
    }
    
    .item-cell {
        font-size: 11px;
        padding-left: 16px !important;
    }
    
    .btn-inspect {
        padding: 4px 8px;
        font-size: 10px;
        min-height: 28px;
    }
    
    .do-inspection-inspect-button {
        padding: 4px 8px;
        font-size: 10px;
        min-height: 28px;
    }
    
    .btn-note,
    .btn-image {
        width: 28px;
        height: 28px;
    }
    
    .do-inspection-icon-cell {
        padding: 4px;
    }
    
    .do-inspection-icon-cell svg {
        width: 20px;
        height: 20px;
    }
    
    .status-indicator {
        padding: 2px 6px;
    }
    
    .status-text {
        font-size: 9px;
    }
    
    .modal-content {
        width: 98%;
        margin: 0.5rem;
        max-width: calc(100% - 1rem);
    }
    
    .modal-header {
        padding: 12px;
    }
    
    .modal-header h2 {
        font-size: 16px;
    }
    
    .modal-body {
        padding: 12px;
    }
    
    .item-title h3 {
        font-size: 14px;
    }
    
    .section-label {
        font-size: 12px;
        margin-bottom: 6px;
    }
    
    .condition-options {
        gap: 6px;
    }
    
    .option-item {
        padding: 8px;
    }
    
    .option-text {
        font-size: 12px;
    }
    
    .note-textarea {
        min-height: 70px;
        font-size: 14px;
    }
    
    .image-preview {
        height: 120px;
    }
    
    .btn-upload {
        padding: 8px 12px;
        font-size: 12px;
    }
    
    .modal-footer {
        padding: 12px;
    }
    
    .btn-cancel,
    .btn-save {
        padding: 10px 12px;
        font-size: 13px;
    }
    
    .completion-section {
        padding: 12px;
        margin: 0 12px 12px 12px;
    }
    
    .btn-complete {
        padding: 12px 24px;
        font-size: 14px;
        min-height: 44px;
    }
    
    /* Inspection Summary Section */
    #Inspection-Summary-main {
        margin: 0 12px 12px 12px !important;
        padding: 12px !important;
    }
    
    #Inspection-Summary-main h3 {
        font-size: 16px;
        margin-bottom: 12px;
    }
    
    #Inspection-Summary-main .mb-3 {
        margin-bottom: 10px !important;
        gap: 6px !important;
    }
    
    #Inspection-Summary-main .form-label {
        font-size: 12px;
    }
    
    #Inspection-Summary-main .form-select,
    #Inspection-Summary-main .form-control {
        padding: 8px 10px;
        font-size: 14px;
        min-height: 40px;
    }
    
    #Inspection-Summary-main .yes-no-checkbox-main-Inspection-Summary {
        gap: 12px;
    }
    
    #Inspection-Summary-main .form-check-label {
        font-size: 12px;
    }
    
    #Inspection-Summary-main .Inspection-Summary-btn {
        padding: 12px 16px;
        font-size: 14px;
        min-height: 44px;
    }
}

@media (max-width: 480px) {
    .inspection-header {
        margin: 0 8px 8px 8px;
    }
    
    .header-content {
        padding: 10px;
    }
    
    .page-title h1 {
        font-size: 16px;
        margin-bottom: 3px;
    }
    
    .page-title p {
        font-size: 11px;
    }
    
    .inspection-table-section {
        margin: 0 8px 8px 8px;
    }
    
    .inspection-table {
        min-width: 450px;
        font-size: 10px;
    }
    
    .table-header th {
        padding: 8px 4px;
        font-size: 9px;
    }
    
    .table-body td {
        padding: 4px;
        font-size: 9px;
    }
    
    .section-header-cell {
        padding: 8px 4px !important;
    }
    
    .section-title {
        font-size: 12px;
    }
    
    .item-cell {
        font-size: 10px;
        padding-left: 12px !important;
    }
    
    .btn-inspect {
        padding: 3px 6px;
        font-size: 9px;
        min-height: 24px;
    }
    
    .do-inspection-inspect-button {
        padding: 3px 6px;
        font-size: 9px;
        min-height: 24px;
    }
    
    .btn-note,
    .btn-image {
        width: 24px;
        height: 24px;
    }
    
    .do-inspection-icon-cell svg {
        width: 18px;
        height: 18px;
    }
    
    .completion-section {
        padding: 8px;
        margin: 0 8px 8px 8px;
    }
    
    .btn-complete {
        padding: 10px 20px;
        font-size: 13px;
        min-height: 40px;
    }
    
    /* Inspection Summary Section */
    #Inspection-Summary-main {
        margin: 0 8px 8px 8px !important;
        padding: 8px !important;
    }
    
    #Inspection-Summary-main h3 {
        font-size: 14px;
        margin-bottom: 10px;
    }
    
    #Inspection-Summary-main .form-label {
        font-size: 11px;
    }
    
    #Inspection-Summary-main .form-select,
    #Inspection-Summary-main .form-control {
        padding: 6px 8px;
        font-size: 14px;
        min-height: 36px;
    }
    
    #Inspection-Summary-main .yes-no-checkbox-main-Inspection-Summary {
        gap: 8px;
    }
    
    #Inspection-Summary-main .form-check-label {
        font-size: 11px;
    }
    
    #Inspection-Summary-main .Inspection-Summary-btn {
        padding: 10px 12px;
        font-size: 13px;
        min-height: 40px;
    }
}

@media (max-width: 360px) {
    .inspection-header {
        margin: 0 6px 6px 6px;
    }
    
    .header-content {
        padding: 8px;
    }
    
    .page-title h1 {
        font-size: 14px;
        margin-bottom: 2px;
    }
    
    .page-title p {
        font-size: 10px;
    }
    
    .inspection-table-section {
        margin: 0 6px 6px 6px;
    }
    
    .inspection-table {
        min-width: 400px;
        font-size: 9px;
    }
    
    .table-header th {
        padding: 6px 3px;
        font-size: 8px;
    }
    
    .table-body td {
        padding: 3px;
        font-size: 8px;
    }
    
    .section-header-cell {
        padding: 6px 3px !important;
    }
    
    .section-title {
        font-size: 11px;
    }
    
    .item-cell {
        font-size: 9px;
        padding-left: 10px !important;
    }
    
    .btn-inspect {
        padding: 2px 4px;
        font-size: 8px;
        min-height: 20px;
    }
    
    .do-inspection-inspect-button {
        padding: 2px 4px;
        font-size: 8px;
        min-height: 20px;
    }
    
    .btn-note,
    .btn-image {
        width: 20px;
        height: 20px;
    }
    
    .do-inspection-icon-cell svg {
        width: 16px;
        height: 16px;
    }
    
    .completion-section {
        padding: 6px;
        margin: 0 6px 6px 6px;
    }
    
    .btn-complete {
        padding: 8px 16px;
        font-size: 12px;
        min-height: 36px;
    }
    
    /* Inspection Summary Section */
    #Inspection-Summary-main {
        margin: 0 6px 6px 6px !important;
        padding: 6px !important;
    }
    
    #Inspection-Summary-main h3 {
        font-size: 13px;
        margin-bottom: 8px;
    }
    
    #Inspection-Summary-main .form-label {
        font-size: 10px;
    }
    
    #Inspection-Summary-main .form-select,
    #Inspection-Summary-main .form-control {
        padding: 4px 6px;
        font-size: 14px;
        min-height: 32px;
    }
    
    #Inspection-Summary-main .yes-no-checkbox-main-Inspection-Summary {
        gap: 6px;
    }
    
    #Inspection-Summary-main .form-check-label {
        font-size: 10px;
    }
    
    #Inspection-Summary-main .Inspection-Summary-btn {
        padding: 8px 10px;
        font-size: 12px;
        min-height: 36px;
    }
}

/* Focus states for accessibility */
.btn-inspect:focus,
.btn-note:focus,
.btn-image:focus,
.btn-complete:focus,
.btn-close:focus,
.btn-upload:focus,
.btn-cancel:focus,
.btn-save:focus {
    outline: 2px solid #3b82f6;
    outline-offset: 2px;
}

/* Smooth animations */
* {
    transition: all 0.2s ease;
}

/* Icon improvements */
.btn-inspect svg,
.btn-note svg,
.btn-image svg,
.btn-complete svg,
.btn-close svg,
.btn-upload svg,
.btn-cancel svg,
.btn-save svg,
.toggle-icon {
    flex-shrink: 0;
}
</style>

<script>
(function() {
    'use strict';
    
    // Configuration object
    const CONFIG = {
        selectors: {
            modal: '#inspectionModal',
            conditionInputs: 'input[name="condition"]',
            noteTextarea: '.note-textarea',
            imageUpload: '#imageUpload',
            imagePreview: '#imagePreview',
            statusTexts: '.status-text',
            customToggles: '.custom-toggle'
        },
        messages: {
            conditionRequired: 'Please select a condition',
            noteRequired: 'Please enter inspection notes',
            inspectionSaved: 'Inspection saved successfully!',
            inspectionCompleted: 'Inspection completed successfully!',
            completeAllItems: 'Please complete all inspection items before finishing'
        },
        timing: {
            notificationDelay: 100,
            notificationDuration: 3000,
            animationDuration: 300,
            completionDelay: 1500
        },
        styles: {
            success: 'linear-gradient(135deg, #10b981 0%, #059669 100%)',
            error: 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)',
            info: 'linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%)'
        }
    };
    
    // DOM elements cache
    let elements = {};
    
    // Initialize DOM elements
    function initElements() {
        elements.modal = document.querySelector(CONFIG.selectors.modal);
        elements.conditionInputs = document.querySelectorAll(CONFIG.selectors.conditionInputs);
        elements.noteTextarea = document.querySelector(CONFIG.selectors.noteTextarea);
        elements.imageUpload = document.querySelector(CONFIG.selectors.imageUpload);
        elements.imagePreview = document.querySelector(CONFIG.selectors.imagePreview);
        elements.statusTexts = document.querySelectorAll(CONFIG.selectors.statusTexts);
        elements.customToggles = document.querySelectorAll(CONFIG.selectors.customToggles);
    }
    
    // Open modal
    function openModal() {
        if (elements.modal) {
            elements.modal.style.display = 'flex';
        }
    }
    
    // Close modal
    function closeModal() {
        if (elements.modal) {
            elements.modal.style.display = 'none';
        }
    }
    
    // Save inspection
    function saveInspection() {
        const condition = document.querySelector('input[name="condition"]:checked');
        const note = elements.noteTextarea?.value || '';
        const image = elements.imageUpload?.files[0];
        
        if (!condition) {
            showNotification(CONFIG.messages.conditionRequired, 'error');
            return;
        }
        
        if (!note.trim()) {
            showNotification(CONFIG.messages.noteRequired, 'error');
            return;
        }
        
        // Save inspection data (you can implement your save logic here)
        console.log('Saving inspection:', {
            condition: condition.value,
            note: note,
            image: image ? image.name : null
        });
        
        showNotification(CONFIG.messages.inspectionSaved, 'success');
        closeModal();
    }
    
    // Complete inspection
    function completeInspection() {
        const hasPending = Array.from(elements.statusTexts).some(item => item.textContent === 'Pending');
        
        if (hasPending) {
            showNotification(CONFIG.messages.completeAllItems, 'error');
            return;
        }
        
        showNotification(CONFIG.messages.inspectionCompleted, 'success');
        
        setTimeout(() => {
            console.log('Inspection completed');
        }, CONFIG.timing.completionDelay);
    }

    // Show notification
    function showNotification(message, type = 'info') {
        const notification = document.createElement('div');
        notification.className = `notification notification-${type}`;
        notification.textContent = message;
        
        notification.style.cssText = `
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 12px 20px;
            border-radius: 0;
            color: white;
            font-weight: 500;
            z-index: ${CONFIG.timing.notificationDuration};
            opacity: 0;
            transform: translateX(100%);
            transition: all 0.3s ease;
        `;
        
        notification.style.background = CONFIG.styles[type] || CONFIG.styles.info;
        
        document.body.appendChild(notification);
        
        setTimeout(() => {
            notification.style.opacity = '1';
            notification.style.transform = 'translateX(0)';
        }, CONFIG.timing.notificationDelay);
        
        setTimeout(() => {
            notification.style.opacity = '0';
            notification.style.transform = 'translateX(100%)';
            setTimeout(() => {
                if (document.body.contains(notification)) {
                    document.body.removeChild(notification);
                }
            }, CONFIG.timing.animationDuration);
        }, CONFIG.timing.notificationDuration);
    }

    // Handle image upload and preview
    function initImageUpload() {
        if (elements.imageUpload && elements.imagePreview) {
            elements.imageUpload.addEventListener('change', function(event) {
                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        elements.imagePreview.src = e.target.result;
                    };
                    reader.readAsDataURL(file);
                }
            });
        }
    }
    
    // Initialize modal event handlers
    function initModalHandlers() {
        if (elements.modal) {
            elements.modal.addEventListener('click', function(e) {
                if (e.target === this) {
                    closeModal();
                }
            });
        }
        
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeModal();
            }
        });
    }
    
    // Initialize the application
    function init() {
        initElements();
        initImageUpload();
        initModalHandlers();
    }
    
    // Make functions globally accessible
    window.openModal = openModal;
    window.closeModal = closeModal;
    window.saveInspection = saveInspection;
    window.completeInspection = completeInspection;
    window.showNotification = showNotification;
    
    // Initialize when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();
</script>

<!-- Bootstrap 5 JS and Popper.js -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
<!-- JavaScript to toggle icon -->
<script>
(function() {
    'use strict';
    
    // Initialize toggle functionality
    function initToggles() {
        const customToggleRows = document.querySelectorAll('.custom-toggle');

        customToggleRows.forEach(row => {
            row.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                const targetSelector = this.getAttribute('data-target');
                const targetElements = document.querySelectorAll(targetSelector);
                
                if (targetElements.length > 0) {
                    const isCurrentlyShown = Array.from(targetElements).some(el => el.classList.contains('show'));
                    
                    if (isCurrentlyShown) {
                        closeTargets(targetElements, this);
                    } else {
                        closeAllOthers();
                        openTargets(targetElements, this);
                    }
                }
            });
        });
    }
    
    // Close target elements
    function closeTargets(targetElements, trigger) {
        targetElements.forEach(targetElement => {
            targetElement.classList.remove('show');
        });
        trigger.setAttribute('aria-expanded', 'false');
        updateIconRotation(trigger, 0);
    }
    
    // Open target elements
    function openTargets(targetElements, trigger) {
        targetElements.forEach(targetElement => {
            targetElement.classList.add('show');
        });
        trigger.setAttribute('aria-expanded', 'true');
        updateIconRotation(trigger, 180);
    }
    
    // Close all other open collapses
    function closeAllOthers() {
        const allCollapses = document.querySelectorAll('.collapse.show');
        allCollapses.forEach(collapse => {
            collapse.classList.remove('show');
            const otherTrigger = document.querySelector(`[data-target]`);
            if (otherTrigger) {
                otherTrigger.setAttribute('aria-expanded', 'false');
                updateIconRotation(otherTrigger, 0);
            }
        });
    }
    
    // Update icon rotation
    function updateIconRotation(trigger, degrees) {
        const icon = trigger.querySelector('.toggle-icon, .do-inspection-toggle-icon');
        if (icon) {
            icon.style.transform = `rotate(${degrees}deg)`;
        }
    }
    
    // Initialize when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initToggles);
    } else {
        initToggles();
    }
})();
</script>













<div class="container mt-5" id="Inspection-Summary-main">
    <h3>3. Inspection Summary</h3>
    <form>
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3 d-flex align-items-center justify-content-end" style="gap:50px;">
                    <label for="overallCondition" class="form-label">Overall Condition: </label>
                    <select class="form-select" id="overallCondition-select" required>
                        <option value="">Select</option>
                        <option value="aLittleWear">A little wear</option>
                    </select>
                </div>
                <div class="mb-3 d-flex align-items-center justify-content-end" style="gap:50px;">
                    <label class="form-label">Vehicle Safe to Use: </label>
                    <div class="yes-no-checkbox-main-Inspection-Summary">
                        <div class="form-check" id="Inspection-Summary-Checkbox-Yes-Safe">
                            <input class="form-check-input" type="checkbox" id="yesSafe" value="yes" name="safeGroup" onchange="handleCheckboxChange('safeGroup', this)">
                            <label class="form-check-label" for="yesSafe">Yes</label>
                        </div>
                        <div class="form-check" id="Inspection-Summary-Checkbox-No-Safe">
                            <input class="form-check-input" type="checkbox" id="noSafe" value="no" name="safeGroup" onchange="handleCheckboxChange('safeGroup', this)">
                            <label class="form-check-label" for="noSafe">No</label>
                        </div>
                    </div>
                </div>
                <div class="mb-3 d-flex justify-content-end" style="gap:50px;">
                    <label for="additionalNote" class="form-label">Additional Note:</label>
                    <textarea class="form-control" id="additionalNote" rows="3"></textarea>
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3 d-flex align-items-center justify-content-end" style="gap:50px;">
                    <label class="form-label">Maintenance Required *</label>
                    <div class="yes-no-checkbox-main-Inspection-Summary">
                        <div class="form-check" id="Inspection-Summary-Checkbox-Yes-Maintenance">
                            <input class="form-check-input" type="checkbox" id="yesMaintenance" value="yes" name="maintenanceGroup" onchange="handleCheckboxChange('maintenanceGroup', this)">
                            <label class="form-check-label" for="yesMaintenance">Yes</label>
                        </div>
                        <div class="form-check" id="Inspection-Summary-Checkbox-No-Maintenance">
                            <input class="form-check-input" type="checkbox" id="noMaintenance" value="no" name="maintenanceGroup" onchange="handleCheckboxChange('maintenanceGroup', this)">
                            <label class="form-check-label" for="noMaintenance">No</label>
                        </div>
                    </div>
                </div>
                <div class="mb-3 d-flex align-items-center justify-content-end" style="gap:50px;">
                    <label for="vehicleStatus" class="form-label">Vehicle Status *</label>
                    <select class="form-select" id="vehicleStatus-select" required>
                        <option value="">Select</option>
                        <option value="maintenanceRequired">Maintenance Required</option>
                    </select>
                </div>
            </div>
        </div>
        <button type="submit" class="Inspection-Summary-btn">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                <g fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                    <path d="M20 12V5.749a.6.6 0 0 0-.176-.425l-3.148-3.148A.6.6 0 0 0 16.252 2H4.6a.6.6 0 0 0-.6.6v18.8a.6.6 0 0 0 .6.6H11M8 10h8M8 6h4m-4 8h3m9.5 6.5L22 22" />
                    <path d="M15 18a3 3 0 1 0 6 0a3 3 0 0 0-6 0m1-16v3.4a.6.6 0 0 0 .6.6H20" />
                </g>
            </svg>
            Generate Report</button>
    </form>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function handleCheckboxChange(groupName, currentCheckbox) {
        const checkboxes = document.querySelectorAll(`input[name="${groupName}"]`);
        checkboxes.forEach(checkbox => {
            if (checkbox !== currentCheckbox) {
                checkbox.checked = false;
            }
        });
    }
</script>
@endsection