@extends('welcome')

@section('title', 'Sites KPI')

@section('styles')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Jost:wght@300;400;500;600;700&display=swap" rel="stylesheet">
@endsection

@section('content')
<div class="sites-kpi-container">
    <div class="header-gradient">
        <div class="header-content">
            <div class="header-left">
                <a href="{{ route('dashboard.team_kpi.home') }}" class="back-button">
                    <i class="fas fa-arrow-left"></i>
                </a>
                <h1 class="header-title">Sites KPI</h1>
            </div>
        </div>
    </div>
    
    <div class="sites-kpi-content">
        <div class="content-box">
            <div class="kpi-cards-grid">
                <div class="kpi-card">
                    <div class="kpi-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div class="kpi-content">
                        <h3>Total Sites</h3>
                        <div class="kpi-value" id="total-sites">00</div>
                        <div class="kpi-label">Count</div>
                    </div>
                </div>
                
                <div class="kpi-card">
                    <div class="kpi-icon success">
                        <i class="fas fa-clipboard-check"></i>
                    </div>
                    <div class="kpi-content">
                        <h3>Total Inspections</h3>
                        <div class="kpi-value" id="total-inspections">00</div>
                        <div class="kpi-label">Count</div>
                    </div>
                </div>
            </div>
            
            <div class="placeholder-message">
                <i class="fas fa-chart-bar"></i>
                <p>Sites analytics and charts will be displayed here</p>
            </div>
        </div>
    </div>
</div>

<style>
@import url('https://fonts.googleapis.com/css2?family=Jost:wght@300;400;500;600;700&display=swap');
:root{--primary-color:#0055a5;--font-family:'Jost',sans-serif}
.sites-kpi-container{min-height:100vh;background:#f8fafc;font-family:var(--font-family)}
.header-gradient{background:#0055a5;padding:20px 0;box-shadow:0 4px 12px rgba(0,85,165,.3)}
.header-content{padding:0 20px;display:flex;align-items:center;justify-content:space-between}
.header-left{display:flex;align-items:center;gap:15px}
.back-button{color:white;font-size:20px;text-decoration:none;padding:8px;border-radius:50%}
.back-button:hover{background-color:rgba(255,255,255,.1)}
.header-title{color:white;font-size:28px;font-weight:700;margin:0}
.sites-kpi-content{padding:30px 20px}
.content-box{background:white;padding:30px;border-radius:.5rem;box-shadow:0 .5rem 1rem rgba(0,0,0,.15);border:1px solid #e2e8f0}
.kpi-cards-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(280px,1fr));gap:1.5rem;margin-bottom:2rem}
.kpi-card{background:white;border:1px solid #e2e8f0;border-radius:.5rem;padding:1.5rem;box-shadow:0 .125rem .25rem rgba(0,0,0,.075);display:flex;align-items:center;gap:1rem}
.kpi-icon{width:56px;height:56px;background:linear-gradient(135deg,#3b82f6,#1d4ed8);border-radius:.375rem;display:flex;align-items:center;justify-content:center;color:white;font-size:24px}
.kpi-icon.success{background:linear-gradient(135deg,#10b981,#059669)}
.kpi-content{flex:1}
.kpi-content h3{font-size:14px;font-weight:500;color:#6c757d;margin:0 0 8px 0}
.kpi-value{font-size:32px;font-weight:700;color:var(--primary-color);margin:0}
.kpi-label{font-size:12px;color:#6c757d;text-transform:uppercase}
.placeholder-message{text-align:center;padding:60px 20px;color:#6c757d}
.placeholder-message i{font-size:64px;color:#0055a5;margin-bottom:20px}
.placeholder-message p{font-size:18px;margin:0}
</style>
@endsection

