import React, { useState } from 'react';
import {
  View,
  Text,
  StyleSheet,
  StatusBar,
  Dimensions,
  TouchableOpacity,
} from 'react-native';
import LinearGradient from 'react-native-linear-gradient';
import Basic_Details_TeamTab1 from './Basic_Details_TeamTab1';
import { useRoute, useNavigation } from '@react-navigation/native';
import MaterialIcons from 'react-native-vector-icons/MaterialIcons';

const { height } = Dimensions.get('window');
const TOTAL_HEADER_HEIGHT = height * 0.1;

const Team_memberHeader = () => {
  const route = useRoute();
  const navigation = useNavigation();
  const initialTeamData = route.params?.teamData || {};
  const [teamData, setTeamData] = useState(initialTeamData);

  const updateTeamData = (newData) => {
    setTeamData((prevData) => ({ ...prevData, ...newData }));
  };

  return (
    <View style={styles.container}>
      <LinearGradient
        colors={['#3481BC', '#025383']}
        style={[styles.header, { height: TOTAL_HEADER_HEIGHT }]}
      >
        <StatusBar translucent backgroundColor="transparent" barStyle="light-content" />
        <View style={styles.simpleHeaderContent}>
          <TouchableOpacity onPress={() => navigation.goBack()} style={styles.backButton}>
            <MaterialIcons name="arrow-back" size={26} color="#fff" />
          </TouchableOpacity>
          <Text style={styles.headerTitle}>Create User</Text>
        </View>
      </LinearGradient>

      <View style={styles.mainContent}>
        <Basic_Details_TeamTab1
          teamData={teamData}
          updateTeamData={updateTeamData}
        />
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: '#fff',
  },
  header: {
    width: '100%',
    paddingBottom: 15,
  },
  simpleHeaderContent: {
    flex: 1,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    marginTop: '9%',
    position: 'relative',
  },
  backButton: {
    position: 'absolute',
    left: 0,
    padding: 10,
    zIndex: 1,
  },
  headerTitle: {
    fontSize: 22,
    color: '#fff',
    fontWeight: '500',
    // marginLeft: 30, // To offset for the arrow
  },
  mainContent: {
    flex: 1,
  },
});

export default Team_memberHeader;