<?php
/**
 * Simple FCM Test Script
 * Upload this to your server and access via browser
 */

header('Content-Type: text/html; charset=utf-8');

echo "<h1>FCM Configuration Test</h1>";

// Check if FCM Server Key is configured
$fcmServerKey = 'YOUR_FCM_SERVER_KEY'; // Replace with your actual key

if ($fcmServerKey === 'YOUR_FCM_SERVER_KEY') {
    echo "<p style='color: red;'>❌ FCM Server Key not configured!</p>";
    echo "<p>Please update the FCM Server Key in titanNotificationsFCM.php</p>";
    echo "<hr>";
    echo "<h2>How to Get FCM Server Key:</h2>";
    echo "<ol>";
    echo "<li>Go to <a href='https://console.firebase.google.com/' target='_blank'>Firebase Console</a></li>";
    echo "<li>Select project: <strong>titan-drilling-1f8e9</strong></li>";
    echo "<li>Click Project Settings (gear icon)</li>";
    echo "<li>Go to 'Cloud Messaging' tab</li>";
    echo "<li>Copy the 'Server Key' (starts with AAAA...)</li>";
    echo "<li>Replace 'YOUR_FCM_SERVER_KEY' in titanNotificationsFCM.php</li>";
    echo "</ol>";
    exit();
}

echo "<p style='color: green;'>✅ FCM Server Key configured</p>";

// Test FCM API with a dummy token
$testData = [
    'to' => 'test_token_123',
    'notification' => [
        'title' => 'Test Notification',
        'body' => 'This is a test notification'
    ]
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: key=' . $fcmServerKey,
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($testData));
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<h2>FCM API Test Results:</h2>";
echo "<p>HTTP Code: {$httpCode}</p>";
echo "<p>Response: " . htmlspecialchars($response) . "</p>";

$result = json_decode($response, true);

if ($httpCode === 200) {
    if ($result && isset($result['failure']) && $result['failure'] == 1) {
        echo "<p style='color: orange;'>⚠️ FCM API working but test token invalid (expected)</p>";
        echo "<p>Error: " . ($result['results'][0]['error'] ?? 'Unknown') . "</p>";
    } else {
        echo "<p style='color: green;'>✅ FCM API working correctly</p>";
    }
} else {
    echo "<p style='color: red;'>❌ FCM API error</p>";
    if ($result && isset($result['error'])) {
        echo "<p>Error: " . $result['error'] . "</p>";
    }
}

echo "<hr>";
echo "<h2>Next Steps:</h2>";
echo "<ol>";
echo "<li>Make sure your FCM Server Key is correct</li>";
echo "<li>Generate FCM tokens in your app</li>";
echo "<li>Test with 'Check Current Token Validity' button</li>";
echo "<li>If token is invalid, regenerate it</li>";
echo "</ol>";
?> 