// File: DocumentPickerExample.tsx
import React from 'react';
import { Button, View, Alert } from 'react-native';
import { pick } from '@react-native-documents/picker';

export default function docxpickertest() {
  const handlePick = async () => {
    try {
      const [file] = await pick({
        type: ['application/pdf'], // only allow PDFs
      });

      Alert.alert('Document Picked', `Name: ${file.name}\nSize: ${file.size} bytes`);
      console.log('File URI:', file.uri);
    } catch (error) {
      if (error instanceof Error) {
        Alert.alert('Error', error.message);
      } else {
        console.log('Unknown error:', error);
      }
    }
  };

  return (
    <View style={{ flex: 1, justifyContent: 'center', alignItems: 'center' }}>
      <Button title="Pick a PDF" onPress={handlePick} />
    </View>
  );
}
