<?php $__env->startSection('title', 'Salary Advance Applications'); ?>

<?php $__env->startSection('styles'); ?>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<style>
:root {
    --primary-color: #0055a5;
    --primary-hover: #003f7d;
    --success-color: #22c55e;
    --warning-color: #f97316;
    --danger-color: #dc2626;
    --text-primary: #0f172a;
    --text-secondary: #475569;
    --bg-page: #f5f7fb;
    --bg-card: #ffffff;
    --border-color: #e2e8f0;
    --shadow-sm: 0 10px 30px rgba(15, 23, 42, 0.06);
    --radius-lg: 20px;
}

body {
    font-family: 'Inter', sans-serif;
}

.page-shell {
    min-height: 100vh;
    background: var(--bg-page);
}

.hero {
    background: linear-gradient(160deg, #0055a5 0%, #002b54 100%);
    padding: 28px 32px;
    color: white;
    box-shadow: 0 15px 35px rgba(5, 30, 55, 0.25);
}

.hero-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 16px;
    flex-wrap: wrap;
}

.hero-left h1 {
    font-size: 28px;
    margin: 0 0 4px;
    font-weight: 600;
}

.hero-left p {
    margin: 0;
    opacity: 0.9;
}

.hero-actions {
    display: flex;
    gap: 12px;
}

.btn-primary {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    background: white;
    color: var(--primary-color);
    padding: 12px 24px;
    font-weight: 600;
    border-radius: 999px;
    text-decoration: none;
    transition: transform 0.2s ease;
    box-shadow: 0 10px 25px rgba(255, 255, 255, 0.25);
}

.btn-primary:hover {
    transform: translateY(-2px);
    color: var(--primary-color);
}

.content-shell {
    padding: 30px;
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.metrics-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 16px;
}

.metric-card {
    background: var(--bg-card);
    border-radius: var(--radius-lg);
    padding: 18px;
    border: 1px solid var(--border-color);
    box-shadow: var(--shadow-sm);
    position: relative;
    overflow: hidden;
}

.metric-card span.label {
    font-size: 13px;
    color: var(--text-secondary);
    text-transform: uppercase;
    letter-spacing: 0.08em;
}

.metric-card h3 {
    margin: 10px 0 0;
    font-size: 30px;
    color: var(--text-primary);
}

.metric-card small {
    color: var(--text-secondary);
}

.panel {
    background: var(--bg-card);
    border-radius: var(--radius-lg);
    border: 1px solid var(--border-color);
    box-shadow: var(--shadow-sm);
    overflow: hidden;
}

.panel-header {
    padding: 22px 24px;
    display: flex;
    align-items: center;
    gap: 14px;
    border-bottom: 1px solid var(--border-color);
}

.panel-header h2 {
    margin: 0;
    font-size: 20px;
    color: var(--text-primary);
}

.applications-list {
    padding: 26px;
    display: flex;
    flex-direction: column;
    gap: 16px;
}

.application-card {
    border: 1px solid var(--border-color);
    border-radius: 18px;
    padding: 20px;
    background: white;
    box-shadow: 0 12px 32px rgba(15, 23, 42, 0.06);
    transition: all 0.2s ease;
    cursor: pointer;
}

.application-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 15px 35px rgba(15, 23, 42, 0.08);
}

.card-head {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: 16px;
}

.applicant-name {
    font-size: 18px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0;
}

.muted {
    color: var(--text-secondary);
    font-size: 14px;
    margin: 2px 0 0;
}

.badge {
    padding: 6px 16px;
    border-radius: 999px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.badge.pending { background: #fff4ce; color: #a15c00; }
.badge.approved { background: #dcfce7; color: #15803d; }
.badge.rejected { background: #fee2e2; color: #b91c1c; }

.card-body-grid {
    margin: 18px 0;
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
    gap: 14px;
}

.info-block span {
    display: block;
    font-size: 12px;
    text-transform: uppercase;
    color: var(--text-secondary);
    letter-spacing: 0.05em;
}

.info-block strong {
    font-size: 16px;
    color: var(--text-primary);
}

.card-actions {
    display: flex;
    justify-content: flex-end;
}

.btn-menu {
    border: 1px solid var(--border-color);
    background: #f8fafc;
    color: var(--text-secondary);
    border-radius: 999px;
    width: 40px;
    height: 40px;
    display: grid;
    place-items: center;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-menu:hover {
    background: var(--primary-color);
    color: white;
    border-color: var(--primary-color);
}

.loading-state,
.empty-state {
    padding: 60px 20px;
    text-align: center;
    color: var(--text-secondary);
}

.loading-spinner {
    width: 44px;
    height: 44px;
    border-radius: 50%;
    border: 4px solid #e2e8f0;
    border-top-color: var(--primary-color);
    animation: spin 1s linear infinite;
    margin: 0 auto 16px;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

.action-menu {
    position: fixed;
    background: white;
    border-radius: 16px;
    box-shadow: 0 25px 60px rgba(15, 23, 42, 0.18);
    min-width: 190px;
    z-index: 2000;
    overflow: hidden;
    border: 1px solid rgba(148, 163, 184, 0.3);
}

.action-menu-item {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 12px 16px;
    font-size: 14px;
    color: var(--text-primary);
    cursor: pointer;
}

.action-menu-item:hover {
    background: #f8fafc;
}

.action-menu-item-danger {
    color: var(--danger-color);
}

.toast {
    position: fixed;
    top: 90px;
    right: 24px;
    background: #0f172a;
    color: white;
    padding: 14px 20px;
    border-radius: 12px;
    box-shadow: 0 15px 40px rgba(15, 23, 42, 0.25);
    opacity: 0;
    transform: translateX(120%);
    transition: all 0.3s ease;
    z-index: 2100;
    font-weight: 500;
}

.toast.show {
    opacity: 1;
    transform: translateX(0);
}

@media (max-width: 768px) {
    .hero,
    .content-shell {
        padding: 20px;
    }

    .applications-list {
        padding: 18px;
    }

    .card-body-grid {
        grid-template-columns: 1fr;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-shell">
    <div class="hero">
        <div class="hero-content">
            <div class="hero-left">
                <p style="font-size: 14px; letter-spacing: 0.08em; text-transform: uppercase; opacity: .8;">
                    HR Module / Salary Advance
                </p>
                <h1>Salary Advance Applications</h1>
                <p>Monitor requests, review statuses, and take action instantly.</p>
            </div>
            <div class="hero-actions">
                <a href="<?php echo e(route('hr.create.application')); ?>" class="btn-primary">
                    <i class="fas fa-plus"></i>
                    New Advance
                </a>
            </div>
        </div>
    </div>

    <div class="content-shell">
        <div class="metrics-grid">
            <div class="metric-card">
                <span class="label">Total Requests</span>
                <h3 id="metricTotal">0</h3>
                <small>Across all projects</small>
            </div>
            <div class="metric-card">
                <span class="label">Pending</span>
                <h3 id="metricPending">0</h3>
                <small>Awaiting approval</small>
            </div>
            <div class="metric-card">
                <span class="label">Approved</span>
                <h3 id="metricApproved">0</h3>
                <small>Ready for payout</small>
            </div>
            <div class="metric-card">
                <span class="label">Rejected</span>
                <h3 id="metricRejected">0</h3>
                <small>Need follow-up</small>
            </div>
        </div>

        <div class="panel">
            <div class="panel-header">
                <div style="width: 46px; height: 46px; border-radius: 16px; background: rgba(0,85,165,.15); display: grid; place-items: center;">
                    <i class="fas fa-money-bill-wave" style="color: white;"></i>
                </div>
                <h2>Recent Applications</h2>
            </div>
            <div class="applications-list" id="applicationsList">
                <div class="loading-state" id="loadingState">
                    <div class="loading-spinner"></div>
                    <p>Loading salary advance applications...</p>
                </div>
                <div class="empty-state" id="emptyState" style="display:none;">
                    <i class="fas fa-folder-open" style="font-size: 44px; margin-bottom: 12px;"></i>
                    <p>No salary advance applications to show.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="toast" class="toast"></div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
const CSRF_TOKEN = document.querySelector('meta[name="csrf-token"]')?.content || '';
const HR_API_BASE_URL = <?php echo json_encode(rtrim(env('MONGODB_HR_API_BASE_URL', 'https://api.titandrillingzm.com:6013'), '/')) ?>;
const HR_REMOTE_UID_RAW = <?php echo json_encode(config('services.hr_module.admin_uid'), 15, 512) ?>;
const HR_REMOTE_UID = encodeURIComponent(HR_REMOTE_UID_RAW);
const STORAGE_KEY = 'salaryAdvanceApplications';
const COUNT_KEY = 'salaryAdvanceCount';

document.addEventListener('DOMContentLoaded', () => {
    loadSalaryApplications();
});

async function fetchHrApplicationsData(applicationType, queryParams = '') {
    const normalizedQuery = queryParams
        ? (queryParams.startsWith('?') ? queryParams : `?${queryParams}`)
        : '';

    const endpoints = [
        {
            label: 'laravel',
            url: `/api/hr-applications/${applicationType}${normalizedQuery}`,
            options: { credentials: 'same-origin', headers: { Accept: 'application/json' } }
        },
        {
            label: 'remote',
            url: `${HR_API_BASE_URL}/hr-applications/${applicationType}/${HR_REMOTE_UID}${normalizedQuery}`,
            options: { credentials: 'omit', headers: { Accept: 'application/json' } }
        }
    ];

    let lastError = null;

    for (const endpoint of endpoints) {
        try {
            const response = await fetch(endpoint.url, endpoint.options);
            if (!response.ok) {
                const text = await response.text();
                console.warn(`[${applicationType}] ${endpoint.label} responded ${response.status}`, text);
                lastError = new Error(`HTTP ${response.status}`);
                continue;
            }

            const payload = await response.json();
            const applications = Array.isArray(payload?.data)
                ? payload.data
                : Array.isArray(payload?.applications)
                    ? payload.applications
                    : Array.isArray(payload)
                        ? payload
                        : null;

            if (applications !== null) {
                console.log(`[${applicationType}] Loaded from ${endpoint.label}`, endpoint.url);
                return { applications, raw: payload, endpoint: endpoint.url };
            }

            lastError = new Error('Unexpected response shape');
        } catch (error) {
            console.error(`[${applicationType}] Fetch error from ${endpoint.url}`, error);
            lastError = error;
        }
    }

    throw lastError || new Error('Unable to load applications');
}

async function loadSalaryApplications() {
    const loadingState = document.getElementById('loadingState');
    const emptyState = document.getElementById('emptyState');
    const applicationsList = document.getElementById('applicationsList');

    if (loadingState) loadingState.style.display = 'block';
    if (emptyState) emptyState.style.display = 'none';

    try {
        const { applications } = await fetchHrApplicationsData('salary_advance_application');
        if (loadingState) loadingState.style.display = 'none';

        const normalized = Array.isArray(applications) ? applications : Object.values(applications || {});

        if (!normalized.length) {
            if (emptyState) emptyState.style.display = 'block';
            updateHomePageCounts([]);
            applicationsList?.querySelectorAll('.application-card').forEach(card => card.remove());
            return;
        }

        if (emptyState) emptyState.style.display = 'none';
        updateHomePageCounts(normalized);
        displayApplications(normalized);
    } catch (error) {
        console.error('Error loading salary advance applications:', error);
        if (loadingState) loadingState.style.display = 'none';
        if (emptyState) emptyState.style.display = 'block';
        showToast('Failed to load salary advance applications.', 'error');
    }
}

function displayApplications(applications) {
    const list = document.getElementById('applicationsList');
    if (!list) return;

    list.querySelectorAll('.application-card').forEach(card => card.remove());

    const store = {};
    applications.forEach(app => {
        const key = app.id || app._id || app.applicationId || `salary_${Date.now()}`;
        store[key] = { ...app, _storageKey: key };
    });
    sessionStorage.setItem(STORAGE_KEY, JSON.stringify(store));

    const sorted = Object.values(store).sort((a, b) =>
        new Date(b.submittedAt || b.createdAt || 0) - new Date(a.submittedAt || a.createdAt || 0)
    );

    sorted.forEach(app => {
        const card = createApplicationCard(app);
        list.appendChild(card);
    });

    addCardListeners();
}

function createApplicationCard(application) {
    const card = document.createElement('div');
    card.className = 'application-card';
    const applicationId = application._storageKey || application.id || application._id;
    card.dataset.applicationId = applicationId;

    const status = (application.status || 'pending').toLowerCase();
    const badgeClass = ['approved', 'rejected'].includes(status) ? status : 'pending';
    const amount = application.salaryAdvanceAmount
        ? `K ${Number(application.salaryAdvanceAmount).toLocaleString()}`
        : 'N/A';

    const recovery = application.selectedRecoveryPeriod
        ? application.selectedRecoveryPeriod.replace('_', ' ')
        : 'N/A';

    const sites = Array.isArray(application.selectedSites) && application.selectedSites.length
        ? application.selectedSites.map(site => site.toUpperCase()).join(', ')
        : application.salaryAdvanceOtherSite || 'N/A';

    const reasons = Array.isArray(application.selectedReasons) && application.selectedReasons.length
        ? application.selectedReasons.map(reason => reason.replace(/_/g, ' '))
        : application.salaryAdvanceOtherReason || 'N/A';

    card.innerHTML = `
        <div class="card-head">
            <div>
                <p class="applicant-name">${application.fullName || 'Unknown Applicant'}</p>
                <p class="muted">Employee #${application.employeeNo || 'N/A'} • ${application.department || 'N/A'}</p>
            </div>
            <span class="badge ${badgeClass}">${status}</span>
        </div>
        <div class="card-body-grid">
            <div class="info-block">
                <span>Amount</span>
                <strong>${amount}</strong>
            </div>
            <div class="info-block">
                <span>Recovery</span>
                <strong>${recovery}</strong>
            </div>
            <div class="info-block">
                <span>Sites</span>
                <strong>${sites}</strong>
            </div>
            <div class="info-block">
                <span>Reasons</span>
                <strong>${reasons}</strong>
            </div>
        </div>
        <div class="card-actions">
            <button class="btn-menu" title="Actions">
                <i class="fas fa-ellipsis-h"></i>
            </button>
        </div>
    `;

    return card;
}

function addCardListeners() {
    document.querySelectorAll('.application-card').forEach(card => {
        card.addEventListener('click', e => {
            if (e.target.closest('.btn-menu')) return;
            const applicationId = card.dataset.applicationId;
            window.location.href = `/application-detail?id=${applicationId}&type=salary_advance_application`;
        });
    });

    document.querySelectorAll('.btn-menu').forEach(btn => {
        btn.addEventListener('click', e => {
            e.stopPropagation();
            const card = btn.closest('.application-card');
            showActionMenu(btn, card.dataset.applicationId);
        });
    });
}

let currentMenu = null;

function showActionMenu(anchor, applicationId) {
    if (currentMenu) {
        currentMenu.remove();
        currentMenu = null;
    }

    const menu = document.createElement('div');
    menu.className = 'action-menu';
    menu.innerHTML = `
        <div class="action-menu-item" data-action="view"><i class="fas fa-eye"></i> View details</div>
        <div class="action-menu-item" data-action="approve"><i class="fas fa-check"></i> Approve</div>
        <div class="action-menu-item" data-action="reject"><i class="fas fa-times"></i> Reject</div>
        <div class="action-menu-item action-menu-item-danger" data-action="delete"><i class="fas fa-trash"></i> Delete</div>
    `;

    const rect = anchor.getBoundingClientRect();
    menu.style.top = `${rect.bottom + 8}px`;
    menu.style.left = `${rect.left - 120}px`;
    document.body.appendChild(menu);
    currentMenu = menu;

    menu.querySelectorAll('.action-menu-item').forEach(item => {
        item.addEventListener('click', () => {
            handleMenuAction(item.dataset.action, applicationId);
            menu.remove();
            currentMenu = null;
        });
    });

    setTimeout(() => {
        document.addEventListener('click', function closeMenu(event) {
            if (menu && !menu.contains(event.target)) {
                menu.remove();
                currentMenu = null;
                document.removeEventListener('click', closeMenu);
            }
        });
    }, 0);
}

async function handleMenuAction(action, applicationId) {
    const store = JSON.parse(sessionStorage.getItem(STORAGE_KEY) || '{}');
    const application = store[applicationId];

    if (!application) {
        showToast('Application not found', 'error');
        return;
    }

    switch (action) {
        case 'view':
            window.location.href = `/application-detail?id=${applicationId}&type=salary_advance_application`;
            break;
        case 'approve':
            confirmAction('Approve application?', () => updateStatus(applicationId, 'approved'));
            break;
        case 'reject':
            confirmAction('Reject application?', () => updateStatus(applicationId, 'rejected'));
            break;
        case 'delete':
            confirmAction('Delete this application? This cannot be undone.', () => deleteApplication(applicationId), true);
            break;
    }
}

function confirmAction(message, onConfirm, isDanger = false) {
    const confirmed = window.confirm(message);
    if (confirmed) onConfirm();
}

async function updateStatus(applicationId, status) {
    try {
        const response = await fetch(`/api/hr-applications/${applicationId}/status`, {
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': CSRF_TOKEN
            },
            body: JSON.stringify({
                status,
                comments: '',
                approverName: 'HR Admin',
                approverRole: 'ProAdmin',
                reason: `${status} via portal`,
                timestamp: new Date().toISOString()
            })
        });

        if (!response.ok) throw new Error('Failed to update status');

        const result = await response.json();
        if (!result.success) throw new Error(result.error || 'Status update failed');

        showToast(`Application ${status}`, 'success');
        loadSalaryApplications();
    } catch (error) {
        console.error('Status update error:', error);
        showToast('Unable to update status', 'error');
    }
}

async function deleteApplication(applicationId) {
    try {
        const response = await fetch(`/api/hr-applications/${applicationId}`, {
            method: 'DELETE',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': CSRF_TOKEN
            }
        });

        if (!response.ok) throw new Error('Failed to delete application');

        const result = await response.json();
        if (!result.success) throw new Error(result.error || 'Delete failed');

        showToast('Application deleted', 'success');
        loadSalaryApplications();
    } catch (error) {
        console.error('Delete error:', error);
        showToast('Unable to delete application', 'error');
    }
}

function updateHomePageCounts(applications) {
    const list = Array.isArray(applications) ? applications : Object.values(applications || {});
    const pending = list.filter(app => (app.status || 'pending').toLowerCase() === 'pending').length;
    const approved = list.filter(app => (app.status || '').toLowerCase() === 'approved').length;
    const rejected = list.filter(app => (app.status || '').toLowerCase() === 'rejected').length;
    const total = list.length;

    document.getElementById('metricTotal').textContent = total;
    document.getElementById('metricPending').textContent = pending;
    document.getElementById('metricApproved').textContent = approved;
    document.getElementById('metricRejected').textContent = rejected;

    localStorage.setItem(COUNT_KEY, JSON.stringify({
        total, pending, approved, rejected, lastUpdated: new Date().toISOString()
    }));
}

function showToast(message, type = 'info') {
    const toast = document.getElementById('toast');
    toast.textContent = message;
    toast.style.background = type === 'success'
        ? 'linear-gradient(120deg,#16a34a,#22c55e)'
        : type === 'error'
            ? 'linear-gradient(120deg,#dc2626,#ef4444)'
            : 'linear-gradient(120deg,#0f172a,#1e293b)';
    toast.classList.add('show');
    setTimeout(() => toast.classList.remove('show'), 3200);
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('welcome', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/titandrillingzm/public_html/admin.titandrillingzm.com/resources/views/hr/salary-advance.blade.php ENDPATH**/ ?>