<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Titan Drilling</title>
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        /* CSS Variables for better maintainability */
        :root {
            --primary-color: #0055a5;
            --primary-hover: #3b82f6;
            --text-primary: #1a202c;
            --text-secondary: #374151;
            --text-muted: #718096;
            --text-light: #6b7280;
            --bg-primary: #f8fafc;
            --bg-white: #ffffff;
            --border-color: #d1d5db;
            --border-light: #e2e8f0;
            --shadow-sm: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
            --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            --radius-sm: 0;
            --radius-md: 0;
            --transition-base: all 0.2s ease;
            --transition-slow: all 0.3s ease;
            --font-family: 'Jost', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            --z-index-toggle: 1;
        }

        /* Reset and base styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: var(--font-family);
            background: var(--bg-primary) url('<?php echo e(asset("images/jut9.jpg")); ?>') center/cover no-repeat;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
            animation: backgroundSlide 80s ease-in-out infinite;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: var(--bg-primary);
            opacity: 0.8;
            z-index: -1;
            animation: overlayPulse 80s ease-in-out infinite;
        }

        @keyframes backgroundSlide {
            0%, 100% {
                background-position: center center;
                background-size: 100% auto;
            }
            25% {
                background-position: 20% 20%;
                background-size: 102% auto;
            }
            50% {
                background-position: 80% 30%;
                background-size: 105% auto;
            }
            75% {
                background-position: 60% 70%;
                background-size: 118% auto;
            }
        }

        @keyframes overlayPulse {
            0%, 100% {
                opacity: 0.8;
            }
            50% {
                opacity: 0.6;
            }
        }

        /* Main container */
        .admin-login-container {
            background: var(--bg-white);
            border-radius: var(--radius-sm);
            box-shadow: var(--shadow-md);
            padding: 32px;
            width: 100%;
            max-width: 400px;
            border: 1px solid var(--border-light);
        }

        /* Header styles */
        .admin-header {
            text-align: center;
            margin-bottom: 32px;
        }

        .admin-title {
            font-size: 24px;
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 8px;
        }

        .admin-subtitle {
            color: var(--text-muted);
            font-size: 14px;
        }

        /* Form styles */
        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            display: block;
            margin-bottom: 6px;
            font-weight: 500;
            color: var(--text-secondary);
            font-size: 14px;
        }

        .form-input {
            width: 100%;
            padding: 14px 12px;
            border: 1px solid var(--border-color);
            border-radius: var(--radius-sm);
            font-size: 16px;
            transition: var(--transition-base);
            background: var(--bg-white);
            min-height: 48px;
            font-family: var(--font-family);
        }

        .form-input:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        }

        /* Password container */
        .password-container {
            position: relative;
        }

        .password-toggle {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--text-light);
            cursor: pointer;
            font-size: 14px;
            z-index: var(--z-index-toggle);
            transition: var(--transition-base);
        }

        .password-toggle:hover {
            color: var(--text-secondary);
        }

        /* Button styles */
        .login-button {
            width: 100%;
            padding: 16px;
            background: var(--primary-color);
            color: var(--bg-white);
            border: none;
            border-radius: var(--radius-sm);
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: var(--transition-slow);
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            min-height: 52px;
            font-family: var(--font-family);
        }

        .login-button::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.8s;
        }

        .login-button:hover {
            background: var(--primary-color);
        }

        .login-button:hover::before {
            left: 100%;
        }

        .login-button:active {
            box-shadow: 0 4px 15px rgba(37, 99, 235, 0.2);
        }

        .login-button:disabled {
            background: rgba(156, 163, 175, 0.68);
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }

        .login-button:disabled:hover {
            background: #9ca3af;
            transform: none;
            box-shadow: none;
        }

        /* Message styles */
        .error-message,
        .success-message {
            padding: 12px;
            border-radius: var(--radius-sm);
            margin-bottom: 20px;
            font-size: 14px;
            display: none;
            font-family: var(--font-family);
        }

        .error-message {
            background: #fef2f2;
            color: #dc2626;
        }

        .success-message {
            background: #f0fdf4;
            color: #16a34a;
        }

        /* Field error styles */
        .field-error {
            margin-top: 6px;
            min-height: 18px;
        }

        .error-text {
            color: #dc2626;
            font-size: 12px;
            font-weight: 500;
            font-family: var(--font-family);
            display: block;
            line-height: 1.4;
        }

        /* ===== RESPONSIVE DESIGN ===== */
        @media (max-width: 768px) {
            body {
                padding: 16px;
                align-items: flex-start;
                padding-top: 40px;
            }
            
            .admin-login-container {
                padding: 24px;
                max-width: 100%;
                margin: 0 auto;
            }
            
            .admin-header {
                margin-bottom: 24px;
            }
            
            .admin-title {
                font-size: 22px;
            }
            
            .admin-subtitle {
                font-size: 13px;
            }
            
            .form-group {
                margin-bottom: 18px;
            }
            
            .form-label {
                font-size: 15px;
                margin-bottom: 8px;
            }
            
            .form-input {
                padding: 16px 14px;
                font-size: 16px;
                min-height: 52px;
            }
            
            .login-button {
                padding: 18px;
                font-size: 16px;
                min-height: 56px;
            }
            
            .error-message,
            .success-message {
                padding: 14px;
                font-size: 15px;
                margin-bottom: 18px;
            }
            
            .error-text {
                font-size: 13px;
            }
        }

        @media (max-width: 576px) {
            body {
                padding: 12px;
                padding-top: 20px;
            }
            
            .admin-login-container {
                padding: 20px;
            }
            
            .admin-header {
                margin-bottom: 20px;
            }
            
            .admin-title {
                font-size: 20px;
            }
            
            .admin-subtitle {
                font-size: 12px;
            }
            
            .form-group {
                margin-bottom: 16px;
            }
            
            .form-label {
                font-size: 14px;
                margin-bottom: 6px;
            }
            
            .form-input {
                padding: 14px 12px;
                font-size: 16px;
                min-height: 48px;
            }
            
            .login-button {
                padding: 16px;
                font-size: 15px;
                min-height: 52px;
            }
            
            .error-message,
            .success-message {
                padding: 12px;
                font-size: 14px;
                margin-bottom: 16px;
            }
            
            .error-text {
                font-size: 12px;
            }
        }

        @media (max-width: 480px) {
            body {
                padding: 8px;
                padding-top: 16px;
            }
            
            .admin-login-container {
                padding: 16px;
            }
            
            .admin-header {
                margin-bottom: 18px;
            }
            
            .admin-title {
                font-size: 18px;
            }
            
            .admin-subtitle {
                font-size: 11px;
            }
            
            .form-group {
                margin-bottom: 14px;
            }
            
            .form-label {
                font-size: 13px;
                margin-bottom: 5px;
            }
            
            .form-input {
                padding: 12px 10px;
                font-size: 15px;
                min-height: 44px;
            }
            
            .login-button {
                padding: 14px;
                font-size: 14px;
                min-height: 48px;
            }
            
            .error-message,
            .success-message {
                padding: 10px;
                font-size: 13px;
                margin-bottom: 14px;
            }
            
            .error-text {
                font-size: 11px;
            }
        }

        @media (max-width: 360px) {
            body {
                padding: 4px;
                padding-top: 12px;
            }
            
            .admin-login-container {
                padding: 12px;
            }
            
            .admin-header {
                margin-bottom: 16px;
            }
            
            .admin-title {
                font-size: 16px;
            }
            
            .admin-subtitle {
                font-size: 10px;
            }
            
            .form-group {
                margin-bottom: 12px;
            }
            
            .form-label {
                font-size: 12px;
                margin-bottom: 4px;
            }
            
            .form-input {
                padding: 10px 8px;
                font-size: 14px;
                min-height: 40px;
            }
            
            .login-button {
                padding: 12px;
                font-size: 13px;
                min-height: 44px;
            }
            
            .error-message,
            .success-message {
                padding: 8px;
                font-size: 12px;
                margin-bottom: 12px;
            }
            
            .error-text {
                font-size: 10px;
            }
        }

        /* ===== ACCESSIBILITY ===== */
        @media (prefers-reduced-motion: reduce) {
            * {
                animation-duration: 0.01ms !important;
                animation-iteration-count: 1 !important;
                transition-duration: 0.01ms !important;
            }
        }

        /* ===== FOCUS STYLES ===== */
        button:focus-visible,
        input:focus-visible {
            outline: 2px solid var(--primary-color);
            outline-offset: 2px;
        }

        /* ===== PRINT STYLES ===== */
        @media print {
            body {
                background: white;
                padding: 0;
            }
            
            .admin-login-container {
                box-shadow: none;
                border: 1px solid #000;
                max-width: none;
                margin: 0;
            }
        }
    </style>
</head>
<body>
    <div class="admin-login-container">
        <div class="admin-header">
            <h1 class="admin-title">Admin Login</h1>
            <p class="admin-subtitle">Titan Drilling Management System</p>
        </div>

        <?php if($errors->any()): ?>
            <div class="error-message" role="alert" aria-live="polite">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($error); ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>

        <?php if(session('success')): ?>
            <div class="success-message" role="status" aria-live="polite">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <div class="error-message" id="errorMessage" role="alert" aria-live="polite" style="display: none;"></div>
        <div class="success-message" id="successMessage" role="status" aria-live="polite" style="display: none;"></div>

        <form method="POST" action="<?php echo e(route('admin.login.store')); ?>" novalidate>
            <?php echo csrf_field(); ?>
            
            <div class="form-group">
                <label for="email" class="form-label">Email Address</label>
                <input type="email" 
                       id="email" 
                       name="email" 
                       class="form-input" 
                       placeholder="admin123@gmail.com"
                       value="<?php echo e(old('email')); ?>"
                       autocomplete="email"
                       required
                       aria-describedby="email-error"
                       autofocus>
                <div class="field-error" id="email-error">
                    <?php if($errors->has('email')): ?>
                        <span class="error-text"><?php echo e($errors->first('email')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="form-group">
                <label for="password" class="form-label">Password</label>
                <div class="password-container">
                    <input type="password" 
                           id="password" 
                           name="password" 
                           class="form-input" 
                           placeholder="Enter password"
                           autocomplete="current-password"
                           required
                           aria-describedby="password-error">
                    <button type="button" 
                            class="password-toggle" 
                            onclick="togglePassword()"
                            aria-label="Show password"
                            title="Toggle password visibility">
                        <i class="fas fa-eye" id="toggleIcon" aria-hidden="true"></i>
                    </button>
                </div>
                <div class="field-error" id="password-error">
                    <?php if($errors->has('password')): ?>
                        <span class="error-text"><?php echo e($errors->first('password')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <button type="submit" class="login-button" aria-describedby="login-help">
                <span class="button-text">Login</span>
            </button>
        </form>

        <!-- Account Deletion Request Link -->
        <div style="margin-top: 24px; padding-top: 20px; border-top: 1px solid var(--border-light); text-align: center;">
            <p style="color: var(--text-muted); font-size: 14px; margin-bottom: 12px;">
                Need to delete your account?
            </p>
            <a href="<?php echo e(route('account-deletion.request')); ?>" 
               style="display: inline-flex; align-items: center; color: var(--primary-color); text-decoration: none; font-size: 14px; font-weight: 500; padding: 8px 16px; border: 1px solid var(--primary-color); border-radius: var(--radius-sm); transition: var(--transition-base);"
               onmouseover="this.style.backgroundColor='var(--primary-color)'; this.style.color='white';"
               onmouseout="this.style.backgroundColor='transparent'; this.style.color='var(--primary-color)';">
                <i class="fas fa-user-times" style="margin-right: 8px; font-size: 12px;"></i>
                Request Account Deletion
            </a>
        </div>
    </div>

    <script>
        // Optimized SignIn Functionality
        (function() {
            'use strict';
            
            // Configuration object
            const CONFIG = {
                selectors: {
                    passwordInput: '#password',
                    toggleIcon: '#toggleIcon',
                    errorMessage: '#errorMessage',
                    successMessage: '#successMessage',
                    loginForm: 'form[method="POST"]'
                },
                classes: {
                    eyeIcon: 'fas fa-eye',
                    eyeSlashIcon: 'fas fa-eye-slash'
                }
            };
            
            // Cache DOM elements
            let elements = {};
            
            function initElements() {
                elements = {
                    passwordInput: document.querySelector(CONFIG.selectors.passwordInput),
                    toggleIcon: document.querySelector(CONFIG.selectors.toggleIcon),
                    errorMessage: document.querySelector(CONFIG.selectors.errorMessage),
                    successMessage: document.querySelector(CONFIG.selectors.successMessage),
                    loginForm: document.querySelector(CONFIG.selectors.loginForm)
                };
            }
            
            // Password toggle functionality
            function togglePassword() {
                if (!elements.passwordInput || !elements.toggleIcon) return;
                
                const isPassword = elements.passwordInput.type === 'password';
                
                elements.passwordInput.type = isPassword ? 'text' : 'password';
                elements.toggleIcon.className = isPassword ? CONFIG.classes.eyeSlashIcon : CONFIG.classes.eyeIcon;
                
                // Update aria-label for accessibility
                elements.toggleIcon.setAttribute('aria-label', 
                    isPassword ? 'Hide password' : 'Show password'
                );
            }
            
            // Form validation and submission
            function initFormHandlers() {
                if (!elements.loginForm) return;
                
                elements.loginForm.addEventListener('submit', function(e) {
                    const email = elements.passwordInput.form.querySelector('input[name="email"]');
                    const password = elements.passwordInput;
                    
                    // Clear previous field errors
                    clearFieldErrors();
                    
                    // Basic client-side validation
                    if (!email.value.trim()) {
                        e.preventDefault();
                        showFieldError('email', 'Please enter your email address.');
                        email.focus();
                        return;
                    }
                    
                    if (!password.value.trim()) {
                        e.preventDefault();
                        showFieldError('password', 'Please enter your password.');
                        password.focus();
                        return;
                    }
                    
                    // Show loading state
                    const submitButton = elements.loginForm.querySelector('button[type="submit"]');
                    if (submitButton) {
                        const buttonText = submitButton.querySelector('.button-text');
                        submitButton.disabled = true;
                        if (buttonText) {
                            buttonText.textContent = 'Logging in...';
                        } else {
                            submitButton.textContent = 'Logging in...';
                        }
                    }
                });
            }
            
            // Clear all field errors
            function clearFieldErrors() {
                const emailError = document.getElementById('email-error');
                const passwordError = document.getElementById('password-error');
                
                if (emailError) {
                    emailError.innerHTML = '';
                }
                if (passwordError) {
                    passwordError.innerHTML = '';
                }
            }
            
            // Show field-specific error
            function showFieldError(fieldName, message) {
                const errorElement = document.getElementById(fieldName + '-error');
                if (errorElement) {
                    errorElement.innerHTML = '<span class="error-text">' + message + '</span>';
                }
            }
            
            // Message display system
            function showMessage(message, type = 'error') {
                const messageElement = type === 'error' ? elements.errorMessage : elements.successMessage;
                const otherMessageElement = type === 'error' ? elements.successMessage : elements.errorMessage;
                
                if (!messageElement) return;
                
                // Hide other message type
                if (otherMessageElement) {
                    otherMessageElement.style.display = 'none';
                }
                
                // Show current message
                messageElement.textContent = message;
                messageElement.style.display = 'block';
                
                // Auto-hide after 5 seconds
                setTimeout(() => {
                    messageElement.style.display = 'none';
                }, 5000);
            }
            
            // Initialize all functionality
            function init() {
                initElements();
                initFormHandlers();
                
                // Make togglePassword globally accessible
                window.togglePassword = togglePassword;
                window.showMessage = showMessage;
            }
            
            // Initialize when DOM is ready
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', init);
            } else {
                init();
            }
        })();
    </script>
</body>
</html><?php /**PATH /home/titandrillingzm/public_html/admin.titandrillingzm.com/resources/views/auth/sign-in.blade.php ENDPATH**/ ?>