<?php $__env->startSection('title', 'Submit Application'); ?>

<?php $__env->startSection('styles'); ?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<style>
/* CSS Variables for consistent theming */
:root {
    --primary-color: #0055a5;
    --primary-hover: #003f7d;
    --secondary-color: #6c757d;
    --success-color: #28a745;
    --warning-color: #ffc107;
    --danger-color: #dc3545;
    --info-color: #17a2b8;
    --text-primary: #212529;
    --text-secondary: #6c757d;
    --bg-primary: #ffffff;
    --bg-secondary: #f8f9fa;
    --bg-light: #f8fafc;
    --border-color: #dee2e6;
    --border-light: #e2e8f0;
    --shadow-sm: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    --shadow-md: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    --radius-sm: 0.25rem;
    --radius-md: 0.375rem;
    --radius-lg: 0.5rem;
    --transition-base: all 0.15s ease-in-out;
    --font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
}

/* Reset and base styles */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: var(--font-family);
    background-color: var(--bg-light);
    color: var(--text-primary);
}

/* Main Container */
.application-container {
    min-height: 100vh;
    background: var(--bg-light);
}

/* Header Styles */
.header-gradient {
    background: #0055a5;
    padding: 20px 0;
    box-shadow: 0 4px 12px rgba(0, 85, 165, 0.3);
}

.header-content {
    width: 100%;
    padding: 0 20px;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.header-left {
    display: flex;
    align-items: center;
    gap: 15px;
}

.back-button {
    color: white;
    font-size: 20px;
    text-decoration: none;
    padding: 8px;
    border-radius: 50%;
    transition: var(--transition-base);
}

.back-button:hover {
    background-color: rgba(255, 255, 255, 0.1);
    color: white;
}

.header-title {
    color: white;
    font-size: 28px;
    font-weight: 700;
    margin: 0;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 15px;
}

.create-btn {
    background: white;
    color: var(--primary-color);
    border: none;
    padding: 12px 24px;
    border-radius: var(--radius-md);
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: var(--transition-base);
    box-shadow: var(--shadow-sm);
}

.create-btn:hover {
    background: rgba(255, 255, 255, 0.9);
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

/* Main Content */
.main-content {
    width: 100%;
    padding: 30px 20px;
}

/* Form Styles */
.form-container {
    background: white;
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-md);
    border: 1px solid var(--border-light);
    overflow: hidden;
}

.form-section {
    padding: 30px;
    border-bottom: 1px solid var(--border-light);
}

.form-section:last-child {
    border-bottom: none;
}

.section-title {
    font-size: 20px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.section-title i {
    color: var(--primary-color);
}

/* Form Groups */
.form-group {
    margin-bottom: 25px;
}

.form-group:last-child {
    margin-bottom: 0;
}

.form-label {
    display: block;
    font-size: 14px;
    font-weight: 500;
    color: var(--text-primary);
    margin-bottom: 8px;
}

.required {
    color: var(--danger-color);
    font-weight: bold;
}

.form-input, .form-select {
    width: 100%;
    padding: 12px 16px;
    border: 1px solid var(--border-color);
    border-radius: var(--radius-md);
    font-size: 14px;
    font-family: var(--font-family);
    transition: var(--transition-base);
    background: white;
}

.form-input:focus, .form-select:focus {
    outline: none;
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(0, 85, 165, 0.1);
}

.form-input.error, .form-select.error {
    border-color: var(--danger-color);
}

.form-textarea {
    min-height: 100px;
    resize: vertical;
}

.error-message {
    color: var(--danger-color);
    font-size: 12px;
    margin-top: 5px;
    display: none;
}

.error-message.show {
    display: block;
}

/* Form Rows */
.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 24px;
    margin-bottom: 24px;
}

.form-row:last-child {
    margin-bottom: 0;
}

/* Checkbox and Radio Groups */
.checkbox-group, .radio-group {
    display: flex;
    flex-direction: column;
    gap: 12px;
    margin-top: 8px;
}

.checkbox-label, .radio-label {
    display: flex;
    align-items: center;
    gap: 12px;
    cursor: pointer;
    font-size: 14px;
    color: var(--text-primary);
    padding: 8px 0;
}

.checkbox-label input[type="checkbox"], .radio-label input[type="radio"] {
    display: none;
}

.checkmark, .radio-mark {
    width: 20px;
    height: 20px;
    border: 2px solid var(--border-color);
    border-radius: var(--radius-sm);
    position: relative;
    transition: var(--transition-base);
}

.radio-mark {
    border-radius: 50%;
}

.checkbox-label input[type="checkbox"]:checked + .checkmark {
    background-color: var(--primary-color);
    border-color: var(--primary-color);
}

.checkbox-label input[type="checkbox"]:checked + .checkmark::after {
    content: '✓';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: white;
    font-size: 12px;
    font-weight: bold;
}

.radio-label input[type="radio"]:checked + .radio-mark {
    border-color: var(--primary-color);
}

.radio-label input[type="radio"]:checked + .radio-mark::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 8px;
    height: 8px;
    background-color: var(--primary-color);
    border-radius: 50%;
}

/* Signature Container */
.signature-container {
    border: 2px dashed var(--border-color);
    border-radius: var(--radius-md);
    padding: 16px;
    background: var(--bg-secondary);
    margin-top: 8px;
}

.signature-canvas {
    border: 1px solid var(--border-color);
    border-radius: var(--radius-sm);
    background: white;
    cursor: crosshair;
    width: 100%;
    max-width: 400px;
    height: 150px;
}

.signature-controls {
    margin-top: 12px;
    display: flex;
    gap: 12px;
}

/* Funeral Tables */
.funeral-table-container {
    margin: 24px 0;
}

.table-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 16px;
    text-align: center;
    background: var(--bg-secondary);
    padding: 12px;
    border-radius: var(--radius-md);
}

.funeral-table {
    border: 1px solid var(--border-color);
    border-radius: var(--radius-md);
    overflow: hidden;
}

.table-header {
    display: grid;
    grid-template-columns: 1fr 2fr 1fr;
    background: var(--primary-color);
    color: white;
    font-weight: 600;
}

.table-row {
    display: grid;
    grid-template-columns: 1fr 2fr 1fr;
    border-bottom: 1px solid var(--border-color);
}

.table-row:last-child {
    border-bottom: none;
}

.table-cell {
    padding: 12px;
    border-right: 1px solid var(--border-color);
    display: flex;
    align-items: center;
    justify-content: center;
}

.table-cell:last-child {
    border-right: none;
}

.table-cell .form-input {
    border: none;
    background: transparent;
    padding: 8px;
    text-align: center;
}

.total-row {
    background: var(--bg-secondary);
    font-weight: 600;
}

.total-input {
    background: var(--bg-secondary) !important;
    font-weight: 600;
    color: var(--primary-color);
}

/* Complainant Rows */
.complainant-row {
    border: 1px solid var(--border-color);
    border-radius: var(--radius-md);
    padding: 16px;
    margin-bottom: 16px;
    background: var(--bg-secondary);
}

.btn-remove {
    background: var(--danger-color);
    color: white;
    border: none;
    padding: 8px 16px;
    border-radius: var(--radius-sm);
    font-size: 12px;
    cursor: pointer;
    transition: var(--transition-base);
}

.btn-remove:hover {
    background: #c82333;
}

/* Buttons */
.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 12px 24px;
    border-radius: var(--radius-md);
    font-size: 14px;
    font-weight: 500;
    text-decoration: none;
    cursor: pointer;
    transition: var(--transition-base);
    border: none;
    font-family: var(--font-family);
}

.btn-primary {
    background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-hover) 100%);
    color: white;
}

.btn-primary:hover {
    background: linear-gradient(135deg, var(--primary-hover) 0%, #002a5c 100%);
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

.btn-outline {
    background: transparent;
    color: var(--primary-color);
    border: 1px solid var(--primary-color);
}

.btn-outline:hover {
    background: var(--primary-color);
    color: white;
}

.btn-secondary {
    background: linear-gradient(135deg, var(--secondary-color) 0%, #5a6268 100%);
    color: white;
}

.btn-secondary:hover {
    background: linear-gradient(135deg, #5a6268 0%, #495057 100%);
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

/* Form Actions */
.form-actions {
    margin-top: 32px;
    padding-top: 24px;
    border-top: 1px solid var(--border-light);
    display: flex;
    justify-content: center;
    gap: 16px;
}

/* Success Modal Styles - Matching Create Workorder File */
.success-modal-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 10000;
}

.success-modal-container {
    background: white;
    border-radius: 12px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
    max-width: 500px;
    width: 90%;
    max-height: 80vh;
    overflow: hidden;
    position: relative;
}

.success-modal-header {
    background: #0055a5;
    padding: 20px 30px;
    text-align: center;
    border-radius: 12px 12px 0 0;
}

.success-title {
    color: white;
    font-size: 24px;
    font-weight: 700;
    margin: 0;
    font-family: var(--font-family);
}

.success-modal-body {
    padding: 40px 30px;
    text-align: center;
}

.success-message {
    color: #333;
    font-size: 18px;
    font-weight: 500;
    margin: 0 0 30px 0;
    font-family: var(--font-family);
}

.success-buttons {
    display: flex;
    gap: 15px;
    justify-content: center;
    margin-top: 20px;
}

.success-btn {
    background: #0055a5;
    color: white;
    border: none;
    padding: 12px 24px;
    border-radius: 8px;
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.3s ease;
    font-family: var(--font-family);
    min-width: 120px;
}

.success-btn:hover {
    background: #003d7a;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 85, 165, 0.3);
}

.success-btn:active {
    transform: translateY(0);
}

.back-btn {
    background: #0055A5;
}

.add-another-btn {
    background: #0055A5;
}

/* Loading Modal */
.loading-modal-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 10000;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.loading-modal-overlay.show {
    opacity: 1;
}

.loading-modal-container {
    background: white;
    border-radius: 12px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
    max-width: 500px;
    width: 90%;
    max-height: 80vh;
    overflow: hidden;
    position: relative;
    transform: scale(0.9);
    transition: transform 0.3s ease;
}

.loading-modal-overlay.show .loading-modal-container {
    transform: scale(1);
}

/* Loading Modal */
.loading-modal-container {
    text-align: center;
    padding: 40px;
}

.loading-spinner {
    width: 40px;
    height: 40px;
    border: 4px solid var(--border-light);
    border-top: 4px solid var(--primary-color);
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 0 auto 20px;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.loading-title {
    font-size: 20px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 12px;
}

.loading-message {
    font-size: 14px;
    color: var(--text-secondary);
    margin: 0;
}

/* Responsive Design */
@media (max-width: 768px) {
    .header-gradient {
        padding: 15px 0;
    }
    
    .header-title {
        font-size: 24px;
    }
    
    .header-content {
        padding: 0 15px;
    }
    
    .main-content {
        padding: 20px 15px;
    }
    
    .form-section {
        padding: 20px;
    }
    
    .form-row {
        grid-template-columns: 1fr;
        gap: 16px;
    }
    
    .section-title {
        font-size: 18px;
    }
    
    .success-buttons {
        flex-direction: column;
    }
    
    .funeral-table {
        font-size: 12px;
    }
    
    .table-cell {
        padding: 8px;
    }
}

@media (max-width: 576px) {
    .header-gradient {
        padding: 12px 0;
    }
    
    .header-title {
        font-size: 20px;
    }
    
    .header-content {
        padding: 0 12px;
    }
    
    .main-content {
        padding: 15px 12px;
    }
    
    .form-section {
        padding: 16px;
    }
    
    .form-input, .form-select {
        padding: 10px 12px;
        font-size: 14px;
    }
    
    .btn {
        padding: 10px 20px;
        font-size: 14px;
    }
    
    .signature-canvas {
        height: 120px;
    }
}

/* Focus States */
.form-input:focus,
.form-select:focus,
.btn:focus {
    outline: 2px solid rgba(0, 85, 165, 0.5);
    outline-offset: 2px;
}

/* Smooth Animations */
* {
    transition: var(--transition-base);
}

/* Hover Effects */
.btn:active {
    transform: translateY(0);
}

/* Loading States */
.btn:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
}

.btn:disabled:hover {
    transform: none;
    box-shadow: none;
}
</style>
<?php $__env->stopSection(); ?>

<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

<?php $__env->startSection('content'); ?>
<div class="application-container">
    <!-- Header -->
    <div class="header-gradient">
        <div class="header-content">
            <div class="header-left">
                <a href="<?php echo e(route('hr.admin.dashboard')); ?>" class="back-button">
                    <i class="fas fa-arrow-left"></i>
                </a>
                <h1 class="header-title">New Application</h1>
            </div>
            <div class="header-right">
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="form-container">
            <form id="createApplicationForm">
                <!-- Basic Information Section -->
                <div class="form-section">
                    <h2 class="section-title">
                        <i class="fas fa-user"></i>
                        Basic Information
                    </h2>
                    
                    <!-- Select User Button - TOP POSITION -->
                    <div class="select-user-container" style="margin-bottom: 30px; padding: 20px; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); border-radius: 8px; border: 2px dashed #0055a5;">
                        <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 15px;">
                            <div>
                                <h3 style="margin: 0; color: #0055a5; font-size: 18px; font-family: 'Jost', sans-serif;">
                                    <i class="fas fa-users"></i> Quick Fill from User Database
                                </h3>
                                <p style="margin: 5px 0 0 0; color: #6c757d; font-size: 14px;">Select an existing user to auto-fill their information below</p>
                            </div>
                            <button type="button" class="btn-select-user" onclick="openUserSelectionModal()" style="background: #0055a5; color: white; border: none; padding: 12px 24px; border-radius: 6px; font-size: 16px; font-weight: 600; cursor: pointer; display: flex; align-items: center; gap: 8px; transition: all 0.3s;">
                                <i class="fas fa-user-check"></i>
                                Select User
                            </button>
                        </div>
                        <div id="selectedUserInfo" style="display: none; background: white; padding: 15px; border-radius: 6px; border-left: 4px solid #28a745;">
                            <p style="margin: 0; color: #28a745; font-weight: 600;">
                                <i class="fas fa-check-circle"></i> 
                                Selected: <span id="selectedUserName"></span>
                            </p>
                            <p style="margin: 5px 0 0 0; color: #6c757d; font-size: 13px;">
                                Employee #: <span id="selectedUserEmployeeNo"></span> | 
                                <a href="javascript:void(0)" onclick="openUserSelectionModal()" style="color: #0055a5; text-decoration: none; font-weight: 600;">
                                    <i class="fas fa-sync-alt"></i> Change User
                                </a>
                            </p>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label for="fullName" class="form-label">
                                Full name
                                <span class="required">*</span>
                            </label>
                            <input type="text" class="form-input" id="fullName" name="fullName" placeholder="Enter your full name" required>
                            <div class="error-message" id="fullNameError">Full name is required</div>
                        </div>
                        
                        <div class="form-group">
                            <label for="employeeNo" class="form-label">
                                Employee no
                                <span class="required">*</span>
                            </label>
                            <input type="text" class="form-input" id="employeeNo" name="employeeNo" placeholder="Enter employee number" required>
                            <div class="error-message" id="employeeNoError">Employee number is required</div>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label for="country" class="form-label">
                                Country
                                <span class="required">*</span>
                            </label>
                            <select class="form-select" id="country" name="country" required onchange="updateProjectOptions()">
                                <option value="">Select Country</option>
                                <option value="Zambia" selected>Zambia</option>
                                <option value="DRC">DRC</option>
                            </select>
                            <div class="error-message" id="countryError">Country is required</div>
                        </div>
                        
                        <div class="form-group">
                            <label for="project" class="form-label">
                                Project
                                <span class="required">*</span>
                            </label>
                            <select class="form-select" id="project" name="project" required>
                                <option value="">Select Project</option>
                            </select>
                            <div class="error-message" id="projectError">Project is required</div>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label for="department" class="form-label">
                                Department
                                <span class="required">*</span>
                            </label>
                            <input type="text" class="form-input" id="department" name="department" placeholder="Enter department" required>
                            <div class="error-message" id="departmentError">Department is required</div>
                        </div>
                        
                        <div class="form-group">
                            <label for="nrcNo" class="form-label">
                                NRC no
                                <span class="required">*</span>
                            </label>
                            <input type="text" class="form-input" id="nrcNo" name="nrcNo" placeholder="Enter NRC number" required>
                            <div class="error-message" id="nrcNoError">NRC number is required</div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="applicationType" class="form-label">
                            Application type
                            <span class="required">*</span>
                        </label>
                        <select class="form-select" id="applicationType" name="applicationType" required onchange="handleApplicationTypeChange()">
                            <option value="">Select Application Type</option>
                            <option value="leave_application">Leave Application</option>
                            <option value="funeral_grant_form">Funeral Grant Form</option>
                            <option value="salary_advance_application">Salary Advance Application</option>
                            <option value="application_for_appeal">Application for Appeal</option>
                            <option value="grievance_record">Grievance Record</option>
                            <option value="hospital_attendance_form">Hospital Attendance Form</option>
                        </select>
                        <div class="error-message" id="applicationTypeError">Application type is required</div>
                    </div>
                </div>

                <!-- Dynamic Form Sections -->
                <div id="dynamicFormSections" style="display: none;">
                    <!-- Leave Application Section -->
                    <div id="leaveApplicationSection" class="form-section" style="display: none;">
                        <h2 class="section-title">
                            <i class="fas fa-calendar-alt"></i>
                            Leave Application Details
                        </h2>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="leaveStartDate" class="form-label">
                                    Start Date
                                    <span class="required">*</span>
                                </label>
                                <input type="date" class="form-input" id="leaveStartDate" name="leaveStartDate" required>
                                <div class="error-message" id="leaveStartDateError">Start date is required</div>
                            </div>
                            
                            <div class="form-group">
                                <label for="leaveEndDate" class="form-label">
                                    End Date
                                    <span class="required">*</span>
                                </label>
                                <input type="date" class="form-input" id="leaveEndDate" name="leaveEndDate" required>
                                <div class="error-message" id="leaveEndDateError">End date is required</div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="reportDate" class="form-label">
                                Report Date
                                <span class="required">*</span>
                            </label>
                            <input type="date" class="form-input" id="reportDate" name="reportDate" required>
                            <div class="error-message" id="reportDateError">Report date is required</div>
                        </div>

                        <div class="form-group">
                            <label for="reasonOfLeave" class="form-label">
                                Reason of Leave
                                <span class="required">*</span>
                            </label>
                            <textarea class="form-input" id="reasonOfLeave" name="reasonOfLeave" rows="3" placeholder="Enter reason for leave" required></textarea>
                            <div class="error-message" id="reasonOfLeaveError">Reason of leave is required</div>
                        </div>

                        <div class="form-group">
                            <label for="addressWhileOnLeave" class="form-label">
                                Address While on Leave
                                <span class="required">*</span>
                            </label>
                            <textarea class="form-input" id="addressWhileOnLeave" name="addressWhileOnLeave" rows="3" placeholder="Enter address while on leave" required></textarea>
                            <div class="error-message" id="addressWhileOnLeaveError">Address while on leave is required</div>
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label for="otherContactName" class="form-label">Other Contact Name</label>
                                <input type="text" class="form-input" id="otherContactName" name="otherContactName" placeholder="Enter contact name">
                            </div>
                            
                            <div class="form-group">
                                <label for="otherContactCell" class="form-label">Other Contact Cell</label>
                                <input type="tel" class="form-input" id="otherContactCell" name="otherContactCell" placeholder="Enter contact number">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="signatureDate" class="form-label">
                                Signature Date
                                <span class="required">*</span>
                            </label>
                            <input type="date" class="form-input" id="signatureDate" name="signatureDate" required>
                            <div class="error-message" id="signatureDateError">Signature date is required</div>
                        </div>

                        <div class="form-group">
                            <label for="leaveSignature" class="form-label">
                                Employee Signature
                                <span class="required">*</span>
                            </label>
                            <div class="signature-container">
                                <canvas id="leaveSignatureCanvas" class="signature-canvas" width="400" height="150"></canvas>
                                <div class="signature-controls">
                                    <button type="button" class="btn btn-outline" onclick="clearSignature('leaveSignatureCanvas')">Clear</button>
                                </div>
                            </div>
                            <div class="error-message" id="leaveSignatureError">Signature is required</div>
                        </div>
                    </div>

                    <!-- Funeral Grant Form Section -->
                    <div id="funeralGrantSection" class="form-section" style="display: none;">
                        <h2 class="section-title">
                            <i class="fas fa-heart"></i>
                            Funeral Grant Form Details
                        </h2>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="funeralFromDate" class="form-label">
                                    From Date
                                    <span class="required">*</span>
                                </label>
                                <input type="date" class="form-input" id="funeralFromDate" name="funeralFromDate" required>
                                <div class="error-message" id="funeralFromDateError">From date is required</div>
                            </div>
                            
                            <div class="form-group">
                                <label for="funeralToDate" class="form-label">
                                    To Date
                                    <span class="required">*</span>
                                </label>
                                <input type="date" class="form-input" id="funeralToDate" name="funeralToDate" required>
                                <div class="error-message" id="funeralToDateError">To date is required</div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="selectedFuneralRelationshipType" class="form-label">
                                Relationship Type
                                <span class="required">*</span>
                            </label>
                            <select class="form-select" id="selectedFuneralRelationshipType" name="selectedFuneralRelationshipType" required onchange="handleFuneralRelationshipChange()">
                                <option value="">Select Relationship Type</option>
                                <option value="spouse_child">SPOUSE AND BIOLOGICAL CHILD</option>
                                <option value="mother_father">MOTHER AND FATHER</option>
                                <option value="both">BOTH</option>
                            </select>
                            <div class="error-message" id="selectedFuneralRelationshipTypeError">Relationship type is required</div>
                        </div>

                        <!-- Funeral Grant Tables -->
                        <div id="funeralSpouseChildTable" class="funeral-table-container" style="display: none;">
                            <h3 class="table-title">RELATIONSHIP: SPOUSE AND BIOLOGICAL CHILD (EMPLOYEE HIM/HERSELF)</h3>
                            <div class="funeral-table">
                                <div class="table-header">
                                    <div class="table-cell">DATE</div>
                                    <div class="table-cell">DESCRIPTION</div>
                                    <div class="table-cell">AMOUNT</div>
                                </div>
                                <div class="table-row">
                                    <div class="table-cell">
                                        <input type="date" class="form-input" name="funeralSpouseChildDate1" required>
                                    </div>
                                    <div class="table-cell">
                                        <input type="text" class="form-input" name="funeralSpouseChildDescription1" value="STANDARD COFFIN" required>
                                    </div>
                                    <div class="table-cell">
                                        <input type="number" class="form-input" name="funeralSpouseChildAmount1" placeholder="K" required oninput="calculateSpouseChildTotal()">
                                    </div>
                                </div>
                                <div class="table-row">
                                    <div class="table-cell">
                                        <input type="date" class="form-input" name="funeralSpouseChildDate2" required>
                                    </div>
                                    <div class="table-cell">
                                        <input type="text" class="form-input" name="funeralSpouseChildDescription2" value="CASH" required>
                                    </div>
                                    <div class="table-cell">
                                        <input type="number" class="form-input" name="funeralSpouseChildAmount2" placeholder="K" required oninput="calculateSpouseChildTotal()">
                                    </div>
                                </div>
                                <div class="table-row">
                                    <div class="table-cell">
                                        <input type="date" class="form-input" name="funeralSpouseChildDate3" required>
                                    </div>
                                    <div class="table-cell">
                                        <input type="text" class="form-input" name="funeralSpouseChildDescription3" value="TRANSPORT" required>
                                    </div>
                                    <div class="table-cell">
                                        <input type="number" class="form-input" name="funeralSpouseChildAmount3" placeholder="K" required oninput="calculateSpouseChildTotal()">
                                    </div>
                                </div>
                                <div class="table-row total-row">
                                    <div class="table-cell">TOTAL</div>
                                    <div class="table-cell"></div>
                                    <div class="table-cell">
                                        <input type="number" class="form-input total-input" id="spouseChildTotal" name="spouseChildTotal" placeholder="K" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div id="funeralMotherFatherTable" class="funeral-table-container" style="display: none;">
                            <h3 class="table-title">RELATIONSHIP: MOTHER AND FATHER</h3>
                            <div class="funeral-table">
                                <div class="table-header">
                                    <div class="table-cell">DATE</div>
                                    <div class="table-cell">DESCRIPTION</div>
                                    <div class="table-cell">AMOUNT</div>
                                </div>
                                <div class="table-row">
                                    <div class="table-cell">
                                        <input type="date" class="form-input" name="funeralMotherFatherDate1" required>
                                    </div>
                                    <div class="table-cell">
                                        <input type="text" class="form-input" name="funeralMotherFatherDescription1" value="CASH" required>
                                    </div>
                                    <div class="table-cell">
                                        <input type="number" class="form-input" name="funeralMotherFatherAmount1" placeholder="K" required oninput="calculateMotherFatherTotal()">
                                    </div>
                                </div>
                                <div class="table-row">
                                    <div class="table-cell">
                                        <input type="date" class="form-input" name="funeralMotherFatherDate2" required>
                                    </div>
                                    <div class="table-cell">
                                        <input type="text" class="form-input" name="funeralMotherFatherDescription2" value="TRANSPORT" required>
                                    </div>
                                    <div class="table-cell">
                                        <input type="number" class="form-input" name="funeralMotherFatherAmount2" placeholder="K" required oninput="calculateMotherFatherTotal()">
                                    </div>
                                </div>
                                <div class="table-row total-row">
                                    <div class="table-cell">TOTAL</div>
                                    <div class="table-cell"></div>
                                    <div class="table-cell">
                                        <input type="number" class="form-input total-input" id="motherFatherTotal" name="motherFatherTotal" placeholder="K" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label for="deceasedName" class="form-label">
                                    Deceased's Name
                                    <span class="required">*</span>
                                </label>
                                <input type="text" class="form-input" id="deceasedName" name="deceasedName" placeholder="Enter deceased's name" required>
                                <div class="error-message" id="deceasedNameError">Deceased's name is required</div>
                            </div>
                            
                            <div class="form-group">
                                <label for="deceasedRelationship" class="form-label">
                                    Relationship
                                    <span class="required">*</span>
                                </label>
                                <input type="text" class="form-input" id="deceasedRelationship" name="deceasedRelationship" placeholder="Enter relationship" required>
                                <div class="error-message" id="deceasedRelationshipError">Relationship is required</div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="deceasedDate" class="form-label">
                                Deceased Date
                                <span class="required">*</span>
                            </label>
                            <input type="date" class="form-input" id="deceasedDate" name="deceasedDate" required>
                            <div class="error-message" id="deceasedDateError">Deceased date is required</div>
                        </div>

                        <div class="form-group">
                            <label for="funeralEmployeeSignatureDate" class="form-label">
                                Employee Signature Date
                                <span class="required">*</span>
                            </label>
                            <input type="date" class="form-input" id="funeralEmployeeSignatureDate" name="funeralEmployeeSignatureDate" required>
                            <div class="error-message" id="funeralEmployeeSignatureDateError">Signature date is required</div>
                        </div>

                        <div class="form-group">
                            <label for="funeralSignature" class="form-label">
                                Employee Signature
                                <span class="required">*</span>
                            </label>
                            <div class="signature-container">
                                <canvas id="funeralSignatureCanvas" class="signature-canvas" width="400" height="150"></canvas>
                                <div class="signature-controls">
                                    <button type="button" class="btn btn-outline" onclick="clearSignature('funeralSignatureCanvas')">Clear</button>
                                </div>
                            </div>
                            <div class="error-message" id="funeralSignatureError">Signature is required</div>
                        </div>
                    </div>

                    <!-- Salary Advance Application Section -->
                    <div id="salaryAdvanceSection" class="form-section" style="display: none;">
                        <h2 class="section-title">
                            <i class="fas fa-money-bill-wave"></i>
                            Salary Advance Application Details
                        </h2>
                        
                        <div class="form-group">
                            <label for="salaryAdvanceDepartment" class="form-label">
                                Department
                                <span class="required">*</span>
                            </label>
                            <input type="text" class="form-input" id="salaryAdvanceDepartment" name="salaryAdvanceDepartment" placeholder="Enter department" required>
                            <div class="error-message" id="salaryAdvanceDepartmentError">Department is required</div>
                        </div>

                        <div class="form-group">
                            <label for="salaryAdvanceAmount" class="form-label">
                                Amount
                                <span class="required">*</span>
                            </label>
                            <input type="number" class="form-input" id="salaryAdvanceAmount" name="salaryAdvanceAmount" placeholder="Enter amount" required>
                            <div class="error-message" id="salaryAdvanceAmountError">Amount is required</div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">
                                Sites
                                <span class="required">*</span>
                            </label>
                            <div class="checkbox-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedSites[]" value="kalumbila">
                                    <span class="checkmark"></span>
                                    KALUMBILA
                                </label>
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedSites[]" value="kansanshi">
                                    <span class="checkmark"></span>
                                    KANSANSHI
                                </label>
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedSites[]" value="kimteto">
                                    <span class="checkmark"></span>
                                    KIMITETO
                                </label>
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedSites[]" value="others" onchange="toggleOtherSite()">
                                    <span class="checkmark"></span>
                                    OTHERS
                                </label>
                            </div>
                            <div class="error-message" id="selectedSitesError">At least one site is required</div>
                        </div>

                        <div id="otherSiteContainer" class="form-group" style="display: none;">
                            <label for="salaryAdvanceOtherSite" class="form-label">
                                Other Site
                                <span class="required">*</span>
                            </label>
                            <input type="text" class="form-input" id="salaryAdvanceOtherSite" name="salaryAdvanceOtherSite" placeholder="Specify other site">
                            <div class="error-message" id="salaryAdvanceOtherSiteError">Other site is required</div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">
                                Recovery Period
                                <span class="required">*</span>
                            </label>
                            <div class="radio-group">
                                <label class="radio-label">
                                    <input type="radio" name="selectedRecoveryPeriod" value="1_instalment">
                                    <span class="radio-mark"></span>
                                    1 Instalment
                                </label>
                                <label class="radio-label">
                                    <input type="radio" name="selectedRecoveryPeriod" value="2_instalments">
                                    <span class="radio-mark"></span>
                                    2 Instalments
                                </label>
                                <label class="radio-label">
                                    <input type="radio" name="selectedRecoveryPeriod" value="3_instalments">
                                    <span class="radio-mark"></span>
                                    3 Instalments
                                </label>
                            </div>
                            <div class="error-message" id="selectedRecoveryPeriodError">Recovery period is required</div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">
                                Reasons
                                <span class="required">*</span>
                            </label>
                            <div class="checkbox-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedReasons[]" value="medical_assistance">
                                    <span class="checkmark"></span>
                                    Medical Assistance
                                </label>
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedReasons[]" value="funeral">
                                    <span class="checkmark"></span>
                                    Funeral
                                </label>
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedReasons[]" value="school_fees">
                                    <span class="checkmark"></span>
                                    School Fees
                                </label>
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedReasons[]" value="tools_recovery">
                                    <span class="checkmark"></span>
                                    Tools Recovery
                                </label>
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedReasons[]" value="others" onchange="toggleOtherReason()">
                                    <span class="checkmark"></span>
                                    Others
                                </label>
                            </div>
                            <div class="error-message" id="selectedReasonsError">At least one reason is required</div>
                        </div>

                        <div id="otherReasonContainer" class="form-group" style="display: none;">
                            <label for="salaryAdvanceOtherReason" class="form-label">
                                Other Reason
                                <span class="required">*</span>
                            </label>
                            <input type="text" class="form-input" id="salaryAdvanceOtherReason" name="salaryAdvanceOtherReason" placeholder="Specify other reason">
                            <div class="error-message" id="salaryAdvanceOtherReasonError">Other reason is required</div>
                        </div>

                        <div class="form-group">
                            <label for="salaryAdvanceSignatureDate" class="form-label">
                                Signature Date
                                <span class="required">*</span>
                            </label>
                            <input type="date" class="form-input" id="salaryAdvanceSignatureDate" name="salaryAdvanceSignatureDate" required>
                            <div class="error-message" id="salaryAdvanceSignatureDateError">Signature date is required</div>
                        </div>

                        <div class="form-group">
                            <label for="salaryAdvanceSignature" class="form-label">
                                Employee Signature
                                <span class="required">*</span>
                            </label>
                            <div class="signature-container">
                                <canvas id="salaryAdvanceSignatureCanvas" class="signature-canvas" width="400" height="150"></canvas>
                                <div class="signature-controls">
                                    <button type="button" class="btn btn-outline" onclick="clearSignature('salaryAdvanceSignatureCanvas')">Clear</button>
                                </div>
                            </div>
                            <div class="error-message" id="salaryAdvanceSignatureError">Signature is required</div>
                        </div>
                    </div>

                    <!-- Application for Appeal Section -->
                    <div id="appealSection" class="form-section" style="display: none;">
                        <h2 class="section-title">
                            <i class="fas fa-gavel"></i>
                            Application for Appeal Details
                        </h2>
                        
                        <div class="form-group">
                            <label for="appealFormDate" class="form-label">
                                Form Date
                                <span class="required">*</span>
                            </label>
                            <input type="date" class="form-input" id="appealFormDate" name="appealFormDate" required>
                            <div class="error-message" id="appealFormDateError">Form date is required</div>
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label for="appealManNo" class="form-label">
                                    Man No
                                    <span class="required">*</span>
                                </label>
                                <input type="text" class="form-input" id="appealManNo" name="appealManNo" placeholder="Enter man number" required>
                                <div class="error-message" id="appealManNoError">Man number is required</div>
                            </div>
                            
                            <div class="form-group">
                                <label for="appealName" class="form-label">
                                    Name
                                    <span class="required">*</span>
                                </label>
                                <input type="text" class="form-input" id="appealName" name="appealName" placeholder="Enter name" required>
                                <div class="error-message" id="appealNameError">Name is required</div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="appealSanction" class="form-label">
                                Sanction
                                <span class="required">*</span>
                            </label>
                            <input type="text" class="form-input" id="appealSanction" name="appealSanction" placeholder="Enter sanction" required>
                            <div class="error-message" id="appealSanctionError">Sanction is required</div>
                        </div>

                        <div class="form-group">
                            <label for="appealOffence" class="form-label">
                                Offence
                                <span class="required">*</span>
                            </label>
                            <input type="text" class="form-input" id="appealOffence" name="appealOffence" placeholder="Enter offence" required>
                            <div class="error-message" id="appealOffenceError">Offence is required</div>
                        </div>

                        <div class="form-group">
                            <label for="appealOffenceDate" class="form-label">
                                Date of Offence
                                <span class="required">*</span>
                            </label>
                            <input type="date" class="form-input" id="appealOffenceDate" name="appealOffenceDate" required>
                            <div class="error-message" id="appealOffenceDateError">Date of offence is required</div>
                        </div>

                        <div class="form-group">
                            <label for="appealGrounds" class="form-label">
                                Grounds for Appeal
                                <span class="required">*</span>
                            </label>
                            <textarea class="form-input" id="appealGrounds" name="appealGrounds" rows="4" placeholder="Enter grounds for appeal" required></textarea>
                            <div class="error-message" id="appealGroundsError">Grounds for appeal is required</div>
                        </div>

                        <div class="form-group">
                            <label for="appealDateOfAppeal" class="form-label">
                                Date of Appeal
                                <span class="required">*</span>
                            </label>
                            <input type="date" class="form-input" id="appealDateOfAppeal" name="appealDateOfAppeal" required>
                            <div class="error-message" id="appealDateOfAppealError">Date of appeal is required</div>
                        </div>

                        <div class="form-group">
                            <label for="appellantSignature" class="form-label">
                                Appellant Signature
                                <span class="required">*</span>
                            </label>
                            <div class="signature-container">
                                <canvas id="appellantSignatureCanvas" class="signature-canvas" width="400" height="150"></canvas>
                                <div class="signature-controls">
                                    <button type="button" class="btn btn-outline" onclick="clearSignature('appellantSignatureCanvas')">Clear</button>
                                </div>
                            </div>
                            <div class="error-message" id="appellantSignatureError">Signature is required</div>
                        </div>
                    </div>

                    <!-- Grievance Record Section -->
                    <div id="grievanceSection" class="form-section" style="display: none;">
                        <h2 class="section-title">
                            <i class="fas fa-exclamation-triangle"></i>
                            Grievance Record Details
                        </h2>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="grievanceDate" class="form-label">
                                    Date
                                    <span class="required">*</span>
                                </label>
                                <input type="date" class="form-input" id="grievanceDate" name="grievanceDate" required>
                                <div class="error-message" id="grievanceDateError">Date is required</div>
                            </div>
                            
                            <div class="form-group">
                                <label for="grievanceType" class="form-label">
                                    Grievance Type
                                    <span class="required">*</span>
                                </label>
                                <select class="form-select" id="grievanceType" name="grievanceType" required>
                                    <option value="">Select Grievance Type</option>
                                    <option value="Workplace Conduct">Workplace Conduct</option>
                                    <option value="Discrimination">Discrimination</option>
                                    <option value="Harassment">Harassment</option>
                                    <option value="Safety Concern">Safety Concern</option>
                                    <option value="Compensation">Compensation</option>
                                    <option value="Working Conditions">Working Conditions</option>
                                    <option value="Management Issue">Management Issue</option>
                                    <option value="Policy Violation">Policy Violation</option>
                                    <option value="General Grievance">General Grievance</option>
                                    <option value="Other">Other</option>
                                </select>
                                <div class="error-message" id="grievanceTypeError">Grievance type is required</div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="grievancePriority" class="form-label">
                                Priority
                                <span class="required">*</span>
                            </label>
                            <select class="form-select" id="grievancePriority" name="grievancePriority" required>
                                <option value="">Select Priority</option>
                                <option value="Low">Low</option>
                                <option value="Normal">Normal</option>
                                <option value="High">High</option>
                                <option value="Urgent">Urgent</option>
                            </select>
                            <div class="error-message" id="grievancePriorityError">Priority is required</div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">Complainant(s)</label>
                            <div id="grievanceComplainants">
                                <div class="complainant-row">
                                    <div class="form-row">
                                        <div class="form-group">
                                            <label class="form-label">Name</label>
                                            <input type="text" class="form-input" name="grievanceComplainantName[]" placeholder="Enter name">
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label">Mine No</label>
                                            <input type="text" class="form-input" name="grievanceComplainantMineNo[]" placeholder="Enter mine number">
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label">Occupation/Grade</label>
                                            <input type="text" class="form-input" name="grievanceComplainantOccupation[]" placeholder="Enter occupation/grade">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-outline" onclick="addComplainant()">Add Complainant</button>
                        </div>

                        <div class="form-group">
                            <label for="grievancePlaceOfWork" class="form-label">
                                Place of Work
                                <span class="required">*</span>
                            </label>
                            <input type="text" class="form-input" id="grievancePlaceOfWork" name="grievancePlaceOfWork" placeholder="Enter place of work" required>
                            <div class="error-message" id="grievancePlaceOfWorkError">Place of work is required</div>
                        </div>

                        <div class="form-group">
                            <label for="grievanceSupervisorName" class="form-label">
                                Supervisor Name
                                <span class="required">*</span>
                            </label>
                            <input type="text" class="form-input" id="grievanceSupervisorName" name="grievanceSupervisorName" placeholder="Enter supervisor name" required>
                            <div class="error-message" id="grievanceSupervisorNameError">Supervisor name is required</div>
                        </div>

                        <div class="form-group">
                            <label for="grievanceDetails" class="form-label">
                                Details of Grievance
                                <span class="required">*</span>
                            </label>
                            <textarea class="form-input" id="grievanceDetails" name="grievanceDetails" rows="4" placeholder="Enter details of grievance" required></textarea>
                            <div class="error-message" id="grievanceDetailsError">Details of grievance is required</div>
                        </div>
                    </div>

                    <!-- Hospital Attendance Form Section -->
                    <div id="hospitalAttendanceSection" class="form-section" style="display: none;">
                        <h2 class="section-title">
                            <i class="fas fa-hospital"></i>
                            Hospital Attendance Form Details
                        </h2>
                        
                        <div class="form-group">
                            <label class="form-label">
                                Clinic(s)
                                <span class="required">*</span>
                            </label>
                            <div class="checkbox-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedClinics[]" value="marybegg_kalumbila">
                                    <span class="checkmark"></span>
                                    Marybegg Clinic Kalumbila
                                </label>
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedClinics[]" value="solwezi_general">
                                    <span class="checkmark"></span>
                                    Solwezi General Hospital
                                </label>
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedClinics[]" value="kalumbila_district">
                                    <span class="checkmark"></span>
                                    Kalumbila District Hospital
                                </label>
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedClinics[]" value="hilltop">
                                    <span class="checkmark"></span>
                                    Hilltop Hospital
                                </label>
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedClinics[]" value="marybegg_kansanshi">
                                    <span class="checkmark"></span>
                                    Marybegg Clinic Kansanshi
                                </label>
                                <label class="checkbox-label">
                                    <input type="checkbox" name="selectedClinics[]" value="others" onchange="toggleOtherClinic()">
                                    <span class="checkmark"></span>
                                    Others
                                </label>
                            </div>
                            <div class="error-message" id="selectedClinicsError">At least one clinic is required</div>
                        </div>

                        <div id="otherClinicContainer" class="form-group" style="display: none;">
                            <label for="otherClinic" class="form-label">
                                Other Clinic
                                <span class="required">*</span>
                            </label>
                            <input type="text" class="form-input" id="otherClinic" name="otherClinic" placeholder="Specify other clinic">
                            <div class="error-message" id="otherClinicError">Other clinic is required</div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">
                                Shift
                                <span class="required">*</span>
                            </label>
                            <div class="radio-group">
                                <label class="radio-label">
                                    <input type="radio" name="selectedShift" value="Day">
                                    <span class="radio-mark"></span>
                                    Day
                                </label>
                                <label class="radio-label">
                                    <input type="radio" name="selectedShift" value="Night">
                                    <span class="radio-mark"></span>
                                    Night
                                </label>
                            </div>
                            <div class="error-message" id="selectedShiftError">Shift is required</div>
                        </div>
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="form-actions">
                    <button type="button" class="btn btn-primary" id="submitApplication1Btn" onclick="submitApplication1()">
                        <i class="fas fa-paper-plane"></i>
                        Submit Application
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Success Modal -->
<div id="successModal" class="success-modal-overlay" style="display: none;">
    <div class="success-modal-container">
        <div class="success-modal-header">
            <h2 class="success-title">Success</h2>
        </div>
        <div class="success-modal-body">
            <p class="success-message">Application Submitted Successfully!</p>
            <div class="success-buttons">
                <button type="button" class="success-btn back-btn" onclick="goBackToDashboard()">
                    Back to Dashboard
                </button>
                <button type="button" class="success-btn add-another-btn" onclick="addAnotherApplication()">
                    Add Another Application
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Loading Modal -->
<div id="loadingModal" class="loading-modal-overlay" style="display: none;">
    <div class="loading-modal-container">
        <div class="loading-spinner"></div>
        <h3 class="loading-title">Processing Application</h3>
        <p class="loading-message">Please wait while we submit your application...</p>
    </div>
</div>

<script>
// Project options by country
const projectOptionsByCountry = {
    'Zambia': [
        { label: 'Kansanshi', value: 'Kansanshi' },
        { label: 'Kalumbila', value: 'Kalumbila' },
        { label: 'Kimteto', value: 'Kimteto' },
        { label: 'Kobold', value: 'Kobold' },
        { label: 'FQM Exploration', value: 'FQM Exploration' },
        { label: 'Mimosa', value: 'Mimosa' }
    ],
    'DRC': [
        { label: 'Lubumbashi', value: 'Lubumbashi' },
        { label: 'Musompo', value: 'Musompo' },
        { label: 'IME', value: 'IME' },
        { label: 'Kamoa', value: 'Kamoa' }
    ]
};

// Signature canvases
const signatureCanvases = {};

document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('createApplicationForm');
    
    // Initialize project options
    updateProjectOptions();
    
    // Initialize signature canvases
    initializeSignatureCanvases();
    
    // Form validation
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        submitApplication();
    });
});

// Update project options based on selected country
function updateProjectOptions() {
    const countrySelect = document.getElementById('country');
    const projectSelect = document.getElementById('project');
    const selectedCountry = countrySelect.value;
    
    // Clear existing options
    projectSelect.innerHTML = '<option value="">Select Project</option>';
    
    if (selectedCountry && projectOptionsByCountry[selectedCountry]) {
        projectOptionsByCountry[selectedCountry].forEach(option => {
            const optionElement = document.createElement('option');
            optionElement.value = option.value;
            optionElement.textContent = option.label;
            projectSelect.appendChild(optionElement);
        });
    }
}

// Handle application type change
function handleApplicationTypeChange() {
    const applicationType = document.getElementById('applicationType').value;
    const dynamicSections = document.getElementById('dynamicFormSections');
    
    // Hide all sections first
    const allSections = dynamicSections.querySelectorAll('.form-section');
    allSections.forEach(section => {
        section.style.display = 'none';
    });
    
    if (applicationType) {
        dynamicSections.style.display = 'block';
        
        // Show the relevant section
        const sectionMap = {
            'leave_application': 'leaveApplicationSection',
            'funeral_grant_form': 'funeralGrantSection',
            'salary_advance_application': 'salaryAdvanceSection',
            'application_for_appeal': 'appealSection',
            'grievance_record': 'grievanceSection',
            'hospital_attendance_form': 'hospitalAttendanceSection'
        };
        
        const sectionId = sectionMap[applicationType];
        if (sectionId) {
            document.getElementById(sectionId).style.display = 'block';
        }
    } else {
        dynamicSections.style.display = 'none';
    }
}

// Handle funeral relationship type change
function handleFuneralRelationshipChange() {
    const relationshipType = document.getElementById('selectedFuneralRelationshipType').value;
    const spouseChildTable = document.getElementById('funeralSpouseChildTable');
    const motherFatherTable = document.getElementById('funeralMotherFatherTable');
    
    // Hide both tables first
    spouseChildTable.style.display = 'none';
    motherFatherTable.style.display = 'none';
    
    if (relationshipType === 'spouse_child' || relationshipType === 'both') {
        spouseChildTable.style.display = 'block';
    }
    
    if (relationshipType === 'mother_father' || relationshipType === 'both') {
        motherFatherTable.style.display = 'block';
    }
}

// Calculate spouse and child total
function calculateSpouseChildTotal() {
    const amount1 = parseFloat(document.querySelector('input[name="funeralSpouseChildAmount1"]').value) || 0;
    const amount2 = parseFloat(document.querySelector('input[name="funeralSpouseChildAmount2"]').value) || 0;
    const amount3 = parseFloat(document.querySelector('input[name="funeralSpouseChildAmount3"]').value) || 0;
    
    const total = amount1 + amount2 + amount3;
    document.getElementById('spouseChildTotal').value = total.toFixed(2);
}

// Calculate mother and father total
function calculateMotherFatherTotal() {
    const amount1 = parseFloat(document.querySelector('input[name="funeralMotherFatherAmount1"]').value) || 0;
    const amount2 = parseFloat(document.querySelector('input[name="funeralMotherFatherAmount2"]').value) || 0;
    
    const total = amount1 + amount2;
    document.getElementById('motherFatherTotal').value = total.toFixed(2);
}

// Toggle other site field
function toggleOtherSite() {
    const otherSiteCheckbox = document.querySelector('input[name="selectedSites[]"][value="others"]');
    const otherSiteContainer = document.getElementById('otherSiteContainer');
    
    if (otherSiteCheckbox.checked) {
        otherSiteContainer.style.display = 'block';
    } else {
        otherSiteContainer.style.display = 'none';
        document.getElementById('salaryAdvanceOtherSite').value = '';
    }
}

// Toggle other reason field
function toggleOtherReason() {
    const otherReasonCheckbox = document.querySelector('input[name="selectedReasons[]"][value="others"]');
    const otherReasonContainer = document.getElementById('otherReasonContainer');
    
    if (otherReasonCheckbox.checked) {
        otherReasonContainer.style.display = 'block';
    } else {
        otherReasonContainer.style.display = 'none';
        document.getElementById('salaryAdvanceOtherReason').value = '';
    }
}

// Toggle other clinic field
function toggleOtherClinic() {
    const otherClinicCheckbox = document.querySelector('input[name="selectedClinics[]"][value="others"]');
    const otherClinicContainer = document.getElementById('otherClinicContainer');
    
    if (otherClinicCheckbox.checked) {
        otherClinicContainer.style.display = 'block';
    } else {
        otherClinicContainer.style.display = 'none';
        document.getElementById('otherClinic').value = '';
    }
}

// Add complainant row
function addComplainant() {
    const complainantsContainer = document.getElementById('grievanceComplainants');
    const newRow = document.createElement('div');
    newRow.className = 'complainant-row';
    newRow.innerHTML = `
        <div class="form-row">
            <div class="form-group">
                <label class="form-label">Name</label>
                <input type="text" class="form-input" name="grievanceComplainantName[]" placeholder="Enter name">
            </div>
            <div class="form-group">
                <label class="form-label">Mine No</label>
                <input type="text" class="form-input" name="grievanceComplainantMineNo[]" placeholder="Enter mine number">
            </div>
            <div class="form-group">
                <label class="form-label">Occupation/Grade</label>
                <input type="text" class="form-input" name="grievanceComplainantOccupation[]" placeholder="Enter occupation/grade">
            </div>
            <div class="form-group">
                <button type="button" class="btn btn-outline btn-remove" onclick="removeComplainant(this)">Remove</button>
            </div>
        </div>
    `;
    complainantsContainer.appendChild(newRow);
}

// Remove complainant row
function removeComplainant(button) {
    button.closest('.complainant-row').remove();
}

// Initialize signature canvases
function initializeSignatureCanvases() {
    const canvasIds = ['leaveSignatureCanvas', 'funeralSignatureCanvas', 'salaryAdvanceSignatureCanvas', 'appellantSignatureCanvas'];
    
    canvasIds.forEach(canvasId => {
        const canvas = document.getElementById(canvasId);
        if (canvas) {
            signatureCanvases[canvasId] = {
                canvas: canvas,
                ctx: canvas.getContext('2d'),
                isDrawing: false
            };
            
            setupSignatureCanvas(canvasId);
        }
    });
}

// Setup signature canvas
function setupSignatureCanvas(canvasId) {
    const sigData = signatureCanvases[canvasId];
    const canvas = sigData.canvas;
    const ctx = sigData.ctx;
    
    // Set canvas styles
    ctx.strokeStyle = '#000';
    ctx.lineWidth = 2;
    ctx.lineCap = 'round';
    ctx.lineJoin = 'round';
    
    // Mouse events
    canvas.addEventListener('mousedown', (e) => startDrawing(e, canvasId));
    canvas.addEventListener('mousemove', (e) => draw(e, canvasId));
    canvas.addEventListener('mouseup', () => stopDrawing(canvasId));
    canvas.addEventListener('mouseout', () => stopDrawing(canvasId));
    
    // Touch events for mobile
    canvas.addEventListener('touchstart', (e) => {
        e.preventDefault();
        const touch = e.touches[0];
        const mouseEvent = new MouseEvent('mousedown', {
            clientX: touch.clientX,
            clientY: touch.clientY
        });
        canvas.dispatchEvent(mouseEvent);
    });
    
    canvas.addEventListener('touchmove', (e) => {
        e.preventDefault();
        const touch = e.touches[0];
        const mouseEvent = new MouseEvent('mousemove', {
            clientX: touch.clientX,
            clientY: touch.clientY
        });
        canvas.dispatchEvent(mouseEvent);
    });
    
    canvas.addEventListener('touchend', (e) => {
        e.preventDefault();
        const mouseEvent = new MouseEvent('mouseup', {});
        canvas.dispatchEvent(mouseEvent);
    });
}

// Start drawing
function startDrawing(e, canvasId) {
    const sigData = signatureCanvases[canvasId];
    sigData.isDrawing = true;
    
    const rect = sigData.canvas.getBoundingClientRect();
    const x = e.clientX - rect.left;
    const y = e.clientY - rect.top;
    
    sigData.ctx.beginPath();
    sigData.ctx.moveTo(x, y);
}

// Draw
function draw(e, canvasId) {
    if (!signatureCanvases[canvasId].isDrawing) return;
    
    const sigData = signatureCanvases[canvasId];
    const rect = sigData.canvas.getBoundingClientRect();
    const x = e.clientX - rect.left;
    const y = e.clientY - rect.top;
    
    sigData.ctx.lineTo(x, y);
    sigData.ctx.stroke();
}

// Stop drawing
function stopDrawing(canvasId) {
    signatureCanvases[canvasId].isDrawing = false;
}

// Clear signature
function clearSignature(canvasId) {
    const sigData = signatureCanvases[canvasId];
    sigData.ctx.clearRect(0, 0, sigData.canvas.width, sigData.canvas.height);
}

// Validate form
function validateForm() {
    let isValid = true;
    const applicationType = document.getElementById('applicationType').value;
    
    // Clear previous errors
    clearErrors();
    
    // Basic validation
    const requiredFields = ['fullName', 'employeeNo', 'country', 'project', 'department', 'nrcNo', 'applicationType'];
    
    requiredFields.forEach(fieldId => {
        const field = document.getElementById(fieldId);
        if (!field.value.trim()) {
            showFieldError(fieldId, `${fieldId.replace(/([A-Z])/g, ' $1').toLowerCase()} is required`);
            isValid = false;
        }
    });
    
    // Application type specific validation
    if (applicationType === 'leave_application') {
        const leaveFields = ['leaveStartDate', 'leaveEndDate', 'reportDate', 'reasonOfLeave', 'addressWhileOnLeave', 'signatureDate'];
        leaveFields.forEach(fieldId => {
            const field = document.getElementById(fieldId);
            if (!field.value.trim()) {
                showFieldError(fieldId, `${fieldId.replace(/([A-Z])/g, ' $1').toLowerCase()} is required`);
                isValid = false;
            }
        });
        
        // Check signature
        if (isCanvasEmpty('leaveSignatureCanvas')) {
            showFieldError('leaveSignature', 'Signature is required');
            isValid = false;
        }
    } else if (applicationType === 'funeral_grant_form') {
        const funeralFields = ['funeralFromDate', 'funeralToDate', 'selectedFuneralRelationshipType', 'deceasedName', 'deceasedRelationship', 'deceasedDate', 'funeralEmployeeSignatureDate'];
        funeralFields.forEach(fieldId => {
            const field = document.getElementById(fieldId);
            if (!field.value.trim()) {
                showFieldError(fieldId, `${fieldId.replace(/([A-Z])/g, ' $1').toLowerCase()} is required`);
                isValid = false;
            }
        });
        
        // Check signature
        if (isCanvasEmpty('funeralSignatureCanvas')) {
            showFieldError('funeralSignature', 'Signature is required');
            isValid = false;
        }
        
        // Validate funeral table fields based on relationship type
        const relationshipType = document.getElementById('selectedFuneralRelationshipType').value;
        if (relationshipType === 'spouse_child' || relationshipType === 'both') {
            const spouseChildFields = ['funeralSpouseChildDate1', 'funeralSpouseChildDate2', 'funeralSpouseChildDate3', 'funeralSpouseChildAmount1', 'funeralSpouseChildAmount2', 'funeralSpouseChildAmount3', 'funeralSpouseChildDescription1', 'funeralSpouseChildDescription2', 'funeralSpouseChildDescription3'];
            spouseChildFields.forEach(fieldName => {
                const field = document.querySelector(`input[name="${fieldName}"]`);
                if (field && !field.value.trim()) {
                    showFieldError(fieldName, 'This field is required');
                    isValid = false;
                }
            });
        }
        
        if (relationshipType === 'mother_father' || relationshipType === 'both') {
            const motherFatherFields = ['funeralMotherFatherDate1', 'funeralMotherFatherDate2', 'funeralMotherFatherAmount1', 'funeralMotherFatherAmount2', 'funeralMotherFatherDescription1', 'funeralMotherFatherDescription2'];
            motherFatherFields.forEach(fieldName => {
                const field = document.querySelector(`input[name="${fieldName}"]`);
                if (field && !field.value.trim()) {
                    showFieldError(fieldName, 'This field is required');
                    isValid = false;
                }
            });
        }
    }
    
    // Add similar validation for other application types...
    
    return isValid;
}

// Check if canvas is empty
function isCanvasEmpty(canvasId) {
    const sigData = signatureCanvases[canvasId];
    const canvas = sigData.canvas;
    const ctx = sigData.ctx;
    
    const imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);
    const data = imageData.data;
    
    for (let i = 0; i < data.length; i += 4) {
        if (data[i + 3] !== 0) { // Check alpha channel
            return false;
        }
    }
    return true;
}

// Show field error
function showFieldError(fieldId, message) {
    const field = document.getElementById(fieldId);
    const errorElement = document.getElementById(fieldId + 'Error');
    
    if (field) {
        field.classList.add('error');
    }
    
    if (errorElement) {
        errorElement.textContent = message;
        errorElement.style.display = 'block';
    }
}

// Clear errors
function clearErrors() {
    const errorFields = document.querySelectorAll('.form-input.error, .form-select.error');
    errorFields.forEach(field => {
        field.classList.remove('error');
    });
    
    const errorMessages = document.querySelectorAll('.error-message');
    errorMessages.forEach(message => {
        message.style.display = 'none';
    });
}

// Submit application
async function submitApplication() {
    if (!validateForm()) {
        return;
    }
    
    const form = document.getElementById('createApplicationForm');
    const formData = new FormData(form);
    const applicationData = {};
    
    // Convert FormData to object
    for (let [key, value] of formData.entries()) {
        if (key.endsWith('[]')) {
            const arrayKey = key.slice(0, -2);
            if (!applicationData[arrayKey]) {
                applicationData[arrayKey] = [];
            }
            applicationData[arrayKey].push(value);
        } else {
            applicationData[key] = value;
        }
    }
    
    // Add signatures
    const applicationType = applicationData.applicationType;
    if (applicationType === 'leave_application') {
        applicationData.leaveSignature = getSignatureData('leaveSignatureCanvas');
    } else if (applicationType === 'funeral_grant_form') {
        applicationData.funeralSignature = getSignatureData('funeralSignatureCanvas');
    } else if (applicationType === 'salary_advance_application') {
        applicationData.salaryAdvanceSignature = getSignatureData('salaryAdvanceSignatureCanvas');
    } else if (applicationType === 'application_for_appeal') {
        applicationData.appellantSignature = getSignatureData('appellantSignatureCanvas');
    }
    
    // Add metadata
    applicationData.createdAt = new Date().toISOString();
    applicationData.id = 'APP-' + Date.now();
    applicationData.status = 'Pending';
    
    console.log('Submitting application data:', applicationData);
    
    // Show loading modal
    showLoadingModal();
    
    try {
        // Save to MongoDB via Laravel API
        const response = await fetch('/api/hr-applications', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || ''
            },
            body: JSON.stringify(applicationData)
        });
        
        if (!response.ok) {
            throw new Error('Failed to save application');
        }
        
        const result = await response.json();
        if (result.success) {
            hideLoadingModal();
            showSuccessModal();
        } else {
            throw new Error(result.error || 'Failed to save application');
        }
    } catch (error) {
        console.error('Error submitting application:', error);
        hideLoadingModal();
        showNotification('Failed to submit application. Please try again.', 'error');
    }
}

// Get signature data
function getSignatureData(canvasId) {
    const sigData = signatureCanvases[canvasId];
    return sigData.canvas.toDataURL();
}

// Show loading modal
function showLoadingModal() {
    document.getElementById('loadingModal').style.display = 'flex';
}

// Hide loading modal
function hideLoadingModal() {
    document.getElementById('loadingModal').style.display = 'none';
}

// Success Modal Functions (matching create workorder file)
function showSuccessModal() {
    const successModal = document.getElementById('successModal');
    if (successModal) {
        successModal.style.display = 'flex';
        successModal.style.opacity = '0';
        successModal.style.transition = 'opacity 0.3s ease';
        
        // Fade in the success modal
        setTimeout(() => {
            successModal.style.opacity = '1';
        }, 10);
    }
}

function hideSuccessModal() {
    const successModal = document.getElementById('successModal');
    if (successModal) {
        successModal.style.display = 'none';
    }
}

// Go back to dashboard
function goBackToDashboard() {
    window.location.href = '<?php echo e(route("hr.admin.dashboard")); ?>';
}

// Add another application
function addAnotherApplication() {
    hideSuccessModal();
    document.getElementById('createApplicationForm').reset();
    document.getElementById('dynamicFormSections').style.display = 'none';
    
    // Clear all signature canvases
    Object.keys(signatureCanvases).forEach(canvasId => {
        clearSignature(canvasId);
    });
    
    // Reset project options
    updateProjectOptions();
}

// Submit Application1 - Comprehensive data logging and signature saving
async function submitApplication1() {
    console.log('=== SUBMITTING APPLICATION1 - COMPREHENSIVE DATA LOGGING ===');
    
    // Validate form first
    if (!validateForm()) {
        return;
    }
    
    // Collect all form data section-wise
    const applicationData = collectAllFormData();
    
    // Log all data section-wise
    logSectionWiseData(applicationData);
    
    // Save signature images
    saveSignatureImages(applicationData);
    
    // Save application to MongoDB (unified function for all types)
    const applicationType = document.getElementById('applicationType').value;
    await storeApplicationInMongoDB(applicationData, applicationType);
}

// Generic MongoDB save function for all application types
async function storeApplicationInMongoDB(applicationData, applicationType) {
    try {
        console.log('=== STORING APPLICATION IN MONGODB ===');
        console.log('Type:', applicationType);
        
        // Show loading modal
        showLoadingModal();
        
        // Collect form data based on application type
        const form = document.getElementById('createApplicationForm');
        const formData = new FormData(form);
        const mongoData = {
            applicationType: applicationType,
            fullName: formData.get('fullName') || '',
            employeeNo: formData.get('employeeNo') || '',
            country: formData.get('country') || '',
            project: formData.get('project') || '',
            department: formData.get('department') || '',
            nrcNo: formData.get('nrcNo') || '',
            status: 'Pending',
            submittedAt: new Date().toISOString(),
            submissionDate: new Date().toISOString(),
            createdAt: new Date().toISOString(),
            adminUid: 'cahj3jJqe5Z16pQdLGSWrNgm84o1',
            HrManager: {
                name: "Pending:HrManager",
                status: "Pending"
            },
            Supervisor: {
                name: "Pending:Supervisor",
                status: "Pending"
            }
        };
        
        // Add application-type specific fields
        if (applicationType === 'leave_application') {
            mongoData.leaveStartDate = formData.get('leaveStartDate') || '';
            mongoData.leaveEndDate = formData.get('leaveEndDate') || '';
            mongoData.reportDate = formData.get('reportDate') || '';
            mongoData.reasonOfLeave = formData.get('reasonOfLeave') || '';
            mongoData.addressWhileOnLeave = formData.get('addressWhileOnLeave') || '';
            mongoData.otherContactName = formData.get('otherContactName') || '';
            mongoData.otherContactCell = formData.get('otherContactCell') || '';
            mongoData.signatureDate = formData.get('signatureDate') || '';
            mongoData.leaveSignature = getSignatureData('leaveSignatureCanvas');
        } else if (applicationType === 'salary_advance_application') {
            mongoData.salaryAdvanceAmount = formData.get('salaryAdvanceAmount') || '';
            mongoData.salaryAdvanceDepartment = formData.get('salaryAdvanceDepartment') || '';
            mongoData.salaryAdvanceOtherSite = formData.get('salaryAdvanceOtherSite') || '';
            mongoData.salaryAdvanceOtherReason = formData.get('salaryAdvanceOtherReason') || '';
            mongoData.salaryAdvanceSignatureDate = formData.get('salaryAdvanceSignatureDate') || '';
            mongoData.salaryAdvanceSignature = getSignatureData('salaryAdvanceSignatureCanvas');
            mongoData.selectedSites = formData.getAll('selectedSites[]');
            mongoData.selectedReasons = formData.getAll('selectedReasons[]');
            mongoData.selectedRecoveryPeriod = formData.get('selectedRecoveryPeriod') || '';
            mongoData.FinanceManager = { name: "Pending:FinanceManager", status: "Pending" };
        } else if (applicationType === 'application_for_appeal') {
            mongoData.appealFormDate = formData.get('appealFormDate') || '';
            mongoData.appealManNo = formData.get('appealManNo') || '';
            mongoData.appealName = formData.get('appealName') || '';
            mongoData.appealSanction = formData.get('appealSanction') || '';
            mongoData.appealOffence = formData.get('appealOffence') || '';
            mongoData.appealOffenceDate = formData.get('appealOffenceDate') || '';
            mongoData.appealGrounds = formData.get('appealGrounds') || '';
            mongoData.appealDateOfAppeal = formData.get('appealDateOfAppeal') || '';
            mongoData.appellantSignature = getSignatureData('appellantSignatureCanvas');
        } else if (applicationType === 'hospital_attendance_form') {
            mongoData.selectedClinics = formData.getAll('selectedClinics[]');
            mongoData.otherClinic = formData.get('otherClinic') || '';
            mongoData.selectedShift = formData.get('selectedShift') || '';
        } else if (applicationType === 'grievance_record') {
            mongoData.grievanceDate = formData.get('grievanceDate') || '';
            mongoData.grievanceType = formData.get('grievanceType') || 'General Grievance';
            mongoData.grievancePriority = formData.get('grievancePriority') || 'Normal';
            mongoData.grievancePlaceOfWork = formData.get('grievancePlaceOfWork') || '';
            mongoData.grievanceSupervisorName = formData.get('grievanceSupervisorName') || '';
            mongoData.grievanceDetails = formData.get('grievanceDetails') || '';
            
            // Map to expected display fields
            mongoData.description = formData.get('grievanceDetails') || '';
            mongoData.grievanceDescription = formData.get('grievanceDetails') || '';
            mongoData.priority = formData.get('grievancePriority') || 'Normal';
        
        // Collect complainant data
        const grievanceComplaints = [];
        const complainantRows = document.querySelectorAll('.complainant-row');
        complainantRows.forEach((row, index) => {
            const name = row.querySelector('input[name="grievanceComplainantName[]"]')?.value || '';
            const mineNo = row.querySelector('input[name="grievanceComplainantMineNo[]"]')?.value || '';
            const occupation = row.querySelector('input[name="grievanceComplainantOccupation[]"]')?.value || '';
            if (name || mineNo || occupation) {
                    grievanceComplaints.push({ name, mineNo, occupationGrade: occupation });
                }
            });
            mongoData.grievanceComplaints = grievanceComplaints;
        } else if (applicationType === 'funeral_grant_form') {
            mongoData.funeralFromDate = formData.get('funeralFromDate') || '';
            mongoData.funeralToDate = formData.get('funeralToDate') || '';
            mongoData.selectedFuneralRelationshipType = formData.get('selectedFuneralRelationshipType') || '';
            mongoData.deceasedName = formData.get('deceasedName') || '';
            mongoData.deceasedRelationship = formData.get('deceasedRelationship') || '';
            mongoData.deceasedDate = formData.get('deceasedDate') || '';
            mongoData.funeralEmployeeSignatureDate = formData.get('funeralEmployeeSignatureDate') || '';
            mongoData.funeralSignature = getSignatureData('funeralSignatureCanvas');
            
            // Collect funeral table data
        const funeralSpouseChildData = [];
            const relationshipType = formData.get('selectedFuneralRelationshipType');
            if (relationshipType === 'spouse_child' || relationshipType === 'both') {
            for (let i = 1; i <= 3; i++) {
                    const date = formData.get(`funeralSpouseChildDate${i}`);
                    const amount = formData.get(`funeralSpouseChildAmount${i}`);
                    const description = formData.get(`funeralSpouseChildDescription${i}`);
                if (date && amount) {
                        funeralSpouseChildData.push({ date, amount, description, id: i.toString() });
                }
            }
        } else if (relationshipType === 'mother_father') {
            for (let i = 1; i <= 2; i++) {
                    const date = formData.get(`funeralMotherFatherDate${i}`);
                    const amount = formData.get(`funeralMotherFatherAmount${i}`);
                    const description = formData.get(`funeralMotherFatherDescription${i}`);
                if (date && amount) {
                        funeralSpouseChildData.push({ date, amount, description, id: i.toString() });
                    }
                }
            }
            mongoData.funeralSpouseChildData = funeralSpouseChildData;
        }
        
        console.log('MongoDB data structure:', mongoData);
        
        // Save to MongoDB via Laravel API
        const response = await fetch('/api/hr-applications', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.content || ''
            },
            body: JSON.stringify(mongoData)
        });
        
        if (!response.ok) {
            throw new Error('Failed to save to MongoDB');
        }
        
            const result = await response.json();
        console.log('✅ Application stored successfully in MongoDB:', result);
            hideLoadingModal();
            
        // Show success modal after 1 second
            setTimeout(() => {
                showSuccessModal();
            }, 1000);
        
    } catch (error) {
        console.error('❌ Error storing application in MongoDB:', error);
        hideLoadingModal();
        showNotification('Failed to submit application. Please try again.', 'error');
    }
}

// ===== FIREBASE FUNCTIONS REMOVED - NOW USING MONGODB =====
// All application types now save via the unified storeApplicationInMongoDB() function above.
// Legacy Firebase functions have been removed to simplify the codebase.

function collectAllFormData() {
    const form = document.getElementById('createApplicationForm');
    const formData = new FormData(form);
    const applicationData = {
        basicInformation: {},
        dynamicSections: {},
        signatures: {},
        metadata: {
            timestamp: new Date().toISOString(),
            submissionType: 'Application1',
            userAgent: navigator.userAgent,
            formId: 'createApplicationForm'
        }
    };
    
    // Basic Information Section
    const basicFields = [
        'fullName', 'employeeNo', 'country', 'project', 'department', 
        'nrcNo', 'applicationType'
    ];
    
    basicFields.forEach(field => {
        const element = document.getElementById(field);
        if (element) {
            applicationData.basicInformation[field] = {
                value: element.value,
                type: element.type,
                required: element.hasAttribute('required'),
                placeholder: element.placeholder || null
            };
        }
    });
    
    // Dynamic Sections based on Application Type
    const applicationType = document.getElementById('applicationType').value;
    applicationData.basicInformation.applicationType = applicationType;
    
    if (applicationType === 'leave_application') {
        applicationData.dynamicSections.leaveApplication = collectLeaveApplicationData();
    } else if (applicationType === 'funeral_grant_form') {
        applicationData.dynamicSections.funeralGrant = collectFuneralGrantData();
    } else if (applicationType === 'salary_advance_application') {
        applicationData.dynamicSections.salaryAdvance = collectSalaryAdvanceData();
    } else if (applicationType === 'application_for_appeal') {
        applicationData.dynamicSections.appeal = collectAppealData();
    } else if (applicationType === 'grievance_record') {
        applicationData.dynamicSections.grievance = collectGrievanceData();
    } else if (applicationType === 'hospital_attendance_form') {
        applicationData.dynamicSections.hospitalAttendance = collectHospitalAttendanceData();
    }
    
    // Collect all checkboxes and radio buttons
    applicationData.checkboxes = collectCheckboxData();
    applicationData.radioButtons = collectRadioButtonData();
    
    // Collect all textareas
    applicationData.textareas = collectTextareaData();
    
    // Collect all select elements
    applicationData.selects = collectSelectData();
    
    return applicationData;
}

// Collect Leave Application Data
function collectLeaveApplicationData() {
    const leaveFields = [
        'leaveStartDate', 'leaveEndDate', 'reportDate', 'reasonOfLeave', 
        'addressWhileOnLeave', 'otherContactName', 'otherContactCell', 'signatureDate'
    ];
    
    const leaveData = {};
    leaveFields.forEach(field => {
        const element = document.getElementById(field);
        if (element) {
            leaveData[field] = {
                value: element.value,
                type: element.type,
                required: element.hasAttribute('required')
            };
        }
    });
    
    return leaveData;
}

// Collect Funeral Grant Data
function collectFuneralGrantData() {
    const funeralData = {
        basic: {},
        tables: {
            spouseChild: {},
            motherFather: {}
        }
    };
    
    const funeralFields = [
        'funeralFromDate', 'funeralToDate', 'selectedFuneralRelationshipType',
        'deceasedName', 'deceasedRelationship', 'deceasedDate', 'funeralEmployeeSignatureDate'
    ];
    
    funeralFields.forEach(field => {
        const element = document.getElementById(field);
        if (element) {
            funeralData.basic[field] = {
                value: element.value,
                type: element.type,
                required: element.hasAttribute('required')
            };
        }
    });
    
    // Collect spouse child table data
    const spouseChildFields = [
        'funeralSpouseChildDate1', 'funeralSpouseChildDate2', 'funeralSpouseChildDate3',
        'funeralSpouseChildAmount1', 'funeralSpouseChildAmount2', 'funeralSpouseChildAmount3',
        'funeralSpouseChildDescription1', 'funeralSpouseChildDescription2', 'funeralSpouseChildDescription3',
        'spouseChildTotal'
    ];
    
    spouseChildFields.forEach(field => {
        const element = document.querySelector(`input[name="${field}"]`) || document.getElementById(field);
        if (element) {
            funeralData.tables.spouseChild[field] = {
                value: element.value,
                type: element.type,
                readonly: element.hasAttribute('readonly')
            };
        }
    });
    
    // Collect mother father table data
    const motherFatherFields = [
        'funeralMotherFatherDate1', 'funeralMotherFatherDate2',
        'funeralMotherFatherAmount1', 'funeralMotherFatherAmount2',
        'funeralMotherFatherDescription1', 'funeralMotherFatherDescription2',
        'motherFatherTotal'
    ];
    
    motherFatherFields.forEach(field => {
        const element = document.querySelector(`input[name="${field}"]`) || document.getElementById(field);
        if (element) {
            funeralData.tables.motherFather[field] = {
                value: element.value,
                type: element.type,
                readonly: element.hasAttribute('readonly')
            };
        }
    });
    
    return funeralData;
}

// Collect Salary Advance Data
function collectSalaryAdvanceData() {
    const salaryData = {
        basic: {},
        checkboxes: {},
        radioButtons: {}
    };
    
    const salaryFields = [
        'salaryAdvanceDepartment', 'salaryAdvanceAmount', 'salaryAdvanceOtherSite',
        'salaryAdvanceOtherReason', 'salaryAdvanceSignatureDate'
    ];
    
    salaryFields.forEach(field => {
        const element = document.getElementById(field);
        if (element) {
            salaryData.basic[field] = {
                value: element.value,
                type: element.type,
                required: element.hasAttribute('required')
            };
        }
    });
    
    return salaryData;
}

// Collect Appeal Data
function collectAppealData() {
    const appealFields = [
        'appealFormDate', 'appealManNo', 'appealName', 'appealSanction',
        'appealOffence', 'appealOffenceDate', 'appealGrounds', 'appealDateOfAppeal'
    ];
    
    const appealData = {};
    appealFields.forEach(field => {
        const element = document.getElementById(field);
        if (element) {
            appealData[field] = {
                value: element.value,
                type: element.type,
                required: element.hasAttribute('required')
            };
        }
    });
    
    return appealData;
}

// Collect Grievance Data
function collectGrievanceData() {
    const grievanceData = {
        basic: {},
        complainants: []
    };
    
    const grievanceFields = [
        'grievanceDate', 'grievanceType', 'grievancePriority', 'grievancePlaceOfWork', 'grievanceSupervisorName', 'grievanceDetails'
    ];
    
    grievanceFields.forEach(field => {
        const element = document.getElementById(field);
        if (element) {
            grievanceData.basic[field] = {
                value: element.value,
                type: element.type,
                required: element.hasAttribute('required')
            };
        }
    });
    
    // Collect complainant data
    const complainantRows = document.querySelectorAll('.complainant-row');
    complainantRows.forEach((row, index) => {
        const complainant = {
            index: index,
            name: row.querySelector('input[name="grievanceComplainantName[]"]')?.value || '',
            mineNo: row.querySelector('input[name="grievanceComplainantMineNo[]"]')?.value || '',
            occupation: row.querySelector('input[name="grievanceComplainantOccupation[]"]')?.value || ''
        };
        grievanceData.complainants.push(complainant);
    });
    
    return grievanceData;
}

// Collect Hospital Attendance Data
function collectHospitalAttendanceData() {
    const hospitalData = {
        basic: {},
        checkboxes: {},
        radioButtons: {}
    };
    
    const hospitalFields = ['otherClinic'];
    hospitalFields.forEach(field => {
        const element = document.getElementById(field);
        if (element) {
            hospitalData.basic[field] = {
                value: element.value,
                type: element.type,
                required: element.hasAttribute('required')
            };
        }
    });
    
    return hospitalData;
}

// Collect Checkbox Data
function collectCheckboxData() {
    const checkboxData = {};
    const checkboxes = document.querySelectorAll('input[type="checkbox"]');
    
    checkboxes.forEach(checkbox => {
        const name = checkbox.name;
        if (!checkboxData[name]) {
            checkboxData[name] = [];
        }
        if (checkbox.checked) {
            checkboxData[name].push({
                value: checkbox.value,
                checked: checkbox.checked,
                id: checkbox.id
            });
        }
    });
    
    return checkboxData;
}

// Collect Radio Button Data
function collectRadioButtonData() {
    const radioData = {};
    const radios = document.querySelectorAll('input[type="radio"]');
    
    radios.forEach(radio => {
        const name = radio.name;
        if (radio.checked) {
            radioData[name] = {
                value: radio.value,
                checked: radio.checked,
                id: radio.id
            };
        }
    });
    
    return radioData;
}

// Collect Textarea Data
function collectTextareaData() {
    const textareaData = {};
    const textareas = document.querySelectorAll('textarea');
    
    textareas.forEach(textarea => {
        textareaData[textarea.name || textarea.id] = {
            value: textarea.value,
            rows: textarea.rows,
            placeholder: textarea.placeholder,
            required: textarea.hasAttribute('required')
        };
    });
    
    return textareaData;
}

// Collect Select Data
function collectSelectData() {
    const selectData = {};
    const selects = document.querySelectorAll('select');
    
    selects.forEach(select => {
        selectData[select.name || select.id] = {
            value: select.value,
            selectedIndex: select.selectedIndex,
            options: Array.from(select.options).map(option => ({
                value: option.value,
                text: option.text,
                selected: option.selected
            })),
            required: select.hasAttribute('required')
        };
    });
    
    return selectData;
}

// Log data section-wise
function logSectionWiseData(applicationData) {
    console.log('=== SECTION-WISE DATA LOGGING ===');
    
    console.log('📋 BASIC INFORMATION:', applicationData.basicInformation);
    
    console.log('📝 DYNAMIC SECTIONS:', applicationData.dynamicSections);
    
    console.log('☑️ CHECKBOXES:', applicationData.checkboxes);
    
    console.log('🔘 RADIO BUTTONS:', applicationData.radioButtons);
    
    console.log('📄 TEXTAREAS:', applicationData.textareas);
    
    console.log('📋 SELECTS:', applicationData.selects);
    
    console.log('✍️ SIGNATURES:', applicationData.signatures);
    
    console.log('📊 METADATA:', applicationData.metadata);
    
    console.log('=== COMPLETE APPLICATION DATA ===');
    console.log(applicationData);
}

// Save signature images
function saveSignatureImages(applicationData) {
    console.log('=== SAVING SIGNATURE IMAGES ===');
    
    const signatureCanvases = ['leaveSignatureCanvas', 'funeralSignatureCanvas', 'salaryAdvanceSignatureCanvas', 'appellantSignatureCanvas'];
    
    signatureCanvases.forEach(canvasId => {
        const canvas = document.getElementById(canvasId);
        if (canvas && !isCanvasEmpty(canvasId)) {
            const signatureData = canvas.toDataURL('image/png');
            applicationData.signatures[canvasId] = {
                dataURL: signatureData,
                timestamp: new Date().toISOString(),
                size: signatureData.length,
                format: 'PNG'
            };
            
            console.log(`✅ Signature saved: ${canvasId}`, {
                size: signatureData.length,
                timestamp: new Date().toISOString()
            });
            
            // Optionally save to localStorage for persistence
            localStorage.setItem(`signature_${canvasId}_${Date.now()}`, signatureData);
        } else {
            console.log(`❌ No signature found for: ${canvasId}`);
        }
    });
    
    console.log('=== SIGNATURE SAVING COMPLETE ===');
}

// Notification system
function showNotification(message, type = 'info') {
    const notification = document.createElement('div');
    notification.className = `app-notification app-notification-${type}`;
    notification.textContent = message;
    
    notification.style.cssText = `
        position: fixed;
        top: 80px;
        right: 20px;
        padding: 12px 20px;
        border-radius: 8px;
        color: white;
        font-weight: 500;
        font-size: 14px;
        z-index: 10001;
        opacity: 0;
        transform: translateX(100%);
        transition: all 0.3s ease;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        font-family: 'Inter', sans-serif;
    `;
    
    if (type === 'success') {
        notification.style.background = 'linear-gradient(135deg, #10b981 0%, #059669 100%)';
    } else if (type === 'error') {
        notification.style.background = 'linear-gradient(135deg, #ef4444 0%, #dc2626 100%)';
    } else if (type === 'warning') {
        notification.style.background = 'linear-gradient(135deg, #f59e0b 0%, #d97706 100%)';
    } else {
        notification.style.background = 'linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%)';
    }
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.style.opacity = '1';
        notification.style.transform = 'translateX(0)';
    }, 100);
    
    setTimeout(() => {
        notification.style.opacity = '0';
        notification.style.transform = 'translateX(100%)';
        setTimeout(() => {
            if (notification.parentNode) {
                document.body.removeChild(notification);
            }
        }, 300);
    }, 3000);
}
</script>

<style>
/* Import Google Fonts */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* CSS Variables for consistent theming */
:root {
    --primary-color: #0055a5;
    --primary-hover: #003f7d;
    --secondary-color: #6c757d;
    --success-color: #28a745;
    --warning-color: #ffc107;
    --danger-color: #dc3545;
    --info-color: #17a2b8;
    --text-primary: #212529;
    --text-secondary: #6c757d;
    --bg-primary: #ffffff;
    --bg-secondary: #f8f9fa;
    --bg-light: #f8fafc;
    --border-color: #dee2e6;
    --border-light: #e2e8f0;
    --shadow-sm: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    --shadow-md: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    --radius-sm: 0.25rem;
    --radius-md: 0.375rem;
    --radius-lg: 0.5rem;
    --transition-base: all 0.15s ease-in-out;
    --font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
}

/* ===== CREATE APPLICATION CONTAINER ===== */
.create-application-container {
    min-height: 100vh;
    background-color: var(--bg-light);
}

/* ===== HEADER SECTION ===== */
.create-application-header {
    background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-hover) 100%);
    padding: 32px;
    margin-bottom: 24px;
    box-shadow: var(--shadow-md);
}

.header-content {
    display: flex;
    align-items: center;
    justify-content: space-between;
    flex-wrap: wrap;
    gap: 20px;
}

.page-title h1 {
    color: white;
    font-size: 32px;
    font-weight: 700;
    margin: 0 0 8px 0;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.page-title p {
    color: rgba(255, 255, 255, 0.9);
    font-size: 16px;
    font-weight: 400;
    margin: 0;
}

.btn-back {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    background: rgba(255, 255, 255, 0.1);
    color: white;
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    transition: var(--transition-base);
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: var(--radius-md);
}

.btn-back:hover {
    background: rgba(255, 255, 255, 0.2);
    color: white;
    text-decoration: none;
    transform: translateY(-2px);
    box-shadow: var(--shadow-sm);
}

/* ===== FORM CONTAINER ===== */
.form-container {
    background: var(--bg-primary);
    border-radius: var(--radius-lg);
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--border-light);
    padding: 32px;
  
}

.application-form {
    display: flex;
    flex-direction: column;
    gap: 32px;
}

/* ===== FORM SECTIONS ===== */
.form-section {
    background: var(--bg-primary);
    border-radius: var(--radius-lg);
    padding: 24px;
    border: 1px solid var(--border-light);
    box-shadow: var(--shadow-sm);
}

.section-title {
    display: flex;
    align-items: center;
    gap: 12px;
    font-size: 20px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 24px;
    padding-bottom: 12px;
    border-bottom: 2px solid var(--border-light);
}

.section-title i {
    color: var(--primary-color);
    font-size: 18px;
}

/* ===== FORM ROWS ===== */
.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 24px;
    margin-bottom: 24px;
}

.form-row:last-child {
    margin-bottom: 0;
}

/* ===== FORM GROUPS ===== */
.form-group {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.form-label {
    font-weight: 500;
    color: var(--text-primary);
    font-size: 14px;
    display: block;
}

.required {
    color: var(--danger-color);
    font-weight: 600;
}

.form-input, .form-select {
    border: 1px solid var(--border-color);
    border-radius: var(--radius-md);
    padding: 12px 16px;
    font-size: 14px;
    transition: var(--transition-base);
    width: 100%;
    box-sizing: border-box;
    background: var(--bg-primary);
    font-family: var(--font-family);
}

.form-input:focus, .form-select:focus {
    outline: none;
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(0, 85, 165, 0.1);
}

.form-input.error, .form-select.error {
    border-color: var(--danger-color);
    box-shadow: 0 0 0 3px rgba(220, 38, 38, 0.1);
}

.error-message {
    color: var(--danger-color);
    font-size: 12px;
    font-weight: 500;
    margin-top: 4px;
    display: none;
}

/* ===== CHECKBOX AND RADIO GROUPS ===== */
.checkbox-group, .radio-group {
    display: flex;
    flex-direction: column;
    gap: 12px;
    margin-top: 8px;
}

.checkbox-label, .radio-label {
    display: flex;
    align-items: center;
    gap: 12px;
    cursor: pointer;
    font-size: 14px;
    color: var(--text-primary);
    padding: 8px 0;
}

.checkbox-label input[type="checkbox"], .radio-label input[type="radio"] {
    display: none;
}

.checkmark, .radio-mark {
    width: 20px;
    height: 20px;
    border: 2px solid var(--border-color);
    border-radius: var(--radius-sm);
    position: relative;
    transition: var(--transition-base);
}

.radio-mark {
    border-radius: 50%;
}

.checkbox-label input[type="checkbox"]:checked + .checkmark {
    background-color: var(--primary-color);
    border-color: var(--primary-color);
}

.checkbox-label input[type="checkbox"]:checked + .checkmark::after {
    content: '✓';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: white;
    font-size: 12px;
    font-weight: bold;
}

.radio-label input[type="radio"]:checked + .radio-mark {
    border-color: var(--primary-color);
}

.radio-label input[type="radio"]:checked + .radio-mark::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 8px;
    height: 8px;
    background-color: var(--primary-color);
    border-radius: 50%;
}

/* ===== SIGNATURE CONTAINER ===== */
.signature-container {
    border: 2px dashed var(--border-color);
    border-radius: var(--radius-md);
    padding: 16px;
    background: var(--bg-secondary);
    margin-top: 8px;
}

.signature-canvas {
    border: 1px solid var(--border-color);
    border-radius: var(--radius-sm);
    background: white;
    cursor: crosshair;
    width: 100%;
    max-width: 400px;
    height: 150px;
}

.signature-controls {
    margin-top: 12px;
    display: flex;
    gap: 12px;
}

/* ===== FUNERAL TABLES ===== */
.funeral-table-container {
    margin: 24px 0;
}

.table-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 16px;
    text-align: center;
    background: var(--bg-secondary);
    padding: 12px;
    border-radius: var(--radius-md);
}

.funeral-table {
    border: 1px solid var(--border-color);
    border-radius: var(--radius-md);
    overflow: hidden;
}

.table-header {
    display: grid;
    grid-template-columns: 1fr 2fr 1fr;
    background: var(--primary-color);
    color: white;
    font-weight: 600;
}

.table-row {
    display: grid;
    grid-template-columns: 1fr 2fr 1fr;
    border-bottom: 1px solid var(--border-color);
}

.table-row:last-child {
    border-bottom: none;
}

.table-cell {
    padding: 12px;
    border-right: 1px solid var(--border-color);
    display: flex;
    align-items: center;
    justify-content: center;
}

.table-cell:last-child {
    border-right: none;
}

.table-cell .form-input {
    border: none;
    background: transparent;
    padding: 8px;
    text-align: center;
}

.total-row {
    background: var(--bg-secondary);
    font-weight: 600;
}

.total-input {
    background: var(--bg-secondary) !important;
    font-weight: 600;
    color: var(--primary-color);
}

/* ===== COMPLAINANT ROWS ===== */
.complainant-row {
    border: 1px solid var(--border-color);
    border-radius: var(--radius-md);
    padding: 16px;
    margin-bottom: 16px;
    background: var(--bg-secondary);
}

.btn-remove {
    background: var(--danger-color);
    color: white;
    border: none;
    padding: 8px 16px;
    border-radius: var(--radius-sm);
    font-size: 12px;
    cursor: pointer;
    transition: var(--transition-base);
}

.btn-remove:hover {
    background: #c82333;
}

/* ===== BUTTONS ===== */
.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 12px 24px;
    border-radius: var(--radius-md);
    font-size: 14px;
    font-weight: 500;
    text-decoration: none;
    cursor: pointer;
    transition: var(--transition-base);
    border: none;
    font-family: var(--font-family);
}

.btn-primary {
    background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-hover) 100%);
    color: white;
}

.btn-primary:hover {
    background: linear-gradient(135deg, var(--primary-hover) 0%, #002a5c 100%);
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

.btn-outline {
    background: transparent;
    color: var(--primary-color);
    border: 1px solid var(--primary-color);
}

.btn-outline:hover {
    background: var(--primary-color);
    color: white;
}

.btn-secondary {
    background: linear-gradient(135deg, var(--secondary-color) 0%, #5a6268 100%);
    color: white;
}

.btn-secondary:hover {
    background: linear-gradient(135deg, #5a6268 0%, #495057 100%);
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

/* ===== FORM ACTIONS ===== */
.form-actions {
    margin-top: 32px;
    padding-top: 24px;
    border-top: 1px solid var(--border-light);
    display: flex;
    justify-content: center;
}

/* ===== MODALS ===== */
.success-modal-overlay, .loading-modal-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 10000;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.success-modal-overlay.show, .loading-modal-overlay.show {
    opacity: 1;
}

.success-modal-container, .loading-modal-container {
    background: white;
    border-radius: 12px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
    max-width: 500px;
    width: 90%;
    max-height: 80vh;
    overflow: hidden;
    position: relative;
    transform: scale(0.9);
    transition: transform 0.3s ease;
}

.success-modal-overlay.show .success-modal-container,
.loading-modal-overlay.show .loading-modal-container {
    transform: scale(1);
}

.success-modal-header {
    background: #0055a5;
    color: white;
    padding: 24px;
    text-align: center;
}

.success-title {
    font-size: 24px;
    font-weight: 600;
    margin: 0;
}

.success-modal-body {
    padding: 24px;
    text-align: center;
}

.success-message {
    font-size: 16px;
    color: var(--text-primary);
    margin-bottom: 24px;
}

.success-buttons {
    display: flex;
    gap: 12px;
    justify-content: center;
}

.success-btn {
    padding: 12px 24px;
    border-radius: var(--radius-md);
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
    border: none;
}

.back-btn {
    background: #0055a5;
    color: white;
}

.back-btn:hover {
    background: #003d7a;
}

.add-another-btn {
    background: #0055a5;
    color: white;
}

.add-another-btn:hover {
    background: #003d7a;
}

/* ===== LOADING MODAL ===== */
.loading-modal-container {
    text-align: center;
    padding: 40px;
}

.loading-spinner {
    width: 40px;
    height: 40px;
    border: 4px solid var(--border-light);
    border-top: 4px solid var(--primary-color);
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 0 auto 20px;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.loading-title {
    font-size: 20px;
    font-weight: 600;
    color: var(--text-primary);
    margin-bottom: 12px;
}

.loading-message {
    font-size: 14px;
    color: var(--text-secondary);
    margin: 0;
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 768px) {
    .create-application-header {
        padding: 20px;
    }
    
    .page-title h1 {
        font-size: 24px;
    }
    
    .page-title p {
        font-size: 14px;
    }
    
    .header-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 16px;
    }
    
    .form-container {
        padding: 24px;
       

    }
    
    .form-row {
        grid-template-columns: 1fr;
        gap: 16px;
    }
    
    .section-title {
        font-size: 18px;
    }
    
    .success-buttons {
        flex-direction: column;
    }
    
    .funeral-table {
        font-size: 12px;
    }
    
    .table-cell {
        padding: 8px;
    }
}

@media (max-width: 576px) {
    .create-application-header {
        padding: 16px;
    }
    
    .page-title h1 {
        font-size: 20px;
    }
    
    .page-title p {
        font-size: 13px;
    }
    
    .form-container {
        padding: 20px;
       
    }
    
    .form-input, .form-select {
        padding: 10px 12px;
        font-size: 14px;
    }
    
    .btn {
        padding: 10px 20px;
        font-size: 14px;
    }
    
    .signature-canvas {
        height: 120px;
    }
}

/* ===== FOCUS STATES ===== */
.form-input:focus,
.form-select:focus,
.btn:focus {
    outline: 2px solid rgba(0, 85, 165, 0.5);
    outline-offset: 2px;
}

/* ===== SMOOTH ANIMATIONS ===== */
* {
    transition: var(--transition-base);
}

/* ===== HOVER EFFECTS ===== */
.btn:active {
    transform: translateY(0);
}

/* ===== LOADING STATES ===== */
.btn:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
}

.btn:disabled:hover {
    transform: none;
    box-shadow: none;
}

/* ===== USER SELECTION MODAL ===== */
.user-modal-overlay {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.7);
    z-index: 10000;
    align-items: center;
    justify-content: center;
    backdrop-filter: blur(4px);
}

.user-modal-overlay.active {
    display: flex;
}

.user-modal-content {
    background: white;
    border-radius: 12px;
    max-width: 900px;
    width: 90%;
    max-height: 85vh;
    display: flex;
    flex-direction: column;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    animation: modalSlideIn 0.3s ease-out;
}

@keyframes modalSlideIn {
    from {
        opacity: 0;
        transform: translateY(-50px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.user-modal-header {
    padding: 24px 30px;
    border-bottom: 2px solid #e9ecef;
    background: linear-gradient(135deg, #0055a5 0%, #003d7a 100%);
    color: white;
    border-radius: 12px 12px 0 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.user-modal-title {
    font-size: 24px;
    font-weight: 700;
    margin: 0;
    font-family: 'Jost', sans-serif;
    display: flex;
    align-items: center;
    gap: 12px;
}

.user-modal-close {
    background: rgba(255, 255, 255, 0.2);
    border: none;
    color: white;
    font-size: 28px;
    cursor: pointer;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s;
}

.user-modal-close:hover {
    background: rgba(255, 255, 255, 0.3);
    transform: rotate(90deg);
}

.user-modal-search {
    padding: 20px 30px;
    border-bottom: 1px solid #e9ecef;
    background: #f8f9fa;
}

.user-search-input {
    width: 100%;
    padding: 12px 16px 12px 44px;
    border: 2px solid #dee2e6;
    border-radius: 8px;
    font-size: 16px;
    font-family: 'Jost', sans-serif;
    transition: all 0.3s;
}

.user-search-input:focus {
    outline: none;
    border-color: #0055a5;
    box-shadow: 0 0 0 3px rgba(0, 85, 165, 0.1);
}

.user-search-wrapper {
    position: relative;
}

.user-search-icon {
    position: absolute;
    left: 16px;
    top: 50%;
    transform: translateY(-50%);
    color: #6c757d;
    font-size: 18px;
}

.user-modal-body {
    padding: 20px 30px;
    overflow-y: auto;
    flex: 1;
}

.user-list {
    display: grid;
    gap: 12px;
}

.user-item {
    padding: 16px 20px;
    background: white;
    border: 2px solid #e9ecef;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.user-item:hover {
    border-color: #0055a5;
    background: linear-gradient(135deg, #f8f9fa 0%, #e8f4f8 100%);
    transform: translateX(5px);
    box-shadow: 0 4px 12px rgba(0, 85, 165, 0.15);
}

.user-info {
    flex: 1;
}

.user-name {
    font-size: 18px;
    font-weight: 600;
    color: #212529;
    margin: 0 0 4px 0;
    font-family: 'Jost', sans-serif;
}

.user-details {
    font-size: 14px;
    color: #6c757d;
    margin: 0;
}

.user-badge {
    padding: 6px 12px;
    background: #0055a5;
    color: white;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.user-loading {
    text-align: center;
    padding: 40px;
    color: #6c757d;
    font-size: 16px;
}

.user-empty {
    text-align: center;
    padding: 60px 20px;
    color: #6c757d;
}

.user-empty i {
    font-size: 64px;
    color: #dee2e6;
    margin-bottom: 20px;
}

.btn-select-user:hover {
    background: #003d7a;
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 85, 165, 0.3);
}

/* ===== RESPONSIVE - MOBILE ===== */
@media (max-width: 768px) {
    .user-modal-content {
        width: 95%;
        max-height: 90vh;
    }
    
    .user-modal-header {
        padding: 20px;
    }
    
    .user-modal-title {
        font-size: 20px;
    }
    
    .user-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 12px;
    }
    
    .user-badge {
        align-self: flex-end;
    }
    
    .select-user-container {
        padding: 15px !important;
    }
    
    .select-user-container > div {
        flex-direction: column !important;
        align-items: flex-start !important;
        gap: 15px;
    }
    
    .btn-select-user {
        width: 100%;
        justify-content: center;
    }
}
</style>

<!-- User Selection Modal -->
<div id="userSelectionModal" class="user-modal-overlay" onclick="closeUserSelectionModal(event)">
    <div class="user-modal-content" onclick="event.stopPropagation()">
        <div class="user-modal-header">
            <h2 class="user-modal-title">
                <i class="fas fa-users"></i>
                Select User
            </h2>
            <button class="user-modal-close" onclick="closeUserSelectionModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        
        <div class="user-modal-search">
            <div class="user-search-wrapper">
                <i class="fas fa-search user-search-icon"></i>
                <input type="text" class="user-search-input" id="userSearchInput" placeholder="Search by name, email, or employee number..." onkeyup="filterUsers()">
            </div>
        </div>
        
        <div class="user-modal-body">
            <div id="userListContainer" class="user-list">
                <div class="user-loading">
                    <i class="fas fa-spinner fa-spin" style="font-size: 32px; color: #0055a5;"></i>
                    <p style="margin-top: 16px;">Loading users from database...</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Global users data
let allUsers = [];
let filteredUsers = [];

// Open user selection modal
async function openUserSelectionModal() {
    console.log('🔍 Opening user selection modal...');
    const modal = document.getElementById('userSelectionModal');
    modal.classList.add('active');
    document.body.style.overflow = 'hidden';
    
    // Load users from MongoDB
    await loadUsersFromMongoDB();
}

// Close user selection modal
function closeUserSelectionModal(event) {
    if (event && event.target !== event.currentTarget) return;
    
    const modal = document.getElementById('userSelectionModal');
    modal.classList.remove('active');
    document.body.style.overflow = 'auto';
}

// Load users from MongoDB API
async function loadUsersFromMongoDB() {
    try {
        console.log('📥 Fetching users from MongoDB API...');
        const userListContainer = document.getElementById('userListContainer');
        
        // Show loading
        userListContainer.innerHTML = `
            <div class="user-loading">
                <i class="fas fa-spinner fa-spin" style="font-size: 32px; color: #0055a5;"></i>
                <p style="margin-top: 16px;">Loading users from database...</p>
            </div>
        `;
        
        // Fetch from MongoDB API (GlobalAdminUsersHandle - Port 5003)
        const response = await fetch('https://api.titandrillingzm.com:6003/users/all');
        const result = await response.json();
        
        if (!result.success || !result.data || result.data.length === 0) {
            userListContainer.innerHTML = `
                <div class="user-empty">
                    <i class="fas fa-users-slash"></i>
                    <h3 style="color: #495057; margin: 20px 0 10px 0;">No Users Found</h3>
                    <p style="margin: 0;">No users available in the database.</p>
                </div>
            `;
            return;
        }
        
        allUsers = result.data;
        filteredUsers = allUsers;
        
        console.log(`✅ Loaded ${allUsers.length} users from MongoDB`);
        console.log('📊 Sample user:', allUsers[0]);
        
        // Render users
        renderUserList(filteredUsers);
        
    } catch (error) {
        console.error('❌ Error loading users:', error);
        const userListContainer = document.getElementById('userListContainer');
        userListContainer.innerHTML = `
            <div class="user-empty">
                <i class="fas fa-exclamation-triangle" style="color: #dc3545;"></i>
                <h3 style="color: #495057; margin: 20px 0 10px 0;">Error Loading Users</h3>
                <p style="margin: 0; color: #6c757d;">Failed to connect to database. Please try again.</p>
                <button onclick="loadUsersFromMongoDB()" style="margin-top: 20px; padding: 10px 24px; background: #0055a5; color: white; border: none; border-radius: 6px; cursor: pointer; font-size: 14px; font-weight: 600;">
                    <i class="fas fa-sync"></i> Retry
                </button>
            </div>
        `;
    }
}

// Render user list
function renderUserList(users) {
    const userListContainer = document.getElementById('userListContainer');
    
    if (users.length === 0) {
        userListContainer.innerHTML = `
            <div class="user-empty">
                <i class="fas fa-search"></i>
                <h3 style="color: #495057; margin: 20px 0 10px 0;">No Matching Users</h3>
                <p style="margin: 0;">Try a different search term.</p>
            </div>
        `;
        return;
    }
    
    userListContainer.innerHTML = users.map(user => `
        <div class="user-item" onclick='selectUser(${JSON.stringify(user).replace(/'/g, "&apos;")})'>
            <div class="user-info">
                <h4 class="user-name">
                    <i class="fas fa-user" style="color: #0055a5; margin-right: 8px;"></i>
                    ${user.name || 'N/A'}
                </h4>
                <p class="user-details">
                    <i class="fas fa-envelope" style="margin-right: 6px;"></i> ${user.email || 'N/A'}
                    ${user.employeeNumber ? ` | <i class="fas fa-id-card" style="margin-left: 8px; margin-right: 6px;"></i> ${user.employeeNumber}` : ''}
                    ${user.department ? ` | <i class="fas fa-building" style="margin-left: 8px; margin-right: 6px;"></i> ${user.department}` : ''}
                </p>
            </div>
            <div class="user-badge">
                <i class="fas fa-check"></i> Select
            </div>
        </div>
    `).join('');
    
    console.log(`✅ Rendered ${users.length} users in modal`);
}

// Filter users based on search input
function filterUsers() {
    const searchTerm = document.getElementById('userSearchInput').value.toLowerCase();
    
    if (!searchTerm) {
        filteredUsers = allUsers;
    } else {
        filteredUsers = allUsers.filter(user => {
            const name = (user.name || '').toLowerCase();
            const email = (user.email || '').toLowerCase();
            const employeeNo = (user.employeeNumber || '').toLowerCase();
            const department = (user.department || '').toLowerCase();
            
            return name.includes(searchTerm) || 
                   email.includes(searchTerm) || 
                   employeeNo.includes(searchTerm) || 
                   department.includes(searchTerm);
        });
    }
    
    renderUserList(filteredUsers);
}

// Select user and auto-fill form
function selectUser(user) {
    console.log('✅ User selected:', user);
    console.log('📋 User data:', {
        name: user.name,
        employeeNumber: user.employeeNumber,
        department: user.department,
        nrcIdNumber: user.nrcIdNumber,
        countries: user.countries,
        projects: user.projects,
        country: user.country,
        project: user.project
    });
    
    try {
        // Auto-fill basic information fields
        const fullNameInput = document.getElementById('fullName');
        const employeeNoInput = document.getElementById('employeeNo');
        const departmentInput = document.getElementById('department');
        const nrcNoInput = document.getElementById('nrcNo');
        const countrySelect = document.getElementById('country');
        const projectSelect = document.getElementById('project');
        
        // Fill basic fields
        if (fullNameInput && user.name) {
            fullNameInput.value = user.name;
            fullNameInput.dispatchEvent(new Event('input', { bubbles: true }));
            console.log('✓ Filled fullName:', user.name);
        }
        
        if (employeeNoInput && user.employeeNumber) {
            employeeNoInput.value = user.employeeNumber;
            employeeNoInput.dispatchEvent(new Event('input', { bubbles: true }));
            console.log('✓ Filled employeeNo:', user.employeeNumber);
        }
        
        if (departmentInput && user.department) {
            departmentInput.value = user.department;
            departmentInput.dispatchEvent(new Event('input', { bubbles: true }));
            console.log('✓ Filled department:', user.department);
        }
        
        if (nrcNoInput && user.nrcIdNumber) {
            nrcNoInput.value = user.nrcIdNumber;
            nrcNoInput.dispatchEvent(new Event('input', { bubbles: true }));
            console.log('✓ Filled nrcNo:', user.nrcIdNumber);
        }
        
        // Auto-fill country (must be done before project)
        let selectedCountry = null;
        if (user.countries && user.countries.length > 0) {
            selectedCountry = user.countries[0];
        } else if (user.country) {
            selectedCountry = user.country;
        }
        
        if (countrySelect && selectedCountry) {
            countrySelect.value = selectedCountry;
            countrySelect.dispatchEvent(new Event('change', { bubbles: true }));
            console.log('✓ Filled country:', selectedCountry);
            
            // Update project options based on country (this is critical!)
            updateProjectOptions();
            
            // Wait for project options to populate, then set project value
            setTimeout(() => {
                // Get project value (prefer array first, then single value)
                let selectedProject = null;
                if (user.projects && user.projects.length > 0) {
                    selectedProject = user.projects[0];
                } else if (user.project) {
                    selectedProject = user.project;
                }
                
                if (projectSelect && selectedProject) {
                    // Check if the project option exists in the dropdown
                    const projectOption = Array.from(projectSelect.options).find(
                        opt => opt.value === selectedProject || opt.text === selectedProject
                    );
                    
                    if (projectOption) {
                        projectSelect.value = projectOption.value;
                        projectSelect.dispatchEvent(new Event('change', { bubbles: true }));
                        console.log('✓ Filled project:', projectOption.value);
                    } else {
                        console.warn('⚠ Project not found in options:', selectedProject);
                        // Try to add it if it doesn't exist
                        const newOption = document.createElement('option');
                        newOption.value = selectedProject;
                        newOption.textContent = selectedProject;
                        projectSelect.appendChild(newOption);
                        projectSelect.value = selectedProject;
                        projectSelect.dispatchEvent(new Event('change', { bubbles: true }));
                        console.log('✓ Added and filled project:', selectedProject);
                    }
                }
            }, 100); // Small delay to ensure options are populated
        }
        
        // Show selected user info
        const selectedUserNameEl = document.getElementById('selectedUserName');
        const selectedUserEmployeeNoEl = document.getElementById('selectedUserEmployeeNo');
        const selectedUserInfoEl = document.getElementById('selectedUserInfo');
        
        if (selectedUserNameEl) {
            selectedUserNameEl.textContent = user.name || 'N/A';
        }
        if (selectedUserEmployeeNoEl) {
            selectedUserEmployeeNoEl.textContent = user.employeeNumber || 'N/A';
        }
        if (selectedUserInfoEl) {
            selectedUserInfoEl.style.display = 'block';
        }
        
        // Store user ID for reference
        window.selectedUserId = user._id || user.uid;
        window.selectedUserData = user; // Store full user data for reference
        
        // Close modal
        closeUserSelectionModal();
        
        // Show success notification with filled fields count
        const filledFields = [
            user.name ? 'Name' : null,
            user.employeeNumber ? 'Employee No' : null,
            user.department ? 'Department' : null,
            user.nrcIdNumber ? 'NRC No' : null,
            selectedCountry ? 'Country' : null,
            (user.projects && user.projects.length > 0) || user.project ? 'Project' : null
        ].filter(f => f !== null);
        
        showNotification(`✅ User data loaded! Filled ${filledFields.length} fields: ${filledFields.join(', ')}. Please review and complete the form.`, 'success');
        
        console.log('✅ All fields auto-filled successfully!');
        
    } catch (error) {
        console.error('❌ Error auto-filling user data:', error);
        showNotification('⚠️ Some fields could not be auto-filled. Please fill them manually.', 'warning');
    }
}

// Notification function (if not already defined)
function showNotification(message, type = 'info') {
    // Create notification element
    const notification = document.createElement('div');
    notification.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px; max-width: 500px;';
    notification.innerHTML = `
        ${message}
        <button type="button" class="btn-close" onclick="this.parentElement.remove()"></button>
    `;
    
    document.body.appendChild(notification);
    
    // Auto-remove after 5 seconds
    setTimeout(() => {
        if (notification.parentNode) {
            notification.remove();
        }
    }, 5000);
}
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/titandrillingzm/public_html/admin.titandrillingzm.com/resources/views/hr/create-application.blade.php ENDPATH**/ ?>