

<?php $__env->startSection('title', 'Profile - Titan Drilling'); ?>

<?php
    // Helper function to get module icon
    function getModuleIcon($moduleName) {
        $icons = [
            'Equipments' => 'truck',
            'Documents' => 'file-alt',
            'teamEmploy' => 'users',
            'inspectionReport' => 'clipboard-check',
            'dvirReport' => 'car-crash',
            'checklist' => 'tasks',
            'incidentReport' => 'exclamation-triangle',
            'dailyReport' => 'calendar-day',
            'requestMaintenance' => 'tools',
            'jobcard' => 'id-card',
            'serviceSchedule' => 'calendar-alt',
            'fuelLog' => 'gas-pump',
            'logbook' => 'book',
            'hrForm' => 'user-tie',
            'hrApplications' => 'file-invoice',
            'teamKpi' => 'chart-line'
        ];
        return $icons[$moduleName] ?? 'cog';
    }
    
    // Helper function to format module names
    function formatModuleName($moduleName) {
        $names = [
            'Equipments' => 'Equipment Management',
            'Documents' => 'Document Management',
            'teamEmploy' => 'Team & Employees',
            'inspectionReport' => 'Inspection Reports',
            'dvirReport' => 'DVIR Reports',
            'checklist' => 'Checklists',
            'incidentReport' => 'Incident Reports',
            'dailyReport' => 'Daily Reports',
            'requestMaintenance' => 'Maintenance Requests',
            'jobcard' => 'Job Cards',
            'serviceSchedule' => 'Service Schedule',
            'fuelLog' => 'Fuel Logs',
            'logbook' => 'Logbook',
            'hrForm' => 'HR Forms',
            'hrApplications' => 'HR Applications',
            'teamKpi' => 'Team KPI'
        ];
        return $names[$moduleName] ?? ucfirst($moduleName);
    }
    
    // Helper function to get permission icon
    function getPermissionIcon($permission) {
        $icons = [
            'create' => 'plus-circle',
            'edit' => 'edit',
            'delete' => 'trash-alt',
            'view' => 'eye',
            'update' => 'sync-alt'
        ];
        return $icons[$permission] ?? 'check';
    }
?>

<?php $__env->startSection('content'); ?>
<div class="profile-container">
    <div class="profile-header">
        <div class="profile-avatar">
            <div class="avatar-circle">
                <i class="fas fa-user"></i>
            </div>
        </div>
        <div class="profile-info">
            <h1 class="profile-name"><?php echo e(Auth::user()->name ?? 'User'); ?></h1>
            <p class="profile-role"><?php echo e(Auth::user()->role ?? 'User'); ?></p>
            <p class="profile-email"><?php echo e(Auth::user()->email ?? 'No email provided'); ?></p>
        </div>
    </div>

    <div class="profile-content">
        <div class="profile-sections">
            

            <!-- Web Admin Countries & Projects -->
            <?php if(session('mongo_user_data')): ?>
            <div class="profile-section">
                <h2 class="section-title">
                    <i class="fas fa-globe"></i>
                    Assigned Countries & Projects
                </h2>
                <div class="countries-projects-grid">
                    <div class="info-item">
                        <label>Countries</label>
                        <div class="badge-container">
                            <?php if(isset(session('mongo_user_data')['countries']) && is_array(session('mongo_user_data')['countries'])): ?>
                                <?php $__currentLoopData = session('mongo_user_data')['countries']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge badge-country">
                                        <i class="fas fa-flag"></i> <?php echo e($country); ?>

                                    </span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <span class="text-muted">No countries assigned</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="info-item">
                        <label>Projects</label>
                        <div class="badge-container">
                            <?php if(isset(session('mongo_user_data')['projects']) && is_array(session('mongo_user_data')['projects'])): ?>
                                <?php $__currentLoopData = session('mongo_user_data')['projects']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge badge-project">
                                        <i class="fas fa-briefcase"></i> <?php echo e($project); ?>

                                    </span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <span class="text-muted">No projects assigned</span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            
            <?php endif; ?>

            
        </div>
    </div>
</div>

<style>
/* Profile Page Styles */
.profile-container {
    min-height: 100vh;
}

.profile-header {
    background: white;
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: var(--shadow-md);
    display: flex;
    align-items: center;
    gap: 2rem;
}

.profile-avatar {
    flex-shrink: 0;
}

.avatar-circle {
    width: 120px;
    height: 120px;
    background: linear-gradient(135deg, var(--primary-color), var(--primary-hover));
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 3rem;
}

.profile-info {
    flex: 1;
}

.profile-name {
    font-size: 2rem;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0 0 0.5rem 0;
}

.profile-role {
    font-size: 1.1rem;
    color: var(--primary-color);
    font-weight: 500;
    margin: 0 0 0.5rem 0;
}

.profile-email {
    font-size: 1rem;
    color: var(--text-muted);
    margin: 0;
}

.profile-sections {
    display: grid;
    gap: 2rem;
}

.profile-section {
    background: white;
    padding: 2rem;
    box-shadow: var(--shadow-md);
}

.section-title {
    font-size: 1.5rem;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0 0 1.5rem 0;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.section-title i {
    color: var(--primary-color);
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
}

.info-item {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.info-item label {
    font-weight: 600;
    color: var(--text-secondary);
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.info-item span {
    font-size: 1rem;
}

.role-badge {
    background: var(--primary-color);
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.875rem;
    font-weight: 500;
    display: inline-block;
    width: fit-content;
}

.status-active {
    color: #16a34a;
    font-weight: 600;
}

.settings-grid {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.setting-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1.5rem;
    border: 1px solid var(--border-light);
    transition: var(--transition-base);
}

.setting-item:hover {
    border-color: var(--primary-color);
    box-shadow: var(--shadow-sm);
}

.setting-info h3 {
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0 0 0.5rem 0;
}

.setting-info p {
    font-size: 0.875rem;
    color: var(--text-muted);
    margin: 0;
}

.btn-secondary {
    background: var(--secondary-color);
    color: white;
    border: none;
    padding: 0.75rem 1.5rem;
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition-base);
    font-size: 0.875rem;
}

.btn-secondary:hover {
    background: var(--secondary-hover);
    transform: translateY(-1px);
}

.activity-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.activity-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    padding: 1rem;
    border-left: 3px solid var(--primary-color);
    background: var(--bg-secondary);
    border-radius: 0 8px 8px 0;
}

.activity-icon {
    width: 40px;
    height: 40px;
    background: var(--primary-color);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    flex-shrink: 0;
}

.activity-content h4 {
    font-size: 1rem;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0 0 0.25rem 0;
}

.activity-content p {
    font-size: 0.875rem;
    color: var(--text-muted);
    margin: 0 0 0.5rem 0;
}

.activity-time {
    font-size: 0.75rem;
    color: var(--text-light);
    font-weight: 500;
    position: relative;
}

.activity-time::after {
    content: '';
    display: inline-block;
    width: 6px;
    height: 6px;
    background: #10b981;
    border-radius: 50%;
    margin-left: 6px;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% {
        opacity: 1;
        transform: scale(1);
    }
    50% {
        opacity: 0.5;
        transform: scale(0.8);
    }
}

.system-info {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
}

/* Responsive Design */
@media (max-width: 768px) {
    .profile-container {
        padding: 1rem;
    }
    
    .profile-header {
        flex-direction: column;
        text-align: center;
        gap: 1rem;
    }
    
    .avatar-circle {
        width: 100px;
        height: 100px;
        font-size: 2.5rem;
    }
    
    .profile-name {
        font-size: 1.5rem;
    }
    
    .info-grid,
    .system-info {
        grid-template-columns: 1fr;
    }
    
    .setting-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
    }
    
    .btn-secondary {
        width: 100%;
    }
}

@media (max-width: 480px) {
    .profile-container {
        padding: 0.5rem;
    }
    
    .profile-section {
        padding: 1.5rem;
    }
    
    .section-title {
        font-size: 1.25rem;
    }
}

/* Password Modal Styles */
.password-form {
    padding: 1rem 0;
}

.password-input-container {
    position: relative;
    display: flex;
    align-items: center;
}

.password-input-container input {
    width: 100%;
    padding: 0.75rem 3rem 0.75rem 1rem;
    border: 2px solid #e2e8f0;
    border-radius: 8px;
    font-size: 1rem;
    transition: all 0.2s ease;
}

.password-input-container input:focus {
    outline: none;
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(0, 85, 165, 0.1);
}

.password-toggle {
    position: absolute;
    right: 0.75rem;
    background: none;
    border: none;
    color: #64748b;
    cursor: pointer;
    padding: 0.5rem;
    border-radius: 4px;
    transition: color 0.2s ease;
}

.password-toggle:hover {
    color: var(--primary-color);
}

.password-strength {
    margin-top: 0.5rem;
    font-size: 0.875rem;
}

.password-strength.weak {
    color: #dc2626;
}

.password-strength.medium {
    color: #f59e0b;
}

.password-strength.strong {
    color: #16a34a;
}



.modal-header {
    background: var(--primary-color);
    color: white;
    border-bottom: none;
    border-radius: 12px 12px 0 0;
}

.modal-title {
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-close {
    filter: invert(1);
}

.modal-content {
    border: 1px solid rgb(0 0 0 / 10%);
    border-radius: 12px;
    box-shadow:  10px 10px 10px -12px rgba(0, 0, 0, 0.17);
}

.modal-footer {
    border-top: 1px solid #e2e8f0;
    padding: 1.5rem;
}

.btn-primary {
    background: var(--primary-color);
    border-color: var(--primary-color);
    font-weight: 500;
    padding: 0.75rem 1.5rem;
}

.btn-primary:hover {
    background: var(--primary-hover);
    border-color: var(--primary-hover);
}

.btn-secondary {
    background: #6b7280;
    border-color: #6b7280;
    font-weight: 500;
    padding: 0.75rem 1.5rem;
}

.btn-secondary:hover {
    background: #4b5563;
    border-color: #4b5563;
}

/* Countries & Projects Styles */
.countries-projects-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 2rem;
}

.badge-container {
    display: flex;
    flex-wrap: wrap;
    gap: 0.5rem;
    margin-top: 0.5rem;
}

.badge {
    display: inline-flex;
    align-items: center;
    gap: 0.375rem;
    padding: 0.5rem 0.875rem;
    border-radius: 20px;
    font-size: 0.875rem;
    font-weight: 500;
    transition: all 0.2s ease;
}

.badge-country {
    background: linear-gradient(135deg, #0055a5, #0066cc);
    color: white;
}

.badge-country:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0, 85, 165, 0.3);
}

.badge-project {
    background: linear-gradient(135deg, #ffd205, #ffdd33);
    color: #1a202c;
}

.badge-project:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(255, 210, 5, 0.3);
}

/* Modules & Permissions Styles */
.modules-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 1.5rem;
}

.module-card {
    border: 2px solid #e2e8f0;
    border-radius: 12px;
    padding: 1.25rem;
    transition: all 0.3s ease;
    background: #ffffff;
}

.module-card:hover {
    border-color: #0055a5;
    box-shadow: 0 8px 16px rgba(0, 85, 165, 0.1);
    transform: translateY(-4px);
}

.module-header {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin-bottom: 1rem;
    padding-bottom: 0.75rem;
    border-bottom: 2px solid #f3f4f6;
}

.module-header i {
    font-size: 1.5rem;
    color: #0055a5;
}

.module-header h3 {
    font-size: 1.1rem;
    font-weight: 600;
    color: #1a202c;
    margin: 0;
}

.permissions-list {
    display: flex;
    flex-wrap: wrap;
    gap: 0.5rem;
}

.permission-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.375rem;
    padding: 0.375rem 0.75rem;
    border-radius: 16px;
    font-size: 0.75rem;
    font-weight: 500;
    transition: all 0.2s ease;
}

.permission-badge i {
    font-size: 0.7rem;
}

.permission-create {
    background: #dcfce7;
    color: #166534;
    border: 1px solid #86efac;
}

.permission-create:hover {
    background: #bbf7d0;
}

.permission-edit {
    background: #dbeafe;
    color: #1e40af;
    border: 1px solid #93c5fd;
}

.permission-edit:hover {
    background: #bfdbfe;
}

.permission-delete {
    background: #fee2e2;
    color: #991b1b;
    border: 1px solid #fca5a5;
}

.permission-delete:hover {
    background: #fecaca;
}

.permission-view {
    background: #fef3c7;
    color: #92400e;
    border: 1px solid #fcd34d;
}

.permission-view:hover {
    background: #fde68a;
}

.permission-update {
    background: #e0e7ff;
    color: #3730a3;
    border: 1px solid #a5b4fc;
}

.permission-update:hover {
    background: #c7d2fe;
}

.text-muted {
    color: #6b7280;
    font-style: italic;
}

/* Responsive adjustments for modules */
@media (max-width: 768px) {
    .modules-grid {
        grid-template-columns: 1fr;
    }
    
    .countries-projects-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const changePasswordForm = document.getElementById('changePasswordForm');
    const newPasswordInput = document.getElementById('newPassword');
    const passwordStrengthDiv = document.getElementById('passwordStrength');
    
    // Initialize real-time timestamps
    initRealTimeTimestamps();
    
    // Password strength validation
    newPasswordInput.addEventListener('input', function() {
        const password = this.value;
        const strength = checkPasswordStrength(password);
        updatePasswordStrength(strength);
    });
    
    // Form submission
    changePasswordForm.addEventListener('submit', function(e) {
        e.preventDefault();
        
        const newPassword = newPasswordInput.value;
        
        // Validation
        if (!newPassword) {
            showNotification('Please enter a new password', 'error');
            return;
        }
        
        const strength = checkPasswordStrength(newPassword);
        if (strength.score < 3) {
            showNotification('Password is too weak. Please choose a stronger password.', 'error');
            return;
        }
        
        // Submit form
        changePassword(newPassword);
    });
    
    function checkPasswordStrength(password) {
        let score = 0;
        let feedback = [];
        
        if (password.length >= 8) score++;
        else feedback.push('At least 8 characters');
        
        if (/[a-z]/.test(password)) score++;
        else feedback.push('One lowercase letter');
        
        if (/[A-Z]/.test(password)) score++;
        else feedback.push('One uppercase letter');
        
        if (/[0-9]/.test(password)) score++;
        else feedback.push('One number');
        
        if (/[^A-Za-z0-9]/.test(password)) score++;
        else feedback.push('One special character');
        
        return { score, feedback };
    }
    
    function updatePasswordStrength(strength) {
        const { score, feedback } = strength;
        let strengthText = '';
        let strengthClass = '';
        
        if (score <= 2) {
            strengthText = 'Weak';
            strengthClass = 'weak';
        } else if (score <= 4) {
            strengthText = 'Medium';
            strengthClass = 'medium';
        } else {
            strengthText = 'Strong';
            strengthClass = 'strong';
        }
        
        passwordStrengthDiv.textContent = `Password Strength: ${strengthText}`;
        passwordStrengthDiv.className = `password-strength ${strengthClass}`;
    }
    
    
    function changePassword(newPassword) {
        const submitBtn = document.getElementById('changePasswordBtn');
        const originalText = submitBtn.textContent;
        
        // Show loading state
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Changing...';
        
        // Make API call to change password
        fetch('<?php echo e(route("change-password")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                new_password: newPassword
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showNotification('Password changed successfully!', 'success');
                // Close modal
                const modal = bootstrap.Modal.getInstance(document.getElementById('changePasswordModal'));
                modal.hide();
                // Reset form
                changePasswordForm.reset();
                passwordStrengthDiv.textContent = '';
            } else {
                showNotification(data.message || 'Failed to change password', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showNotification('An error occurred while changing password', 'error');
        })
        .finally(() => {
            // Reset button state
            submitBtn.disabled = false;
            submitBtn.textContent = originalText;
        });
    }
});

// Toggle password visibility
function togglePassword(inputId) {
    const input = document.getElementById(inputId);
    const button = input.nextElementSibling;
    const icon = button.querySelector('i');
    
    if (input.type === 'password') {
        input.type = 'text';
        icon.className = 'fas fa-eye-slash';
    } else {
        input.type = 'password';
        icon.className = 'fas fa-eye';
    }
}

// Real-time timestamp updates
function initRealTimeTimestamps() {
    const activityItems = document.querySelectorAll('.activity-item');
    const lastLoginElement = document.getElementById('lastLoginTime');
    
    function updateTimestamps() {
        const now = Math.floor(Date.now() / 1000); // Current timestamp in seconds
        
        // Update activity timestamps
        activityItems.forEach(item => {
            const timestamp = parseInt(item.getAttribute('data-timestamp'));
            const timeSpan = item.querySelector('.activity-time');
            
            if (timeSpan && timestamp) {
                const timeAgo = now - timestamp;
                timeSpan.textContent = formatTimeAgo(timeAgo);
            }
        });
        
        // Update last login time
        if (lastLoginElement) {
            const timestamp = parseInt(lastLoginElement.getAttribute('data-timestamp'));
            if (timestamp) {
                const timeAgo = now - timestamp;
                lastLoginElement.textContent = formatTimeAgo(timeAgo);
            }
        }
    }
    
    function formatTimeAgo(seconds) {
        if (seconds < 5) {
            return 'Just now';
        } else if (seconds < 60) {
            return `${seconds} seconds ago`;
        } else if (seconds < 120) {
            return '1 minute ago';
        } else if (seconds < 3600) {
            const minutes = Math.floor(seconds / 60);
            return `${minutes} minutes ago`;
        } else if (seconds < 7200) {
            return '1 hour ago';
        } else if (seconds < 86400) {
            const hours = Math.floor(seconds / 3600);
            return `${hours} hours ago`;
        } else if (seconds < 172800) {
            return '1 day ago';
        } else if (seconds < 2592000) {
            const days = Math.floor(seconds / 86400);
            return `${days} days ago`;
        } else if (seconds < 5184000) {
            return '1 month ago';
        } else if (seconds < 31536000) {
            const months = Math.floor(seconds / 2592000);
            return `${months} months ago`;
        } else if (seconds < 63072000) {
            return '1 year ago';
        } else {
            const years = Math.floor(seconds / 31536000);
            return `${years} years ago`;
        }
    }
    
    // Update timestamps immediately
    updateTimestamps();
    
    // Update every 30 seconds
    setInterval(updateTimestamps, 30000);
    
    // Update every minute for more precise timing
    setTimeout(() => {
        setInterval(updateTimestamps, 60000);
    }, 30000);
}

// Notification system
function showNotification(message, type = 'info') {
    const notification = document.createElement('div');
    notification.className = `notification notification-${type}`;
    notification.innerHTML = `
        <div class="notification-content">
            <i class="fas fa-${getNotificationIcon(type)}"></i>
            <span>${message}</span>
        </div>
        <button class="notification-close" onclick="this.parentElement.remove()">
            <i class="fas fa-times"></i>
        </button>
    `;
    
    document.body.appendChild(notification);
    
    // Auto remove after 5 seconds
    setTimeout(() => {
        if (notification.parentElement) {
            notification.remove();
        }
    }, 5000);
}

function getNotificationIcon(type) {
    const icons = {
        success: 'check-circle',
        error: 'exclamation-circle',
        warning: 'exclamation-triangle',
        info: 'info-circle'
    };
    return icons[type] || 'info-circle';
}
</script>

<style>
/* Notification Styles */
.notification {
    position: fixed;
    top: 20px;
    right: 20px;
    background: white;
    border-radius: 8px;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
    padding: 1rem 1.5rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    z-index: 10000;
    min-width: 300px;
    border-left: 4px solid #3b82f6;
    animation: slideInRight 0.3s ease-out;
}

.notification-success {
    border-left-color: #16a34a;
}

.notification-error {
    border-left-color: #dc2626;
}

.notification-warning {
    border-left-color: #f59e0b;
}

.notification-info {
    border-left-color: #3b82f6;
}

.notification-content {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    flex: 1;
}

.notification-content i {
    font-size: 1.25rem;
}

.notification-success .notification-content i {
    color: #16a34a;
}

.notification-error .notification-content i {
    color: #dc2626;
}

.notification-warning .notification-content i {
    color: #f59e0b;
}

.notification-info .notification-content i {
    color: #3b82f6;
}

.notification-close {
    background: none;
    border: none;
    color: #6b7280;
    cursor: pointer;
    padding: 0.25rem;
    border-radius: 4px;
    transition: color 0.2s ease;
}

.notification-close:hover {
    color: #374151;
}

@keyframes slideInRight {
    from {
        transform: translateX(100%);
        opacity: 0;
    }
    to {
        transform: translateX(0);
        opacity: 1;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/titandrillingzm/public_html/admin.titandrillingzm.com/resources/views/profile.blade.php ENDPATH**/ ?>