@extends('welcome')

@section('title', 'Subscription')

@section('content')
<div class="subscription-container">
    <div class="subscription-header">
        <div class="header-content">
            <div class="page-title">
                <h1>Subscription Management</h1>
                <p>Manage your subscription plans, billing, and payment methods</p>
            </div>
        </div>
    </div>
    
    <div class="subscription-content">
            <div class="content-box">
            <div class="action-bar">
                <div class="action-content">
                    <div class="page-title">
                        <h1>Subscription</h1>
                    </div>
                    <div class="action-buttons">
                        <button class="btn-create" data-bs-toggle="modal" data-bs-target="#upgrade-plan">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                            </svg>
                            Upgrade Plan
                        </button>
                        <button class="btn-secondary" data-bs-toggle="modal" data-bs-target="#billing-history">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                <polyline points="14,2 14,8 20,8"/>
                                <line x1="16" y1="13" x2="8" y2="13"/>
                                <line x1="16" y1="17" x2="8" y2="17"/>
                                <polyline points="10,9 9,9 8,9"/>
                            </svg>
                            Billing History
                        </button>
                    </div>
                </div>
            </div>
            
            <div class="subscription-overview">
                <div class="current-plan-card">
                    <div class="plan-header">
                        <div class="plan-info">
                            <h2>Current Plan</h2>
                            <div class="plan-badge">
                                <span class="badge-text">Professional</span>
                            </div>
                        </div>
                        <div class="plan-status">
                            <span class="status-active">Active</span>
                        </div>
                    </div>
                    <div class="plan-details">
                        <div class="plan-features">
                            <div class="feature-item">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M20 6L9 17l-5-5"/>
                                </svg>
                                <span>Unlimited Inspections</span>
                            </div>
                            <div class="feature-item">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M20 6L9 17l-5-5"/>
                                </svg>
                                <span>Advanced Reporting</span>
                            </div>
                            <div class="feature-item">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M20 6L9 17l-5-5"/>
                                </svg>
                                <span>Priority Support</span>
                            </div>
                            <div class="feature-item">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M20 6L9 17l-5-5"/>
                                </svg>
                                <span>API Access</span>
                            </div>
                        </div>
                        <div class="plan-pricing">
                            <div class="price">
                                <span class="currency">$</span>
                                <span class="amount">99</span>
                                <span class="period">/month</span>
                            </div>
                            <div class="billing-info">
                                <span>Billed monthly</span>
                                <span>Next billing: Dec 15, 2024</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="subscription-settings">
                    <div class="settings-section">
                        <h3>Billing Settings</h3>
                        <div class="settings-form">
                            <div class="form-group">
                                <label for="currency" class="form-label">Currency</label>
                                <div class="input-with-select">
                                    <input type="text" class="form-control" id="currency" name="currency" placeholder="Select currency" value="USD" readonly>
                                    <button type="button" class="btn-select" data-bs-toggle="modal" data-bs-target="#select-checklist">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M3 3h18v18H3zM9 9h6v6H9z"/>
                                        </svg>
                                    </button>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="payment-method" class="form-label">Payment Method</label>
                                <div class="payment-method">
                                    <div class="payment-card">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <rect x="1" y="4" width="22" height="16" rx="2" ry="2"/>
                                            <line x1="1" y1="10" x2="23" y2="10"/>
                                        </svg>
                                        <div class="card-info">
                                            <span class="card-type">Visa</span>
                                            <span class="card-number">•••• •••• •••• 4242</span>
                                        </div>
                                        <button class="btn-edit-card">Edit</button>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="billing-email" class="form-label">Billing Email</label>
                                <input type="email" class="form-control" id="billing-email" name="billing-email" placeholder="Enter billing email" value="billing@company.com">
                            </div>
                        </div>
                    </div>
                    
                    <div class="settings-section">
                        <h3>Subscription Management</h3>
                        <div class="subscription-actions">
                            <button class="btn-secondary">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"/>
                                    <polyline points="22,6 12,13 2,6"/>
                                </svg>
                                Update Billing Info
                            </button>
                            <button class="btn-secondary">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                    <polyline points="14,2 14,8 20,8"/>
                                    <line x1="16" y1="13" x2="8" y2="13"/>
                                    <line x1="16" y1="17" x2="8" y2="17"/>
                                    <polyline points="10,9 9,9 8,9"/>
                                </svg>
                                Download Invoice
                            </button>
                            <button class="btn-danger">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M3 6h18"/>
                                    <path d="M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6"/>
                                    <path d="M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2"/>
                            </svg>
                                Cancel Subscription
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <script>
        function toggleSidebar() {
            const sidebar = document.querySelector('.sidebar');
            sidebar.classList.toggle('collapsed');
        }
    </script>
<!-- Modern Currency Selection Modal -->
<div class="modal fade" id="select-checklist" tabindex="-1" aria-labelledby="currencySelectionModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="currencySelectionModalLabel">Select Currency</h4>
                <button type="button" class="modal-close" data-bs-dismiss="modal" aria-label="Close">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"/>
                        <line x1="6" y1="6" x2="18" y2="18"/>
                    </svg>
                </button>
            </div>
            <div class="modal-body">
                <form class="currency-selection-form" action="">
                    <div class="search-section">
                        <div class="search-container">
                            <svg class="search-icon" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <circle cx="11" cy="11" r="8"/>
                                <path d="m21 21-4.35-4.35"/>
                            </svg>
                            <input type="text" class="search-input" placeholder="Search currencies...">
                        </div>
                    </div>
                    <div class="currency-list">
                        <div class="currency-item">
                            <div class="currency-info">
                                <span class="currency-code">USD</span>
                                <span class="currency-name">US Dollar</span>
                            </div>
                            <div class="currency-symbol">$</div>
                        </div>
                        <div class="currency-item">
                            <div class="currency-info">
                                <span class="currency-code">EUR</span>
                                <span class="currency-name">Euro</span>
                            </div>
                            <div class="currency-symbol">€</div>
                        </div>
                        <div class="currency-item">
                            <div class="currency-info">
                                <span class="currency-code">GBP</span>
                                <span class="currency-name">British Pound</span>
                            </div>
                            <div class="currency-symbol">£</div>
                        </div>
                        <div class="currency-item">
                            <div class="currency-info">
                                <span class="currency-code">CAD</span>
                                <span class="currency-name">Canadian Dollar</span>
                            </div>
                            <div class="currency-symbol">C$</div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn-cancel" data-bs-dismiss="modal">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <line x1="18" y1="6" x2="6" y2="18"/>
                        <line x1="6" y1="6" x2="18" y2="18"/>
                    </svg>
                    Cancel
                </button>
                <button type="submit" class="btn-save" form="currency-selection-form">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M20 6L9 17l-5-5"/>
                    </svg>
                    Select
                </button>
            </div>
        </div>
    </div>
</div>

<script>
    var dropdown = document.getElementsByClassName("dropdown-btn");
    var i;

    for (i = 0; i < dropdown.length; i++) {
        dropdown[i].addEventListener("click", function() {
            this.classList.toggle("active");
            var dropdownContent = this.nextElementSibling;
            if (dropdownContent.style.display === "block") {
                dropdownContent.style.display = "none";
            } else {
                dropdownContent.style.display = "block";
            }
        });
    }
</script>
@endsection

<style>
/* Import Google Fonts for better typography */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

/* ===== MAIN CONTAINER ===== */
.subscription-container {
    min-height: 100vh;
    background: #f8fafc;
    font-family: 'Inter', sans-serif;
    padding: 0;
    margin: 0;
    overflow-x: hidden;
    overflow-y: visible;
}

/* ===== HEADER STYLES ===== */
.subscription-header {
    background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
    padding: 2rem 0;
    margin-bottom: 0;
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    display: none;
}

.header-content {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 2rem;
}

.page-title h1 {
    font-size: 2.5rem;
    font-weight: 700;
    color: #ffffff;
    margin: 0 0 0.5rem 0;
    letter-spacing: -0.025em;
}

.page-title p {
    font-size: 1.125rem;
    color: #cbd5e1;
    margin: 0;
    font-weight: 400;
}

/* ===== MAIN CONTENT ===== */
.subscription-content {
    min-height: 100vh;
}

.content-box {
    background: white;
    padding: 32px 32px 32px 40px;
    border-radius: 0;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
    border: 1px solid #e2e8f0;
    font-family: 'Inter', sans-serif;
    margin-bottom: 2rem;
}

/* ===== ACTION BAR ===== */
.action-bar {
    background: transparent;
    border: none;
    border-radius: 0;
    padding: 0;
    margin-bottom: 32px;
    box-shadow: none;
}

.action-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: 1rem;
    flex-wrap: wrap;
}

.page-title h1, .page-title h2 {
    color: #0f172a;
    font-weight: 700;
    font-size: 32px;
    line-height: 1.2;
    letter-spacing: -0.025em;
    margin: 0;
}

.page-title h2 {
    font-size: 24px;
}

.action-buttons {
    display: flex;
    align-items: center;
    gap: 1rem;
    flex-wrap: wrap;
}

/* ===== BUTTON STYLES ===== */
.btn-create {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: #0055a5;
    color: #ffffff;
    border: none;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    /* font-family: 'Inter', sans-serif; */
    cursor: pointer;
    transition: all 0.2s ease;
    /* box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2); */
    white-space: nowrap;
}

.btn-create:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-1px);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    color: black !important;
}

.btn-secondary {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: #ffffff;
    color: #64748b;
    border: 2px solid #e2e8f0;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
    white-space: nowrap;
}

.btn-secondary:hover {
    background: #f8fafc;
    border-color: #cbd5e1;
    color: #475569;
    transform: translateY(-1px);
}

.btn-danger {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
    color: #ffffff;
    border: none;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
    box-shadow: 0 2px 4px rgba(239, 68, 68, 0.2);
    white-space: nowrap;
}

.btn-danger:hover {
    background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(239, 68, 68, 0.3);
}

/* ===== SUBSCRIPTION OVERVIEW ===== */
.subscription-overview {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 2rem;
    margin-top: 2rem;
}

/* ===== CURRENT PLAN CARD ===== */
.current-plan-card {
    background: #0055a5;
    border-radius: 0;
    padding: 2rem;
    color: #ffffff;
    box-shadow: 0 4px 6px -1px rgba(59, 130, 246, 0.2);
}

.plan-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 2rem;
}

.plan-info h2 {
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0 0 0.5rem 0;
    color: #ffffff;
}

.plan-badge {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.25rem 0.75rem;
    border-radius: 0;
    display: inline-block;
}

.badge-text {
    font-size: 0.875rem;
    font-weight: 600;
    color: #ffffff;
}

.plan-status {
    text-align: right;
}

.status-active {
    background: #10b981;
    color: #ffffff;
    padding: 0.25rem 0.75rem;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
}

.plan-details {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 2rem;
}

.plan-features {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.feature-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.875rem;
    font-weight: 500;
}

.feature-item svg {
    color: #10b981;
    flex-shrink: 0;
}

.plan-pricing {
    text-align: right;
}

.price {
    display: flex;
    align-items: baseline;
    justify-content: flex-end;
    gap: 0.25rem;
    margin-bottom: 1rem;
}

.currency {
    font-size: 1.5rem;
    font-weight: 600;
}

.amount {
    font-size: 3rem;
    font-weight: 700;
    line-height: 1;
}

.period {
    font-size: 1rem;
    font-weight: 500;
    opacity: 0.9;
}

.billing-info {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
    font-size: 0.875rem;
    opacity: 0.9;
}

/* ===== SUBSCRIPTION SETTINGS ===== */
.subscription-settings {
    display: flex;
    flex-direction: column;
    gap: 2rem;
}

.settings-section {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    padding: 2rem;
    box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06);
}

.settings-section h3 {
    font-size: 1.25rem;
    font-weight: 700;
    color: #1e293b;
    margin: 0 0 1.5rem 0;
}

.settings-form {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.form-group {
    display: flex;
    flex-direction: column;
}

.form-label {
    font-weight: 600;
    color: #374151;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
}

.form-control {
    border: 2px solid #e2e8f0;
    border-radius: 0;
    padding: 0.75rem 1rem;
    font-size: 0.875rem;
    font-weight: 500;
    color: #1e293b;
    background: #ffffff;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
}

.form-control:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.input-with-select {
    position: relative;
    display: flex;
}

.input-with-select .form-control {
    flex: 1;
    border-right: none;
}

.btn-select {
    background: #f8fafc;
    border: 2px solid #e2e8f0;
    border-left: none;
    padding: 0.75rem;
    cursor: pointer;
    transition: all 0.2s ease;
    display: flex;
    align-items: center;
    justify-content: center;
}

.btn-select:hover {
    background: #f1f5f9;
    border-color: #cbd5e1;
}

/* ===== PAYMENT METHOD ===== */
.payment-method {
    margin-top: 0.5rem;
}

.payment-card {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    background: #f8fafc;
    border: 2px solid #e2e8f0;
    border-radius: 0;
    transition: all 0.2s ease;
}

.payment-card:hover {
    border-color: #cbd5e1;
    background: #f1f5f9;
}

.payment-card svg {
    color: #64748b;
    flex-shrink: 0;
}

.card-info {
    flex: 1;
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.card-type {
    font-weight: 600;
    color: #1e293b;
    font-size: 0.875rem;
}

.card-number {
    color: #64748b;
    font-size: 0.875rem;
    font-family: 'Courier New', monospace;
}

.btn-edit-card {
    background: #0055a5;
    color: #ffffff;
    border: none;
    border-radius: 0;
    padding: 0.5rem 1rem;
    font-size: 0.875rem;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-edit-card:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-1px);
    box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
    color: black !important;
}

/* ===== SUBSCRIPTION ACTIONS ===== */
.subscription-actions {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

/* ===== MODAL STYLES ===== */
.modal {
    font-family: 'Inter', sans-serif;
}

.modal.show {
    display: block;
}

.modal.fade .modal-dialog {
    transition: transform 0.3s ease-out;
    transform: translate(0, -50px);
}

.modal.show .modal-dialog {
    transform: none;
}

.modal-dialog {
    max-width: 100%;
    margin: 1.75rem auto;
}

.modal-dialog.modal-lg {
    max-width: 600px;
}

.modal-content {
    background: #ffffff;
    border: 1px solid #e2e8f0;
    border-radius: 0;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
}

.modal-header {
    background: linear-gradient(135deg, #1e293b 0%, #334155 100%);
    color: #ffffff;
    border-bottom: 1px solid #e2e8f0;
    padding: 1.5rem 2rem;
    border-radius: 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.modal-title {
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0;
    color: #ffffff;
}

.modal-close {
    background: none;
    border: none;
    color: #ffffff;
    font-size: 1.5rem;
    cursor: pointer;
    padding: 0;
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 0;
    transition: background-color 0.2s;
}

.modal-close:hover {
    background-color: rgba(255, 255, 255, 0.1);
}

.modal-body {
    padding: 2rem;
}

.modal-footer {
    background: #f8fafc;
    border-top: 1px solid #e2e8f0;
    padding: 1.5rem 2rem;
    display: flex;
    justify-content: flex-end;
    gap: 1rem;
    border-radius: 0;
}

/* ===== SEARCH SECTION ===== */
.search-section {
    margin-bottom: 1.5rem;
}

.search-container {
    position: relative;
    display: flex;
    align-items: center;
}

.search-icon {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #64748b;
    pointer-events: none;
    z-index: 2;
}

.search-input {
    padding: 0.75rem 1rem 0.75rem 3rem;
    border: 2px solid #e2e8f0;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 500;
    color: #1e293b;
    background: #ffffff;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
    width: 100%;
}

.search-input:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.search-input::placeholder {
    color: #94a3b8;
    font-weight: 400;
}

/* ===== CURRENCY LIST ===== */
.currency-list {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
    max-height: 300px;
    overflow-y: auto;
}

.currency-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem;
    background: #f8fafc;
    border: 2px solid #e2e8f0;
    border-radius: 0;
    cursor: pointer;
    transition: all 0.2s ease;
}

.currency-item:hover {
    background: #f1f5f9;
    border-color: #3b82f6;
}

.currency-info {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.currency-code {
    font-weight: 600;
    color: #1e293b;
    font-size: 0.875rem;
}

.currency-name {
    color: #64748b;
    font-size: 0.875rem;
}

.currency-symbol {
    font-size: 1.25rem;
    font-weight: 600;
    color: #3b82f6;
}

/* ===== MODAL FOOTER BUTTONS ===== */
.btn-save {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
    color: #ffffff;
    border: none;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
    box-shadow: 0 2px 4px rgba(59, 130, 246, 0.2);
}

.btn-save:hover {
    background: linear-gradient(135deg, #1d4ed8 0%, #1e40af 100%);
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(59, 130, 246, 0.3);
}

.btn-cancel {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.75rem 1.5rem;
    background: #ffffff;
    color: #64748b;
    border: 2px solid #e2e8f0;
    border-radius: 0;
    font-size: 0.875rem;
    font-weight: 600;
    font-family: 'Inter', sans-serif;
    cursor: pointer;
    transition: all 0.2s ease;
}

.btn-cancel:hover {
    background: #f8fafc;
    border-color: #cbd5e1;
    color: #475569;
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 1200px) {
    .subscription-container {
        padding: 0;
    }
    
    .subscription-content {
        padding: 20px 0 0 14px;
    }
    
    .content-box {
        padding: 28px 28px 28px 36px;
        margin-left: 0.5rem;
    }
    
    .action-content {
        flex-direction: column;
        align-items: stretch;
        gap: 16px;
    }
    
    .action-buttons {
        justify-content: center;
        flex-wrap: wrap;
    }
    
    .subscription-overview {
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }
    
    .plan-details {
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }
    
    .plan-pricing {
        text-align: left;
    }
    
    .price {
        justify-content: flex-start;
    }
}

@media (max-width: 992px) {
    .subscription-header {
        padding: 1.5rem 0;
    }
    
    .page-title h1 {
        font-size: 2.25rem;
    }
    
    .page-title h2 {
        font-size: 1.75rem;
    }
    
    .action-bar {
        padding: 0;
        margin-bottom: 24px;
    }
    
    .action-buttons {
        gap: 8px;
    }
    
    .action-buttons button {
        padding: 8px 12px;
        font-size: 13px;
    }
    
    .current-plan-card {
        padding: 1.5rem;
    }
    
    .plan-header {
        flex-direction: column;
        gap: 1rem;
        align-items: flex-start;
    }
    
    .plan-status {
        text-align: left;
    }
    
    .amount {
        font-size: 2.5rem;
    }
    
    .settings-section {
        padding: 1.5rem;
    }
    
    .modal-dialog {
        margin: 0.5rem;
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 1rem 1.5rem;
    }
}

@media (max-width: 768px) {
    .header-content {
        padding: 0 1rem;
    }
    
    .subscription-content {
        padding: 1rem 1rem 1rem 2rem;
    }
    
    .content-box {
        padding: 1.5rem 1.5rem 1.5rem 2rem;
        margin-left: 0.25rem;
    }
    
    .page-title h1 {
        font-size: 2rem;
    }
    
    .page-title h2 {
        font-size: 1.5rem;
    }
    
    .action-content {
        flex-direction: column;
        align-items: flex-start;
        gap: 1.5rem;
    }
    
    .action-buttons {
        width: 100%;
        justify-content: flex-start;
        flex-wrap: wrap;
    }
    
    .subscription-overview {
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }
    
    .plan-details {
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }
    
    .plan-pricing {
        text-align: left;
    }
    
    .price {
        justify-content: flex-start;
    }
    
    .subscription-actions {
        gap: 0.75rem;
    }
    
    .modal-dialog {
        margin: 0.5rem;
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 1rem 1.5rem;
    }
}

@media (max-width: 576px) {
    .subscription-content {
        padding: 0.75rem 0.75rem 0.75rem 1.5rem;
    }
    
    .content-box {
        padding: 1rem 1rem 1rem 1.5rem;
        margin-left: 0.25rem;
    }
    
    .page-title h1 {
        font-size: 1.75rem;
    }
    
    .page-title h2 {
        font-size: 1.25rem;
    }
    
    .action-buttons {
        flex-direction: column;
        gap: 0.75rem;
    }
    
    .action-buttons button {
        width: 100%;
        justify-content: center;
        padding: 12px 16px;
        font-size: 14px;
    }
    
    .current-plan-card {
        padding: 1.25rem;
    }
    
    .plan-header {
        flex-direction: column;
        gap: 0.75rem;
        align-items: flex-start;
    }
    
    .plan-status {
        text-align: left;
    }
    
    .amount {
        font-size: 2.25rem;
    }
    
    .settings-section {
        padding: 1.25rem;
    }
    
    .form-group {
        margin-bottom: 1rem;
    }
    
    .form-control {
        padding: 10px 12px;
        font-size: 14px;
    }
    
    .payment-card {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.75rem;
        padding: 0.75rem;
    }
    
    .btn-edit-card {
        align-self: flex-end;
        padding: 8px 12px;
        font-size: 13px;
    }
    
    .subscription-actions {
        gap: 0.5rem;
    }
    
    .subscription-actions button {
        width: 100%;
        justify-content: center;
        padding: 12px 16px;
        font-size: 14px;
    }
    
    .modal-dialog {
        margin: 0.25rem;
        max-width: calc(100% - 0.5rem);
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 0.75rem 1rem;
    }
    
    .modal-title {
        font-size: 1.25rem;
    }
    
    .search-input {
        padding: 10px 12px 10px 2.5rem;
        font-size: 14px;
    }
    
    .currency-item {
        padding: 0.75rem;
    }
    
    .currency-code {
        font-size: 13px;
    }
    
    .currency-name {
        font-size: 13px;
    }
    
    .currency-symbol {
        font-size: 1.125rem;
    }
}

@media (max-width: 480px) {
    .subscription-content {
        padding: 0.5rem 0.5rem 0.5rem 1rem;
    }
    
    .content-box {
        padding: 0.75rem 0.75rem 0.75rem 1rem;
        margin-left: 0.25rem;
    }
    
    .page-title h1 {
        font-size: 1.5rem;
    }
    
    .page-title h2 {
        font-size: 1.125rem;
    }
    
    .current-plan-card {
        padding: 1rem;
    }
    
    .plan-header {
        flex-direction: column;
        gap: 0.5rem;
        align-items: flex-start;
    }
    
    .plan-status {
        text-align: left;
    }
    
    .amount {
        font-size: 2rem;
    }
    
    .settings-section {
        padding: 1rem;
    }
    
    .form-group {
        margin-bottom: 0.75rem;
    }
    
    .form-control {
        padding: 8px 10px;
        font-size: 13px;
    }
    
    .payment-card {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
        padding: 0.5rem;
    }
    
    .btn-edit-card {
        align-self: flex-end;
        padding: 6px 10px;
        font-size: 12px;
    }
    
    .subscription-actions {
        gap: 0.5rem;
    }
    
    .subscription-actions button {
        width: 100%;
        justify-content: center;
        padding: 10px 14px;
        font-size: 13px;
    }
    
    .modal-dialog {
        margin: 0.25rem;
        max-width: calc(100% - 0.5rem);
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 0.5rem 0.75rem;
    }
    
    .modal-title {
        font-size: 1.125rem;
    }
    
    .search-input {
        padding: 8px 10px 8px 2.25rem;
        font-size: 13px;
    }
    
    .currency-item {
        padding: 0.5rem;
    }
    
    .currency-code {
        font-size: 12px;
    }
    
    .currency-name {
        font-size: 12px;
    }
    
    .currency-symbol {
        font-size: 1rem;
    }
}

/* ===== LANDSCAPE ORIENTATION ===== */
@media (max-width: 768px) and (orientation: landscape) {
    .subscription-content {
        padding: 0.5rem 0.5rem 0.5rem 1rem;
    }
    
    .content-box {
        padding: 1rem 1rem 1rem 1.5rem;
        margin-left: 0.25rem;
    }
    
    .current-plan-card {
        padding: 1rem;
    }
    
    .settings-section {
        padding: 1rem;
    }
    
    .modal-dialog {
        margin: 0.25rem;
        max-width: calc(100% - 0.5rem);
    }
    
    .modal-header, .modal-body, .modal-footer {
        padding: 0.75rem 1rem;
    }
}

/* ===== TOUCH DEVICES ===== */
@media (hover: none) and (pointer: coarse) {
    .action-buttons button,
    .subscription-actions button,
    .btn-edit-card,
    .btn-save,
    .btn-cancel {
        min-height: 44px;
        padding: 12px 16px;
    }
    
    .form-control {
        min-height: 44px;
        padding: 12px 16px;
    }
    
    .currency-item {
        min-height: 44px;
        padding: 12px 16px;
    }
    
    .modal-close {
        min-width: 44px;
        min-height: 44px;
    }
}

/* ===== ACCESSIBILITY ===== */
@media (prefers-reduced-motion: reduce) {
    * {
        animation-duration: 0.01ms !important;
        animation-iteration-count: 1 !important;
        transition-duration: 0.01ms !important;
    }
}

/* ===== FOCUS STYLES ===== */
button:focus-visible,
input:focus-visible,
select:focus-visible {
    outline: 2px solid #3b82f6;
    outline-offset: 2px;
}

/* ===== PRINT STYLES ===== */
@media print {
    .action-bar,
    .modal {
        display: none !important;
    }
    
    .subscription-container {
        background: white;
    }
    
    .subscription-header {
        background: white;
        color: black;
    }
    
    .current-plan-card {
        background: white !important;
        color: black !important;
        border: 2px solid #e2e8f0;
    }
}
</style>

<script>
// Modern Subscription Management Functionality
document.addEventListener('DOMContentLoaded', function() {
    // Currency selection functionality
    const currencyItems = document.querySelectorAll('.currency-item');
    const currencyInput = document.querySelector('#currency');
    
    currencyItems.forEach(item => {
        item.addEventListener('click', function() {
            const currencyCode = this.querySelector('.currency-code').textContent;
            const currencySymbol = this.querySelector('.currency-symbol').textContent;
            
            if (currencyInput) {
                currencyInput.value = currencyCode;
            }
            
            // Close modal
            const modal = bootstrap.Modal.getInstance(document.querySelector('#select-checklist'));
            if (modal) {
                modal.hide();
            }
        });
    });
    
    // Search functionality
    const searchInput = document.querySelector('.search-input');
    if (searchInput) {
        searchInput.addEventListener('input', function(e) {
            const searchTerm = e.target.value.toLowerCase();
            currencyItems.forEach(item => {
                const currencyCode = item.querySelector('.currency-code').textContent.toLowerCase();
                const currencyName = item.querySelector('.currency-name').textContent.toLowerCase();
                
                if (currencyCode.includes(searchTerm) || currencyName.includes(searchTerm)) {
                    item.style.display = 'flex';
                } else {
                    item.style.display = 'none';
                }
            });
        });
    }
    
    // Form validation
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            // Add form submission logic here
            console.log('Form submitted');
        });
    });
    
    // Modal handling
    const modals = document.querySelectorAll('.modal');
    modals.forEach(modal => {
        modal.addEventListener('hidden.bs.modal', function() {
            // Reset form when modal is closed
            const form = this.querySelector('form');
            if (form) {
                form.reset();
            }
            // Reset search
            const searchInput = this.querySelector('.search-input');
            if (searchInput) {
                searchInput.value = '';
                currencyItems.forEach(item => {
                    item.style.display = 'flex';
                });
            }
        });
    });
    
    // Payment card edit functionality
    const editCardBtn = document.querySelector('.btn-edit-card');
    if (editCardBtn) {
        editCardBtn.addEventListener('click', function() {
            // Add payment method edit logic here
            console.log('Edit payment method');
        });
    }
    
    // Subscription action buttons
    const subscriptionActions = document.querySelectorAll('.subscription-actions button');
    subscriptionActions.forEach(button => {
        button.addEventListener('click', function() {
            const action = this.textContent.trim();
            console.log('Subscription action:', action);
            
            if (action === 'Cancel Subscription') {
                if (confirm('Are you sure you want to cancel your subscription?')) {
                    // Add cancellation logic here
                    console.log('Subscription cancelled');
                }
            }
        });
    });
});
</script>