@extends('welcome')

@section('title', 'Add User')

@section('styles')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
@endsection

@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<div class="user-container" role="main">
    <!-- Header Section -->
    <div class="header-gradient">
        <div class="header-content">
            <div class="header-left">
                <a href="{{ route('users') }}" class="back-button">
                    <i class="fas fa-arrow-left"></i>
                </a>
                <h1 class="header-title">Add New User</h1>
            </div>
            <div class="header-right">
                <button class="btn-info" type="button" id="refreshFormBtn" aria-label="Refresh form">
                    <i class="fas fa-refresh"></i>
                    Reset Form
                </button>
            </div>
        </div>
    </div>
    
    <!-- Info Banner -->
    <div class="main-content">
        <div class="info-banner" role="status" aria-live="polite">
            <i class="fas fa-info-circle"></i>
            <span>Complete the form below to add a new user to the system</span>
        </div>
    
        <!-- Form Section -->
        <section class="form-section" role="region" aria-label="Add user form">
            <div class="form-container">

            <form id="addUserForm" novalidate>
                @csrf
                <div class="profile-section">
                    <label class="form-title">Employee Profile Picture</label><br>
                    <button type="button" class="btn-upload" id="btnUploadProfile">Upload Picture</button>
                    <input type="file" id="profilePicInput" name="profilePicture" accept="image/*" class="file-input-hidden">
                    <div id="profilePreview" class="profile-preview profile-preview-hidden">
                        <img id="profileImage" src="" alt="Profile Preview" class="profile-image">
                        <button type="button" class="btn-remove" id="removeProfile">Remove</button>
                    </div>
                </div>

                <div class="section-block">
                    <h6 class="section-heading">Authentication Details</h6>
                    <div class="form-row">
                        <div class="form-col-half">
                            <label class="form-label">Full Name <span class="required">*</span></label>
                            <input type="text" class="modern-input" name="fullName" required placeholder="Enter Full Name" maxlength="100">
                        </div>
                        <div class="form-col-half">
                            <label class="form-label">Role <span class="required">*</span></label>
                            <select class="modern-input" name="role" id="roleSelect" required aria-label="Select role">
                                <option value="">Select Role</option>
                                <option value="ProAdmin">Admin</option>
                                <option value="CEO">CEO</option>
                                <option value="Country Manager">Country Manager</option>
                                <option value="Operations Manager">Operations Manager</option>
                                <option value="Health & Safety Manager">Health & Safety Manager</option>
                                <option value="Project Manager">Project Manager</option>
                                <option value="Site Manager">Site Manager</option>
                                <option value="Supervisor">Supervisor</option>
                                <option value="HrManager">HrManager</option>
                                <option value="FinanceManager">FinanceManager</option>
                                <option value="Driller">Driller</option>
                                <option value="Trainee Driller">Trainee Driller</option>
                                <option value="Junior Driller">Junior Driller</option>
                                <option value="Coremarker">Coremarker</option>
                                <option value="Assistant">Assistant</option>
                                <option value="Workshop Manager">Workshop Manager</option>
                                <option value="Workshop Foreman">Workshop Foreman</option>
                                <option value="Maintenance Manager">Maintenance Manager</option>
                                <option value="Mechanical Engineer">Mechanical Engineer</option>
                                <option value="Boilermaker">Boilermaker</option>
                                <option value="Welder">Welder</option>
                                <option value="Mechanic">Mechanic</option>
                                <option value="Machinist">Machinist</option>
                                <option value="Electrician">Electrician</option>
                                <option value="Housekeeper">Housekeeper</option>
                                <option value="Cook">Cook</option>
                                <option value="Stores Officer">Stores Officer</option>
                                <option value="General Worker">General Worker</option>
                            </select>
                        </div>
                        <div class="form-col-half">
                            <label class="form-label">Email <span class="required">*</span></label>
                            <div class="password-input-container">
                                <input type="email" class="modern-input" name="email" id="emailInput" required 
                                       placeholder="Enter email address" maxlength="40">
                            </div>
                            <div id="emailError" class="field-error" style="display: none;"></div>
                        </div>
                        <div class="form-col-half">
                            <label class="form-label">Password <span class="required">*</span></label>
                            <div class="password-input-container">
                                <input type="password" class="modern-input" name="password" id="passwordInput" required 
                                       placeholder="Enter password" minlength="8" maxlength="15">
                                <button type="button" class="password-toggle" id="passwordToggle">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M1 12s4-8 7-8 7 8 7 8-4 8-7 8-7-8-7-8z"></path>
                                        <circle cx="12" cy="12" r="3"></circle>
                                    </svg>
                                </button>
                            </div>
                            <div id="passwordError" class="field-error" style="display: none;"></div>
                        </div>
                        <div class="form-col-half">
                            <label class="form-label">Mobile <span class="required">*</span></label>
                            <input type="tel" class="modern-input" name="mobile" required placeholder="Enter mobile number" maxlength="15">
                        </div>
                        <div class="form-col-half">
                            <label class="form-label">Employee Number <span class="required">*</span></label>
                            <input type="text" class="modern-input" name="employeeNumber" required placeholder="Enter Employee Number" maxlength="20">
                        </div>
                        <div class="form-col-half">
                            <label class="form-label">Department <span class="required">*</span></label>
                            <input type="text" class="modern-input" name="department" required placeholder="Enter Department">
                        </div>
                        <div class="form-col-half">
                            <label class="form-label">NRC / ID Number <span class="required">*</span></label>
                            <input type="text" class="modern-input" name="nrcId" required placeholder="Enter NRC / ID Number" maxlength="20">
                        </div>
                        <div class="form-col-half">
                            <label class="form-label">Engagement Date <span class="required">*</span></label>
                            <input type="date" class="modern-input datepicker" name="engagementDate" id="engagementDate" required>
                        </div>
                        <div class="form-col-full">
                            <label class="form-label">Countries <span class="required">*</span></label>
                            <select class="modern-input" name="countries" id="countriesSelect" required aria-label="Select country">
                                <option value="">Select Country</option>
                                <option value="Zambia">Zambia</option>
                                <option value="DRC">DRC</option>
                                <option value="Namibia">Namibia</option>
                                <option value="Botswana">Botswana</option>
                            </select>
                        </div>
                        <div class="form-col-full">
                            <label class="form-label">Projects <span class="required">*</span> <span class="dependency-note">(Select Country First)</span></label>
                            <div class="multi-select-container">
                                <div class="multi-select-input disabled" id="projectMultiSelect">
                                    <span class="multi-select-placeholder">Select Country First</span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <polyline points="6,9 12,15 18,9"></polyline>
                                    </svg>
                                </div>
                                <div class="multi-select-dropdown" id="projectDropdown">
                                <div class="multi-select-option" data-value="Kansanshi" data-country="Zambia">
                                    <input type="checkbox" id="project-kansanshi" value="Kansanshi">
                                    <label for="project-kansanshi">Kansanshi</label>
                                </div>
                                <div class="multi-select-option" data-value="Kalumbila" data-country="Zambia">
                                    <input type="checkbox" id="project-kalumbila" value="Kalumbila">
                                    <label for="project-kalumbila">Kalumbila</label>
                                </div>
                                <div class="multi-select-option" data-value="Kimteto" data-country="Zambia">
                                    <input type="checkbox" id="project-kimteto" value="Kimteto">
                                    <label for="project-kimteto">Kimteto</label>
                                </div>
                                <div class="multi-select-option" data-value="Kobold" data-country="Zambia">
                                    <input type="checkbox" id="project-kobold" value="Kobold">
                                    <label for="project-kobold">Kobold</label>
                                </div>
                                <div class="multi-select-option" data-value="FQM Exploration" data-country="Zambia">
                                    <input type="checkbox" id="project-fqm" value="FQM Exploration">
                                    <label for="project-fqm">FQM Exploration</label>
                                </div>
                                <div class="multi-select-option" data-value="Mimosa" data-country="Zambia">
                                    <input type="checkbox" id="project-mimosa" value="Mimosa">
                                    <label for="project-mimosa">Mimosa</label>
                                </div>
                                <div class="multi-select-option" data-value="Lubumbashi" data-country="DRC">
                                    <input type="checkbox" id="project-lubumbashi" value="Lubumbashi">
                                    <label for="project-lubumbashi">Lubumbashi</label>
                                </div>
                                <div class="multi-select-option" data-value="Musompo" data-country="DRC">
                                    <input type="checkbox" id="project-musompo" value="Musompo">
                                    <label for="project-musompo">Musompo</label>
                                </div>
                                <div class="multi-select-option" data-value="IME" data-country="DRC">
                                    <input type="checkbox" id="project-ime" value="IME">
                                    <label for="project-ime">IME</label>
                                </div>
                                <div class="multi-select-option" data-value="Kamoa" data-country="DRC">
                                    <input type="checkbox" id="project-kamoa" value="Kamoa">
                                    <label for="project-kamoa">Kamoa</label>
                                </div>
                                <div class="multi-select-option" data-value="Rosh Pinah" data-country="Namibia">
                                    <input type="checkbox" id="project-rosh-pinah" value="Rosh Pinah">
                                    <label for="project-rosh-pinah">Rosh Pinah</label>
                                </div>
                                <div class="multi-select-option" data-value="Tsumeb" data-country="Namibia">
                                    <input type="checkbox" id="project-tsumeb" value="Tsumeb">
                                    <label for="project-tsumeb">Tsumeb</label>
                                </div>
                                <div class="multi-select-option" data-value="Jwaneng" data-country="Botswana">
                                    <input type="checkbox" id="project-jwaneng" value="Jwaneng">
                                    <label for="project-jwaneng">Jwaneng</label>
                                </div>
                                <div class="multi-select-option" data-value="Orapa" data-country="Botswana">
                                    <input type="checkbox" id="project-orapa" value="Orapa">
                                    <label for="project-orapa">Orapa</label>
                                </div>
                                </div>
                            </div>
                            <div class="selected-projects" id="selectedProjects"></div>
                        </div>
                        <div class="form-col-full">
                            <label class="form-label">Modules <span class="required">*</span></label>
                            <div class="multi-select-container">
                                <div class="multi-select-input" id="moduleMultiSelect">
                                    <span class="multi-select-placeholder">Select Modules</span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <polyline points="6,9 12,15 18,9"></polyline>
                                    </svg>
                        </div>
                                <div class="multi-select-dropdown" id="moduleDropdown">
                                    <div class="multi-select-option" data-value="Equipments">
                                        <input type="checkbox" id="module-equipments" value="Equipments">
                                        <label for="module-equipments">Equipments</label>
                                    </div>
                                    <div class="multi-select-option" data-value="Documents">
                                        <input type="checkbox" id="module-documents" value="Documents">
                                        <label for="module-documents">Documents</label>
                                    </div>
                                    <div class="multi-select-option" data-value="teamEmploy">
                                        <input type="checkbox" id="module-teamEmploy" value="teamEmploy">
                                        <label for="module-teamEmploy">Team Employ</label>
                                    </div>
                                    <div class="multi-select-option" data-value="inspectionReport">
                                        <input type="checkbox" id="module-inspectionReport" value="inspectionReport">
                                        <label for="module-inspectionReport">Inspection Report</label>
                                    </div>
                                    <div class="multi-select-option" data-value="dvirReport">
                                        <input type="checkbox" id="module-dvirReport" value="dvirReport">
                                        <label for="module-dvirReport">DVIR Report</label>
                                    </div>
                                    <div class="multi-select-option" data-value="checklist">
                                        <input type="checkbox" id="module-checklist" value="checklist">
                                        <label for="module-checklist">Checklist</label>
                                    </div>
                                    <div class="multi-select-option" data-value="incidentReport">
                                        <input type="checkbox" id="module-incidentReport" value="incidentReport">
                                        <label for="module-incidentReport">Incident Report</label>
                                    </div>
                                    <div class="multi-select-option" data-value="dailyReport">
                                        <input type="checkbox" id="module-dailyReport" value="dailyReport">
                                        <label for="module-dailyReport">Daily Report</label>
                                    </div>
                                    <div class="multi-select-option" data-value="requestMaintenance">
                                        <input type="checkbox" id="module-requestMaintenance" value="requestMaintenance">
                                        <label for="module-requestMaintenance">Request Maintenance</label>
                                    </div>
                                    <div class="multi-select-option" data-value="jobcard">
                                        <input type="checkbox" id="module-jobcard" value="jobcard">
                                        <label for="module-jobcard">Jobcard</label>
                                    </div>
                                    <div class="multi-select-option" data-value="serviceSchedule">
                                        <input type="checkbox" id="module-serviceSchedule" value="serviceSchedule">
                                        <label for="module-serviceSchedule">Service Schedule</label>
                                    </div>
                                    <div class="multi-select-option" data-value="fuelLog">
                                        <input type="checkbox" id="module-fuelLog" value="fuelLog">
                                        <label for="module-fuelLog">Fuel Log</label>
                                    </div>
                                    <div class="multi-select-option" data-value="logbook">
                                        <input type="checkbox" id="module-logbook" value="logbook">
                                        <label for="module-logbook">Logbook</label>
                                    </div>
                                    <div class="multi-select-option" data-value="hrForm">
                                        <input type="checkbox" id="module-hrForm" value="hrForm">
                                        <label for="module-hrForm">HR Form</label>
                                    </div>
                                    <div class="multi-select-option" data-value="hrApplications">
                                        <input type="checkbox" id="module-hrApplications" value="hrApplications">
                                        <label for="module-hrApplications">HR Applications</label>
                                    </div>
                                    <div class="multi-select-option" data-value="teamKpi">
                                        <input type="checkbox" id="module-teamKpi" value="teamKpi">
                                        <label for="module-teamKpi">Team KPI</label>
                                    </div>
                                </div>
                            </div>
                            <div class="selected-modules" id="selectedModules"></div>
                        </div>
                    </div>
                </div>

                <!-- Module Permissions Section -->
                <div class="section-block" id="permissionsSection" style="display: none;">
                    <h6 class="section-heading">Module Permissions</h6>
                    <div id="modulePermissionsContainer"></div>
                </div>

                <div class="section-block">
                    <h6 class="section-heading">Titan Induction</h6>
                    <div class="form-row">
                        <div class="form-col-half">
                            <label class="form-label">Titan Induction Date</label>
                            <input type="date" class="modern-input datepicker" name="titanInductionDate" id="titanInductionDate">
                        </div>
                        <div class="form-col-half">
                            <label class="form-label">Client Induction</label>
                            <input type="date" class="modern-input datepicker" name="clientInductionDate" id="clientInductionDate">
                        </div>
                    </div>
                </div>

                <div class="section-block">
                    <h6 class="section-heading">Medicals</h6>
                    <div class="form-row form-row-align-end">
                        <div class="form-col-half">
                            <label class="form-label">Date Examined</label>
                            <input type="date" class="modern-input datepicker" name="medicalExamined" id="medicalExamined">
                        </div>
                        <div class="form-col-half">
                            <label class="form-label">Expiry</label>
                            <input type="date" class="modern-input datepicker" name="medicalExpiry" id="medicalExpiry">
                        </div>
                        <div class="form-col-full">
                            <button type="button" class="btn-upload" id="btnUploadMedical">Upload Medical Docs</button>
                            <input type="file" id="medicalDocsInput" name="medicalDocs[]" multiple class="file-input-hidden">
                            <div id="medicalFilesList" class="files-list"></div>
                        </div>
                    </div>
                </div>

                <div class="section-block">
                    <h6 class="section-heading">Driver's License</h6>
                    <div class="form-row form-row-align-end">
                        <div class="form-col-half">
                            <label class="form-label">Number</label>
                            <input type="text" class="modern-input" name="dlNumber" placeholder="Enter License Number" maxlength="20">
                        </div>
                        <div class="form-col-half">
                            <label class="form-label">Code</label>
                            <input type="text" class="modern-input" name="dlCode" placeholder="Enter License Code" maxlength="5">
                        </div>
                        <div class="form-col-half">
                            <label class="form-label">Expiry</label>
                            <input type="date" class="modern-input datepicker" name="dlExpiry" id="dlExpiry">
                        </div>
                        <div class="form-col-full">
                            <button type="button" class="btn-upload" id="btnUploadDL">Upload License Docs</button>
                            <input type="file" id="dlDocsInput" name="dlDocs[]" multiple accept=".pdf,.jpg,.jpeg,.png" class="file-input-hidden">
                            <div id="dlFilesList" class="files-list"></div>
                        </div>
                    </div>
                </div>

                <div class="section-block">
                    <h6 class="section-heading">Defensive Driving Data</h6>
                    <div class="form-row">
                        <div class="form-col-half">
                            <label class="form-label">Client Driving Date</label>
                            <input type="date" class="modern-input datepicker" name="clientDrivingDate" id="clientDrivingDate">
                        </div>
                        <div class="form-col-full">
                            <button type="button" class="btn-upload" id="btnUploadDriving">Upload Driving Docs</button>
                            <input type="file" id="drivingDocsInput" name="drivingDocs[]" multiple accept=".pdf,.jpg,.jpeg,.png" class="file-input-hidden">
                            <div id="drivingFilesList" class="files-list"></div>
                        </div>
                    </div>
                </div>

                <div class="section-block">
                    <h6 class="section-heading">First Aid Training</h6>
                    <div class="form-row">
                        <div class="form-col-third">
                            <label class="form-label">Date Completed</label>
                            <input type="date" class="modern-input datepicker" name="faDateCompleted" id="faDateCompleted">
                        </div>
                        <div class="form-col-third">
                            <label class="form-label">Level</label>
                            <select class="modern-input" name="faLevel">
                                <option value="">Select First Aid Level</option>
                                <option value="Basic">Basic</option>
                                <option value="Intermediate">Intermediate</option>
                                <option value="Advanced">Advanced</option>
                                <option value="Instructor">Instructor</option>
                                <option value="Master">Master</option>
                            </select>
                        </div>
                        <div class="form-col-third">
                            <label class="form-label">Expiry Date</label>
                            <input type="date" class="modern-input datepicker" name="faExpiryDate" id="faExpiryDate">
                        </div>
                    </div>
                </div>

                <div class="form-actions">
                    <button type="button" class="btn-ghost" id="cancelBtn">Cancel</button>
                    <button type="button" class="btn-primary" id="saveUserBtn">Save User</button>
                </div>
            </form>
        </div>
    </section>
</div>

<!-- Success Modal -->
<div id="successModal" class="success-modal-overlay" style="display: none;">
    <div class="success-modal-container">
        <div class="success-modal-header">
            <h2 class="success-title">Success</h2>
        </div>
        <div class="success-modal-body">
            <p class="success-message">User Created Successfully!</p>
            <div class="success-buttons">
                <button type="button" class="success-btn back-btn" onclick="goBackToUsers()">
                    Back
                </button>
                <button type="button" class="success-btn add-another-btn" onclick="addAnotherUser()">
                    Add New User
                </button>
            </div>
        </div>
    </div>
</div>

<style>
/* Custom CSS - No Bootstrap Dependencies */
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');

:root {
    --primary-color: #0055a5;
    --primary-hover: #003d7a;
    --secondary-color: #3b82f6;
    --success-color: #10b981;
    --info-color: #ffd205;
    --text-primary: #0f172a;
    --text-muted: #64748b;
    --bg-white: #ffffff;
    --border-color: #e2e8f0;
    --border-light: #d1d5db;
    --shadow-md: 0 1px 3px 0 rgba(0,0,0,0.1), 0 1px 2px 0 rgba(0,0,0,0.06);
    --radius-sm: 0;
    --transition-base: all .2s ease;
}

/* Reset and Base Styles */
* {
    box-sizing: border-box;
}

body {
    font-family: 'Inter', sans-serif;
    margin: 0;
    padding: 0;
    background-color: #f8fafc;
}

/* Container Styles */
.user-container {
    min-height: 100vh;
    background: var(--bg-light);
}

/* Header Styles */
.header-gradient {
    background: #0055a5;
    padding: 20px 0;
    box-shadow: 0 4px 12px rgba(0, 85, 165, 0.3);
}

.header-content {
    width: 100%;
    padding: 0 20px;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.header-left {
    display: flex;
    align-items: center;
    gap: 15px;
}

.back-button {
    color: white;
    font-size: 20px;
    text-decoration: none;
    padding: 8px;
    border-radius: 50%;
    transition: var(--transition-base);
}

.back-button:hover {
    background-color: rgba(255, 255, 255, 0.1);
    color: white;
}

.header-title {
    color: white;
    font-size: 28px;
    font-weight: 700;
    margin: 0;
}

.header-right {
    display: flex;
    align-items: center;
    gap: 15px;
}

/* Main Content */
.main-content {
    width: 100%;
    padding: 30px 20px;
}

/* Button Styles */
.btn-primary, .btn-secondary, .btn-success, .btn-info {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 20px;
    border: none;
    border-radius: var(--radius-sm);
    font-size: 14px;
    font-weight: 500;
    cursor: pointer;
    box-shadow: 0 1px 2px rgba(0,0,0,.05);
    text-decoration: none;
    transition: var(--transition-base);
}

.btn-primary {
    background: #0055a5;
    color: #fff;
}

.btn-primary:hover {
    background: #003d7a;
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.btn-secondary {
    background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
    color: #fff;
}

.btn-secondary:hover {
    background: linear-gradient(135deg, #4b5563 0%, #374151 100%);
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.btn-info {
    background: white;
    color: var(--primary-color);
    border: none;
    padding: 12px 24px;
    border-radius: var(--radius-md);
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: var(--transition-base);
    box-shadow: var(--shadow-sm);
}

.btn-info:hover {
    background: rgba(255, 255, 255, 0.9);
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

.btn-ghost {
    background: #0055a5;
    border: 1px solid #0055a5;
    color: #fff;
    
    padding: 12px 20px;
    cursor: pointer;
    transition: var(--transition-base);
}

.btn-ghost:hover {
    background: #003d7a;
    border-color: #003d7a;
    transform: translateY(-1px);
    box-shadow: var(--shadow-md);
}

.btn-upload {
    background: #0055a5;
    color: #fff;
    border: none;
    border-radius: 6px;
    padding: 8px 12px;
    font-size: 13px;
    cursor: pointer;
    transition: var(--transition-base);
}

.btn-upload:hover {
    background: #003d7a;
}

.btn-remove {
    background: #ef4444;
    color: #fff;
    border: none;
    border-radius: 4px;
    padding: 4px 8px;
    font-size: 12px;
    cursor: pointer;
    transition: var(--transition-base);
}

.btn-remove:hover {
    background: #dc2626;
}

/* Form Section Styles */
.form-section {
    background: #fff;
    border: 1px solid var(--border-color);
    box-shadow: var(--shadow-md);
    border-radius: var(--radius-sm);
    overflow: hidden;
}

.form-container {
    padding: 32px;
}

.info-banner {
    display: flex;
    align-items: center;
    gap: 10px;
    background: #e8f2ff;
    border: 1px solid #cfe0ff;
    border-left: 4px solid #3b82f6;
    color: #1e3a8a;
    padding: 12px 14px;
    border-radius: 6px;
    margin-bottom: 24px;
    font-size: 14px;
    font-weight: 500;
}

/* Form Layout Styles */
.form-row {
    display: flex;
    flex-wrap: wrap;
    gap: 16px;
    margin-bottom: 16px;
}

.form-row-align-end {
    align-items: flex-end;
}

.form-col-half {
    flex: 1;
    min-width: 300px;
}

.form-col-third {
    flex: 1;
    min-width: 200px;
}

.form-col-full {
    flex: 100%;
    width: 100%;
}

/* Profile Section */
.profile-section {
    margin-bottom: 24px;
}

/* Section Block Styles */
.section-block {
    background: #fff;
    border: 1px solid #e5e7eb;
    border-radius: 6px;
    padding: 20px;
    margin-bottom: 20px;
}

.section-heading {
    font-weight: 600;
    color: #111827;
    margin: 0 0 16px 0;
    font-size: 16px;
}

/* Form Elements */
.form-title {
    font-weight: 600;
    color: #1f2937;
    margin-bottom: 8px;
    display: block;
}

.form-label {
    display: block;
    margin-bottom: 6px;
    font-weight: 500;
    color: #374151;
    font-size: 14px;
}

.modern-input {
    width: 100%;
    height: 44px;
    padding: 10px 12px;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    background: #fff;
    font-size: 14px;
    color: #374151;
    transition: var(--transition-base);
}

.modern-input:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59,130,246,.1);
}

/* Date input styling */
.datepicker {
    position: relative;
}

.datepicker::-webkit-calendar-picker-indicator {
    background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='20' height='20' viewBox='0 0 24 24' fill='none' stroke='%23666' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Crect x='3' y='4' width='18' height='18' rx='2' ry='2'/%3E%3Cline x1='16' y1='2' x2='16' y2='6'/%3E%3Cline x1='8' y1='2' x2='8' y2='6'/%3E%3Cline x1='3' y1='10' x2='21' y2='10'/%3E%3C/svg%3E") no-repeat center;
    background-size: 20px 20px;
    cursor: pointer;
    padding: 4px;
    margin-left: 8px;
}

.datepicker::-webkit-calendar-picker-indicator:hover {
    background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='20' height='20' viewBox='0 0 24 24' fill='none' stroke='%233b82f6' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Crect x='3' y='4' width='18' height='18' rx='2' ry='2'/%3E%3Cline x1='16' y1='2' x2='16' y2='6'/%3E%3Cline x1='8' y1='2' x2='8' y2='6'/%3E%3Cline x1='3' y1='10' x2='21' y2='10'/%3E%3C/svg%3E") no-repeat center;
    background-size: 20px 20px;
}

/* Firefox date input styling */
.datepicker::-moz-calendar-picker-indicator {
    background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='20' height='20' viewBox='0 0 24 24' fill='none' stroke='%23666' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Crect x='3' y='4' width='18' height='18' rx='2' ry='2'/%3E%3Cline x1='16' y1='2' x2='16' y2='6'/%3E%3Cline x1='8' y1='2' x2='8' y2='6'/%3E%3Cline x1='3' y1='10' x2='21' y2='10'/%3E%3C/svg%3E") no-repeat center;
    background-size: 20px 20px;
    cursor: pointer;
    padding: 4px;
    margin-left: 8px;
}

.datepicker::-moz-calendar-picker-indicator:hover {
    background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='20' height='20' viewBox='0 0 24 24' fill='none' stroke='%233b82f6' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Crect x='3' y='4' width='18' height='18' rx='2' ry='2'/%3E%3Cline x1='16' y1='2' x2='16' y2='6'/%3E%3Cline x1='8' y1='2' x2='8' y2='6'/%3E%3Cline x1='3' y1='10' x2='21' y2='10'/%3E%3C/svg%3E") no-repeat center;
    background-size: 20px 20px;
}

.required {
    color: #ef4444;
}

.dependency-note {
    color: #6b7280;
    font-size: 12px;
    font-weight: normal;
    font-style: italic;
}

.hint {
    display: block;
    margin-top: 4px;
    color: #6b7280;
    font-size: 12px;
}

/* Profile Preview */
.profile-preview {
    margin-top: 12px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.profile-preview-hidden {
    display: none;
}

.profile-image {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    object-fit: cover;
    border: 2px solid #e5e7eb;
}

/* File Input */
.file-input-hidden {
    display: none;
}

/* Password Input Container */
.password-input-container {
    position: relative;
    display: flex;
    align-items: center;
}

.password-toggle {
    position: absolute;
    right: 12px;
    background: none;
    border: none;
    cursor: pointer;
    padding: 4px;
    color: #6b7280;
    transition: var(--transition-base);
}

.password-toggle:hover {
    color: #374151;
}

/* Multi-Select Styles */
.multi-select-container {
    position: relative;
    width: 100%;
}

.multi-select-input {
    width: 100%;
    height: 44px;
    padding: 10px 12px;
    border: 1px solid #d1d5db;
    border-radius: 6px;
    background: #fff;
    font-size: 14px;
    color: #374151;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: space-between;
    transition: var(--transition-base);
}

.multi-select-input:hover {
    border-color: #3b82f6;
}

.multi-select-input.active {
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59,130,246,.1);
}

.multi-select-input.disabled {
    background-color: #f9fafb;
    border-color: #d1d5db;
    color: #9ca3af;
    cursor: not-allowed;
    opacity: 0.6;
}

.multi-select-input.disabled:hover {
    border-color: #d1d5db;
    box-shadow: none;
}

.multi-select-placeholder {
    color: #9ca3af;
}

.multi-select-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: #fff;
    border: 1px solid #d1d5db;
    border-top: none;
    border-radius: 0 0 6px 6px;
    box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1);
    z-index: 1000;
    max-height: 200px;
    overflow-y: auto;
    display: none;
}

.multi-select-dropdown.show {
    display: block;
}

.multi-select-option {
    display: flex;
    align-items: center;
    padding: 8px 12px;
    cursor: pointer;
    transition: var(--transition-base);
}

.multi-select-option[style*="display: none"] {
    display: none !important;
}

.no-projects-message {
    padding: 12px;
    text-align: center;
    color: #6b7280;
    font-style: italic;
    font-size: 14px;
    border-top: 1px solid #e5e7eb;
    background: #f9fafb;
}

.multi-select-option:hover {
    background: #f3f4f6;
}

.multi-select-option input[type="checkbox"] {
    margin-right: 8px;
    width: 16px;
    height: 16px;
    accent-color: #3b82f6;
}

.multi-select-option label {
    cursor: pointer;
    font-size: 14px;
    color: #374151;
    flex: 1;
}

.selected-projects,
.selected-modules {
    margin-top: 8px;
    display: flex;
    flex-wrap: wrap;
    gap: 6px;
}

.project-badge {
    background: #3b82f6;
    color: #fff;
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 12px;
    display: flex;
    align-items: center;
    gap: 4px;
}

.project-badge-remove {
    background: rgba(255,255,255,0.3);
    border: none;
    color: #fff;
    cursor: pointer;
    border-radius: 50%;
    width: 16px;
    height: 16px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 10px;
}

.project-badge-remove:hover {
    background: rgba(255,255,255,0.5);
}

/* Field Error Styles */
.field-error {
    color: #ef4444;
    font-size: 12px;
    margin-top: 4px;
    margin-left: 4px;
}

/* Files List */
.files-list {
    margin-top: 8px;
}

.file-item {
    display: flex;
    align-items: center;
    gap: 8px;
    padding: 8px 12px;
    background: #f3f4f6;
    border-radius: 6px;
    margin-bottom: 6px;
    font-size: 12px;
    border: 1px solid #e5e7eb;
}

.file-item.pdf {
    background: #fef2f2;
    border-color: #fecaca;
}

.file-item img {
    width: 20px;
    height: 20px;
    object-fit: cover;
    border-radius: 3px;
}

.file-icon {
    width: 20px;
    height: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #ef4444;
    color: #fff;
    border-radius: 3px;
    font-size: 10px;
}

.file-name {
    flex: 1;
    color: #374151;
    font-weight: 500;
}

.file-size {
    color: #6b7280;
    font-size: 10px;
}

.file-remove {
    background: #ef4444;
    color: #fff;
    border: none;
    border-radius: 2px;
    padding: 2px 6px;
    font-size: 10px;
    cursor: pointer;
    transition: var(--transition-base);
}

.file-remove:hover {
    background: #dc2626;
}

/* Form Actions */
.form-actions {
    display: flex;
    gap: 12px;
    justify-content: center;
    padding-top: 24px;
    border-top: 1px solid #e5e7eb;
    margin-top: 24px;
}

/* Permission Styles */
.permission-module {
    margin-bottom: 20px;
    padding: 15px;
    border: 1px solid #e5e7eb;
    border-radius: 6px;
    background: #f9fafb;
}

.permission-module-title {
    font-weight: 600;
    color: #374151;
    margin-bottom: 10px;
    font-size: 14px;
}

.permission-options {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
}

.permission-option {
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    background: #fff;
    border: 1px solid #d1d5db;
    border-radius: 4px;
    cursor: pointer;
    transition: all 0.2s ease;
}

.permission-option:hover {
    background: #f3f4f6;
    border-color: #3b82f6;
}

.permission-option.selected {
    background: #3b82f6;
    color: #fff;
    border-color: #3b82f6;
}

.permission-option input[type="checkbox"] {
    margin: 0;
    width: 16px;
    height: 16px;
    accent-color: #3b82f6;
}

.permission-option label {
    cursor: pointer;
    font-size: 12px;
    margin: 0;
}

/* Responsive Design */
@media (max-width: 768px) {
    .main-content {
        padding: 20px 15px;
    }
    
    .header-content {
        padding: 0 15px;
    }
    
    .header-title {
        font-size: 24px;
    }
    
    .form-col-half,
    .form-col-third {
        min-width: 100%;
        flex: 100%;
    }
    
    .form-row {
        flex-direction: column;
    }
}

@media (max-width: 480px) {
    .main-content {
        padding: 15px 10px;
    }
    
    .form-container {
        padding: 20px;
    }
    
    .header-content {
        padding: 0 10px;
    }
    
    .header-title {
        font-size: 20px;
    }
    
    .btn-info {
        padding: 10px 16px;
        font-size: 14px;
    }
}

/* Success Modal Styles */
.success-modal-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 10000;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.success-modal-container {
    background: white;
    border-radius: 12px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
    max-width: 500px;
    width: 90%;
    max-height: 80vh;
    overflow: hidden;
    position: relative;
    transform: scale(0.9);
    transition: transform 0.3s ease;
}

.success-modal-overlay.show .success-modal-container {
    transform: scale(1);
}

.success-modal-header {
    background: #0055a5;
    padding: 20px 30px;
    text-align: center;
    border-radius: 12px 12px 0 0;
}

.success-title {
    color: white;
    font-size: 24px;
    font-weight: 700;
    margin: 0;
}

.success-modal-body {
    padding: 40px 30px;
    text-align: center;
}

.success-message {
    color: #333;
    font-size: 18px;
    font-weight: 500;
    margin: 0 0 30px 0;
}

.success-buttons {
    display: flex;
    gap: 15px;
    justify-content: center;
    flex-wrap: wrap;
}

.success-btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 24px;
    border: none;
    border-radius: 8px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    min-width: 160px;
    justify-content: center;
}

.success-btn.back-btn {
    background: #6c757d;
    color: white;
}

.success-btn.back-btn:hover {
    background: #5a6268;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(108, 117, 125, 0.3);
}

.success-btn.add-another-btn {
    background: #0055a5;
    color: white;
}

.success-btn.add-another-btn:hover {
    background: #003d7a;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 85, 165, 0.3);
}

/* Modal Responsive Styles */
@media (max-width: 768px) {
    .success-modal-container {
        width: 95%;
        margin: 10px;
    }
    
    .success-modal-header {
        padding: 15px 20px;
    }
    
    .success-title {
        font-size: 20px;
    }
    
    .success-modal-body {
        padding: 30px 20px;
    }
    
    .success-message {
        font-size: 16px;
    }
    
    .success-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .success-btn {
        width: 100%;
        max-width: 200px;
    }
}

/* SweetAlert2 Custom Styles */
.swal-success-btn {
    font-family: 'Jost', sans-serif !important;
    font-weight: 600 !important;
    padding: 12px 24px !important;
    border-radius: 8px !important;
    font-size: 15px !important;
}

.swal2-popup {
    font-family: 'Jost', sans-serif !important;
}
</style>

<script>
(function(){
    'use strict';
    const CONFIG = {
        selectors: {
            form: '#addUserForm',
            saveBtn: '#saveUserBtn',
            cancelBtn: '#cancelBtn',
            refreshBtn: '#refreshFormBtn',
            profileBtn: '#btnUploadProfile',
            profileInput: '#profilePicInput',
            profilePreview: '#profilePreview',
            profileImage: '#profileImage',
            removeProfile: '#removeProfile',
            medicalBtn: '#btnUploadMedical',
            medicalInput: '#medicalDocsInput',
            medicalFilesList: '#medicalFilesList',
            dlBtn: '#btnUploadDL',
            dlInput: '#dlDocsInput',
            dlFilesList: '#dlFilesList',
            drivingBtn: '#btnUploadDriving',
            drivingInput: '#drivingDocsInput',
            drivingFilesList: '#drivingFilesList',
            projectMultiSelect: '#projectMultiSelect',
            projectDropdown: '#projectDropdown',
            selectedProjects: '#selectedProjects',
            moduleMultiSelect: '#moduleMultiSelect',
            moduleDropdown: '#moduleDropdown',
            selectedModules: '#selectedModules',
            permissionsSection: '#permissionsSection',
            modulePermissionsContainer: '#modulePermissionsContainer',
            passwordToggle: '#passwordToggle',
            passwordInput: '#passwordInput',
            emailInput: '#emailInput'
        }
    };

    // Permission options matching the JS file
    const permissionOptions = [
        { label: 'All Permissions', value: 'all' },
        { label: 'Create', value: 'create' },
        { label: 'Edit', value: 'edit' },
        { label: 'Delete', value: 'delete' },
        { label: 'View', value: 'view' },
        { label: 'Update', value: 'update' },
        { label: 'Only Mine View', value: 'onlyMineView' },
    ];

    // Store module permissions
    let modulePermissions = {};

    function el(q) { return document.querySelector(q); }
    function getSelectValue(select) { return select?.value || ''; }
    
    function generateSourceKey() {
        return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
            const r = Math.random() * 16 | 0;
            const v = c == 'x' ? r : (r & 0x3 | 0x8);
            return v.toString(16);
        });
    }

    function init() {
        console.log('🚀 Initializing Add User page...');
        
        // Form submission
        const saveBtn = el(CONFIG.selectors.saveBtn);
        if (saveBtn) { 
            console.log('✅ Save button found, attaching click handler');
            saveBtn.addEventListener('click', saveUser); 
        } else {
            console.error('❌ Save button not found!');
        }

        // Cancel button
        const cancelBtn = el(CONFIG.selectors.cancelBtn);
        if (cancelBtn) { cancelBtn.addEventListener('click', () => window.location.href = '{{ route("users") }}'); }

        // Refresh form
        const refreshBtn = el(CONFIG.selectors.refreshBtn);
        if (refreshBtn) { refreshBtn.addEventListener('click', resetForm); }

        // Profile picture upload
        const pBtn = el(CONFIG.selectors.profileBtn), pInp = el(CONFIG.selectors.profileInput);
        if (pBtn && pInp) { pBtn.addEventListener('click', () => pInp.click()); }
        if (pInp) { pInp.addEventListener('change', handleProfileUpload); }

        // Remove profile picture
        const removeProfile = el(CONFIG.selectors.removeProfile);
        if (removeProfile) { removeProfile.addEventListener('click', removeProfilePicture); }

        // Medical docs upload
        const mBtn = el(CONFIG.selectors.medicalBtn), mInp = el(CONFIG.selectors.medicalInput);
        if (mBtn && mInp) { mBtn.addEventListener('click', () => mInp.click()); }
        if (mInp) { mInp.addEventListener('change', (e) => handleFileUpload(e, 'medical')); }

        // DL docs upload
        const dBtn = el(CONFIG.selectors.dlBtn), dInp = el(CONFIG.selectors.dlInput);
        if (dBtn && dInp) { dBtn.addEventListener('click', () => dInp.click()); }
        if (dInp) { dInp.addEventListener('change', (e) => handleFileUpload(e, 'dl')); }

        // Driving docs upload
        const drBtn = el(CONFIG.selectors.drivingBtn), drInp = el(CONFIG.selectors.drivingInput);
        if (drBtn && drInp) { drBtn.addEventListener('click', () => drInp.click()); }
        if (drInp) { drInp.addEventListener('change', (e) => handleFileUpload(e, 'driving')); }

        // Password toggle
        const passwordToggle = el(CONFIG.selectors.passwordToggle);
        if (passwordToggle) { passwordToggle.addEventListener('click', togglePasswordVisibility); }

        // Multi-select project dropdown
        const projectMultiSelect = el(CONFIG.selectors.projectMultiSelect);
        const projectDropdown = el(CONFIG.selectors.projectDropdown);
        if (projectMultiSelect && projectDropdown) {
            projectMultiSelect.addEventListener('click', toggleProjectDropdown);
            projectDropdown.addEventListener('change', handleProjectSelection);
        }

        // Multi-select module dropdown
        const moduleMultiSelect = el(CONFIG.selectors.moduleMultiSelect);
        const moduleDropdown = el(CONFIG.selectors.moduleDropdown);
        if (moduleMultiSelect && moduleDropdown) {
            moduleMultiSelect.addEventListener('click', toggleModuleDropdown);
            moduleDropdown.addEventListener('change', handleModuleSelection);
        }

        // Email validation
        const emailInput = el(CONFIG.selectors.emailInput);
        if (emailInput) { emailInput.addEventListener('blur', validateEmail); }

        // Password validation
        const passwordInput = el(CONFIG.selectors.passwordInput);
        if (passwordInput) { passwordInput.addEventListener('blur', validatePassword); }

        // Country selection change
        const countrySelect = el('#countriesSelect');
        if (countrySelect) {
            countrySelect.addEventListener('change', handleCountryChange);
        }

        // Initialize date pickers
        initializeDatePickers();

        // Close dropdown when clicking outside
        document.addEventListener('click', (e) => {
            const projectMultiSelect = el(CONFIG.selectors.projectMultiSelect);
            const projectDropdown = el(CONFIG.selectors.projectDropdown);
            const moduleMultiSelect = el(CONFIG.selectors.moduleMultiSelect);
            const moduleDropdown = el(CONFIG.selectors.moduleDropdown);
            
            if (projectMultiSelect && projectDropdown && 
                !projectMultiSelect.contains(e.target) && 
                !projectDropdown.contains(e.target)) {
                projectDropdown.classList.remove('show');
                projectMultiSelect.classList.remove('active');
            }
            
            if (moduleMultiSelect && moduleDropdown && 
                !moduleMultiSelect.contains(e.target) && 
                !moduleDropdown.contains(e.target)) {
                moduleDropdown.classList.remove('show');
                moduleMultiSelect.classList.remove('active');
            }
        });
    }

    async function saveUser() {
        console.log('🔘 Save User button clicked!');
        
        const form = el(CONFIG.selectors.form);
        if (!form) {
            console.error('❌ Form not found!');
            return;
        }
        
        console.log('✅ Form found, validating fields...');
        
        // Validate required fields
        const fullName = form.querySelector('input[name="fullName"]').value;
        const role = getSelectValue(el('#roleSelect'));
        const email = form.querySelector('input[name="email"]').value;
        const password = form.querySelector('input[name="password"]').value;
        const mobile = form.querySelector('input[name="mobile"]').value;
        const employeeNumber = form.querySelector('input[name="employeeNumber"]').value;
        const department = form.querySelector('input[name="department"]').value;
        const nrcId = form.querySelector('input[name="nrcId"]').value;
        const engagementDate = form.querySelector('input[name="engagementDate"]').value;
        const countries = getSelectValue(el('#countriesSelect'));
        const projects = getSelectedProjects();
        const modules = getSelectedModules();

        console.log('📝 Form Values:', {
            fullName, role, email, mobile, employeeNumber, department, 
            nrcId, engagementDate, countries, 
            projectsCount: projects.length, 
            modulesCount: modules.length
        });

        // Validation checks...
        if (!fullName.trim() || !role.trim() || !email.trim() || !password.trim() || 
            !mobile.trim() || !employeeNumber.trim() || !department.trim() || 
            !nrcId.trim() || !engagementDate.trim() || !countries.trim() || 
            projects.length === 0 || modules.length === 0) {
            console.error('❌ Validation failed - missing required fields');
            alert('Please fill all required fields.');
            return;
        }
        
        console.log('✅ All required fields validated');

        // Validate permissions
        console.log('🔑 Checking module permissions...', window.modulePermissions || modulePermissions);
        
        const hasValidPermissions = modules.every(module => {
            const perms = (window.modulePermissions || modulePermissions)[module];
            const isValid = perms && perms.length > 0;
            if (!isValid) {
                console.warn(`⚠️ Module ${module} has no permissions`);
            }
            return isValid;
        });
        
        if (!hasValidPermissions) {
            console.error('❌ Permission validation failed');
            alert('Please select permissions for all selected modules.');
            return;
        }
        
        console.log('✅ Permissions validated');

        // Validate email format
        if (!validateEmailFormat(email)) {
            console.error('❌ Email validation failed');
            alert('Please enter a valid email address.');
            return;
        }
        
        console.log('✅ Email validated');

        // Validate password strength
        if (!validatePasswordStrength(password)) {
            console.error('❌ Password strength validation failed');
            alert('Password must be 8-15 characters with at least one special character.');
            return;
        }
        
        console.log('✅ Password validated');

        // Show loading state
        const saveBtn = el(CONFIG.selectors.saveBtn);
        const originalText = saveBtn.innerHTML;
        saveBtn.disabled = true;
        saveBtn.innerHTML = '<i class="fas fa-spinner fa-spin" style="margin-right: 5px;"></i>Saving...';
        
        console.log('💾 Saving user data...');

        try {
            const fd = new FormData(form);
            const data = Object.fromEntries(fd.entries());
            
            // Transform data to match the desired JSON format
            const transformedData = {
                // Basic user info
                name: fullName,
                email: email,
                password: password,
                employeeNumber: employeeNumber,
                role: role,
                nrcIdNumber: nrcId,
                engagementDate: engagementDate,
                loginStatus: false,
                
                // Countries and projects as arrays
                countries: [countries],
                projects: projects,
                
                // Modules with permissions
                modules: modules.map(module => {
                    const permissions = modulePermissions[module] ? 
                        modulePermissions[module].filter(perm => perm !== 'all') : [];
                    return {
                        module: module,
                        ...(permissions.length > 0 && { permissions: permissions })
                    };
                }),
                
                // Medical information
                dateExamined: form.querySelector('input[name="medicalExamined"]').value || null,
                expiryMedicals: form.querySelector('input[name="medicalExpiry"]').value || null,
                
                // Driver's license
                driverLicenseNumber: form.querySelector('input[name="dlNumber"]').value || null,
                driverLicenseCode: form.querySelector('input[name="dlCode"]').value || null,
                driverLicenseExpiry: form.querySelector('input[name="dlExpiry"]').value || null,
                
                // Training dates
                clientDrivingDate: form.querySelector('input[name="clientDrivingDate"]').value || null,
                titanInductionDate: form.querySelector('input[name="titanInductionDate"]').value || null,
                dateCompletedFirstAid: form.querySelector('input[name="faDateCompleted"]').value || null,
                
                // Notifications (empty object for new user)
                notifications: {},
                
                // Source key for tracking
                sourceKey: generateSourceKey()
            };
            
            // Remove null values to clean up the data
            Object.keys(transformedData).forEach(key => {
                if (transformedData[key] === null || transformedData[key] === '') {
                    delete transformedData[key];
                }
            });
            
            console.log('=== FORM DATA BEING SAVED ===');
            
            // Check if in Edit Mode
            const isEditMode = window.editingUserId ? true : false;
            const userId = window.editingUserId;
            
            if (isEditMode) {
                console.log('Mode: UPDATE USER');
                console.log('User ID:', userId);
                console.log('MongoDB API: PUT /api/users/update/' + userId);
            } else {
                console.log('Mode: CREATE NEW USER');
                console.log('MongoDB API: POST /api/users/save');
            }
            console.log('Transformed Data:', transformedData);
            console.log('=============================');
            
            // Determine API endpoint and method
            const apiUrl = isEditMode ? `/api/users/update/${userId}` : '/api/users/save';
            const apiMethod = isEditMode ? 'PUT' : 'POST';
            
            console.log('📡 API Call:', { url: apiUrl, method: apiMethod, data: transformedData });
            
            // Send to MongoDB API
            const response = await fetch(apiUrl, {
                method: apiMethod,
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
                },
                body: JSON.stringify(transformedData)
            });
            
            console.log('📥 API Response Status:', response.status);
            
            const result = await response.json();
            console.log('📥 API Response Data:', result);
            
            if (result.success) {
                if (isEditMode) {
                    console.log('✅ User updated successfully');
                    // Show beautiful success modal for update
                    Swal.fire({
                        icon: 'success',
                        title: '<div style="color: #16a34a; font-weight: 700;">✅ User Updated Successfully!</div>',
                        html: `
                            <div style="font-family: 'Jost', sans-serif; padding: 20px;">
                                <div style="background: linear-gradient(135deg, #dcfce7, #bbf7d0); border-radius: 12px; padding: 20px; margin-bottom: 15px;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="#16a34a" stroke-width="2" style="margin-bottom: 10px;">
                                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                                        <circle cx="12" cy="7" r="4"></circle>
                                    </svg>
                                    <h3 style="color: #166534; margin: 10px 0; font-size: 20px; font-weight: 700;">${fullName}</h3>
                                    <p style="color: #15803d; margin: 0; font-size: 14px;">${email}</p>
                                </div>
                                <p style="color: #1a202c; font-size: 16px; margin: 0;">
                                    All user information has been successfully updated in MongoDB.
                                </p>
                            </div>
                        `,
                        confirmButtonText: '<i class="fas fa-arrow-left" style="margin-right: 8px;"></i>Back to Users List',
                        confirmButtonColor: '#0055a5',
                        allowOutsideClick: false,
                        customClass: {
                            confirmButton: 'swal-success-btn'
                        }
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Redirect back to users list
                            window.location.href = '{{ route("users") }}';
                        }
                    });
                } else {
                    console.log('✅ User created successfully');
                    // Show success modal for new user
                    showSuccessModal({
                        uid: result.userId,
                        email: email,
                        name: fullName
                    });
                }
            } else {
                console.error('❌ API Error:', result.message);
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: `Error ${isEditMode ? 'updating' : 'creating'} user: ` + result.message,
                    confirmButtonColor: '#0055a5'
                });
            }
        } catch (error) {
            console.error('❌ Error saving user:', error);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Error saving user. Please try again: ' + error.message,
                confirmButtonColor: '#0055a5'
            });
        } finally {
            // Reset button state
            console.log('🔄 Resetting button state');
            saveBtn.disabled = false;
            saveBtn.innerHTML = originalText;
        }
    }

    function resetForm() {
        const form = el(CONFIG.selectors.form);
        if (form) {
            form.reset();
            modulePermissions = {};
            updatePermissionsSection();
            removeProfilePicture();
            clearFileLists();
            
            // Clear project selection and hide all projects
            updateSelectedProjects();
            filterProjectsByCountry('');
            
            // Disable project selection
            const projectMultiSelect = el(CONFIG.selectors.projectMultiSelect);
            if (projectMultiSelect) {
                projectMultiSelect.classList.add('disabled');
                projectMultiSelect.querySelector('.multi-select-placeholder').textContent = 'Select Country First';
            }
            
            // Clear module selection
            updateSelectedModules();
            
            // Close dropdowns
            const projectDropdown = el(CONFIG.selectors.projectDropdown);
            const moduleDropdown = el(CONFIG.selectors.moduleDropdown);
            const moduleMultiSelect = el(CONFIG.selectors.moduleMultiSelect);
            
            if (projectDropdown) projectDropdown.classList.remove('show');
            if (projectMultiSelect) projectMultiSelect.classList.remove('active');
            if (moduleDropdown) moduleDropdown.classList.remove('show');
            if (moduleMultiSelect) moduleMultiSelect.classList.remove('active');
        }
    }

    function handleProfileUpload(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = el(CONFIG.selectors.profilePreview);
                const image = el(CONFIG.selectors.profileImage);
                if (preview && image) {
                    image.src = e.target.result;
                    preview.style.display = 'flex';
                }
            };
            reader.readAsDataURL(file);
        }
    }

    function removeProfilePicture() {
        const preview = el(CONFIG.selectors.profilePreview);
        const input = el(CONFIG.selectors.profileInput);
        if (preview) preview.style.display = 'none';
        if (input) input.value = '';
    }

    function handleFileUpload(e, type) {
        const files = Array.from(e.target.files);
        const filesList = el(CONFIG.selectors[type + 'FilesList']);
        if (!filesList) return;

        files.forEach(file => {
            // Validate file type
            const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'application/pdf'];
            if (!allowedTypes.includes(file.type)) {
                alert(`File ${file.name} is not supported. Please upload JPG, PNG, or PDF files only.`);
                return;
            }

            // Validate file size (5MB limit)
            const maxSize = 5 * 1024 * 1024; // 5MB
            if (file.size > maxSize) {
                alert(`File ${file.name} is too large. Please upload files smaller than 5MB.`);
                return;
            }

            const fileItem = document.createElement('div');
            const isPDF = file.type === 'application/pdf';
            fileItem.className = `file-item ${isPDF ? 'pdf' : ''}`;
            
            const fileSize = (file.size / 1024).toFixed(1) + ' KB';
            
            fileItem.innerHTML = `
                ${isPDF ? 
                    '<div class="file-icon">PDF</div>' : 
                    '<img src="' + URL.createObjectURL(file) + '" alt="Preview">'
                }
                <div class="file-name">${file.name}</div>
                <div class="file-size">${fileSize}</div>
                <button type="button" class="file-remove" onclick="this.parentElement.remove()">Remove</button>
            `;
            filesList.appendChild(fileItem);
        });
    }

    function clearFileLists() {
        const medicalList = el(CONFIG.selectors.medicalFilesList);
        const dlList = el(CONFIG.selectors.dlFilesList);
        const drivingList = el(CONFIG.selectors.drivingFilesList);
        if (medicalList) medicalList.innerHTML = '';
        if (dlList) dlList.innerHTML = '';
        if (drivingList) drivingList.innerHTML = '';
    }

    // Country change handler
    function handleCountryChange() {
        const selectedCountry = getSelectValue(el('#countriesSelect'));
        const projectMultiSelect = el(CONFIG.selectors.projectMultiSelect);
        
        if (selectedCountry) {
            // Enable project selection
            projectMultiSelect.classList.remove('disabled');
            projectMultiSelect.querySelector('.multi-select-placeholder').textContent = 'Select Projects';
            filterProjectsByCountry(selectedCountry);
        } else {
            // Disable project selection
            projectMultiSelect.classList.add('disabled');
            projectMultiSelect.querySelector('.multi-select-placeholder').textContent = 'Select Country First';
            filterProjectsByCountry('');
        }
    }

    function filterProjectsByCountry(selectedCountry) {
        const projectOptions = document.querySelectorAll('#projectDropdown .multi-select-option');
        let hasVisibleProjects = false;
        
        projectOptions.forEach(option => {
            const projectCountry = option.getAttribute('data-country');
            const checkbox = option.querySelector('input[type="checkbox"]');
            
            if (!selectedCountry) {
                // If no country selected, hide all projects
                option.style.display = 'none';
                checkbox.checked = false;
            } else if (projectCountry === selectedCountry) {
                // Show projects for selected country
                option.style.display = 'flex';
                hasVisibleProjects = true;
            } else {
                // Hide projects for non-selected countries
                option.style.display = 'none';
                checkbox.checked = false;
            }
        });
        
        // Show/hide no projects message
        let noProjectsMsg = document.getElementById('noProjectsMessage');
        if (selectedCountry && !hasVisibleProjects) {
            if (!noProjectsMsg) {
                noProjectsMsg = document.createElement('div');
                noProjectsMsg.id = 'noProjectsMessage';
                noProjectsMsg.className = 'no-projects-message';
                noProjectsMsg.textContent = 'No projects available for the selected country';
                document.getElementById('projectDropdown').appendChild(noProjectsMsg);
            }
            noProjectsMsg.style.display = 'block';
        } else if (noProjectsMsg) {
            noProjectsMsg.style.display = 'none';
        }
        
        // Update project selection display
        updateSelectedProjects();
    }

    // Password visibility toggle
    function togglePasswordVisibility() {
        const passwordInput = el(CONFIG.selectors.passwordInput);
        const passwordToggle = el(CONFIG.selectors.passwordToggle);
        if (passwordInput && passwordToggle) {
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                passwordToggle.innerHTML = `
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M17.94 17.94A10.07 10.07 0 0 1 12 20c-7 0-11-8-11-8a18.45 18.45 0 0 1 5.06-5.94M9.9 4.24A9.12 9.12 0 0 1 12 4c7 0 11 8 11 8a18.5 18.5 0 0 1-2.16 3.19m-6.72-1.07a3 3 0 1 1-4.24-4.24"></path>
                        <line x1="1" y1="1" x2="23" y2="23"></line>
                    </svg>
                `;
            } else {
                passwordInput.type = 'password';
                passwordToggle.innerHTML = `
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M1 12s4-8 7-8 7 8 7 8-4 8-7 8-7-8-7-8z"></path>
                        <circle cx="12" cy="12" r="3"></circle>
                    </svg>
                `;
            }
        }
    }

    // Multi-select project functionality
    function toggleProjectDropdown() {
        const dropdown = el(CONFIG.selectors.projectDropdown);
        const multiSelect = el(CONFIG.selectors.projectMultiSelect);
        
        // Don't open if disabled
        if (multiSelect && multiSelect.classList.contains('disabled')) {
            return;
        }
        
        if (dropdown && multiSelect) {
            dropdown.classList.toggle('show');
            multiSelect.classList.toggle('active');
        }
    }

    function handleProjectSelection(event) {
        if (event.target.type === 'checkbox') {
            updateSelectedProjects();
        }
    }

    function getSelectedProjects() {
        const checkboxes = document.querySelectorAll('#projectDropdown input[type="checkbox"]:checked');
        return Array.from(checkboxes).map(cb => cb.value);
    }

    function updateSelectedProjects() {
        const selectedProjects = getSelectedProjects();
        const container = el(CONFIG.selectors.selectedProjects);
        const multiSelect = el(CONFIG.selectors.projectMultiSelect);
        const placeholder = multiSelect.querySelector('.multi-select-placeholder');
        
        if (container && multiSelect && placeholder) {
            container.innerHTML = '';
            
            if (selectedProjects.length > 0) {
                placeholder.textContent = `${selectedProjects.length} project(s) selected`;
                selectedProjects.forEach(project => {
                    const badge = document.createElement('div');
                    badge.className = 'project-badge';
                    badge.innerHTML = `
                        ${project}
                        <button type="button" class="project-badge-remove" onclick="removeProject('${project}')">×</button>
                    `;
                    container.appendChild(badge);
                });
            } else {
                placeholder.textContent = 'Select Projects';
            }
        }
    }

    function removeProject(projectName) {
        const checkbox = document.querySelector(`#projectDropdown input[value="${projectName}"]`);
        if (checkbox) {
            checkbox.checked = false;
            updateSelectedProjects();
        }
    }

    // Multi-select module functionality
    function toggleModuleDropdown() {
        const dropdown = el(CONFIG.selectors.moduleDropdown);
        const multiSelect = el(CONFIG.selectors.moduleMultiSelect);
        if (dropdown && multiSelect) {
            dropdown.classList.toggle('show');
            multiSelect.classList.toggle('active');
        }
    }

    function handleModuleSelection(event) {
        if (event.target.type === 'checkbox') {
            updateSelectedModules();
            updatePermissionsSection();
        }
    }

    function getSelectedModules() {
        const checkboxes = document.querySelectorAll('#moduleDropdown input[type="checkbox"]:checked');
        return Array.from(checkboxes).map(cb => cb.value);
    }

    function updateSelectedModules() {
        const selectedModules = getSelectedModules();
        const container = el(CONFIG.selectors.selectedModules);
        const multiSelect = el(CONFIG.selectors.moduleMultiSelect);
        const placeholder = multiSelect.querySelector('.multi-select-placeholder');
        
        if (container && multiSelect && placeholder) {
            container.innerHTML = '';
            
            if (selectedModules.length > 0) {
                placeholder.textContent = `${selectedModules.length} module(s) selected`;
                selectedModules.forEach(module => {
                    const badge = document.createElement('div');
                    badge.className = 'project-badge';
                    badge.innerHTML = `
                        ${module}
                        <button type="button" class="project-badge-remove" onclick="removeModule('${module}')">×</button>
                    `;
                    container.appendChild(badge);
                });
            } else {
                placeholder.textContent = 'Select Modules';
            }
        }
    }

    function removeModule(moduleName) {
        const checkbox = document.querySelector(`#moduleDropdown input[value="${moduleName}"]`);
        if (checkbox) {
            checkbox.checked = false;
            updateSelectedModules();
            updatePermissionsSection();
        }
    }

    function updatePermissionsSection() {
        const selectedModules = getSelectedModules();
        const permissionsSection = el(CONFIG.selectors.permissionsSection);
        const container = el(CONFIG.selectors.modulePermissionsContainer);
        
        if (selectedModules.length === 0) {
            permissionsSection.style.display = 'none';
            return;
        }
        
        permissionsSection.style.display = 'block';
        container.innerHTML = '';
        
        selectedModules.forEach(module => {
            if (!modulePermissions[module]) {
                modulePermissions[module] = [];
            }
            
            const moduleDiv = document.createElement('div');
            moduleDiv.className = 'permission-module';
            moduleDiv.innerHTML = `
                <div class="permission-module-title">Permissions for ${module} <span class="required">*</span></div>
                <div class="permission-options" id="permissions-${module}">
                    ${permissionOptions.map(option => `
                        <div class="permission-option ${modulePermissions[module].includes(option.value) ? 'selected' : ''}" 
                             data-value="${option.value}" data-module="${module}">
                            <input type="checkbox" id="perm-${module}-${option.value}" 
                                   value="${option.value}" 
                                   ${modulePermissions[module].includes(option.value) ? 'checked' : ''}>
                            <label for="perm-${module}-${option.value}">${option.label}</label>
                        </div>
                    `).join('')}
                </div>
            `;
            container.appendChild(moduleDiv);
        });
        
        // Add event listeners for permission changes
        container.addEventListener('change', handlePermissionChange);
        container.addEventListener('click', handlePermissionClick);
    }

    function handlePermissionChange(event) {
        if (event.target.type === 'checkbox') {
            const module = event.target.closest('.permission-module').querySelector('.permission-module-title').textContent.split(' ')[2];
            const value = event.target.value;
            const isChecked = event.target.checked;
            
            if (!modulePermissions[module]) {
                modulePermissions[module] = [];
            }
            
            if (isChecked) {
                if (!modulePermissions[module].includes(value)) {
                    modulePermissions[module].push(value);
                }
            } else {
                modulePermissions[module] = modulePermissions[module].filter(p => p !== value);
            }
            
            // Handle "All Permissions" logic
            if (value === 'all' && isChecked) {
                const individualPermissions = ['create', 'edit', 'delete', 'view', 'update', 'onlyMineView'];
                modulePermissions[module] = ['all', ...individualPermissions];
                updatePermissionUI(module);
            } else if (value === 'all' && !isChecked) {
                modulePermissions[module] = [];
                updatePermissionUI(module);
            }
        }
    }

    function handlePermissionClick(event) {
        if (event.target.closest('.permission-option')) {
            const option = event.target.closest('.permission-option');
            const checkbox = option.querySelector('input[type="checkbox"]');
            checkbox.checked = !checkbox.checked;
            checkbox.dispatchEvent(new Event('change'));
        }
    }

    function updatePermissionUI(module) {
        const moduleDiv = document.querySelector(`#permissions-${module}`);
        if (!moduleDiv) return;
        
        const options = moduleDiv.querySelectorAll('.permission-option');
        options.forEach(option => {
            const value = option.dataset.value;
            const checkbox = option.querySelector('input[type="checkbox"]');
            const isSelected = modulePermissions[module].includes(value);
            
            checkbox.checked = isSelected;
            option.classList.toggle('selected', isSelected);
        });
    }

    // Email validation
    function validateEmail() {
        const emailInput = el(CONFIG.selectors.emailInput);
        if (emailInput) {
            const email = emailInput.value.trim();
            const isValid = validateEmailFormat(email);
            
            if (email && !isValid) {
                emailInput.style.borderColor = '#ef4444';
                showFieldError(emailInput, 'Please enter a valid email address');
            } else {
                emailInput.style.borderColor = '#d1d5db';
                hideFieldError(emailInput);
            }
        }
    }

    function validateEmailFormat(email) {
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailRegex.test(email) && email.length <= 40;
    }

    // Password validation
    function validatePassword() {
        const passwordInput = el(CONFIG.selectors.passwordInput);
        if (passwordInput) {
            const password = passwordInput.value;
            const isValid = validatePasswordStrength(password);
            
            if (password && !isValid) {
                passwordInput.style.borderColor = '#ef4444';
                showFieldError(passwordInput, 'Password must be 8-15 characters with at least one special character');
            } else {
                passwordInput.style.borderColor = '#d1d5db';
                hideFieldError(passwordInput);
            }
        }
    }

    function validatePasswordStrength(password) {
        const hasMinLength = password.length >= 8;
        const hasMaxLength = password.length <= 15;
        const hasSpecialChar = /[!@#$%^&*(),.?":{}|<>]/.test(password);
        return hasMinLength && hasMaxLength && hasSpecialChar;
    }

    function showFieldError(field, message) {
        hideFieldError(field);
        const errorDiv = document.createElement('div');
        errorDiv.className = 'field-error';
        errorDiv.textContent = message;
        errorDiv.style.color = '#ef4444';
        errorDiv.style.fontSize = '12px';
        errorDiv.style.marginTop = '4px';
        field.parentNode.appendChild(errorDiv);
    }

    function hideFieldError(field) {
        const existingError = field.parentNode.querySelector('.field-error');
        if (existingError) {
            existingError.remove();
        }
    }

    function initializeDatePickers() {
        // Set default date attributes
        const today = new Date().toISOString().split('T')[0];
        const oneYearFromNow = new Date();
        oneYearFromNow.setFullYear(oneYearFromNow.getFullYear() + 1);
        const oneYearFromNowStr = oneYearFromNow.toISOString().split('T')[0];
        
        // Set max date to today for past dates
        const pastDateFields = ['engagementDate', 'titanInductionDate', 'clientInductionDate', 'medicalExamined', 'clientDrivingDate', 'faDateCompleted'];
        pastDateFields.forEach(fieldId => {
            const field = el('#' + fieldId);
            if (field) {
                field.setAttribute('max', today);
            }
        });
        
        // Set min date to today for future dates
        const futureDateFields = ['medicalExpiry', 'dlExpiry', 'faExpiryDate'];
        futureDateFields.forEach(fieldId => {
            const field = el('#' + fieldId);
            if (field) {
                field.setAttribute('min', today);
            }
        });
        
        // Add date validation
        const allDateFields = document.querySelectorAll('.datepicker');
        allDateFields.forEach(field => {
            field.addEventListener('change', validateDateField);
        });
    }

    function validateDateField(event) {
        const field = event.target;
        const fieldName = field.name;
        const selectedDate = new Date(field.value);
        const today = new Date();
        today.setHours(0, 0, 0, 0);
        
        // Remove any existing error styling
        field.style.borderColor = '#d1d5db';
        
        // Past date fields validation
        const pastDateFields = ['engagementDate', 'titanInductionDate', 'clientInductionDate', 'medicalExamined', 'clientDrivingDate', 'faDateCompleted'];
        if (pastDateFields.includes(fieldName) && selectedDate > today) {
            field.style.borderColor = '#ef4444';
            alert(`${fieldName.replace(/([A-Z])/g, ' $1').toLowerCase()} cannot be in the future.`);
            field.value = '';
            return;
        }
        
        // Future date fields validation
        const futureDateFields = ['medicalExpiry', 'dlExpiry', 'faExpiryDate'];
        if (futureDateFields.includes(fieldName) && selectedDate < today) {
            field.style.borderColor = '#ef4444';
            alert(`${fieldName.replace(/([A-Z])/g, ' $1').toLowerCase()} cannot be in the past.`);
            field.value = '';
            return;
        }
        
        // Medical expiry should be after medical examined date
        if (fieldName === 'medicalExpiry') {
            const medicalExaminedField = el('#medicalExamined');
            if (medicalExaminedField && medicalExaminedField.value) {
                const examinedDate = new Date(medicalExaminedField.value);
                if (selectedDate <= examinedDate) {
                    field.style.borderColor = '#ef4444';
                    alert('Medical expiry date must be after the examination date.');
                    field.value = '';
                    return;
                }
            }
        }
        
        // DL expiry should be after today (for new licenses)
        if (fieldName === 'dlExpiry') {
            const oneYearFromNow = new Date();
            oneYearFromNow.setFullYear(oneYearFromNow.getFullYear() + 1);
            if (selectedDate < oneYearFromNow) {
                field.style.borderColor = '#ef4444';
                alert('Driver\'s license expiry should be at least one year from now.');
                field.value = '';
                return;
            }
        }
        
        // First aid expiry should be after completion date
        if (fieldName === 'faExpiryDate') {
            const faCompletedField = el('#faDateCompleted');
            if (faCompletedField && faCompletedField.value) {
                const completedDate = new Date(faCompletedField.value);
                if (selectedDate <= completedDate) {
                    field.style.borderColor = '#ef4444';
                    alert('First aid expiry date must be after the completion date.');
                    field.value = '';
                    return;
                }
            }
        }
    }

    // Success Modal Functions
    function showSuccessModal(data) {
        const modal = document.getElementById('successModal');
        if (modal) {
            // Show modal with animation
            modal.style.display = 'flex';
            modal.style.opacity = '0';
            
            // Fade in the modal
            setTimeout(() => {
                modal.style.opacity = '1';
                modal.classList.add('show');
            }, 10);
        }
    }

    function hideSuccessModal() {
        const modal = document.getElementById('successModal');
        if (modal) {
            modal.style.opacity = '0';
            modal.classList.remove('show');
            
            setTimeout(() => {
                modal.style.display = 'none';
            }, 300);
        }
    }

    function goBackToUsers() {
        window.location.href = '{{ route("users") }}';
    }

    function addAnotherUser() {
        hideSuccessModal();
        resetForm();
    }

    // Close modal when clicking outside
    document.addEventListener('click', (e) => {
        const modal = document.getElementById('successModal');
        if (e.target === modal) {
            hideSuccessModal();
        }
    });

    // Check if page is in Edit Mode
    async function checkEditMode() {
        const urlParams = new URLSearchParams(window.location.search);
        const isEditMode = urlParams.get('edit') === 'true';
        const userId = urlParams.get('userId');
        
        if (isEditMode && userId) {
            console.log('🔧 Edit mode detected for user:', userId);
            
            // Update page title and header
            document.title = 'Edit User - Titan Drilling';
            
            const headerTitle = document.querySelector('.header-title');
            if (headerTitle) {
                headerTitle.innerHTML = '<i class="fas fa-edit" style="margin-right: 10px;"></i>Edit User';
            }
            
            const infoBanner = document.querySelector('.info-banner span');
            if (infoBanner) {
                infoBanner.innerHTML = '<i class="fas fa-pencil-alt" style="margin-right: 5px;"></i>Update the form below to modify user details';
            }
            
            // Update save button text
            const saveBtn = document.getElementById('saveUserBtn');
            if (saveBtn) {
                saveBtn.innerHTML = '<i class="fas fa-save" style="margin-right: 5px;"></i>Update User';
            }
            
            // Load user data from MongoDB
            await loadUserDataForEdit(userId);
        }
    }
    
    // Load user data for editing
    async function loadUserDataForEdit(userId) {
        try {
            console.log('📥 Loading user data for editing:', userId);
            
            const response = await fetch(`/api/users/get/${userId}`);
            const result = await response.json();
            
            if (result.success && result.data) {
                const user = result.data;
                console.log('✅ User data loaded:', user);
                
                // Store userId for update operation
                window.editingUserId = userId;
                
                // Fill form fields
                const form = document.getElementById('addUserForm');
                if (!form) return;
                
                // Helper function to format date for input fields
                const formatDate = (dateString) => {
                    if (!dateString) return '';
                    try {
                        const date = new Date(dateString);
                        const year = date.getFullYear();
                        const month = String(date.getMonth() + 1).padStart(2, '0');
                        const day = String(date.getDate()).padStart(2, '0');
                        return `${year}-${month}-${day}`;
                    } catch (e) {
                        return '';
                    }
                };
                
                // All form fields with proper date formatting
                const fields = {
                    // Basic Info
                    'fullName': user.name,
                    'email': user.email,
                    'password': user.password,
                    'mobile': user.mobile,
                    'employeeNumber': user.employeeNumber,
                    'department': user.department,
                    'nrcId': user.nrcIdNumber,
                    'engagementDate': formatDate(user.engagementDate),
                    'titanInductionDate': formatDate(user.titanInductionDate),
                    'clientInductionDate': formatDate(user.clientInduction),
                    // Medical Data
                    'medicalExamined': formatDate(user.dateExamined),
                    'medicalExpiry': formatDate(user.expiryMedicals),
                    // Driver's License
                    'dlNumber': user.driverLicenseNumber,
                    'dlCode': user.driverLicenseCode,
                    'dlExpiry': formatDate(user.driverLicenseExpiry),
                    'clientDrivingDate': formatDate(user.clientDrivingDate),
                    // First Aid
                    'faDateCompleted': formatDate(user.dateCompletedFirstAid),
                    'faLevel': user.levelFirstAid,
                    'faExpiryDate': formatDate(user.expiryDateFirstAid)
                };
                
                // Fill each field
                Object.keys(fields).forEach(fieldName => {
                    const input = form.querySelector(`[name="${fieldName}"]`);
                    if (input && fields[fieldName]) {
                        input.value = fields[fieldName];
                        console.log(`✓ Filled ${fieldName}:`, fields[fieldName]);
                    }
                });
                
                // Set role
                const roleSelect = form.querySelector('[name="role"]');
                if (roleSelect && user.role) {
                    roleSelect.value = user.role;
                }
                
                // Set countries (multi-select)
                if (user.countries && Array.isArray(user.countries)) {
                    window.preSelectedCountries = user.countries;
                    setTimeout(() => {
                        user.countries.forEach(country => {
                            const countryOption = form.querySelector(`[name="countries[]"] option[value="${country}"]`);
                            if (countryOption) {
                                countryOption.selected = true;
                            }
                        });
                        // Trigger change event to load projects
                        const countriesSelect = form.querySelector('[name="countries[]"]');
                        if (countriesSelect) {
                            countriesSelect.dispatchEvent(new Event('change'));
                        }
                    }, 500);
                }
                
                // Set projects (multi-select)
                if (user.projects && Array.isArray(user.projects)) {
                    window.preSelectedProjects = user.projects;
                    setTimeout(() => {
                        user.projects.forEach(project => {
                            const projectCheckbox = form.querySelector(`input[type="checkbox"][value="${project}"]`);
                            if (projectCheckbox) {
                                projectCheckbox.checked = true;
                            }
                        });
                    }, 1000);
                }
                
                // Set modules with permissions
                if (user.modules && Array.isArray(user.modules)) {
                    // Reset modulePermissions object
                    window.modulePermissions = {};
                    
                    setTimeout(() => {
                        user.modules.forEach(module => {
                            const moduleName = module.module || module;
                            const moduleCheckbox = form.querySelector(`input[type="checkbox"][value="${moduleName}"]`);
                            if (moduleCheckbox) {
                                moduleCheckbox.checked = true;
                                
                                // Store permissions for this module
                                if (module.permissions && Array.isArray(module.permissions)) {
                                    window.modulePermissions[moduleName] = module.permissions;
                                }
                            }
                        });
                        
                        // Update permissions section to show loaded permissions
                        if (typeof updatePermissionsSection === 'function') {
                            updatePermissionsSection();
                        }
                        
                        // Update selected modules display
                        if (typeof updateSelectedModules === 'function') {
                            updateSelectedModules();
                        }
                    }, 1200);
                }
                
                console.log('✅ Form populated with user data');
                
            } else {
                console.error('❌ Failed to load user data');
                alert('Failed to load user data for editing');
            }
            
        } catch (error) {
            console.error('❌ Error loading user data:', error);
            alert('Error loading user data: ' + error.message);
        }
    }

    document.addEventListener('DOMContentLoaded', function() {
        init();
        checkEditMode();
    });
})();
</script>

<!-- Firebase SDK -->
<script src="https://www.gstatic.com/firebasejs/9.22.0/firebase-app-compat.js"></script>
<script src="https://www.gstatic.com/firebasejs/9.22.0/firebase-auth-compat.js"></script>
<script src="https://www.gstatic.com/firebasejs/9.22.0/firebase-database-compat.js"></script>

<script>
// Firebase configuration
const firebaseConfig = {
    apiKey: "AIzaSyDsA1JohORkg-EdXWTHlFEea8zCqfvig8w",
    authDomain: "titan-drilling-1f8e9.firebaseapp.com",
    databaseURL: "https://titan-drilling-1f8e9-default-rtdb.firebaseio.com",
    projectId: "titan-drilling-1f8e9",
    storageBucket: "titan-drilling-1f8e9.appspot.com",
    messagingSenderId: "749788854975",
    appId: "1:749788854975:web:your-app-id"
};

// Initialize Firebase
firebase.initializeApp(firebaseConfig);
const auth = firebase.auth();
const database = firebase.database();

console.log('Firebase initialized for user management');
</script>
@endsection
