<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if admin user already exists
        $adminExists = User::where('email', 'admin@titandrilling.com')->exists();
        
        if (!$adminExists) {
            User::create([
                'name' => 'Admin User',
                'email' => 'admin@titandrilling.com',
                'password' => Hash::make('TitanAdmin2024!@#$%^&*'),
                'role' => 'admin',
                'email_verified_at' => now()
            ]);
            
            $this->command->info('Admin user created successfully!');
            $this->command->info('Email: admin@titandrilling.com');
            $this->command->info('Password: TitanAdmin2024!@#$%^&*');
        } else {
            $this->command->info('Admin user already exists.');
        }
    }
}
